#import "RSMNewFolderHelper.h"

@implementation RSMNewFolderHelper

/*
 * NSControl delegate methods
 */
- ( void )controlTextDidChange: ( NSNotification * )notification
{
    if ( [[ notification object ] isEqual: rsmNewFolderNameField ] ) {
        NSString        *infoString = @"";
        
        if ( [[ rsmNewFolderNameField stringValue ] length ] ) {
	    [ rsmNewFolderButton setEnabled: YES ];
	    infoString = [ NSString stringWithFormat:
			NSLocalizedString( @"A new folder will be created at %@/%@",
			    @"A new folder will be created at %@/%@" ),
			    [ self basePath ], [ rsmNewFolderNameField stringValue ]];
        } else {
	    [ rsmNewFolderButton setEnabled: NO ];
	}
        
        [ rsmNewFolderPathField setStringValue: infoString ];
    }
}
/* end NSControl delegate methods */

- ( id )init
{
    self = [ super init ];
    
    _rsmNewFolderHelperDelegate = nil;
    _rsmNewFolderHelperBasePath = nil;
    
    return( self );
}

- ( void )setDelegate: ( id )delegate
{
    _rsmNewFolderHelperDelegate = delegate;
}

- ( id )delegate
{
    return( _rsmNewFolderHelperDelegate );
}

- ( void )setBasePath: ( NSString * )basePath
{
    if ( _rsmNewFolderHelperBasePath != nil ) {
	[ _rsmNewFolderHelperBasePath release ];
	_rsmNewFolderHelperBasePath = nil;
    }
    _rsmNewFolderHelperBasePath = [ basePath retain ];
}

- ( NSString * )basePath
{
    return( _rsmNewFolderHelperBasePath );
}

- ( void )displayNewFolderSheetForWindow: ( NSWindow * )window
	    basePath: ( NSString * )basePath
	    delegate: ( id )delegate
{
    if ( window == nil || basePath == nil || delegate == nil ) {
	return;
    }
    
    [ self setDelegate: delegate ];
    [ self setBasePath: basePath ];
    
    [ NSApp beginSheet: rsmNewFolderSheet
	    modalForWindow: window
	    modalDelegate: self
	    didEndSelector: NULL
	    contextInfo: nil ];
}

- ( IBAction )createNewFolder: ( id )sender
{
    [ self dismissNewFolderSheet: self ];
    [[ self delegate ] folderHelperCreateFolderAtPath:
	    [ NSString stringWithFormat: @"%@/%@",
	    [ self basePath ],
	    [ rsmNewFolderNameField stringValue ]]];
}

- ( IBAction )dismissNewFolderSheet: ( id )sender
{
    [ rsmNewFolderSheet orderOut: nil ];
    [ NSApp endSheet: rsmNewFolderSheet ];
}

@end
