#import <Cocoa/Cocoa.h>

#import "RSMLogger.h"
#import "RSMNewFolderHelper.h"

@class RAServerAuth;
@class RASTableView;
@class RAOutlineView;
@class RSMLoadsetEditor;

/* convenience macro for outline view datasource methods */
#define GET_NODE_CHILDREN(j,n,m)    NSMutableArray *children = nil; \
if ( n && m ) { \
    NSString	*_gncStr = nil; \
    int		_gnci; \
								\
    children = [[ NSMutableArray alloc ] init ]; \
								\
    for ( _gnci = j; _gnci < [ m count ]; _gnci++ ) { \
	_gncStr = [[ m objectAtIndex: _gnci ] \
		    objectForKey: @"RadmindServerItemParent" ]; \
	if ( [ _gncStr isEqualToString: [ n objectForKey: \
		    @"RadmindServerItemPath" ]] ) { \
	    [ children addObject: [ m objectAtIndex: _gnci ]]; \
	} \
    } \
    [ children autorelease ]; \
}
/* end GET_NODE_CHILDREN(n) macro */

@interface RSMLoadsetManager : NSObject
{
    IBOutlet NSWindow		*transcriptWindow;
    IBOutlet RAOutlineView 	*tmpTranscriptTable;
    IBOutlet NSBox		*tmpTranscriptBox;
    IBOutlet NSMenu		*tmpTableMenu;
    IBOutlet RAOutlineView 	*transcriptTable;
    IBOutlet NSBox		*transcriptBox;
    IBOutlet NSMenu		*transcriptTableMenu;
    
    IBOutlet NSProgressIndicator	*progBar;
    IBOutlet NSPanel		*progSheet;
    IBOutlet NSTextField	*progMessage;
    IBOutlet NSBox		*toolProgressDetailsBox;
    IBOutlet NSTextView		*toolProgressDetailsTextView;
    IBOutlet NSView		*toolProgressDetailsView;
    
    IBOutlet NSPanel		*mergeSheet;
    IBOutlet NSMatrix		*mergeMatrix;
    IBOutlet NSTextField	*newMergeNameField;
    IBOutlet NSBox		*mergedNameBox;
    IBOutlet NSView		*mergedNameView;
    IBOutlet RASTableView	*loadsetsToMergeTable;
    
    IBOutlet NSPanel            *newSubDirectorySheet;
    IBOutlet NSTextField        *newSubDirectoryNameField;
    IBOutlet NSTextField        *newSubDirectoryInfoField;
    IBOutlet NSButton           *createNewSubDirectoryButton;
    
    IBOutlet RSMLoadsetEditor	*loadsetEditor;
    
@private
    NSConnection		*_connectionToServerAuth;
    int				_currentCommand;
    pid_t			_currentCommandPID;
    RAServerAuth		*_sa;
    NSMutableArray		*_checkedInTranscripts;
    NSMutableArray		*_tmpTranscripts;
    NSString			*_transcriptName;
    NSDictionary		*_mergeInfo;
    id                          _draggingSource;
    NSMutableArray		*_loadsetsToMerge;
    int				dragOriginRow;
    id                          _itemAwaitingChildren;
    id				_delegate;
    RSMNewFolderHelper		*_rsmNewFolderHelper;
    
    int                         _rsmThreadID;
    
    RSMLogger                   *_rsmLogger;
}

- ( void )setServer: ( id )serverObject andThreadID: ( int )ID;

- ( int )loadsetManagerHelperThreadID;
- ( void )setLoadsetManagerHelperThreadID: ( int )ID;

- ( int )currentCommand;
- ( void )setCurrentCommand: ( int )command;
- ( pid_t )currentCommandPID;
- ( oneway void )setCurrentCommandPID: ( pid_t )pid threadID: ( int )ID;

- ( NSArray * )availableTranscripts;

- ( NSDictionary * )mergeInfo;
- ( void )setMergeInfo: ( NSDictionary * )merge;

- ( NSString * )transcript;
- ( void )setTranscript: ( NSString * )transcript;

- ( id )draggingSource;
- ( void )setDraggingSource: ( id )source;

- ( int )dragOriginRow;
- ( void )setDragOriginRow: ( int )row;

- ( IBAction )toggleToolProgressDetails: ( id )sender;
- ( IBAction )mergeTypeToggle: ( id )sender;

- ( void )modifyTranscriptWithCommand: ( int )command;
- ( void )verifyTranscript: ( id )sender;
- ( void )updateTranscript: ( id )sender;
- ( void )deleteTranscript: ( id )sender;

- ( void )getNewSubdirectorySheet: ( id )sender;

- ( IBAction )mergeLoadsets: ( id )sender;
- ( IBAction )cancelMerge: ( id )sender;

- ( IBAction )killCurrentTask: ( id )sender;
- ( void )killFinishedWithStatus: ( int )status;

- ( void )loadIfNeeded;
- ( void )readAvailableCheckedInTranscripts: ( id )sender;
- ( void )readAvailableTmpTranscripts: ( id )sender;
- ( void )refreshTranscriptListing: ( id )sender;

- ( void )authorizationFailedInThreadWithID: ( int )threadID;
- ( oneway void )command: ( int )command finishedWithStatus: ( int )status inThread: ( int )ID;
- ( oneway void )updateDisplayWithString: ( NSString * )string threadID: ( int )ID;
- ( oneway void )updateToolProgressWithString: ( NSString * )string threadID: ( int )ID;

- ( void )setDelegate: ( id )delegate;
- ( id )delegate;

/* menu for right clicks on transcript tables */
                
- ( void )setupTranscriptTableCells;

@end
