#import <Cocoa/Cocoa.h>
#import "RASTableView.h"
#import "RAOutlineView.h"
#import "RSMNewFolderHelper.h"

#define KFILEDIR	    "/var/radmind/command"
#define RSMKFilePboardType  @"RSMKFileFilePboardType"

/* convenience macro for outline view datasource methods */
#define GET_NODE_CHILDREN(j,n,m)    NSMutableArray *children = nil; \
if ( n && m ) { \
    NSString	*_gncStr = nil; \
    int		_gnci; \
								\
    children = [[ NSMutableArray alloc ] init ]; \
								\
    for ( _gnci = j; _gnci < [ m count ]; _gnci++ ) { \
	_gncStr = [[ m objectAtIndex: _gnci ] \
		    objectForKey: @"RadmindServerItemParent" ]; \
	if ( [ _gncStr isEqualToString: [ n objectForKey: \
		    @"RadmindServerItemPath" ]] ) { \
	    [ children addObject: [ m objectAtIndex: _gnci ]]; \
	} \
    } \
    [ children autorelease ]; \
}
/* end GET_NODE_CHILDREN(n) macro */

@class RAServerAuth;
@class RAServerController;
@class RSMLoadsetManager;

@interface RSMLoadsetEditor : NSObject
{
    IBOutlet RASTableView 	*currentKFileTable;
    IBOutlet RAOutlineView	*allCommandFilesTable;
    IBOutlet NSWindow		*loadsetWindow;
    IBOutlet RAServerController	*serverController;
    IBOutlet RSMLoadsetManager	*transcriptManager;
    
    IBOutlet NSPanel		*newCommandFileSheet;
    IBOutlet NSPopUpButton	*newCommandFileContents;
    IBOutlet NSTextField	*newCommandFileNameField;
    
    IBOutlet NSPanel		*specialSheet;
    IBOutlet NSPopUpButton	*specialTranscriptPopUp;
    IBOutlet NSPopUpButton	*specialClientPopUp;
    
@private
    NSString			*_currentCommandFileName;
    NSMutableArray		*_currentCommandFile;
    NSMutableArray		*_allCommandFiles;
    BOOL			_isCommandFileEdited;
    RAServerAuth		*_sa;
    NSConnection		*_connectionToServerAuth;
    int				_currentCommand;
    id				_delegate;
    int				_dragOriginRow;
    RSMNewFolderHelper		*_rsmNewFolderHelper;
    BOOL			_rsmSavingCommandFile;
    
    int                         _rsmThreadID;
}

- ( int )loadsetEditorHelperThreadID;
- ( void )setLoadsetEditorHelperThreadID: ( int )ID;

- ( void )setServer: ( id )serverObject andThreadID: ( int )ID;
- ( oneway void )setCurrentCommandPID: ( pid_t )pid threadID: ( int )ID;

- ( IBAction )readSelectedCommandFile: ( id )sender;
- ( IBAction )deleteCommandFileEntry: ( id )sender;
- ( IBAction )saveCommandFile: ( id )sender;
- ( IBAction )deleteCommandFile: ( id )sender;
- ( IBAction )newCommandFile: ( id )sender;
- ( void )moveCommandFileAtPath: ( NSString * )src toPath: ( NSString * )dest;

- ( IBAction )addSpecialFile: ( id )sender;
- ( IBAction )cancelAddSpecialFile: ( id )sender;

- ( BOOL )savingCommandFile;
- ( void )setSavingCommandFile: ( BOOL )saving;
- ( BOOL )isCommandFileEdited;
- ( void )setCommandFileEdited: ( BOOL )edit;
- ( void )setCurrentCommand: ( int )command;
- ( int )currentCommand;
- ( NSString * )currentCommandFileName;
- ( void )setCurrentCommandFileName: ( NSString * )name;
- ( int )dragOriginRow;
- ( void )setDragOriginRow: ( int )row;

- ( void )setDelegate: ( id )delegate;
- ( id )delegate;

- ( IBAction )createNewKFile: ( id )sender;
- ( IBAction )dismissNewKFileSheet: ( id )sender;

- ( void )setupKFileEntryTypePopups;

- ( oneway void )command: ( int )cmd finishedWithStatus: ( int )status inThread: ( int )ID;

- ( void )reloadCommandFiles;
- ( void )readFromTmpCommandFile;

- ( BOOL )assistAdditionOfLoadsetEntry: ( NSDictionary * )entry isNegative: ( BOOL )negative;
- ( void )addLoadsetEntry: ( NSDictionary * )entry toCommandFile: ( NSString * )commandFile;
- ( void )setupCommandFileNameCells;

@end

@interface NSObject(RMSLoadsetEditorDelegate)
- ( void )setAvailableCommandFiles: ( NSMutableArray * )commandFiles;
- ( void )availableCommandFilesDidChange: ( NSMutableArray * )commandFiles;
@end
