/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import <Cocoa/Cocoa.h>
#import <Security/Authorization.h>

enum {
    RSM_REFRESHALL = 0,
    RSM_REFRESH_CONFIG = 1,
    RSM_REFRESH_TRANSCRIPTS = 2,
    RSM_REFRESH_KFILES,
    RA_CURRENTKFILE_READ,
    RA_ALLKFILE_READ,
    RA_CHECKEDIN_TRANSCRIPTS_READ,
    RA_TMP_TRANSCRIPTS_READ,
    RA_FILE_WRITE,
    RA_KFILE_DELETE,
    RA_TRANSCRIPT_CHECKIN,
    RA_TRANSCRIPT_VERIFY,
    RA_NEWKFILE_CREATE,
    RA_TRANSCRIPT_DELETE,
    RA_LOADSET_MERGE,
    RA_LOADSET_MERGEINTO,
    RA_LOADSET_RENAME,
    RA_TRANSCRIPT_UPDATE,
    RA_ADD_SPECIAL,
    RA_TRANSCRIPT_LOCAL_BACKUP,
    RA_SUBDIRECTORY_READ,
    RA_SUBDIRECTORY_CREATE,
    RA_KFILE_SUBDIRECTORY_READ,
    RA_KFILE_SUBDIRECTORY_CREATE,
};

#define RSMHelperThreadReadyNotification    @"RSMHelperThreadReadyNotification"

@protocol RAServerAuthInterface

- ( oneway void )disconnect;
- ( oneway void )executeCommand: ( int )cmd
            withArguments: ( NSArray * )args
            controller: ( id )controller;

@end

@interface RAServerAuth : NSObject <RAServerAuthInterface>
{
@private
    id              rascontroller;
    int             _rsmThreadID;
}

+ ( void )connectWithPorts: ( NSArray * )ports;
- ( id )init;
- ( void )setThreadID: ( int )ID;
- ( int )threadID;

- ( int )executeAuthorizedCommand: ( int )command
            withRef: ( AuthorizationRef )authRef
            andArguments: ( NSArray * )args;
            
- ( int )prepareAuthorizedCommand: ( int )command
            withRight: ( AuthorizationItem )right
            andArguments: ( NSArray * )args;

@end
