/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "RAEditorLauncher.h"

#include <ApplicationServices/ApplicationServices.h>

#include <sys/types.h>
#include <errno.h>
#include <unistd.h>

extern int			errno;

@implementation RAEditorLauncher

+ ( RAEditorLauncher * )sharedInstance
{
    static RAEditorLauncher       *sharedInstance = nil;
   
    if ( !sharedInstance ) {
        sharedInstance = [[ RAEditorLauncher alloc ] init ];
    }

    return( [ sharedInstance autorelease ] );
}

- ( BOOL )viewTrans: ( NSString * )tPath withTextEditor: ( NSString * )editor
{
    NSUserDefaults		*defaults;
    NSArray			*altEditors, *itemArray = nil;
    int				i;
    OSStatus			status;
    NSMutableDictionary		*term;
    NSString			*termPath;
    LSLaunchURLSpec		spec;
    NSURL			*transcriptURL = NULL;
    CFURLRef			url = NULL;
    
    if ( strstr(( char * )[ editor UTF8String ], "Radmind" ) != NULL ) {
        status = LSFindApplicationForInfo(( OSType )'????',
                        ( CFStringRef )@"edu.umich.radmindtranscripteditor",
                        NULL, NULL, &url );

        if ( status != noErr ) {
            NSRunAlertPanel( @"Error launching editor", @"Error %d",
                    @"OK", @"", @"", ( int )status );
            return( NO );
        }
    
        if ( tPath == nil ) {
            if ( ![[ NSWorkspace sharedWorkspace ] openURL: ( NSURL * )url ] ) {
                NSRunAlertPanel( @"Couldn't launch Radmind Transcript Editor",
                            @"", @"OK", @"", @"" );
                return( NO );
            }
            return( YES );
        }
        
        transcriptURL = [ NSURL fileURLWithPath: tPath ];
        itemArray = [ NSArray arrayWithObject: transcriptURL ];

        spec.appURL = ( CFURLRef )url;
        spec.itemURLs = ( CFArrayRef )itemArray;
        spec.passThruParams = NULL;
        spec.launchFlags = kLSLaunchDefaults;
        spec.asyncRefCon = NULL;
        
        status = LSOpenFromURLSpec( &spec, NULL );
        
        if ( status != noErr ) {
            NSRunAlertPanel( @"Error launching editing session.",
                            @"Couldn't launch Radmind Transcript Editor: error %d",
                            @"OK", @"", @"", ( int )status );
            return( NO );
        }
        
        return( YES );
    }
    
    defaults = [ NSUserDefaults standardUserDefaults ];
    altEditors = [ defaults objectForKey: @"alteditors" ];
    
    for ( i = 0; i < [ altEditors count ]; i++ ) {
        if ( [ editor isEqualToString: [[ altEditors objectAtIndex: i ]
                                                objectForKey: @"name" ]] ) {
            if ( ! [[ NSWorkspace sharedWorkspace ] openFile: tPath
                    withApplication: [[ altEditors objectAtIndex: i ]
                                            objectForKey: @"path" ]
                    andDeactivate: YES ] ) {
                NSRunAlertPanel( @"Error launching editing session.",
                    @"Couldn't launch %@", @"OK", @"", @"",
                        [[ altEditors objectAtIndex: i ] objectForKey: @"name" ] );
                return( NO );
            }
            return( YES );
        }
    }
    
    term = [[ NSMutableDictionary alloc ] init ];
    
    [ term setDictionary: [ NSDictionary dictionaryWithContentsOfFile:
        [[ NSBundle mainBundle ] pathForResource: @"template" ofType: @"term" ]]];

    [[[ term objectForKey: @"WindowSettings" ] objectAtIndex: 0 ] setObject:
            [ NSString stringWithFormat: @"/usr/bin/sudo %@ %@ ; exit", editor, tPath ]
            forKey: @"ExecutionString" ];
                
    termPath = [ NSString stringWithFormat: @"/tmp/ra.%d.term", getpid() ];
    
    if ( access(( char * )[ termPath UTF8String ], F_OK ) == 0 ) {
        if ( unlink(( char * )[ termPath UTF8String ] ) < 0 ) {
            NSLog( @"unlink %@: %s", termPath, strerror( errno ));
            return( NO );
        }
    }
    
    if ( ![ term writeToFile: termPath atomically: YES ] ) {
        NSRunAlertPanel( @"Error creating terminal session.",
                            @"Couldn't write .term file to /tmp",
                            @"OK", @"", @"" );
        return( NO );
    }
    
    if ( ![[ NSWorkspace sharedWorkspace ] openFile: termPath
                                        withApplication: @"Terminal.app"
                                        andDeactivate: YES ] ) {
        NSRunAlertPanel( @"Error launching editing session.",
                            @"Couldn't launch Terminal",
                            @"OK", @"", @"" );
        return( NO );
    }
    
    return( YES );
}

@end
