/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSFileManager(mktemp).h"

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>

@implementation NSFileManager(mktemp)

- ( NSString * )makeTemporaryDirectory: ( NSString * )template
	withMode: ( mode_t )mode
{
    char	tmp[ MAXPATHLEN ];
    
    if ( template == nil ) {
	return( nil );
    }
    
    if ( strlen( [ template UTF8String ] ) >= MAXPATHLEN ) {
	NSLog( @"%s: too long\n", [ template UTF8String ] );
	return( nil );
    }
    strcpy( tmp, [ template UTF8String ] );
    
    /* XXX is this really a good idea? */
    if ( mkdtemp( tmp ) == NULL ) {
	if ( errno != EEXIST ) {
	    NSLog( @"mkdtemp %s: %s", tmp, strerror( errno ));
	    return( nil );
	}
    }
    if ( chmod( tmp, mode ) != 0 ) {
	NSLog( @"chmod %.4o %s: %s", mode, tmp, strerror( errno ));
	return( nil );
    }
    
    return( [ NSString stringWithUTF8String: tmp ] );
}

@end
