#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <dirent.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#include "prepost.h"

extern char *const	environ[];

    static int
run_prepost( char *radmind_path, char *type, char *transcript )
{
    DIR			*d;
    struct dirent	*de;
    struct stat		st;
    char		*argv[ 3 ];
    char		pd[ MAXPATHLEN ];
    char		pitem[ MAXPATHLEN ];
    pid_t		pid;
    int			status;

    if ( snprintf( pd, MAXPATHLEN, "%s/%s",
		radmind_path, type ) >= MAXPATHLEN ) {
	fprintf( stderr, "%s/%s: path too long\n", radmind_path, type );
	return( 2 );
    }

    if (( d = opendir( pd )) == NULL ) {
	fprintf( stderr, "opendir %s: %s\n", pd, strerror( errno ));
	return( 2 );
    }

    while (( de = readdir( d )) != NULL ) {
	if ( de->d_name[ 0 ] == '.' ) {
	    continue;
	}

	if ( snprintf( pitem, MAXPATHLEN, "%s/%s",
		pd, de->d_name ) >= MAXPATHLEN ) {
	    fprintf( stderr, "%s/%s: path too long\n", pd, de->d_name );
	    return( 2 );
	}

	if ( stat( pitem, &st ) != 0 ) {
	    fprintf( stderr, "stat %s: %s\n", pitem, strerror( errno ));
	    return( 2 );
	}
	if ( !S_ISREG( st.st_mode ) || !( st.st_mode & S_IXUSR )) {
	    continue;
	}

	printf( "Executing %s...\n", pitem );
	fflush( stdout );

	switch ( fork()) {
	case 0:
	    argv[ 0 ] = pitem;
	    argv[ 1 ] = transcript;
	    argv[ 2 ] = NULL;

	    execve( pitem, argv, NULL );
	    fprintf( stderr, "execve %s: %s\n", pitem, strerror( errno ));
	    fflush( stderr );
	    _exit( 2 );

	case -1:
	    fprintf( stderr, "fork: %s\n", strerror( errno ));
	    return( 2 );

	default:
	    break;
	}

	pid = wait( &status );

	if ( WEXITSTATUS( status ) != 0 ) {
	    syslog( LOG_ERR, "%s (pid %d) exited with status %d.",
		pitem, pid, WEXITSTATUS( status ));
	}
    }

    if ( closedir( d ) != 0 ) {
	perror( "closedir" );
	return( 2 );
    }

    return( 0 );
}

    int
preapply( char *radmind_path, char *transcript )
{
    return( run_prepost( radmind_path, "preapply", transcript ));
}

    int
postapply( char *radmind_path, char *transcript )
{
    return( run_prepost( radmind_path, "postapply", transcript ));
}
