/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import <Cocoa/Cocoa.h>
#import "RAAuthExec.h"
#import "RAAuthKiller.h"

#define CREATE	1
#define UPDATE	0

#define AUTH_FAILED_MESSAGE @"Authorization Failed. You must supply a valid \
    administrator name and password to continue."

@interface RCMStepController : NSObject
{
    int				step;
    int				sessiontype, CURRENTTOOL, KILLED;
    double			lines;
    
    /* common UI elements */
    IBOutlet NSButton 		*backButton;
    IBOutlet NSButton 		*continueButton;
    IBOutlet NSButton 		*skipButton;
    IBOutlet NSWindow 		*stepperWindow;
    IBOutlet NSBox 		*viewBox;
    IBOutlet NSTextField	*stepTitleField;
    
    /* about panel */
    IBOutlet NSPanel		*aboutPanel;
    IBOutlet NSTextView		*aboutToolsVersionView;
    
    /* first time run views */
    IBOutlet NSView		*firstTimeRunView;
        IBOutlet NSMatrix	*ftChoiceMatrix;
    IBOutlet NSView		*setupServerView;
        IBOutlet NSMatrix	*radmindServerOptionMatrix;
    IBOutlet NSView		*setupDefaultsView;
        IBOutlet NSComboBox	*setupDefaultsServerField;
        IBOutlet NSPopUpButton	*setupDefaultsFsdiffPath;
        IBOutlet NSMatrix	*setupDefaultsChecksums;
        IBOutlet NSPopUpButton	*setupDefaultsTLSLevel;
    IBOutlet NSView		*setupAutomationView;
    IBOutlet NSView		*negativePreparationView;
        IBOutlet NSTextField	*baseNegativeTranscriptField;
        IBOutlet NSButton	*clearCustomNegativeButton;
    
    /* creation views */
    IBOutlet NSView		*cWelcomeView;
    
    IBOutlet NSView		*cCheckUpView;
        
    IBOutlet NSView 		*cFsdiffView;
        /* fsdiff step */
        IBOutlet NSMatrix	*cFsdiffCksumSwitch;
        IBOutlet NSTextField	*cFsdiffLoadsetName;
        
    IBOutlet NSView 		*cLcreateView;
        /* lcreate step */
        IBOutlet NSComboBox	*cLcreateServerField;
        IBOutlet NSMatrix	*cLcreateCksumSwitch;
        IBOutlet NSButton	*cLcreateZeroSwitch;
        IBOutlet NSTextField	*cLoadsetNameField;
        
    IBOutlet NSView		*cCreationDone;
        /* finished pane */
        IBOutlet NSTextField	*cFinishedHeaderField;
        IBOutlet NSTextField	*cFinishedMessageField;
    
    
    /* update views */
    IBOutlet NSView		*aWelcomeView;
    
    IBOutlet NSView 		*aCkForUpdatesView;
        /* update view outlets */
        IBOutlet NSComboBox	*aKtcheckHostField;
        
    IBOutlet NSView		*aFsdiffView;
        /* fsdiff step */
        IBOutlet NSMatrix	*aFsdiffCksumSwitch;
        IBOutlet NSTextField	*updatesInfoField;
        IBOutlet NSButton	*viewUpdatesButton;
        
    IBOutlet NSView 		*aDiffsFoundView;
        /* lapply step */
        IBOutlet NSComboBox	*aLapplyServerField;	/* radmind server name */
        IBOutlet NSMatrix	*aLapplyCksumSwitch;	/* en/disable cksums */
        IBOutlet NSButton	*aLapplyForceSwitch;	/* remove locks */
        
    IBOutlet NSView 		*aSysUpToDateView;
        IBOutlet NSTextField	*aFinalUpdateMsg;
    
    /* user auth sheet outlets */
    IBOutlet NSPanel		*passwordSheet;
    IBOutlet NSSecureTextField	*userAuthPassField;
    IBOutlet NSTextField	*userAuthNameField;
    
    /* tool prog outlets */
    IBOutlet NSProgressIndicator	*toolProgBar;
    IBOutlet NSTextField	*toolMsgField;
    IBOutlet NSScrollView	*msgScrollView;
    IBOutlet NSTextField	*toolHeaderField;
    IBOutlet NSView		*toolProgressView;
    IBOutlet NSButton		*toolProgCancelButton;
    IBOutlet NSTextField        *progressMessageField;
    
    /* tool error outlets */
    IBOutlet NSView		*errorView;
    IBOutlet NSTextField	*errorMessageField;
    
    /* log drawer outlets */
    IBOutlet NSDrawer		*logDrawer;
    IBOutlet NSTextView		*toolsLogField;
    
    IBOutlet NSTableView	*negativeTranscriptTable;
    
@private
        /* for distributed objects */
    NSConnection		*connectionToAuthExec;
    RAAuthExec			*aexec;
    
    /* for bonjour */
    NSNetServiceBrowser		*svcBrowser;
    NSNetService		*serviceBeingResolved;
    NSMutableArray		*services;
    NSMutableArray		*zcServerAddresses; /* resolved zeroconf addresses */
    
    /* temp dir where we place files during session */
    NSString                    *_raSessionTmpDir;
    
    /* array of negative transcripts available for this system */
    NSArray			*_validNegativeTranscripts;
    
    /* transcript names used for creating and updating */
    NSString			*_applicableTranscriptName;
    NSString			*_creatableTranscriptName;
    
    /* used to determine if tools need to be installed */
    BOOL			needsToolUpdate;
    
    /* pre- and post-apply settings */
    BOOL			_raPreApply;
    BOOL			_raPostApply;
}

/* about panel methods */
- ( IBAction )showAboutPanel: ( id )sender;
- ( IBAction )emailAuthors: ( id )sender;
- ( IBAction )visitWebsite: ( id )sender;

/* accessor methods */
- ( void )setValidNegativeTranscripts: ( NSArray * )validTranscripts;
- ( NSArray * )validNegativeTranscripts;

- ( void )setCreatableTranscriptName: ( NSString * )name;
- ( NSString * )creatableTranscriptName;

- ( void )setApplicableTranscriptName: ( NSString * )name;
- ( NSString * )applicableTranscriptName;

- ( void )setSessionTempDirectory: ( NSString * )tmpdir;
- ( NSString * )sessionTempDirectory;
- ( void )cleanUpTemporaryDirectory;

- ( void )setNeedsToolUpdate: ( BOOL )update;
- ( BOOL )needsToolUpdate;

- ( void )setPreApply: ( BOOL )preapply;
- ( BOOL )preApply;
- ( void )setPostApply: ( BOOL )postapply;
- ( BOOL )postApply;

/* main button actions */
- ( IBAction )back: ( id )sender;
- ( IBAction )next: ( id )sender;
- ( IBAction )skip: ( id )sender;

- ( IBAction )cancel: ( id )sender;
- ( void )killFinishedWithStatus: ( int )status;

- ( void )prePostQuery: ( NSString * )type;

/* first time run optional steps */
- ( IBAction )firstRunDetected: ( id )sender;
- ( IBAction )firstTimeRun: ( id )sender;
- ( IBAction )setupServer: ( id )sender;
- ( IBAction )setSystemWideDefaults: ( id )sender;
- ( IBAction )configureRadmindAutomation: ( id )sender;
- ( IBAction )negativePrepared: ( id )sender;
- ( IBAction )examineNegativeTranscript: ( id )sender;

- ( IBAction )beginCreation: ( id )sender;
- ( IBAction )beginUpdate: ( id )sender;

- ( void )nextStepUI;
- ( NSView * )viewForStep: ( int )st;

- ( NSWindow * )assistantWindow;

- ( void )setServer: ( id )serverObject;

- ( oneway void )showProgUIForTool: ( int )tool;
- ( oneway void )updateProgress: ( NSString * )progressString;
- ( oneway void )tool: ( int )tool finishedWithStatus: ( int )status;
- ( oneway void )addTextToLog: ( NSString * )text color: ( NSColor * )color
            displayInPane: ( BOOL )display;
- ( oneway void )toolError: ( char * )errmsg;

- ( void )openDrawer;

- ( void )actionForStep: ( int )st;
- ( void )execTool: ( int )tool arguments: ( NSArray * )args;

- ( void )authorizationFailed;

- ( void )getPassword;
- ( NSString * )retrievePassword;
- ( IBAction )storePassword: ( id )sender;
- ( IBAction )endPasswordSheet: ( id )sender;

- ( IBAction )installTools: ( id )sender;

- ( IBAction )openServerManager: ( id )sender;

- ( IBAction )chooseBaseNegativeTranscript: ( id )sender;
- ( IBAction )clearCustomNegativeTranscriptChoice: ( id )sender;

- ( IBAction )chooseTranscript: ( id )sender;
- ( IBAction )viewTranscript: ( id )sender;
- ( IBAction )openTranscriptEditor: ( id )sender;

@end

@interface RCMStepController(AppDelegateMethods)

- ( void )showAutomationPreferencesPane;

@end
