/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSString(ComparisonExtensions).h"

@implementation NSString(ComparisonExtensions)

- ( BOOL )containsString: ( NSString * )substring
{
    return( [ self containsString: substring useCaseInsensitiveComparison: NO ] );
}

- ( BOOL )containsString: ( NSString * )substring useCaseInsensitiveComparison: ( BOOL )ci
{
    unsigned		mask;
    
    if ( substring == nil ) return NO;
    
    if ( ci == YES ) mask = NSCaseInsensitiveSearch;
    else mask = NSLiteralSearch;
    
    if ( [ self rangeOfString: substring options: mask ].location != NSNotFound ) {
        return( YES );
    }
    return( NO );
}

@end
