/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "AppDelegate.h"
#import "RCMStepController.h"
#import "RCMPreferences.h"

#include <unistd.h>

#define RADMIND_SERVER_CONF	"/var/radmind/config"

@implementation AppDelegate

- ( IBAction )showStepperWindow: ( id )sender
{
    [ stepper beginUpdate: nil ];
}

- ( IBAction )gotoRadmindHomepage: ( id )sender
{
    [[ NSWorkspace sharedWorkspace ] openURL:
        [ NSURL URLWithString: @"http://www.radmind.org" ]];
}

- ( BOOL )validateMenuItem: ( NSMenuItem * )anItem
{
    BOOL                validate = YES;
    
    if ( [[ anItem title ] isEqualToString: @"Open Server Manager" ] ) {
        if ( access( RADMIND_SERVER_CONF, F_OK ) < 0 ) {
            validate = NO;
        }
    }
    
    return( validate );
}

- ( IBAction )showPreferencePanel: ( id )sender
{
    if ( prefs == nil ) {
        prefs = [[ RCMPreferences alloc ] init ];
        [ NSBundle loadNibNamed: @"Preferences" owner: prefs ];
    }

    [[ prefs prefPanel ] makeKeyAndOrderFront: nil ];
    [ prefs prefsReload ];
}

- ( void )showAutomationPreferencesPane
{
    [ self showPreferencePanel: nil ];
    [ prefs showAutomationPreferences: nil ];
}

- ( NSString * )sessionTemporaryDirectory
{
    return( [ stepper sessionTempDirectory ] );
}

- ( void )applicationDidFinishLaunching: ( NSNotification * )aNotification
{
    [ self showStepperWindow: nil ];
}

- ( void )applicationWillTerminate: ( NSNotification * )notification
{
    [ stepper cleanUpTemporaryDirectory ];
}

@end
