#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 587
#define LARGE_STATE_COUNT 172
#define SYMBOL_COUNT 264
#define ALIAS_COUNT 1
#define TOKEN_COUNT 122
#define EXTERNAL_TOKEN_COUNT 7
#define FIELD_COUNT 7
#define MAX_ALIAS_SEQUENCE_LENGTH 6

enum {
  anon_sym_DQUOTE = 1,
  aux_sym_legacy_quoted_command_token1 = 2,
  anon_sym_TILDE = 3,
  sym_grep_specifier_identifier = 4,
  aux_sym_grep_specifier_token1 = 5,
  anon_sym_PIPE = 6,
  anon_sym_PIPEH = 7,
  anon_sym_PIPET = 8,
  sym_pipe_second_command = 9,
  anon_sym_AT_AT_AT_EQ = 10,
  anon_sym_AT_AT_ATb = 11,
  anon_sym_AT_AT_ATc_COLON = 12,
  anon_sym_AT_AT_ATC_COLON = 13,
  anon_sym_AT_AT_ATi = 14,
  anon_sym_AT_AT_ATr = 15,
  anon_sym_AT_AT_ATs = 16,
  anon_sym_AT_AT_ATst = 17,
  anon_sym_AT_AT_ATS = 18,
  anon_sym_AT_AT_ATm = 19,
  anon_sym_AT_AT_ATM = 20,
  anon_sym_AT_AT_ATf = 21,
  anon_sym_AT_AT_ATf_COLON = 22,
  anon_sym_AT_AT_ATF = 23,
  anon_sym_AT_AT_ATF_COLON = 24,
  anon_sym_AT_AT_ATt = 25,
  anon_sym_AT_AT = 26,
  anon_sym_AT_ATdbt = 27,
  anon_sym_AT_ATdbta = 28,
  anon_sym_AT_ATdbtb = 29,
  anon_sym_AT_ATdbts = 30,
  anon_sym_AT_AT_DOT = 31,
  anon_sym_AT_AT_EQ = 32,
  anon_sym_AT_ATk = 33,
  anon_sym_AT_ATt = 34,
  anon_sym_AT_ATb = 35,
  anon_sym_AT_ATi = 36,
  anon_sym_AT_ATiS = 37,
  anon_sym_AT_ATf = 38,
  anon_sym_COLON = 39,
  anon_sym_AT_ATs_COLON = 40,
  anon_sym_AT_ATc_COLON = 41,
  anon_sym_AT = 42,
  anon_sym_AT_BANG = 43,
  anon_sym_AT_LBRACE = 44,
  anon_sym_RBRACE = 45,
  anon_sym_ATa_COLON = 46,
  anon_sym_ATb_COLON = 47,
  anon_sym_ATB_COLON = 48,
  anon_sym_ATe_COLON = 49,
  anon_sym_ATF_COLON = 50,
  anon_sym_ATi_COLON = 51,
  anon_sym_ATk_COLON = 52,
  anon_sym_ATo_COLON = 53,
  anon_sym_ATr_COLON = 54,
  anon_sym_ATf_COLON = 55,
  anon_sym_ATs_COLON = 56,
  anon_sym_ATx_COLON = 57,
  anon_sym_POUND_BANG = 58,
  anon_sym_AMP = 59,
  anon_sym_AMPt = 60,
  aux_sym_task_command_token1 = 61,
  anon_sym_0 = 62,
  aux_sym_number_command_token1 = 63,
  anon_sym_POUND_QMARK = 64,
  anon_sym_POUND_BANG_QMARK = 65,
  aux_sym__search_command_token1 = 66,
  anon_sym_DOT = 67,
  anon_sym_DOT_BANG = 68,
  anon_sym_DOT_LPAREN = 69,
  anon_sym_PIPE_DOT = 70,
  anon_sym_DOT_SLASH = 71,
  anon_sym_pfo = 72,
  anon_sym_Cf = 73,
  sym_pf_dot_cmd_identifier = 74,
  sym_pf_dot_full_cmd_identifier = 75,
  aux_sym_pf_cmd_token1 = 76,
  anon_sym_EQ = 77,
  sym__pf_dot_arg_identifier = 78,
  anon_sym_LPAREN = 79,
  anon_sym_RPAREN = 80,
  sym_pf_arg_identifier = 81,
  anon_sym_PERCENT = 82,
  anon_sym_env = 83,
  anon_sym_DOT_DOT_DOT = 84,
  aux_sym__interpret_identifier_token1 = 85,
  aux_sym__interpret_identifier_token2 = 86,
  sym_system_identifier = 87,
  sym_question_mark_identifier = 88,
  sym_pointer_identifier = 89,
  sym_macro_identifier = 90,
  anon_sym_SEMI = 91,
  anon_sym_GT = 92,
  anon_sym_GT_GT = 93,
  sym_html_redirect_operator = 94,
  sym_html_append_operator = 95,
  anon_sym_COMMA = 96,
  aux_sym_tmp_eval_arg_token1 = 97,
  sym__eq_sep_key_identifier = 98,
  sym__any_command = 99,
  sym_arg_identifier = 100,
  sym_arg_identifier_brace = 101,
  aux_sym_double_quoted_arg_token1 = 102,
  aux_sym_double_quoted_arg_token2 = 103,
  aux_sym_double_quoted_arg_token3 = 104,
  anon_sym_SQUOTE = 105,
  aux_sym_single_quoted_arg_token1 = 106,
  aux_sym_single_quoted_arg_token2 = 107,
  anon_sym_DOLLAR_LPAREN = 108,
  anon_sym_BQUOTE = 109,
  aux_sym__dec_number_token1 = 110,
  aux_sym__dec_number_token2 = 111,
  sym__comment = 112,
  anon_sym_LF = 113,
  anon_sym_CR = 114,
  sym_cmd_identifier = 115,
  sym__help_command = 116,
  sym_file_descriptor = 117,
  sym__eq_sep_concat = 118,
  sym__concat = 119,
  sym__concat_brace = 120,
  sym__concat_pf_dot = 121,
  sym_commands = 122,
  sym__commands_singleline = 123,
  sym__command = 124,
  sym_legacy_quoted_command = 125,
  sym__simple_command = 126,
  sym__tmp_command = 127,
  sym__iter_command = 128,
  sym__foreach_command = 129,
  sym__pipe_command = 130,
  sym_grep_command = 131,
  sym_grep_specifier = 132,
  sym_html_disable_command = 133,
  sym_html_enable_command = 134,
  sym_scr_tts_command = 135,
  sym_pipe_command = 136,
  sym_foreach_addrsize_command = 137,
  sym_foreach_bb_command = 138,
  sym_foreach_cmd_command = 139,
  sym_foreach_comment_command = 140,
  sym_foreach_import_command = 141,
  sym_foreach_register_command = 142,
  sym_foreach_symbol_command = 143,
  sym_foreach_string_command = 144,
  sym_foreach_section_command = 145,
  sym_foreach_iomap_command = 146,
  sym_foreach_dbgmap_command = 147,
  sym_foreach_flag_command = 148,
  sym_foreach_function_command = 149,
  sym_foreach_thread_command = 150,
  sym_iter_flags_command = 151,
  sym_iter_dbta_command = 152,
  sym_iter_dbtb_command = 153,
  sym_iter_dbts_command = 154,
  sym_iter_file_lines_command = 155,
  sym_iter_offsets_command = 156,
  sym_iter_sdbquery_command = 157,
  sym_iter_threads_command = 158,
  sym_iter_bbs_command = 159,
  sym_iter_instrs_command = 160,
  sym_iter_sections_command = 161,
  sym_iter_functions_command = 162,
  sym_iter_step_command = 163,
  sym_iter_interpret_command = 164,
  sym_iter_hit_command = 165,
  sym_tmp_seek_command = 166,
  sym_tmp_blksz_command = 167,
  sym_tmp_fromto_command = 168,
  sym_tmp_arch_command = 169,
  sym_tmp_bits_command = 170,
  sym_tmp_nthi_command = 171,
  sym_tmp_eval_command = 172,
  sym_tmp_fs_command = 173,
  sym_tmp_reli_command = 174,
  sym_tmp_kuery_command = 175,
  sym_tmp_fd_command = 176,
  sym_tmp_reg_command = 177,
  sym_tmp_file_command = 178,
  sym_tmp_string_command = 179,
  sym_tmp_hex_command = 180,
  sym__interpreter_command = 181,
  sym_task_command = 182,
  sym_number_command = 183,
  sym_help_command = 184,
  sym_arged_command = 185,
  sym__simple_arged_command = 186,
  sym__search_command = 187,
  sym__math_arged_command = 188,
  sym__pointer_arged_command = 189,
  sym__macro_arged_command = 190,
  sym__system_command = 191,
  sym__interpret_command = 192,
  sym__interpret_search_identifier = 193,
  sym__pf_arged_command = 194,
  sym__pf_commands = 195,
  sym_Cf_cmd = 196,
  sym__Cf_args = 197,
  sym_pf_new_cmd = 198,
  sym_pf_dot_cmd = 199,
  sym_pf_cmd = 200,
  sym_pf_new_args = 201,
  sym_pf_dot_cmd_args = 202,
  sym__pf_arg_parentheses = 203,
  sym__pf_arg = 204,
  sym__pf_dot_arg = 205,
  sym_pf_concatenation = 206,
  sym_pf_dot_concatenation = 207,
  sym_pf_arg = 208,
  sym_pf_dot_arg = 209,
  sym_pf_args = 210,
  sym_pf_dot_args = 211,
  sym__env_command = 212,
  sym__env_command_identifier = 213,
  sym_last_command = 214,
  sym_last_command_identifier = 215,
  sym__interpret_identifier = 216,
  sym_interpret_arg = 217,
  sym_repeat_command = 218,
  sym_eq_sep_args = 219,
  sym_macro_call_content = 220,
  sym_macro_call_full_content = 221,
  sym_macro_content = 222,
  sym_macro_args = 223,
  sym_redirect_command = 224,
  sym__redirect_operator = 225,
  sym_fdn_redirect_operator = 226,
  sym_fdn_append_operator = 227,
  sym__arg = 228,
  sym__arg_brace = 229,
  sym_arg = 230,
  sym_arg_brace = 231,
  sym_args = 232,
  sym_tmp_eval_args = 233,
  sym_tmp_eval_arg = 234,
  sym__eq_sep_key_single = 235,
  sym_eq_sep_key = 236,
  sym_eq_sep_val = 237,
  sym_double_quoted_arg = 238,
  sym_single_quoted_arg = 239,
  sym_cmd_substitution_arg = 240,
  sym_concatenation = 241,
  sym_concatenation_brace = 242,
  sym__dec_number = 243,
  aux_sym_commands_repeat1 = 244,
  aux_sym_commands_repeat2 = 245,
  aux_sym__commands_singleline_repeat1 = 246,
  aux_sym__commands_singleline_repeat2 = 247,
  aux_sym_grep_specifier_repeat1 = 248,
  aux_sym_foreach_addrsize_command_repeat1 = 249,
  aux_sym_pf_concatenation_repeat1 = 250,
  aux_sym_pf_dot_concatenation_repeat1 = 251,
  aux_sym_pf_args_repeat1 = 252,
  aux_sym_pf_dot_args_repeat1 = 253,
  aux_sym_macro_content_repeat1 = 254,
  aux_sym_args_repeat1 = 255,
  aux_sym_tmp_eval_args_repeat1 = 256,
  aux_sym_tmp_eval_arg_repeat1 = 257,
  aux_sym_eq_sep_key_repeat1 = 258,
  aux_sym_eq_sep_val_repeat1 = 259,
  aux_sym_double_quoted_arg_repeat1 = 260,
  aux_sym_single_quoted_arg_repeat1 = 261,
  aux_sym_concatenation_repeat1 = 262,
  aux_sym_concatenation_brace_repeat1 = 263,
  alias_sym_number = 264,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_legacy_quoted_command_token1] = "legacy_quoted_command_token1",
  [anon_sym_TILDE] = "~",
  [sym_grep_specifier_identifier] = "grep_specifier_identifier",
  [aux_sym_grep_specifier_token1] = "grep_specifier_identifier",
  [anon_sym_PIPE] = "|",
  [anon_sym_PIPEH] = "|H",
  [anon_sym_PIPET] = "|T",
  [sym_pipe_second_command] = "pipe_second_command",
  [anon_sym_AT_AT_AT_EQ] = "@@@=",
  [anon_sym_AT_AT_ATb] = "@@@b",
  [anon_sym_AT_AT_ATc_COLON] = "@@@c:",
  [anon_sym_AT_AT_ATC_COLON] = "@@@C:",
  [anon_sym_AT_AT_ATi] = "@@@i",
  [anon_sym_AT_AT_ATr] = "@@@r",
  [anon_sym_AT_AT_ATs] = "@@@s",
  [anon_sym_AT_AT_ATst] = "@@@st",
  [anon_sym_AT_AT_ATS] = "@@@S",
  [anon_sym_AT_AT_ATm] = "@@@m",
  [anon_sym_AT_AT_ATM] = "@@@M",
  [anon_sym_AT_AT_ATf] = "@@@f",
  [anon_sym_AT_AT_ATf_COLON] = "@@@f:",
  [anon_sym_AT_AT_ATF] = "@@@F",
  [anon_sym_AT_AT_ATF_COLON] = "@@@F:",
  [anon_sym_AT_AT_ATt] = "@@@t",
  [anon_sym_AT_AT] = "@@",
  [anon_sym_AT_ATdbt] = "@@dbt",
  [anon_sym_AT_ATdbta] = "@@dbta",
  [anon_sym_AT_ATdbtb] = "@@dbtb",
  [anon_sym_AT_ATdbts] = "@@dbts",
  [anon_sym_AT_AT_DOT] = "@@.",
  [anon_sym_AT_AT_EQ] = "@@=",
  [anon_sym_AT_ATk] = "@@k",
  [anon_sym_AT_ATt] = "@@t",
  [anon_sym_AT_ATb] = "@@b",
  [anon_sym_AT_ATi] = "@@i",
  [anon_sym_AT_ATiS] = "@@iS",
  [anon_sym_AT_ATf] = "@@f",
  [anon_sym_COLON] = ":",
  [anon_sym_AT_ATs_COLON] = "@@s:",
  [anon_sym_AT_ATc_COLON] = "@@c:",
  [anon_sym_AT] = "@",
  [anon_sym_AT_BANG] = "@!",
  [anon_sym_AT_LBRACE] = "@{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_ATa_COLON] = "@a:",
  [anon_sym_ATb_COLON] = "@b:",
  [anon_sym_ATB_COLON] = "@B:",
  [anon_sym_ATe_COLON] = "@e:",
  [anon_sym_ATF_COLON] = "@F:",
  [anon_sym_ATi_COLON] = "@i:",
  [anon_sym_ATk_COLON] = "@k:",
  [anon_sym_ATo_COLON] = "@o:",
  [anon_sym_ATr_COLON] = "@r:",
  [anon_sym_ATf_COLON] = "@f:",
  [anon_sym_ATs_COLON] = "@s:",
  [anon_sym_ATx_COLON] = "@x:",
  [anon_sym_POUND_BANG] = "cmd_identifier",
  [anon_sym_AMP] = "cmd_identifier",
  [anon_sym_AMPt] = "cmd_identifier",
  [aux_sym_task_command_token1] = "cmd_identifier",
  [anon_sym_0] = "0",
  [aux_sym_number_command_token1] = "number_command_token1",
  [anon_sym_POUND_QMARK] = "cmd_identifier",
  [anon_sym_POUND_BANG_QMARK] = "cmd_identifier",
  [aux_sym__search_command_token1] = "cmd_identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_BANG] = "cmd_identifier",
  [anon_sym_DOT_LPAREN] = "cmd_identifier",
  [anon_sym_PIPE_DOT] = "|.",
  [anon_sym_DOT_SLASH] = "./",
  [anon_sym_pfo] = "cmd_identifier",
  [anon_sym_Cf] = "cmd_identifier",
  [sym_pf_dot_cmd_identifier] = "cmd_identifier",
  [sym_pf_dot_full_cmd_identifier] = "cmd_identifier",
  [aux_sym_pf_cmd_token1] = "cmd_identifier",
  [anon_sym_EQ] = "=",
  [sym__pf_dot_arg_identifier] = "pf_arg_identifier",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym_pf_arg_identifier] = "pf_arg_identifier",
  [anon_sym_PERCENT] = "%",
  [anon_sym_env] = "env",
  [anon_sym_DOT_DOT_DOT] = "...",
  [aux_sym__interpret_identifier_token1] = "_interpret_identifier_token1",
  [aux_sym__interpret_identifier_token2] = "_interpret_identifier_token2",
  [sym_system_identifier] = "system_identifier",
  [sym_question_mark_identifier] = "cmd_identifier",
  [sym_pointer_identifier] = "cmd_identifier",
  [sym_macro_identifier] = "cmd_identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [sym_html_redirect_operator] = "html_redirect_operator",
  [sym_html_append_operator] = "html_append_operator",
  [anon_sym_COMMA] = ",",
  [aux_sym_tmp_eval_arg_token1] = "tmp_eval_arg_token1",
  [sym__eq_sep_key_identifier] = "arg_identifier",
  [sym__any_command] = "_any_command",
  [sym_arg_identifier] = "arg_identifier",
  [sym_arg_identifier_brace] = "arg_identifier",
  [aux_sym_double_quoted_arg_token1] = "double_quoted_arg_token1",
  [aux_sym_double_quoted_arg_token2] = "double_quoted_arg_token2",
  [aux_sym_double_quoted_arg_token3] = "double_quoted_arg_token3",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_single_quoted_arg_token1] = "single_quoted_arg_token1",
  [aux_sym_single_quoted_arg_token2] = "single_quoted_arg_token2",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [aux_sym__dec_number_token1] = "_dec_number_token1",
  [aux_sym__dec_number_token2] = "_dec_number_token2",
  [sym__comment] = "_comment",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [sym_cmd_identifier] = "cmd_identifier",
  [sym__help_command] = "cmd_identifier",
  [sym_file_descriptor] = "file_descriptor",
  [sym__eq_sep_concat] = "_eq_sep_concat",
  [sym__concat] = "_concat",
  [sym__concat_brace] = "_concat_brace",
  [sym__concat_pf_dot] = "_concat_pf_dot",
  [sym_commands] = "commands",
  [sym__commands_singleline] = "_commands_singleline",
  [sym__command] = "_command",
  [sym_legacy_quoted_command] = "legacy_quoted_command",
  [sym__simple_command] = "_simple_command",
  [sym__tmp_command] = "_tmp_command",
  [sym__iter_command] = "_iter_command",
  [sym__foreach_command] = "_foreach_command",
  [sym__pipe_command] = "_pipe_command",
  [sym_grep_command] = "grep_command",
  [sym_grep_specifier] = "grep_specifier",
  [sym_html_disable_command] = "html_disable_command",
  [sym_html_enable_command] = "html_enable_command",
  [sym_scr_tts_command] = "scr_tts_command",
  [sym_pipe_command] = "pipe_command",
  [sym_foreach_addrsize_command] = "foreach_addrsize_command",
  [sym_foreach_bb_command] = "foreach_bb_command",
  [sym_foreach_cmd_command] = "foreach_cmd_command",
  [sym_foreach_comment_command] = "foreach_comment_command",
  [sym_foreach_import_command] = "foreach_import_command",
  [sym_foreach_register_command] = "foreach_register_command",
  [sym_foreach_symbol_command] = "foreach_symbol_command",
  [sym_foreach_string_command] = "foreach_string_command",
  [sym_foreach_section_command] = "foreach_section_command",
  [sym_foreach_iomap_command] = "foreach_iomap_command",
  [sym_foreach_dbgmap_command] = "foreach_dbgmap_command",
  [sym_foreach_flag_command] = "foreach_flag_command",
  [sym_foreach_function_command] = "foreach_function_command",
  [sym_foreach_thread_command] = "foreach_thread_command",
  [sym_iter_flags_command] = "iter_flags_command",
  [sym_iter_dbta_command] = "iter_dbta_command",
  [sym_iter_dbtb_command] = "iter_dbtb_command",
  [sym_iter_dbts_command] = "iter_dbts_command",
  [sym_iter_file_lines_command] = "iter_file_lines_command",
  [sym_iter_offsets_command] = "iter_offsets_command",
  [sym_iter_sdbquery_command] = "iter_sdbquery_command",
  [sym_iter_threads_command] = "iter_threads_command",
  [sym_iter_bbs_command] = "iter_bbs_command",
  [sym_iter_instrs_command] = "iter_instrs_command",
  [sym_iter_sections_command] = "iter_sections_command",
  [sym_iter_functions_command] = "iter_functions_command",
  [sym_iter_step_command] = "iter_step_command",
  [sym_iter_interpret_command] = "iter_interpret_command",
  [sym_iter_hit_command] = "iter_hit_command",
  [sym_tmp_seek_command] = "tmp_seek_command",
  [sym_tmp_blksz_command] = "tmp_blksz_command",
  [sym_tmp_fromto_command] = "tmp_fromto_command",
  [sym_tmp_arch_command] = "tmp_arch_command",
  [sym_tmp_bits_command] = "tmp_bits_command",
  [sym_tmp_nthi_command] = "tmp_nthi_command",
  [sym_tmp_eval_command] = "tmp_eval_command",
  [sym_tmp_fs_command] = "tmp_fs_command",
  [sym_tmp_reli_command] = "tmp_reli_command",
  [sym_tmp_kuery_command] = "tmp_kuery_command",
  [sym_tmp_fd_command] = "tmp_fd_command",
  [sym_tmp_reg_command] = "tmp_reg_command",
  [sym_tmp_file_command] = "tmp_file_command",
  [sym_tmp_string_command] = "tmp_string_command",
  [sym_tmp_hex_command] = "tmp_hex_command",
  [sym__interpreter_command] = "_interpreter_command",
  [sym_task_command] = "task_command",
  [sym_number_command] = "number_command",
  [sym_help_command] = "help_command",
  [sym_arged_command] = "arged_command",
  [sym__simple_arged_command] = "_simple_arged_command",
  [sym__search_command] = "arged_command",
  [sym__math_arged_command] = "_math_arged_command",
  [sym__pointer_arged_command] = "_pointer_arged_command",
  [sym__macro_arged_command] = "_macro_arged_command",
  [sym__system_command] = "_system_command",
  [sym__interpret_command] = "_interpret_command",
  [sym__interpret_search_identifier] = "cmd_identifier",
  [sym__pf_arged_command] = "_pf_arged_command",
  [sym__pf_commands] = "_pf_commands",
  [sym_Cf_cmd] = "arged_command",
  [sym__Cf_args] = "args",
  [sym_pf_new_cmd] = "arged_command",
  [sym_pf_dot_cmd] = "arged_command",
  [sym_pf_cmd] = "arged_command",
  [sym_pf_new_args] = "pf_new_args",
  [sym_pf_dot_cmd_args] = "pf_dot_cmd_args",
  [sym__pf_arg_parentheses] = "_pf_arg_parentheses",
  [sym__pf_arg] = "_pf_arg",
  [sym__pf_dot_arg] = "_pf_dot_arg",
  [sym_pf_concatenation] = "pf_concatenation",
  [sym_pf_dot_concatenation] = "pf_concatenation",
  [sym_pf_arg] = "pf_arg",
  [sym_pf_dot_arg] = "pf_arg",
  [sym_pf_args] = "pf_args",
  [sym_pf_dot_args] = "pf_args",
  [sym__env_command] = "_env_command",
  [sym__env_command_identifier] = "cmd_identifier",
  [sym_last_command] = "last_command",
  [sym_last_command_identifier] = "cmd_identifier",
  [sym__interpret_identifier] = "cmd_identifier",
  [sym_interpret_arg] = "interpret_arg",
  [sym_repeat_command] = "repeat_command",
  [sym_eq_sep_args] = "args",
  [sym_macro_call_content] = "macro_call_content",
  [sym_macro_call_full_content] = "macro_call_full_content",
  [sym_macro_content] = "macro_content",
  [sym_macro_args] = "macro_args",
  [sym_redirect_command] = "redirect_command",
  [sym__redirect_operator] = "_redirect_operator",
  [sym_fdn_redirect_operator] = "fdn_redirect_operator",
  [sym_fdn_append_operator] = "fdn_append_operator",
  [sym__arg] = "_arg",
  [sym__arg_brace] = "_arg_brace",
  [sym_arg] = "arg",
  [sym_arg_brace] = "arg",
  [sym_args] = "args",
  [sym_tmp_eval_args] = "tmp_eval_args",
  [sym_tmp_eval_arg] = "tmp_eval_arg",
  [sym__eq_sep_key_single] = "arg",
  [sym_eq_sep_key] = "args",
  [sym_eq_sep_val] = "args",
  [sym_double_quoted_arg] = "double_quoted_arg",
  [sym_single_quoted_arg] = "single_quoted_arg",
  [sym_cmd_substitution_arg] = "cmd_substitution_arg",
  [sym_concatenation] = "concatenation",
  [sym_concatenation_brace] = "concatenation",
  [sym__dec_number] = "_dec_number",
  [aux_sym_commands_repeat1] = "commands_repeat1",
  [aux_sym_commands_repeat2] = "commands_repeat2",
  [aux_sym__commands_singleline_repeat1] = "_commands_singleline_repeat1",
  [aux_sym__commands_singleline_repeat2] = "_commands_singleline_repeat2",
  [aux_sym_grep_specifier_repeat1] = "grep_specifier_repeat1",
  [aux_sym_foreach_addrsize_command_repeat1] = "foreach_addrsize_command_repeat1",
  [aux_sym_pf_concatenation_repeat1] = "pf_concatenation_repeat1",
  [aux_sym_pf_dot_concatenation_repeat1] = "pf_dot_concatenation_repeat1",
  [aux_sym_pf_args_repeat1] = "pf_args_repeat1",
  [aux_sym_pf_dot_args_repeat1] = "pf_dot_args_repeat1",
  [aux_sym_macro_content_repeat1] = "macro_content_repeat1",
  [aux_sym_args_repeat1] = "args_repeat1",
  [aux_sym_tmp_eval_args_repeat1] = "tmp_eval_args_repeat1",
  [aux_sym_tmp_eval_arg_repeat1] = "tmp_eval_arg_repeat1",
  [aux_sym_eq_sep_key_repeat1] = "eq_sep_key_repeat1",
  [aux_sym_eq_sep_val_repeat1] = "eq_sep_val_repeat1",
  [aux_sym_double_quoted_arg_repeat1] = "double_quoted_arg_repeat1",
  [aux_sym_single_quoted_arg_repeat1] = "single_quoted_arg_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_concatenation_brace_repeat1] = "concatenation_brace_repeat1",
  [alias_sym_number] = "number",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_legacy_quoted_command_token1] = aux_sym_legacy_quoted_command_token1,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [sym_grep_specifier_identifier] = sym_grep_specifier_identifier,
  [aux_sym_grep_specifier_token1] = sym_grep_specifier_identifier,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PIPEH] = anon_sym_PIPEH,
  [anon_sym_PIPET] = anon_sym_PIPET,
  [sym_pipe_second_command] = sym_pipe_second_command,
  [anon_sym_AT_AT_AT_EQ] = anon_sym_AT_AT_AT_EQ,
  [anon_sym_AT_AT_ATb] = anon_sym_AT_AT_ATb,
  [anon_sym_AT_AT_ATc_COLON] = anon_sym_AT_AT_ATc_COLON,
  [anon_sym_AT_AT_ATC_COLON] = anon_sym_AT_AT_ATC_COLON,
  [anon_sym_AT_AT_ATi] = anon_sym_AT_AT_ATi,
  [anon_sym_AT_AT_ATr] = anon_sym_AT_AT_ATr,
  [anon_sym_AT_AT_ATs] = anon_sym_AT_AT_ATs,
  [anon_sym_AT_AT_ATst] = anon_sym_AT_AT_ATst,
  [anon_sym_AT_AT_ATS] = anon_sym_AT_AT_ATS,
  [anon_sym_AT_AT_ATm] = anon_sym_AT_AT_ATm,
  [anon_sym_AT_AT_ATM] = anon_sym_AT_AT_ATM,
  [anon_sym_AT_AT_ATf] = anon_sym_AT_AT_ATf,
  [anon_sym_AT_AT_ATf_COLON] = anon_sym_AT_AT_ATf_COLON,
  [anon_sym_AT_AT_ATF] = anon_sym_AT_AT_ATF,
  [anon_sym_AT_AT_ATF_COLON] = anon_sym_AT_AT_ATF_COLON,
  [anon_sym_AT_AT_ATt] = anon_sym_AT_AT_ATt,
  [anon_sym_AT_AT] = anon_sym_AT_AT,
  [anon_sym_AT_ATdbt] = anon_sym_AT_ATdbt,
  [anon_sym_AT_ATdbta] = anon_sym_AT_ATdbta,
  [anon_sym_AT_ATdbtb] = anon_sym_AT_ATdbtb,
  [anon_sym_AT_ATdbts] = anon_sym_AT_ATdbts,
  [anon_sym_AT_AT_DOT] = anon_sym_AT_AT_DOT,
  [anon_sym_AT_AT_EQ] = anon_sym_AT_AT_EQ,
  [anon_sym_AT_ATk] = anon_sym_AT_ATk,
  [anon_sym_AT_ATt] = anon_sym_AT_ATt,
  [anon_sym_AT_ATb] = anon_sym_AT_ATb,
  [anon_sym_AT_ATi] = anon_sym_AT_ATi,
  [anon_sym_AT_ATiS] = anon_sym_AT_ATiS,
  [anon_sym_AT_ATf] = anon_sym_AT_ATf,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT_ATs_COLON] = anon_sym_AT_ATs_COLON,
  [anon_sym_AT_ATc_COLON] = anon_sym_AT_ATc_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_AT_BANG] = anon_sym_AT_BANG,
  [anon_sym_AT_LBRACE] = anon_sym_AT_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_ATa_COLON] = anon_sym_ATa_COLON,
  [anon_sym_ATb_COLON] = anon_sym_ATb_COLON,
  [anon_sym_ATB_COLON] = anon_sym_ATB_COLON,
  [anon_sym_ATe_COLON] = anon_sym_ATe_COLON,
  [anon_sym_ATF_COLON] = anon_sym_ATF_COLON,
  [anon_sym_ATi_COLON] = anon_sym_ATi_COLON,
  [anon_sym_ATk_COLON] = anon_sym_ATk_COLON,
  [anon_sym_ATo_COLON] = anon_sym_ATo_COLON,
  [anon_sym_ATr_COLON] = anon_sym_ATr_COLON,
  [anon_sym_ATf_COLON] = anon_sym_ATf_COLON,
  [anon_sym_ATs_COLON] = anon_sym_ATs_COLON,
  [anon_sym_ATx_COLON] = anon_sym_ATx_COLON,
  [anon_sym_POUND_BANG] = sym_cmd_identifier,
  [anon_sym_AMP] = sym_cmd_identifier,
  [anon_sym_AMPt] = sym_cmd_identifier,
  [aux_sym_task_command_token1] = sym_cmd_identifier,
  [anon_sym_0] = anon_sym_0,
  [aux_sym_number_command_token1] = aux_sym_number_command_token1,
  [anon_sym_POUND_QMARK] = sym_cmd_identifier,
  [anon_sym_POUND_BANG_QMARK] = sym_cmd_identifier,
  [aux_sym__search_command_token1] = sym_cmd_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_BANG] = sym_cmd_identifier,
  [anon_sym_DOT_LPAREN] = sym_cmd_identifier,
  [anon_sym_PIPE_DOT] = anon_sym_PIPE_DOT,
  [anon_sym_DOT_SLASH] = anon_sym_DOT_SLASH,
  [anon_sym_pfo] = sym_cmd_identifier,
  [anon_sym_Cf] = sym_cmd_identifier,
  [sym_pf_dot_cmd_identifier] = sym_cmd_identifier,
  [sym_pf_dot_full_cmd_identifier] = sym_cmd_identifier,
  [aux_sym_pf_cmd_token1] = sym_cmd_identifier,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym__pf_dot_arg_identifier] = sym_pf_arg_identifier,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_pf_arg_identifier] = sym_pf_arg_identifier,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_env] = anon_sym_env,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [aux_sym__interpret_identifier_token1] = aux_sym__interpret_identifier_token1,
  [aux_sym__interpret_identifier_token2] = aux_sym__interpret_identifier_token2,
  [sym_system_identifier] = sym_system_identifier,
  [sym_question_mark_identifier] = sym_cmd_identifier,
  [sym_pointer_identifier] = sym_cmd_identifier,
  [sym_macro_identifier] = sym_cmd_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [sym_html_redirect_operator] = sym_html_redirect_operator,
  [sym_html_append_operator] = sym_html_append_operator,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [aux_sym_tmp_eval_arg_token1] = aux_sym_tmp_eval_arg_token1,
  [sym__eq_sep_key_identifier] = sym_arg_identifier,
  [sym__any_command] = sym__any_command,
  [sym_arg_identifier] = sym_arg_identifier,
  [sym_arg_identifier_brace] = sym_arg_identifier,
  [aux_sym_double_quoted_arg_token1] = aux_sym_double_quoted_arg_token1,
  [aux_sym_double_quoted_arg_token2] = aux_sym_double_quoted_arg_token2,
  [aux_sym_double_quoted_arg_token3] = aux_sym_double_quoted_arg_token3,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_single_quoted_arg_token1] = aux_sym_single_quoted_arg_token1,
  [aux_sym_single_quoted_arg_token2] = aux_sym_single_quoted_arg_token2,
  [anon_sym_DOLLAR_LPAREN] = anon_sym_DOLLAR_LPAREN,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym__dec_number_token1] = aux_sym__dec_number_token1,
  [aux_sym__dec_number_token2] = aux_sym__dec_number_token2,
  [sym__comment] = sym__comment,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [sym_cmd_identifier] = sym_cmd_identifier,
  [sym__help_command] = sym_cmd_identifier,
  [sym_file_descriptor] = sym_file_descriptor,
  [sym__eq_sep_concat] = sym__eq_sep_concat,
  [sym__concat] = sym__concat,
  [sym__concat_brace] = sym__concat_brace,
  [sym__concat_pf_dot] = sym__concat_pf_dot,
  [sym_commands] = sym_commands,
  [sym__commands_singleline] = sym__commands_singleline,
  [sym__command] = sym__command,
  [sym_legacy_quoted_command] = sym_legacy_quoted_command,
  [sym__simple_command] = sym__simple_command,
  [sym__tmp_command] = sym__tmp_command,
  [sym__iter_command] = sym__iter_command,
  [sym__foreach_command] = sym__foreach_command,
  [sym__pipe_command] = sym__pipe_command,
  [sym_grep_command] = sym_grep_command,
  [sym_grep_specifier] = sym_grep_specifier,
  [sym_html_disable_command] = sym_html_disable_command,
  [sym_html_enable_command] = sym_html_enable_command,
  [sym_scr_tts_command] = sym_scr_tts_command,
  [sym_pipe_command] = sym_pipe_command,
  [sym_foreach_addrsize_command] = sym_foreach_addrsize_command,
  [sym_foreach_bb_command] = sym_foreach_bb_command,
  [sym_foreach_cmd_command] = sym_foreach_cmd_command,
  [sym_foreach_comment_command] = sym_foreach_comment_command,
  [sym_foreach_import_command] = sym_foreach_import_command,
  [sym_foreach_register_command] = sym_foreach_register_command,
  [sym_foreach_symbol_command] = sym_foreach_symbol_command,
  [sym_foreach_string_command] = sym_foreach_string_command,
  [sym_foreach_section_command] = sym_foreach_section_command,
  [sym_foreach_iomap_command] = sym_foreach_iomap_command,
  [sym_foreach_dbgmap_command] = sym_foreach_dbgmap_command,
  [sym_foreach_flag_command] = sym_foreach_flag_command,
  [sym_foreach_function_command] = sym_foreach_function_command,
  [sym_foreach_thread_command] = sym_foreach_thread_command,
  [sym_iter_flags_command] = sym_iter_flags_command,
  [sym_iter_dbta_command] = sym_iter_dbta_command,
  [sym_iter_dbtb_command] = sym_iter_dbtb_command,
  [sym_iter_dbts_command] = sym_iter_dbts_command,
  [sym_iter_file_lines_command] = sym_iter_file_lines_command,
  [sym_iter_offsets_command] = sym_iter_offsets_command,
  [sym_iter_sdbquery_command] = sym_iter_sdbquery_command,
  [sym_iter_threads_command] = sym_iter_threads_command,
  [sym_iter_bbs_command] = sym_iter_bbs_command,
  [sym_iter_instrs_command] = sym_iter_instrs_command,
  [sym_iter_sections_command] = sym_iter_sections_command,
  [sym_iter_functions_command] = sym_iter_functions_command,
  [sym_iter_step_command] = sym_iter_step_command,
  [sym_iter_interpret_command] = sym_iter_interpret_command,
  [sym_iter_hit_command] = sym_iter_hit_command,
  [sym_tmp_seek_command] = sym_tmp_seek_command,
  [sym_tmp_blksz_command] = sym_tmp_blksz_command,
  [sym_tmp_fromto_command] = sym_tmp_fromto_command,
  [sym_tmp_arch_command] = sym_tmp_arch_command,
  [sym_tmp_bits_command] = sym_tmp_bits_command,
  [sym_tmp_nthi_command] = sym_tmp_nthi_command,
  [sym_tmp_eval_command] = sym_tmp_eval_command,
  [sym_tmp_fs_command] = sym_tmp_fs_command,
  [sym_tmp_reli_command] = sym_tmp_reli_command,
  [sym_tmp_kuery_command] = sym_tmp_kuery_command,
  [sym_tmp_fd_command] = sym_tmp_fd_command,
  [sym_tmp_reg_command] = sym_tmp_reg_command,
  [sym_tmp_file_command] = sym_tmp_file_command,
  [sym_tmp_string_command] = sym_tmp_string_command,
  [sym_tmp_hex_command] = sym_tmp_hex_command,
  [sym__interpreter_command] = sym__interpreter_command,
  [sym_task_command] = sym_task_command,
  [sym_number_command] = sym_number_command,
  [sym_help_command] = sym_help_command,
  [sym_arged_command] = sym_arged_command,
  [sym__simple_arged_command] = sym__simple_arged_command,
  [sym__search_command] = sym_arged_command,
  [sym__math_arged_command] = sym__math_arged_command,
  [sym__pointer_arged_command] = sym__pointer_arged_command,
  [sym__macro_arged_command] = sym__macro_arged_command,
  [sym__system_command] = sym__system_command,
  [sym__interpret_command] = sym__interpret_command,
  [sym__interpret_search_identifier] = sym_cmd_identifier,
  [sym__pf_arged_command] = sym__pf_arged_command,
  [sym__pf_commands] = sym__pf_commands,
  [sym_Cf_cmd] = sym_arged_command,
  [sym__Cf_args] = sym_args,
  [sym_pf_new_cmd] = sym_arged_command,
  [sym_pf_dot_cmd] = sym_arged_command,
  [sym_pf_cmd] = sym_arged_command,
  [sym_pf_new_args] = sym_pf_new_args,
  [sym_pf_dot_cmd_args] = sym_pf_dot_cmd_args,
  [sym__pf_arg_parentheses] = sym__pf_arg_parentheses,
  [sym__pf_arg] = sym__pf_arg,
  [sym__pf_dot_arg] = sym__pf_dot_arg,
  [sym_pf_concatenation] = sym_pf_concatenation,
  [sym_pf_dot_concatenation] = sym_pf_concatenation,
  [sym_pf_arg] = sym_pf_arg,
  [sym_pf_dot_arg] = sym_pf_arg,
  [sym_pf_args] = sym_pf_args,
  [sym_pf_dot_args] = sym_pf_args,
  [sym__env_command] = sym__env_command,
  [sym__env_command_identifier] = sym_cmd_identifier,
  [sym_last_command] = sym_last_command,
  [sym_last_command_identifier] = sym_cmd_identifier,
  [sym__interpret_identifier] = sym_cmd_identifier,
  [sym_interpret_arg] = sym_interpret_arg,
  [sym_repeat_command] = sym_repeat_command,
  [sym_eq_sep_args] = sym_args,
  [sym_macro_call_content] = sym_macro_call_content,
  [sym_macro_call_full_content] = sym_macro_call_full_content,
  [sym_macro_content] = sym_macro_content,
  [sym_macro_args] = sym_macro_args,
  [sym_redirect_command] = sym_redirect_command,
  [sym__redirect_operator] = sym__redirect_operator,
  [sym_fdn_redirect_operator] = sym_fdn_redirect_operator,
  [sym_fdn_append_operator] = sym_fdn_append_operator,
  [sym__arg] = sym__arg,
  [sym__arg_brace] = sym__arg_brace,
  [sym_arg] = sym_arg,
  [sym_arg_brace] = sym_arg,
  [sym_args] = sym_args,
  [sym_tmp_eval_args] = sym_tmp_eval_args,
  [sym_tmp_eval_arg] = sym_tmp_eval_arg,
  [sym__eq_sep_key_single] = sym_arg,
  [sym_eq_sep_key] = sym_args,
  [sym_eq_sep_val] = sym_args,
  [sym_double_quoted_arg] = sym_double_quoted_arg,
  [sym_single_quoted_arg] = sym_single_quoted_arg,
  [sym_cmd_substitution_arg] = sym_cmd_substitution_arg,
  [sym_concatenation] = sym_concatenation,
  [sym_concatenation_brace] = sym_concatenation,
  [sym__dec_number] = sym__dec_number,
  [aux_sym_commands_repeat1] = aux_sym_commands_repeat1,
  [aux_sym_commands_repeat2] = aux_sym_commands_repeat2,
  [aux_sym__commands_singleline_repeat1] = aux_sym__commands_singleline_repeat1,
  [aux_sym__commands_singleline_repeat2] = aux_sym__commands_singleline_repeat2,
  [aux_sym_grep_specifier_repeat1] = aux_sym_grep_specifier_repeat1,
  [aux_sym_foreach_addrsize_command_repeat1] = aux_sym_foreach_addrsize_command_repeat1,
  [aux_sym_pf_concatenation_repeat1] = aux_sym_pf_concatenation_repeat1,
  [aux_sym_pf_dot_concatenation_repeat1] = aux_sym_pf_dot_concatenation_repeat1,
  [aux_sym_pf_args_repeat1] = aux_sym_pf_args_repeat1,
  [aux_sym_pf_dot_args_repeat1] = aux_sym_pf_dot_args_repeat1,
  [aux_sym_macro_content_repeat1] = aux_sym_macro_content_repeat1,
  [aux_sym_args_repeat1] = aux_sym_args_repeat1,
  [aux_sym_tmp_eval_args_repeat1] = aux_sym_tmp_eval_args_repeat1,
  [aux_sym_tmp_eval_arg_repeat1] = aux_sym_tmp_eval_arg_repeat1,
  [aux_sym_eq_sep_key_repeat1] = aux_sym_eq_sep_key_repeat1,
  [aux_sym_eq_sep_val_repeat1] = aux_sym_eq_sep_val_repeat1,
  [aux_sym_double_quoted_arg_repeat1] = aux_sym_double_quoted_arg_repeat1,
  [aux_sym_single_quoted_arg_repeat1] = aux_sym_single_quoted_arg_repeat1,
  [aux_sym_concatenation_repeat1] = aux_sym_concatenation_repeat1,
  [aux_sym_concatenation_brace_repeat1] = aux_sym_concatenation_brace_repeat1,
  [alias_sym_number] = alias_sym_number,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_legacy_quoted_command_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [sym_grep_specifier_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_grep_specifier_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPEH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPET] = {
    .visible = true,
    .named = false,
  },
  [sym_pipe_second_command] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT_AT_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATc_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATC_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATf_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATF_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_ATt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATdbt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATdbta] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATdbtb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATdbts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATk] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATiS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATs_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_ATc_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATa_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATb_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATB_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATe_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATF_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATi_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATk_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATo_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATr_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATf_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATs_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATx_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMPt] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_task_command_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_number_command_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_POUND_QMARK] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND_BANG_QMARK] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__search_command_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_BANG] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_LPAREN] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pfo] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_Cf] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_cmd_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_full_cmd_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_pf_cmd_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym__pf_dot_arg_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_pf_arg_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_env] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__interpret_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interpret_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_system_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_question_mark_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_html_redirect_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_html_append_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_tmp_eval_arg_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__eq_sep_key_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__any_command] = {
    .visible = false,
    .named = true,
  },
  [sym_arg_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_arg_identifier_brace] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_double_quoted_arg_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quoted_arg_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quoted_arg_token3] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_single_quoted_arg_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quoted_arg_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__dec_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__dec_number_token2] = {
    .visible = false,
    .named = false,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [sym_cmd_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__help_command] = {
    .visible = true,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__eq_sep_concat] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__concat_pf_dot] = {
    .visible = false,
    .named = true,
  },
  [sym_commands] = {
    .visible = true,
    .named = true,
  },
  [sym__commands_singleline] = {
    .visible = false,
    .named = true,
  },
  [sym__command] = {
    .visible = false,
    .named = true,
  },
  [sym_legacy_quoted_command] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_command] = {
    .visible = false,
    .named = true,
  },
  [sym__tmp_command] = {
    .visible = false,
    .named = true,
  },
  [sym__iter_command] = {
    .visible = false,
    .named = true,
  },
  [sym__foreach_command] = {
    .visible = false,
    .named = true,
  },
  [sym__pipe_command] = {
    .visible = false,
    .named = true,
  },
  [sym_grep_command] = {
    .visible = true,
    .named = true,
  },
  [sym_grep_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_html_disable_command] = {
    .visible = true,
    .named = true,
  },
  [sym_html_enable_command] = {
    .visible = true,
    .named = true,
  },
  [sym_scr_tts_command] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_addrsize_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_bb_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_cmd_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_comment_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_import_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_register_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_symbol_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_string_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_section_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_iomap_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_dbgmap_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_flag_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_function_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_thread_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_flags_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_dbta_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_dbtb_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_dbts_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_file_lines_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_offsets_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_sdbquery_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_threads_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_bbs_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_instrs_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_sections_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_functions_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_step_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_interpret_command] = {
    .visible = true,
    .named = true,
  },
  [sym_iter_hit_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_seek_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_blksz_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_fromto_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_arch_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_bits_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_nthi_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_eval_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_fs_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_reli_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_kuery_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_fd_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_reg_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_file_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_string_command] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_hex_command] = {
    .visible = true,
    .named = true,
  },
  [sym__interpreter_command] = {
    .visible = false,
    .named = true,
  },
  [sym_task_command] = {
    .visible = true,
    .named = true,
  },
  [sym_number_command] = {
    .visible = true,
    .named = true,
  },
  [sym_help_command] = {
    .visible = true,
    .named = true,
  },
  [sym_arged_command] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__search_command] = {
    .visible = true,
    .named = true,
  },
  [sym__math_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__pointer_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__macro_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__system_command] = {
    .visible = false,
    .named = true,
  },
  [sym__interpret_command] = {
    .visible = false,
    .named = true,
  },
  [sym__interpret_search_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__pf_arged_command] = {
    .visible = false,
    .named = true,
  },
  [sym__pf_commands] = {
    .visible = false,
    .named = true,
  },
  [sym_Cf_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym__Cf_args] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_new_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_cmd] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_new_args] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_cmd_args] = {
    .visible = true,
    .named = true,
  },
  [sym__pf_arg_parentheses] = {
    .visible = false,
    .named = true,
  },
  [sym__pf_arg] = {
    .visible = false,
    .named = true,
  },
  [sym__pf_dot_arg] = {
    .visible = false,
    .named = true,
  },
  [sym_pf_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_args] = {
    .visible = true,
    .named = true,
  },
  [sym_pf_dot_args] = {
    .visible = true,
    .named = true,
  },
  [sym__env_command] = {
    .visible = false,
    .named = true,
  },
  [sym__env_command_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_last_command] = {
    .visible = true,
    .named = true,
  },
  [sym_last_command_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__interpret_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interpret_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_command] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_sep_args] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_call_content] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_call_full_content] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_content] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_args] = {
    .visible = true,
    .named = true,
  },
  [sym_redirect_command] = {
    .visible = true,
    .named = true,
  },
  [sym__redirect_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_fdn_redirect_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_fdn_append_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__arg] = {
    .visible = false,
    .named = true,
  },
  [sym__arg_brace] = {
    .visible = false,
    .named = true,
  },
  [sym_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_arg_brace] = {
    .visible = true,
    .named = true,
  },
  [sym_args] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_eval_args] = {
    .visible = true,
    .named = true,
  },
  [sym_tmp_eval_arg] = {
    .visible = true,
    .named = true,
  },
  [sym__eq_sep_key_single] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_sep_key] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_sep_val] = {
    .visible = true,
    .named = true,
  },
  [sym_double_quoted_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quoted_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_cmd_substitution_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation_brace] = {
    .visible = true,
    .named = true,
  },
  [sym__dec_number] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_commands_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_commands_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__commands_singleline_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__commands_singleline_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grep_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_foreach_addrsize_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pf_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pf_dot_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pf_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pf_dot_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_macro_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tmp_eval_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tmp_eval_arg_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_eq_sep_key_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_eq_sep_val_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_quoted_arg_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_quoted_arg_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_brace_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_number] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_arg = 1,
  field_args = 2,
  field_command = 3,
  field_name = 4,
  field_redirect_operator = 5,
  field_specifier = 6,
  field_string = 7,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_args] = "args",
  [field_command] = "command",
  [field_name] = "name",
  [field_redirect_operator] = "redirect_operator",
  [field_specifier] = "specifier",
  [field_string] = "string",
};

static const TSFieldMapSlice ts_field_map_slices[18] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 3, .length = 2},
  [6] = {.index = 5, .length = 2},
  [7] = {.index = 7, .length = 2},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 2},
  [10] = {.index = 12, .length = 1},
  [11] = {.index = 13, .length = 2},
  [12] = {.index = 15, .length = 3},
  [16] = {.index = 18, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_command, 0},
  [1] =
    {field_args, 0, .inherited = true},
    {field_command, 0, .inherited = true},
  [3] =
    {field_args, 1},
    {field_command, 0},
  [5] =
    {field_args, 0},
    {field_command, 1},
  [7] =
    {field_arg, 0},
    {field_command, 1},
  [9] =
    {field_string, 1},
  [10] =
    {field_args, 2},
    {field_command, 0},
  [12] =
    {field_name, 0},
  [13] =
    {field_command, 0},
    {field_specifier, 2},
  [15] =
    {field_arg, 2},
    {field_command, 0},
    {field_redirect_operator, 1},
  [18] =
    {field_args, 3, .inherited = true},
    {field_command, 3, .inherited = true},
};

static TSSymbol ts_alias_sequences[18][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [0] = sym_arg_identifier,
  },
  [5] = {
    [0] = sym_cmd_identifier,
  },
  [7] = {
    [0] = alias_sym_number,
  },
  [13] = {
    [0] = sym_arg_identifier,
    [2] = sym_arg_identifier,
  },
  [14] = {
    [0] = sym_pf_arg_identifier,
    [2] = sym_pf_arg_identifier,
  },
  [15] = {
    [1] = sym_arg_identifier,
  },
  [17] = {
    [1] = sym_pf_arg_identifier,
  },
};

static inline bool sym_grep_specifier_identifier_character_set_1(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == '#' ||
    lookahead == '(' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '`' ||
    lookahead == '|';
}

static inline bool sym_grep_specifier_identifier_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == '#' ||
    lookahead == '(' ||
    lookahead == ')' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|';
}

static inline bool sym__pf_dot_arg_identifier_character_set_2(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == '.' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('|' <= lookahead && lookahead <= '~');
}

static inline bool sym__pf_dot_arg_identifier_character_set_3(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == '.' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__pf_dot_arg_identifier_character_set_4(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == '.' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym_pf_arg_identifier_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym_pf_arg_identifier_character_set_3(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__eq_sep_key_identifier_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '\\' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym_arg_identifier_character_set_1(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('|' <= lookahead && lookahead <= '~');
}

static inline bool sym_arg_identifier_character_set_2(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym_arg_identifier_character_set_3(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym_arg_identifier_brace_character_set_1(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('{' <= lookahead && lookahead <= '~');
}

static inline bool sym_arg_identifier_brace_character_set_2(int32_t lookahead) {
  return
    lookahead == 0 ||
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('|' <= lookahead && lookahead <= '~');
}

static inline bool sym_arg_identifier_brace_character_set_3(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    ('{' <= lookahead && lookahead <= '~');
}

static inline bool sym__comment_character_set_1(int32_t lookahead) {
  return
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == '#' ||
    lookahead == '(' ||
    lookahead == ')' ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|';
}

static inline bool sym__comment_character_set_2(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ';' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static inline bool sym__comment_character_set_3(int32_t lookahead) {
  return
    lookahead == '\t' ||
    lookahead == '\n' ||
    lookahead == '\r' ||
    lookahead == ' ' ||
    lookahead == '"' ||
    lookahead == '#' ||
    ('\'' <= lookahead && lookahead <= ')') ||
    lookahead == ',' ||
    lookahead == ';' ||
    lookahead == '=' ||
    lookahead == '>' ||
    lookahead == '@' ||
    lookahead == '\\' ||
    lookahead == '`' ||
    lookahead == '|' ||
    lookahead == '~';
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(416);
      if (lookahead == '$') ADVANCE(117);
      if (lookahead == '%') ADVANCE(316);
      if (lookahead == '&') ADVANCE(248);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(294);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == '*') ADVANCE(325);
      if (lookahead == ',') ADVANCE(337);
      if (lookahead == '.') ADVANCE(263);
      if (lookahead == '/') ADVANCE(257);
      if (lookahead == '0') ADVANCE(251);
      if (lookahead == ':') ADVANCE(210);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '=') ADVANCE(274);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '?') ADVANCE(324);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'H') ADVANCE(340);
      if (lookahead == '\\') ADVANCE(399);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '}') ADVANCE(221);
      if (lookahead == '~') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(0)
      if (lookahead != 0) ADVANCE(338);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '*') ADVANCE(371);
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(376);
      if (lookahead != 0) ADVANCE(372);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '*') ADVANCE(309);
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(315);
      if (lookahead != 0) ADVANCE(311);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(293);
      if (lookahead != 0) ADVANCE(289);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '*') ADVANCE(312);
      if (lookahead != 0) ADVANCE(315);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '*') ADVANCE(385);
      if (lookahead != 0) ADVANCE(388);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(361);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(294);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == ',') ADVANCE(337);
      if (lookahead == '/') ADVANCE(364);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '\\') ADVANCE(77);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(8)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(369);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(342);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(9)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '\\' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(346);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(379);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(294);
      if (lookahead == ',') ADVANCE(337);
      if (lookahead == '/') ADVANCE(381);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(10)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(384);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(394);
      if (lookahead == '$') ADVANCE(397);
      if (lookahead == '/') ADVANCE(393);
      if (lookahead == '\\') ADVANCE(399);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(390);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(395);
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(299);
      if (lookahead == '(') ADVANCE(294);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == '/') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(78);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(12)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(308);
      END_STATE();
    case 13:
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(118);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(106);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '|') ADVANCE(109);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(278);
      if (lookahead == '/') ADVANCE(281);
      if (lookahead == '\\') ADVANCE(80);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(14)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != '.' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(286);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '/') ADVANCE(257);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(16)
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < '"' || '$' < lookahead) &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '\\' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(338);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == ')') ADVANCE(296);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '@') ADVANCE(216);
      if (lookahead == 'H') ADVANCE(147);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(124);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(151);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '@') ADVANCE(216);
      if (lookahead == 'H') ADVANCE(147);
      if (lookahead == '`') ADVANCE(412);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(151);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(406);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '/') ADVANCE(405);
      if (lookahead == '\\') ADVANCE(409);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(402);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(407);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(352);
      if (lookahead == '/') ADVANCE(354);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(353);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(358);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(418);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == '\\') ADVANCE(76);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(98);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(100);
      END_STATE();
    case 22:
      if (lookahead == '(') ADVANCE(410);
      if (lookahead == '{') ADVANCE(82);
      if (lookahead != 0) ADVANCE(346);
      END_STATE();
    case 23:
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == '*') ADVANCE(347);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0) ADVANCE(351);
      END_STATE();
    case 24:
      if (lookahead == '*') ADVANCE(26);
      END_STATE();
    case 25:
      if (lookahead == '*') ADVANCE(25);
      if (lookahead == '/') ADVANCE(415);
      if (lookahead != 0) ADVANCE(26);
      END_STATE();
    case 26:
      if (lookahead == '*') ADVANCE(25);
      if (lookahead != 0) ADVANCE(26);
      END_STATE();
    case 27:
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(419);
      if (lookahead == '}') ADVANCE(376);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(28);
      END_STATE();
    case 28:
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '}') ADVANCE(376);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(28);
      END_STATE();
    case 29:
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == '#' ||
          lookahead == '(' ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '`' ||
          lookahead == '|') ADVANCE(26);
      if (lookahead != 0) ADVANCE(114);
      END_STATE();
    case 30:
      if (lookahead == '*') ADVANCE(30);
      if (lookahead == '/') ADVANCE(420);
      if (lookahead == '}') ADVANCE(315);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 31:
      if (lookahead == '*') ADVANCE(30);
      if (lookahead == '}') ADVANCE(315);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 32:
      if (lookahead == '*') ADVANCE(32);
      if (lookahead == '/') ADVANCE(421);
      if (lookahead == '}') ADVANCE(351);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 33:
      if (lookahead == '*') ADVANCE(32);
      if (lookahead == '}') ADVANCE(351);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 34:
      if (lookahead == '*') ADVANCE(32);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(26);
      if (lookahead != 0) ADVANCE(33);
      END_STATE();
    case 35:
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '/') ADVANCE(422);
      if (lookahead == '}') ADVANCE(388);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(36);
      END_STATE();
    case 36:
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '}') ADVANCE(388);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '*') ADVANCE(35);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(26);
      if (lookahead != 0) ADVANCE(36);
      END_STATE();
    case 38:
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == '/') ADVANCE(423);
      if (lookahead == '}') ADVANCE(293);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 39:
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == '}') ADVANCE(293);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$') ADVANCE(26);
      if (lookahead != 0) ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == '.') ADVANCE(271);
      END_STATE();
    case 41:
      if (lookahead == ':') ADVANCE(226);
      END_STATE();
    case 42:
      if (lookahead == ':') ADVANCE(230);
      END_STATE();
    case 43:
      if (lookahead == ':') ADVANCE(222);
      END_STATE();
    case 44:
      if (lookahead == ':') ADVANCE(224);
      END_STATE();
    case 45:
      if (lookahead == ':') ADVANCE(228);
      END_STATE();
    case 46:
      if (lookahead == ':') ADVANCE(240);
      END_STATE();
    case 47:
      if (lookahead == ':') ADVANCE(232);
      END_STATE();
    case 48:
      if (lookahead == ':') ADVANCE(234);
      END_STATE();
    case 49:
      if (lookahead == ':') ADVANCE(236);
      END_STATE();
    case 50:
      if (lookahead == ':') ADVANCE(238);
      END_STATE();
    case 51:
      if (lookahead == ':') ADVANCE(242);
      END_STATE();
    case 52:
      if (lookahead == ':') ADVANCE(244);
      END_STATE();
    case 53:
      if (lookahead == ':') ADVANCE(213);
      END_STATE();
    case 54:
      if (lookahead == ':') ADVANCE(211);
      END_STATE();
    case 55:
      if (lookahead == ':') ADVANCE(158);
      END_STATE();
    case 56:
      if (lookahead == ':') ADVANCE(156);
      END_STATE();
    case 57:
      if (lookahead == '=') ADVANCE(152);
      if (lookahead == 'C') ADVANCE(55);
      if (lookahead == 'F') ADVANCE(178);
      if (lookahead == 'M') ADVANCE(172);
      if (lookahead == 'S') ADVANCE(168);
      if (lookahead == 'b') ADVANCE(154);
      if (lookahead == 'c') ADVANCE(56);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(160);
      if (lookahead == 'm') ADVANCE(170);
      if (lookahead == 'r') ADVANCE(162);
      if (lookahead == 's') ADVANCE(164);
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 58:
      if (lookahead == '>') ADVANCE(333);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(63);
      END_STATE();
    case 60:
      if (lookahead == 'f') ADVANCE(269);
      END_STATE();
    case 61:
      if (lookahead == 'f') ADVANCE(272);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(64);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 64:
      if (lookahead == 'v') ADVANCE(317);
      END_STATE();
    case 65:
      if (lookahead == '{') ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(346);
      END_STATE();
    case 66:
      if (lookahead == '}') ADVANCE(369);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(66);
      END_STATE();
    case 67:
      if (lookahead == '}') ADVANCE(308);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(67);
      END_STATE();
    case 68:
      if (lookahead == '}') ADVANCE(346);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(68);
      END_STATE();
    case 69:
      if (lookahead == '}') ADVANCE(384);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(69);
      END_STATE();
    case 70:
      if (lookahead == '}') ADVANCE(286);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(70);
      END_STATE();
    case 71:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(253);
      END_STATE();
    case 72:
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(369);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(366);
      END_STATE();
    case 73:
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(308);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(304);
      END_STATE();
    case 74:
      if (lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '$' ||
          lookahead == '}') ADVANCE(286);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(283);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(254);
      END_STATE();
    case 76:
      if (lookahead != 0) ADVANCE(100);
      END_STATE();
    case 77:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(369);
      END_STATE();
    case 78:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(308);
      END_STATE();
    case 79:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(384);
      END_STATE();
    case 80:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(286);
      END_STATE();
    case 81:
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(97);
      if (lookahead == '*') ADVANCE(96);
      END_STATE();
    case 82:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$' &&
          lookahead != '}') ADVANCE(68);
      END_STATE();
    case 83:
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$' &&
          lookahead != '}') ADVANCE(69);
      END_STATE();
    case 84:
      if (!sym_grep_specifier_identifier_character_set_1(lookahead)) ADVANCE(109);
      END_STATE();
    case 85:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '!') ADVANCE(323);
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(416);
      if (lookahead == '%') ADVANCE(316);
      if (lookahead == '&') ADVANCE(247);
      if (lookahead == '(') ADVANCE(327);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == '*') ADVANCE(325);
      if (lookahead == '.') ADVANCE(262);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '0') ADVANCE(252);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '?') ADVANCE(324);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'C') ADVANCE(60);
      if (lookahead == 'H') ADVANCE(58);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 'p') ADVANCE(61);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(85)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(413);
      END_STATE();
    case 86:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(361);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == '(') ADVANCE(294);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == ',') ADVANCE(337);
      if (lookahead == '/') ADVANCE(364);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'H') ADVANCE(368);
      if (lookahead == '\\') ADVANCE(77);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(86)
      if (lookahead != 0) ADVANCE(369);
      END_STATE();
    case 87:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(342);
      if (lookahead == '\'') ADVANCE(400);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'H') ADVANCE(343);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(87)
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != ',' &&
          lookahead != '=' &&
          lookahead != '\\') ADVANCE(346);
      END_STATE();
    case 88:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '"') ADVANCE(95);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '(') ADVANCE(294);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == ',') ADVANCE(337);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'H') ADVANCE(340);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(88)
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(338);
      END_STATE();
    case 89:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(299);
      if (lookahead == '(') ADVANCE(294);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == '/') ADVANCE(302);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '=') ADVANCE(275);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'H') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(78);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(89)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'') ADVANCE(308);
      END_STATE();
    case 90:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(299);
      if (lookahead == '(') ADVANCE(294);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == '/') ADVANCE(302);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'H') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(78);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(90)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'') ADVANCE(308);
      END_STATE();
    case 91:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == '$') ADVANCE(118);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'H') ADVANCE(108);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(102);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(105);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(109);
      END_STATE();
    case 92:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '#') ADVANCE(426);
      if (lookahead == ')') ADVANCE(295);
      if (lookahead == '.') ADVANCE(261);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == ':') ADVANCE(210);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '=') ADVANCE(274);
      if (lookahead == '>') ADVANCE(329);
      if (lookahead == '@') ADVANCE(215);
      if (lookahead == 'H') ADVANCE(58);
      if (lookahead == '`') ADVANCE(411);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '}') ADVANCE(221);
      if (lookahead == '~') ADVANCE(101);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(92)
      END_STATE();
    case 93:
      if (eof) ADVANCE(94);
      if (lookahead == '\n') ADVANCE(427);
      if (lookahead == '\r') ADVANCE(428);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == ';') ADVANCE(328);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '@') ADVANCE(216);
      if (lookahead == 'H') ADVANCE(147);
      if (lookahead == '|') ADVANCE(120);
      if (lookahead == '~') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(126);
      if (lookahead != 0) ADVANCE(151);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '"') ADVANCE(26);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '/') ADVANCE(415);
      if (lookahead == '\\') ADVANCE(81);
      if (lookahead != 0) ADVANCE(97);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '"') ADVANCE(26);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(81);
      if (lookahead != 0) ADVANCE(97);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '#') ADVANCE(418);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == '\\') ADVANCE(76);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(98);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(100);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '\\') ADVANCE(76);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(100);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_legacy_quoted_command_token1);
      if (lookahead == '\\') ADVANCE(76);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(100);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(111);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(109);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '$') ADVANCE(115);
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(104);
      if (lookahead == '\r' ||
          lookahead == '#' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          lookahead == '|') ADVANCE(114);
      if (lookahead != 0) ADVANCE(114);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(118);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == 'H') ADVANCE(108);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead == '~') ADVANCE(102);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(105);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(109);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(118);
      if (lookahead == '/') ADVANCE(107);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(106);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(109);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '*') ADVANCE(114);
      if (lookahead == '\\') ADVANCE(111);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(109);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '>') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ';' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '|') ADVANCE(109);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(111);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(110);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead == ')' ||
          lookahead == '@') ADVANCE(109);
      if (!sym_grep_specifier_identifier_character_set_1(lookahead)) ADVANCE(109);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(110);
      if (lookahead == '\\') ADVANCE(111);
      if (lookahead == '\r' ||
          lookahead == '#' ||
          lookahead == '(' ||
          lookahead == ')' ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          lookahead == '|') ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(109);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(119);
      if (lookahead == '\\') ADVANCE(111);
      if (!sym_grep_specifier_identifier_character_set_2(lookahead)) ADVANCE(109);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '/') ADVANCE(109);
      if (lookahead == '\\') ADVANCE(104);
      if (sym__comment_character_set_1(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(114);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(104);
      if (sym__comment_character_set_1(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(114);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_grep_specifier_identifier);
      if (lookahead == '$') ADVANCE(115);
      if (lookahead == '*') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(104);
      if (lookahead == ')' ||
          lookahead == '@') ADVANCE(114);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == '#' ||
          lookahead == '(' ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '`' ||
          lookahead == '|') ADVANCE(26);
      if (lookahead != 0) ADVANCE(114);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_grep_specifier_token1);
      if (lookahead == '$') ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_grep_specifier_token1);
      if (lookahead == '$') ADVANCE(116);
      if (lookahead == '(') ADVANCE(410);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_grep_specifier_token1);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '(') ADVANCE(410);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '#' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '`' &&
          lookahead != '|') ADVANCE(109);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_grep_specifier_token1);
      if (lookahead == '$') ADVANCE(112);
      if (!sym_grep_specifier_identifier_character_set_1(lookahead)) ADVANCE(109);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '.') ADVANCE(266);
      if (lookahead == 'H') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(122);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_PIPEH);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PIPET);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '!') ADVANCE(151);
      if (lookahead == ';' ||
          lookahead == '|') ADVANCE(424);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(150);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == ')') ADVANCE(296);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '@') ADVANCE(216);
      if (lookahead == 'H') ADVANCE(147);
      if (lookahead == '~') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(124);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '@') ADVANCE(216);
      if (lookahead == 'H') ADVANCE(147);
      if (lookahead == '`') ADVANCE(412);
      if (lookahead == '~') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '#') ADVANCE(123);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead == '>') ADVANCE(330);
      if (lookahead == '@') ADVANCE(216);
      if (lookahead == 'H') ADVANCE(147);
      if (lookahead == '~') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(126);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '*') ADVANCE(129);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '*') ADVANCE(128);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ';' ||
          lookahead == '|') ADVANCE(26);
      if (lookahead != 0) ADVANCE(129);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '*') ADVANCE(128);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ';' ||
          lookahead == '|') ADVANCE(26);
      if (lookahead != 0) ADVANCE(129);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(227);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(231);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(223);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(225);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(229);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(241);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(233);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(235);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(237);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(239);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(243);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(245);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(214);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(212);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ':') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '=') ADVANCE(153);
      if (lookahead == 'C') ADVANCE(144);
      if (lookahead == 'F') ADVANCE(179);
      if (lookahead == 'M') ADVANCE(173);
      if (lookahead == 'S') ADVANCE(169);
      if (lookahead == 'b') ADVANCE(155);
      if (lookahead == 'c') ADVANCE(145);
      if (lookahead == 'f') ADVANCE(175);
      if (lookahead == 'i') ADVANCE(161);
      if (lookahead == 'm') ADVANCE(171);
      if (lookahead == 'r') ADVANCE(163);
      if (lookahead == 's') ADVANCE(165);
      if (lookahead == 't') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == '>') ADVANCE(334);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == 'b') ADVANCE(149);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == 't') ADVANCE(187);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead == ';' ||
          lookahead == '|') ADVANCE(424);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_pipe_second_command);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_AT_AT_AT_EQ);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_AT_AT_AT_EQ);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATb);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATb);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATc_COLON);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATc_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATC_COLON);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATC_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATi);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATi);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATr);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATr);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATs);
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATs);
      if (lookahead == 't') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATst);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATst);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATS);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATS);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATm);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATm);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATM);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATM);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATf);
      if (lookahead == ':') ADVANCE(176);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATf);
      if (lookahead == ':') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATf_COLON);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATf_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATF);
      if (lookahead == ':') ADVANCE(180);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATF);
      if (lookahead == ':') ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATF_COLON);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATF_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATt);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_AT_AT_ATt);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      if (lookahead == '.') ADVANCE(194);
      if (lookahead == '=') ADVANCE(196);
      if (lookahead == '@') ADVANCE(57);
      if (lookahead == 'b') ADVANCE(202);
      if (lookahead == 'c') ADVANCE(53);
      if (lookahead == 'd') ADVANCE(59);
      if (lookahead == 'f') ADVANCE(208);
      if (lookahead == 'i') ADVANCE(204);
      if (lookahead == 'k') ADVANCE(198);
      if (lookahead == 's') ADVANCE(54);
      if (lookahead == 't') ADVANCE(200);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      if (lookahead == '.') ADVANCE(195);
      if (lookahead == '=') ADVANCE(197);
      if (lookahead == '@') ADVANCE(146);
      if (lookahead == 'b') ADVANCE(203);
      if (lookahead == 'c') ADVANCE(142);
      if (lookahead == 'd') ADVANCE(148);
      if (lookahead == 'f') ADVANCE(209);
      if (lookahead == 'i') ADVANCE(205);
      if (lookahead == 'k') ADVANCE(199);
      if (lookahead == 's') ADVANCE(143);
      if (lookahead == 't') ADVANCE(201);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_AT_ATdbt);
      if (lookahead == 'a') ADVANCE(188);
      if (lookahead == 'b') ADVANCE(190);
      if (lookahead == 's') ADVANCE(192);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_AT_ATdbt);
      if (lookahead == 'a') ADVANCE(189);
      if (lookahead == 'b') ADVANCE(191);
      if (lookahead == 's') ADVANCE(193);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_AT_ATdbta);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_AT_ATdbta);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_AT_ATdbtb);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_AT_ATdbtb);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_AT_ATdbts);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_AT_ATdbts);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_AT_AT_DOT);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_AT_AT_DOT);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_AT_AT_EQ);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_AT_AT_EQ);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_AT_ATk);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_AT_ATk);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_AT_ATt);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_AT_ATt);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_AT_ATb);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_AT_ATb);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_AT_ATi);
      if (lookahead == 'S') ADVANCE(206);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_AT_ATi);
      if (lookahead == 'S') ADVANCE(207);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_AT_ATiS);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_AT_ATiS);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_AT_ATf);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_AT_ATf);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_AT_ATs_COLON);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_AT_ATs_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_AT_ATc_COLON);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_AT_ATc_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '!') ADVANCE(217);
      if (lookahead == '@') ADVANCE(184);
      if (lookahead == 'B') ADVANCE(41);
      if (lookahead == 'F') ADVANCE(42);
      if (lookahead == 'a') ADVANCE(43);
      if (lookahead == 'b') ADVANCE(44);
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'f') ADVANCE(46);
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 'k') ADVANCE(48);
      if (lookahead == 'o') ADVANCE(49);
      if (lookahead == 'r') ADVANCE(50);
      if (lookahead == 's') ADVANCE(51);
      if (lookahead == 'x') ADVANCE(52);
      if (lookahead == '{') ADVANCE(219);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '!') ADVANCE(218);
      if (lookahead == '@') ADVANCE(185);
      if (lookahead == 'B') ADVANCE(130);
      if (lookahead == 'F') ADVANCE(131);
      if (lookahead == 'a') ADVANCE(132);
      if (lookahead == 'b') ADVANCE(133);
      if (lookahead == 'e') ADVANCE(134);
      if (lookahead == 'f') ADVANCE(135);
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'k') ADVANCE(137);
      if (lookahead == 'o') ADVANCE(138);
      if (lookahead == 'r') ADVANCE(139);
      if (lookahead == 's') ADVANCE(140);
      if (lookahead == 'x') ADVANCE(141);
      if (lookahead == '{') ADVANCE(220);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_AT_BANG);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_AT_BANG);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_AT_LBRACE);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_AT_LBRACE);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_ATa_COLON);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_ATa_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_ATb_COLON);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_ATb_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_ATB_COLON);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_ATB_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_ATe_COLON);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_ATe_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_ATF_COLON);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_ATF_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_ATi_COLON);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_ATi_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_ATk_COLON);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_ATk_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_ATo_COLON);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_ATo_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_ATr_COLON);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_ATr_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_ATf_COLON);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_ATf_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_ATs_COLON);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_ATs_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_ATx_COLON);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_ATx_COLON);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      if (lookahead == '?') ADVANCE(256);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == 't') ADVANCE(249);
      if (lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_AMPt);
      if (lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(aux_sym_task_command_token1);
      if (lookahead == '&' ||
          lookahead == '*' ||
          lookahead == '+' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_0);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == 'b') ADVANCE(71);
      if (lookahead == 'x') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(414);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(aux_sym_number_command_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(253);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(aux_sym_number_command_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(254);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(424);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_POUND_BANG_QMARK);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(aux_sym__search_command_token1);
      if (lookahead == '*') ADVANCE(259);
      if (lookahead == '!' ||
          lookahead == '+' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(260);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(aux_sym__search_command_token1);
      if (lookahead == '*') ADVANCE(258);
      if (lookahead == '/') ADVANCE(260);
      if (lookahead == '!' ||
          lookahead == '+' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      if (lookahead != 0) ADVANCE(26);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(aux_sym__search_command_token1);
      if (lookahead == '*') ADVANCE(258);
      if (lookahead == '!' ||
          lookahead == '+' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(259);
      if (lookahead != 0) ADVANCE(26);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(aux_sym__search_command_token1);
      if (lookahead == '!' ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(260);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == ' ') ADVANCE(322);
      if (lookahead == '!') ADVANCE(264);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '.') ADVANCE(320);
      if (lookahead == '/') ADVANCE(267);
      if (lookahead == '*' ||
          lookahead == '-' ||
          lookahead == ':') ADVANCE(321);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '(') ADVANCE(265);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_DOT_BANG);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_DOT_LPAREN);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_PIPE_DOT);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_DOT_SLASH);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_pfo);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_Cf);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_pf_dot_cmd_identifier);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_pf_dot_full_cmd_identifier);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(aux_sym_pf_cmd_token1);
      if (lookahead == '.') ADVANCE(270);
      if (lookahead == 'o') ADVANCE(268);
      if (lookahead == 'v') ADVANCE(40);
      if (lookahead == '*' ||
          lookahead == 'c' ||
          lookahead == 'j' ||
          lookahead == 'q' ||
          lookahead == 's') ADVANCE(273);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(aux_sym_pf_cmd_token1);
      if (lookahead == '.') ADVANCE(271);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(78);
      if (!sym_pf_arg_identifier_character_set_2(lookahead)) ADVANCE(308);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '\\') ADVANCE(276);
      if (lookahead == '}') ADVANCE(293);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(293);
      if (sym__pf_dot_arg_identifier_character_set_2(lookahead)) ADVANCE(289);
      if (lookahead != 0) ADVANCE(289);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead == '/') ADVANCE(291);
      if (lookahead == '\\') ADVANCE(277);
      if (sym__pf_dot_arg_identifier_character_set_3(lookahead)) ADVANCE(293);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '(') ADVANCE(410);
      if (lookahead == '/') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(80);
      if (lookahead == '{') ADVANCE(283);
      if (lookahead == '.' ||
          lookahead == '=') ADVANCE(286);
      if (!sym_pf_arg_identifier_character_set_2(lookahead)) ADVANCE(286);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '*') ADVANCE(286);
      if (lookahead == '/') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(284);
      if (sym__pf_dot_arg_identifier_character_set_4(lookahead)) ADVANCE(286);
      if (lookahead != 0) ADVANCE(286);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '*') ADVANCE(283);
      if (lookahead == '/') ADVANCE(280);
      if (lookahead == '\\') ADVANCE(282);
      if (lookahead == '}') ADVANCE(286);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(286);
      if (sym__pf_dot_arg_identifier_character_set_2(lookahead)) ADVANCE(283);
      if (lookahead != 0) ADVANCE(283);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '*') ADVANCE(293);
      if (lookahead == '/') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(284);
      if (sym__pf_dot_arg_identifier_character_set_4(lookahead)) ADVANCE(286);
      if (lookahead != 0) ADVANCE(286);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '/') ADVANCE(280);
      if (lookahead == '\\') ADVANCE(282);
      if (lookahead == '}') ADVANCE(286);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(286);
      if (sym__pf_dot_arg_identifier_character_set_2(lookahead)) ADVANCE(283);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(283);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '/') ADVANCE(280);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == '}') ADVANCE(286);
      if (sym__pf_dot_arg_identifier_character_set_2(lookahead)) ADVANCE(70);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(283);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '/') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(284);
      if (sym__pf_dot_arg_identifier_character_set_3(lookahead)) ADVANCE(286);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(286);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '/') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(80);
      if (lookahead == '{') ADVANCE(283);
      if (lookahead == '.' ||
          lookahead == '=') ADVANCE(286);
      if (!sym_pf_arg_identifier_character_set_2(lookahead)) ADVANCE(286);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(285);
      if (lookahead == '/') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(80);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != '.' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(286);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '/') ADVANCE(280);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '}') ADVANCE(293);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(26);
      if (sym__pf_dot_arg_identifier_character_set_2(lookahead)) ADVANCE(39);
      if (lookahead != 0) ADVANCE(289);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '\\') ADVANCE(276);
      if (lookahead == '}') ADVANCE(293);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(293);
      if (sym__pf_dot_arg_identifier_character_set_2(lookahead)) ADVANCE(289);
      if (lookahead != 0) ADVANCE(289);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(287);
      if (lookahead == '/') ADVANCE(288);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '}') ADVANCE(293);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(26);
      if (sym__pf_dot_arg_identifier_character_set_2(lookahead)) ADVANCE(39);
      if (lookahead != 0) ADVANCE(289);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead == '/') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(7);
      if (sym__pf_dot_arg_identifier_character_set_4(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead == '/') ADVANCE(291);
      if (lookahead == '\\') ADVANCE(277);
      if (sym__pf_dot_arg_identifier_character_set_4(lookahead)) ADVANCE(293);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead == '/') ADVANCE(291);
      if (lookahead == '\\') ADVANCE(7);
      if (lookahead == '{') ADVANCE(289);
      if (lookahead == '.' ||
          lookahead == '=') ADVANCE(293);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym__pf_dot_arg_identifier);
      if (lookahead == '$') ADVANCE(292);
      if (lookahead == '*') ADVANCE(290);
      if (lookahead == '/') ADVANCE(291);
      if (lookahead == '\\') ADVANCE(7);
      if (sym__pf_dot_arg_identifier_character_set_4(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(293);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(309);
      if (lookahead == '/') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(297);
      if (lookahead == '}') ADVANCE(315);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(315);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(311);
      if (lookahead != 0) ADVANCE(311);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(312);
      if (lookahead == '/') ADVANCE(313);
      if (lookahead == '\\') ADVANCE(298);
      if (sym_pf_arg_identifier_character_set_3(lookahead)) ADVANCE(315);
      if (lookahead != 0) ADVANCE(315);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '(') ADVANCE(410);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(78);
      if (lookahead == '{') ADVANCE(304);
      if (!sym_pf_arg_identifier_character_set_2(lookahead)) ADVANCE(308);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '*') ADVANCE(308);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(306);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(308);
      if (lookahead != 0) ADVANCE(308);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '*') ADVANCE(304);
      if (lookahead == '/') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(303);
      if (lookahead == '}') ADVANCE(308);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(308);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(304);
      if (lookahead != 0) ADVANCE(304);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '*') ADVANCE(315);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(306);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(308);
      if (lookahead != 0) ADVANCE(308);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '/') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(303);
      if (lookahead == '}') ADVANCE(308);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(308);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(304);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(304);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '/') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(73);
      if (lookahead == '}') ADVANCE(308);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(67);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(304);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '>') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(78);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ';' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(308);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(306);
      if (sym_pf_arg_identifier_character_set_3(lookahead)) ADVANCE(308);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(308);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(78);
      if (lookahead == '{') ADVANCE(304);
      if (!sym_pf_arg_identifier_character_set_2(lookahead)) ADVANCE(308);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(307);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(78);
      if (!sym_pf_arg_identifier_character_set_2(lookahead)) ADVANCE(308);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(309);
      if (lookahead == '/') ADVANCE(301);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '}') ADVANCE(315);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(31);
      if (lookahead != 0) ADVANCE(311);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(309);
      if (lookahead == '/') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(297);
      if (lookahead == '}') ADVANCE(315);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(315);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(311);
      if (lookahead != 0) ADVANCE(311);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(309);
      if (lookahead == '/') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '}') ADVANCE(315);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(31);
      if (lookahead != 0) ADVANCE(311);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(312);
      if (lookahead == '/') ADVANCE(300);
      if (lookahead == '\\') ADVANCE(5);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(315);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(312);
      if (lookahead == '/') ADVANCE(313);
      if (lookahead == '\\') ADVANCE(298);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(315);
      if (lookahead != 0) ADVANCE(315);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(312);
      if (lookahead == '/') ADVANCE(313);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == '{') ADVANCE(311);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(315);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_pf_arg_identifier);
      if (lookahead == '$') ADVANCE(314);
      if (lookahead == '*') ADVANCE(312);
      if (lookahead == '/') ADVANCE(313);
      if (lookahead == '\\') ADVANCE(5);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(315);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_env);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      if (lookahead == ' ') ADVANCE(319);
      if (lookahead == '*' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':') ADVANCE(321);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym__interpret_identifier_token1);
      if (lookahead == ' ') ADVANCE(319);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(aux_sym__interpret_identifier_token1);
      if (lookahead == ' ') ADVANCE(319);
      if (lookahead == '.') ADVANCE(318);
      if (lookahead == '*' ||
          lookahead == '-' ||
          lookahead == ':') ADVANCE(321);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(aux_sym__interpret_identifier_token1);
      if (lookahead == ' ') ADVANCE(319);
      if (lookahead == '*' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == ':') ADVANCE(321);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(aux_sym__interpret_identifier_token2);
      if (lookahead == ' ') ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_system_identifier);
      if (('!' <= lookahead && lookahead <= '=')) ADVANCE(323);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_question_mark_identifier);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_pointer_identifier);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_macro_identifier);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_macro_identifier);
      if (lookahead == '*' ||
          lookahead == '-') ADVANCE(326);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '>') ADVANCE(331);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '>') ADVANCE(332);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_html_redirect_operator);
      if (lookahead == '>') ADVANCE(335);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_html_redirect_operator);
      if (lookahead == '>') ADVANCE(336);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_html_append_operator);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_html_append_operator);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(aux_sym_tmp_eval_arg_token1);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(aux_sym_tmp_eval_arg_token1);
      if (lookahead == '*') ADVANCE(26);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(aux_sym_tmp_eval_arg_token1);
      if (lookahead == '>') ADVANCE(333);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '%') ADVANCE(342);
      if (lookahead == '*') ADVANCE(351);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(346);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '%') ADVANCE(342);
      if (lookahead == '5') ADVANCE(344);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(346);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '%') ADVANCE(342);
      if (lookahead == '>') ADVANCE(333);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '=' &&
          lookahead != '@' &&
          lookahead != '\\' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(346);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '%') ADVANCE(342);
      if (lookahead == 'C') ADVANCE(345);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(346);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '%') ADVANCE(342);
      if (lookahead == 's') ADVANCE(346);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(346);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '%') ADVANCE(342);
      if (!sym__eq_sep_key_identifier_character_set_2(lookahead)) ADVANCE(346);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '%') ADVANCE(348);
      if (lookahead == '*') ADVANCE(347);
      if (lookahead == '/') ADVANCE(346);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(351);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '%') ADVANCE(348);
      if (lookahead == '*') ADVANCE(347);
      if (lookahead == '5') ADVANCE(349);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(351);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '%') ADVANCE(348);
      if (lookahead == '*') ADVANCE(347);
      if (lookahead == 'C') ADVANCE(350);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(351);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '%') ADVANCE(348);
      if (lookahead == '*') ADVANCE(347);
      if (lookahead == 's') ADVANCE(351);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(351);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__eq_sep_key_identifier);
      if (lookahead == '$') ADVANCE(23);
      if (lookahead == '%') ADVANCE(348);
      if (lookahead == '*') ADVANCE(347);
      if (sym__comment_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(351);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '!') ADVANCE(358);
      if (lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(424);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(357);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '#') ADVANCE(352);
      if (lookahead == '/') ADVANCE(354);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(353);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(358);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '*') ADVANCE(356);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(358);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '*') ADVANCE(355);
      if (lookahead == '/') ADVANCE(358);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(26);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == '*') ADVANCE(355);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(26);
      if (lookahead != 0) ADVANCE(356);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead == ';' ||
          lookahead == '|' ||
          lookahead == '~') ADVANCE(424);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(357);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__any_command);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(358);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(371);
      if (lookahead == '/') ADVANCE(373);
      if (lookahead == '\\') ADVANCE(359);
      if (lookahead == '}') ADVANCE(376);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(376);
      if (sym_arg_identifier_character_set_1(lookahead)) ADVANCE(372);
      if (lookahead != 0) ADVANCE(372);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '/') ADVANCE(377);
      if (lookahead == '\\') ADVANCE(360);
      if (sym_arg_identifier_character_set_2(lookahead)) ADVANCE(376);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '(') ADVANCE(410);
      if (lookahead == ',') ADVANCE(369);
      if (lookahead == '/') ADVANCE(362);
      if (lookahead == '\\') ADVANCE(77);
      if (lookahead == '{') ADVANCE(366);
      if (!sym_pf_arg_identifier_character_set_2(lookahead)) ADVANCE(369);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '*') ADVANCE(369);
      if (lookahead == '/') ADVANCE(362);
      if (lookahead == '\\') ADVANCE(370);
      if (sym_arg_identifier_character_set_3(lookahead)) ADVANCE(369);
      if (lookahead != 0) ADVANCE(369);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '*') ADVANCE(366);
      if (lookahead == '/') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(367);
      if (lookahead == '}') ADVANCE(369);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(369);
      if (sym_arg_identifier_character_set_1(lookahead)) ADVANCE(366);
      if (lookahead != 0) ADVANCE(366);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '*') ADVANCE(376);
      if (lookahead == '/') ADVANCE(362);
      if (lookahead == '\\') ADVANCE(370);
      if (sym_arg_identifier_character_set_3(lookahead)) ADVANCE(369);
      if (lookahead != 0) ADVANCE(369);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == ',') ADVANCE(369);
      if (lookahead == '/') ADVANCE(362);
      if (lookahead == '\\') ADVANCE(77);
      if (lookahead == '{') ADVANCE(366);
      if (!sym_pf_arg_identifier_character_set_2(lookahead)) ADVANCE(369);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '/') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == '}') ADVANCE(369);
      if (sym_arg_identifier_character_set_1(lookahead)) ADVANCE(66);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ') ADVANCE(366);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '/') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(367);
      if (lookahead == '}') ADVANCE(369);
      if (lookahead == '\r' ||
          lookahead == ' ') ADVANCE(369);
      if (sym_arg_identifier_character_set_1(lookahead)) ADVANCE(366);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(366);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '/') ADVANCE(362);
      if (lookahead == '>') ADVANCE(333);
      if (lookahead == '\\') ADVANCE(77);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(369);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '/') ADVANCE(362);
      if (lookahead == '\\') ADVANCE(77);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '|' &&
          lookahead != '~') ADVANCE(369);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(365);
      if (lookahead == '/') ADVANCE(362);
      if (lookahead == '\\') ADVANCE(370);
      if (sym_arg_identifier_character_set_2(lookahead)) ADVANCE(369);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(369);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(371);
      if (lookahead == '/') ADVANCE(363);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '}') ADVANCE(376);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(26);
      if (sym_arg_identifier_character_set_1(lookahead)) ADVANCE(28);
      if (lookahead != 0) ADVANCE(372);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(371);
      if (lookahead == '/') ADVANCE(373);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '}') ADVANCE(376);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(26);
      if (sym_arg_identifier_character_set_1(lookahead)) ADVANCE(28);
      if (lookahead != 0) ADVANCE(372);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(371);
      if (lookahead == '/') ADVANCE(373);
      if (lookahead == '\\') ADVANCE(359);
      if (lookahead == '}') ADVANCE(376);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(376);
      if (sym_arg_identifier_character_set_1(lookahead)) ADVANCE(372);
      if (lookahead != 0) ADVANCE(372);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == ',') ADVANCE(376);
      if (lookahead == '/') ADVANCE(377);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '{') ADVANCE(372);
      if (sym__comment_character_set_2(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '/') ADVANCE(362);
      if (lookahead == '\\') ADVANCE(4);
      if (sym_arg_identifier_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '/') ADVANCE(377);
      if (lookahead == '\\') ADVANCE(4);
      if (sym_arg_identifier_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_arg_identifier);
      if (lookahead == '$') ADVANCE(374);
      if (lookahead == '*') ADVANCE(375);
      if (lookahead == '/') ADVANCE(377);
      if (lookahead == '\\') ADVANCE(360);
      if (sym_arg_identifier_character_set_3(lookahead)) ADVANCE(376);
      if (lookahead != 0) ADVANCE(376);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '\n') ADVANCE(26);
      if (lookahead == '$') ADVANCE(387);
      if (lookahead == '*') ADVANCE(385);
      if (lookahead == '/') ADVANCE(386);
      if (lookahead == '\\') ADVANCE(378);
      if (sym_arg_identifier_brace_character_set_1(lookahead)) ADVANCE(388);
      if (lookahead != 0) ADVANCE(388);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '(') ADVANCE(410);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead == '{') ADVANCE(83);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(384);
      if (!sym_arg_identifier_brace_character_set_2(lookahead)) ADVANCE(384);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '\\') ADVANCE(382);
      if (sym_arg_identifier_brace_character_set_3(lookahead)) ADVANCE(384);
      if (lookahead != 0) ADVANCE(384);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '*') ADVANCE(388);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '\\') ADVANCE(382);
      if (sym_arg_identifier_brace_character_set_3(lookahead)) ADVANCE(384);
      if (lookahead != 0) ADVANCE(384);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '\\') ADVANCE(382);
      if (sym_arg_identifier_brace_character_set_1(lookahead)) ADVANCE(384);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(384);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead == '{') ADVANCE(83);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(384);
      if (!sym_arg_identifier_brace_character_set_2(lookahead)) ADVANCE(384);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(383);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != ';' &&
          lookahead != '>' &&
          lookahead != '@' &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(384);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(387);
      if (lookahead == '*') ADVANCE(385);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '\\') ADVANCE(6);
      if (sym_arg_identifier_brace_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(388);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(387);
      if (lookahead == '*') ADVANCE(385);
      if (lookahead == '/') ADVANCE(386);
      if (lookahead == '\\') ADVANCE(378);
      if (sym_arg_identifier_brace_character_set_3(lookahead)) ADVANCE(388);
      if (lookahead != 0) ADVANCE(388);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(387);
      if (lookahead == '*') ADVANCE(385);
      if (lookahead == '/') ADVANCE(386);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '{') ADVANCE(37);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(388);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '"' ||
          lookahead == '#' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '>' ||
          lookahead == '@' ||
          lookahead == '`' ||
          ('|' <= lookahead && lookahead <= '~')) ADVANCE(26);
      if (lookahead != 0) ADVANCE(388);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_arg_identifier_brace);
      if (lookahead == '$') ADVANCE(387);
      if (lookahead == '*') ADVANCE(385);
      if (lookahead == '/') ADVANCE(386);
      if (lookahead == '\\') ADVANCE(6);
      if (sym_arg_identifier_brace_character_set_3(lookahead)) ADVANCE(26);
      if (lookahead != 0) ADVANCE(388);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '\r') ADVANCE(395);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(389);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '#') ADVANCE(394);
      if (lookahead == '/') ADVANCE(393);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(390);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(395);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(391);
      if (lookahead == '/') ADVANCE(395);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(392);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(391);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(392);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(392);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(395);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead == '\r' ||
          lookahead == '!') ADVANCE(395);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(389);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(395);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token2);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token2);
      if (lookahead == '(') ADVANCE(410);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(396);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token3);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(aux_sym_double_quoted_arg_token3);
      if (lookahead == '\n' ||
          lookahead == '"' ||
          lookahead == '$' ||
          lookahead == '\\' ||
          lookahead == '`') ADVANCE(398);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '\r') ADVANCE(407);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(401);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '#') ADVANCE(406);
      if (lookahead == '/') ADVANCE(405);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(402);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(407);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(403);
      if (lookahead == '/') ADVANCE(407);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(404);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(403);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(404);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '*') ADVANCE(404);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(407);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead == '\r' ||
          lookahead == '!') ADVANCE(407);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(401);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(407);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token2);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(aux_sym_single_quoted_arg_token2);
      if (lookahead == '\n' ||
          lookahead == '\'' ||
          lookahead == '\\') ADVANCE(408);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ';' &&
          lookahead != '|') ADVANCE(151);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(aux_sym__dec_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(413);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(aux_sym__dec_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(414);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym__comment);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '!') ADVANCE(246);
      if (lookahead == '?') ADVANCE(255);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(424);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '"') ADVANCE(424);
      if (lookahead == '\\') ADVANCE(425);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(417);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '"') ADVANCE(424);
      if (lookahead == '\\') ADVANCE(425);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '!') ADVANCE(417);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(369);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(66);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(308);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(67);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(346);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(68);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(384);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(69);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead == '}') ADVANCE(286);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '$') ADVANCE(70);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(424);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(417);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym__comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '!') ADVANCE(424);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_CR);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 85, .external_lex_state = 2},
  [2] = {.lex_state = 85, .external_lex_state = 3},
  [3] = {.lex_state = 85, .external_lex_state = 3},
  [4] = {.lex_state = 85, .external_lex_state = 3},
  [5] = {.lex_state = 85, .external_lex_state = 3},
  [6] = {.lex_state = 85, .external_lex_state = 3},
  [7] = {.lex_state = 85, .external_lex_state = 3},
  [8] = {.lex_state = 85, .external_lex_state = 2},
  [9] = {.lex_state = 85, .external_lex_state = 2},
  [10] = {.lex_state = 85, .external_lex_state = 2},
  [11] = {.lex_state = 85, .external_lex_state = 2},
  [12] = {.lex_state = 85, .external_lex_state = 2},
  [13] = {.lex_state = 85, .external_lex_state = 2},
  [14] = {.lex_state = 85, .external_lex_state = 2},
  [15] = {.lex_state = 85, .external_lex_state = 2},
  [16] = {.lex_state = 85, .external_lex_state = 2},
  [17] = {.lex_state = 85, .external_lex_state = 2},
  [18] = {.lex_state = 85, .external_lex_state = 2},
  [19] = {.lex_state = 85, .external_lex_state = 2},
  [20] = {.lex_state = 85, .external_lex_state = 2},
  [21] = {.lex_state = 85, .external_lex_state = 2},
  [22] = {.lex_state = 85, .external_lex_state = 2},
  [23] = {.lex_state = 85, .external_lex_state = 2},
  [24] = {.lex_state = 85, .external_lex_state = 2},
  [25] = {.lex_state = 85, .external_lex_state = 2},
  [26] = {.lex_state = 85, .external_lex_state = 2},
  [27] = {.lex_state = 85, .external_lex_state = 2},
  [28] = {.lex_state = 85, .external_lex_state = 2},
  [29] = {.lex_state = 85, .external_lex_state = 2},
  [30] = {.lex_state = 85, .external_lex_state = 2},
  [31] = {.lex_state = 85, .external_lex_state = 2},
  [32] = {.lex_state = 85, .external_lex_state = 2},
  [33] = {.lex_state = 85, .external_lex_state = 2},
  [34] = {.lex_state = 85, .external_lex_state = 2},
  [35] = {.lex_state = 85, .external_lex_state = 2},
  [36] = {.lex_state = 85, .external_lex_state = 2},
  [37] = {.lex_state = 85, .external_lex_state = 2},
  [38] = {.lex_state = 85, .external_lex_state = 2},
  [39] = {.lex_state = 85, .external_lex_state = 2},
  [40] = {.lex_state = 85, .external_lex_state = 2},
  [41] = {.lex_state = 85, .external_lex_state = 2},
  [42] = {.lex_state = 85, .external_lex_state = 2},
  [43] = {.lex_state = 85, .external_lex_state = 2},
  [44] = {.lex_state = 85, .external_lex_state = 2},
  [45] = {.lex_state = 85, .external_lex_state = 2},
  [46] = {.lex_state = 85, .external_lex_state = 2},
  [47] = {.lex_state = 85, .external_lex_state = 2},
  [48] = {.lex_state = 85, .external_lex_state = 2},
  [49] = {.lex_state = 85, .external_lex_state = 2},
  [50] = {.lex_state = 85, .external_lex_state = 2},
  [51] = {.lex_state = 85, .external_lex_state = 2},
  [52] = {.lex_state = 85, .external_lex_state = 2},
  [53] = {.lex_state = 85, .external_lex_state = 3},
  [54] = {.lex_state = 86, .external_lex_state = 4},
  [55] = {.lex_state = 86, .external_lex_state = 4},
  [56] = {.lex_state = 86, .external_lex_state = 4},
  [57] = {.lex_state = 86, .external_lex_state = 4},
  [58] = {.lex_state = 86, .external_lex_state = 4},
  [59] = {.lex_state = 86, .external_lex_state = 4},
  [60] = {.lex_state = 86, .external_lex_state = 4},
  [61] = {.lex_state = 86, .external_lex_state = 4},
  [62] = {.lex_state = 86, .external_lex_state = 4},
  [63] = {.lex_state = 86, .external_lex_state = 4},
  [64] = {.lex_state = 86, .external_lex_state = 4},
  [65] = {.lex_state = 86, .external_lex_state = 4},
  [66] = {.lex_state = 89, .external_lex_state = 5},
  [67] = {.lex_state = 86, .external_lex_state = 4},
  [68] = {.lex_state = 86, .external_lex_state = 4},
  [69] = {.lex_state = 86, .external_lex_state = 4},
  [70] = {.lex_state = 86, .external_lex_state = 4},
  [71] = {.lex_state = 86, .external_lex_state = 4},
  [72] = {.lex_state = 86, .external_lex_state = 4},
  [73] = {.lex_state = 86, .external_lex_state = 4},
  [74] = {.lex_state = 87, .external_lex_state = 4},
  [75] = {.lex_state = 86, .external_lex_state = 4},
  [76] = {.lex_state = 86, .external_lex_state = 4},
  [77] = {.lex_state = 86, .external_lex_state = 4},
  [78] = {.lex_state = 86, .external_lex_state = 4},
  [79] = {.lex_state = 86, .external_lex_state = 4},
  [80] = {.lex_state = 86, .external_lex_state = 4},
  [81] = {.lex_state = 89, .external_lex_state = 5},
  [82] = {.lex_state = 86, .external_lex_state = 4},
  [83] = {.lex_state = 90, .external_lex_state = 4},
  [84] = {.lex_state = 86, .external_lex_state = 4},
  [85] = {.lex_state = 90, .external_lex_state = 4},
  [86] = {.lex_state = 86, .external_lex_state = 4},
  [87] = {.lex_state = 86, .external_lex_state = 6},
  [88] = {.lex_state = 86, .external_lex_state = 6},
  [89] = {.lex_state = 86, .external_lex_state = 6},
  [90] = {.lex_state = 86, .external_lex_state = 6},
  [91] = {.lex_state = 86, .external_lex_state = 6},
  [92] = {.lex_state = 86, .external_lex_state = 6},
  [93] = {.lex_state = 86, .external_lex_state = 6},
  [94] = {.lex_state = 86, .external_lex_state = 6},
  [95] = {.lex_state = 86, .external_lex_state = 6},
  [96] = {.lex_state = 86, .external_lex_state = 6},
  [97] = {.lex_state = 86, .external_lex_state = 6},
  [98] = {.lex_state = 86, .external_lex_state = 6},
  [99] = {.lex_state = 86, .external_lex_state = 4},
  [100] = {.lex_state = 86, .external_lex_state = 4},
  [101] = {.lex_state = 89, .external_lex_state = 5},
  [102] = {.lex_state = 86, .external_lex_state = 4},
  [103] = {.lex_state = 89, .external_lex_state = 5},
  [104] = {.lex_state = 87, .external_lex_state = 4},
  [105] = {.lex_state = 89, .external_lex_state = 5},
  [106] = {.lex_state = 90, .external_lex_state = 6},
  [107] = {.lex_state = 89, .external_lex_state = 5},
  [108] = {.lex_state = 89, .external_lex_state = 5},
  [109] = {.lex_state = 90, .external_lex_state = 6},
  [110] = {.lex_state = 90, .external_lex_state = 4},
  [111] = {.lex_state = 89, .external_lex_state = 5},
  [112] = {.lex_state = 89, .external_lex_state = 5},
  [113] = {.lex_state = 90, .external_lex_state = 6},
  [114] = {.lex_state = 91, .external_lex_state = 4},
  [115] = {.lex_state = 90, .external_lex_state = 6},
  [116] = {.lex_state = 87, .external_lex_state = 4},
  [117] = {.lex_state = 90, .external_lex_state = 6},
  [118] = {.lex_state = 90, .external_lex_state = 6},
  [119] = {.lex_state = 90, .external_lex_state = 6},
  [120] = {.lex_state = 91, .external_lex_state = 4},
  [121] = {.lex_state = 88, .external_lex_state = 4},
  [122] = {.lex_state = 92, .external_lex_state = 5},
  [123] = {.lex_state = 92, .external_lex_state = 7},
  [124] = {.lex_state = 90, .external_lex_state = 4},
  [125] = {.lex_state = 92, .external_lex_state = 5},
  [126] = {.lex_state = 88, .external_lex_state = 4},
  [127] = {.lex_state = 92, .external_lex_state = 7},
  [128] = {.lex_state = 92, .external_lex_state = 5},
  [129] = {.lex_state = 92, .external_lex_state = 5},
  [130] = {.lex_state = 92, .external_lex_state = 7},
  [131] = {.lex_state = 88, .external_lex_state = 8},
  [132] = {.lex_state = 92, .external_lex_state = 5},
  [133] = {.lex_state = 92, .external_lex_state = 5},
  [134] = {.lex_state = 88, .external_lex_state = 8},
  [135] = {.lex_state = 88, .external_lex_state = 8},
  [136] = {.lex_state = 92, .external_lex_state = 5},
  [137] = {.lex_state = 92, .external_lex_state = 7},
  [138] = {.lex_state = 91, .external_lex_state = 4},
  [139] = {.lex_state = 91, .external_lex_state = 4},
  [140] = {.lex_state = 88, .external_lex_state = 8},
  [141] = {.lex_state = 88, .external_lex_state = 8},
  [142] = {.lex_state = 92, .external_lex_state = 5},
  [143] = {.lex_state = 92, .external_lex_state = 5},
  [144] = {.lex_state = 88, .external_lex_state = 8},
  [145] = {.lex_state = 88, .external_lex_state = 8},
  [146] = {.lex_state = 88, .external_lex_state = 8},
  [147] = {.lex_state = 88, .external_lex_state = 8},
  [148] = {.lex_state = 88, .external_lex_state = 8},
  [149] = {.lex_state = 88, .external_lex_state = 8},
  [150] = {.lex_state = 88, .external_lex_state = 4},
  [151] = {.lex_state = 88, .external_lex_state = 8},
  [152] = {.lex_state = 92, .external_lex_state = 7},
  [153] = {.lex_state = 92, .external_lex_state = 7},
  [154] = {.lex_state = 88, .external_lex_state = 7},
  [155] = {.lex_state = 92, .external_lex_state = 7},
  [156] = {.lex_state = 88, .external_lex_state = 7},
  [157] = {.lex_state = 88, .external_lex_state = 4},
  [158] = {.lex_state = 88, .external_lex_state = 6},
  [159] = {.lex_state = 88, .external_lex_state = 7},
  [160] = {.lex_state = 92, .external_lex_state = 7},
  [161] = {.lex_state = 92, .external_lex_state = 5},
  [162] = {.lex_state = 92, .external_lex_state = 7},
  [163] = {.lex_state = 88, .external_lex_state = 6},
  [164] = {.lex_state = 92, .external_lex_state = 7},
  [165] = {.lex_state = 88, .external_lex_state = 4},
  [166] = {.lex_state = 88, .external_lex_state = 6},
  [167] = {.lex_state = 88, .external_lex_state = 4},
  [168] = {.lex_state = 92, .external_lex_state = 7},
  [169] = {.lex_state = 92, .external_lex_state = 5},
  [170] = {.lex_state = 91, .external_lex_state = 4},
  [171] = {.lex_state = 91, .external_lex_state = 4},
  [172] = {.lex_state = 88, .external_lex_state = 4},
  [173] = {.lex_state = 88, .external_lex_state = 6},
  [174] = {.lex_state = 91, .external_lex_state = 4},
  [175] = {.lex_state = 88, .external_lex_state = 6},
  [176] = {.lex_state = 92, .external_lex_state = 4},
  [177] = {.lex_state = 88, .external_lex_state = 6},
  [178] = {.lex_state = 88, .external_lex_state = 4},
  [179] = {.lex_state = 88, .external_lex_state = 6},
  [180] = {.lex_state = 88, .external_lex_state = 4},
  [181] = {.lex_state = 88, .external_lex_state = 6},
  [182] = {.lex_state = 88, .external_lex_state = 7},
  [183] = {.lex_state = 88, .external_lex_state = 6},
  [184] = {.lex_state = 88, .external_lex_state = 4},
  [185] = {.lex_state = 88, .external_lex_state = 4},
  [186] = {.lex_state = 88, .external_lex_state = 4},
  [187] = {.lex_state = 88, .external_lex_state = 6},
  [188] = {.lex_state = 88, .external_lex_state = 6},
  [189] = {.lex_state = 92, .external_lex_state = 4},
  [190] = {.lex_state = 88, .external_lex_state = 6},
  [191] = {.lex_state = 88, .external_lex_state = 4},
  [192] = {.lex_state = 88, .external_lex_state = 7},
  [193] = {.lex_state = 88, .external_lex_state = 4},
  [194] = {.lex_state = 88, .external_lex_state = 4},
  [195] = {.lex_state = 88, .external_lex_state = 4},
  [196] = {.lex_state = 88, .external_lex_state = 4},
  [197] = {.lex_state = 88, .external_lex_state = 4},
  [198] = {.lex_state = 92, .external_lex_state = 4},
  [199] = {.lex_state = 88, .external_lex_state = 4},
  [200] = {.lex_state = 88, .external_lex_state = 4},
  [201] = {.lex_state = 88, .external_lex_state = 4},
  [202] = {.lex_state = 91, .external_lex_state = 4},
  [203] = {.lex_state = 88, .external_lex_state = 4},
  [204] = {.lex_state = 88, .external_lex_state = 4},
  [205] = {.lex_state = 88, .external_lex_state = 4},
  [206] = {.lex_state = 88, .external_lex_state = 4},
  [207] = {.lex_state = 88, .external_lex_state = 4},
  [208] = {.lex_state = 88, .external_lex_state = 4},
  [209] = {.lex_state = 88, .external_lex_state = 4},
  [210] = {.lex_state = 88, .external_lex_state = 4},
  [211] = {.lex_state = 88, .external_lex_state = 4},
  [212] = {.lex_state = 88, .external_lex_state = 4},
  [213] = {.lex_state = 88, .external_lex_state = 4},
  [214] = {.lex_state = 88, .external_lex_state = 4},
  [215] = {.lex_state = 88, .external_lex_state = 4},
  [216] = {.lex_state = 88, .external_lex_state = 4},
  [217] = {.lex_state = 88, .external_lex_state = 4},
  [218] = {.lex_state = 88, .external_lex_state = 4},
  [219] = {.lex_state = 88, .external_lex_state = 4},
  [220] = {.lex_state = 88, .external_lex_state = 4},
  [221] = {.lex_state = 88, .external_lex_state = 4},
  [222] = {.lex_state = 88, .external_lex_state = 4},
  [223] = {.lex_state = 88, .external_lex_state = 4},
  [224] = {.lex_state = 88, .external_lex_state = 4},
  [225] = {.lex_state = 88, .external_lex_state = 4},
  [226] = {.lex_state = 91, .external_lex_state = 4},
  [227] = {.lex_state = 88, .external_lex_state = 4},
  [228] = {.lex_state = 88, .external_lex_state = 5},
  [229] = {.lex_state = 88, .external_lex_state = 4},
  [230] = {.lex_state = 88, .external_lex_state = 4},
  [231] = {.lex_state = 88, .external_lex_state = 4},
  [232] = {.lex_state = 88, .external_lex_state = 4},
  [233] = {.lex_state = 88, .external_lex_state = 4},
  [234] = {.lex_state = 88, .external_lex_state = 4},
  [235] = {.lex_state = 88, .external_lex_state = 4},
  [236] = {.lex_state = 88, .external_lex_state = 4},
  [237] = {.lex_state = 88, .external_lex_state = 4},
  [238] = {.lex_state = 88, .external_lex_state = 4},
  [239] = {.lex_state = 88, .external_lex_state = 4},
  [240] = {.lex_state = 88, .external_lex_state = 4},
  [241] = {.lex_state = 88, .external_lex_state = 4},
  [242] = {.lex_state = 88, .external_lex_state = 4},
  [243] = {.lex_state = 88, .external_lex_state = 4},
  [244] = {.lex_state = 88, .external_lex_state = 4},
  [245] = {.lex_state = 88, .external_lex_state = 4},
  [246] = {.lex_state = 88, .external_lex_state = 4},
  [247] = {.lex_state = 88, .external_lex_state = 4},
  [248] = {.lex_state = 88, .external_lex_state = 4},
  [249] = {.lex_state = 88, .external_lex_state = 4},
  [250] = {.lex_state = 88, .external_lex_state = 4},
  [251] = {.lex_state = 88, .external_lex_state = 4},
  [252] = {.lex_state = 88, .external_lex_state = 4},
  [253] = {.lex_state = 88, .external_lex_state = 4},
  [254] = {.lex_state = 88, .external_lex_state = 4},
  [255] = {.lex_state = 88, .external_lex_state = 4},
  [256] = {.lex_state = 88, .external_lex_state = 4},
  [257] = {.lex_state = 88, .external_lex_state = 4},
  [258] = {.lex_state = 88, .external_lex_state = 4},
  [259] = {.lex_state = 88, .external_lex_state = 4},
  [260] = {.lex_state = 88, .external_lex_state = 4},
  [261] = {.lex_state = 88, .external_lex_state = 4},
  [262] = {.lex_state = 88, .external_lex_state = 4},
  [263] = {.lex_state = 88, .external_lex_state = 4},
  [264] = {.lex_state = 88, .external_lex_state = 4},
  [265] = {.lex_state = 88, .external_lex_state = 4},
  [266] = {.lex_state = 88, .external_lex_state = 4},
  [267] = {.lex_state = 88, .external_lex_state = 4},
  [268] = {.lex_state = 88, .external_lex_state = 4},
  [269] = {.lex_state = 88, .external_lex_state = 4},
  [270] = {.lex_state = 88, .external_lex_state = 4},
  [271] = {.lex_state = 88, .external_lex_state = 4},
  [272] = {.lex_state = 88, .external_lex_state = 4},
  [273] = {.lex_state = 88, .external_lex_state = 4},
  [274] = {.lex_state = 88, .external_lex_state = 4},
  [275] = {.lex_state = 88, .external_lex_state = 4},
  [276] = {.lex_state = 88, .external_lex_state = 4},
  [277] = {.lex_state = 88, .external_lex_state = 4},
  [278] = {.lex_state = 88, .external_lex_state = 4},
  [279] = {.lex_state = 88, .external_lex_state = 4},
  [280] = {.lex_state = 88, .external_lex_state = 4},
  [281] = {.lex_state = 88, .external_lex_state = 4},
  [282] = {.lex_state = 93, .external_lex_state = 4},
  [283] = {.lex_state = 88, .external_lex_state = 4},
  [284] = {.lex_state = 88, .external_lex_state = 4},
  [285] = {.lex_state = 88, .external_lex_state = 4},
  [286] = {.lex_state = 92, .external_lex_state = 4},
  [287] = {.lex_state = 17, .external_lex_state = 4},
  [288] = {.lex_state = 88, .external_lex_state = 5},
  [289] = {.lex_state = 18, .external_lex_state = 4},
  [290] = {.lex_state = 88, .external_lex_state = 4},
  [291] = {.lex_state = 88, .external_lex_state = 4},
  [292] = {.lex_state = 85, .external_lex_state = 2},
  [293] = {.lex_state = 85, .external_lex_state = 2},
  [294] = {.lex_state = 8},
  [295] = {.lex_state = 8},
  [296] = {.lex_state = 8},
  [297] = {.lex_state = 8},
  [298] = {.lex_state = 8},
  [299] = {.lex_state = 8},
  [300] = {.lex_state = 8},
  [301] = {.lex_state = 8},
  [302] = {.lex_state = 8},
  [303] = {.lex_state = 8},
  [304] = {.lex_state = 8},
  [305] = {.lex_state = 8},
  [306] = {.lex_state = 8},
  [307] = {.lex_state = 8},
  [308] = {.lex_state = 8},
  [309] = {.lex_state = 8, .external_lex_state = 9},
  [310] = {.lex_state = 8},
  [311] = {.lex_state = 8, .external_lex_state = 9},
  [312] = {.lex_state = 8},
  [313] = {.lex_state = 8},
  [314] = {.lex_state = 8},
  [315] = {.lex_state = 8},
  [316] = {.lex_state = 8},
  [317] = {.lex_state = 8},
  [318] = {.lex_state = 8},
  [319] = {.lex_state = 8},
  [320] = {.lex_state = 8},
  [321] = {.lex_state = 8},
  [322] = {.lex_state = 8},
  [323] = {.lex_state = 8},
  [324] = {.lex_state = 8},
  [325] = {.lex_state = 8},
  [326] = {.lex_state = 8},
  [327] = {.lex_state = 10},
  [328] = {.lex_state = 8},
  [329] = {.lex_state = 8},
  [330] = {.lex_state = 8},
  [331] = {.lex_state = 8},
  [332] = {.lex_state = 8},
  [333] = {.lex_state = 8},
  [334] = {.lex_state = 8},
  [335] = {.lex_state = 8},
  [336] = {.lex_state = 8},
  [337] = {.lex_state = 8},
  [338] = {.lex_state = 8},
  [339] = {.lex_state = 10},
  [340] = {.lex_state = 8},
  [341] = {.lex_state = 10},
  [342] = {.lex_state = 12},
  [343] = {.lex_state = 12},
  [344] = {.lex_state = 12},
  [345] = {.lex_state = 10},
  [346] = {.lex_state = 12},
  [347] = {.lex_state = 9},
  [348] = {.lex_state = 10},
  [349] = {.lex_state = 10},
  [350] = {.lex_state = 12},
  [351] = {.lex_state = 8},
  [352] = {.lex_state = 12},
  [353] = {.lex_state = 12},
  [354] = {.lex_state = 12},
  [355] = {.lex_state = 8},
  [356] = {.lex_state = 8, .external_lex_state = 9},
  [357] = {.lex_state = 8},
  [358] = {.lex_state = 12},
  [359] = {.lex_state = 8},
  [360] = {.lex_state = 8, .external_lex_state = 9},
  [361] = {.lex_state = 8},
  [362] = {.lex_state = 12},
  [363] = {.lex_state = 10},
  [364] = {.lex_state = 8, .external_lex_state = 9},
  [365] = {.lex_state = 8},
  [366] = {.lex_state = 8, .external_lex_state = 9},
  [367] = {.lex_state = 8, .external_lex_state = 9},
  [368] = {.lex_state = 8, .external_lex_state = 9},
  [369] = {.lex_state = 8, .external_lex_state = 9},
  [370] = {.lex_state = 14},
  [371] = {.lex_state = 14},
  [372] = {.lex_state = 8, .external_lex_state = 9},
  [373] = {.lex_state = 8, .external_lex_state = 9},
  [374] = {.lex_state = 8, .external_lex_state = 9},
  [375] = {.lex_state = 8, .external_lex_state = 9},
  [376] = {.lex_state = 8, .external_lex_state = 9},
  [377] = {.lex_state = 14},
  [378] = {.lex_state = 8},
  [379] = {.lex_state = 10, .external_lex_state = 10},
  [380] = {.lex_state = 14},
  [381] = {.lex_state = 10, .external_lex_state = 10},
  [382] = {.lex_state = 10, .external_lex_state = 10},
  [383] = {.lex_state = 9},
  [384] = {.lex_state = 10, .external_lex_state = 10},
  [385] = {.lex_state = 11},
  [386] = {.lex_state = 10, .external_lex_state = 10},
  [387] = {.lex_state = 11},
  [388] = {.lex_state = 11},
  [389] = {.lex_state = 11},
  [390] = {.lex_state = 10, .external_lex_state = 10},
  [391] = {.lex_state = 11},
  [392] = {.lex_state = 11},
  [393] = {.lex_state = 88, .external_lex_state = 9},
  [394] = {.lex_state = 10, .external_lex_state = 10},
  [395] = {.lex_state = 11},
  [396] = {.lex_state = 11},
  [397] = {.lex_state = 88, .external_lex_state = 9},
  [398] = {.lex_state = 11},
  [399] = {.lex_state = 11},
  [400] = {.lex_state = 11},
  [401] = {.lex_state = 11},
  [402] = {.lex_state = 10, .external_lex_state = 10},
  [403] = {.lex_state = 11},
  [404] = {.lex_state = 88, .external_lex_state = 9},
  [405] = {.lex_state = 11},
  [406] = {.lex_state = 11},
  [407] = {.lex_state = 11},
  [408] = {.lex_state = 10, .external_lex_state = 10},
  [409] = {.lex_state = 11},
  [410] = {.lex_state = 11},
  [411] = {.lex_state = 11},
  [412] = {.lex_state = 11},
  [413] = {.lex_state = 11},
  [414] = {.lex_state = 10, .external_lex_state = 10},
  [415] = {.lex_state = 10, .external_lex_state = 10},
  [416] = {.lex_state = 10, .external_lex_state = 10},
  [417] = {.lex_state = 14},
  [418] = {.lex_state = 8},
  [419] = {.lex_state = 88, .external_lex_state = 9},
  [420] = {.lex_state = 8},
  [421] = {.lex_state = 88, .external_lex_state = 9},
  [422] = {.lex_state = 88, .external_lex_state = 9},
  [423] = {.lex_state = 88, .external_lex_state = 9},
  [424] = {.lex_state = 13},
  [425] = {.lex_state = 12, .external_lex_state = 9},
  [426] = {.lex_state = 88, .external_lex_state = 9},
  [427] = {.lex_state = 88, .external_lex_state = 9},
  [428] = {.lex_state = 13},
  [429] = {.lex_state = 12},
  [430] = {.lex_state = 8},
  [431] = {.lex_state = 88, .external_lex_state = 9},
  [432] = {.lex_state = 8},
  [433] = {.lex_state = 8},
  [434] = {.lex_state = 88, .external_lex_state = 9},
  [435] = {.lex_state = 88, .external_lex_state = 9},
  [436] = {.lex_state = 12, .external_lex_state = 9},
  [437] = {.lex_state = 10},
  [438] = {.lex_state = 12},
  [439] = {.lex_state = 12, .external_lex_state = 9},
  [440] = {.lex_state = 13},
  [441] = {.lex_state = 88},
  [442] = {.lex_state = 12, .external_lex_state = 9},
  [443] = {.lex_state = 88},
  [444] = {.lex_state = 11},
  [445] = {.lex_state = 11},
  [446] = {.lex_state = 12, .external_lex_state = 9},
  [447] = {.lex_state = 12, .external_lex_state = 9},
  [448] = {.lex_state = 12, .external_lex_state = 9},
  [449] = {.lex_state = 12, .external_lex_state = 9},
  [450] = {.lex_state = 12, .external_lex_state = 9},
  [451] = {.lex_state = 12, .external_lex_state = 9},
  [452] = {.lex_state = 12, .external_lex_state = 9},
  [453] = {.lex_state = 14},
  [454] = {.lex_state = 12, .external_lex_state = 9},
  [455] = {.lex_state = 88},
  [456] = {.lex_state = 12},
  [457] = {.lex_state = 14},
  [458] = {.lex_state = 12, .external_lex_state = 9},
  [459] = {.lex_state = 88},
  [460] = {.lex_state = 88},
  [461] = {.lex_state = 12, .external_lex_state = 9},
  [462] = {.lex_state = 88},
  [463] = {.lex_state = 88},
  [464] = {.lex_state = 12, .external_lex_state = 9},
  [465] = {.lex_state = 12, .external_lex_state = 9},
  [466] = {.lex_state = 12, .external_lex_state = 9},
  [467] = {.lex_state = 19},
  [468] = {.lex_state = 19},
  [469] = {.lex_state = 19},
  [470] = {.lex_state = 88},
  [471] = {.lex_state = 19},
  [472] = {.lex_state = 19},
  [473] = {.lex_state = 19},
  [474] = {.lex_state = 16},
  [475] = {.lex_state = 19},
  [476] = {.lex_state = 19},
  [477] = {.lex_state = 19},
  [478] = {.lex_state = 19},
  [479] = {.lex_state = 19},
  [480] = {.lex_state = 19},
  [481] = {.lex_state = 19},
  [482] = {.lex_state = 19},
  [483] = {.lex_state = 19},
  [484] = {.lex_state = 12},
  [485] = {.lex_state = 19},
  [486] = {.lex_state = 19},
  [487] = {.lex_state = 19},
  [488] = {.lex_state = 19},
  [489] = {.lex_state = 19},
  [490] = {.lex_state = 19},
  [491] = {.lex_state = 88},
  [492] = {.lex_state = 88},
  [493] = {.lex_state = 88},
  [494] = {.lex_state = 88},
  [495] = {.lex_state = 88},
  [496] = {.lex_state = 88},
  [497] = {.lex_state = 16},
  [498] = {.lex_state = 88},
  [499] = {.lex_state = 88},
  [500] = {.lex_state = 88},
  [501] = {.lex_state = 88},
  [502] = {.lex_state = 88},
  [503] = {.lex_state = 88},
  [504] = {.lex_state = 92, .external_lex_state = 10},
  [505] = {.lex_state = 92, .external_lex_state = 10},
  [506] = {.lex_state = 88},
  [507] = {.lex_state = 88},
  [508] = {.lex_state = 88},
  [509] = {.lex_state = 92, .external_lex_state = 10},
  [510] = {.lex_state = 88},
  [511] = {.lex_state = 88},
  [512] = {.lex_state = 92, .external_lex_state = 10},
  [513] = {.lex_state = 20},
  [514] = {.lex_state = 92, .external_lex_state = 10},
  [515] = {.lex_state = 15},
  [516] = {.lex_state = 88},
  [517] = {.lex_state = 92, .external_lex_state = 10},
  [518] = {.lex_state = 15},
  [519] = {.lex_state = 92, .external_lex_state = 10},
  [520] = {.lex_state = 92, .external_lex_state = 10},
  [521] = {.lex_state = 92, .external_lex_state = 10},
  [522] = {.lex_state = 88},
  [523] = {.lex_state = 92, .external_lex_state = 10},
  [524] = {.lex_state = 92, .external_lex_state = 10},
  [525] = {.lex_state = 92, .external_lex_state = 10},
  [526] = {.lex_state = 88},
  [527] = {.lex_state = 88},
  [528] = {.lex_state = 88},
  [529] = {.lex_state = 92},
  [530] = {.lex_state = 88},
  [531] = {.lex_state = 88},
  [532] = {.lex_state = 88},
  [533] = {.lex_state = 88},
  [534] = {.lex_state = 88},
  [535] = {.lex_state = 88},
  [536] = {.lex_state = 88},
  [537] = {.lex_state = 88},
  [538] = {.lex_state = 88},
  [539] = {.lex_state = 88},
  [540] = {.lex_state = 88},
  [541] = {.lex_state = 88},
  [542] = {.lex_state = 88},
  [543] = {.lex_state = 88},
  [544] = {.lex_state = 88},
  [545] = {.lex_state = 88},
  [546] = {.lex_state = 88},
  [547] = {.lex_state = 88},
  [548] = {.lex_state = 88},
  [549] = {.lex_state = 88},
  [550] = {.lex_state = 88},
  [551] = {.lex_state = 88},
  [552] = {.lex_state = 88, .external_lex_state = 11},
  [553] = {.lex_state = 88},
  [554] = {.lex_state = 88},
  [555] = {.lex_state = 88},
  [556] = {.lex_state = 88},
  [557] = {.lex_state = 88},
  [558] = {.lex_state = 88},
  [559] = {.lex_state = 88},
  [560] = {.lex_state = 88},
  [561] = {.lex_state = 88},
  [562] = {.lex_state = 88},
  [563] = {.lex_state = 88},
  [564] = {.lex_state = 92},
  [565] = {.lex_state = 88},
  [566] = {.lex_state = 88},
  [567] = {.lex_state = 88},
  [568] = {.lex_state = 88},
  [569] = {.lex_state = 21},
  [570] = {.lex_state = 88},
  [571] = {.lex_state = 88},
  [572] = {.lex_state = 88},
  [573] = {.lex_state = 88},
  [574] = {.lex_state = 88},
  [575] = {.lex_state = 88},
  [576] = {.lex_state = 88},
  [577] = {.lex_state = 88},
  [578] = {.lex_state = 88, .external_lex_state = 11},
  [579] = {.lex_state = 88},
  [580] = {.lex_state = 88},
  [581] = {.lex_state = 92},
  [582] = {.lex_state = 88},
  [583] = {.lex_state = 88},
  [584] = {.lex_state = 88},
  [585] = {.lex_state = 88},
  [586] = {.lex_state = 88, .external_lex_state = 11},
};

enum {
  ts_external_token_cmd_identifier = 0,
  ts_external_token__help_command = 1,
  ts_external_token_file_descriptor = 2,
  ts_external_token__eq_sep_concat = 3,
  ts_external_token__concat = 4,
  ts_external_token__concat_brace = 5,
  ts_external_token__concat_pf_dot = 6,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_cmd_identifier] = sym_cmd_identifier,
  [ts_external_token__help_command] = sym__help_command,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__eq_sep_concat] = sym__eq_sep_concat,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token__concat_brace] = sym__concat_brace,
  [ts_external_token__concat_pf_dot] = sym__concat_pf_dot,
};

static bool ts_external_scanner_states[12][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_cmd_identifier] = true,
    [ts_external_token__help_command] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__eq_sep_concat] = true,
    [ts_external_token__concat] = true,
    [ts_external_token__concat_brace] = true,
    [ts_external_token__concat_pf_dot] = true,
  },
  [2] = {
    [ts_external_token_cmd_identifier] = true,
    [ts_external_token__help_command] = true,
  },
  [3] = {
    [ts_external_token_cmd_identifier] = true,
    [ts_external_token__help_command] = true,
    [ts_external_token_file_descriptor] = true,
  },
  [4] = {
    [ts_external_token_file_descriptor] = true,
  },
  [5] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat_pf_dot] = true,
  },
  [6] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
  },
  [7] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__eq_sep_concat] = true,
  },
  [8] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__eq_sep_concat] = true,
    [ts_external_token__concat] = true,
  },
  [9] = {
    [ts_external_token__concat] = true,
  },
  [10] = {
    [ts_external_token__concat_brace] = true,
  },
  [11] = {
    [ts_external_token__concat_pf_dot] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [aux_sym_grep_specifier_token1] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PIPEH] = ACTIONS(1),
    [anon_sym_PIPET] = ACTIONS(1),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(1),
    [anon_sym_AT_AT_ATb] = ACTIONS(1),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(1),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(1),
    [anon_sym_AT_AT_ATi] = ACTIONS(1),
    [anon_sym_AT_AT_ATr] = ACTIONS(1),
    [anon_sym_AT_AT_ATs] = ACTIONS(1),
    [anon_sym_AT_AT_ATst] = ACTIONS(1),
    [anon_sym_AT_AT_ATS] = ACTIONS(1),
    [anon_sym_AT_AT_ATm] = ACTIONS(1),
    [anon_sym_AT_AT_ATM] = ACTIONS(1),
    [anon_sym_AT_AT_ATf] = ACTIONS(1),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(1),
    [anon_sym_AT_AT_ATF] = ACTIONS(1),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(1),
    [anon_sym_AT_AT_ATt] = ACTIONS(1),
    [anon_sym_AT_AT] = ACTIONS(1),
    [anon_sym_AT_ATdbt] = ACTIONS(1),
    [anon_sym_AT_ATdbta] = ACTIONS(1),
    [anon_sym_AT_ATdbtb] = ACTIONS(1),
    [anon_sym_AT_ATdbts] = ACTIONS(1),
    [anon_sym_AT_AT_DOT] = ACTIONS(1),
    [anon_sym_AT_AT_EQ] = ACTIONS(1),
    [anon_sym_AT_ATk] = ACTIONS(1),
    [anon_sym_AT_ATt] = ACTIONS(1),
    [anon_sym_AT_ATb] = ACTIONS(1),
    [anon_sym_AT_ATi] = ACTIONS(1),
    [anon_sym_AT_ATiS] = ACTIONS(1),
    [anon_sym_AT_ATf] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT_ATs_COLON] = ACTIONS(1),
    [anon_sym_AT_ATc_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_AT_BANG] = ACTIONS(1),
    [anon_sym_AT_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_ATa_COLON] = ACTIONS(1),
    [anon_sym_ATb_COLON] = ACTIONS(1),
    [anon_sym_ATB_COLON] = ACTIONS(1),
    [anon_sym_ATe_COLON] = ACTIONS(1),
    [anon_sym_ATF_COLON] = ACTIONS(1),
    [anon_sym_ATi_COLON] = ACTIONS(1),
    [anon_sym_ATk_COLON] = ACTIONS(1),
    [anon_sym_ATo_COLON] = ACTIONS(1),
    [anon_sym_ATr_COLON] = ACTIONS(1),
    [anon_sym_ATf_COLON] = ACTIONS(1),
    [anon_sym_ATs_COLON] = ACTIONS(1),
    [anon_sym_ATx_COLON] = ACTIONS(1),
    [anon_sym_POUND_BANG] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [aux_sym_task_command_token1] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym_POUND_QMARK] = ACTIONS(1),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(1),
    [aux_sym__search_command_token1] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_LPAREN] = ACTIONS(1),
    [anon_sym_PIPE_DOT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_question_mark_identifier] = ACTIONS(1),
    [sym_pointer_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [sym_html_redirect_operator] = ACTIONS(1),
    [sym_html_append_operator] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [aux_sym_tmp_eval_arg_token1] = ACTIONS(1),
    [aux_sym_double_quoted_arg_token3] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_CR] = ACTIONS(1),
    [sym_cmd_identifier] = ACTIONS(1),
    [sym__help_command] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__eq_sep_concat] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym__concat_brace] = ACTIONS(1),
    [sym__concat_pf_dot] = ACTIONS(1),
  },
  [1] = {
    [sym_commands] = STATE(572),
    [sym__command] = STATE(462),
    [sym_legacy_quoted_command] = STATE(186),
    [sym__simple_command] = STATE(186),
    [sym__tmp_command] = STATE(186),
    [sym__iter_command] = STATE(186),
    [sym__foreach_command] = STATE(186),
    [sym__pipe_command] = STATE(186),
    [sym_grep_command] = STATE(186),
    [sym_html_disable_command] = STATE(186),
    [sym_html_enable_command] = STATE(186),
    [sym_scr_tts_command] = STATE(186),
    [sym_pipe_command] = STATE(186),
    [sym_foreach_addrsize_command] = STATE(186),
    [sym_foreach_bb_command] = STATE(186),
    [sym_foreach_cmd_command] = STATE(186),
    [sym_foreach_comment_command] = STATE(186),
    [sym_foreach_import_command] = STATE(186),
    [sym_foreach_register_command] = STATE(186),
    [sym_foreach_symbol_command] = STATE(186),
    [sym_foreach_string_command] = STATE(186),
    [sym_foreach_section_command] = STATE(186),
    [sym_foreach_iomap_command] = STATE(186),
    [sym_foreach_dbgmap_command] = STATE(186),
    [sym_foreach_flag_command] = STATE(186),
    [sym_foreach_function_command] = STATE(186),
    [sym_foreach_thread_command] = STATE(186),
    [sym_iter_flags_command] = STATE(186),
    [sym_iter_dbta_command] = STATE(186),
    [sym_iter_dbtb_command] = STATE(186),
    [sym_iter_dbts_command] = STATE(186),
    [sym_iter_file_lines_command] = STATE(186),
    [sym_iter_offsets_command] = STATE(186),
    [sym_iter_sdbquery_command] = STATE(186),
    [sym_iter_threads_command] = STATE(186),
    [sym_iter_bbs_command] = STATE(186),
    [sym_iter_instrs_command] = STATE(186),
    [sym_iter_sections_command] = STATE(186),
    [sym_iter_functions_command] = STATE(186),
    [sym_iter_step_command] = STATE(186),
    [sym_iter_interpret_command] = STATE(186),
    [sym_iter_hit_command] = STATE(186),
    [sym_tmp_seek_command] = STATE(186),
    [sym_tmp_blksz_command] = STATE(186),
    [sym_tmp_fromto_command] = STATE(186),
    [sym_tmp_arch_command] = STATE(186),
    [sym_tmp_bits_command] = STATE(186),
    [sym_tmp_nthi_command] = STATE(186),
    [sym_tmp_eval_command] = STATE(186),
    [sym_tmp_fs_command] = STATE(186),
    [sym_tmp_reli_command] = STATE(186),
    [sym_tmp_kuery_command] = STATE(186),
    [sym_tmp_fd_command] = STATE(186),
    [sym_tmp_reg_command] = STATE(186),
    [sym_tmp_file_command] = STATE(186),
    [sym_tmp_string_command] = STATE(186),
    [sym_tmp_hex_command] = STATE(186),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(186),
    [sym_number_command] = STATE(186),
    [sym_help_command] = STATE(186),
    [sym_arged_command] = STATE(186),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(186),
    [sym_Cf_cmd] = STATE(186),
    [sym_pf_new_cmd] = STATE(186),
    [sym_pf_dot_cmd] = STATE(186),
    [sym_pf_cmd] = STATE(186),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(186),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(186),
    [sym_redirect_command] = STATE(462),
    [sym__dec_number] = STATE(2),
    [aux_sym_commands_repeat1] = STATE(8),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(57),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(57),
    [anon_sym_CR] = ACTIONS(57),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [2] = {
    [sym_legacy_quoted_command] = STATE(255),
    [sym__simple_command] = STATE(255),
    [sym__tmp_command] = STATE(255),
    [sym__iter_command] = STATE(255),
    [sym__foreach_command] = STATE(255),
    [sym__pipe_command] = STATE(255),
    [sym_grep_command] = STATE(255),
    [sym_html_disable_command] = STATE(255),
    [sym_html_enable_command] = STATE(255),
    [sym_scr_tts_command] = STATE(255),
    [sym_pipe_command] = STATE(255),
    [sym_foreach_addrsize_command] = STATE(255),
    [sym_foreach_bb_command] = STATE(255),
    [sym_foreach_cmd_command] = STATE(255),
    [sym_foreach_comment_command] = STATE(255),
    [sym_foreach_import_command] = STATE(255),
    [sym_foreach_register_command] = STATE(255),
    [sym_foreach_symbol_command] = STATE(255),
    [sym_foreach_string_command] = STATE(255),
    [sym_foreach_section_command] = STATE(255),
    [sym_foreach_iomap_command] = STATE(255),
    [sym_foreach_dbgmap_command] = STATE(255),
    [sym_foreach_flag_command] = STATE(255),
    [sym_foreach_function_command] = STATE(255),
    [sym_foreach_thread_command] = STATE(255),
    [sym_iter_flags_command] = STATE(255),
    [sym_iter_dbta_command] = STATE(255),
    [sym_iter_dbtb_command] = STATE(255),
    [sym_iter_dbts_command] = STATE(255),
    [sym_iter_file_lines_command] = STATE(255),
    [sym_iter_offsets_command] = STATE(255),
    [sym_iter_sdbquery_command] = STATE(255),
    [sym_iter_threads_command] = STATE(255),
    [sym_iter_bbs_command] = STATE(255),
    [sym_iter_instrs_command] = STATE(255),
    [sym_iter_sections_command] = STATE(255),
    [sym_iter_functions_command] = STATE(255),
    [sym_iter_step_command] = STATE(255),
    [sym_iter_interpret_command] = STATE(255),
    [sym_iter_hit_command] = STATE(255),
    [sym_tmp_seek_command] = STATE(255),
    [sym_tmp_blksz_command] = STATE(255),
    [sym_tmp_fromto_command] = STATE(255),
    [sym_tmp_arch_command] = STATE(255),
    [sym_tmp_bits_command] = STATE(255),
    [sym_tmp_nthi_command] = STATE(255),
    [sym_tmp_eval_command] = STATE(255),
    [sym_tmp_fs_command] = STATE(255),
    [sym_tmp_reli_command] = STATE(255),
    [sym_tmp_kuery_command] = STATE(255),
    [sym_tmp_fd_command] = STATE(255),
    [sym_tmp_reg_command] = STATE(255),
    [sym_tmp_file_command] = STATE(255),
    [sym_tmp_string_command] = STATE(255),
    [sym_tmp_hex_command] = STATE(255),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(255),
    [sym_number_command] = STATE(255),
    [sym_help_command] = STATE(255),
    [sym_arged_command] = STATE(255),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(255),
    [sym_Cf_cmd] = STATE(255),
    [sym_pf_new_cmd] = STATE(255),
    [sym_pf_dot_cmd] = STATE(255),
    [sym_pf_cmd] = STATE(255),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(255),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(255),
    [sym__dec_number] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(67),
    [anon_sym_PIPEH] = ACTIONS(65),
    [anon_sym_PIPET] = ACTIONS(65),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(65),
    [anon_sym_AT_AT_ATb] = ACTIONS(65),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(65),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(65),
    [anon_sym_AT_AT_ATi] = ACTIONS(65),
    [anon_sym_AT_AT_ATr] = ACTIONS(65),
    [anon_sym_AT_AT_ATs] = ACTIONS(67),
    [anon_sym_AT_AT_ATst] = ACTIONS(65),
    [anon_sym_AT_AT_ATS] = ACTIONS(65),
    [anon_sym_AT_AT_ATm] = ACTIONS(65),
    [anon_sym_AT_AT_ATM] = ACTIONS(65),
    [anon_sym_AT_AT_ATf] = ACTIONS(67),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(65),
    [anon_sym_AT_AT_ATF] = ACTIONS(67),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(65),
    [anon_sym_AT_AT_ATt] = ACTIONS(65),
    [anon_sym_AT_AT] = ACTIONS(67),
    [anon_sym_AT_ATdbt] = ACTIONS(67),
    [anon_sym_AT_ATdbta] = ACTIONS(65),
    [anon_sym_AT_ATdbtb] = ACTIONS(65),
    [anon_sym_AT_ATdbts] = ACTIONS(65),
    [anon_sym_AT_AT_DOT] = ACTIONS(65),
    [anon_sym_AT_AT_EQ] = ACTIONS(65),
    [anon_sym_AT_ATk] = ACTIONS(65),
    [anon_sym_AT_ATt] = ACTIONS(65),
    [anon_sym_AT_ATb] = ACTIONS(65),
    [anon_sym_AT_ATi] = ACTIONS(67),
    [anon_sym_AT_ATiS] = ACTIONS(65),
    [anon_sym_AT_ATf] = ACTIONS(65),
    [anon_sym_AT_ATs_COLON] = ACTIONS(65),
    [anon_sym_AT_ATc_COLON] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_AT_BANG] = ACTIONS(65),
    [anon_sym_AT_LBRACE] = ACTIONS(65),
    [anon_sym_ATa_COLON] = ACTIONS(65),
    [anon_sym_ATb_COLON] = ACTIONS(65),
    [anon_sym_ATB_COLON] = ACTIONS(65),
    [anon_sym_ATe_COLON] = ACTIONS(65),
    [anon_sym_ATF_COLON] = ACTIONS(65),
    [anon_sym_ATi_COLON] = ACTIONS(65),
    [anon_sym_ATk_COLON] = ACTIONS(65),
    [anon_sym_ATo_COLON] = ACTIONS(65),
    [anon_sym_ATr_COLON] = ACTIONS(65),
    [anon_sym_ATf_COLON] = ACTIONS(65),
    [anon_sym_ATs_COLON] = ACTIONS(65),
    [anon_sym_ATx_COLON] = ACTIONS(65),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_PIPE_DOT] = ACTIONS(65),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(65),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(65),
    [sym_html_redirect_operator] = ACTIONS(67),
    [sym_html_append_operator] = ACTIONS(65),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(65),
    [anon_sym_CR] = ACTIONS(65),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
    [sym_file_descriptor] = ACTIONS(65),
  },
  [3] = {
    [sym_legacy_quoted_command] = STATE(271),
    [sym__simple_command] = STATE(271),
    [sym__tmp_command] = STATE(271),
    [sym__iter_command] = STATE(271),
    [sym__foreach_command] = STATE(271),
    [sym__pipe_command] = STATE(271),
    [sym_grep_command] = STATE(271),
    [sym_html_disable_command] = STATE(271),
    [sym_html_enable_command] = STATE(271),
    [sym_scr_tts_command] = STATE(271),
    [sym_pipe_command] = STATE(271),
    [sym_foreach_addrsize_command] = STATE(271),
    [sym_foreach_bb_command] = STATE(271),
    [sym_foreach_cmd_command] = STATE(271),
    [sym_foreach_comment_command] = STATE(271),
    [sym_foreach_import_command] = STATE(271),
    [sym_foreach_register_command] = STATE(271),
    [sym_foreach_symbol_command] = STATE(271),
    [sym_foreach_string_command] = STATE(271),
    [sym_foreach_section_command] = STATE(271),
    [sym_foreach_iomap_command] = STATE(271),
    [sym_foreach_dbgmap_command] = STATE(271),
    [sym_foreach_flag_command] = STATE(271),
    [sym_foreach_function_command] = STATE(271),
    [sym_foreach_thread_command] = STATE(271),
    [sym_iter_flags_command] = STATE(271),
    [sym_iter_dbta_command] = STATE(271),
    [sym_iter_dbtb_command] = STATE(271),
    [sym_iter_dbts_command] = STATE(271),
    [sym_iter_file_lines_command] = STATE(271),
    [sym_iter_offsets_command] = STATE(271),
    [sym_iter_sdbquery_command] = STATE(271),
    [sym_iter_threads_command] = STATE(271),
    [sym_iter_bbs_command] = STATE(271),
    [sym_iter_instrs_command] = STATE(271),
    [sym_iter_sections_command] = STATE(271),
    [sym_iter_functions_command] = STATE(271),
    [sym_iter_step_command] = STATE(271),
    [sym_iter_interpret_command] = STATE(271),
    [sym_iter_hit_command] = STATE(271),
    [sym_tmp_seek_command] = STATE(271),
    [sym_tmp_blksz_command] = STATE(271),
    [sym_tmp_fromto_command] = STATE(271),
    [sym_tmp_arch_command] = STATE(271),
    [sym_tmp_bits_command] = STATE(271),
    [sym_tmp_nthi_command] = STATE(271),
    [sym_tmp_eval_command] = STATE(271),
    [sym_tmp_fs_command] = STATE(271),
    [sym_tmp_reli_command] = STATE(271),
    [sym_tmp_kuery_command] = STATE(271),
    [sym_tmp_fd_command] = STATE(271),
    [sym_tmp_reg_command] = STATE(271),
    [sym_tmp_file_command] = STATE(271),
    [sym_tmp_string_command] = STATE(271),
    [sym_tmp_hex_command] = STATE(271),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(271),
    [sym_number_command] = STATE(271),
    [sym_help_command] = STATE(271),
    [sym_arged_command] = STATE(271),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(271),
    [sym_Cf_cmd] = STATE(271),
    [sym_pf_new_cmd] = STATE(271),
    [sym_pf_dot_cmd] = STATE(271),
    [sym_pf_cmd] = STATE(271),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(271),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(271),
    [sym__dec_number] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_PIPE] = ACTIONS(71),
    [anon_sym_PIPEH] = ACTIONS(69),
    [anon_sym_PIPET] = ACTIONS(69),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(69),
    [anon_sym_AT_AT_ATb] = ACTIONS(69),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATi] = ACTIONS(69),
    [anon_sym_AT_AT_ATr] = ACTIONS(69),
    [anon_sym_AT_AT_ATs] = ACTIONS(71),
    [anon_sym_AT_AT_ATst] = ACTIONS(69),
    [anon_sym_AT_AT_ATS] = ACTIONS(69),
    [anon_sym_AT_AT_ATm] = ACTIONS(69),
    [anon_sym_AT_AT_ATM] = ACTIONS(69),
    [anon_sym_AT_AT_ATf] = ACTIONS(71),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATF] = ACTIONS(71),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATt] = ACTIONS(69),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_AT_ATdbt] = ACTIONS(71),
    [anon_sym_AT_ATdbta] = ACTIONS(69),
    [anon_sym_AT_ATdbtb] = ACTIONS(69),
    [anon_sym_AT_ATdbts] = ACTIONS(69),
    [anon_sym_AT_AT_DOT] = ACTIONS(69),
    [anon_sym_AT_AT_EQ] = ACTIONS(69),
    [anon_sym_AT_ATk] = ACTIONS(69),
    [anon_sym_AT_ATt] = ACTIONS(69),
    [anon_sym_AT_ATb] = ACTIONS(69),
    [anon_sym_AT_ATi] = ACTIONS(71),
    [anon_sym_AT_ATiS] = ACTIONS(69),
    [anon_sym_AT_ATf] = ACTIONS(69),
    [anon_sym_AT_ATs_COLON] = ACTIONS(69),
    [anon_sym_AT_ATc_COLON] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(71),
    [anon_sym_AT_BANG] = ACTIONS(69),
    [anon_sym_AT_LBRACE] = ACTIONS(69),
    [anon_sym_ATa_COLON] = ACTIONS(69),
    [anon_sym_ATb_COLON] = ACTIONS(69),
    [anon_sym_ATB_COLON] = ACTIONS(69),
    [anon_sym_ATe_COLON] = ACTIONS(69),
    [anon_sym_ATF_COLON] = ACTIONS(69),
    [anon_sym_ATi_COLON] = ACTIONS(69),
    [anon_sym_ATk_COLON] = ACTIONS(69),
    [anon_sym_ATo_COLON] = ACTIONS(69),
    [anon_sym_ATr_COLON] = ACTIONS(69),
    [anon_sym_ATf_COLON] = ACTIONS(69),
    [anon_sym_ATs_COLON] = ACTIONS(69),
    [anon_sym_ATx_COLON] = ACTIONS(69),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_PIPE_DOT] = ACTIONS(69),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(69),
    [sym_html_redirect_operator] = ACTIONS(71),
    [sym_html_append_operator] = ACTIONS(69),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(69),
    [anon_sym_CR] = ACTIONS(69),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
    [sym_file_descriptor] = ACTIONS(69),
  },
  [4] = {
    [sym_legacy_quoted_command] = STATE(241),
    [sym__simple_command] = STATE(241),
    [sym__tmp_command] = STATE(241),
    [sym__iter_command] = STATE(241),
    [sym__foreach_command] = STATE(241),
    [sym__pipe_command] = STATE(241),
    [sym_grep_command] = STATE(241),
    [sym_html_disable_command] = STATE(241),
    [sym_html_enable_command] = STATE(241),
    [sym_scr_tts_command] = STATE(241),
    [sym_pipe_command] = STATE(241),
    [sym_foreach_addrsize_command] = STATE(241),
    [sym_foreach_bb_command] = STATE(241),
    [sym_foreach_cmd_command] = STATE(241),
    [sym_foreach_comment_command] = STATE(241),
    [sym_foreach_import_command] = STATE(241),
    [sym_foreach_register_command] = STATE(241),
    [sym_foreach_symbol_command] = STATE(241),
    [sym_foreach_string_command] = STATE(241),
    [sym_foreach_section_command] = STATE(241),
    [sym_foreach_iomap_command] = STATE(241),
    [sym_foreach_dbgmap_command] = STATE(241),
    [sym_foreach_flag_command] = STATE(241),
    [sym_foreach_function_command] = STATE(241),
    [sym_foreach_thread_command] = STATE(241),
    [sym_iter_flags_command] = STATE(241),
    [sym_iter_dbta_command] = STATE(241),
    [sym_iter_dbtb_command] = STATE(241),
    [sym_iter_dbts_command] = STATE(241),
    [sym_iter_file_lines_command] = STATE(241),
    [sym_iter_offsets_command] = STATE(241),
    [sym_iter_sdbquery_command] = STATE(241),
    [sym_iter_threads_command] = STATE(241),
    [sym_iter_bbs_command] = STATE(241),
    [sym_iter_instrs_command] = STATE(241),
    [sym_iter_sections_command] = STATE(241),
    [sym_iter_functions_command] = STATE(241),
    [sym_iter_step_command] = STATE(241),
    [sym_iter_interpret_command] = STATE(241),
    [sym_iter_hit_command] = STATE(241),
    [sym_tmp_seek_command] = STATE(241),
    [sym_tmp_blksz_command] = STATE(241),
    [sym_tmp_fromto_command] = STATE(241),
    [sym_tmp_arch_command] = STATE(241),
    [sym_tmp_bits_command] = STATE(241),
    [sym_tmp_nthi_command] = STATE(241),
    [sym_tmp_eval_command] = STATE(241),
    [sym_tmp_fs_command] = STATE(241),
    [sym_tmp_reli_command] = STATE(241),
    [sym_tmp_kuery_command] = STATE(241),
    [sym_tmp_fd_command] = STATE(241),
    [sym_tmp_reg_command] = STATE(241),
    [sym_tmp_file_command] = STATE(241),
    [sym_tmp_string_command] = STATE(241),
    [sym_tmp_hex_command] = STATE(241),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(241),
    [sym_number_command] = STATE(241),
    [sym_help_command] = STATE(241),
    [sym_arged_command] = STATE(241),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(241),
    [sym_Cf_cmd] = STATE(241),
    [sym_pf_new_cmd] = STATE(241),
    [sym_pf_dot_cmd] = STATE(241),
    [sym_pf_cmd] = STATE(241),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(241),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(241),
    [sym__dec_number] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_PIPE] = ACTIONS(75),
    [anon_sym_PIPEH] = ACTIONS(73),
    [anon_sym_PIPET] = ACTIONS(73),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(73),
    [anon_sym_AT_AT_ATb] = ACTIONS(73),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(73),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(73),
    [anon_sym_AT_AT_ATi] = ACTIONS(73),
    [anon_sym_AT_AT_ATr] = ACTIONS(73),
    [anon_sym_AT_AT_ATs] = ACTIONS(75),
    [anon_sym_AT_AT_ATst] = ACTIONS(73),
    [anon_sym_AT_AT_ATS] = ACTIONS(73),
    [anon_sym_AT_AT_ATm] = ACTIONS(73),
    [anon_sym_AT_AT_ATM] = ACTIONS(73),
    [anon_sym_AT_AT_ATf] = ACTIONS(75),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(73),
    [anon_sym_AT_AT_ATF] = ACTIONS(75),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(73),
    [anon_sym_AT_AT_ATt] = ACTIONS(73),
    [anon_sym_AT_AT] = ACTIONS(75),
    [anon_sym_AT_ATdbt] = ACTIONS(75),
    [anon_sym_AT_ATdbta] = ACTIONS(73),
    [anon_sym_AT_ATdbtb] = ACTIONS(73),
    [anon_sym_AT_ATdbts] = ACTIONS(73),
    [anon_sym_AT_AT_DOT] = ACTIONS(73),
    [anon_sym_AT_AT_EQ] = ACTIONS(73),
    [anon_sym_AT_ATk] = ACTIONS(73),
    [anon_sym_AT_ATt] = ACTIONS(73),
    [anon_sym_AT_ATb] = ACTIONS(73),
    [anon_sym_AT_ATi] = ACTIONS(75),
    [anon_sym_AT_ATiS] = ACTIONS(73),
    [anon_sym_AT_ATf] = ACTIONS(73),
    [anon_sym_AT_ATs_COLON] = ACTIONS(73),
    [anon_sym_AT_ATc_COLON] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_AT_BANG] = ACTIONS(73),
    [anon_sym_AT_LBRACE] = ACTIONS(73),
    [anon_sym_ATa_COLON] = ACTIONS(73),
    [anon_sym_ATb_COLON] = ACTIONS(73),
    [anon_sym_ATB_COLON] = ACTIONS(73),
    [anon_sym_ATe_COLON] = ACTIONS(73),
    [anon_sym_ATF_COLON] = ACTIONS(73),
    [anon_sym_ATi_COLON] = ACTIONS(73),
    [anon_sym_ATk_COLON] = ACTIONS(73),
    [anon_sym_ATo_COLON] = ACTIONS(73),
    [anon_sym_ATr_COLON] = ACTIONS(73),
    [anon_sym_ATf_COLON] = ACTIONS(73),
    [anon_sym_ATs_COLON] = ACTIONS(73),
    [anon_sym_ATx_COLON] = ACTIONS(73),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_PIPE_DOT] = ACTIONS(73),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(73),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(73),
    [anon_sym_GT] = ACTIONS(75),
    [anon_sym_GT_GT] = ACTIONS(73),
    [sym_html_redirect_operator] = ACTIONS(75),
    [sym_html_append_operator] = ACTIONS(73),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(73),
    [anon_sym_CR] = ACTIONS(73),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
    [sym_file_descriptor] = ACTIONS(73),
  },
  [5] = {
    [sym_legacy_quoted_command] = STATE(255),
    [sym__simple_command] = STATE(255),
    [sym__tmp_command] = STATE(255),
    [sym__iter_command] = STATE(255),
    [sym__foreach_command] = STATE(255),
    [sym__pipe_command] = STATE(255),
    [sym_grep_command] = STATE(255),
    [sym_html_disable_command] = STATE(255),
    [sym_html_enable_command] = STATE(255),
    [sym_scr_tts_command] = STATE(255),
    [sym_pipe_command] = STATE(255),
    [sym_foreach_addrsize_command] = STATE(255),
    [sym_foreach_bb_command] = STATE(255),
    [sym_foreach_cmd_command] = STATE(255),
    [sym_foreach_comment_command] = STATE(255),
    [sym_foreach_import_command] = STATE(255),
    [sym_foreach_register_command] = STATE(255),
    [sym_foreach_symbol_command] = STATE(255),
    [sym_foreach_string_command] = STATE(255),
    [sym_foreach_section_command] = STATE(255),
    [sym_foreach_iomap_command] = STATE(255),
    [sym_foreach_dbgmap_command] = STATE(255),
    [sym_foreach_flag_command] = STATE(255),
    [sym_foreach_function_command] = STATE(255),
    [sym_foreach_thread_command] = STATE(255),
    [sym_iter_flags_command] = STATE(255),
    [sym_iter_dbta_command] = STATE(255),
    [sym_iter_dbtb_command] = STATE(255),
    [sym_iter_dbts_command] = STATE(255),
    [sym_iter_file_lines_command] = STATE(255),
    [sym_iter_offsets_command] = STATE(255),
    [sym_iter_sdbquery_command] = STATE(255),
    [sym_iter_threads_command] = STATE(255),
    [sym_iter_bbs_command] = STATE(255),
    [sym_iter_instrs_command] = STATE(255),
    [sym_iter_sections_command] = STATE(255),
    [sym_iter_functions_command] = STATE(255),
    [sym_iter_step_command] = STATE(255),
    [sym_iter_interpret_command] = STATE(255),
    [sym_iter_hit_command] = STATE(255),
    [sym_tmp_seek_command] = STATE(255),
    [sym_tmp_blksz_command] = STATE(255),
    [sym_tmp_fromto_command] = STATE(255),
    [sym_tmp_arch_command] = STATE(255),
    [sym_tmp_bits_command] = STATE(255),
    [sym_tmp_nthi_command] = STATE(255),
    [sym_tmp_eval_command] = STATE(255),
    [sym_tmp_fs_command] = STATE(255),
    [sym_tmp_reli_command] = STATE(255),
    [sym_tmp_kuery_command] = STATE(255),
    [sym_tmp_fd_command] = STATE(255),
    [sym_tmp_reg_command] = STATE(255),
    [sym_tmp_file_command] = STATE(255),
    [sym_tmp_string_command] = STATE(255),
    [sym_tmp_hex_command] = STATE(255),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(255),
    [sym_number_command] = STATE(255),
    [sym_help_command] = STATE(255),
    [sym_arged_command] = STATE(255),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(255),
    [sym_Cf_cmd] = STATE(255),
    [sym_pf_new_cmd] = STATE(255),
    [sym_pf_dot_cmd] = STATE(255),
    [sym_pf_cmd] = STATE(255),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(255),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(255),
    [sym__dec_number] = STATE(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(67),
    [anon_sym_PIPEH] = ACTIONS(65),
    [anon_sym_PIPET] = ACTIONS(65),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(65),
    [anon_sym_AT_AT_ATb] = ACTIONS(65),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(65),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(65),
    [anon_sym_AT_AT_ATi] = ACTIONS(65),
    [anon_sym_AT_AT_ATr] = ACTIONS(65),
    [anon_sym_AT_AT_ATs] = ACTIONS(67),
    [anon_sym_AT_AT_ATst] = ACTIONS(65),
    [anon_sym_AT_AT_ATS] = ACTIONS(65),
    [anon_sym_AT_AT_ATm] = ACTIONS(65),
    [anon_sym_AT_AT_ATM] = ACTIONS(65),
    [anon_sym_AT_AT_ATf] = ACTIONS(67),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(65),
    [anon_sym_AT_AT_ATF] = ACTIONS(67),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(65),
    [anon_sym_AT_AT_ATt] = ACTIONS(65),
    [anon_sym_AT_AT] = ACTIONS(67),
    [anon_sym_AT_ATdbt] = ACTIONS(67),
    [anon_sym_AT_ATdbta] = ACTIONS(65),
    [anon_sym_AT_ATdbtb] = ACTIONS(65),
    [anon_sym_AT_ATdbts] = ACTIONS(65),
    [anon_sym_AT_AT_DOT] = ACTIONS(65),
    [anon_sym_AT_AT_EQ] = ACTIONS(65),
    [anon_sym_AT_ATk] = ACTIONS(65),
    [anon_sym_AT_ATt] = ACTIONS(65),
    [anon_sym_AT_ATb] = ACTIONS(65),
    [anon_sym_AT_ATi] = ACTIONS(67),
    [anon_sym_AT_ATiS] = ACTIONS(65),
    [anon_sym_AT_ATf] = ACTIONS(65),
    [anon_sym_AT_ATs_COLON] = ACTIONS(65),
    [anon_sym_AT_ATc_COLON] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_AT_BANG] = ACTIONS(65),
    [anon_sym_AT_LBRACE] = ACTIONS(65),
    [anon_sym_ATa_COLON] = ACTIONS(65),
    [anon_sym_ATb_COLON] = ACTIONS(65),
    [anon_sym_ATB_COLON] = ACTIONS(65),
    [anon_sym_ATe_COLON] = ACTIONS(65),
    [anon_sym_ATF_COLON] = ACTIONS(65),
    [anon_sym_ATi_COLON] = ACTIONS(65),
    [anon_sym_ATk_COLON] = ACTIONS(65),
    [anon_sym_ATo_COLON] = ACTIONS(65),
    [anon_sym_ATr_COLON] = ACTIONS(65),
    [anon_sym_ATf_COLON] = ACTIONS(65),
    [anon_sym_ATs_COLON] = ACTIONS(65),
    [anon_sym_ATx_COLON] = ACTIONS(65),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_PIPE_DOT] = ACTIONS(65),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(65),
    [anon_sym_GT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(65),
    [sym_html_redirect_operator] = ACTIONS(67),
    [sym_html_append_operator] = ACTIONS(65),
    [anon_sym_BQUOTE] = ACTIONS(65),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
    [sym_file_descriptor] = ACTIONS(65),
  },
  [6] = {
    [sym_legacy_quoted_command] = STATE(271),
    [sym__simple_command] = STATE(271),
    [sym__tmp_command] = STATE(271),
    [sym__iter_command] = STATE(271),
    [sym__foreach_command] = STATE(271),
    [sym__pipe_command] = STATE(271),
    [sym_grep_command] = STATE(271),
    [sym_html_disable_command] = STATE(271),
    [sym_html_enable_command] = STATE(271),
    [sym_scr_tts_command] = STATE(271),
    [sym_pipe_command] = STATE(271),
    [sym_foreach_addrsize_command] = STATE(271),
    [sym_foreach_bb_command] = STATE(271),
    [sym_foreach_cmd_command] = STATE(271),
    [sym_foreach_comment_command] = STATE(271),
    [sym_foreach_import_command] = STATE(271),
    [sym_foreach_register_command] = STATE(271),
    [sym_foreach_symbol_command] = STATE(271),
    [sym_foreach_string_command] = STATE(271),
    [sym_foreach_section_command] = STATE(271),
    [sym_foreach_iomap_command] = STATE(271),
    [sym_foreach_dbgmap_command] = STATE(271),
    [sym_foreach_flag_command] = STATE(271),
    [sym_foreach_function_command] = STATE(271),
    [sym_foreach_thread_command] = STATE(271),
    [sym_iter_flags_command] = STATE(271),
    [sym_iter_dbta_command] = STATE(271),
    [sym_iter_dbtb_command] = STATE(271),
    [sym_iter_dbts_command] = STATE(271),
    [sym_iter_file_lines_command] = STATE(271),
    [sym_iter_offsets_command] = STATE(271),
    [sym_iter_sdbquery_command] = STATE(271),
    [sym_iter_threads_command] = STATE(271),
    [sym_iter_bbs_command] = STATE(271),
    [sym_iter_instrs_command] = STATE(271),
    [sym_iter_sections_command] = STATE(271),
    [sym_iter_functions_command] = STATE(271),
    [sym_iter_step_command] = STATE(271),
    [sym_iter_interpret_command] = STATE(271),
    [sym_iter_hit_command] = STATE(271),
    [sym_tmp_seek_command] = STATE(271),
    [sym_tmp_blksz_command] = STATE(271),
    [sym_tmp_fromto_command] = STATE(271),
    [sym_tmp_arch_command] = STATE(271),
    [sym_tmp_bits_command] = STATE(271),
    [sym_tmp_nthi_command] = STATE(271),
    [sym_tmp_eval_command] = STATE(271),
    [sym_tmp_fs_command] = STATE(271),
    [sym_tmp_reli_command] = STATE(271),
    [sym_tmp_kuery_command] = STATE(271),
    [sym_tmp_fd_command] = STATE(271),
    [sym_tmp_reg_command] = STATE(271),
    [sym_tmp_file_command] = STATE(271),
    [sym_tmp_string_command] = STATE(271),
    [sym_tmp_hex_command] = STATE(271),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(271),
    [sym_number_command] = STATE(271),
    [sym_help_command] = STATE(271),
    [sym_arged_command] = STATE(271),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(271),
    [sym_Cf_cmd] = STATE(271),
    [sym_pf_new_cmd] = STATE(271),
    [sym_pf_dot_cmd] = STATE(271),
    [sym_pf_cmd] = STATE(271),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(271),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(271),
    [sym__dec_number] = STATE(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_PIPE] = ACTIONS(71),
    [anon_sym_PIPEH] = ACTIONS(69),
    [anon_sym_PIPET] = ACTIONS(69),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(69),
    [anon_sym_AT_AT_ATb] = ACTIONS(69),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATi] = ACTIONS(69),
    [anon_sym_AT_AT_ATr] = ACTIONS(69),
    [anon_sym_AT_AT_ATs] = ACTIONS(71),
    [anon_sym_AT_AT_ATst] = ACTIONS(69),
    [anon_sym_AT_AT_ATS] = ACTIONS(69),
    [anon_sym_AT_AT_ATm] = ACTIONS(69),
    [anon_sym_AT_AT_ATM] = ACTIONS(69),
    [anon_sym_AT_AT_ATf] = ACTIONS(71),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATF] = ACTIONS(71),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATt] = ACTIONS(69),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_AT_ATdbt] = ACTIONS(71),
    [anon_sym_AT_ATdbta] = ACTIONS(69),
    [anon_sym_AT_ATdbtb] = ACTIONS(69),
    [anon_sym_AT_ATdbts] = ACTIONS(69),
    [anon_sym_AT_AT_DOT] = ACTIONS(69),
    [anon_sym_AT_AT_EQ] = ACTIONS(69),
    [anon_sym_AT_ATk] = ACTIONS(69),
    [anon_sym_AT_ATt] = ACTIONS(69),
    [anon_sym_AT_ATb] = ACTIONS(69),
    [anon_sym_AT_ATi] = ACTIONS(71),
    [anon_sym_AT_ATiS] = ACTIONS(69),
    [anon_sym_AT_ATf] = ACTIONS(69),
    [anon_sym_AT_ATs_COLON] = ACTIONS(69),
    [anon_sym_AT_ATc_COLON] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(71),
    [anon_sym_AT_BANG] = ACTIONS(69),
    [anon_sym_AT_LBRACE] = ACTIONS(69),
    [anon_sym_ATa_COLON] = ACTIONS(69),
    [anon_sym_ATb_COLON] = ACTIONS(69),
    [anon_sym_ATB_COLON] = ACTIONS(69),
    [anon_sym_ATe_COLON] = ACTIONS(69),
    [anon_sym_ATF_COLON] = ACTIONS(69),
    [anon_sym_ATi_COLON] = ACTIONS(69),
    [anon_sym_ATk_COLON] = ACTIONS(69),
    [anon_sym_ATo_COLON] = ACTIONS(69),
    [anon_sym_ATr_COLON] = ACTIONS(69),
    [anon_sym_ATf_COLON] = ACTIONS(69),
    [anon_sym_ATs_COLON] = ACTIONS(69),
    [anon_sym_ATx_COLON] = ACTIONS(69),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_PIPE_DOT] = ACTIONS(69),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(69),
    [sym_html_redirect_operator] = ACTIONS(71),
    [sym_html_append_operator] = ACTIONS(69),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
    [sym_file_descriptor] = ACTIONS(69),
  },
  [7] = {
    [sym_legacy_quoted_command] = STATE(241),
    [sym__simple_command] = STATE(241),
    [sym__tmp_command] = STATE(241),
    [sym__iter_command] = STATE(241),
    [sym__foreach_command] = STATE(241),
    [sym__pipe_command] = STATE(241),
    [sym_grep_command] = STATE(241),
    [sym_html_disable_command] = STATE(241),
    [sym_html_enable_command] = STATE(241),
    [sym_scr_tts_command] = STATE(241),
    [sym_pipe_command] = STATE(241),
    [sym_foreach_addrsize_command] = STATE(241),
    [sym_foreach_bb_command] = STATE(241),
    [sym_foreach_cmd_command] = STATE(241),
    [sym_foreach_comment_command] = STATE(241),
    [sym_foreach_import_command] = STATE(241),
    [sym_foreach_register_command] = STATE(241),
    [sym_foreach_symbol_command] = STATE(241),
    [sym_foreach_string_command] = STATE(241),
    [sym_foreach_section_command] = STATE(241),
    [sym_foreach_iomap_command] = STATE(241),
    [sym_foreach_dbgmap_command] = STATE(241),
    [sym_foreach_flag_command] = STATE(241),
    [sym_foreach_function_command] = STATE(241),
    [sym_foreach_thread_command] = STATE(241),
    [sym_iter_flags_command] = STATE(241),
    [sym_iter_dbta_command] = STATE(241),
    [sym_iter_dbtb_command] = STATE(241),
    [sym_iter_dbts_command] = STATE(241),
    [sym_iter_file_lines_command] = STATE(241),
    [sym_iter_offsets_command] = STATE(241),
    [sym_iter_sdbquery_command] = STATE(241),
    [sym_iter_threads_command] = STATE(241),
    [sym_iter_bbs_command] = STATE(241),
    [sym_iter_instrs_command] = STATE(241),
    [sym_iter_sections_command] = STATE(241),
    [sym_iter_functions_command] = STATE(241),
    [sym_iter_step_command] = STATE(241),
    [sym_iter_interpret_command] = STATE(241),
    [sym_iter_hit_command] = STATE(241),
    [sym_tmp_seek_command] = STATE(241),
    [sym_tmp_blksz_command] = STATE(241),
    [sym_tmp_fromto_command] = STATE(241),
    [sym_tmp_arch_command] = STATE(241),
    [sym_tmp_bits_command] = STATE(241),
    [sym_tmp_nthi_command] = STATE(241),
    [sym_tmp_eval_command] = STATE(241),
    [sym_tmp_fs_command] = STATE(241),
    [sym_tmp_reli_command] = STATE(241),
    [sym_tmp_kuery_command] = STATE(241),
    [sym_tmp_fd_command] = STATE(241),
    [sym_tmp_reg_command] = STATE(241),
    [sym_tmp_file_command] = STATE(241),
    [sym_tmp_string_command] = STATE(241),
    [sym_tmp_hex_command] = STATE(241),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(241),
    [sym_number_command] = STATE(241),
    [sym_help_command] = STATE(241),
    [sym_arged_command] = STATE(241),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(241),
    [sym_Cf_cmd] = STATE(241),
    [sym_pf_new_cmd] = STATE(241),
    [sym_pf_dot_cmd] = STATE(241),
    [sym_pf_cmd] = STATE(241),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(241),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(241),
    [sym__dec_number] = STATE(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(73),
    [anon_sym_PIPE] = ACTIONS(75),
    [anon_sym_PIPEH] = ACTIONS(73),
    [anon_sym_PIPET] = ACTIONS(73),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(73),
    [anon_sym_AT_AT_ATb] = ACTIONS(73),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(73),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(73),
    [anon_sym_AT_AT_ATi] = ACTIONS(73),
    [anon_sym_AT_AT_ATr] = ACTIONS(73),
    [anon_sym_AT_AT_ATs] = ACTIONS(75),
    [anon_sym_AT_AT_ATst] = ACTIONS(73),
    [anon_sym_AT_AT_ATS] = ACTIONS(73),
    [anon_sym_AT_AT_ATm] = ACTIONS(73),
    [anon_sym_AT_AT_ATM] = ACTIONS(73),
    [anon_sym_AT_AT_ATf] = ACTIONS(75),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(73),
    [anon_sym_AT_AT_ATF] = ACTIONS(75),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(73),
    [anon_sym_AT_AT_ATt] = ACTIONS(73),
    [anon_sym_AT_AT] = ACTIONS(75),
    [anon_sym_AT_ATdbt] = ACTIONS(75),
    [anon_sym_AT_ATdbta] = ACTIONS(73),
    [anon_sym_AT_ATdbtb] = ACTIONS(73),
    [anon_sym_AT_ATdbts] = ACTIONS(73),
    [anon_sym_AT_AT_DOT] = ACTIONS(73),
    [anon_sym_AT_AT_EQ] = ACTIONS(73),
    [anon_sym_AT_ATk] = ACTIONS(73),
    [anon_sym_AT_ATt] = ACTIONS(73),
    [anon_sym_AT_ATb] = ACTIONS(73),
    [anon_sym_AT_ATi] = ACTIONS(75),
    [anon_sym_AT_ATiS] = ACTIONS(73),
    [anon_sym_AT_ATf] = ACTIONS(73),
    [anon_sym_AT_ATs_COLON] = ACTIONS(73),
    [anon_sym_AT_ATc_COLON] = ACTIONS(73),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_AT_BANG] = ACTIONS(73),
    [anon_sym_AT_LBRACE] = ACTIONS(73),
    [anon_sym_ATa_COLON] = ACTIONS(73),
    [anon_sym_ATb_COLON] = ACTIONS(73),
    [anon_sym_ATB_COLON] = ACTIONS(73),
    [anon_sym_ATe_COLON] = ACTIONS(73),
    [anon_sym_ATF_COLON] = ACTIONS(73),
    [anon_sym_ATi_COLON] = ACTIONS(73),
    [anon_sym_ATk_COLON] = ACTIONS(73),
    [anon_sym_ATo_COLON] = ACTIONS(73),
    [anon_sym_ATr_COLON] = ACTIONS(73),
    [anon_sym_ATf_COLON] = ACTIONS(73),
    [anon_sym_ATs_COLON] = ACTIONS(73),
    [anon_sym_ATx_COLON] = ACTIONS(73),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_PIPE_DOT] = ACTIONS(73),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(73),
    [anon_sym_GT] = ACTIONS(75),
    [anon_sym_GT_GT] = ACTIONS(73),
    [sym_html_redirect_operator] = ACTIONS(75),
    [sym_html_append_operator] = ACTIONS(73),
    [anon_sym_BQUOTE] = ACTIONS(73),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
    [sym_file_descriptor] = ACTIONS(73),
  },
  [8] = {
    [sym__command] = STATE(455),
    [sym_legacy_quoted_command] = STATE(186),
    [sym__simple_command] = STATE(186),
    [sym__tmp_command] = STATE(186),
    [sym__iter_command] = STATE(186),
    [sym__foreach_command] = STATE(186),
    [sym__pipe_command] = STATE(186),
    [sym_grep_command] = STATE(186),
    [sym_html_disable_command] = STATE(186),
    [sym_html_enable_command] = STATE(186),
    [sym_scr_tts_command] = STATE(186),
    [sym_pipe_command] = STATE(186),
    [sym_foreach_addrsize_command] = STATE(186),
    [sym_foreach_bb_command] = STATE(186),
    [sym_foreach_cmd_command] = STATE(186),
    [sym_foreach_comment_command] = STATE(186),
    [sym_foreach_import_command] = STATE(186),
    [sym_foreach_register_command] = STATE(186),
    [sym_foreach_symbol_command] = STATE(186),
    [sym_foreach_string_command] = STATE(186),
    [sym_foreach_section_command] = STATE(186),
    [sym_foreach_iomap_command] = STATE(186),
    [sym_foreach_dbgmap_command] = STATE(186),
    [sym_foreach_flag_command] = STATE(186),
    [sym_foreach_function_command] = STATE(186),
    [sym_foreach_thread_command] = STATE(186),
    [sym_iter_flags_command] = STATE(186),
    [sym_iter_dbta_command] = STATE(186),
    [sym_iter_dbtb_command] = STATE(186),
    [sym_iter_dbts_command] = STATE(186),
    [sym_iter_file_lines_command] = STATE(186),
    [sym_iter_offsets_command] = STATE(186),
    [sym_iter_sdbquery_command] = STATE(186),
    [sym_iter_threads_command] = STATE(186),
    [sym_iter_bbs_command] = STATE(186),
    [sym_iter_instrs_command] = STATE(186),
    [sym_iter_sections_command] = STATE(186),
    [sym_iter_functions_command] = STATE(186),
    [sym_iter_step_command] = STATE(186),
    [sym_iter_interpret_command] = STATE(186),
    [sym_iter_hit_command] = STATE(186),
    [sym_tmp_seek_command] = STATE(186),
    [sym_tmp_blksz_command] = STATE(186),
    [sym_tmp_fromto_command] = STATE(186),
    [sym_tmp_arch_command] = STATE(186),
    [sym_tmp_bits_command] = STATE(186),
    [sym_tmp_nthi_command] = STATE(186),
    [sym_tmp_eval_command] = STATE(186),
    [sym_tmp_fs_command] = STATE(186),
    [sym_tmp_reli_command] = STATE(186),
    [sym_tmp_kuery_command] = STATE(186),
    [sym_tmp_fd_command] = STATE(186),
    [sym_tmp_reg_command] = STATE(186),
    [sym_tmp_file_command] = STATE(186),
    [sym_tmp_string_command] = STATE(186),
    [sym_tmp_hex_command] = STATE(186),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(186),
    [sym_number_command] = STATE(186),
    [sym_help_command] = STATE(186),
    [sym_arged_command] = STATE(186),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(186),
    [sym_Cf_cmd] = STATE(186),
    [sym_pf_new_cmd] = STATE(186),
    [sym_pf_dot_cmd] = STATE(186),
    [sym_pf_cmd] = STATE(186),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(186),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(186),
    [sym_redirect_command] = STATE(455),
    [sym__dec_number] = STATE(2),
    [aux_sym_commands_repeat1] = STATE(292),
    [ts_builtin_sym_end] = ACTIONS(107),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(109),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(109),
    [anon_sym_CR] = ACTIONS(109),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [9] = {
    [sym__command] = STATE(470),
    [sym_legacy_quoted_command] = STATE(186),
    [sym__simple_command] = STATE(186),
    [sym__tmp_command] = STATE(186),
    [sym__iter_command] = STATE(186),
    [sym__foreach_command] = STATE(186),
    [sym__pipe_command] = STATE(186),
    [sym_grep_command] = STATE(186),
    [sym_html_disable_command] = STATE(186),
    [sym_html_enable_command] = STATE(186),
    [sym_scr_tts_command] = STATE(186),
    [sym_pipe_command] = STATE(186),
    [sym_foreach_addrsize_command] = STATE(186),
    [sym_foreach_bb_command] = STATE(186),
    [sym_foreach_cmd_command] = STATE(186),
    [sym_foreach_comment_command] = STATE(186),
    [sym_foreach_import_command] = STATE(186),
    [sym_foreach_register_command] = STATE(186),
    [sym_foreach_symbol_command] = STATE(186),
    [sym_foreach_string_command] = STATE(186),
    [sym_foreach_section_command] = STATE(186),
    [sym_foreach_iomap_command] = STATE(186),
    [sym_foreach_dbgmap_command] = STATE(186),
    [sym_foreach_flag_command] = STATE(186),
    [sym_foreach_function_command] = STATE(186),
    [sym_foreach_thread_command] = STATE(186),
    [sym_iter_flags_command] = STATE(186),
    [sym_iter_dbta_command] = STATE(186),
    [sym_iter_dbtb_command] = STATE(186),
    [sym_iter_dbts_command] = STATE(186),
    [sym_iter_file_lines_command] = STATE(186),
    [sym_iter_offsets_command] = STATE(186),
    [sym_iter_sdbquery_command] = STATE(186),
    [sym_iter_threads_command] = STATE(186),
    [sym_iter_bbs_command] = STATE(186),
    [sym_iter_instrs_command] = STATE(186),
    [sym_iter_sections_command] = STATE(186),
    [sym_iter_functions_command] = STATE(186),
    [sym_iter_step_command] = STATE(186),
    [sym_iter_interpret_command] = STATE(186),
    [sym_iter_hit_command] = STATE(186),
    [sym_tmp_seek_command] = STATE(186),
    [sym_tmp_blksz_command] = STATE(186),
    [sym_tmp_fromto_command] = STATE(186),
    [sym_tmp_arch_command] = STATE(186),
    [sym_tmp_bits_command] = STATE(186),
    [sym_tmp_nthi_command] = STATE(186),
    [sym_tmp_eval_command] = STATE(186),
    [sym_tmp_fs_command] = STATE(186),
    [sym_tmp_reli_command] = STATE(186),
    [sym_tmp_kuery_command] = STATE(186),
    [sym_tmp_fd_command] = STATE(186),
    [sym_tmp_reg_command] = STATE(186),
    [sym_tmp_file_command] = STATE(186),
    [sym_tmp_string_command] = STATE(186),
    [sym_tmp_hex_command] = STATE(186),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(186),
    [sym_number_command] = STATE(186),
    [sym_help_command] = STATE(186),
    [sym_arged_command] = STATE(186),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(186),
    [sym_Cf_cmd] = STATE(186),
    [sym_pf_new_cmd] = STATE(186),
    [sym_pf_dot_cmd] = STATE(186),
    [sym_pf_cmd] = STATE(186),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(186),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(186),
    [sym_redirect_command] = STATE(470),
    [sym__dec_number] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(111),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(111),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(111),
    [anon_sym_CR] = ACTIONS(111),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [10] = {
    [sym__commands_singleline] = STATE(557),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [11] = {
    [sym__commands_singleline] = STATE(579),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [12] = {
    [sym__commands_singleline] = STATE(541),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [13] = {
    [sym__commands_singleline] = STATE(540),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [14] = {
    [sym__commands_singleline] = STATE(539),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [15] = {
    [sym__commands_singleline] = STATE(538),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [16] = {
    [sym__commands_singleline] = STATE(560),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [17] = {
    [sym__commands_singleline] = STATE(537),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [18] = {
    [sym__commands_singleline] = STATE(536),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [19] = {
    [sym__commands_singleline] = STATE(535),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [20] = {
    [sym__commands_singleline] = STATE(534),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [21] = {
    [sym__commands_singleline] = STATE(533),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [22] = {
    [sym__commands_singleline] = STATE(532),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [23] = {
    [sym__commands_singleline] = STATE(561),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [24] = {
    [sym__commands_singleline] = STATE(543),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [25] = {
    [sym__commands_singleline] = STATE(531),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [26] = {
    [sym__commands_singleline] = STATE(555),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [27] = {
    [sym__commands_singleline] = STATE(530),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [28] = {
    [sym__commands_singleline] = STATE(584),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [29] = {
    [sym__commands_singleline] = STATE(546),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [30] = {
    [sym__commands_singleline] = STATE(547),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [31] = {
    [sym__commands_singleline] = STATE(550),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [32] = {
    [sym__commands_singleline] = STATE(565),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [33] = {
    [sym__commands_singleline] = STATE(548),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [34] = {
    [sym__commands_singleline] = STATE(583),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [35] = {
    [sym__commands_singleline] = STATE(527),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [36] = {
    [sym__commands_singleline] = STATE(570),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [37] = {
    [sym__commands_singleline] = STATE(573),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [38] = {
    [sym__commands_singleline] = STATE(575),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [39] = {
    [sym__commands_singleline] = STATE(582),
    [sym__command] = STATE(492),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(492),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(44),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(113),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [40] = {
    [sym__commands_singleline] = STATE(558),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [41] = {
    [sym__commands_singleline] = STATE(542),
    [sym__command] = STATE(493),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(493),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(45),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(115),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [42] = {
    [sym__command] = STATE(491),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(491),
    [sym__dec_number] = STATE(2),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_RPAREN] = ACTIONS(117),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(117),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [43] = {
    [sym__command] = STATE(491),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(491),
    [sym__dec_number] = STATE(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(117),
    [anon_sym_BQUOTE] = ACTIONS(117),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [44] = {
    [sym__command] = STATE(506),
    [sym_legacy_quoted_command] = STATE(285),
    [sym__simple_command] = STATE(285),
    [sym__tmp_command] = STATE(285),
    [sym__iter_command] = STATE(285),
    [sym__foreach_command] = STATE(285),
    [sym__pipe_command] = STATE(285),
    [sym_grep_command] = STATE(285),
    [sym_html_disable_command] = STATE(285),
    [sym_html_enable_command] = STATE(285),
    [sym_scr_tts_command] = STATE(285),
    [sym_pipe_command] = STATE(285),
    [sym_foreach_addrsize_command] = STATE(285),
    [sym_foreach_bb_command] = STATE(285),
    [sym_foreach_cmd_command] = STATE(285),
    [sym_foreach_comment_command] = STATE(285),
    [sym_foreach_import_command] = STATE(285),
    [sym_foreach_register_command] = STATE(285),
    [sym_foreach_symbol_command] = STATE(285),
    [sym_foreach_string_command] = STATE(285),
    [sym_foreach_section_command] = STATE(285),
    [sym_foreach_iomap_command] = STATE(285),
    [sym_foreach_dbgmap_command] = STATE(285),
    [sym_foreach_flag_command] = STATE(285),
    [sym_foreach_function_command] = STATE(285),
    [sym_foreach_thread_command] = STATE(285),
    [sym_iter_flags_command] = STATE(285),
    [sym_iter_dbta_command] = STATE(285),
    [sym_iter_dbtb_command] = STATE(285),
    [sym_iter_dbts_command] = STATE(285),
    [sym_iter_file_lines_command] = STATE(285),
    [sym_iter_offsets_command] = STATE(285),
    [sym_iter_sdbquery_command] = STATE(285),
    [sym_iter_threads_command] = STATE(285),
    [sym_iter_bbs_command] = STATE(285),
    [sym_iter_instrs_command] = STATE(285),
    [sym_iter_sections_command] = STATE(285),
    [sym_iter_functions_command] = STATE(285),
    [sym_iter_step_command] = STATE(285),
    [sym_iter_interpret_command] = STATE(285),
    [sym_iter_hit_command] = STATE(285),
    [sym_tmp_seek_command] = STATE(285),
    [sym_tmp_blksz_command] = STATE(285),
    [sym_tmp_fromto_command] = STATE(285),
    [sym_tmp_arch_command] = STATE(285),
    [sym_tmp_bits_command] = STATE(285),
    [sym_tmp_nthi_command] = STATE(285),
    [sym_tmp_eval_command] = STATE(285),
    [sym_tmp_fs_command] = STATE(285),
    [sym_tmp_reli_command] = STATE(285),
    [sym_tmp_kuery_command] = STATE(285),
    [sym_tmp_fd_command] = STATE(285),
    [sym_tmp_reg_command] = STATE(285),
    [sym_tmp_file_command] = STATE(285),
    [sym_tmp_string_command] = STATE(285),
    [sym_tmp_hex_command] = STATE(285),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(285),
    [sym_number_command] = STATE(285),
    [sym_help_command] = STATE(285),
    [sym_arged_command] = STATE(285),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(285),
    [sym_Cf_cmd] = STATE(285),
    [sym_pf_new_cmd] = STATE(285),
    [sym_pf_dot_cmd] = STATE(285),
    [sym_pf_cmd] = STATE(285),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(285),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(285),
    [sym_redirect_command] = STATE(506),
    [sym__dec_number] = STATE(5),
    [aux_sym__commands_singleline_repeat1] = STATE(293),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(119),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [45] = {
    [sym__command] = STATE(495),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(495),
    [sym__dec_number] = STATE(2),
    [aux_sym__commands_singleline_repeat1] = STATE(293),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [anon_sym_SEMI] = ACTIONS(119),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [46] = {
    [sym__command] = STATE(522),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(522),
    [sym__dec_number] = STATE(2),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [47] = {
    [sym__command] = STATE(501),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(501),
    [sym__dec_number] = STATE(2),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [48] = {
    [sym__command] = STATE(496),
    [sym_legacy_quoted_command] = STATE(284),
    [sym__simple_command] = STATE(284),
    [sym__tmp_command] = STATE(284),
    [sym__iter_command] = STATE(284),
    [sym__foreach_command] = STATE(284),
    [sym__pipe_command] = STATE(284),
    [sym_grep_command] = STATE(284),
    [sym_html_disable_command] = STATE(284),
    [sym_html_enable_command] = STATE(284),
    [sym_scr_tts_command] = STATE(284),
    [sym_pipe_command] = STATE(284),
    [sym_foreach_addrsize_command] = STATE(284),
    [sym_foreach_bb_command] = STATE(284),
    [sym_foreach_cmd_command] = STATE(284),
    [sym_foreach_comment_command] = STATE(284),
    [sym_foreach_import_command] = STATE(284),
    [sym_foreach_register_command] = STATE(284),
    [sym_foreach_symbol_command] = STATE(284),
    [sym_foreach_string_command] = STATE(284),
    [sym_foreach_section_command] = STATE(284),
    [sym_foreach_iomap_command] = STATE(284),
    [sym_foreach_dbgmap_command] = STATE(284),
    [sym_foreach_flag_command] = STATE(284),
    [sym_foreach_function_command] = STATE(284),
    [sym_foreach_thread_command] = STATE(284),
    [sym_iter_flags_command] = STATE(284),
    [sym_iter_dbta_command] = STATE(284),
    [sym_iter_dbtb_command] = STATE(284),
    [sym_iter_dbts_command] = STATE(284),
    [sym_iter_file_lines_command] = STATE(284),
    [sym_iter_offsets_command] = STATE(284),
    [sym_iter_sdbquery_command] = STATE(284),
    [sym_iter_threads_command] = STATE(284),
    [sym_iter_bbs_command] = STATE(284),
    [sym_iter_instrs_command] = STATE(284),
    [sym_iter_sections_command] = STATE(284),
    [sym_iter_functions_command] = STATE(284),
    [sym_iter_step_command] = STATE(284),
    [sym_iter_interpret_command] = STATE(284),
    [sym_iter_hit_command] = STATE(284),
    [sym_tmp_seek_command] = STATE(284),
    [sym_tmp_blksz_command] = STATE(284),
    [sym_tmp_fromto_command] = STATE(284),
    [sym_tmp_arch_command] = STATE(284),
    [sym_tmp_bits_command] = STATE(284),
    [sym_tmp_nthi_command] = STATE(284),
    [sym_tmp_eval_command] = STATE(284),
    [sym_tmp_fs_command] = STATE(284),
    [sym_tmp_reli_command] = STATE(284),
    [sym_tmp_kuery_command] = STATE(284),
    [sym_tmp_fd_command] = STATE(284),
    [sym_tmp_reg_command] = STATE(284),
    [sym_tmp_file_command] = STATE(284),
    [sym_tmp_string_command] = STATE(284),
    [sym_tmp_hex_command] = STATE(284),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(284),
    [sym_number_command] = STATE(284),
    [sym_help_command] = STATE(284),
    [sym_arged_command] = STATE(284),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(284),
    [sym_Cf_cmd] = STATE(284),
    [sym_pf_new_cmd] = STATE(284),
    [sym_pf_dot_cmd] = STATE(284),
    [sym_pf_cmd] = STATE(284),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(284),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(284),
    [sym_redirect_command] = STATE(496),
    [sym__dec_number] = STATE(2),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [49] = {
    [sym_legacy_quoted_command] = STATE(281),
    [sym__simple_command] = STATE(281),
    [sym__tmp_command] = STATE(281),
    [sym__iter_command] = STATE(281),
    [sym__foreach_command] = STATE(281),
    [sym__pipe_command] = STATE(281),
    [sym_grep_command] = STATE(281),
    [sym_html_disable_command] = STATE(281),
    [sym_html_enable_command] = STATE(281),
    [sym_scr_tts_command] = STATE(281),
    [sym_pipe_command] = STATE(281),
    [sym_foreach_addrsize_command] = STATE(281),
    [sym_foreach_bb_command] = STATE(281),
    [sym_foreach_cmd_command] = STATE(281),
    [sym_foreach_comment_command] = STATE(281),
    [sym_foreach_import_command] = STATE(281),
    [sym_foreach_register_command] = STATE(281),
    [sym_foreach_symbol_command] = STATE(281),
    [sym_foreach_string_command] = STATE(281),
    [sym_foreach_section_command] = STATE(281),
    [sym_foreach_iomap_command] = STATE(281),
    [sym_foreach_dbgmap_command] = STATE(281),
    [sym_foreach_flag_command] = STATE(281),
    [sym_foreach_function_command] = STATE(281),
    [sym_foreach_thread_command] = STATE(281),
    [sym_iter_flags_command] = STATE(281),
    [sym_iter_dbta_command] = STATE(281),
    [sym_iter_dbtb_command] = STATE(281),
    [sym_iter_dbts_command] = STATE(281),
    [sym_iter_file_lines_command] = STATE(281),
    [sym_iter_offsets_command] = STATE(281),
    [sym_iter_sdbquery_command] = STATE(281),
    [sym_iter_threads_command] = STATE(281),
    [sym_iter_bbs_command] = STATE(281),
    [sym_iter_instrs_command] = STATE(281),
    [sym_iter_sections_command] = STATE(281),
    [sym_iter_functions_command] = STATE(281),
    [sym_iter_step_command] = STATE(281),
    [sym_iter_interpret_command] = STATE(281),
    [sym_iter_hit_command] = STATE(281),
    [sym_tmp_seek_command] = STATE(281),
    [sym_tmp_blksz_command] = STATE(281),
    [sym_tmp_fromto_command] = STATE(281),
    [sym_tmp_arch_command] = STATE(281),
    [sym_tmp_bits_command] = STATE(281),
    [sym_tmp_nthi_command] = STATE(281),
    [sym_tmp_eval_command] = STATE(281),
    [sym_tmp_fs_command] = STATE(281),
    [sym_tmp_reli_command] = STATE(281),
    [sym_tmp_kuery_command] = STATE(281),
    [sym_tmp_fd_command] = STATE(281),
    [sym_tmp_reg_command] = STATE(281),
    [sym_tmp_file_command] = STATE(281),
    [sym_tmp_string_command] = STATE(281),
    [sym_tmp_hex_command] = STATE(281),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(281),
    [sym_number_command] = STATE(281),
    [sym_help_command] = STATE(281),
    [sym_arged_command] = STATE(281),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(281),
    [sym_Cf_cmd] = STATE(281),
    [sym_pf_new_cmd] = STATE(281),
    [sym_pf_dot_cmd] = STATE(281),
    [sym_pf_cmd] = STATE(281),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(281),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(281),
    [sym__dec_number] = STATE(2),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [50] = {
    [sym_legacy_quoted_command] = STATE(283),
    [sym__simple_command] = STATE(283),
    [sym__tmp_command] = STATE(283),
    [sym__iter_command] = STATE(283),
    [sym__foreach_command] = STATE(283),
    [sym__pipe_command] = STATE(283),
    [sym_grep_command] = STATE(283),
    [sym_html_disable_command] = STATE(283),
    [sym_html_enable_command] = STATE(283),
    [sym_scr_tts_command] = STATE(283),
    [sym_pipe_command] = STATE(283),
    [sym_foreach_addrsize_command] = STATE(283),
    [sym_foreach_bb_command] = STATE(283),
    [sym_foreach_cmd_command] = STATE(283),
    [sym_foreach_comment_command] = STATE(283),
    [sym_foreach_import_command] = STATE(283),
    [sym_foreach_register_command] = STATE(283),
    [sym_foreach_symbol_command] = STATE(283),
    [sym_foreach_string_command] = STATE(283),
    [sym_foreach_section_command] = STATE(283),
    [sym_foreach_iomap_command] = STATE(283),
    [sym_foreach_dbgmap_command] = STATE(283),
    [sym_foreach_flag_command] = STATE(283),
    [sym_foreach_function_command] = STATE(283),
    [sym_foreach_thread_command] = STATE(283),
    [sym_iter_flags_command] = STATE(283),
    [sym_iter_dbta_command] = STATE(283),
    [sym_iter_dbtb_command] = STATE(283),
    [sym_iter_dbts_command] = STATE(283),
    [sym_iter_file_lines_command] = STATE(283),
    [sym_iter_offsets_command] = STATE(283),
    [sym_iter_sdbquery_command] = STATE(283),
    [sym_iter_threads_command] = STATE(283),
    [sym_iter_bbs_command] = STATE(283),
    [sym_iter_instrs_command] = STATE(283),
    [sym_iter_sections_command] = STATE(283),
    [sym_iter_functions_command] = STATE(283),
    [sym_iter_step_command] = STATE(283),
    [sym_iter_interpret_command] = STATE(283),
    [sym_iter_hit_command] = STATE(283),
    [sym_tmp_seek_command] = STATE(283),
    [sym_tmp_blksz_command] = STATE(283),
    [sym_tmp_fromto_command] = STATE(283),
    [sym_tmp_arch_command] = STATE(283),
    [sym_tmp_bits_command] = STATE(283),
    [sym_tmp_nthi_command] = STATE(283),
    [sym_tmp_eval_command] = STATE(283),
    [sym_tmp_fs_command] = STATE(283),
    [sym_tmp_reli_command] = STATE(283),
    [sym_tmp_kuery_command] = STATE(283),
    [sym_tmp_fd_command] = STATE(283),
    [sym_tmp_reg_command] = STATE(283),
    [sym_tmp_file_command] = STATE(283),
    [sym_tmp_string_command] = STATE(283),
    [sym_tmp_hex_command] = STATE(283),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(283),
    [sym_number_command] = STATE(283),
    [sym_help_command] = STATE(283),
    [sym_arged_command] = STATE(283),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(301),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(283),
    [sym_Cf_cmd] = STATE(283),
    [sym_pf_new_cmd] = STATE(283),
    [sym_pf_dot_cmd] = STATE(283),
    [sym_pf_cmd] = STATE(283),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(74),
    [sym_last_command] = STATE(283),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(55),
    [sym_repeat_command] = STATE(283),
    [sym__dec_number] = STATE(2),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(11),
    [anon_sym_AMPt] = ACTIONS(11),
    [aux_sym_task_command_token1] = ACTIONS(13),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(19),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(21),
    [anon_sym_DOT] = ACTIONS(23),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(31),
    [anon_sym_Cf] = ACTIONS(33),
    [sym_pf_dot_cmd_identifier] = ACTIONS(35),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(37),
    [aux_sym_pf_cmd_token1] = ACTIONS(39),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(49),
    [sym_question_mark_identifier] = ACTIONS(51),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(55),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(63),
    [sym__help_command] = ACTIONS(21),
  },
  [51] = {
    [sym_legacy_quoted_command] = STATE(291),
    [sym__simple_command] = STATE(291),
    [sym__tmp_command] = STATE(291),
    [sym__iter_command] = STATE(291),
    [sym__foreach_command] = STATE(291),
    [sym__pipe_command] = STATE(291),
    [sym_grep_command] = STATE(291),
    [sym_html_disable_command] = STATE(291),
    [sym_html_enable_command] = STATE(291),
    [sym_scr_tts_command] = STATE(291),
    [sym_pipe_command] = STATE(291),
    [sym_foreach_addrsize_command] = STATE(291),
    [sym_foreach_bb_command] = STATE(291),
    [sym_foreach_cmd_command] = STATE(291),
    [sym_foreach_comment_command] = STATE(291),
    [sym_foreach_import_command] = STATE(291),
    [sym_foreach_register_command] = STATE(291),
    [sym_foreach_symbol_command] = STATE(291),
    [sym_foreach_string_command] = STATE(291),
    [sym_foreach_section_command] = STATE(291),
    [sym_foreach_iomap_command] = STATE(291),
    [sym_foreach_dbgmap_command] = STATE(291),
    [sym_foreach_flag_command] = STATE(291),
    [sym_foreach_function_command] = STATE(291),
    [sym_foreach_thread_command] = STATE(291),
    [sym_iter_flags_command] = STATE(291),
    [sym_iter_dbta_command] = STATE(291),
    [sym_iter_dbtb_command] = STATE(291),
    [sym_iter_dbts_command] = STATE(291),
    [sym_iter_file_lines_command] = STATE(291),
    [sym_iter_offsets_command] = STATE(291),
    [sym_iter_sdbquery_command] = STATE(291),
    [sym_iter_threads_command] = STATE(291),
    [sym_iter_bbs_command] = STATE(291),
    [sym_iter_instrs_command] = STATE(291),
    [sym_iter_sections_command] = STATE(291),
    [sym_iter_functions_command] = STATE(291),
    [sym_iter_step_command] = STATE(291),
    [sym_iter_interpret_command] = STATE(291),
    [sym_iter_hit_command] = STATE(291),
    [sym_tmp_seek_command] = STATE(291),
    [sym_tmp_blksz_command] = STATE(291),
    [sym_tmp_fromto_command] = STATE(291),
    [sym_tmp_arch_command] = STATE(291),
    [sym_tmp_bits_command] = STATE(291),
    [sym_tmp_nthi_command] = STATE(291),
    [sym_tmp_eval_command] = STATE(291),
    [sym_tmp_fs_command] = STATE(291),
    [sym_tmp_reli_command] = STATE(291),
    [sym_tmp_kuery_command] = STATE(291),
    [sym_tmp_fd_command] = STATE(291),
    [sym_tmp_reg_command] = STATE(291),
    [sym_tmp_file_command] = STATE(291),
    [sym_tmp_string_command] = STATE(291),
    [sym_tmp_hex_command] = STATE(291),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(291),
    [sym_number_command] = STATE(291),
    [sym_help_command] = STATE(291),
    [sym_arged_command] = STATE(291),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(291),
    [sym_Cf_cmd] = STATE(291),
    [sym_pf_new_cmd] = STATE(291),
    [sym_pf_dot_cmd] = STATE(291),
    [sym_pf_cmd] = STATE(291),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(291),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(291),
    [sym__dec_number] = STATE(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [52] = {
    [sym_legacy_quoted_command] = STATE(290),
    [sym__simple_command] = STATE(290),
    [sym__tmp_command] = STATE(290),
    [sym__iter_command] = STATE(290),
    [sym__foreach_command] = STATE(290),
    [sym__pipe_command] = STATE(290),
    [sym_grep_command] = STATE(290),
    [sym_html_disable_command] = STATE(290),
    [sym_html_enable_command] = STATE(290),
    [sym_scr_tts_command] = STATE(290),
    [sym_pipe_command] = STATE(290),
    [sym_foreach_addrsize_command] = STATE(290),
    [sym_foreach_bb_command] = STATE(290),
    [sym_foreach_cmd_command] = STATE(290),
    [sym_foreach_comment_command] = STATE(290),
    [sym_foreach_import_command] = STATE(290),
    [sym_foreach_register_command] = STATE(290),
    [sym_foreach_symbol_command] = STATE(290),
    [sym_foreach_string_command] = STATE(290),
    [sym_foreach_section_command] = STATE(290),
    [sym_foreach_iomap_command] = STATE(290),
    [sym_foreach_dbgmap_command] = STATE(290),
    [sym_foreach_flag_command] = STATE(290),
    [sym_foreach_function_command] = STATE(290),
    [sym_foreach_thread_command] = STATE(290),
    [sym_iter_flags_command] = STATE(290),
    [sym_iter_dbta_command] = STATE(290),
    [sym_iter_dbtb_command] = STATE(290),
    [sym_iter_dbts_command] = STATE(290),
    [sym_iter_file_lines_command] = STATE(290),
    [sym_iter_offsets_command] = STATE(290),
    [sym_iter_sdbquery_command] = STATE(290),
    [sym_iter_threads_command] = STATE(290),
    [sym_iter_bbs_command] = STATE(290),
    [sym_iter_instrs_command] = STATE(290),
    [sym_iter_sections_command] = STATE(290),
    [sym_iter_functions_command] = STATE(290),
    [sym_iter_step_command] = STATE(290),
    [sym_iter_interpret_command] = STATE(290),
    [sym_iter_hit_command] = STATE(290),
    [sym_tmp_seek_command] = STATE(290),
    [sym_tmp_blksz_command] = STATE(290),
    [sym_tmp_fromto_command] = STATE(290),
    [sym_tmp_arch_command] = STATE(290),
    [sym_tmp_bits_command] = STATE(290),
    [sym_tmp_nthi_command] = STATE(290),
    [sym_tmp_eval_command] = STATE(290),
    [sym_tmp_fs_command] = STATE(290),
    [sym_tmp_reli_command] = STATE(290),
    [sym_tmp_kuery_command] = STATE(290),
    [sym_tmp_fd_command] = STATE(290),
    [sym_tmp_reg_command] = STATE(290),
    [sym_tmp_file_command] = STATE(290),
    [sym_tmp_string_command] = STATE(290),
    [sym_tmp_hex_command] = STATE(290),
    [sym__interpreter_command] = STATE(220),
    [sym_task_command] = STATE(290),
    [sym_number_command] = STATE(290),
    [sym_help_command] = STATE(290),
    [sym_arged_command] = STATE(290),
    [sym__simple_arged_command] = STATE(220),
    [sym__math_arged_command] = STATE(220),
    [sym__pointer_arged_command] = STATE(220),
    [sym__macro_arged_command] = STATE(220),
    [sym__system_command] = STATE(220),
    [sym__interpret_command] = STATE(220),
    [sym__interpret_search_identifier] = STATE(303),
    [sym__pf_arged_command] = STATE(220),
    [sym__pf_commands] = STATE(290),
    [sym_Cf_cmd] = STATE(290),
    [sym_pf_new_cmd] = STATE(290),
    [sym_pf_dot_cmd] = STATE(290),
    [sym_pf_cmd] = STATE(290),
    [sym__env_command] = STATE(220),
    [sym__env_command_identifier] = STATE(104),
    [sym_last_command] = STATE(290),
    [sym_last_command_identifier] = STATE(225),
    [sym__interpret_identifier] = STATE(77),
    [sym_repeat_command] = STATE(290),
    [sym__dec_number] = STATE(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND_BANG] = ACTIONS(77),
    [anon_sym_AMP] = ACTIONS(79),
    [anon_sym_AMPt] = ACTIONS(79),
    [aux_sym_task_command_token1] = ACTIONS(81),
    [anon_sym_0] = ACTIONS(15),
    [aux_sym_number_command_token1] = ACTIONS(17),
    [anon_sym_POUND_QMARK] = ACTIONS(83),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(85),
    [anon_sym_DOT] = ACTIONS(87),
    [anon_sym_DOT_BANG] = ACTIONS(25),
    [anon_sym_DOT_LPAREN] = ACTIONS(27),
    [anon_sym_DOT_SLASH] = ACTIONS(29),
    [anon_sym_pfo] = ACTIONS(89),
    [anon_sym_Cf] = ACTIONS(91),
    [sym_pf_dot_cmd_identifier] = ACTIONS(93),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(95),
    [aux_sym_pf_cmd_token1] = ACTIONS(97),
    [anon_sym_PERCENT] = ACTIONS(41),
    [anon_sym_env] = ACTIONS(41),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(43),
    [aux_sym__interpret_identifier_token1] = ACTIONS(45),
    [aux_sym__interpret_identifier_token2] = ACTIONS(47),
    [sym_system_identifier] = ACTIONS(99),
    [sym_question_mark_identifier] = ACTIONS(101),
    [sym_pointer_identifier] = ACTIONS(53),
    [sym_macro_identifier] = ACTIONS(103),
    [aux_sym__dec_number_token1] = ACTIONS(59),
    [aux_sym__dec_number_token2] = ACTIONS(61),
    [sym__comment] = ACTIONS(3),
    [sym_cmd_identifier] = ACTIONS(105),
    [sym__help_command] = ACTIONS(85),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(121),
    [anon_sym_DQUOTE] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_PIPE] = ACTIONS(123),
    [anon_sym_PIPEH] = ACTIONS(121),
    [anon_sym_PIPET] = ACTIONS(121),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(121),
    [anon_sym_AT_AT_ATb] = ACTIONS(121),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(121),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(121),
    [anon_sym_AT_AT_ATi] = ACTIONS(121),
    [anon_sym_AT_AT_ATr] = ACTIONS(121),
    [anon_sym_AT_AT_ATs] = ACTIONS(123),
    [anon_sym_AT_AT_ATst] = ACTIONS(121),
    [anon_sym_AT_AT_ATS] = ACTIONS(121),
    [anon_sym_AT_AT_ATm] = ACTIONS(121),
    [anon_sym_AT_AT_ATM] = ACTIONS(121),
    [anon_sym_AT_AT_ATf] = ACTIONS(123),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(121),
    [anon_sym_AT_AT_ATF] = ACTIONS(123),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(121),
    [anon_sym_AT_AT_ATt] = ACTIONS(121),
    [anon_sym_AT_AT] = ACTIONS(123),
    [anon_sym_AT_ATdbt] = ACTIONS(123),
    [anon_sym_AT_ATdbta] = ACTIONS(121),
    [anon_sym_AT_ATdbtb] = ACTIONS(121),
    [anon_sym_AT_ATdbts] = ACTIONS(121),
    [anon_sym_AT_AT_DOT] = ACTIONS(121),
    [anon_sym_AT_AT_EQ] = ACTIONS(121),
    [anon_sym_AT_ATk] = ACTIONS(121),
    [anon_sym_AT_ATt] = ACTIONS(121),
    [anon_sym_AT_ATb] = ACTIONS(121),
    [anon_sym_AT_ATi] = ACTIONS(123),
    [anon_sym_AT_ATiS] = ACTIONS(121),
    [anon_sym_AT_ATf] = ACTIONS(121),
    [anon_sym_AT_ATs_COLON] = ACTIONS(121),
    [anon_sym_AT_ATc_COLON] = ACTIONS(121),
    [anon_sym_AT] = ACTIONS(123),
    [anon_sym_AT_BANG] = ACTIONS(121),
    [anon_sym_AT_LBRACE] = ACTIONS(121),
    [anon_sym_ATa_COLON] = ACTIONS(121),
    [anon_sym_ATb_COLON] = ACTIONS(121),
    [anon_sym_ATB_COLON] = ACTIONS(121),
    [anon_sym_ATe_COLON] = ACTIONS(121),
    [anon_sym_ATF_COLON] = ACTIONS(121),
    [anon_sym_ATi_COLON] = ACTIONS(121),
    [anon_sym_ATk_COLON] = ACTIONS(121),
    [anon_sym_ATo_COLON] = ACTIONS(121),
    [anon_sym_ATr_COLON] = ACTIONS(121),
    [anon_sym_ATf_COLON] = ACTIONS(121),
    [anon_sym_ATs_COLON] = ACTIONS(121),
    [anon_sym_ATx_COLON] = ACTIONS(121),
    [anon_sym_POUND_BANG] = ACTIONS(123),
    [anon_sym_AMP] = ACTIONS(123),
    [anon_sym_AMPt] = ACTIONS(123),
    [aux_sym_task_command_token1] = ACTIONS(123),
    [anon_sym_0] = ACTIONS(123),
    [aux_sym_number_command_token1] = ACTIONS(121),
    [anon_sym_POUND_QMARK] = ACTIONS(123),
    [anon_sym_POUND_BANG_QMARK] = ACTIONS(121),
    [anon_sym_DOT] = ACTIONS(123),
    [anon_sym_DOT_BANG] = ACTIONS(121),
    [anon_sym_DOT_LPAREN] = ACTIONS(121),
    [anon_sym_PIPE_DOT] = ACTIONS(121),
    [anon_sym_DOT_SLASH] = ACTIONS(121),
    [anon_sym_pfo] = ACTIONS(121),
    [anon_sym_Cf] = ACTIONS(121),
    [sym_pf_dot_cmd_identifier] = ACTIONS(121),
    [sym_pf_dot_full_cmd_identifier] = ACTIONS(121),
    [aux_sym_pf_cmd_token1] = ACTIONS(123),
    [anon_sym_RPAREN] = ACTIONS(121),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_env] = ACTIONS(121),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(123),
    [aux_sym__interpret_identifier_token1] = ACTIONS(123),
    [aux_sym__interpret_identifier_token2] = ACTIONS(121),
    [sym_system_identifier] = ACTIONS(121),
    [sym_question_mark_identifier] = ACTIONS(121),
    [sym_pointer_identifier] = ACTIONS(121),
    [sym_macro_identifier] = ACTIONS(121),
    [anon_sym_SEMI] = ACTIONS(121),
    [anon_sym_GT] = ACTIONS(123),
    [anon_sym_GT_GT] = ACTIONS(121),
    [sym_html_redirect_operator] = ACTIONS(123),
    [sym_html_append_operator] = ACTIONS(121),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [aux_sym__dec_number_token1] = ACTIONS(121),
    [aux_sym__dec_number_token2] = ACTIONS(123),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(121),
    [anon_sym_CR] = ACTIONS(121),
    [sym_cmd_identifier] = ACTIONS(121),
    [sym__help_command] = ACTIONS(121),
    [sym_file_descriptor] = ACTIONS(121),
  },
  [54] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(247),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(125),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(125),
    [anon_sym_PIPE] = ACTIONS(129),
    [anon_sym_PIPEH] = ACTIONS(125),
    [anon_sym_PIPET] = ACTIONS(125),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(125),
    [anon_sym_AT_AT_ATb] = ACTIONS(125),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(125),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(125),
    [anon_sym_AT_AT_ATi] = ACTIONS(125),
    [anon_sym_AT_AT_ATr] = ACTIONS(125),
    [anon_sym_AT_AT_ATs] = ACTIONS(129),
    [anon_sym_AT_AT_ATst] = ACTIONS(125),
    [anon_sym_AT_AT_ATS] = ACTIONS(125),
    [anon_sym_AT_AT_ATm] = ACTIONS(125),
    [anon_sym_AT_AT_ATM] = ACTIONS(125),
    [anon_sym_AT_AT_ATf] = ACTIONS(129),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(125),
    [anon_sym_AT_AT_ATF] = ACTIONS(129),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(125),
    [anon_sym_AT_AT_ATt] = ACTIONS(125),
    [anon_sym_AT_AT] = ACTIONS(129),
    [anon_sym_AT_ATdbt] = ACTIONS(129),
    [anon_sym_AT_ATdbta] = ACTIONS(125),
    [anon_sym_AT_ATdbtb] = ACTIONS(125),
    [anon_sym_AT_ATdbts] = ACTIONS(125),
    [anon_sym_AT_AT_DOT] = ACTIONS(125),
    [anon_sym_AT_AT_EQ] = ACTIONS(125),
    [anon_sym_AT_ATk] = ACTIONS(125),
    [anon_sym_AT_ATt] = ACTIONS(125),
    [anon_sym_AT_ATb] = ACTIONS(125),
    [anon_sym_AT_ATi] = ACTIONS(129),
    [anon_sym_AT_ATiS] = ACTIONS(125),
    [anon_sym_AT_ATf] = ACTIONS(125),
    [anon_sym_AT_ATs_COLON] = ACTIONS(125),
    [anon_sym_AT_ATc_COLON] = ACTIONS(125),
    [anon_sym_AT] = ACTIONS(129),
    [anon_sym_AT_BANG] = ACTIONS(125),
    [anon_sym_AT_LBRACE] = ACTIONS(125),
    [anon_sym_ATa_COLON] = ACTIONS(125),
    [anon_sym_ATb_COLON] = ACTIONS(125),
    [anon_sym_ATB_COLON] = ACTIONS(125),
    [anon_sym_ATe_COLON] = ACTIONS(125),
    [anon_sym_ATF_COLON] = ACTIONS(125),
    [anon_sym_ATi_COLON] = ACTIONS(125),
    [anon_sym_ATk_COLON] = ACTIONS(125),
    [anon_sym_ATo_COLON] = ACTIONS(125),
    [anon_sym_ATr_COLON] = ACTIONS(125),
    [anon_sym_ATf_COLON] = ACTIONS(125),
    [anon_sym_ATs_COLON] = ACTIONS(125),
    [anon_sym_ATx_COLON] = ACTIONS(125),
    [anon_sym_PIPE_DOT] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(125),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_GT] = ACTIONS(129),
    [anon_sym_GT_GT] = ACTIONS(125),
    [sym_html_redirect_operator] = ACTIONS(129),
    [sym_html_append_operator] = ACTIONS(125),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(125),
    [anon_sym_CR] = ACTIONS(125),
    [sym_file_descriptor] = ACTIONS(125),
  },
  [55] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(233),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(143),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(143),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_PIPEH] = ACTIONS(143),
    [anon_sym_PIPET] = ACTIONS(143),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(143),
    [anon_sym_AT_AT_ATb] = ACTIONS(143),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(143),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(143),
    [anon_sym_AT_AT_ATi] = ACTIONS(143),
    [anon_sym_AT_AT_ATr] = ACTIONS(143),
    [anon_sym_AT_AT_ATs] = ACTIONS(145),
    [anon_sym_AT_AT_ATst] = ACTIONS(143),
    [anon_sym_AT_AT_ATS] = ACTIONS(143),
    [anon_sym_AT_AT_ATm] = ACTIONS(143),
    [anon_sym_AT_AT_ATM] = ACTIONS(143),
    [anon_sym_AT_AT_ATf] = ACTIONS(145),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(143),
    [anon_sym_AT_AT_ATF] = ACTIONS(145),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(143),
    [anon_sym_AT_AT_ATt] = ACTIONS(143),
    [anon_sym_AT_AT] = ACTIONS(145),
    [anon_sym_AT_ATdbt] = ACTIONS(145),
    [anon_sym_AT_ATdbta] = ACTIONS(143),
    [anon_sym_AT_ATdbtb] = ACTIONS(143),
    [anon_sym_AT_ATdbts] = ACTIONS(143),
    [anon_sym_AT_AT_DOT] = ACTIONS(143),
    [anon_sym_AT_AT_EQ] = ACTIONS(143),
    [anon_sym_AT_ATk] = ACTIONS(143),
    [anon_sym_AT_ATt] = ACTIONS(143),
    [anon_sym_AT_ATb] = ACTIONS(143),
    [anon_sym_AT_ATi] = ACTIONS(145),
    [anon_sym_AT_ATiS] = ACTIONS(143),
    [anon_sym_AT_ATf] = ACTIONS(143),
    [anon_sym_AT_ATs_COLON] = ACTIONS(143),
    [anon_sym_AT_ATc_COLON] = ACTIONS(143),
    [anon_sym_AT] = ACTIONS(145),
    [anon_sym_AT_BANG] = ACTIONS(143),
    [anon_sym_AT_LBRACE] = ACTIONS(143),
    [anon_sym_ATa_COLON] = ACTIONS(143),
    [anon_sym_ATb_COLON] = ACTIONS(143),
    [anon_sym_ATB_COLON] = ACTIONS(143),
    [anon_sym_ATe_COLON] = ACTIONS(143),
    [anon_sym_ATF_COLON] = ACTIONS(143),
    [anon_sym_ATi_COLON] = ACTIONS(143),
    [anon_sym_ATk_COLON] = ACTIONS(143),
    [anon_sym_ATo_COLON] = ACTIONS(143),
    [anon_sym_ATr_COLON] = ACTIONS(143),
    [anon_sym_ATf_COLON] = ACTIONS(143),
    [anon_sym_ATs_COLON] = ACTIONS(143),
    [anon_sym_ATx_COLON] = ACTIONS(143),
    [anon_sym_PIPE_DOT] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_SEMI] = ACTIONS(143),
    [anon_sym_GT] = ACTIONS(145),
    [anon_sym_GT_GT] = ACTIONS(143),
    [sym_html_redirect_operator] = ACTIONS(145),
    [sym_html_append_operator] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(143),
    [anon_sym_CR] = ACTIONS(143),
    [sym_file_descriptor] = ACTIONS(143),
  },
  [56] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(256),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_PIPEH] = ACTIONS(147),
    [anon_sym_PIPET] = ACTIONS(147),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(147),
    [anon_sym_AT_AT_ATb] = ACTIONS(147),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATi] = ACTIONS(147),
    [anon_sym_AT_AT_ATr] = ACTIONS(147),
    [anon_sym_AT_AT_ATs] = ACTIONS(149),
    [anon_sym_AT_AT_ATst] = ACTIONS(147),
    [anon_sym_AT_AT_ATS] = ACTIONS(147),
    [anon_sym_AT_AT_ATm] = ACTIONS(147),
    [anon_sym_AT_AT_ATM] = ACTIONS(147),
    [anon_sym_AT_AT_ATf] = ACTIONS(149),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATF] = ACTIONS(149),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATt] = ACTIONS(147),
    [anon_sym_AT_AT] = ACTIONS(149),
    [anon_sym_AT_ATdbt] = ACTIONS(149),
    [anon_sym_AT_ATdbta] = ACTIONS(147),
    [anon_sym_AT_ATdbtb] = ACTIONS(147),
    [anon_sym_AT_ATdbts] = ACTIONS(147),
    [anon_sym_AT_AT_DOT] = ACTIONS(147),
    [anon_sym_AT_AT_EQ] = ACTIONS(147),
    [anon_sym_AT_ATk] = ACTIONS(147),
    [anon_sym_AT_ATt] = ACTIONS(147),
    [anon_sym_AT_ATb] = ACTIONS(147),
    [anon_sym_AT_ATi] = ACTIONS(149),
    [anon_sym_AT_ATiS] = ACTIONS(147),
    [anon_sym_AT_ATf] = ACTIONS(147),
    [anon_sym_AT_ATs_COLON] = ACTIONS(147),
    [anon_sym_AT_ATc_COLON] = ACTIONS(147),
    [anon_sym_AT] = ACTIONS(149),
    [anon_sym_AT_BANG] = ACTIONS(147),
    [anon_sym_AT_LBRACE] = ACTIONS(147),
    [anon_sym_ATa_COLON] = ACTIONS(147),
    [anon_sym_ATb_COLON] = ACTIONS(147),
    [anon_sym_ATB_COLON] = ACTIONS(147),
    [anon_sym_ATe_COLON] = ACTIONS(147),
    [anon_sym_ATF_COLON] = ACTIONS(147),
    [anon_sym_ATi_COLON] = ACTIONS(147),
    [anon_sym_ATk_COLON] = ACTIONS(147),
    [anon_sym_ATo_COLON] = ACTIONS(147),
    [anon_sym_ATr_COLON] = ACTIONS(147),
    [anon_sym_ATf_COLON] = ACTIONS(147),
    [anon_sym_ATs_COLON] = ACTIONS(147),
    [anon_sym_ATx_COLON] = ACTIONS(147),
    [anon_sym_PIPE_DOT] = ACTIONS(147),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(147),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(149),
    [anon_sym_GT_GT] = ACTIONS(147),
    [sym_html_redirect_operator] = ACTIONS(149),
    [sym_html_append_operator] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(147),
    [anon_sym_CR] = ACTIONS(147),
    [sym_file_descriptor] = ACTIONS(147),
  },
  [57] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(260),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_PIPEH] = ACTIONS(151),
    [anon_sym_PIPET] = ACTIONS(151),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(151),
    [anon_sym_AT_AT_ATb] = ACTIONS(151),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(151),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(151),
    [anon_sym_AT_AT_ATi] = ACTIONS(151),
    [anon_sym_AT_AT_ATr] = ACTIONS(151),
    [anon_sym_AT_AT_ATs] = ACTIONS(153),
    [anon_sym_AT_AT_ATst] = ACTIONS(151),
    [anon_sym_AT_AT_ATS] = ACTIONS(151),
    [anon_sym_AT_AT_ATm] = ACTIONS(151),
    [anon_sym_AT_AT_ATM] = ACTIONS(151),
    [anon_sym_AT_AT_ATf] = ACTIONS(153),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(151),
    [anon_sym_AT_AT_ATF] = ACTIONS(153),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(151),
    [anon_sym_AT_AT_ATt] = ACTIONS(151),
    [anon_sym_AT_AT] = ACTIONS(153),
    [anon_sym_AT_ATdbt] = ACTIONS(153),
    [anon_sym_AT_ATdbta] = ACTIONS(151),
    [anon_sym_AT_ATdbtb] = ACTIONS(151),
    [anon_sym_AT_ATdbts] = ACTIONS(151),
    [anon_sym_AT_AT_DOT] = ACTIONS(151),
    [anon_sym_AT_AT_EQ] = ACTIONS(151),
    [anon_sym_AT_ATk] = ACTIONS(151),
    [anon_sym_AT_ATt] = ACTIONS(151),
    [anon_sym_AT_ATb] = ACTIONS(151),
    [anon_sym_AT_ATi] = ACTIONS(153),
    [anon_sym_AT_ATiS] = ACTIONS(151),
    [anon_sym_AT_ATf] = ACTIONS(151),
    [anon_sym_AT_ATs_COLON] = ACTIONS(151),
    [anon_sym_AT_ATc_COLON] = ACTIONS(151),
    [anon_sym_AT] = ACTIONS(153),
    [anon_sym_AT_BANG] = ACTIONS(151),
    [anon_sym_AT_LBRACE] = ACTIONS(151),
    [anon_sym_ATa_COLON] = ACTIONS(151),
    [anon_sym_ATb_COLON] = ACTIONS(151),
    [anon_sym_ATB_COLON] = ACTIONS(151),
    [anon_sym_ATe_COLON] = ACTIONS(151),
    [anon_sym_ATF_COLON] = ACTIONS(151),
    [anon_sym_ATi_COLON] = ACTIONS(151),
    [anon_sym_ATk_COLON] = ACTIONS(151),
    [anon_sym_ATo_COLON] = ACTIONS(151),
    [anon_sym_ATr_COLON] = ACTIONS(151),
    [anon_sym_ATf_COLON] = ACTIONS(151),
    [anon_sym_ATs_COLON] = ACTIONS(151),
    [anon_sym_ATx_COLON] = ACTIONS(151),
    [anon_sym_PIPE_DOT] = ACTIONS(151),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(151),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_GT] = ACTIONS(151),
    [sym_html_redirect_operator] = ACTIONS(153),
    [sym_html_append_operator] = ACTIONS(151),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(151),
    [anon_sym_CR] = ACTIONS(151),
    [sym_file_descriptor] = ACTIONS(151),
  },
  [58] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(264),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_PIPE] = ACTIONS(71),
    [anon_sym_PIPEH] = ACTIONS(69),
    [anon_sym_PIPET] = ACTIONS(69),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(69),
    [anon_sym_AT_AT_ATb] = ACTIONS(69),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATi] = ACTIONS(69),
    [anon_sym_AT_AT_ATr] = ACTIONS(69),
    [anon_sym_AT_AT_ATs] = ACTIONS(71),
    [anon_sym_AT_AT_ATst] = ACTIONS(69),
    [anon_sym_AT_AT_ATS] = ACTIONS(69),
    [anon_sym_AT_AT_ATm] = ACTIONS(69),
    [anon_sym_AT_AT_ATM] = ACTIONS(69),
    [anon_sym_AT_AT_ATf] = ACTIONS(71),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATF] = ACTIONS(71),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATt] = ACTIONS(69),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_AT_ATdbt] = ACTIONS(71),
    [anon_sym_AT_ATdbta] = ACTIONS(69),
    [anon_sym_AT_ATdbtb] = ACTIONS(69),
    [anon_sym_AT_ATdbts] = ACTIONS(69),
    [anon_sym_AT_AT_DOT] = ACTIONS(69),
    [anon_sym_AT_AT_EQ] = ACTIONS(69),
    [anon_sym_AT_ATk] = ACTIONS(69),
    [anon_sym_AT_ATt] = ACTIONS(69),
    [anon_sym_AT_ATb] = ACTIONS(69),
    [anon_sym_AT_ATi] = ACTIONS(71),
    [anon_sym_AT_ATiS] = ACTIONS(69),
    [anon_sym_AT_ATf] = ACTIONS(69),
    [anon_sym_AT_ATs_COLON] = ACTIONS(69),
    [anon_sym_AT_ATc_COLON] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(71),
    [anon_sym_AT_BANG] = ACTIONS(69),
    [anon_sym_AT_LBRACE] = ACTIONS(69),
    [anon_sym_ATa_COLON] = ACTIONS(69),
    [anon_sym_ATb_COLON] = ACTIONS(69),
    [anon_sym_ATB_COLON] = ACTIONS(69),
    [anon_sym_ATe_COLON] = ACTIONS(69),
    [anon_sym_ATF_COLON] = ACTIONS(69),
    [anon_sym_ATi_COLON] = ACTIONS(69),
    [anon_sym_ATk_COLON] = ACTIONS(69),
    [anon_sym_ATo_COLON] = ACTIONS(69),
    [anon_sym_ATr_COLON] = ACTIONS(69),
    [anon_sym_ATf_COLON] = ACTIONS(69),
    [anon_sym_ATs_COLON] = ACTIONS(69),
    [anon_sym_ATx_COLON] = ACTIONS(69),
    [anon_sym_PIPE_DOT] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_SEMI] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(69),
    [sym_html_redirect_operator] = ACTIONS(71),
    [sym_html_append_operator] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(69),
    [anon_sym_CR] = ACTIONS(69),
    [sym_file_descriptor] = ACTIONS(69),
  },
  [59] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(195),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_PIPEH] = ACTIONS(155),
    [anon_sym_PIPET] = ACTIONS(155),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(155),
    [anon_sym_AT_AT_ATb] = ACTIONS(155),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(155),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(155),
    [anon_sym_AT_AT_ATi] = ACTIONS(155),
    [anon_sym_AT_AT_ATr] = ACTIONS(155),
    [anon_sym_AT_AT_ATs] = ACTIONS(157),
    [anon_sym_AT_AT_ATst] = ACTIONS(155),
    [anon_sym_AT_AT_ATS] = ACTIONS(155),
    [anon_sym_AT_AT_ATm] = ACTIONS(155),
    [anon_sym_AT_AT_ATM] = ACTIONS(155),
    [anon_sym_AT_AT_ATf] = ACTIONS(157),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(155),
    [anon_sym_AT_AT_ATF] = ACTIONS(157),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(155),
    [anon_sym_AT_AT_ATt] = ACTIONS(155),
    [anon_sym_AT_AT] = ACTIONS(157),
    [anon_sym_AT_ATdbt] = ACTIONS(157),
    [anon_sym_AT_ATdbta] = ACTIONS(155),
    [anon_sym_AT_ATdbtb] = ACTIONS(155),
    [anon_sym_AT_ATdbts] = ACTIONS(155),
    [anon_sym_AT_AT_DOT] = ACTIONS(155),
    [anon_sym_AT_AT_EQ] = ACTIONS(155),
    [anon_sym_AT_ATk] = ACTIONS(155),
    [anon_sym_AT_ATt] = ACTIONS(155),
    [anon_sym_AT_ATb] = ACTIONS(155),
    [anon_sym_AT_ATi] = ACTIONS(157),
    [anon_sym_AT_ATiS] = ACTIONS(155),
    [anon_sym_AT_ATf] = ACTIONS(155),
    [anon_sym_AT_ATs_COLON] = ACTIONS(155),
    [anon_sym_AT_ATc_COLON] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(157),
    [anon_sym_AT_BANG] = ACTIONS(155),
    [anon_sym_AT_LBRACE] = ACTIONS(155),
    [anon_sym_ATa_COLON] = ACTIONS(155),
    [anon_sym_ATb_COLON] = ACTIONS(155),
    [anon_sym_ATB_COLON] = ACTIONS(155),
    [anon_sym_ATe_COLON] = ACTIONS(155),
    [anon_sym_ATF_COLON] = ACTIONS(155),
    [anon_sym_ATi_COLON] = ACTIONS(155),
    [anon_sym_ATk_COLON] = ACTIONS(155),
    [anon_sym_ATo_COLON] = ACTIONS(155),
    [anon_sym_ATr_COLON] = ACTIONS(155),
    [anon_sym_ATf_COLON] = ACTIONS(155),
    [anon_sym_ATs_COLON] = ACTIONS(155),
    [anon_sym_ATx_COLON] = ACTIONS(155),
    [anon_sym_PIPE_DOT] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(155),
    [anon_sym_SEMI] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_GT] = ACTIONS(155),
    [sym_html_redirect_operator] = ACTIONS(157),
    [sym_html_append_operator] = ACTIONS(155),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(155),
    [anon_sym_CR] = ACTIONS(155),
    [sym_file_descriptor] = ACTIONS(155),
  },
  [60] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(248),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_PIPEH] = ACTIONS(147),
    [anon_sym_PIPET] = ACTIONS(147),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(147),
    [anon_sym_AT_AT_ATb] = ACTIONS(147),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATi] = ACTIONS(147),
    [anon_sym_AT_AT_ATr] = ACTIONS(147),
    [anon_sym_AT_AT_ATs] = ACTIONS(149),
    [anon_sym_AT_AT_ATst] = ACTIONS(147),
    [anon_sym_AT_AT_ATS] = ACTIONS(147),
    [anon_sym_AT_AT_ATm] = ACTIONS(147),
    [anon_sym_AT_AT_ATM] = ACTIONS(147),
    [anon_sym_AT_AT_ATf] = ACTIONS(149),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATF] = ACTIONS(149),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATt] = ACTIONS(147),
    [anon_sym_AT_AT] = ACTIONS(149),
    [anon_sym_AT_ATdbt] = ACTIONS(149),
    [anon_sym_AT_ATdbta] = ACTIONS(147),
    [anon_sym_AT_ATdbtb] = ACTIONS(147),
    [anon_sym_AT_ATdbts] = ACTIONS(147),
    [anon_sym_AT_AT_DOT] = ACTIONS(147),
    [anon_sym_AT_AT_EQ] = ACTIONS(147),
    [anon_sym_AT_ATk] = ACTIONS(147),
    [anon_sym_AT_ATt] = ACTIONS(147),
    [anon_sym_AT_ATb] = ACTIONS(147),
    [anon_sym_AT_ATi] = ACTIONS(149),
    [anon_sym_AT_ATiS] = ACTIONS(147),
    [anon_sym_AT_ATf] = ACTIONS(147),
    [anon_sym_AT_ATs_COLON] = ACTIONS(147),
    [anon_sym_AT_ATc_COLON] = ACTIONS(147),
    [anon_sym_AT] = ACTIONS(149),
    [anon_sym_AT_BANG] = ACTIONS(147),
    [anon_sym_AT_LBRACE] = ACTIONS(147),
    [anon_sym_ATa_COLON] = ACTIONS(147),
    [anon_sym_ATb_COLON] = ACTIONS(147),
    [anon_sym_ATB_COLON] = ACTIONS(147),
    [anon_sym_ATe_COLON] = ACTIONS(147),
    [anon_sym_ATF_COLON] = ACTIONS(147),
    [anon_sym_ATi_COLON] = ACTIONS(147),
    [anon_sym_ATk_COLON] = ACTIONS(147),
    [anon_sym_ATo_COLON] = ACTIONS(147),
    [anon_sym_ATr_COLON] = ACTIONS(147),
    [anon_sym_ATf_COLON] = ACTIONS(147),
    [anon_sym_ATs_COLON] = ACTIONS(147),
    [anon_sym_ATx_COLON] = ACTIONS(147),
    [anon_sym_PIPE_DOT] = ACTIONS(147),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(147),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(149),
    [anon_sym_GT_GT] = ACTIONS(147),
    [sym_html_redirect_operator] = ACTIONS(149),
    [sym_html_append_operator] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(147),
    [anon_sym_CR] = ACTIONS(147),
    [sym_file_descriptor] = ACTIONS(147),
  },
  [61] = {
    [sym_macro_content] = STATE(167),
    [sym_macro_args] = STATE(270),
    [sym__arg] = STATE(356),
    [sym_arg] = STATE(296),
    [sym_double_quoted_arg] = STATE(356),
    [sym_single_quoted_arg] = STATE(356),
    [sym_cmd_substitution_arg] = STATE(356),
    [sym_concatenation] = STATE(378),
    [ts_builtin_sym_end] = ACTIONS(159),
    [anon_sym_DQUOTE] = ACTIONS(161),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_PIPE] = ACTIONS(163),
    [anon_sym_PIPEH] = ACTIONS(159),
    [anon_sym_PIPET] = ACTIONS(159),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(159),
    [anon_sym_AT_AT_ATb] = ACTIONS(159),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(159),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(159),
    [anon_sym_AT_AT_ATi] = ACTIONS(159),
    [anon_sym_AT_AT_ATr] = ACTIONS(159),
    [anon_sym_AT_AT_ATs] = ACTIONS(163),
    [anon_sym_AT_AT_ATst] = ACTIONS(159),
    [anon_sym_AT_AT_ATS] = ACTIONS(159),
    [anon_sym_AT_AT_ATm] = ACTIONS(159),
    [anon_sym_AT_AT_ATM] = ACTIONS(159),
    [anon_sym_AT_AT_ATf] = ACTIONS(163),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(159),
    [anon_sym_AT_AT_ATF] = ACTIONS(163),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(159),
    [anon_sym_AT_AT_ATt] = ACTIONS(159),
    [anon_sym_AT_AT] = ACTIONS(163),
    [anon_sym_AT_ATdbt] = ACTIONS(163),
    [anon_sym_AT_ATdbta] = ACTIONS(159),
    [anon_sym_AT_ATdbtb] = ACTIONS(159),
    [anon_sym_AT_ATdbts] = ACTIONS(159),
    [anon_sym_AT_AT_DOT] = ACTIONS(159),
    [anon_sym_AT_AT_EQ] = ACTIONS(159),
    [anon_sym_AT_ATk] = ACTIONS(159),
    [anon_sym_AT_ATt] = ACTIONS(159),
    [anon_sym_AT_ATb] = ACTIONS(159),
    [anon_sym_AT_ATi] = ACTIONS(163),
    [anon_sym_AT_ATiS] = ACTIONS(159),
    [anon_sym_AT_ATf] = ACTIONS(159),
    [anon_sym_AT_ATs_COLON] = ACTIONS(159),
    [anon_sym_AT_ATc_COLON] = ACTIONS(159),
    [anon_sym_AT] = ACTIONS(163),
    [anon_sym_AT_BANG] = ACTIONS(159),
    [anon_sym_AT_LBRACE] = ACTIONS(159),
    [anon_sym_ATa_COLON] = ACTIONS(159),
    [anon_sym_ATb_COLON] = ACTIONS(159),
    [anon_sym_ATB_COLON] = ACTIONS(159),
    [anon_sym_ATe_COLON] = ACTIONS(159),
    [anon_sym_ATF_COLON] = ACTIONS(159),
    [anon_sym_ATi_COLON] = ACTIONS(159),
    [anon_sym_ATk_COLON] = ACTIONS(159),
    [anon_sym_ATo_COLON] = ACTIONS(159),
    [anon_sym_ATr_COLON] = ACTIONS(159),
    [anon_sym_ATf_COLON] = ACTIONS(159),
    [anon_sym_ATs_COLON] = ACTIONS(159),
    [anon_sym_ATx_COLON] = ACTIONS(159),
    [anon_sym_PIPE_DOT] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_RPAREN] = ACTIONS(159),
    [anon_sym_SEMI] = ACTIONS(159),
    [anon_sym_GT] = ACTIONS(163),
    [anon_sym_GT_GT] = ACTIONS(159),
    [sym_html_redirect_operator] = ACTIONS(163),
    [sym_html_append_operator] = ACTIONS(159),
    [anon_sym_COMMA] = ACTIONS(167),
    [sym_arg_identifier] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(171),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(173),
    [anon_sym_BQUOTE] = ACTIONS(175),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(159),
    [anon_sym_CR] = ACTIONS(159),
    [sym_file_descriptor] = ACTIONS(159),
  },
  [62] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(273),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(177),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_PIPE] = ACTIONS(179),
    [anon_sym_PIPEH] = ACTIONS(177),
    [anon_sym_PIPET] = ACTIONS(177),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(177),
    [anon_sym_AT_AT_ATb] = ACTIONS(177),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(177),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(177),
    [anon_sym_AT_AT_ATi] = ACTIONS(177),
    [anon_sym_AT_AT_ATr] = ACTIONS(177),
    [anon_sym_AT_AT_ATs] = ACTIONS(179),
    [anon_sym_AT_AT_ATst] = ACTIONS(177),
    [anon_sym_AT_AT_ATS] = ACTIONS(177),
    [anon_sym_AT_AT_ATm] = ACTIONS(177),
    [anon_sym_AT_AT_ATM] = ACTIONS(177),
    [anon_sym_AT_AT_ATf] = ACTIONS(179),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(177),
    [anon_sym_AT_AT_ATF] = ACTIONS(179),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(177),
    [anon_sym_AT_AT_ATt] = ACTIONS(177),
    [anon_sym_AT_AT] = ACTIONS(179),
    [anon_sym_AT_ATdbt] = ACTIONS(179),
    [anon_sym_AT_ATdbta] = ACTIONS(177),
    [anon_sym_AT_ATdbtb] = ACTIONS(177),
    [anon_sym_AT_ATdbts] = ACTIONS(177),
    [anon_sym_AT_AT_DOT] = ACTIONS(177),
    [anon_sym_AT_AT_EQ] = ACTIONS(177),
    [anon_sym_AT_ATk] = ACTIONS(177),
    [anon_sym_AT_ATt] = ACTIONS(177),
    [anon_sym_AT_ATb] = ACTIONS(177),
    [anon_sym_AT_ATi] = ACTIONS(179),
    [anon_sym_AT_ATiS] = ACTIONS(177),
    [anon_sym_AT_ATf] = ACTIONS(177),
    [anon_sym_AT_ATs_COLON] = ACTIONS(177),
    [anon_sym_AT_ATc_COLON] = ACTIONS(177),
    [anon_sym_AT] = ACTIONS(179),
    [anon_sym_AT_BANG] = ACTIONS(177),
    [anon_sym_AT_LBRACE] = ACTIONS(177),
    [anon_sym_ATa_COLON] = ACTIONS(177),
    [anon_sym_ATb_COLON] = ACTIONS(177),
    [anon_sym_ATB_COLON] = ACTIONS(177),
    [anon_sym_ATe_COLON] = ACTIONS(177),
    [anon_sym_ATF_COLON] = ACTIONS(177),
    [anon_sym_ATi_COLON] = ACTIONS(177),
    [anon_sym_ATk_COLON] = ACTIONS(177),
    [anon_sym_ATo_COLON] = ACTIONS(177),
    [anon_sym_ATr_COLON] = ACTIONS(177),
    [anon_sym_ATf_COLON] = ACTIONS(177),
    [anon_sym_ATs_COLON] = ACTIONS(177),
    [anon_sym_ATx_COLON] = ACTIONS(177),
    [anon_sym_PIPE_DOT] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_GT] = ACTIONS(177),
    [sym_html_redirect_operator] = ACTIONS(179),
    [sym_html_append_operator] = ACTIONS(177),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(177),
    [anon_sym_CR] = ACTIONS(177),
    [sym_file_descriptor] = ACTIONS(177),
  },
  [63] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(69),
    [sym_args] = STATE(245),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(69),
    [ts_builtin_sym_end] = ACTIONS(181),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(181),
    [anon_sym_PIPE] = ACTIONS(183),
    [anon_sym_PIPEH] = ACTIONS(181),
    [anon_sym_PIPET] = ACTIONS(181),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(181),
    [anon_sym_AT_AT_ATb] = ACTIONS(181),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(181),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(181),
    [anon_sym_AT_AT_ATi] = ACTIONS(181),
    [anon_sym_AT_AT_ATr] = ACTIONS(181),
    [anon_sym_AT_AT_ATs] = ACTIONS(183),
    [anon_sym_AT_AT_ATst] = ACTIONS(181),
    [anon_sym_AT_AT_ATS] = ACTIONS(181),
    [anon_sym_AT_AT_ATm] = ACTIONS(181),
    [anon_sym_AT_AT_ATM] = ACTIONS(181),
    [anon_sym_AT_AT_ATf] = ACTIONS(183),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(181),
    [anon_sym_AT_AT_ATF] = ACTIONS(183),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(181),
    [anon_sym_AT_AT_ATt] = ACTIONS(181),
    [anon_sym_AT_AT] = ACTIONS(183),
    [anon_sym_AT_ATdbt] = ACTIONS(183),
    [anon_sym_AT_ATdbta] = ACTIONS(181),
    [anon_sym_AT_ATdbtb] = ACTIONS(181),
    [anon_sym_AT_ATdbts] = ACTIONS(181),
    [anon_sym_AT_AT_DOT] = ACTIONS(181),
    [anon_sym_AT_AT_EQ] = ACTIONS(181),
    [anon_sym_AT_ATk] = ACTIONS(181),
    [anon_sym_AT_ATt] = ACTIONS(181),
    [anon_sym_AT_ATb] = ACTIONS(181),
    [anon_sym_AT_ATi] = ACTIONS(183),
    [anon_sym_AT_ATiS] = ACTIONS(181),
    [anon_sym_AT_ATf] = ACTIONS(181),
    [anon_sym_AT_ATs_COLON] = ACTIONS(181),
    [anon_sym_AT_ATc_COLON] = ACTIONS(181),
    [anon_sym_AT] = ACTIONS(183),
    [anon_sym_AT_BANG] = ACTIONS(181),
    [anon_sym_AT_LBRACE] = ACTIONS(181),
    [anon_sym_ATa_COLON] = ACTIONS(181),
    [anon_sym_ATb_COLON] = ACTIONS(181),
    [anon_sym_ATB_COLON] = ACTIONS(181),
    [anon_sym_ATe_COLON] = ACTIONS(181),
    [anon_sym_ATF_COLON] = ACTIONS(181),
    [anon_sym_ATi_COLON] = ACTIONS(181),
    [anon_sym_ATk_COLON] = ACTIONS(181),
    [anon_sym_ATo_COLON] = ACTIONS(181),
    [anon_sym_ATr_COLON] = ACTIONS(181),
    [anon_sym_ATf_COLON] = ACTIONS(181),
    [anon_sym_ATs_COLON] = ACTIONS(181),
    [anon_sym_ATx_COLON] = ACTIONS(181),
    [anon_sym_PIPE_DOT] = ACTIONS(181),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_SEMI] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(183),
    [anon_sym_GT_GT] = ACTIONS(181),
    [sym_html_redirect_operator] = ACTIONS(183),
    [sym_html_append_operator] = ACTIONS(181),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(181),
    [anon_sym_CR] = ACTIONS(181),
    [sym_file_descriptor] = ACTIONS(181),
  },
  [64] = {
    [sym__Cf_args] = STATE(267),
    [sym__arg] = STATE(451),
    [sym_arg] = STATE(353),
    [sym_double_quoted_arg] = STATE(451),
    [sym_single_quoted_arg] = STATE(451),
    [sym_cmd_substitution_arg] = STATE(451),
    [sym_concatenation] = STATE(484),
    [ts_builtin_sym_end] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_TILDE] = ACTIONS(185),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_PIPEH] = ACTIONS(185),
    [anon_sym_PIPET] = ACTIONS(185),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(185),
    [anon_sym_AT_AT_ATb] = ACTIONS(185),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(185),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(185),
    [anon_sym_AT_AT_ATi] = ACTIONS(185),
    [anon_sym_AT_AT_ATr] = ACTIONS(185),
    [anon_sym_AT_AT_ATs] = ACTIONS(189),
    [anon_sym_AT_AT_ATst] = ACTIONS(185),
    [anon_sym_AT_AT_ATS] = ACTIONS(185),
    [anon_sym_AT_AT_ATm] = ACTIONS(185),
    [anon_sym_AT_AT_ATM] = ACTIONS(185),
    [anon_sym_AT_AT_ATf] = ACTIONS(189),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(185),
    [anon_sym_AT_AT_ATF] = ACTIONS(189),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(185),
    [anon_sym_AT_AT_ATt] = ACTIONS(185),
    [anon_sym_AT_AT] = ACTIONS(189),
    [anon_sym_AT_ATdbt] = ACTIONS(189),
    [anon_sym_AT_ATdbta] = ACTIONS(185),
    [anon_sym_AT_ATdbtb] = ACTIONS(185),
    [anon_sym_AT_ATdbts] = ACTIONS(185),
    [anon_sym_AT_AT_DOT] = ACTIONS(185),
    [anon_sym_AT_AT_EQ] = ACTIONS(185),
    [anon_sym_AT_ATk] = ACTIONS(185),
    [anon_sym_AT_ATt] = ACTIONS(185),
    [anon_sym_AT_ATb] = ACTIONS(185),
    [anon_sym_AT_ATi] = ACTIONS(189),
    [anon_sym_AT_ATiS] = ACTIONS(185),
    [anon_sym_AT_ATf] = ACTIONS(185),
    [anon_sym_AT_ATs_COLON] = ACTIONS(185),
    [anon_sym_AT_ATc_COLON] = ACTIONS(185),
    [anon_sym_AT] = ACTIONS(189),
    [anon_sym_AT_BANG] = ACTIONS(185),
    [anon_sym_AT_LBRACE] = ACTIONS(185),
    [anon_sym_ATa_COLON] = ACTIONS(185),
    [anon_sym_ATb_COLON] = ACTIONS(185),
    [anon_sym_ATB_COLON] = ACTIONS(185),
    [anon_sym_ATe_COLON] = ACTIONS(185),
    [anon_sym_ATF_COLON] = ACTIONS(185),
    [anon_sym_ATi_COLON] = ACTIONS(185),
    [anon_sym_ATk_COLON] = ACTIONS(185),
    [anon_sym_ATo_COLON] = ACTIONS(185),
    [anon_sym_ATr_COLON] = ACTIONS(185),
    [anon_sym_ATf_COLON] = ACTIONS(185),
    [anon_sym_ATs_COLON] = ACTIONS(185),
    [anon_sym_ATx_COLON] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_GT_GT] = ACTIONS(185),
    [sym_html_redirect_operator] = ACTIONS(189),
    [sym_html_append_operator] = ACTIONS(185),
    [anon_sym_COMMA] = ACTIONS(193),
    [sym_arg_identifier] = ACTIONS(195),
    [anon_sym_SQUOTE] = ACTIONS(197),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(199),
    [anon_sym_BQUOTE] = ACTIONS(201),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(185),
    [anon_sym_CR] = ACTIONS(185),
    [sym_file_descriptor] = ACTIONS(185),
  },
  [65] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(65),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(203),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(203),
    [anon_sym_PIPE] = ACTIONS(208),
    [anon_sym_PIPEH] = ACTIONS(203),
    [anon_sym_PIPET] = ACTIONS(203),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(203),
    [anon_sym_AT_AT_ATb] = ACTIONS(203),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(203),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(203),
    [anon_sym_AT_AT_ATi] = ACTIONS(203),
    [anon_sym_AT_AT_ATr] = ACTIONS(203),
    [anon_sym_AT_AT_ATs] = ACTIONS(208),
    [anon_sym_AT_AT_ATst] = ACTIONS(203),
    [anon_sym_AT_AT_ATS] = ACTIONS(203),
    [anon_sym_AT_AT_ATm] = ACTIONS(203),
    [anon_sym_AT_AT_ATM] = ACTIONS(203),
    [anon_sym_AT_AT_ATf] = ACTIONS(208),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(203),
    [anon_sym_AT_AT_ATF] = ACTIONS(208),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(203),
    [anon_sym_AT_AT_ATt] = ACTIONS(203),
    [anon_sym_AT_AT] = ACTIONS(208),
    [anon_sym_AT_ATdbt] = ACTIONS(208),
    [anon_sym_AT_ATdbta] = ACTIONS(203),
    [anon_sym_AT_ATdbtb] = ACTIONS(203),
    [anon_sym_AT_ATdbts] = ACTIONS(203),
    [anon_sym_AT_AT_DOT] = ACTIONS(203),
    [anon_sym_AT_AT_EQ] = ACTIONS(203),
    [anon_sym_AT_ATk] = ACTIONS(203),
    [anon_sym_AT_ATt] = ACTIONS(203),
    [anon_sym_AT_ATb] = ACTIONS(203),
    [anon_sym_AT_ATi] = ACTIONS(208),
    [anon_sym_AT_ATiS] = ACTIONS(203),
    [anon_sym_AT_ATf] = ACTIONS(203),
    [anon_sym_AT_ATs_COLON] = ACTIONS(203),
    [anon_sym_AT_ATc_COLON] = ACTIONS(203),
    [anon_sym_AT] = ACTIONS(208),
    [anon_sym_AT_BANG] = ACTIONS(203),
    [anon_sym_AT_LBRACE] = ACTIONS(203),
    [anon_sym_ATa_COLON] = ACTIONS(203),
    [anon_sym_ATb_COLON] = ACTIONS(203),
    [anon_sym_ATB_COLON] = ACTIONS(203),
    [anon_sym_ATe_COLON] = ACTIONS(203),
    [anon_sym_ATF_COLON] = ACTIONS(203),
    [anon_sym_ATi_COLON] = ACTIONS(203),
    [anon_sym_ATk_COLON] = ACTIONS(203),
    [anon_sym_ATo_COLON] = ACTIONS(203),
    [anon_sym_ATr_COLON] = ACTIONS(203),
    [anon_sym_ATf_COLON] = ACTIONS(203),
    [anon_sym_ATs_COLON] = ACTIONS(203),
    [anon_sym_ATx_COLON] = ACTIONS(203),
    [anon_sym_PIPE_DOT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(210),
    [anon_sym_RPAREN] = ACTIONS(203),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_GT] = ACTIONS(208),
    [anon_sym_GT_GT] = ACTIONS(203),
    [sym_html_redirect_operator] = ACTIONS(208),
    [sym_html_append_operator] = ACTIONS(203),
    [anon_sym_COMMA] = ACTIONS(213),
    [sym_arg_identifier] = ACTIONS(216),
    [anon_sym_SQUOTE] = ACTIONS(219),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(222),
    [anon_sym_BQUOTE] = ACTIONS(225),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(203),
    [anon_sym_CR] = ACTIONS(203),
    [sym_file_descriptor] = ACTIONS(203),
  },
  [66] = {
    [sym__pf_arg_parentheses] = STATE(106),
    [sym__pf_arg] = STATE(106),
    [sym_pf_concatenation] = STATE(124),
    [sym_pf_arg] = STATE(83),
    [sym_pf_args] = STATE(235),
    [sym_cmd_substitution_arg] = STATE(106),
    [aux_sym_pf_args_repeat1] = STATE(83),
    [aux_sym_pf_dot_args_repeat1] = STATE(133),
    [ts_builtin_sym_end] = ACTIONS(228),
    [anon_sym_TILDE] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_PIPEH] = ACTIONS(228),
    [anon_sym_PIPET] = ACTIONS(228),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(228),
    [anon_sym_AT_AT_ATb] = ACTIONS(228),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATi] = ACTIONS(228),
    [anon_sym_AT_AT_ATr] = ACTIONS(228),
    [anon_sym_AT_AT_ATs] = ACTIONS(230),
    [anon_sym_AT_AT_ATst] = ACTIONS(228),
    [anon_sym_AT_AT_ATS] = ACTIONS(228),
    [anon_sym_AT_AT_ATm] = ACTIONS(228),
    [anon_sym_AT_AT_ATM] = ACTIONS(228),
    [anon_sym_AT_AT_ATf] = ACTIONS(230),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATF] = ACTIONS(230),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATt] = ACTIONS(228),
    [anon_sym_AT_AT] = ACTIONS(230),
    [anon_sym_AT_ATdbt] = ACTIONS(230),
    [anon_sym_AT_ATdbta] = ACTIONS(228),
    [anon_sym_AT_ATdbtb] = ACTIONS(228),
    [anon_sym_AT_ATdbts] = ACTIONS(228),
    [anon_sym_AT_AT_DOT] = ACTIONS(228),
    [anon_sym_AT_AT_EQ] = ACTIONS(228),
    [anon_sym_AT_ATk] = ACTIONS(228),
    [anon_sym_AT_ATt] = ACTIONS(228),
    [anon_sym_AT_ATb] = ACTIONS(228),
    [anon_sym_AT_ATi] = ACTIONS(230),
    [anon_sym_AT_ATiS] = ACTIONS(228),
    [anon_sym_AT_ATf] = ACTIONS(228),
    [anon_sym_AT_ATs_COLON] = ACTIONS(228),
    [anon_sym_AT_ATc_COLON] = ACTIONS(228),
    [anon_sym_AT] = ACTIONS(230),
    [anon_sym_AT_BANG] = ACTIONS(228),
    [anon_sym_AT_LBRACE] = ACTIONS(228),
    [anon_sym_ATa_COLON] = ACTIONS(228),
    [anon_sym_ATb_COLON] = ACTIONS(228),
    [anon_sym_ATB_COLON] = ACTIONS(228),
    [anon_sym_ATe_COLON] = ACTIONS(228),
    [anon_sym_ATF_COLON] = ACTIONS(228),
    [anon_sym_ATi_COLON] = ACTIONS(228),
    [anon_sym_ATk_COLON] = ACTIONS(228),
    [anon_sym_ATo_COLON] = ACTIONS(228),
    [anon_sym_ATr_COLON] = ACTIONS(228),
    [anon_sym_ATf_COLON] = ACTIONS(228),
    [anon_sym_ATs_COLON] = ACTIONS(228),
    [anon_sym_ATx_COLON] = ACTIONS(228),
    [anon_sym_PIPE_DOT] = ACTIONS(228),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(228),
    [sym_pf_arg_identifier] = ACTIONS(234),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_GT_GT] = ACTIONS(228),
    [sym_html_redirect_operator] = ACTIONS(230),
    [sym_html_append_operator] = ACTIONS(228),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(236),
    [anon_sym_BQUOTE] = ACTIONS(238),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(228),
    [anon_sym_CR] = ACTIONS(228),
    [sym_file_descriptor] = ACTIONS(228),
    [sym__concat_pf_dot] = ACTIONS(240),
  },
  [67] = {
    [sym__arg] = STATE(356),
    [sym_arg] = STATE(318),
    [sym_double_quoted_arg] = STATE(356),
    [sym_single_quoted_arg] = STATE(356),
    [sym_cmd_substitution_arg] = STATE(356),
    [sym_concatenation] = STATE(378),
    [aux_sym_foreach_addrsize_command_repeat1] = STATE(68),
    [ts_builtin_sym_end] = ACTIONS(242),
    [anon_sym_DQUOTE] = ACTIONS(161),
    [anon_sym_TILDE] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(244),
    [anon_sym_PIPEH] = ACTIONS(242),
    [anon_sym_PIPET] = ACTIONS(242),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(242),
    [anon_sym_AT_AT_ATb] = ACTIONS(242),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(242),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(242),
    [anon_sym_AT_AT_ATi] = ACTIONS(242),
    [anon_sym_AT_AT_ATr] = ACTIONS(242),
    [anon_sym_AT_AT_ATs] = ACTIONS(244),
    [anon_sym_AT_AT_ATst] = ACTIONS(242),
    [anon_sym_AT_AT_ATS] = ACTIONS(242),
    [anon_sym_AT_AT_ATm] = ACTIONS(242),
    [anon_sym_AT_AT_ATM] = ACTIONS(242),
    [anon_sym_AT_AT_ATf] = ACTIONS(244),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(242),
    [anon_sym_AT_AT_ATF] = ACTIONS(244),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(242),
    [anon_sym_AT_AT_ATt] = ACTIONS(242),
    [anon_sym_AT_AT] = ACTIONS(244),
    [anon_sym_AT_ATdbt] = ACTIONS(244),
    [anon_sym_AT_ATdbta] = ACTIONS(242),
    [anon_sym_AT_ATdbtb] = ACTIONS(242),
    [anon_sym_AT_ATdbts] = ACTIONS(242),
    [anon_sym_AT_AT_DOT] = ACTIONS(242),
    [anon_sym_AT_AT_EQ] = ACTIONS(242),
    [anon_sym_AT_ATk] = ACTIONS(242),
    [anon_sym_AT_ATt] = ACTIONS(242),
    [anon_sym_AT_ATb] = ACTIONS(242),
    [anon_sym_AT_ATi] = ACTIONS(244),
    [anon_sym_AT_ATiS] = ACTIONS(242),
    [anon_sym_AT_ATf] = ACTIONS(242),
    [anon_sym_AT_ATs_COLON] = ACTIONS(242),
    [anon_sym_AT_ATc_COLON] = ACTIONS(242),
    [anon_sym_AT] = ACTIONS(244),
    [anon_sym_AT_BANG] = ACTIONS(242),
    [anon_sym_AT_LBRACE] = ACTIONS(242),
    [anon_sym_ATa_COLON] = ACTIONS(242),
    [anon_sym_ATb_COLON] = ACTIONS(242),
    [anon_sym_ATB_COLON] = ACTIONS(242),
    [anon_sym_ATe_COLON] = ACTIONS(242),
    [anon_sym_ATF_COLON] = ACTIONS(242),
    [anon_sym_ATi_COLON] = ACTIONS(242),
    [anon_sym_ATk_COLON] = ACTIONS(242),
    [anon_sym_ATo_COLON] = ACTIONS(242),
    [anon_sym_ATr_COLON] = ACTIONS(242),
    [anon_sym_ATf_COLON] = ACTIONS(242),
    [anon_sym_ATs_COLON] = ACTIONS(242),
    [anon_sym_ATx_COLON] = ACTIONS(242),
    [anon_sym_PIPE_DOT] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_SEMI] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(244),
    [anon_sym_GT_GT] = ACTIONS(242),
    [sym_html_redirect_operator] = ACTIONS(244),
    [sym_html_append_operator] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(167),
    [sym_arg_identifier] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(171),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(173),
    [anon_sym_BQUOTE] = ACTIONS(175),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(242),
    [anon_sym_CR] = ACTIONS(242),
    [sym_file_descriptor] = ACTIONS(242),
  },
  [68] = {
    [sym__arg] = STATE(356),
    [sym_arg] = STATE(318),
    [sym_double_quoted_arg] = STATE(356),
    [sym_single_quoted_arg] = STATE(356),
    [sym_cmd_substitution_arg] = STATE(356),
    [sym_concatenation] = STATE(378),
    [aux_sym_foreach_addrsize_command_repeat1] = STATE(68),
    [ts_builtin_sym_end] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [anon_sym_TILDE] = ACTIONS(246),
    [anon_sym_PIPE] = ACTIONS(251),
    [anon_sym_PIPEH] = ACTIONS(246),
    [anon_sym_PIPET] = ACTIONS(246),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(246),
    [anon_sym_AT_AT_ATb] = ACTIONS(246),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(246),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(246),
    [anon_sym_AT_AT_ATi] = ACTIONS(246),
    [anon_sym_AT_AT_ATr] = ACTIONS(246),
    [anon_sym_AT_AT_ATs] = ACTIONS(251),
    [anon_sym_AT_AT_ATst] = ACTIONS(246),
    [anon_sym_AT_AT_ATS] = ACTIONS(246),
    [anon_sym_AT_AT_ATm] = ACTIONS(246),
    [anon_sym_AT_AT_ATM] = ACTIONS(246),
    [anon_sym_AT_AT_ATf] = ACTIONS(251),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(246),
    [anon_sym_AT_AT_ATF] = ACTIONS(251),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(246),
    [anon_sym_AT_AT_ATt] = ACTIONS(246),
    [anon_sym_AT_AT] = ACTIONS(251),
    [anon_sym_AT_ATdbt] = ACTIONS(251),
    [anon_sym_AT_ATdbta] = ACTIONS(246),
    [anon_sym_AT_ATdbtb] = ACTIONS(246),
    [anon_sym_AT_ATdbts] = ACTIONS(246),
    [anon_sym_AT_AT_DOT] = ACTIONS(246),
    [anon_sym_AT_AT_EQ] = ACTIONS(246),
    [anon_sym_AT_ATk] = ACTIONS(246),
    [anon_sym_AT_ATt] = ACTIONS(246),
    [anon_sym_AT_ATb] = ACTIONS(246),
    [anon_sym_AT_ATi] = ACTIONS(251),
    [anon_sym_AT_ATiS] = ACTIONS(246),
    [anon_sym_AT_ATf] = ACTIONS(246),
    [anon_sym_AT_ATs_COLON] = ACTIONS(246),
    [anon_sym_AT_ATc_COLON] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(251),
    [anon_sym_AT_BANG] = ACTIONS(246),
    [anon_sym_AT_LBRACE] = ACTIONS(246),
    [anon_sym_ATa_COLON] = ACTIONS(246),
    [anon_sym_ATb_COLON] = ACTIONS(246),
    [anon_sym_ATB_COLON] = ACTIONS(246),
    [anon_sym_ATe_COLON] = ACTIONS(246),
    [anon_sym_ATF_COLON] = ACTIONS(246),
    [anon_sym_ATi_COLON] = ACTIONS(246),
    [anon_sym_ATk_COLON] = ACTIONS(246),
    [anon_sym_ATo_COLON] = ACTIONS(246),
    [anon_sym_ATr_COLON] = ACTIONS(246),
    [anon_sym_ATf_COLON] = ACTIONS(246),
    [anon_sym_ATs_COLON] = ACTIONS(246),
    [anon_sym_ATx_COLON] = ACTIONS(246),
    [anon_sym_PIPE_DOT] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(253),
    [anon_sym_RPAREN] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(246),
    [anon_sym_GT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(246),
    [sym_html_redirect_operator] = ACTIONS(251),
    [sym_html_append_operator] = ACTIONS(246),
    [anon_sym_COMMA] = ACTIONS(256),
    [sym_arg_identifier] = ACTIONS(259),
    [anon_sym_SQUOTE] = ACTIONS(262),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(265),
    [anon_sym_BQUOTE] = ACTIONS(268),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(246),
    [anon_sym_CR] = ACTIONS(246),
    [sym_file_descriptor] = ACTIONS(246),
  },
  [69] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(65),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(65),
    [ts_builtin_sym_end] = ACTIONS(271),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_PIPE] = ACTIONS(273),
    [anon_sym_PIPEH] = ACTIONS(271),
    [anon_sym_PIPET] = ACTIONS(271),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(271),
    [anon_sym_AT_AT_ATb] = ACTIONS(271),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(271),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(271),
    [anon_sym_AT_AT_ATi] = ACTIONS(271),
    [anon_sym_AT_AT_ATr] = ACTIONS(271),
    [anon_sym_AT_AT_ATs] = ACTIONS(273),
    [anon_sym_AT_AT_ATst] = ACTIONS(271),
    [anon_sym_AT_AT_ATS] = ACTIONS(271),
    [anon_sym_AT_AT_ATm] = ACTIONS(271),
    [anon_sym_AT_AT_ATM] = ACTIONS(271),
    [anon_sym_AT_AT_ATf] = ACTIONS(273),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(271),
    [anon_sym_AT_AT_ATF] = ACTIONS(273),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(271),
    [anon_sym_AT_AT_ATt] = ACTIONS(271),
    [anon_sym_AT_AT] = ACTIONS(273),
    [anon_sym_AT_ATdbt] = ACTIONS(273),
    [anon_sym_AT_ATdbta] = ACTIONS(271),
    [anon_sym_AT_ATdbtb] = ACTIONS(271),
    [anon_sym_AT_ATdbts] = ACTIONS(271),
    [anon_sym_AT_AT_DOT] = ACTIONS(271),
    [anon_sym_AT_AT_EQ] = ACTIONS(271),
    [anon_sym_AT_ATk] = ACTIONS(271),
    [anon_sym_AT_ATt] = ACTIONS(271),
    [anon_sym_AT_ATb] = ACTIONS(271),
    [anon_sym_AT_ATi] = ACTIONS(273),
    [anon_sym_AT_ATiS] = ACTIONS(271),
    [anon_sym_AT_ATf] = ACTIONS(271),
    [anon_sym_AT_ATs_COLON] = ACTIONS(271),
    [anon_sym_AT_ATc_COLON] = ACTIONS(271),
    [anon_sym_AT] = ACTIONS(273),
    [anon_sym_AT_BANG] = ACTIONS(271),
    [anon_sym_AT_LBRACE] = ACTIONS(271),
    [anon_sym_ATa_COLON] = ACTIONS(271),
    [anon_sym_ATb_COLON] = ACTIONS(271),
    [anon_sym_ATB_COLON] = ACTIONS(271),
    [anon_sym_ATe_COLON] = ACTIONS(271),
    [anon_sym_ATF_COLON] = ACTIONS(271),
    [anon_sym_ATi_COLON] = ACTIONS(271),
    [anon_sym_ATk_COLON] = ACTIONS(271),
    [anon_sym_ATo_COLON] = ACTIONS(271),
    [anon_sym_ATr_COLON] = ACTIONS(271),
    [anon_sym_ATf_COLON] = ACTIONS(271),
    [anon_sym_ATs_COLON] = ACTIONS(271),
    [anon_sym_ATx_COLON] = ACTIONS(271),
    [anon_sym_PIPE_DOT] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(271),
    [anon_sym_SEMI] = ACTIONS(271),
    [anon_sym_GT] = ACTIONS(273),
    [anon_sym_GT_GT] = ACTIONS(271),
    [sym_html_redirect_operator] = ACTIONS(273),
    [sym_html_append_operator] = ACTIONS(271),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(271),
    [anon_sym_CR] = ACTIONS(271),
    [sym_file_descriptor] = ACTIONS(271),
  },
  [70] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(248),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_PIPEH] = ACTIONS(147),
    [anon_sym_PIPET] = ACTIONS(147),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(147),
    [anon_sym_AT_AT_ATb] = ACTIONS(147),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATi] = ACTIONS(147),
    [anon_sym_AT_AT_ATr] = ACTIONS(147),
    [anon_sym_AT_AT_ATs] = ACTIONS(149),
    [anon_sym_AT_AT_ATst] = ACTIONS(147),
    [anon_sym_AT_AT_ATS] = ACTIONS(147),
    [anon_sym_AT_AT_ATm] = ACTIONS(147),
    [anon_sym_AT_AT_ATM] = ACTIONS(147),
    [anon_sym_AT_AT_ATf] = ACTIONS(149),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATF] = ACTIONS(149),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATt] = ACTIONS(147),
    [anon_sym_AT_AT] = ACTIONS(149),
    [anon_sym_AT_ATdbt] = ACTIONS(149),
    [anon_sym_AT_ATdbta] = ACTIONS(147),
    [anon_sym_AT_ATdbtb] = ACTIONS(147),
    [anon_sym_AT_ATdbts] = ACTIONS(147),
    [anon_sym_AT_AT_DOT] = ACTIONS(147),
    [anon_sym_AT_AT_EQ] = ACTIONS(147),
    [anon_sym_AT_ATk] = ACTIONS(147),
    [anon_sym_AT_ATt] = ACTIONS(147),
    [anon_sym_AT_ATb] = ACTIONS(147),
    [anon_sym_AT_ATi] = ACTIONS(149),
    [anon_sym_AT_ATiS] = ACTIONS(147),
    [anon_sym_AT_ATf] = ACTIONS(147),
    [anon_sym_AT_ATs_COLON] = ACTIONS(147),
    [anon_sym_AT_ATc_COLON] = ACTIONS(147),
    [anon_sym_AT] = ACTIONS(149),
    [anon_sym_AT_BANG] = ACTIONS(147),
    [anon_sym_AT_LBRACE] = ACTIONS(147),
    [anon_sym_ATa_COLON] = ACTIONS(147),
    [anon_sym_ATb_COLON] = ACTIONS(147),
    [anon_sym_ATB_COLON] = ACTIONS(147),
    [anon_sym_ATe_COLON] = ACTIONS(147),
    [anon_sym_ATF_COLON] = ACTIONS(147),
    [anon_sym_ATi_COLON] = ACTIONS(147),
    [anon_sym_ATk_COLON] = ACTIONS(147),
    [anon_sym_ATo_COLON] = ACTIONS(147),
    [anon_sym_ATr_COLON] = ACTIONS(147),
    [anon_sym_ATf_COLON] = ACTIONS(147),
    [anon_sym_ATs_COLON] = ACTIONS(147),
    [anon_sym_ATx_COLON] = ACTIONS(147),
    [anon_sym_PIPE_DOT] = ACTIONS(147),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(149),
    [anon_sym_GT_GT] = ACTIONS(147),
    [sym_html_redirect_operator] = ACTIONS(149),
    [sym_html_append_operator] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(147),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(147),
  },
  [71] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(245),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(181),
    [anon_sym_PIPE] = ACTIONS(183),
    [anon_sym_PIPEH] = ACTIONS(181),
    [anon_sym_PIPET] = ACTIONS(181),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(181),
    [anon_sym_AT_AT_ATb] = ACTIONS(181),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(181),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(181),
    [anon_sym_AT_AT_ATi] = ACTIONS(181),
    [anon_sym_AT_AT_ATr] = ACTIONS(181),
    [anon_sym_AT_AT_ATs] = ACTIONS(183),
    [anon_sym_AT_AT_ATst] = ACTIONS(181),
    [anon_sym_AT_AT_ATS] = ACTIONS(181),
    [anon_sym_AT_AT_ATm] = ACTIONS(181),
    [anon_sym_AT_AT_ATM] = ACTIONS(181),
    [anon_sym_AT_AT_ATf] = ACTIONS(183),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(181),
    [anon_sym_AT_AT_ATF] = ACTIONS(183),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(181),
    [anon_sym_AT_AT_ATt] = ACTIONS(181),
    [anon_sym_AT_AT] = ACTIONS(183),
    [anon_sym_AT_ATdbt] = ACTIONS(183),
    [anon_sym_AT_ATdbta] = ACTIONS(181),
    [anon_sym_AT_ATdbtb] = ACTIONS(181),
    [anon_sym_AT_ATdbts] = ACTIONS(181),
    [anon_sym_AT_AT_DOT] = ACTIONS(181),
    [anon_sym_AT_AT_EQ] = ACTIONS(181),
    [anon_sym_AT_ATk] = ACTIONS(181),
    [anon_sym_AT_ATt] = ACTIONS(181),
    [anon_sym_AT_ATb] = ACTIONS(181),
    [anon_sym_AT_ATi] = ACTIONS(183),
    [anon_sym_AT_ATiS] = ACTIONS(181),
    [anon_sym_AT_ATf] = ACTIONS(181),
    [anon_sym_AT_ATs_COLON] = ACTIONS(181),
    [anon_sym_AT_ATc_COLON] = ACTIONS(181),
    [anon_sym_AT] = ACTIONS(183),
    [anon_sym_AT_BANG] = ACTIONS(181),
    [anon_sym_AT_LBRACE] = ACTIONS(181),
    [anon_sym_ATa_COLON] = ACTIONS(181),
    [anon_sym_ATb_COLON] = ACTIONS(181),
    [anon_sym_ATB_COLON] = ACTIONS(181),
    [anon_sym_ATe_COLON] = ACTIONS(181),
    [anon_sym_ATF_COLON] = ACTIONS(181),
    [anon_sym_ATi_COLON] = ACTIONS(181),
    [anon_sym_ATk_COLON] = ACTIONS(181),
    [anon_sym_ATo_COLON] = ACTIONS(181),
    [anon_sym_ATr_COLON] = ACTIONS(181),
    [anon_sym_ATf_COLON] = ACTIONS(181),
    [anon_sym_ATs_COLON] = ACTIONS(181),
    [anon_sym_ATx_COLON] = ACTIONS(181),
    [anon_sym_PIPE_DOT] = ACTIONS(181),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(183),
    [anon_sym_GT_GT] = ACTIONS(181),
    [sym_html_redirect_operator] = ACTIONS(183),
    [sym_html_append_operator] = ACTIONS(181),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(181),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(181),
  },
  [72] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(256),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(147),
    [anon_sym_PIPE] = ACTIONS(149),
    [anon_sym_PIPEH] = ACTIONS(147),
    [anon_sym_PIPET] = ACTIONS(147),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(147),
    [anon_sym_AT_AT_ATb] = ACTIONS(147),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATi] = ACTIONS(147),
    [anon_sym_AT_AT_ATr] = ACTIONS(147),
    [anon_sym_AT_AT_ATs] = ACTIONS(149),
    [anon_sym_AT_AT_ATst] = ACTIONS(147),
    [anon_sym_AT_AT_ATS] = ACTIONS(147),
    [anon_sym_AT_AT_ATm] = ACTIONS(147),
    [anon_sym_AT_AT_ATM] = ACTIONS(147),
    [anon_sym_AT_AT_ATf] = ACTIONS(149),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATF] = ACTIONS(149),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(147),
    [anon_sym_AT_AT_ATt] = ACTIONS(147),
    [anon_sym_AT_AT] = ACTIONS(149),
    [anon_sym_AT_ATdbt] = ACTIONS(149),
    [anon_sym_AT_ATdbta] = ACTIONS(147),
    [anon_sym_AT_ATdbtb] = ACTIONS(147),
    [anon_sym_AT_ATdbts] = ACTIONS(147),
    [anon_sym_AT_AT_DOT] = ACTIONS(147),
    [anon_sym_AT_AT_EQ] = ACTIONS(147),
    [anon_sym_AT_ATk] = ACTIONS(147),
    [anon_sym_AT_ATt] = ACTIONS(147),
    [anon_sym_AT_ATb] = ACTIONS(147),
    [anon_sym_AT_ATi] = ACTIONS(149),
    [anon_sym_AT_ATiS] = ACTIONS(147),
    [anon_sym_AT_ATf] = ACTIONS(147),
    [anon_sym_AT_ATs_COLON] = ACTIONS(147),
    [anon_sym_AT_ATc_COLON] = ACTIONS(147),
    [anon_sym_AT] = ACTIONS(149),
    [anon_sym_AT_BANG] = ACTIONS(147),
    [anon_sym_AT_LBRACE] = ACTIONS(147),
    [anon_sym_ATa_COLON] = ACTIONS(147),
    [anon_sym_ATb_COLON] = ACTIONS(147),
    [anon_sym_ATB_COLON] = ACTIONS(147),
    [anon_sym_ATe_COLON] = ACTIONS(147),
    [anon_sym_ATF_COLON] = ACTIONS(147),
    [anon_sym_ATi_COLON] = ACTIONS(147),
    [anon_sym_ATk_COLON] = ACTIONS(147),
    [anon_sym_ATo_COLON] = ACTIONS(147),
    [anon_sym_ATr_COLON] = ACTIONS(147),
    [anon_sym_ATf_COLON] = ACTIONS(147),
    [anon_sym_ATs_COLON] = ACTIONS(147),
    [anon_sym_ATx_COLON] = ACTIONS(147),
    [anon_sym_PIPE_DOT] = ACTIONS(147),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(149),
    [anon_sym_GT_GT] = ACTIONS(147),
    [sym_html_redirect_operator] = ACTIONS(149),
    [sym_html_append_operator] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(147),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(147),
  },
  [73] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(264),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_PIPE] = ACTIONS(71),
    [anon_sym_PIPEH] = ACTIONS(69),
    [anon_sym_PIPET] = ACTIONS(69),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(69),
    [anon_sym_AT_AT_ATb] = ACTIONS(69),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATi] = ACTIONS(69),
    [anon_sym_AT_AT_ATr] = ACTIONS(69),
    [anon_sym_AT_AT_ATs] = ACTIONS(71),
    [anon_sym_AT_AT_ATst] = ACTIONS(69),
    [anon_sym_AT_AT_ATS] = ACTIONS(69),
    [anon_sym_AT_AT_ATm] = ACTIONS(69),
    [anon_sym_AT_AT_ATM] = ACTIONS(69),
    [anon_sym_AT_AT_ATf] = ACTIONS(71),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATF] = ACTIONS(71),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(69),
    [anon_sym_AT_AT_ATt] = ACTIONS(69),
    [anon_sym_AT_AT] = ACTIONS(71),
    [anon_sym_AT_ATdbt] = ACTIONS(71),
    [anon_sym_AT_ATdbta] = ACTIONS(69),
    [anon_sym_AT_ATdbtb] = ACTIONS(69),
    [anon_sym_AT_ATdbts] = ACTIONS(69),
    [anon_sym_AT_AT_DOT] = ACTIONS(69),
    [anon_sym_AT_AT_EQ] = ACTIONS(69),
    [anon_sym_AT_ATk] = ACTIONS(69),
    [anon_sym_AT_ATt] = ACTIONS(69),
    [anon_sym_AT_ATb] = ACTIONS(69),
    [anon_sym_AT_ATi] = ACTIONS(71),
    [anon_sym_AT_ATiS] = ACTIONS(69),
    [anon_sym_AT_ATf] = ACTIONS(69),
    [anon_sym_AT_ATs_COLON] = ACTIONS(69),
    [anon_sym_AT_ATc_COLON] = ACTIONS(69),
    [anon_sym_AT] = ACTIONS(71),
    [anon_sym_AT_BANG] = ACTIONS(69),
    [anon_sym_AT_LBRACE] = ACTIONS(69),
    [anon_sym_ATa_COLON] = ACTIONS(69),
    [anon_sym_ATb_COLON] = ACTIONS(69),
    [anon_sym_ATB_COLON] = ACTIONS(69),
    [anon_sym_ATe_COLON] = ACTIONS(69),
    [anon_sym_ATF_COLON] = ACTIONS(69),
    [anon_sym_ATi_COLON] = ACTIONS(69),
    [anon_sym_ATk_COLON] = ACTIONS(69),
    [anon_sym_ATo_COLON] = ACTIONS(69),
    [anon_sym_ATr_COLON] = ACTIONS(69),
    [anon_sym_ATf_COLON] = ACTIONS(69),
    [anon_sym_ATs_COLON] = ACTIONS(69),
    [anon_sym_ATx_COLON] = ACTIONS(69),
    [anon_sym_PIPE_DOT] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(69),
    [sym_html_redirect_operator] = ACTIONS(71),
    [sym_html_append_operator] = ACTIONS(69),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(69),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(69),
  },
  [74] = {
    [sym_eq_sep_args] = STATE(237),
    [sym__eq_sep_key_single] = STATE(123),
    [sym_eq_sep_key] = STATE(176),
    [sym_double_quoted_arg] = STATE(168),
    [sym_single_quoted_arg] = STATE(168),
    [sym_cmd_substitution_arg] = STATE(168),
    [ts_builtin_sym_end] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_PIPEH] = ACTIONS(275),
    [anon_sym_PIPET] = ACTIONS(275),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(275),
    [anon_sym_AT_AT_ATb] = ACTIONS(275),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(275),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(275),
    [anon_sym_AT_AT_ATi] = ACTIONS(275),
    [anon_sym_AT_AT_ATr] = ACTIONS(275),
    [anon_sym_AT_AT_ATs] = ACTIONS(279),
    [anon_sym_AT_AT_ATst] = ACTIONS(275),
    [anon_sym_AT_AT_ATS] = ACTIONS(275),
    [anon_sym_AT_AT_ATm] = ACTIONS(275),
    [anon_sym_AT_AT_ATM] = ACTIONS(275),
    [anon_sym_AT_AT_ATf] = ACTIONS(279),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(275),
    [anon_sym_AT_AT_ATF] = ACTIONS(279),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(275),
    [anon_sym_AT_AT_ATt] = ACTIONS(275),
    [anon_sym_AT_AT] = ACTIONS(279),
    [anon_sym_AT_ATdbt] = ACTIONS(279),
    [anon_sym_AT_ATdbta] = ACTIONS(275),
    [anon_sym_AT_ATdbtb] = ACTIONS(275),
    [anon_sym_AT_ATdbts] = ACTIONS(275),
    [anon_sym_AT_AT_DOT] = ACTIONS(275),
    [anon_sym_AT_AT_EQ] = ACTIONS(275),
    [anon_sym_AT_ATk] = ACTIONS(275),
    [anon_sym_AT_ATt] = ACTIONS(275),
    [anon_sym_AT_ATb] = ACTIONS(275),
    [anon_sym_AT_ATi] = ACTIONS(279),
    [anon_sym_AT_ATiS] = ACTIONS(275),
    [anon_sym_AT_ATf] = ACTIONS(275),
    [anon_sym_AT_ATs_COLON] = ACTIONS(275),
    [anon_sym_AT_ATc_COLON] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_AT_BANG] = ACTIONS(275),
    [anon_sym_AT_LBRACE] = ACTIONS(275),
    [anon_sym_ATa_COLON] = ACTIONS(275),
    [anon_sym_ATb_COLON] = ACTIONS(275),
    [anon_sym_ATB_COLON] = ACTIONS(275),
    [anon_sym_ATe_COLON] = ACTIONS(275),
    [anon_sym_ATF_COLON] = ACTIONS(275),
    [anon_sym_ATi_COLON] = ACTIONS(275),
    [anon_sym_ATk_COLON] = ACTIONS(275),
    [anon_sym_ATo_COLON] = ACTIONS(275),
    [anon_sym_ATr_COLON] = ACTIONS(275),
    [anon_sym_ATf_COLON] = ACTIONS(275),
    [anon_sym_ATs_COLON] = ACTIONS(275),
    [anon_sym_ATx_COLON] = ACTIONS(275),
    [anon_sym_PIPE_DOT] = ACTIONS(275),
    [anon_sym_RPAREN] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(275),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_GT_GT] = ACTIONS(275),
    [sym_html_redirect_operator] = ACTIONS(279),
    [sym_html_append_operator] = ACTIONS(275),
    [sym__eq_sep_key_identifier] = ACTIONS(281),
    [anon_sym_SQUOTE] = ACTIONS(283),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(285),
    [anon_sym_BQUOTE] = ACTIONS(287),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(275),
    [anon_sym_CR] = ACTIONS(275),
    [sym_file_descriptor] = ACTIONS(275),
  },
  [75] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(247),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(125),
    [anon_sym_PIPE] = ACTIONS(129),
    [anon_sym_PIPEH] = ACTIONS(125),
    [anon_sym_PIPET] = ACTIONS(125),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(125),
    [anon_sym_AT_AT_ATb] = ACTIONS(125),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(125),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(125),
    [anon_sym_AT_AT_ATi] = ACTIONS(125),
    [anon_sym_AT_AT_ATr] = ACTIONS(125),
    [anon_sym_AT_AT_ATs] = ACTIONS(129),
    [anon_sym_AT_AT_ATst] = ACTIONS(125),
    [anon_sym_AT_AT_ATS] = ACTIONS(125),
    [anon_sym_AT_AT_ATm] = ACTIONS(125),
    [anon_sym_AT_AT_ATM] = ACTIONS(125),
    [anon_sym_AT_AT_ATf] = ACTIONS(129),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(125),
    [anon_sym_AT_AT_ATF] = ACTIONS(129),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(125),
    [anon_sym_AT_AT_ATt] = ACTIONS(125),
    [anon_sym_AT_AT] = ACTIONS(129),
    [anon_sym_AT_ATdbt] = ACTIONS(129),
    [anon_sym_AT_ATdbta] = ACTIONS(125),
    [anon_sym_AT_ATdbtb] = ACTIONS(125),
    [anon_sym_AT_ATdbts] = ACTIONS(125),
    [anon_sym_AT_AT_DOT] = ACTIONS(125),
    [anon_sym_AT_AT_EQ] = ACTIONS(125),
    [anon_sym_AT_ATk] = ACTIONS(125),
    [anon_sym_AT_ATt] = ACTIONS(125),
    [anon_sym_AT_ATb] = ACTIONS(125),
    [anon_sym_AT_ATi] = ACTIONS(129),
    [anon_sym_AT_ATiS] = ACTIONS(125),
    [anon_sym_AT_ATf] = ACTIONS(125),
    [anon_sym_AT_ATs_COLON] = ACTIONS(125),
    [anon_sym_AT_ATc_COLON] = ACTIONS(125),
    [anon_sym_AT] = ACTIONS(129),
    [anon_sym_AT_BANG] = ACTIONS(125),
    [anon_sym_AT_LBRACE] = ACTIONS(125),
    [anon_sym_ATa_COLON] = ACTIONS(125),
    [anon_sym_ATb_COLON] = ACTIONS(125),
    [anon_sym_ATB_COLON] = ACTIONS(125),
    [anon_sym_ATe_COLON] = ACTIONS(125),
    [anon_sym_ATF_COLON] = ACTIONS(125),
    [anon_sym_ATi_COLON] = ACTIONS(125),
    [anon_sym_ATk_COLON] = ACTIONS(125),
    [anon_sym_ATo_COLON] = ACTIONS(125),
    [anon_sym_ATr_COLON] = ACTIONS(125),
    [anon_sym_ATf_COLON] = ACTIONS(125),
    [anon_sym_ATs_COLON] = ACTIONS(125),
    [anon_sym_ATx_COLON] = ACTIONS(125),
    [anon_sym_PIPE_DOT] = ACTIONS(125),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(125),
    [anon_sym_GT] = ACTIONS(129),
    [anon_sym_GT_GT] = ACTIONS(125),
    [sym_html_redirect_operator] = ACTIONS(129),
    [sym_html_append_operator] = ACTIONS(125),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(125),
  },
  [76] = {
    [sym_macro_content] = STATE(167),
    [sym_macro_args] = STATE(270),
    [sym__arg] = STATE(356),
    [sym_arg] = STATE(296),
    [sym_double_quoted_arg] = STATE(356),
    [sym_single_quoted_arg] = STATE(356),
    [sym_cmd_substitution_arg] = STATE(356),
    [sym_concatenation] = STATE(378),
    [anon_sym_DQUOTE] = ACTIONS(161),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_PIPE] = ACTIONS(163),
    [anon_sym_PIPEH] = ACTIONS(159),
    [anon_sym_PIPET] = ACTIONS(159),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(159),
    [anon_sym_AT_AT_ATb] = ACTIONS(159),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(159),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(159),
    [anon_sym_AT_AT_ATi] = ACTIONS(159),
    [anon_sym_AT_AT_ATr] = ACTIONS(159),
    [anon_sym_AT_AT_ATs] = ACTIONS(163),
    [anon_sym_AT_AT_ATst] = ACTIONS(159),
    [anon_sym_AT_AT_ATS] = ACTIONS(159),
    [anon_sym_AT_AT_ATm] = ACTIONS(159),
    [anon_sym_AT_AT_ATM] = ACTIONS(159),
    [anon_sym_AT_AT_ATf] = ACTIONS(163),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(159),
    [anon_sym_AT_AT_ATF] = ACTIONS(163),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(159),
    [anon_sym_AT_AT_ATt] = ACTIONS(159),
    [anon_sym_AT_AT] = ACTIONS(163),
    [anon_sym_AT_ATdbt] = ACTIONS(163),
    [anon_sym_AT_ATdbta] = ACTIONS(159),
    [anon_sym_AT_ATdbtb] = ACTIONS(159),
    [anon_sym_AT_ATdbts] = ACTIONS(159),
    [anon_sym_AT_AT_DOT] = ACTIONS(159),
    [anon_sym_AT_AT_EQ] = ACTIONS(159),
    [anon_sym_AT_ATk] = ACTIONS(159),
    [anon_sym_AT_ATt] = ACTIONS(159),
    [anon_sym_AT_ATb] = ACTIONS(159),
    [anon_sym_AT_ATi] = ACTIONS(163),
    [anon_sym_AT_ATiS] = ACTIONS(159),
    [anon_sym_AT_ATf] = ACTIONS(159),
    [anon_sym_AT_ATs_COLON] = ACTIONS(159),
    [anon_sym_AT_ATc_COLON] = ACTIONS(159),
    [anon_sym_AT] = ACTIONS(163),
    [anon_sym_AT_BANG] = ACTIONS(159),
    [anon_sym_AT_LBRACE] = ACTIONS(159),
    [anon_sym_ATa_COLON] = ACTIONS(159),
    [anon_sym_ATb_COLON] = ACTIONS(159),
    [anon_sym_ATB_COLON] = ACTIONS(159),
    [anon_sym_ATe_COLON] = ACTIONS(159),
    [anon_sym_ATF_COLON] = ACTIONS(159),
    [anon_sym_ATi_COLON] = ACTIONS(159),
    [anon_sym_ATk_COLON] = ACTIONS(159),
    [anon_sym_ATo_COLON] = ACTIONS(159),
    [anon_sym_ATr_COLON] = ACTIONS(159),
    [anon_sym_ATf_COLON] = ACTIONS(159),
    [anon_sym_ATs_COLON] = ACTIONS(159),
    [anon_sym_ATx_COLON] = ACTIONS(159),
    [anon_sym_PIPE_DOT] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_SEMI] = ACTIONS(159),
    [anon_sym_GT] = ACTIONS(163),
    [anon_sym_GT_GT] = ACTIONS(159),
    [sym_html_redirect_operator] = ACTIONS(163),
    [sym_html_append_operator] = ACTIONS(159),
    [anon_sym_COMMA] = ACTIONS(167),
    [sym_arg_identifier] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(171),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(173),
    [anon_sym_BQUOTE] = ACTIONS(159),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(159),
  },
  [77] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(233),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(143),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_PIPEH] = ACTIONS(143),
    [anon_sym_PIPET] = ACTIONS(143),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(143),
    [anon_sym_AT_AT_ATb] = ACTIONS(143),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(143),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(143),
    [anon_sym_AT_AT_ATi] = ACTIONS(143),
    [anon_sym_AT_AT_ATr] = ACTIONS(143),
    [anon_sym_AT_AT_ATs] = ACTIONS(145),
    [anon_sym_AT_AT_ATst] = ACTIONS(143),
    [anon_sym_AT_AT_ATS] = ACTIONS(143),
    [anon_sym_AT_AT_ATm] = ACTIONS(143),
    [anon_sym_AT_AT_ATM] = ACTIONS(143),
    [anon_sym_AT_AT_ATf] = ACTIONS(145),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(143),
    [anon_sym_AT_AT_ATF] = ACTIONS(145),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(143),
    [anon_sym_AT_AT_ATt] = ACTIONS(143),
    [anon_sym_AT_AT] = ACTIONS(145),
    [anon_sym_AT_ATdbt] = ACTIONS(145),
    [anon_sym_AT_ATdbta] = ACTIONS(143),
    [anon_sym_AT_ATdbtb] = ACTIONS(143),
    [anon_sym_AT_ATdbts] = ACTIONS(143),
    [anon_sym_AT_AT_DOT] = ACTIONS(143),
    [anon_sym_AT_AT_EQ] = ACTIONS(143),
    [anon_sym_AT_ATk] = ACTIONS(143),
    [anon_sym_AT_ATt] = ACTIONS(143),
    [anon_sym_AT_ATb] = ACTIONS(143),
    [anon_sym_AT_ATi] = ACTIONS(145),
    [anon_sym_AT_ATiS] = ACTIONS(143),
    [anon_sym_AT_ATf] = ACTIONS(143),
    [anon_sym_AT_ATs_COLON] = ACTIONS(143),
    [anon_sym_AT_ATc_COLON] = ACTIONS(143),
    [anon_sym_AT] = ACTIONS(145),
    [anon_sym_AT_BANG] = ACTIONS(143),
    [anon_sym_AT_LBRACE] = ACTIONS(143),
    [anon_sym_ATa_COLON] = ACTIONS(143),
    [anon_sym_ATb_COLON] = ACTIONS(143),
    [anon_sym_ATB_COLON] = ACTIONS(143),
    [anon_sym_ATe_COLON] = ACTIONS(143),
    [anon_sym_ATF_COLON] = ACTIONS(143),
    [anon_sym_ATi_COLON] = ACTIONS(143),
    [anon_sym_ATk_COLON] = ACTIONS(143),
    [anon_sym_ATo_COLON] = ACTIONS(143),
    [anon_sym_ATr_COLON] = ACTIONS(143),
    [anon_sym_ATf_COLON] = ACTIONS(143),
    [anon_sym_ATs_COLON] = ACTIONS(143),
    [anon_sym_ATx_COLON] = ACTIONS(143),
    [anon_sym_PIPE_DOT] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(143),
    [anon_sym_GT] = ACTIONS(145),
    [anon_sym_GT_GT] = ACTIONS(143),
    [sym_html_redirect_operator] = ACTIONS(145),
    [sym_html_append_operator] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(143),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(143),
  },
  [78] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(273),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(177),
    [anon_sym_PIPE] = ACTIONS(179),
    [anon_sym_PIPEH] = ACTIONS(177),
    [anon_sym_PIPET] = ACTIONS(177),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(177),
    [anon_sym_AT_AT_ATb] = ACTIONS(177),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(177),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(177),
    [anon_sym_AT_AT_ATi] = ACTIONS(177),
    [anon_sym_AT_AT_ATr] = ACTIONS(177),
    [anon_sym_AT_AT_ATs] = ACTIONS(179),
    [anon_sym_AT_AT_ATst] = ACTIONS(177),
    [anon_sym_AT_AT_ATS] = ACTIONS(177),
    [anon_sym_AT_AT_ATm] = ACTIONS(177),
    [anon_sym_AT_AT_ATM] = ACTIONS(177),
    [anon_sym_AT_AT_ATf] = ACTIONS(179),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(177),
    [anon_sym_AT_AT_ATF] = ACTIONS(179),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(177),
    [anon_sym_AT_AT_ATt] = ACTIONS(177),
    [anon_sym_AT_AT] = ACTIONS(179),
    [anon_sym_AT_ATdbt] = ACTIONS(179),
    [anon_sym_AT_ATdbta] = ACTIONS(177),
    [anon_sym_AT_ATdbtb] = ACTIONS(177),
    [anon_sym_AT_ATdbts] = ACTIONS(177),
    [anon_sym_AT_AT_DOT] = ACTIONS(177),
    [anon_sym_AT_AT_EQ] = ACTIONS(177),
    [anon_sym_AT_ATk] = ACTIONS(177),
    [anon_sym_AT_ATt] = ACTIONS(177),
    [anon_sym_AT_ATb] = ACTIONS(177),
    [anon_sym_AT_ATi] = ACTIONS(179),
    [anon_sym_AT_ATiS] = ACTIONS(177),
    [anon_sym_AT_ATf] = ACTIONS(177),
    [anon_sym_AT_ATs_COLON] = ACTIONS(177),
    [anon_sym_AT_ATc_COLON] = ACTIONS(177),
    [anon_sym_AT] = ACTIONS(179),
    [anon_sym_AT_BANG] = ACTIONS(177),
    [anon_sym_AT_LBRACE] = ACTIONS(177),
    [anon_sym_ATa_COLON] = ACTIONS(177),
    [anon_sym_ATb_COLON] = ACTIONS(177),
    [anon_sym_ATB_COLON] = ACTIONS(177),
    [anon_sym_ATe_COLON] = ACTIONS(177),
    [anon_sym_ATF_COLON] = ACTIONS(177),
    [anon_sym_ATi_COLON] = ACTIONS(177),
    [anon_sym_ATk_COLON] = ACTIONS(177),
    [anon_sym_ATo_COLON] = ACTIONS(177),
    [anon_sym_ATr_COLON] = ACTIONS(177),
    [anon_sym_ATf_COLON] = ACTIONS(177),
    [anon_sym_ATs_COLON] = ACTIONS(177),
    [anon_sym_ATx_COLON] = ACTIONS(177),
    [anon_sym_PIPE_DOT] = ACTIONS(177),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_GT] = ACTIONS(177),
    [sym_html_redirect_operator] = ACTIONS(179),
    [sym_html_append_operator] = ACTIONS(177),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(177),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(177),
  },
  [79] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(260),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(151),
    [anon_sym_PIPE] = ACTIONS(153),
    [anon_sym_PIPEH] = ACTIONS(151),
    [anon_sym_PIPET] = ACTIONS(151),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(151),
    [anon_sym_AT_AT_ATb] = ACTIONS(151),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(151),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(151),
    [anon_sym_AT_AT_ATi] = ACTIONS(151),
    [anon_sym_AT_AT_ATr] = ACTIONS(151),
    [anon_sym_AT_AT_ATs] = ACTIONS(153),
    [anon_sym_AT_AT_ATst] = ACTIONS(151),
    [anon_sym_AT_AT_ATS] = ACTIONS(151),
    [anon_sym_AT_AT_ATm] = ACTIONS(151),
    [anon_sym_AT_AT_ATM] = ACTIONS(151),
    [anon_sym_AT_AT_ATf] = ACTIONS(153),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(151),
    [anon_sym_AT_AT_ATF] = ACTIONS(153),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(151),
    [anon_sym_AT_AT_ATt] = ACTIONS(151),
    [anon_sym_AT_AT] = ACTIONS(153),
    [anon_sym_AT_ATdbt] = ACTIONS(153),
    [anon_sym_AT_ATdbta] = ACTIONS(151),
    [anon_sym_AT_ATdbtb] = ACTIONS(151),
    [anon_sym_AT_ATdbts] = ACTIONS(151),
    [anon_sym_AT_AT_DOT] = ACTIONS(151),
    [anon_sym_AT_AT_EQ] = ACTIONS(151),
    [anon_sym_AT_ATk] = ACTIONS(151),
    [anon_sym_AT_ATt] = ACTIONS(151),
    [anon_sym_AT_ATb] = ACTIONS(151),
    [anon_sym_AT_ATi] = ACTIONS(153),
    [anon_sym_AT_ATiS] = ACTIONS(151),
    [anon_sym_AT_ATf] = ACTIONS(151),
    [anon_sym_AT_ATs_COLON] = ACTIONS(151),
    [anon_sym_AT_ATc_COLON] = ACTIONS(151),
    [anon_sym_AT] = ACTIONS(153),
    [anon_sym_AT_BANG] = ACTIONS(151),
    [anon_sym_AT_LBRACE] = ACTIONS(151),
    [anon_sym_ATa_COLON] = ACTIONS(151),
    [anon_sym_ATb_COLON] = ACTIONS(151),
    [anon_sym_ATB_COLON] = ACTIONS(151),
    [anon_sym_ATe_COLON] = ACTIONS(151),
    [anon_sym_ATF_COLON] = ACTIONS(151),
    [anon_sym_ATi_COLON] = ACTIONS(151),
    [anon_sym_ATk_COLON] = ACTIONS(151),
    [anon_sym_ATo_COLON] = ACTIONS(151),
    [anon_sym_ATr_COLON] = ACTIONS(151),
    [anon_sym_ATf_COLON] = ACTIONS(151),
    [anon_sym_ATs_COLON] = ACTIONS(151),
    [anon_sym_ATx_COLON] = ACTIONS(151),
    [anon_sym_PIPE_DOT] = ACTIONS(151),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_GT] = ACTIONS(153),
    [anon_sym_GT_GT] = ACTIONS(151),
    [sym_html_redirect_operator] = ACTIONS(153),
    [sym_html_append_operator] = ACTIONS(151),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(151),
  },
  [80] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(86),
    [sym_args] = STATE(195),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(86),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(155),
    [anon_sym_PIPE] = ACTIONS(157),
    [anon_sym_PIPEH] = ACTIONS(155),
    [anon_sym_PIPET] = ACTIONS(155),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(155),
    [anon_sym_AT_AT_ATb] = ACTIONS(155),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(155),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(155),
    [anon_sym_AT_AT_ATi] = ACTIONS(155),
    [anon_sym_AT_AT_ATr] = ACTIONS(155),
    [anon_sym_AT_AT_ATs] = ACTIONS(157),
    [anon_sym_AT_AT_ATst] = ACTIONS(155),
    [anon_sym_AT_AT_ATS] = ACTIONS(155),
    [anon_sym_AT_AT_ATm] = ACTIONS(155),
    [anon_sym_AT_AT_ATM] = ACTIONS(155),
    [anon_sym_AT_AT_ATf] = ACTIONS(157),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(155),
    [anon_sym_AT_AT_ATF] = ACTIONS(157),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(155),
    [anon_sym_AT_AT_ATt] = ACTIONS(155),
    [anon_sym_AT_AT] = ACTIONS(157),
    [anon_sym_AT_ATdbt] = ACTIONS(157),
    [anon_sym_AT_ATdbta] = ACTIONS(155),
    [anon_sym_AT_ATdbtb] = ACTIONS(155),
    [anon_sym_AT_ATdbts] = ACTIONS(155),
    [anon_sym_AT_AT_DOT] = ACTIONS(155),
    [anon_sym_AT_AT_EQ] = ACTIONS(155),
    [anon_sym_AT_ATk] = ACTIONS(155),
    [anon_sym_AT_ATt] = ACTIONS(155),
    [anon_sym_AT_ATb] = ACTIONS(155),
    [anon_sym_AT_ATi] = ACTIONS(157),
    [anon_sym_AT_ATiS] = ACTIONS(155),
    [anon_sym_AT_ATf] = ACTIONS(155),
    [anon_sym_AT_ATs_COLON] = ACTIONS(155),
    [anon_sym_AT_ATc_COLON] = ACTIONS(155),
    [anon_sym_AT] = ACTIONS(157),
    [anon_sym_AT_BANG] = ACTIONS(155),
    [anon_sym_AT_LBRACE] = ACTIONS(155),
    [anon_sym_ATa_COLON] = ACTIONS(155),
    [anon_sym_ATb_COLON] = ACTIONS(155),
    [anon_sym_ATB_COLON] = ACTIONS(155),
    [anon_sym_ATe_COLON] = ACTIONS(155),
    [anon_sym_ATF_COLON] = ACTIONS(155),
    [anon_sym_ATi_COLON] = ACTIONS(155),
    [anon_sym_ATk_COLON] = ACTIONS(155),
    [anon_sym_ATo_COLON] = ACTIONS(155),
    [anon_sym_ATr_COLON] = ACTIONS(155),
    [anon_sym_ATf_COLON] = ACTIONS(155),
    [anon_sym_ATs_COLON] = ACTIONS(155),
    [anon_sym_ATx_COLON] = ACTIONS(155),
    [anon_sym_PIPE_DOT] = ACTIONS(155),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(155),
    [anon_sym_GT] = ACTIONS(157),
    [anon_sym_GT_GT] = ACTIONS(155),
    [sym_html_redirect_operator] = ACTIONS(157),
    [sym_html_append_operator] = ACTIONS(155),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(141),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(155),
  },
  [81] = {
    [sym__pf_arg_parentheses] = STATE(106),
    [sym__pf_arg] = STATE(106),
    [sym_pf_concatenation] = STATE(124),
    [sym_pf_arg] = STATE(110),
    [sym_pf_args] = STATE(235),
    [sym_cmd_substitution_arg] = STATE(106),
    [aux_sym_pf_args_repeat1] = STATE(110),
    [aux_sym_pf_dot_args_repeat1] = STATE(133),
    [anon_sym_TILDE] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_PIPEH] = ACTIONS(228),
    [anon_sym_PIPET] = ACTIONS(228),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(228),
    [anon_sym_AT_AT_ATb] = ACTIONS(228),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATi] = ACTIONS(228),
    [anon_sym_AT_AT_ATr] = ACTIONS(228),
    [anon_sym_AT_AT_ATs] = ACTIONS(230),
    [anon_sym_AT_AT_ATst] = ACTIONS(228),
    [anon_sym_AT_AT_ATS] = ACTIONS(228),
    [anon_sym_AT_AT_ATm] = ACTIONS(228),
    [anon_sym_AT_AT_ATM] = ACTIONS(228),
    [anon_sym_AT_AT_ATf] = ACTIONS(230),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATF] = ACTIONS(230),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATt] = ACTIONS(228),
    [anon_sym_AT_AT] = ACTIONS(230),
    [anon_sym_AT_ATdbt] = ACTIONS(230),
    [anon_sym_AT_ATdbta] = ACTIONS(228),
    [anon_sym_AT_ATdbtb] = ACTIONS(228),
    [anon_sym_AT_ATdbts] = ACTIONS(228),
    [anon_sym_AT_AT_DOT] = ACTIONS(228),
    [anon_sym_AT_AT_EQ] = ACTIONS(228),
    [anon_sym_AT_ATk] = ACTIONS(228),
    [anon_sym_AT_ATt] = ACTIONS(228),
    [anon_sym_AT_ATb] = ACTIONS(228),
    [anon_sym_AT_ATi] = ACTIONS(230),
    [anon_sym_AT_ATiS] = ACTIONS(228),
    [anon_sym_AT_ATf] = ACTIONS(228),
    [anon_sym_AT_ATs_COLON] = ACTIONS(228),
    [anon_sym_AT_ATc_COLON] = ACTIONS(228),
    [anon_sym_AT] = ACTIONS(230),
    [anon_sym_AT_BANG] = ACTIONS(228),
    [anon_sym_AT_LBRACE] = ACTIONS(228),
    [anon_sym_ATa_COLON] = ACTIONS(228),
    [anon_sym_ATb_COLON] = ACTIONS(228),
    [anon_sym_ATB_COLON] = ACTIONS(228),
    [anon_sym_ATe_COLON] = ACTIONS(228),
    [anon_sym_ATF_COLON] = ACTIONS(228),
    [anon_sym_ATi_COLON] = ACTIONS(228),
    [anon_sym_ATk_COLON] = ACTIONS(228),
    [anon_sym_ATo_COLON] = ACTIONS(228),
    [anon_sym_ATr_COLON] = ACTIONS(228),
    [anon_sym_ATf_COLON] = ACTIONS(228),
    [anon_sym_ATs_COLON] = ACTIONS(228),
    [anon_sym_ATx_COLON] = ACTIONS(228),
    [anon_sym_PIPE_DOT] = ACTIONS(228),
    [anon_sym_EQ] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(232),
    [sym_pf_arg_identifier] = ACTIONS(234),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_GT_GT] = ACTIONS(228),
    [sym_html_redirect_operator] = ACTIONS(230),
    [sym_html_append_operator] = ACTIONS(228),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(236),
    [anon_sym_BQUOTE] = ACTIONS(228),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(228),
    [sym__concat_pf_dot] = ACTIONS(240),
  },
  [82] = {
    [sym__Cf_args] = STATE(267),
    [sym__arg] = STATE(451),
    [sym_arg] = STATE(358),
    [sym_double_quoted_arg] = STATE(451),
    [sym_single_quoted_arg] = STATE(451),
    [sym_cmd_substitution_arg] = STATE(451),
    [sym_concatenation] = STATE(484),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_TILDE] = ACTIONS(185),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_PIPEH] = ACTIONS(185),
    [anon_sym_PIPET] = ACTIONS(185),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(185),
    [anon_sym_AT_AT_ATb] = ACTIONS(185),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(185),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(185),
    [anon_sym_AT_AT_ATi] = ACTIONS(185),
    [anon_sym_AT_AT_ATr] = ACTIONS(185),
    [anon_sym_AT_AT_ATs] = ACTIONS(189),
    [anon_sym_AT_AT_ATst] = ACTIONS(185),
    [anon_sym_AT_AT_ATS] = ACTIONS(185),
    [anon_sym_AT_AT_ATm] = ACTIONS(185),
    [anon_sym_AT_AT_ATM] = ACTIONS(185),
    [anon_sym_AT_AT_ATf] = ACTIONS(189),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(185),
    [anon_sym_AT_AT_ATF] = ACTIONS(189),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(185),
    [anon_sym_AT_AT_ATt] = ACTIONS(185),
    [anon_sym_AT_AT] = ACTIONS(189),
    [anon_sym_AT_ATdbt] = ACTIONS(189),
    [anon_sym_AT_ATdbta] = ACTIONS(185),
    [anon_sym_AT_ATdbtb] = ACTIONS(185),
    [anon_sym_AT_ATdbts] = ACTIONS(185),
    [anon_sym_AT_AT_DOT] = ACTIONS(185),
    [anon_sym_AT_AT_EQ] = ACTIONS(185),
    [anon_sym_AT_ATk] = ACTIONS(185),
    [anon_sym_AT_ATt] = ACTIONS(185),
    [anon_sym_AT_ATb] = ACTIONS(185),
    [anon_sym_AT_ATi] = ACTIONS(189),
    [anon_sym_AT_ATiS] = ACTIONS(185),
    [anon_sym_AT_ATf] = ACTIONS(185),
    [anon_sym_AT_ATs_COLON] = ACTIONS(185),
    [anon_sym_AT_ATc_COLON] = ACTIONS(185),
    [anon_sym_AT] = ACTIONS(189),
    [anon_sym_AT_BANG] = ACTIONS(185),
    [anon_sym_AT_LBRACE] = ACTIONS(185),
    [anon_sym_ATa_COLON] = ACTIONS(185),
    [anon_sym_ATb_COLON] = ACTIONS(185),
    [anon_sym_ATB_COLON] = ACTIONS(185),
    [anon_sym_ATe_COLON] = ACTIONS(185),
    [anon_sym_ATF_COLON] = ACTIONS(185),
    [anon_sym_ATi_COLON] = ACTIONS(185),
    [anon_sym_ATk_COLON] = ACTIONS(185),
    [anon_sym_ATo_COLON] = ACTIONS(185),
    [anon_sym_ATr_COLON] = ACTIONS(185),
    [anon_sym_ATf_COLON] = ACTIONS(185),
    [anon_sym_ATs_COLON] = ACTIONS(185),
    [anon_sym_ATx_COLON] = ACTIONS(185),
    [anon_sym_PIPE_DOT] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(185),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_GT_GT] = ACTIONS(185),
    [sym_html_redirect_operator] = ACTIONS(189),
    [sym_html_append_operator] = ACTIONS(185),
    [anon_sym_COMMA] = ACTIONS(193),
    [sym_arg_identifier] = ACTIONS(195),
    [anon_sym_SQUOTE] = ACTIONS(197),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(199),
    [anon_sym_BQUOTE] = ACTIONS(185),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(185),
  },
  [83] = {
    [sym__pf_arg_parentheses] = STATE(106),
    [sym__pf_arg] = STATE(106),
    [sym_pf_concatenation] = STATE(124),
    [sym_pf_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(106),
    [aux_sym_pf_args_repeat1] = STATE(85),
    [ts_builtin_sym_end] = ACTIONS(289),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PIPEH] = ACTIONS(289),
    [anon_sym_PIPET] = ACTIONS(289),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(289),
    [anon_sym_AT_AT_ATb] = ACTIONS(289),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(289),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(289),
    [anon_sym_AT_AT_ATi] = ACTIONS(289),
    [anon_sym_AT_AT_ATr] = ACTIONS(289),
    [anon_sym_AT_AT_ATs] = ACTIONS(291),
    [anon_sym_AT_AT_ATst] = ACTIONS(289),
    [anon_sym_AT_AT_ATS] = ACTIONS(289),
    [anon_sym_AT_AT_ATm] = ACTIONS(289),
    [anon_sym_AT_AT_ATM] = ACTIONS(289),
    [anon_sym_AT_AT_ATf] = ACTIONS(291),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(289),
    [anon_sym_AT_AT_ATF] = ACTIONS(291),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(289),
    [anon_sym_AT_AT_ATt] = ACTIONS(289),
    [anon_sym_AT_AT] = ACTIONS(291),
    [anon_sym_AT_ATdbt] = ACTIONS(291),
    [anon_sym_AT_ATdbta] = ACTIONS(289),
    [anon_sym_AT_ATdbtb] = ACTIONS(289),
    [anon_sym_AT_ATdbts] = ACTIONS(289),
    [anon_sym_AT_AT_DOT] = ACTIONS(289),
    [anon_sym_AT_AT_EQ] = ACTIONS(289),
    [anon_sym_AT_ATk] = ACTIONS(289),
    [anon_sym_AT_ATt] = ACTIONS(289),
    [anon_sym_AT_ATb] = ACTIONS(289),
    [anon_sym_AT_ATi] = ACTIONS(291),
    [anon_sym_AT_ATiS] = ACTIONS(289),
    [anon_sym_AT_ATf] = ACTIONS(289),
    [anon_sym_AT_ATs_COLON] = ACTIONS(289),
    [anon_sym_AT_ATc_COLON] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(291),
    [anon_sym_AT_BANG] = ACTIONS(289),
    [anon_sym_AT_LBRACE] = ACTIONS(289),
    [anon_sym_ATa_COLON] = ACTIONS(289),
    [anon_sym_ATb_COLON] = ACTIONS(289),
    [anon_sym_ATB_COLON] = ACTIONS(289),
    [anon_sym_ATe_COLON] = ACTIONS(289),
    [anon_sym_ATF_COLON] = ACTIONS(289),
    [anon_sym_ATi_COLON] = ACTIONS(289),
    [anon_sym_ATk_COLON] = ACTIONS(289),
    [anon_sym_ATo_COLON] = ACTIONS(289),
    [anon_sym_ATr_COLON] = ACTIONS(289),
    [anon_sym_ATf_COLON] = ACTIONS(289),
    [anon_sym_ATs_COLON] = ACTIONS(289),
    [anon_sym_ATx_COLON] = ACTIONS(289),
    [anon_sym_PIPE_DOT] = ACTIONS(289),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(289),
    [sym_pf_arg_identifier] = ACTIONS(234),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_GT] = ACTIONS(289),
    [sym_html_redirect_operator] = ACTIONS(291),
    [sym_html_append_operator] = ACTIONS(289),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(236),
    [anon_sym_BQUOTE] = ACTIONS(238),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(289),
    [anon_sym_CR] = ACTIONS(289),
    [sym_file_descriptor] = ACTIONS(289),
  },
  [84] = {
    [sym__arg] = STATE(356),
    [sym_arg] = STATE(318),
    [sym_double_quoted_arg] = STATE(356),
    [sym_single_quoted_arg] = STATE(356),
    [sym_cmd_substitution_arg] = STATE(356),
    [sym_concatenation] = STATE(378),
    [aux_sym_foreach_addrsize_command_repeat1] = STATE(68),
    [anon_sym_DQUOTE] = ACTIONS(161),
    [anon_sym_TILDE] = ACTIONS(242),
    [anon_sym_PIPE] = ACTIONS(244),
    [anon_sym_PIPEH] = ACTIONS(242),
    [anon_sym_PIPET] = ACTIONS(242),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(242),
    [anon_sym_AT_AT_ATb] = ACTIONS(242),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(242),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(242),
    [anon_sym_AT_AT_ATi] = ACTIONS(242),
    [anon_sym_AT_AT_ATr] = ACTIONS(242),
    [anon_sym_AT_AT_ATs] = ACTIONS(244),
    [anon_sym_AT_AT_ATst] = ACTIONS(242),
    [anon_sym_AT_AT_ATS] = ACTIONS(242),
    [anon_sym_AT_AT_ATm] = ACTIONS(242),
    [anon_sym_AT_AT_ATM] = ACTIONS(242),
    [anon_sym_AT_AT_ATf] = ACTIONS(244),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(242),
    [anon_sym_AT_AT_ATF] = ACTIONS(244),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(242),
    [anon_sym_AT_AT_ATt] = ACTIONS(242),
    [anon_sym_AT_AT] = ACTIONS(244),
    [anon_sym_AT_ATdbt] = ACTIONS(244),
    [anon_sym_AT_ATdbta] = ACTIONS(242),
    [anon_sym_AT_ATdbtb] = ACTIONS(242),
    [anon_sym_AT_ATdbts] = ACTIONS(242),
    [anon_sym_AT_AT_DOT] = ACTIONS(242),
    [anon_sym_AT_AT_EQ] = ACTIONS(242),
    [anon_sym_AT_ATk] = ACTIONS(242),
    [anon_sym_AT_ATt] = ACTIONS(242),
    [anon_sym_AT_ATb] = ACTIONS(242),
    [anon_sym_AT_ATi] = ACTIONS(244),
    [anon_sym_AT_ATiS] = ACTIONS(242),
    [anon_sym_AT_ATf] = ACTIONS(242),
    [anon_sym_AT_ATs_COLON] = ACTIONS(242),
    [anon_sym_AT_ATc_COLON] = ACTIONS(242),
    [anon_sym_AT] = ACTIONS(244),
    [anon_sym_AT_BANG] = ACTIONS(242),
    [anon_sym_AT_LBRACE] = ACTIONS(242),
    [anon_sym_ATa_COLON] = ACTIONS(242),
    [anon_sym_ATb_COLON] = ACTIONS(242),
    [anon_sym_ATB_COLON] = ACTIONS(242),
    [anon_sym_ATe_COLON] = ACTIONS(242),
    [anon_sym_ATF_COLON] = ACTIONS(242),
    [anon_sym_ATi_COLON] = ACTIONS(242),
    [anon_sym_ATk_COLON] = ACTIONS(242),
    [anon_sym_ATo_COLON] = ACTIONS(242),
    [anon_sym_ATr_COLON] = ACTIONS(242),
    [anon_sym_ATf_COLON] = ACTIONS(242),
    [anon_sym_ATs_COLON] = ACTIONS(242),
    [anon_sym_ATx_COLON] = ACTIONS(242),
    [anon_sym_PIPE_DOT] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(165),
    [anon_sym_SEMI] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(244),
    [anon_sym_GT_GT] = ACTIONS(242),
    [sym_html_redirect_operator] = ACTIONS(244),
    [sym_html_append_operator] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(167),
    [sym_arg_identifier] = ACTIONS(169),
    [anon_sym_SQUOTE] = ACTIONS(171),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(173),
    [anon_sym_BQUOTE] = ACTIONS(242),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(242),
  },
  [85] = {
    [sym__pf_arg_parentheses] = STATE(106),
    [sym__pf_arg] = STATE(106),
    [sym_pf_concatenation] = STATE(124),
    [sym_pf_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(106),
    [aux_sym_pf_args_repeat1] = STATE(85),
    [ts_builtin_sym_end] = ACTIONS(293),
    [anon_sym_TILDE] = ACTIONS(293),
    [anon_sym_PIPE] = ACTIONS(295),
    [anon_sym_PIPEH] = ACTIONS(293),
    [anon_sym_PIPET] = ACTIONS(293),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(293),
    [anon_sym_AT_AT_ATb] = ACTIONS(293),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(293),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(293),
    [anon_sym_AT_AT_ATi] = ACTIONS(293),
    [anon_sym_AT_AT_ATr] = ACTIONS(293),
    [anon_sym_AT_AT_ATs] = ACTIONS(295),
    [anon_sym_AT_AT_ATst] = ACTIONS(293),
    [anon_sym_AT_AT_ATS] = ACTIONS(293),
    [anon_sym_AT_AT_ATm] = ACTIONS(293),
    [anon_sym_AT_AT_ATM] = ACTIONS(293),
    [anon_sym_AT_AT_ATf] = ACTIONS(295),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(293),
    [anon_sym_AT_AT_ATF] = ACTIONS(295),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(293),
    [anon_sym_AT_AT_ATt] = ACTIONS(293),
    [anon_sym_AT_AT] = ACTIONS(295),
    [anon_sym_AT_ATdbt] = ACTIONS(295),
    [anon_sym_AT_ATdbta] = ACTIONS(293),
    [anon_sym_AT_ATdbtb] = ACTIONS(293),
    [anon_sym_AT_ATdbts] = ACTIONS(293),
    [anon_sym_AT_AT_DOT] = ACTIONS(293),
    [anon_sym_AT_AT_EQ] = ACTIONS(293),
    [anon_sym_AT_ATk] = ACTIONS(293),
    [anon_sym_AT_ATt] = ACTIONS(293),
    [anon_sym_AT_ATb] = ACTIONS(293),
    [anon_sym_AT_ATi] = ACTIONS(295),
    [anon_sym_AT_ATiS] = ACTIONS(293),
    [anon_sym_AT_ATf] = ACTIONS(293),
    [anon_sym_AT_ATs_COLON] = ACTIONS(293),
    [anon_sym_AT_ATc_COLON] = ACTIONS(293),
    [anon_sym_AT] = ACTIONS(295),
    [anon_sym_AT_BANG] = ACTIONS(293),
    [anon_sym_AT_LBRACE] = ACTIONS(293),
    [anon_sym_ATa_COLON] = ACTIONS(293),
    [anon_sym_ATb_COLON] = ACTIONS(293),
    [anon_sym_ATB_COLON] = ACTIONS(293),
    [anon_sym_ATe_COLON] = ACTIONS(293),
    [anon_sym_ATF_COLON] = ACTIONS(293),
    [anon_sym_ATi_COLON] = ACTIONS(293),
    [anon_sym_ATk_COLON] = ACTIONS(293),
    [anon_sym_ATo_COLON] = ACTIONS(293),
    [anon_sym_ATr_COLON] = ACTIONS(293),
    [anon_sym_ATf_COLON] = ACTIONS(293),
    [anon_sym_ATs_COLON] = ACTIONS(293),
    [anon_sym_ATx_COLON] = ACTIONS(293),
    [anon_sym_PIPE_DOT] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(297),
    [anon_sym_RPAREN] = ACTIONS(293),
    [sym_pf_arg_identifier] = ACTIONS(300),
    [anon_sym_SEMI] = ACTIONS(293),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_GT] = ACTIONS(293),
    [sym_html_redirect_operator] = ACTIONS(295),
    [sym_html_append_operator] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(303),
    [anon_sym_BQUOTE] = ACTIONS(306),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(293),
    [anon_sym_CR] = ACTIONS(293),
    [sym_file_descriptor] = ACTIONS(293),
  },
  [86] = {
    [sym__arg] = STATE(88),
    [sym_arg] = STATE(65),
    [sym_double_quoted_arg] = STATE(88),
    [sym_single_quoted_arg] = STATE(88),
    [sym_cmd_substitution_arg] = STATE(88),
    [sym_concatenation] = STATE(102),
    [aux_sym_args_repeat1] = STATE(65),
    [anon_sym_DQUOTE] = ACTIONS(127),
    [anon_sym_TILDE] = ACTIONS(271),
    [anon_sym_PIPE] = ACTIONS(273),
    [anon_sym_PIPEH] = ACTIONS(271),
    [anon_sym_PIPET] = ACTIONS(271),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(271),
    [anon_sym_AT_AT_ATb] = ACTIONS(271),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(271),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(271),
    [anon_sym_AT_AT_ATi] = ACTIONS(271),
    [anon_sym_AT_AT_ATr] = ACTIONS(271),
    [anon_sym_AT_AT_ATs] = ACTIONS(273),
    [anon_sym_AT_AT_ATst] = ACTIONS(271),
    [anon_sym_AT_AT_ATS] = ACTIONS(271),
    [anon_sym_AT_AT_ATm] = ACTIONS(271),
    [anon_sym_AT_AT_ATM] = ACTIONS(271),
    [anon_sym_AT_AT_ATf] = ACTIONS(273),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(271),
    [anon_sym_AT_AT_ATF] = ACTIONS(273),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(271),
    [anon_sym_AT_AT_ATt] = ACTIONS(271),
    [anon_sym_AT_AT] = ACTIONS(273),
    [anon_sym_AT_ATdbt] = ACTIONS(273),
    [anon_sym_AT_ATdbta] = ACTIONS(271),
    [anon_sym_AT_ATdbtb] = ACTIONS(271),
    [anon_sym_AT_ATdbts] = ACTIONS(271),
    [anon_sym_AT_AT_DOT] = ACTIONS(271),
    [anon_sym_AT_AT_EQ] = ACTIONS(271),
    [anon_sym_AT_ATk] = ACTIONS(271),
    [anon_sym_AT_ATt] = ACTIONS(271),
    [anon_sym_AT_ATb] = ACTIONS(271),
    [anon_sym_AT_ATi] = ACTIONS(273),
    [anon_sym_AT_ATiS] = ACTIONS(271),
    [anon_sym_AT_ATf] = ACTIONS(271),
    [anon_sym_AT_ATs_COLON] = ACTIONS(271),
    [anon_sym_AT_ATc_COLON] = ACTIONS(271),
    [anon_sym_AT] = ACTIONS(273),
    [anon_sym_AT_BANG] = ACTIONS(271),
    [anon_sym_AT_LBRACE] = ACTIONS(271),
    [anon_sym_ATa_COLON] = ACTIONS(271),
    [anon_sym_ATb_COLON] = ACTIONS(271),
    [anon_sym_ATB_COLON] = ACTIONS(271),
    [anon_sym_ATe_COLON] = ACTIONS(271),
    [anon_sym_ATF_COLON] = ACTIONS(271),
    [anon_sym_ATi_COLON] = ACTIONS(271),
    [anon_sym_ATk_COLON] = ACTIONS(271),
    [anon_sym_ATo_COLON] = ACTIONS(271),
    [anon_sym_ATr_COLON] = ACTIONS(271),
    [anon_sym_ATf_COLON] = ACTIONS(271),
    [anon_sym_ATs_COLON] = ACTIONS(271),
    [anon_sym_ATx_COLON] = ACTIONS(271),
    [anon_sym_PIPE_DOT] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(271),
    [anon_sym_GT] = ACTIONS(273),
    [anon_sym_GT_GT] = ACTIONS(271),
    [sym_html_redirect_operator] = ACTIONS(273),
    [sym_html_append_operator] = ACTIONS(271),
    [anon_sym_COMMA] = ACTIONS(133),
    [sym_arg_identifier] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(139),
    [anon_sym_BQUOTE] = ACTIONS(271),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(271),
  },
  [87] = {
    [aux_sym_concatenation_repeat1] = STATE(89),
    [ts_builtin_sym_end] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(309),
    [anon_sym_TILDE] = ACTIONS(309),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_PIPEH] = ACTIONS(309),
    [anon_sym_PIPET] = ACTIONS(309),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(309),
    [anon_sym_AT_AT_ATb] = ACTIONS(309),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATi] = ACTIONS(309),
    [anon_sym_AT_AT_ATr] = ACTIONS(309),
    [anon_sym_AT_AT_ATs] = ACTIONS(311),
    [anon_sym_AT_AT_ATst] = ACTIONS(309),
    [anon_sym_AT_AT_ATS] = ACTIONS(309),
    [anon_sym_AT_AT_ATm] = ACTIONS(309),
    [anon_sym_AT_AT_ATM] = ACTIONS(309),
    [anon_sym_AT_AT_ATf] = ACTIONS(311),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATF] = ACTIONS(311),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATt] = ACTIONS(309),
    [anon_sym_AT_AT] = ACTIONS(311),
    [anon_sym_AT_ATdbt] = ACTIONS(311),
    [anon_sym_AT_ATdbta] = ACTIONS(309),
    [anon_sym_AT_ATdbtb] = ACTIONS(309),
    [anon_sym_AT_ATdbts] = ACTIONS(309),
    [anon_sym_AT_AT_DOT] = ACTIONS(309),
    [anon_sym_AT_AT_EQ] = ACTIONS(309),
    [anon_sym_AT_ATk] = ACTIONS(309),
    [anon_sym_AT_ATt] = ACTIONS(309),
    [anon_sym_AT_ATb] = ACTIONS(309),
    [anon_sym_AT_ATi] = ACTIONS(311),
    [anon_sym_AT_ATiS] = ACTIONS(309),
    [anon_sym_AT_ATf] = ACTIONS(309),
    [anon_sym_AT_ATs_COLON] = ACTIONS(309),
    [anon_sym_AT_ATc_COLON] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(311),
    [anon_sym_AT_BANG] = ACTIONS(309),
    [anon_sym_AT_LBRACE] = ACTIONS(309),
    [anon_sym_ATa_COLON] = ACTIONS(309),
    [anon_sym_ATb_COLON] = ACTIONS(309),
    [anon_sym_ATB_COLON] = ACTIONS(309),
    [anon_sym_ATe_COLON] = ACTIONS(309),
    [anon_sym_ATF_COLON] = ACTIONS(309),
    [anon_sym_ATi_COLON] = ACTIONS(309),
    [anon_sym_ATk_COLON] = ACTIONS(309),
    [anon_sym_ATo_COLON] = ACTIONS(309),
    [anon_sym_ATr_COLON] = ACTIONS(309),
    [anon_sym_ATf_COLON] = ACTIONS(309),
    [anon_sym_ATs_COLON] = ACTIONS(309),
    [anon_sym_ATx_COLON] = ACTIONS(309),
    [anon_sym_PIPE_DOT] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_RPAREN] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_GT] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(309),
    [sym_html_redirect_operator] = ACTIONS(311),
    [sym_html_append_operator] = ACTIONS(309),
    [anon_sym_COMMA] = ACTIONS(309),
    [sym_arg_identifier] = ACTIONS(311),
    [anon_sym_SQUOTE] = ACTIONS(309),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(309),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(309),
    [anon_sym_CR] = ACTIONS(309),
    [sym_file_descriptor] = ACTIONS(309),
    [sym__concat] = ACTIONS(313),
  },
  [88] = {
    [aux_sym_concatenation_repeat1] = STATE(87),
    [ts_builtin_sym_end] = ACTIONS(315),
    [anon_sym_DQUOTE] = ACTIONS(315),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_PIPE] = ACTIONS(317),
    [anon_sym_PIPEH] = ACTIONS(315),
    [anon_sym_PIPET] = ACTIONS(315),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(315),
    [anon_sym_AT_AT_ATb] = ACTIONS(315),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATi] = ACTIONS(315),
    [anon_sym_AT_AT_ATr] = ACTIONS(315),
    [anon_sym_AT_AT_ATs] = ACTIONS(317),
    [anon_sym_AT_AT_ATst] = ACTIONS(315),
    [anon_sym_AT_AT_ATS] = ACTIONS(315),
    [anon_sym_AT_AT_ATm] = ACTIONS(315),
    [anon_sym_AT_AT_ATM] = ACTIONS(315),
    [anon_sym_AT_AT_ATf] = ACTIONS(317),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATF] = ACTIONS(317),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATt] = ACTIONS(315),
    [anon_sym_AT_AT] = ACTIONS(317),
    [anon_sym_AT_ATdbt] = ACTIONS(317),
    [anon_sym_AT_ATdbta] = ACTIONS(315),
    [anon_sym_AT_ATdbtb] = ACTIONS(315),
    [anon_sym_AT_ATdbts] = ACTIONS(315),
    [anon_sym_AT_AT_DOT] = ACTIONS(315),
    [anon_sym_AT_AT_EQ] = ACTIONS(315),
    [anon_sym_AT_ATk] = ACTIONS(315),
    [anon_sym_AT_ATt] = ACTIONS(315),
    [anon_sym_AT_ATb] = ACTIONS(315),
    [anon_sym_AT_ATi] = ACTIONS(317),
    [anon_sym_AT_ATiS] = ACTIONS(315),
    [anon_sym_AT_ATf] = ACTIONS(315),
    [anon_sym_AT_ATs_COLON] = ACTIONS(315),
    [anon_sym_AT_ATc_COLON] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_AT_BANG] = ACTIONS(315),
    [anon_sym_AT_LBRACE] = ACTIONS(315),
    [anon_sym_ATa_COLON] = ACTIONS(315),
    [anon_sym_ATb_COLON] = ACTIONS(315),
    [anon_sym_ATB_COLON] = ACTIONS(315),
    [anon_sym_ATe_COLON] = ACTIONS(315),
    [anon_sym_ATF_COLON] = ACTIONS(315),
    [anon_sym_ATi_COLON] = ACTIONS(315),
    [anon_sym_ATk_COLON] = ACTIONS(315),
    [anon_sym_ATo_COLON] = ACTIONS(315),
    [anon_sym_ATr_COLON] = ACTIONS(315),
    [anon_sym_ATf_COLON] = ACTIONS(315),
    [anon_sym_ATs_COLON] = ACTIONS(315),
    [anon_sym_ATx_COLON] = ACTIONS(315),
    [anon_sym_PIPE_DOT] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_RPAREN] = ACTIONS(315),
    [anon_sym_SEMI] = ACTIONS(315),
    [anon_sym_GT] = ACTIONS(317),
    [anon_sym_GT_GT] = ACTIONS(315),
    [sym_html_redirect_operator] = ACTIONS(317),
    [sym_html_append_operator] = ACTIONS(315),
    [anon_sym_COMMA] = ACTIONS(315),
    [sym_arg_identifier] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(315),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(315),
    [anon_sym_BQUOTE] = ACTIONS(315),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(315),
    [anon_sym_CR] = ACTIONS(315),
    [sym_file_descriptor] = ACTIONS(315),
    [sym__concat] = ACTIONS(313),
  },
  [89] = {
    [aux_sym_concatenation_repeat1] = STATE(89),
    [ts_builtin_sym_end] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_PIPEH] = ACTIONS(319),
    [anon_sym_PIPET] = ACTIONS(319),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATi] = ACTIONS(319),
    [anon_sym_AT_AT_ATr] = ACTIONS(319),
    [anon_sym_AT_AT_ATs] = ACTIONS(321),
    [anon_sym_AT_AT_ATst] = ACTIONS(319),
    [anon_sym_AT_AT_ATS] = ACTIONS(319),
    [anon_sym_AT_AT_ATm] = ACTIONS(319),
    [anon_sym_AT_AT_ATM] = ACTIONS(319),
    [anon_sym_AT_AT_ATf] = ACTIONS(321),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATF] = ACTIONS(321),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_AT] = ACTIONS(321),
    [anon_sym_AT_ATdbt] = ACTIONS(321),
    [anon_sym_AT_ATdbta] = ACTIONS(319),
    [anon_sym_AT_ATdbtb] = ACTIONS(319),
    [anon_sym_AT_ATdbts] = ACTIONS(319),
    [anon_sym_AT_AT_DOT] = ACTIONS(319),
    [anon_sym_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_ATk] = ACTIONS(319),
    [anon_sym_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_ATi] = ACTIONS(321),
    [anon_sym_AT_ATiS] = ACTIONS(319),
    [anon_sym_AT_ATf] = ACTIONS(319),
    [anon_sym_AT_ATs_COLON] = ACTIONS(319),
    [anon_sym_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_AT_BANG] = ACTIONS(319),
    [anon_sym_AT_LBRACE] = ACTIONS(319),
    [anon_sym_ATa_COLON] = ACTIONS(319),
    [anon_sym_ATb_COLON] = ACTIONS(319),
    [anon_sym_ATB_COLON] = ACTIONS(319),
    [anon_sym_ATe_COLON] = ACTIONS(319),
    [anon_sym_ATF_COLON] = ACTIONS(319),
    [anon_sym_ATi_COLON] = ACTIONS(319),
    [anon_sym_ATk_COLON] = ACTIONS(319),
    [anon_sym_ATo_COLON] = ACTIONS(319),
    [anon_sym_ATr_COLON] = ACTIONS(319),
    [anon_sym_ATf_COLON] = ACTIONS(319),
    [anon_sym_ATs_COLON] = ACTIONS(319),
    [anon_sym_ATx_COLON] = ACTIONS(319),
    [anon_sym_PIPE_DOT] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_RPAREN] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(321),
    [anon_sym_GT_GT] = ACTIONS(319),
    [sym_html_redirect_operator] = ACTIONS(321),
    [sym_html_append_operator] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(319),
    [sym_arg_identifier] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(319),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_CR] = ACTIONS(319),
    [sym_file_descriptor] = ACTIONS(319),
    [sym__concat] = ACTIONS(323),
  },
  [90] = {
    [ts_builtin_sym_end] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_PIPEH] = ACTIONS(319),
    [anon_sym_PIPET] = ACTIONS(319),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATi] = ACTIONS(319),
    [anon_sym_AT_AT_ATr] = ACTIONS(319),
    [anon_sym_AT_AT_ATs] = ACTIONS(321),
    [anon_sym_AT_AT_ATst] = ACTIONS(319),
    [anon_sym_AT_AT_ATS] = ACTIONS(319),
    [anon_sym_AT_AT_ATm] = ACTIONS(319),
    [anon_sym_AT_AT_ATM] = ACTIONS(319),
    [anon_sym_AT_AT_ATf] = ACTIONS(321),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATF] = ACTIONS(321),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_AT] = ACTIONS(321),
    [anon_sym_AT_ATdbt] = ACTIONS(321),
    [anon_sym_AT_ATdbta] = ACTIONS(319),
    [anon_sym_AT_ATdbtb] = ACTIONS(319),
    [anon_sym_AT_ATdbts] = ACTIONS(319),
    [anon_sym_AT_AT_DOT] = ACTIONS(319),
    [anon_sym_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_ATk] = ACTIONS(319),
    [anon_sym_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_ATi] = ACTIONS(321),
    [anon_sym_AT_ATiS] = ACTIONS(319),
    [anon_sym_AT_ATf] = ACTIONS(319),
    [anon_sym_AT_ATs_COLON] = ACTIONS(319),
    [anon_sym_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_AT_BANG] = ACTIONS(319),
    [anon_sym_AT_LBRACE] = ACTIONS(319),
    [anon_sym_ATa_COLON] = ACTIONS(319),
    [anon_sym_ATb_COLON] = ACTIONS(319),
    [anon_sym_ATB_COLON] = ACTIONS(319),
    [anon_sym_ATe_COLON] = ACTIONS(319),
    [anon_sym_ATF_COLON] = ACTIONS(319),
    [anon_sym_ATi_COLON] = ACTIONS(319),
    [anon_sym_ATk_COLON] = ACTIONS(319),
    [anon_sym_ATo_COLON] = ACTIONS(319),
    [anon_sym_ATr_COLON] = ACTIONS(319),
    [anon_sym_ATf_COLON] = ACTIONS(319),
    [anon_sym_ATs_COLON] = ACTIONS(319),
    [anon_sym_ATx_COLON] = ACTIONS(319),
    [anon_sym_PIPE_DOT] = ACTIONS(319),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_RPAREN] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(321),
    [anon_sym_GT_GT] = ACTIONS(319),
    [sym_html_redirect_operator] = ACTIONS(321),
    [sym_html_append_operator] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(319),
    [sym_arg_identifier] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(319),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_CR] = ACTIONS(319),
    [sym_file_descriptor] = ACTIONS(319),
    [sym__concat] = ACTIONS(319),
  },
  [91] = {
    [ts_builtin_sym_end] = ACTIONS(326),
    [anon_sym_DQUOTE] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(326),
    [anon_sym_PIPE] = ACTIONS(328),
    [anon_sym_PIPEH] = ACTIONS(326),
    [anon_sym_PIPET] = ACTIONS(326),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(326),
    [anon_sym_AT_AT_ATb] = ACTIONS(326),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(326),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(326),
    [anon_sym_AT_AT_ATi] = ACTIONS(326),
    [anon_sym_AT_AT_ATr] = ACTIONS(326),
    [anon_sym_AT_AT_ATs] = ACTIONS(328),
    [anon_sym_AT_AT_ATst] = ACTIONS(326),
    [anon_sym_AT_AT_ATS] = ACTIONS(326),
    [anon_sym_AT_AT_ATm] = ACTIONS(326),
    [anon_sym_AT_AT_ATM] = ACTIONS(326),
    [anon_sym_AT_AT_ATf] = ACTIONS(328),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(326),
    [anon_sym_AT_AT_ATF] = ACTIONS(328),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(326),
    [anon_sym_AT_AT_ATt] = ACTIONS(326),
    [anon_sym_AT_AT] = ACTIONS(328),
    [anon_sym_AT_ATdbt] = ACTIONS(328),
    [anon_sym_AT_ATdbta] = ACTIONS(326),
    [anon_sym_AT_ATdbtb] = ACTIONS(326),
    [anon_sym_AT_ATdbts] = ACTIONS(326),
    [anon_sym_AT_AT_DOT] = ACTIONS(326),
    [anon_sym_AT_AT_EQ] = ACTIONS(326),
    [anon_sym_AT_ATk] = ACTIONS(326),
    [anon_sym_AT_ATt] = ACTIONS(326),
    [anon_sym_AT_ATb] = ACTIONS(326),
    [anon_sym_AT_ATi] = ACTIONS(328),
    [anon_sym_AT_ATiS] = ACTIONS(326),
    [anon_sym_AT_ATf] = ACTIONS(326),
    [anon_sym_AT_ATs_COLON] = ACTIONS(326),
    [anon_sym_AT_ATc_COLON] = ACTIONS(326),
    [anon_sym_AT] = ACTIONS(328),
    [anon_sym_AT_BANG] = ACTIONS(326),
    [anon_sym_AT_LBRACE] = ACTIONS(326),
    [anon_sym_ATa_COLON] = ACTIONS(326),
    [anon_sym_ATb_COLON] = ACTIONS(326),
    [anon_sym_ATB_COLON] = ACTIONS(326),
    [anon_sym_ATe_COLON] = ACTIONS(326),
    [anon_sym_ATF_COLON] = ACTIONS(326),
    [anon_sym_ATi_COLON] = ACTIONS(326),
    [anon_sym_ATk_COLON] = ACTIONS(326),
    [anon_sym_ATo_COLON] = ACTIONS(326),
    [anon_sym_ATr_COLON] = ACTIONS(326),
    [anon_sym_ATf_COLON] = ACTIONS(326),
    [anon_sym_ATs_COLON] = ACTIONS(326),
    [anon_sym_ATx_COLON] = ACTIONS(326),
    [anon_sym_PIPE_DOT] = ACTIONS(326),
    [anon_sym_LPAREN] = ACTIONS(326),
    [anon_sym_RPAREN] = ACTIONS(326),
    [anon_sym_SEMI] = ACTIONS(326),
    [anon_sym_GT] = ACTIONS(328),
    [anon_sym_GT_GT] = ACTIONS(326),
    [sym_html_redirect_operator] = ACTIONS(328),
    [sym_html_append_operator] = ACTIONS(326),
    [anon_sym_COMMA] = ACTIONS(326),
    [sym_arg_identifier] = ACTIONS(328),
    [anon_sym_SQUOTE] = ACTIONS(326),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(326),
    [anon_sym_BQUOTE] = ACTIONS(326),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(326),
    [anon_sym_CR] = ACTIONS(326),
    [sym_file_descriptor] = ACTIONS(326),
    [sym__concat] = ACTIONS(326),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(330),
    [anon_sym_DQUOTE] = ACTIONS(330),
    [anon_sym_TILDE] = ACTIONS(330),
    [anon_sym_PIPE] = ACTIONS(332),
    [anon_sym_PIPEH] = ACTIONS(330),
    [anon_sym_PIPET] = ACTIONS(330),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(330),
    [anon_sym_AT_AT_ATb] = ACTIONS(330),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATi] = ACTIONS(330),
    [anon_sym_AT_AT_ATr] = ACTIONS(330),
    [anon_sym_AT_AT_ATs] = ACTIONS(332),
    [anon_sym_AT_AT_ATst] = ACTIONS(330),
    [anon_sym_AT_AT_ATS] = ACTIONS(330),
    [anon_sym_AT_AT_ATm] = ACTIONS(330),
    [anon_sym_AT_AT_ATM] = ACTIONS(330),
    [anon_sym_AT_AT_ATf] = ACTIONS(332),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATF] = ACTIONS(332),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATt] = ACTIONS(330),
    [anon_sym_AT_AT] = ACTIONS(332),
    [anon_sym_AT_ATdbt] = ACTIONS(332),
    [anon_sym_AT_ATdbta] = ACTIONS(330),
    [anon_sym_AT_ATdbtb] = ACTIONS(330),
    [anon_sym_AT_ATdbts] = ACTIONS(330),
    [anon_sym_AT_AT_DOT] = ACTIONS(330),
    [anon_sym_AT_AT_EQ] = ACTIONS(330),
    [anon_sym_AT_ATk] = ACTIONS(330),
    [anon_sym_AT_ATt] = ACTIONS(330),
    [anon_sym_AT_ATb] = ACTIONS(330),
    [anon_sym_AT_ATi] = ACTIONS(332),
    [anon_sym_AT_ATiS] = ACTIONS(330),
    [anon_sym_AT_ATf] = ACTIONS(330),
    [anon_sym_AT_ATs_COLON] = ACTIONS(330),
    [anon_sym_AT_ATc_COLON] = ACTIONS(330),
    [anon_sym_AT] = ACTIONS(332),
    [anon_sym_AT_BANG] = ACTIONS(330),
    [anon_sym_AT_LBRACE] = ACTIONS(330),
    [anon_sym_ATa_COLON] = ACTIONS(330),
    [anon_sym_ATb_COLON] = ACTIONS(330),
    [anon_sym_ATB_COLON] = ACTIONS(330),
    [anon_sym_ATe_COLON] = ACTIONS(330),
    [anon_sym_ATF_COLON] = ACTIONS(330),
    [anon_sym_ATi_COLON] = ACTIONS(330),
    [anon_sym_ATk_COLON] = ACTIONS(330),
    [anon_sym_ATo_COLON] = ACTIONS(330),
    [anon_sym_ATr_COLON] = ACTIONS(330),
    [anon_sym_ATf_COLON] = ACTIONS(330),
    [anon_sym_ATs_COLON] = ACTIONS(330),
    [anon_sym_ATx_COLON] = ACTIONS(330),
    [anon_sym_PIPE_DOT] = ACTIONS(330),
    [anon_sym_LPAREN] = ACTIONS(330),
    [anon_sym_RPAREN] = ACTIONS(330),
    [anon_sym_SEMI] = ACTIONS(330),
    [anon_sym_GT] = ACTIONS(332),
    [anon_sym_GT_GT] = ACTIONS(330),
    [sym_html_redirect_operator] = ACTIONS(332),
    [sym_html_append_operator] = ACTIONS(330),
    [anon_sym_COMMA] = ACTIONS(330),
    [sym_arg_identifier] = ACTIONS(332),
    [anon_sym_SQUOTE] = ACTIONS(330),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(330),
    [anon_sym_BQUOTE] = ACTIONS(330),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(330),
    [anon_sym_CR] = ACTIONS(330),
    [sym_file_descriptor] = ACTIONS(330),
    [sym__concat] = ACTIONS(330),
  },
  [93] = {
    [ts_builtin_sym_end] = ACTIONS(334),
    [anon_sym_DQUOTE] = ACTIONS(334),
    [anon_sym_TILDE] = ACTIONS(334),
    [anon_sym_PIPE] = ACTIONS(336),
    [anon_sym_PIPEH] = ACTIONS(334),
    [anon_sym_PIPET] = ACTIONS(334),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(334),
    [anon_sym_AT_AT_ATb] = ACTIONS(334),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(334),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(334),
    [anon_sym_AT_AT_ATi] = ACTIONS(334),
    [anon_sym_AT_AT_ATr] = ACTIONS(334),
    [anon_sym_AT_AT_ATs] = ACTIONS(336),
    [anon_sym_AT_AT_ATst] = ACTIONS(334),
    [anon_sym_AT_AT_ATS] = ACTIONS(334),
    [anon_sym_AT_AT_ATm] = ACTIONS(334),
    [anon_sym_AT_AT_ATM] = ACTIONS(334),
    [anon_sym_AT_AT_ATf] = ACTIONS(336),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(334),
    [anon_sym_AT_AT_ATF] = ACTIONS(336),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(334),
    [anon_sym_AT_AT_ATt] = ACTIONS(334),
    [anon_sym_AT_AT] = ACTIONS(336),
    [anon_sym_AT_ATdbt] = ACTIONS(336),
    [anon_sym_AT_ATdbta] = ACTIONS(334),
    [anon_sym_AT_ATdbtb] = ACTIONS(334),
    [anon_sym_AT_ATdbts] = ACTIONS(334),
    [anon_sym_AT_AT_DOT] = ACTIONS(334),
    [anon_sym_AT_AT_EQ] = ACTIONS(334),
    [anon_sym_AT_ATk] = ACTIONS(334),
    [anon_sym_AT_ATt] = ACTIONS(334),
    [anon_sym_AT_ATb] = ACTIONS(334),
    [anon_sym_AT_ATi] = ACTIONS(336),
    [anon_sym_AT_ATiS] = ACTIONS(334),
    [anon_sym_AT_ATf] = ACTIONS(334),
    [anon_sym_AT_ATs_COLON] = ACTIONS(334),
    [anon_sym_AT_ATc_COLON] = ACTIONS(334),
    [anon_sym_AT] = ACTIONS(336),
    [anon_sym_AT_BANG] = ACTIONS(334),
    [anon_sym_AT_LBRACE] = ACTIONS(334),
    [anon_sym_ATa_COLON] = ACTIONS(334),
    [anon_sym_ATb_COLON] = ACTIONS(334),
    [anon_sym_ATB_COLON] = ACTIONS(334),
    [anon_sym_ATe_COLON] = ACTIONS(334),
    [anon_sym_ATF_COLON] = ACTIONS(334),
    [anon_sym_ATi_COLON] = ACTIONS(334),
    [anon_sym_ATk_COLON] = ACTIONS(334),
    [anon_sym_ATo_COLON] = ACTIONS(334),
    [anon_sym_ATr_COLON] = ACTIONS(334),
    [anon_sym_ATf_COLON] = ACTIONS(334),
    [anon_sym_ATs_COLON] = ACTIONS(334),
    [anon_sym_ATx_COLON] = ACTIONS(334),
    [anon_sym_PIPE_DOT] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(334),
    [anon_sym_RPAREN] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(334),
    [anon_sym_GT] = ACTIONS(336),
    [anon_sym_GT_GT] = ACTIONS(334),
    [sym_html_redirect_operator] = ACTIONS(336),
    [sym_html_append_operator] = ACTIONS(334),
    [anon_sym_COMMA] = ACTIONS(334),
    [sym_arg_identifier] = ACTIONS(336),
    [anon_sym_SQUOTE] = ACTIONS(334),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(334),
    [anon_sym_BQUOTE] = ACTIONS(334),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(334),
    [anon_sym_CR] = ACTIONS(334),
    [sym_file_descriptor] = ACTIONS(334),
    [sym__concat] = ACTIONS(334),
  },
  [94] = {
    [ts_builtin_sym_end] = ACTIONS(338),
    [anon_sym_DQUOTE] = ACTIONS(338),
    [anon_sym_TILDE] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(340),
    [anon_sym_PIPEH] = ACTIONS(338),
    [anon_sym_PIPET] = ACTIONS(338),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(338),
    [anon_sym_AT_AT_ATb] = ACTIONS(338),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATi] = ACTIONS(338),
    [anon_sym_AT_AT_ATr] = ACTIONS(338),
    [anon_sym_AT_AT_ATs] = ACTIONS(340),
    [anon_sym_AT_AT_ATst] = ACTIONS(338),
    [anon_sym_AT_AT_ATS] = ACTIONS(338),
    [anon_sym_AT_AT_ATm] = ACTIONS(338),
    [anon_sym_AT_AT_ATM] = ACTIONS(338),
    [anon_sym_AT_AT_ATf] = ACTIONS(340),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATF] = ACTIONS(340),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATt] = ACTIONS(338),
    [anon_sym_AT_AT] = ACTIONS(340),
    [anon_sym_AT_ATdbt] = ACTIONS(340),
    [anon_sym_AT_ATdbta] = ACTIONS(338),
    [anon_sym_AT_ATdbtb] = ACTIONS(338),
    [anon_sym_AT_ATdbts] = ACTIONS(338),
    [anon_sym_AT_AT_DOT] = ACTIONS(338),
    [anon_sym_AT_AT_EQ] = ACTIONS(338),
    [anon_sym_AT_ATk] = ACTIONS(338),
    [anon_sym_AT_ATt] = ACTIONS(338),
    [anon_sym_AT_ATb] = ACTIONS(338),
    [anon_sym_AT_ATi] = ACTIONS(340),
    [anon_sym_AT_ATiS] = ACTIONS(338),
    [anon_sym_AT_ATf] = ACTIONS(338),
    [anon_sym_AT_ATs_COLON] = ACTIONS(338),
    [anon_sym_AT_ATc_COLON] = ACTIONS(338),
    [anon_sym_AT] = ACTIONS(340),
    [anon_sym_AT_BANG] = ACTIONS(338),
    [anon_sym_AT_LBRACE] = ACTIONS(338),
    [anon_sym_ATa_COLON] = ACTIONS(338),
    [anon_sym_ATb_COLON] = ACTIONS(338),
    [anon_sym_ATB_COLON] = ACTIONS(338),
    [anon_sym_ATe_COLON] = ACTIONS(338),
    [anon_sym_ATF_COLON] = ACTIONS(338),
    [anon_sym_ATi_COLON] = ACTIONS(338),
    [anon_sym_ATk_COLON] = ACTIONS(338),
    [anon_sym_ATo_COLON] = ACTIONS(338),
    [anon_sym_ATr_COLON] = ACTIONS(338),
    [anon_sym_ATf_COLON] = ACTIONS(338),
    [anon_sym_ATs_COLON] = ACTIONS(338),
    [anon_sym_ATx_COLON] = ACTIONS(338),
    [anon_sym_PIPE_DOT] = ACTIONS(338),
    [anon_sym_LPAREN] = ACTIONS(338),
    [anon_sym_RPAREN] = ACTIONS(338),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_GT] = ACTIONS(340),
    [anon_sym_GT_GT] = ACTIONS(338),
    [sym_html_redirect_operator] = ACTIONS(340),
    [sym_html_append_operator] = ACTIONS(338),
    [anon_sym_COMMA] = ACTIONS(338),
    [sym_arg_identifier] = ACTIONS(340),
    [anon_sym_SQUOTE] = ACTIONS(338),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(338),
    [anon_sym_BQUOTE] = ACTIONS(338),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(338),
    [anon_sym_CR] = ACTIONS(338),
    [sym_file_descriptor] = ACTIONS(338),
    [sym__concat] = ACTIONS(338),
  },
  [95] = {
    [ts_builtin_sym_end] = ACTIONS(342),
    [anon_sym_DQUOTE] = ACTIONS(342),
    [anon_sym_TILDE] = ACTIONS(342),
    [anon_sym_PIPE] = ACTIONS(344),
    [anon_sym_PIPEH] = ACTIONS(342),
    [anon_sym_PIPET] = ACTIONS(342),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(342),
    [anon_sym_AT_AT_ATb] = ACTIONS(342),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATi] = ACTIONS(342),
    [anon_sym_AT_AT_ATr] = ACTIONS(342),
    [anon_sym_AT_AT_ATs] = ACTIONS(344),
    [anon_sym_AT_AT_ATst] = ACTIONS(342),
    [anon_sym_AT_AT_ATS] = ACTIONS(342),
    [anon_sym_AT_AT_ATm] = ACTIONS(342),
    [anon_sym_AT_AT_ATM] = ACTIONS(342),
    [anon_sym_AT_AT_ATf] = ACTIONS(344),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATF] = ACTIONS(344),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATt] = ACTIONS(342),
    [anon_sym_AT_AT] = ACTIONS(344),
    [anon_sym_AT_ATdbt] = ACTIONS(344),
    [anon_sym_AT_ATdbta] = ACTIONS(342),
    [anon_sym_AT_ATdbtb] = ACTIONS(342),
    [anon_sym_AT_ATdbts] = ACTIONS(342),
    [anon_sym_AT_AT_DOT] = ACTIONS(342),
    [anon_sym_AT_AT_EQ] = ACTIONS(342),
    [anon_sym_AT_ATk] = ACTIONS(342),
    [anon_sym_AT_ATt] = ACTIONS(342),
    [anon_sym_AT_ATb] = ACTIONS(342),
    [anon_sym_AT_ATi] = ACTIONS(344),
    [anon_sym_AT_ATiS] = ACTIONS(342),
    [anon_sym_AT_ATf] = ACTIONS(342),
    [anon_sym_AT_ATs_COLON] = ACTIONS(342),
    [anon_sym_AT_ATc_COLON] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_AT_BANG] = ACTIONS(342),
    [anon_sym_AT_LBRACE] = ACTIONS(342),
    [anon_sym_ATa_COLON] = ACTIONS(342),
    [anon_sym_ATb_COLON] = ACTIONS(342),
    [anon_sym_ATB_COLON] = ACTIONS(342),
    [anon_sym_ATe_COLON] = ACTIONS(342),
    [anon_sym_ATF_COLON] = ACTIONS(342),
    [anon_sym_ATi_COLON] = ACTIONS(342),
    [anon_sym_ATk_COLON] = ACTIONS(342),
    [anon_sym_ATo_COLON] = ACTIONS(342),
    [anon_sym_ATr_COLON] = ACTIONS(342),
    [anon_sym_ATf_COLON] = ACTIONS(342),
    [anon_sym_ATs_COLON] = ACTIONS(342),
    [anon_sym_ATx_COLON] = ACTIONS(342),
    [anon_sym_PIPE_DOT] = ACTIONS(342),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(342),
    [anon_sym_SEMI] = ACTIONS(342),
    [anon_sym_GT] = ACTIONS(344),
    [anon_sym_GT_GT] = ACTIONS(342),
    [sym_html_redirect_operator] = ACTIONS(344),
    [sym_html_append_operator] = ACTIONS(342),
    [anon_sym_COMMA] = ACTIONS(342),
    [sym_arg_identifier] = ACTIONS(344),
    [anon_sym_SQUOTE] = ACTIONS(342),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(342),
    [anon_sym_BQUOTE] = ACTIONS(342),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(342),
    [anon_sym_CR] = ACTIONS(342),
    [sym_file_descriptor] = ACTIONS(342),
    [sym__concat] = ACTIONS(342),
  },
  [96] = {
    [ts_builtin_sym_end] = ACTIONS(346),
    [anon_sym_DQUOTE] = ACTIONS(346),
    [anon_sym_TILDE] = ACTIONS(346),
    [anon_sym_PIPE] = ACTIONS(348),
    [anon_sym_PIPEH] = ACTIONS(346),
    [anon_sym_PIPET] = ACTIONS(346),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(346),
    [anon_sym_AT_AT_ATb] = ACTIONS(346),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATi] = ACTIONS(346),
    [anon_sym_AT_AT_ATr] = ACTIONS(346),
    [anon_sym_AT_AT_ATs] = ACTIONS(348),
    [anon_sym_AT_AT_ATst] = ACTIONS(346),
    [anon_sym_AT_AT_ATS] = ACTIONS(346),
    [anon_sym_AT_AT_ATm] = ACTIONS(346),
    [anon_sym_AT_AT_ATM] = ACTIONS(346),
    [anon_sym_AT_AT_ATf] = ACTIONS(348),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATF] = ACTIONS(348),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATt] = ACTIONS(346),
    [anon_sym_AT_AT] = ACTIONS(348),
    [anon_sym_AT_ATdbt] = ACTIONS(348),
    [anon_sym_AT_ATdbta] = ACTIONS(346),
    [anon_sym_AT_ATdbtb] = ACTIONS(346),
    [anon_sym_AT_ATdbts] = ACTIONS(346),
    [anon_sym_AT_AT_DOT] = ACTIONS(346),
    [anon_sym_AT_AT_EQ] = ACTIONS(346),
    [anon_sym_AT_ATk] = ACTIONS(346),
    [anon_sym_AT_ATt] = ACTIONS(346),
    [anon_sym_AT_ATb] = ACTIONS(346),
    [anon_sym_AT_ATi] = ACTIONS(348),
    [anon_sym_AT_ATiS] = ACTIONS(346),
    [anon_sym_AT_ATf] = ACTIONS(346),
    [anon_sym_AT_ATs_COLON] = ACTIONS(346),
    [anon_sym_AT_ATc_COLON] = ACTIONS(346),
    [anon_sym_AT] = ACTIONS(348),
    [anon_sym_AT_BANG] = ACTIONS(346),
    [anon_sym_AT_LBRACE] = ACTIONS(346),
    [anon_sym_ATa_COLON] = ACTIONS(346),
    [anon_sym_ATb_COLON] = ACTIONS(346),
    [anon_sym_ATB_COLON] = ACTIONS(346),
    [anon_sym_ATe_COLON] = ACTIONS(346),
    [anon_sym_ATF_COLON] = ACTIONS(346),
    [anon_sym_ATi_COLON] = ACTIONS(346),
    [anon_sym_ATk_COLON] = ACTIONS(346),
    [anon_sym_ATo_COLON] = ACTIONS(346),
    [anon_sym_ATr_COLON] = ACTIONS(346),
    [anon_sym_ATf_COLON] = ACTIONS(346),
    [anon_sym_ATs_COLON] = ACTIONS(346),
    [anon_sym_ATx_COLON] = ACTIONS(346),
    [anon_sym_PIPE_DOT] = ACTIONS(346),
    [anon_sym_LPAREN] = ACTIONS(346),
    [anon_sym_RPAREN] = ACTIONS(346),
    [anon_sym_SEMI] = ACTIONS(346),
    [anon_sym_GT] = ACTIONS(348),
    [anon_sym_GT_GT] = ACTIONS(346),
    [sym_html_redirect_operator] = ACTIONS(348),
    [sym_html_append_operator] = ACTIONS(346),
    [anon_sym_COMMA] = ACTIONS(346),
    [sym_arg_identifier] = ACTIONS(348),
    [anon_sym_SQUOTE] = ACTIONS(346),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(346),
    [anon_sym_BQUOTE] = ACTIONS(346),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(346),
    [anon_sym_CR] = ACTIONS(346),
    [sym_file_descriptor] = ACTIONS(346),
    [sym__concat] = ACTIONS(346),
  },
  [97] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_DQUOTE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_COMMA] = ACTIONS(350),
    [sym_arg_identifier] = ACTIONS(352),
    [anon_sym_SQUOTE] = ACTIONS(350),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__concat] = ACTIONS(350),
  },
  [98] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_DQUOTE] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_COMMA] = ACTIONS(350),
    [sym_arg_identifier] = ACTIONS(352),
    [anon_sym_SQUOTE] = ACTIONS(350),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__concat] = ACTIONS(350),
  },
  [99] = {
    [ts_builtin_sym_end] = ACTIONS(354),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_TILDE] = ACTIONS(354),
    [anon_sym_PIPE] = ACTIONS(356),
    [anon_sym_PIPEH] = ACTIONS(354),
    [anon_sym_PIPET] = ACTIONS(354),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(354),
    [anon_sym_AT_AT_ATb] = ACTIONS(354),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(354),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(354),
    [anon_sym_AT_AT_ATi] = ACTIONS(354),
    [anon_sym_AT_AT_ATr] = ACTIONS(354),
    [anon_sym_AT_AT_ATs] = ACTIONS(356),
    [anon_sym_AT_AT_ATst] = ACTIONS(354),
    [anon_sym_AT_AT_ATS] = ACTIONS(354),
    [anon_sym_AT_AT_ATm] = ACTIONS(354),
    [anon_sym_AT_AT_ATM] = ACTIONS(354),
    [anon_sym_AT_AT_ATf] = ACTIONS(356),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(354),
    [anon_sym_AT_AT_ATF] = ACTIONS(356),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(354),
    [anon_sym_AT_AT_ATt] = ACTIONS(354),
    [anon_sym_AT_AT] = ACTIONS(356),
    [anon_sym_AT_ATdbt] = ACTIONS(356),
    [anon_sym_AT_ATdbta] = ACTIONS(354),
    [anon_sym_AT_ATdbtb] = ACTIONS(354),
    [anon_sym_AT_ATdbts] = ACTIONS(354),
    [anon_sym_AT_AT_DOT] = ACTIONS(354),
    [anon_sym_AT_AT_EQ] = ACTIONS(354),
    [anon_sym_AT_ATk] = ACTIONS(354),
    [anon_sym_AT_ATt] = ACTIONS(354),
    [anon_sym_AT_ATb] = ACTIONS(354),
    [anon_sym_AT_ATi] = ACTIONS(356),
    [anon_sym_AT_ATiS] = ACTIONS(354),
    [anon_sym_AT_ATf] = ACTIONS(354),
    [anon_sym_AT_ATs_COLON] = ACTIONS(354),
    [anon_sym_AT_ATc_COLON] = ACTIONS(354),
    [anon_sym_AT] = ACTIONS(356),
    [anon_sym_AT_BANG] = ACTIONS(354),
    [anon_sym_AT_LBRACE] = ACTIONS(354),
    [anon_sym_ATa_COLON] = ACTIONS(354),
    [anon_sym_ATb_COLON] = ACTIONS(354),
    [anon_sym_ATB_COLON] = ACTIONS(354),
    [anon_sym_ATe_COLON] = ACTIONS(354),
    [anon_sym_ATF_COLON] = ACTIONS(354),
    [anon_sym_ATi_COLON] = ACTIONS(354),
    [anon_sym_ATk_COLON] = ACTIONS(354),
    [anon_sym_ATo_COLON] = ACTIONS(354),
    [anon_sym_ATr_COLON] = ACTIONS(354),
    [anon_sym_ATf_COLON] = ACTIONS(354),
    [anon_sym_ATs_COLON] = ACTIONS(354),
    [anon_sym_ATx_COLON] = ACTIONS(354),
    [anon_sym_PIPE_DOT] = ACTIONS(354),
    [anon_sym_LPAREN] = ACTIONS(354),
    [anon_sym_RPAREN] = ACTIONS(354),
    [anon_sym_SEMI] = ACTIONS(354),
    [anon_sym_GT] = ACTIONS(356),
    [anon_sym_GT_GT] = ACTIONS(354),
    [sym_html_redirect_operator] = ACTIONS(356),
    [sym_html_append_operator] = ACTIONS(354),
    [anon_sym_COMMA] = ACTIONS(354),
    [sym_arg_identifier] = ACTIONS(356),
    [anon_sym_SQUOTE] = ACTIONS(354),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(354),
    [anon_sym_BQUOTE] = ACTIONS(354),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(354),
    [anon_sym_CR] = ACTIONS(354),
    [sym_file_descriptor] = ACTIONS(354),
  },
  [100] = {
    [ts_builtin_sym_end] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(246),
    [anon_sym_TILDE] = ACTIONS(246),
    [anon_sym_PIPE] = ACTIONS(251),
    [anon_sym_PIPEH] = ACTIONS(246),
    [anon_sym_PIPET] = ACTIONS(246),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(246),
    [anon_sym_AT_AT_ATb] = ACTIONS(246),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(246),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(246),
    [anon_sym_AT_AT_ATi] = ACTIONS(246),
    [anon_sym_AT_AT_ATr] = ACTIONS(246),
    [anon_sym_AT_AT_ATs] = ACTIONS(251),
    [anon_sym_AT_AT_ATst] = ACTIONS(246),
    [anon_sym_AT_AT_ATS] = ACTIONS(246),
    [anon_sym_AT_AT_ATm] = ACTIONS(246),
    [anon_sym_AT_AT_ATM] = ACTIONS(246),
    [anon_sym_AT_AT_ATf] = ACTIONS(251),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(246),
    [anon_sym_AT_AT_ATF] = ACTIONS(251),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(246),
    [anon_sym_AT_AT_ATt] = ACTIONS(246),
    [anon_sym_AT_AT] = ACTIONS(251),
    [anon_sym_AT_ATdbt] = ACTIONS(251),
    [anon_sym_AT_ATdbta] = ACTIONS(246),
    [anon_sym_AT_ATdbtb] = ACTIONS(246),
    [anon_sym_AT_ATdbts] = ACTIONS(246),
    [anon_sym_AT_AT_DOT] = ACTIONS(246),
    [anon_sym_AT_AT_EQ] = ACTIONS(246),
    [anon_sym_AT_ATk] = ACTIONS(246),
    [anon_sym_AT_ATt] = ACTIONS(246),
    [anon_sym_AT_ATb] = ACTIONS(246),
    [anon_sym_AT_ATi] = ACTIONS(251),
    [anon_sym_AT_ATiS] = ACTIONS(246),
    [anon_sym_AT_ATf] = ACTIONS(246),
    [anon_sym_AT_ATs_COLON] = ACTIONS(246),
    [anon_sym_AT_ATc_COLON] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(251),
    [anon_sym_AT_BANG] = ACTIONS(246),
    [anon_sym_AT_LBRACE] = ACTIONS(246),
    [anon_sym_ATa_COLON] = ACTIONS(246),
    [anon_sym_ATb_COLON] = ACTIONS(246),
    [anon_sym_ATB_COLON] = ACTIONS(246),
    [anon_sym_ATe_COLON] = ACTIONS(246),
    [anon_sym_ATF_COLON] = ACTIONS(246),
    [anon_sym_ATi_COLON] = ACTIONS(246),
    [anon_sym_ATk_COLON] = ACTIONS(246),
    [anon_sym_ATo_COLON] = ACTIONS(246),
    [anon_sym_ATr_COLON] = ACTIONS(246),
    [anon_sym_ATf_COLON] = ACTIONS(246),
    [anon_sym_ATs_COLON] = ACTIONS(246),
    [anon_sym_ATx_COLON] = ACTIONS(246),
    [anon_sym_PIPE_DOT] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(246),
    [anon_sym_RPAREN] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(246),
    [anon_sym_GT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(246),
    [sym_html_redirect_operator] = ACTIONS(251),
    [sym_html_append_operator] = ACTIONS(246),
    [anon_sym_COMMA] = ACTIONS(246),
    [sym_arg_identifier] = ACTIONS(251),
    [anon_sym_SQUOTE] = ACTIONS(246),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(246),
    [anon_sym_BQUOTE] = ACTIONS(246),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(246),
    [anon_sym_CR] = ACTIONS(246),
    [sym_file_descriptor] = ACTIONS(246),
  },
  [101] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(103),
    [ts_builtin_sym_end] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_PIPEH] = ACTIONS(358),
    [anon_sym_PIPET] = ACTIONS(358),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATi] = ACTIONS(358),
    [anon_sym_AT_AT_ATr] = ACTIONS(358),
    [anon_sym_AT_AT_ATs] = ACTIONS(360),
    [anon_sym_AT_AT_ATst] = ACTIONS(358),
    [anon_sym_AT_AT_ATS] = ACTIONS(358),
    [anon_sym_AT_AT_ATm] = ACTIONS(358),
    [anon_sym_AT_AT_ATM] = ACTIONS(358),
    [anon_sym_AT_AT_ATf] = ACTIONS(360),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATF] = ACTIONS(360),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_AT] = ACTIONS(360),
    [anon_sym_AT_ATdbt] = ACTIONS(360),
    [anon_sym_AT_ATdbta] = ACTIONS(358),
    [anon_sym_AT_ATdbtb] = ACTIONS(358),
    [anon_sym_AT_ATdbts] = ACTIONS(358),
    [anon_sym_AT_AT_DOT] = ACTIONS(358),
    [anon_sym_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_ATk] = ACTIONS(358),
    [anon_sym_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_ATi] = ACTIONS(360),
    [anon_sym_AT_ATiS] = ACTIONS(358),
    [anon_sym_AT_ATf] = ACTIONS(358),
    [anon_sym_AT_ATs_COLON] = ACTIONS(358),
    [anon_sym_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_AT_BANG] = ACTIONS(358),
    [anon_sym_AT_LBRACE] = ACTIONS(358),
    [anon_sym_ATa_COLON] = ACTIONS(358),
    [anon_sym_ATb_COLON] = ACTIONS(358),
    [anon_sym_ATB_COLON] = ACTIONS(358),
    [anon_sym_ATe_COLON] = ACTIONS(358),
    [anon_sym_ATF_COLON] = ACTIONS(358),
    [anon_sym_ATi_COLON] = ACTIONS(358),
    [anon_sym_ATk_COLON] = ACTIONS(358),
    [anon_sym_ATo_COLON] = ACTIONS(358),
    [anon_sym_ATr_COLON] = ACTIONS(358),
    [anon_sym_ATf_COLON] = ACTIONS(358),
    [anon_sym_ATs_COLON] = ACTIONS(358),
    [anon_sym_ATx_COLON] = ACTIONS(358),
    [anon_sym_PIPE_DOT] = ACTIONS(358),
    [anon_sym_EQ] = ACTIONS(360),
    [anon_sym_LPAREN] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [sym_pf_arg_identifier] = ACTIONS(360),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(358),
    [sym_html_redirect_operator] = ACTIONS(360),
    [sym_html_append_operator] = ACTIONS(358),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(358),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(358),
    [anon_sym_CR] = ACTIONS(358),
    [sym_file_descriptor] = ACTIONS(358),
    [sym__concat_pf_dot] = ACTIONS(358),
  },
  [102] = {
    [ts_builtin_sym_end] = ACTIONS(315),
    [anon_sym_DQUOTE] = ACTIONS(315),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_PIPE] = ACTIONS(317),
    [anon_sym_PIPEH] = ACTIONS(315),
    [anon_sym_PIPET] = ACTIONS(315),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(315),
    [anon_sym_AT_AT_ATb] = ACTIONS(315),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATi] = ACTIONS(315),
    [anon_sym_AT_AT_ATr] = ACTIONS(315),
    [anon_sym_AT_AT_ATs] = ACTIONS(317),
    [anon_sym_AT_AT_ATst] = ACTIONS(315),
    [anon_sym_AT_AT_ATS] = ACTIONS(315),
    [anon_sym_AT_AT_ATm] = ACTIONS(315),
    [anon_sym_AT_AT_ATM] = ACTIONS(315),
    [anon_sym_AT_AT_ATf] = ACTIONS(317),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATF] = ACTIONS(317),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATt] = ACTIONS(315),
    [anon_sym_AT_AT] = ACTIONS(317),
    [anon_sym_AT_ATdbt] = ACTIONS(317),
    [anon_sym_AT_ATdbta] = ACTIONS(315),
    [anon_sym_AT_ATdbtb] = ACTIONS(315),
    [anon_sym_AT_ATdbts] = ACTIONS(315),
    [anon_sym_AT_AT_DOT] = ACTIONS(315),
    [anon_sym_AT_AT_EQ] = ACTIONS(315),
    [anon_sym_AT_ATk] = ACTIONS(315),
    [anon_sym_AT_ATt] = ACTIONS(315),
    [anon_sym_AT_ATb] = ACTIONS(315),
    [anon_sym_AT_ATi] = ACTIONS(317),
    [anon_sym_AT_ATiS] = ACTIONS(315),
    [anon_sym_AT_ATf] = ACTIONS(315),
    [anon_sym_AT_ATs_COLON] = ACTIONS(315),
    [anon_sym_AT_ATc_COLON] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_AT_BANG] = ACTIONS(315),
    [anon_sym_AT_LBRACE] = ACTIONS(315),
    [anon_sym_ATa_COLON] = ACTIONS(315),
    [anon_sym_ATb_COLON] = ACTIONS(315),
    [anon_sym_ATB_COLON] = ACTIONS(315),
    [anon_sym_ATe_COLON] = ACTIONS(315),
    [anon_sym_ATF_COLON] = ACTIONS(315),
    [anon_sym_ATi_COLON] = ACTIONS(315),
    [anon_sym_ATk_COLON] = ACTIONS(315),
    [anon_sym_ATo_COLON] = ACTIONS(315),
    [anon_sym_ATr_COLON] = ACTIONS(315),
    [anon_sym_ATf_COLON] = ACTIONS(315),
    [anon_sym_ATs_COLON] = ACTIONS(315),
    [anon_sym_ATx_COLON] = ACTIONS(315),
    [anon_sym_PIPE_DOT] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(315),
    [anon_sym_RPAREN] = ACTIONS(315),
    [anon_sym_SEMI] = ACTIONS(315),
    [anon_sym_GT] = ACTIONS(317),
    [anon_sym_GT_GT] = ACTIONS(315),
    [sym_html_redirect_operator] = ACTIONS(317),
    [sym_html_append_operator] = ACTIONS(315),
    [anon_sym_COMMA] = ACTIONS(315),
    [sym_arg_identifier] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(315),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(315),
    [anon_sym_BQUOTE] = ACTIONS(315),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(315),
    [anon_sym_CR] = ACTIONS(315),
    [sym_file_descriptor] = ACTIONS(315),
  },
  [103] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(105),
    [ts_builtin_sym_end] = ACTIONS(362),
    [anon_sym_TILDE] = ACTIONS(362),
    [anon_sym_PIPE] = ACTIONS(364),
    [anon_sym_PIPEH] = ACTIONS(362),
    [anon_sym_PIPET] = ACTIONS(362),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(362),
    [anon_sym_AT_AT_ATb] = ACTIONS(362),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(362),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(362),
    [anon_sym_AT_AT_ATi] = ACTIONS(362),
    [anon_sym_AT_AT_ATr] = ACTIONS(362),
    [anon_sym_AT_AT_ATs] = ACTIONS(364),
    [anon_sym_AT_AT_ATst] = ACTIONS(362),
    [anon_sym_AT_AT_ATS] = ACTIONS(362),
    [anon_sym_AT_AT_ATm] = ACTIONS(362),
    [anon_sym_AT_AT_ATM] = ACTIONS(362),
    [anon_sym_AT_AT_ATf] = ACTIONS(364),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(362),
    [anon_sym_AT_AT_ATF] = ACTIONS(364),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(362),
    [anon_sym_AT_AT_ATt] = ACTIONS(362),
    [anon_sym_AT_AT] = ACTIONS(364),
    [anon_sym_AT_ATdbt] = ACTIONS(364),
    [anon_sym_AT_ATdbta] = ACTIONS(362),
    [anon_sym_AT_ATdbtb] = ACTIONS(362),
    [anon_sym_AT_ATdbts] = ACTIONS(362),
    [anon_sym_AT_AT_DOT] = ACTIONS(362),
    [anon_sym_AT_AT_EQ] = ACTIONS(362),
    [anon_sym_AT_ATk] = ACTIONS(362),
    [anon_sym_AT_ATt] = ACTIONS(362),
    [anon_sym_AT_ATb] = ACTIONS(362),
    [anon_sym_AT_ATi] = ACTIONS(364),
    [anon_sym_AT_ATiS] = ACTIONS(362),
    [anon_sym_AT_ATf] = ACTIONS(362),
    [anon_sym_AT_ATs_COLON] = ACTIONS(362),
    [anon_sym_AT_ATc_COLON] = ACTIONS(362),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_AT_BANG] = ACTIONS(362),
    [anon_sym_AT_LBRACE] = ACTIONS(362),
    [anon_sym_ATa_COLON] = ACTIONS(362),
    [anon_sym_ATb_COLON] = ACTIONS(362),
    [anon_sym_ATB_COLON] = ACTIONS(362),
    [anon_sym_ATe_COLON] = ACTIONS(362),
    [anon_sym_ATF_COLON] = ACTIONS(362),
    [anon_sym_ATi_COLON] = ACTIONS(362),
    [anon_sym_ATk_COLON] = ACTIONS(362),
    [anon_sym_ATo_COLON] = ACTIONS(362),
    [anon_sym_ATr_COLON] = ACTIONS(362),
    [anon_sym_ATf_COLON] = ACTIONS(362),
    [anon_sym_ATs_COLON] = ACTIONS(362),
    [anon_sym_ATx_COLON] = ACTIONS(362),
    [anon_sym_PIPE_DOT] = ACTIONS(362),
    [anon_sym_EQ] = ACTIONS(364),
    [anon_sym_LPAREN] = ACTIONS(362),
    [anon_sym_RPAREN] = ACTIONS(362),
    [sym_pf_arg_identifier] = ACTIONS(364),
    [anon_sym_SEMI] = ACTIONS(362),
    [anon_sym_GT] = ACTIONS(364),
    [anon_sym_GT_GT] = ACTIONS(362),
    [sym_html_redirect_operator] = ACTIONS(364),
    [sym_html_append_operator] = ACTIONS(362),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(362),
    [anon_sym_BQUOTE] = ACTIONS(362),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(362),
    [anon_sym_CR] = ACTIONS(362),
    [sym_file_descriptor] = ACTIONS(362),
    [sym__concat_pf_dot] = ACTIONS(366),
  },
  [104] = {
    [sym_eq_sep_args] = STATE(237),
    [sym__eq_sep_key_single] = STATE(123),
    [sym_eq_sep_key] = STATE(176),
    [sym_double_quoted_arg] = STATE(168),
    [sym_single_quoted_arg] = STATE(168),
    [sym_cmd_substitution_arg] = STATE(168),
    [anon_sym_DQUOTE] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_PIPEH] = ACTIONS(275),
    [anon_sym_PIPET] = ACTIONS(275),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(275),
    [anon_sym_AT_AT_ATb] = ACTIONS(275),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(275),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(275),
    [anon_sym_AT_AT_ATi] = ACTIONS(275),
    [anon_sym_AT_AT_ATr] = ACTIONS(275),
    [anon_sym_AT_AT_ATs] = ACTIONS(279),
    [anon_sym_AT_AT_ATst] = ACTIONS(275),
    [anon_sym_AT_AT_ATS] = ACTIONS(275),
    [anon_sym_AT_AT_ATm] = ACTIONS(275),
    [anon_sym_AT_AT_ATM] = ACTIONS(275),
    [anon_sym_AT_AT_ATf] = ACTIONS(279),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(275),
    [anon_sym_AT_AT_ATF] = ACTIONS(279),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(275),
    [anon_sym_AT_AT_ATt] = ACTIONS(275),
    [anon_sym_AT_AT] = ACTIONS(279),
    [anon_sym_AT_ATdbt] = ACTIONS(279),
    [anon_sym_AT_ATdbta] = ACTIONS(275),
    [anon_sym_AT_ATdbtb] = ACTIONS(275),
    [anon_sym_AT_ATdbts] = ACTIONS(275),
    [anon_sym_AT_AT_DOT] = ACTIONS(275),
    [anon_sym_AT_AT_EQ] = ACTIONS(275),
    [anon_sym_AT_ATk] = ACTIONS(275),
    [anon_sym_AT_ATt] = ACTIONS(275),
    [anon_sym_AT_ATb] = ACTIONS(275),
    [anon_sym_AT_ATi] = ACTIONS(279),
    [anon_sym_AT_ATiS] = ACTIONS(275),
    [anon_sym_AT_ATf] = ACTIONS(275),
    [anon_sym_AT_ATs_COLON] = ACTIONS(275),
    [anon_sym_AT_ATc_COLON] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_AT_BANG] = ACTIONS(275),
    [anon_sym_AT_LBRACE] = ACTIONS(275),
    [anon_sym_ATa_COLON] = ACTIONS(275),
    [anon_sym_ATb_COLON] = ACTIONS(275),
    [anon_sym_ATB_COLON] = ACTIONS(275),
    [anon_sym_ATe_COLON] = ACTIONS(275),
    [anon_sym_ATF_COLON] = ACTIONS(275),
    [anon_sym_ATi_COLON] = ACTIONS(275),
    [anon_sym_ATk_COLON] = ACTIONS(275),
    [anon_sym_ATo_COLON] = ACTIONS(275),
    [anon_sym_ATr_COLON] = ACTIONS(275),
    [anon_sym_ATf_COLON] = ACTIONS(275),
    [anon_sym_ATs_COLON] = ACTIONS(275),
    [anon_sym_ATx_COLON] = ACTIONS(275),
    [anon_sym_PIPE_DOT] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(275),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_GT_GT] = ACTIONS(275),
    [sym_html_redirect_operator] = ACTIONS(279),
    [sym_html_append_operator] = ACTIONS(275),
    [sym__eq_sep_key_identifier] = ACTIONS(281),
    [anon_sym_SQUOTE] = ACTIONS(283),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(285),
    [anon_sym_BQUOTE] = ACTIONS(275),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(275),
  },
  [105] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(105),
    [ts_builtin_sym_end] = ACTIONS(368),
    [anon_sym_TILDE] = ACTIONS(368),
    [anon_sym_PIPE] = ACTIONS(370),
    [anon_sym_PIPEH] = ACTIONS(368),
    [anon_sym_PIPET] = ACTIONS(368),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(368),
    [anon_sym_AT_AT_ATb] = ACTIONS(368),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATi] = ACTIONS(368),
    [anon_sym_AT_AT_ATr] = ACTIONS(368),
    [anon_sym_AT_AT_ATs] = ACTIONS(370),
    [anon_sym_AT_AT_ATst] = ACTIONS(368),
    [anon_sym_AT_AT_ATS] = ACTIONS(368),
    [anon_sym_AT_AT_ATm] = ACTIONS(368),
    [anon_sym_AT_AT_ATM] = ACTIONS(368),
    [anon_sym_AT_AT_ATf] = ACTIONS(370),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATF] = ACTIONS(370),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATt] = ACTIONS(368),
    [anon_sym_AT_AT] = ACTIONS(370),
    [anon_sym_AT_ATdbt] = ACTIONS(370),
    [anon_sym_AT_ATdbta] = ACTIONS(368),
    [anon_sym_AT_ATdbtb] = ACTIONS(368),
    [anon_sym_AT_ATdbts] = ACTIONS(368),
    [anon_sym_AT_AT_DOT] = ACTIONS(368),
    [anon_sym_AT_AT_EQ] = ACTIONS(368),
    [anon_sym_AT_ATk] = ACTIONS(368),
    [anon_sym_AT_ATt] = ACTIONS(368),
    [anon_sym_AT_ATb] = ACTIONS(368),
    [anon_sym_AT_ATi] = ACTIONS(370),
    [anon_sym_AT_ATiS] = ACTIONS(368),
    [anon_sym_AT_ATf] = ACTIONS(368),
    [anon_sym_AT_ATs_COLON] = ACTIONS(368),
    [anon_sym_AT_ATc_COLON] = ACTIONS(368),
    [anon_sym_AT] = ACTIONS(370),
    [anon_sym_AT_BANG] = ACTIONS(368),
    [anon_sym_AT_LBRACE] = ACTIONS(368),
    [anon_sym_ATa_COLON] = ACTIONS(368),
    [anon_sym_ATb_COLON] = ACTIONS(368),
    [anon_sym_ATB_COLON] = ACTIONS(368),
    [anon_sym_ATe_COLON] = ACTIONS(368),
    [anon_sym_ATF_COLON] = ACTIONS(368),
    [anon_sym_ATi_COLON] = ACTIONS(368),
    [anon_sym_ATk_COLON] = ACTIONS(368),
    [anon_sym_ATo_COLON] = ACTIONS(368),
    [anon_sym_ATr_COLON] = ACTIONS(368),
    [anon_sym_ATf_COLON] = ACTIONS(368),
    [anon_sym_ATs_COLON] = ACTIONS(368),
    [anon_sym_ATx_COLON] = ACTIONS(368),
    [anon_sym_PIPE_DOT] = ACTIONS(368),
    [anon_sym_EQ] = ACTIONS(370),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(368),
    [sym_pf_arg_identifier] = ACTIONS(370),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym_GT] = ACTIONS(370),
    [anon_sym_GT_GT] = ACTIONS(368),
    [sym_html_redirect_operator] = ACTIONS(370),
    [sym_html_append_operator] = ACTIONS(368),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(368),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(368),
    [anon_sym_CR] = ACTIONS(368),
    [sym_file_descriptor] = ACTIONS(368),
    [sym__concat_pf_dot] = ACTIONS(372),
  },
  [106] = {
    [aux_sym_pf_concatenation_repeat1] = STATE(109),
    [ts_builtin_sym_end] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(375),
    [anon_sym_PIPE] = ACTIONS(377),
    [anon_sym_PIPEH] = ACTIONS(375),
    [anon_sym_PIPET] = ACTIONS(375),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(375),
    [anon_sym_AT_AT_ATb] = ACTIONS(375),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(375),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(375),
    [anon_sym_AT_AT_ATi] = ACTIONS(375),
    [anon_sym_AT_AT_ATr] = ACTIONS(375),
    [anon_sym_AT_AT_ATs] = ACTIONS(377),
    [anon_sym_AT_AT_ATst] = ACTIONS(375),
    [anon_sym_AT_AT_ATS] = ACTIONS(375),
    [anon_sym_AT_AT_ATm] = ACTIONS(375),
    [anon_sym_AT_AT_ATM] = ACTIONS(375),
    [anon_sym_AT_AT_ATf] = ACTIONS(377),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(375),
    [anon_sym_AT_AT_ATF] = ACTIONS(377),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(375),
    [anon_sym_AT_AT_ATt] = ACTIONS(375),
    [anon_sym_AT_AT] = ACTIONS(377),
    [anon_sym_AT_ATdbt] = ACTIONS(377),
    [anon_sym_AT_ATdbta] = ACTIONS(375),
    [anon_sym_AT_ATdbtb] = ACTIONS(375),
    [anon_sym_AT_ATdbts] = ACTIONS(375),
    [anon_sym_AT_AT_DOT] = ACTIONS(375),
    [anon_sym_AT_AT_EQ] = ACTIONS(375),
    [anon_sym_AT_ATk] = ACTIONS(375),
    [anon_sym_AT_ATt] = ACTIONS(375),
    [anon_sym_AT_ATb] = ACTIONS(375),
    [anon_sym_AT_ATi] = ACTIONS(377),
    [anon_sym_AT_ATiS] = ACTIONS(375),
    [anon_sym_AT_ATf] = ACTIONS(375),
    [anon_sym_AT_ATs_COLON] = ACTIONS(375),
    [anon_sym_AT_ATc_COLON] = ACTIONS(375),
    [anon_sym_AT] = ACTIONS(377),
    [anon_sym_AT_BANG] = ACTIONS(375),
    [anon_sym_AT_LBRACE] = ACTIONS(375),
    [anon_sym_ATa_COLON] = ACTIONS(375),
    [anon_sym_ATb_COLON] = ACTIONS(375),
    [anon_sym_ATB_COLON] = ACTIONS(375),
    [anon_sym_ATe_COLON] = ACTIONS(375),
    [anon_sym_ATF_COLON] = ACTIONS(375),
    [anon_sym_ATi_COLON] = ACTIONS(375),
    [anon_sym_ATk_COLON] = ACTIONS(375),
    [anon_sym_ATo_COLON] = ACTIONS(375),
    [anon_sym_ATr_COLON] = ACTIONS(375),
    [anon_sym_ATf_COLON] = ACTIONS(375),
    [anon_sym_ATs_COLON] = ACTIONS(375),
    [anon_sym_ATx_COLON] = ACTIONS(375),
    [anon_sym_PIPE_DOT] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(375),
    [anon_sym_RPAREN] = ACTIONS(375),
    [sym_pf_arg_identifier] = ACTIONS(377),
    [anon_sym_SEMI] = ACTIONS(375),
    [anon_sym_GT] = ACTIONS(377),
    [anon_sym_GT_GT] = ACTIONS(375),
    [sym_html_redirect_operator] = ACTIONS(377),
    [sym_html_append_operator] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(375),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(375),
    [anon_sym_CR] = ACTIONS(375),
    [sym_file_descriptor] = ACTIONS(375),
    [sym__concat] = ACTIONS(379),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(368),
    [anon_sym_TILDE] = ACTIONS(368),
    [anon_sym_PIPE] = ACTIONS(370),
    [anon_sym_PIPEH] = ACTIONS(368),
    [anon_sym_PIPET] = ACTIONS(368),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(368),
    [anon_sym_AT_AT_ATb] = ACTIONS(368),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATi] = ACTIONS(368),
    [anon_sym_AT_AT_ATr] = ACTIONS(368),
    [anon_sym_AT_AT_ATs] = ACTIONS(370),
    [anon_sym_AT_AT_ATst] = ACTIONS(368),
    [anon_sym_AT_AT_ATS] = ACTIONS(368),
    [anon_sym_AT_AT_ATm] = ACTIONS(368),
    [anon_sym_AT_AT_ATM] = ACTIONS(368),
    [anon_sym_AT_AT_ATf] = ACTIONS(370),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATF] = ACTIONS(370),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATt] = ACTIONS(368),
    [anon_sym_AT_AT] = ACTIONS(370),
    [anon_sym_AT_ATdbt] = ACTIONS(370),
    [anon_sym_AT_ATdbta] = ACTIONS(368),
    [anon_sym_AT_ATdbtb] = ACTIONS(368),
    [anon_sym_AT_ATdbts] = ACTIONS(368),
    [anon_sym_AT_AT_DOT] = ACTIONS(368),
    [anon_sym_AT_AT_EQ] = ACTIONS(368),
    [anon_sym_AT_ATk] = ACTIONS(368),
    [anon_sym_AT_ATt] = ACTIONS(368),
    [anon_sym_AT_ATb] = ACTIONS(368),
    [anon_sym_AT_ATi] = ACTIONS(370),
    [anon_sym_AT_ATiS] = ACTIONS(368),
    [anon_sym_AT_ATf] = ACTIONS(368),
    [anon_sym_AT_ATs_COLON] = ACTIONS(368),
    [anon_sym_AT_ATc_COLON] = ACTIONS(368),
    [anon_sym_AT] = ACTIONS(370),
    [anon_sym_AT_BANG] = ACTIONS(368),
    [anon_sym_AT_LBRACE] = ACTIONS(368),
    [anon_sym_ATa_COLON] = ACTIONS(368),
    [anon_sym_ATb_COLON] = ACTIONS(368),
    [anon_sym_ATB_COLON] = ACTIONS(368),
    [anon_sym_ATe_COLON] = ACTIONS(368),
    [anon_sym_ATF_COLON] = ACTIONS(368),
    [anon_sym_ATi_COLON] = ACTIONS(368),
    [anon_sym_ATk_COLON] = ACTIONS(368),
    [anon_sym_ATo_COLON] = ACTIONS(368),
    [anon_sym_ATr_COLON] = ACTIONS(368),
    [anon_sym_ATf_COLON] = ACTIONS(368),
    [anon_sym_ATs_COLON] = ACTIONS(368),
    [anon_sym_ATx_COLON] = ACTIONS(368),
    [anon_sym_PIPE_DOT] = ACTIONS(368),
    [anon_sym_EQ] = ACTIONS(370),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(368),
    [sym_pf_arg_identifier] = ACTIONS(370),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym_GT] = ACTIONS(370),
    [anon_sym_GT_GT] = ACTIONS(368),
    [sym_html_redirect_operator] = ACTIONS(370),
    [sym_html_append_operator] = ACTIONS(368),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(368),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(368),
    [anon_sym_CR] = ACTIONS(368),
    [sym_file_descriptor] = ACTIONS(368),
    [sym__concat_pf_dot] = ACTIONS(368),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_EQ] = ACTIONS(352),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [sym_pf_arg_identifier] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__concat_pf_dot] = ACTIONS(350),
  },
  [109] = {
    [aux_sym_pf_concatenation_repeat1] = STATE(113),
    [ts_builtin_sym_end] = ACTIONS(381),
    [anon_sym_TILDE] = ACTIONS(381),
    [anon_sym_PIPE] = ACTIONS(383),
    [anon_sym_PIPEH] = ACTIONS(381),
    [anon_sym_PIPET] = ACTIONS(381),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(381),
    [anon_sym_AT_AT_ATb] = ACTIONS(381),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(381),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(381),
    [anon_sym_AT_AT_ATi] = ACTIONS(381),
    [anon_sym_AT_AT_ATr] = ACTIONS(381),
    [anon_sym_AT_AT_ATs] = ACTIONS(383),
    [anon_sym_AT_AT_ATst] = ACTIONS(381),
    [anon_sym_AT_AT_ATS] = ACTIONS(381),
    [anon_sym_AT_AT_ATm] = ACTIONS(381),
    [anon_sym_AT_AT_ATM] = ACTIONS(381),
    [anon_sym_AT_AT_ATf] = ACTIONS(383),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(381),
    [anon_sym_AT_AT_ATF] = ACTIONS(383),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(381),
    [anon_sym_AT_AT_ATt] = ACTIONS(381),
    [anon_sym_AT_AT] = ACTIONS(383),
    [anon_sym_AT_ATdbt] = ACTIONS(383),
    [anon_sym_AT_ATdbta] = ACTIONS(381),
    [anon_sym_AT_ATdbtb] = ACTIONS(381),
    [anon_sym_AT_ATdbts] = ACTIONS(381),
    [anon_sym_AT_AT_DOT] = ACTIONS(381),
    [anon_sym_AT_AT_EQ] = ACTIONS(381),
    [anon_sym_AT_ATk] = ACTIONS(381),
    [anon_sym_AT_ATt] = ACTIONS(381),
    [anon_sym_AT_ATb] = ACTIONS(381),
    [anon_sym_AT_ATi] = ACTIONS(383),
    [anon_sym_AT_ATiS] = ACTIONS(381),
    [anon_sym_AT_ATf] = ACTIONS(381),
    [anon_sym_AT_ATs_COLON] = ACTIONS(381),
    [anon_sym_AT_ATc_COLON] = ACTIONS(381),
    [anon_sym_AT] = ACTIONS(383),
    [anon_sym_AT_BANG] = ACTIONS(381),
    [anon_sym_AT_LBRACE] = ACTIONS(381),
    [anon_sym_ATa_COLON] = ACTIONS(381),
    [anon_sym_ATb_COLON] = ACTIONS(381),
    [anon_sym_ATB_COLON] = ACTIONS(381),
    [anon_sym_ATe_COLON] = ACTIONS(381),
    [anon_sym_ATF_COLON] = ACTIONS(381),
    [anon_sym_ATi_COLON] = ACTIONS(381),
    [anon_sym_ATk_COLON] = ACTIONS(381),
    [anon_sym_ATo_COLON] = ACTIONS(381),
    [anon_sym_ATr_COLON] = ACTIONS(381),
    [anon_sym_ATf_COLON] = ACTIONS(381),
    [anon_sym_ATs_COLON] = ACTIONS(381),
    [anon_sym_ATx_COLON] = ACTIONS(381),
    [anon_sym_PIPE_DOT] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_RPAREN] = ACTIONS(381),
    [sym_pf_arg_identifier] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(381),
    [anon_sym_GT] = ACTIONS(383),
    [anon_sym_GT_GT] = ACTIONS(381),
    [sym_html_redirect_operator] = ACTIONS(383),
    [sym_html_append_operator] = ACTIONS(381),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(381),
    [anon_sym_BQUOTE] = ACTIONS(381),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(381),
    [anon_sym_CR] = ACTIONS(381),
    [sym_file_descriptor] = ACTIONS(381),
    [sym__concat] = ACTIONS(379),
  },
  [110] = {
    [sym__pf_arg_parentheses] = STATE(106),
    [sym__pf_arg] = STATE(106),
    [sym_pf_concatenation] = STATE(124),
    [sym_pf_arg] = STATE(85),
    [sym_cmd_substitution_arg] = STATE(106),
    [aux_sym_pf_args_repeat1] = STATE(85),
    [anon_sym_TILDE] = ACTIONS(289),
    [anon_sym_PIPE] = ACTIONS(291),
    [anon_sym_PIPEH] = ACTIONS(289),
    [anon_sym_PIPET] = ACTIONS(289),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(289),
    [anon_sym_AT_AT_ATb] = ACTIONS(289),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(289),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(289),
    [anon_sym_AT_AT_ATi] = ACTIONS(289),
    [anon_sym_AT_AT_ATr] = ACTIONS(289),
    [anon_sym_AT_AT_ATs] = ACTIONS(291),
    [anon_sym_AT_AT_ATst] = ACTIONS(289),
    [anon_sym_AT_AT_ATS] = ACTIONS(289),
    [anon_sym_AT_AT_ATm] = ACTIONS(289),
    [anon_sym_AT_AT_ATM] = ACTIONS(289),
    [anon_sym_AT_AT_ATf] = ACTIONS(291),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(289),
    [anon_sym_AT_AT_ATF] = ACTIONS(291),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(289),
    [anon_sym_AT_AT_ATt] = ACTIONS(289),
    [anon_sym_AT_AT] = ACTIONS(291),
    [anon_sym_AT_ATdbt] = ACTIONS(291),
    [anon_sym_AT_ATdbta] = ACTIONS(289),
    [anon_sym_AT_ATdbtb] = ACTIONS(289),
    [anon_sym_AT_ATdbts] = ACTIONS(289),
    [anon_sym_AT_AT_DOT] = ACTIONS(289),
    [anon_sym_AT_AT_EQ] = ACTIONS(289),
    [anon_sym_AT_ATk] = ACTIONS(289),
    [anon_sym_AT_ATt] = ACTIONS(289),
    [anon_sym_AT_ATb] = ACTIONS(289),
    [anon_sym_AT_ATi] = ACTIONS(291),
    [anon_sym_AT_ATiS] = ACTIONS(289),
    [anon_sym_AT_ATf] = ACTIONS(289),
    [anon_sym_AT_ATs_COLON] = ACTIONS(289),
    [anon_sym_AT_ATc_COLON] = ACTIONS(289),
    [anon_sym_AT] = ACTIONS(291),
    [anon_sym_AT_BANG] = ACTIONS(289),
    [anon_sym_AT_LBRACE] = ACTIONS(289),
    [anon_sym_ATa_COLON] = ACTIONS(289),
    [anon_sym_ATb_COLON] = ACTIONS(289),
    [anon_sym_ATB_COLON] = ACTIONS(289),
    [anon_sym_ATe_COLON] = ACTIONS(289),
    [anon_sym_ATF_COLON] = ACTIONS(289),
    [anon_sym_ATi_COLON] = ACTIONS(289),
    [anon_sym_ATk_COLON] = ACTIONS(289),
    [anon_sym_ATo_COLON] = ACTIONS(289),
    [anon_sym_ATr_COLON] = ACTIONS(289),
    [anon_sym_ATf_COLON] = ACTIONS(289),
    [anon_sym_ATs_COLON] = ACTIONS(289),
    [anon_sym_ATx_COLON] = ACTIONS(289),
    [anon_sym_PIPE_DOT] = ACTIONS(289),
    [anon_sym_LPAREN] = ACTIONS(232),
    [sym_pf_arg_identifier] = ACTIONS(234),
    [anon_sym_SEMI] = ACTIONS(289),
    [anon_sym_GT] = ACTIONS(291),
    [anon_sym_GT_GT] = ACTIONS(289),
    [sym_html_redirect_operator] = ACTIONS(291),
    [sym_html_append_operator] = ACTIONS(289),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(236),
    [anon_sym_BQUOTE] = ACTIONS(289),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(289),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_PIPEH] = ACTIONS(358),
    [anon_sym_PIPET] = ACTIONS(358),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATi] = ACTIONS(358),
    [anon_sym_AT_AT_ATr] = ACTIONS(358),
    [anon_sym_AT_AT_ATs] = ACTIONS(360),
    [anon_sym_AT_AT_ATst] = ACTIONS(358),
    [anon_sym_AT_AT_ATS] = ACTIONS(358),
    [anon_sym_AT_AT_ATm] = ACTIONS(358),
    [anon_sym_AT_AT_ATM] = ACTIONS(358),
    [anon_sym_AT_AT_ATf] = ACTIONS(360),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATF] = ACTIONS(360),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_AT] = ACTIONS(360),
    [anon_sym_AT_ATdbt] = ACTIONS(360),
    [anon_sym_AT_ATdbta] = ACTIONS(358),
    [anon_sym_AT_ATdbtb] = ACTIONS(358),
    [anon_sym_AT_ATdbts] = ACTIONS(358),
    [anon_sym_AT_AT_DOT] = ACTIONS(358),
    [anon_sym_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_ATk] = ACTIONS(358),
    [anon_sym_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_ATi] = ACTIONS(360),
    [anon_sym_AT_ATiS] = ACTIONS(358),
    [anon_sym_AT_ATf] = ACTIONS(358),
    [anon_sym_AT_ATs_COLON] = ACTIONS(358),
    [anon_sym_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_AT_BANG] = ACTIONS(358),
    [anon_sym_AT_LBRACE] = ACTIONS(358),
    [anon_sym_ATa_COLON] = ACTIONS(358),
    [anon_sym_ATb_COLON] = ACTIONS(358),
    [anon_sym_ATB_COLON] = ACTIONS(358),
    [anon_sym_ATe_COLON] = ACTIONS(358),
    [anon_sym_ATF_COLON] = ACTIONS(358),
    [anon_sym_ATi_COLON] = ACTIONS(358),
    [anon_sym_ATk_COLON] = ACTIONS(358),
    [anon_sym_ATo_COLON] = ACTIONS(358),
    [anon_sym_ATr_COLON] = ACTIONS(358),
    [anon_sym_ATf_COLON] = ACTIONS(358),
    [anon_sym_ATs_COLON] = ACTIONS(358),
    [anon_sym_ATx_COLON] = ACTIONS(358),
    [anon_sym_PIPE_DOT] = ACTIONS(358),
    [anon_sym_EQ] = ACTIONS(360),
    [anon_sym_LPAREN] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [sym_pf_arg_identifier] = ACTIONS(360),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(358),
    [sym_html_redirect_operator] = ACTIONS(360),
    [sym_html_append_operator] = ACTIONS(358),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(358),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(358),
    [anon_sym_CR] = ACTIONS(358),
    [sym_file_descriptor] = ACTIONS(358),
    [sym__concat_pf_dot] = ACTIONS(358),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_EQ] = ACTIONS(352),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [sym_pf_arg_identifier] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__concat_pf_dot] = ACTIONS(350),
  },
  [113] = {
    [aux_sym_pf_concatenation_repeat1] = STATE(113),
    [ts_builtin_sym_end] = ACTIONS(385),
    [anon_sym_TILDE] = ACTIONS(385),
    [anon_sym_PIPE] = ACTIONS(387),
    [anon_sym_PIPEH] = ACTIONS(385),
    [anon_sym_PIPET] = ACTIONS(385),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(385),
    [anon_sym_AT_AT_ATb] = ACTIONS(385),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(385),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(385),
    [anon_sym_AT_AT_ATi] = ACTIONS(385),
    [anon_sym_AT_AT_ATr] = ACTIONS(385),
    [anon_sym_AT_AT_ATs] = ACTIONS(387),
    [anon_sym_AT_AT_ATst] = ACTIONS(385),
    [anon_sym_AT_AT_ATS] = ACTIONS(385),
    [anon_sym_AT_AT_ATm] = ACTIONS(385),
    [anon_sym_AT_AT_ATM] = ACTIONS(385),
    [anon_sym_AT_AT_ATf] = ACTIONS(387),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(385),
    [anon_sym_AT_AT_ATF] = ACTIONS(387),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(385),
    [anon_sym_AT_AT_ATt] = ACTIONS(385),
    [anon_sym_AT_AT] = ACTIONS(387),
    [anon_sym_AT_ATdbt] = ACTIONS(387),
    [anon_sym_AT_ATdbta] = ACTIONS(385),
    [anon_sym_AT_ATdbtb] = ACTIONS(385),
    [anon_sym_AT_ATdbts] = ACTIONS(385),
    [anon_sym_AT_AT_DOT] = ACTIONS(385),
    [anon_sym_AT_AT_EQ] = ACTIONS(385),
    [anon_sym_AT_ATk] = ACTIONS(385),
    [anon_sym_AT_ATt] = ACTIONS(385),
    [anon_sym_AT_ATb] = ACTIONS(385),
    [anon_sym_AT_ATi] = ACTIONS(387),
    [anon_sym_AT_ATiS] = ACTIONS(385),
    [anon_sym_AT_ATf] = ACTIONS(385),
    [anon_sym_AT_ATs_COLON] = ACTIONS(385),
    [anon_sym_AT_ATc_COLON] = ACTIONS(385),
    [anon_sym_AT] = ACTIONS(387),
    [anon_sym_AT_BANG] = ACTIONS(385),
    [anon_sym_AT_LBRACE] = ACTIONS(385),
    [anon_sym_ATa_COLON] = ACTIONS(385),
    [anon_sym_ATb_COLON] = ACTIONS(385),
    [anon_sym_ATB_COLON] = ACTIONS(385),
    [anon_sym_ATe_COLON] = ACTIONS(385),
    [anon_sym_ATF_COLON] = ACTIONS(385),
    [anon_sym_ATi_COLON] = ACTIONS(385),
    [anon_sym_ATk_COLON] = ACTIONS(385),
    [anon_sym_ATo_COLON] = ACTIONS(385),
    [anon_sym_ATr_COLON] = ACTIONS(385),
    [anon_sym_ATf_COLON] = ACTIONS(385),
    [anon_sym_ATs_COLON] = ACTIONS(385),
    [anon_sym_ATx_COLON] = ACTIONS(385),
    [anon_sym_PIPE_DOT] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_RPAREN] = ACTIONS(385),
    [sym_pf_arg_identifier] = ACTIONS(387),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_GT] = ACTIONS(387),
    [anon_sym_GT_GT] = ACTIONS(385),
    [sym_html_redirect_operator] = ACTIONS(387),
    [sym_html_append_operator] = ACTIONS(385),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(385),
    [anon_sym_BQUOTE] = ACTIONS(385),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(385),
    [anon_sym_CR] = ACTIONS(385),
    [sym_file_descriptor] = ACTIONS(385),
    [sym__concat] = ACTIONS(389),
  },
  [114] = {
    [sym_cmd_substitution_arg] = STATE(120),
    [aux_sym_grep_specifier_repeat1] = STATE(120),
    [ts_builtin_sym_end] = ACTIONS(392),
    [anon_sym_TILDE] = ACTIONS(394),
    [sym_grep_specifier_identifier] = ACTIONS(396),
    [aux_sym_grep_specifier_token1] = ACTIONS(398),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_PIPEH] = ACTIONS(394),
    [anon_sym_PIPET] = ACTIONS(394),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(394),
    [anon_sym_AT_AT_ATb] = ACTIONS(394),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATi] = ACTIONS(394),
    [anon_sym_AT_AT_ATr] = ACTIONS(394),
    [anon_sym_AT_AT_ATs] = ACTIONS(394),
    [anon_sym_AT_AT_ATst] = ACTIONS(394),
    [anon_sym_AT_AT_ATS] = ACTIONS(394),
    [anon_sym_AT_AT_ATm] = ACTIONS(394),
    [anon_sym_AT_AT_ATM] = ACTIONS(394),
    [anon_sym_AT_AT_ATf] = ACTIONS(394),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATF] = ACTIONS(394),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATt] = ACTIONS(394),
    [anon_sym_AT_AT] = ACTIONS(394),
    [anon_sym_AT_ATdbt] = ACTIONS(394),
    [anon_sym_AT_ATdbta] = ACTIONS(394),
    [anon_sym_AT_ATdbtb] = ACTIONS(394),
    [anon_sym_AT_ATdbts] = ACTIONS(394),
    [anon_sym_AT_AT_DOT] = ACTIONS(394),
    [anon_sym_AT_AT_EQ] = ACTIONS(394),
    [anon_sym_AT_ATk] = ACTIONS(394),
    [anon_sym_AT_ATt] = ACTIONS(394),
    [anon_sym_AT_ATb] = ACTIONS(394),
    [anon_sym_AT_ATi] = ACTIONS(394),
    [anon_sym_AT_ATiS] = ACTIONS(394),
    [anon_sym_AT_ATf] = ACTIONS(394),
    [anon_sym_AT_ATs_COLON] = ACTIONS(394),
    [anon_sym_AT_ATc_COLON] = ACTIONS(394),
    [anon_sym_AT] = ACTIONS(394),
    [anon_sym_AT_BANG] = ACTIONS(394),
    [anon_sym_AT_LBRACE] = ACTIONS(394),
    [anon_sym_ATa_COLON] = ACTIONS(394),
    [anon_sym_ATb_COLON] = ACTIONS(394),
    [anon_sym_ATB_COLON] = ACTIONS(394),
    [anon_sym_ATe_COLON] = ACTIONS(394),
    [anon_sym_ATF_COLON] = ACTIONS(394),
    [anon_sym_ATi_COLON] = ACTIONS(394),
    [anon_sym_ATk_COLON] = ACTIONS(394),
    [anon_sym_ATo_COLON] = ACTIONS(394),
    [anon_sym_ATr_COLON] = ACTIONS(394),
    [anon_sym_ATf_COLON] = ACTIONS(394),
    [anon_sym_ATs_COLON] = ACTIONS(394),
    [anon_sym_ATx_COLON] = ACTIONS(394),
    [anon_sym_PIPE_DOT] = ACTIONS(394),
    [anon_sym_SEMI] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_GT_GT] = ACTIONS(394),
    [sym_html_redirect_operator] = ACTIONS(394),
    [sym_html_append_operator] = ACTIONS(394),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(400),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(394),
    [anon_sym_CR] = ACTIONS(394),
    [sym_file_descriptor] = ACTIONS(392),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [sym_pf_arg_identifier] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__concat] = ACTIONS(350),
  },
  [116] = {
    [ts_builtin_sym_end] = ACTIONS(404),
    [anon_sym_DQUOTE] = ACTIONS(404),
    [anon_sym_TILDE] = ACTIONS(404),
    [anon_sym_PIPE] = ACTIONS(406),
    [anon_sym_PIPEH] = ACTIONS(404),
    [anon_sym_PIPET] = ACTIONS(404),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(404),
    [anon_sym_AT_AT_ATb] = ACTIONS(404),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(404),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(404),
    [anon_sym_AT_AT_ATi] = ACTIONS(404),
    [anon_sym_AT_AT_ATr] = ACTIONS(404),
    [anon_sym_AT_AT_ATs] = ACTIONS(406),
    [anon_sym_AT_AT_ATst] = ACTIONS(404),
    [anon_sym_AT_AT_ATS] = ACTIONS(404),
    [anon_sym_AT_AT_ATm] = ACTIONS(404),
    [anon_sym_AT_AT_ATM] = ACTIONS(404),
    [anon_sym_AT_AT_ATf] = ACTIONS(406),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(404),
    [anon_sym_AT_AT_ATF] = ACTIONS(406),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(404),
    [anon_sym_AT_AT_ATt] = ACTIONS(404),
    [anon_sym_AT_AT] = ACTIONS(406),
    [anon_sym_AT_ATdbt] = ACTIONS(406),
    [anon_sym_AT_ATdbta] = ACTIONS(404),
    [anon_sym_AT_ATdbtb] = ACTIONS(404),
    [anon_sym_AT_ATdbts] = ACTIONS(404),
    [anon_sym_AT_AT_DOT] = ACTIONS(404),
    [anon_sym_AT_AT_EQ] = ACTIONS(404),
    [anon_sym_AT_ATk] = ACTIONS(404),
    [anon_sym_AT_ATt] = ACTIONS(404),
    [anon_sym_AT_ATb] = ACTIONS(404),
    [anon_sym_AT_ATi] = ACTIONS(406),
    [anon_sym_AT_ATiS] = ACTIONS(404),
    [anon_sym_AT_ATf] = ACTIONS(404),
    [anon_sym_AT_ATs_COLON] = ACTIONS(404),
    [anon_sym_AT_ATc_COLON] = ACTIONS(404),
    [anon_sym_AT] = ACTIONS(406),
    [anon_sym_AT_BANG] = ACTIONS(404),
    [anon_sym_AT_LBRACE] = ACTIONS(404),
    [anon_sym_ATa_COLON] = ACTIONS(404),
    [anon_sym_ATb_COLON] = ACTIONS(404),
    [anon_sym_ATB_COLON] = ACTIONS(404),
    [anon_sym_ATe_COLON] = ACTIONS(404),
    [anon_sym_ATF_COLON] = ACTIONS(404),
    [anon_sym_ATi_COLON] = ACTIONS(404),
    [anon_sym_ATk_COLON] = ACTIONS(404),
    [anon_sym_ATo_COLON] = ACTIONS(404),
    [anon_sym_ATr_COLON] = ACTIONS(404),
    [anon_sym_ATf_COLON] = ACTIONS(404),
    [anon_sym_ATs_COLON] = ACTIONS(404),
    [anon_sym_ATx_COLON] = ACTIONS(404),
    [anon_sym_PIPE_DOT] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(404),
    [anon_sym_SEMI] = ACTIONS(404),
    [anon_sym_GT] = ACTIONS(406),
    [anon_sym_GT_GT] = ACTIONS(404),
    [sym_html_redirect_operator] = ACTIONS(406),
    [sym_html_append_operator] = ACTIONS(404),
    [sym__eq_sep_key_identifier] = ACTIONS(406),
    [anon_sym_SQUOTE] = ACTIONS(404),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(404),
    [anon_sym_BQUOTE] = ACTIONS(404),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(404),
    [anon_sym_CR] = ACTIONS(404),
    [sym_file_descriptor] = ACTIONS(404),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(385),
    [anon_sym_TILDE] = ACTIONS(385),
    [anon_sym_PIPE] = ACTIONS(387),
    [anon_sym_PIPEH] = ACTIONS(385),
    [anon_sym_PIPET] = ACTIONS(385),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(385),
    [anon_sym_AT_AT_ATb] = ACTIONS(385),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(385),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(385),
    [anon_sym_AT_AT_ATi] = ACTIONS(385),
    [anon_sym_AT_AT_ATr] = ACTIONS(385),
    [anon_sym_AT_AT_ATs] = ACTIONS(387),
    [anon_sym_AT_AT_ATst] = ACTIONS(385),
    [anon_sym_AT_AT_ATS] = ACTIONS(385),
    [anon_sym_AT_AT_ATm] = ACTIONS(385),
    [anon_sym_AT_AT_ATM] = ACTIONS(385),
    [anon_sym_AT_AT_ATf] = ACTIONS(387),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(385),
    [anon_sym_AT_AT_ATF] = ACTIONS(387),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(385),
    [anon_sym_AT_AT_ATt] = ACTIONS(385),
    [anon_sym_AT_AT] = ACTIONS(387),
    [anon_sym_AT_ATdbt] = ACTIONS(387),
    [anon_sym_AT_ATdbta] = ACTIONS(385),
    [anon_sym_AT_ATdbtb] = ACTIONS(385),
    [anon_sym_AT_ATdbts] = ACTIONS(385),
    [anon_sym_AT_AT_DOT] = ACTIONS(385),
    [anon_sym_AT_AT_EQ] = ACTIONS(385),
    [anon_sym_AT_ATk] = ACTIONS(385),
    [anon_sym_AT_ATt] = ACTIONS(385),
    [anon_sym_AT_ATb] = ACTIONS(385),
    [anon_sym_AT_ATi] = ACTIONS(387),
    [anon_sym_AT_ATiS] = ACTIONS(385),
    [anon_sym_AT_ATf] = ACTIONS(385),
    [anon_sym_AT_ATs_COLON] = ACTIONS(385),
    [anon_sym_AT_ATc_COLON] = ACTIONS(385),
    [anon_sym_AT] = ACTIONS(387),
    [anon_sym_AT_BANG] = ACTIONS(385),
    [anon_sym_AT_LBRACE] = ACTIONS(385),
    [anon_sym_ATa_COLON] = ACTIONS(385),
    [anon_sym_ATb_COLON] = ACTIONS(385),
    [anon_sym_ATB_COLON] = ACTIONS(385),
    [anon_sym_ATe_COLON] = ACTIONS(385),
    [anon_sym_ATF_COLON] = ACTIONS(385),
    [anon_sym_ATi_COLON] = ACTIONS(385),
    [anon_sym_ATk_COLON] = ACTIONS(385),
    [anon_sym_ATo_COLON] = ACTIONS(385),
    [anon_sym_ATr_COLON] = ACTIONS(385),
    [anon_sym_ATf_COLON] = ACTIONS(385),
    [anon_sym_ATs_COLON] = ACTIONS(385),
    [anon_sym_ATx_COLON] = ACTIONS(385),
    [anon_sym_PIPE_DOT] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_RPAREN] = ACTIONS(385),
    [sym_pf_arg_identifier] = ACTIONS(387),
    [anon_sym_SEMI] = ACTIONS(385),
    [anon_sym_GT] = ACTIONS(387),
    [anon_sym_GT_GT] = ACTIONS(385),
    [sym_html_redirect_operator] = ACTIONS(387),
    [sym_html_append_operator] = ACTIONS(385),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(385),
    [anon_sym_BQUOTE] = ACTIONS(385),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(385),
    [anon_sym_CR] = ACTIONS(385),
    [sym_file_descriptor] = ACTIONS(385),
    [sym__concat] = ACTIONS(385),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [sym_pf_arg_identifier] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__concat] = ACTIONS(350),
  },
  [119] = {
    [ts_builtin_sym_end] = ACTIONS(408),
    [anon_sym_TILDE] = ACTIONS(408),
    [anon_sym_PIPE] = ACTIONS(410),
    [anon_sym_PIPEH] = ACTIONS(408),
    [anon_sym_PIPET] = ACTIONS(408),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(408),
    [anon_sym_AT_AT_ATb] = ACTIONS(408),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(408),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(408),
    [anon_sym_AT_AT_ATi] = ACTIONS(408),
    [anon_sym_AT_AT_ATr] = ACTIONS(408),
    [anon_sym_AT_AT_ATs] = ACTIONS(410),
    [anon_sym_AT_AT_ATst] = ACTIONS(408),
    [anon_sym_AT_AT_ATS] = ACTIONS(408),
    [anon_sym_AT_AT_ATm] = ACTIONS(408),
    [anon_sym_AT_AT_ATM] = ACTIONS(408),
    [anon_sym_AT_AT_ATf] = ACTIONS(410),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(408),
    [anon_sym_AT_AT_ATF] = ACTIONS(410),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(408),
    [anon_sym_AT_AT_ATt] = ACTIONS(408),
    [anon_sym_AT_AT] = ACTIONS(410),
    [anon_sym_AT_ATdbt] = ACTIONS(410),
    [anon_sym_AT_ATdbta] = ACTIONS(408),
    [anon_sym_AT_ATdbtb] = ACTIONS(408),
    [anon_sym_AT_ATdbts] = ACTIONS(408),
    [anon_sym_AT_AT_DOT] = ACTIONS(408),
    [anon_sym_AT_AT_EQ] = ACTIONS(408),
    [anon_sym_AT_ATk] = ACTIONS(408),
    [anon_sym_AT_ATt] = ACTIONS(408),
    [anon_sym_AT_ATb] = ACTIONS(408),
    [anon_sym_AT_ATi] = ACTIONS(410),
    [anon_sym_AT_ATiS] = ACTIONS(408),
    [anon_sym_AT_ATf] = ACTIONS(408),
    [anon_sym_AT_ATs_COLON] = ACTIONS(408),
    [anon_sym_AT_ATc_COLON] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(410),
    [anon_sym_AT_BANG] = ACTIONS(408),
    [anon_sym_AT_LBRACE] = ACTIONS(408),
    [anon_sym_ATa_COLON] = ACTIONS(408),
    [anon_sym_ATb_COLON] = ACTIONS(408),
    [anon_sym_ATB_COLON] = ACTIONS(408),
    [anon_sym_ATe_COLON] = ACTIONS(408),
    [anon_sym_ATF_COLON] = ACTIONS(408),
    [anon_sym_ATi_COLON] = ACTIONS(408),
    [anon_sym_ATk_COLON] = ACTIONS(408),
    [anon_sym_ATo_COLON] = ACTIONS(408),
    [anon_sym_ATr_COLON] = ACTIONS(408),
    [anon_sym_ATf_COLON] = ACTIONS(408),
    [anon_sym_ATs_COLON] = ACTIONS(408),
    [anon_sym_ATx_COLON] = ACTIONS(408),
    [anon_sym_PIPE_DOT] = ACTIONS(408),
    [anon_sym_LPAREN] = ACTIONS(408),
    [anon_sym_RPAREN] = ACTIONS(408),
    [sym_pf_arg_identifier] = ACTIONS(410),
    [anon_sym_SEMI] = ACTIONS(408),
    [anon_sym_GT] = ACTIONS(410),
    [anon_sym_GT_GT] = ACTIONS(408),
    [sym_html_redirect_operator] = ACTIONS(410),
    [sym_html_append_operator] = ACTIONS(408),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(408),
    [anon_sym_BQUOTE] = ACTIONS(408),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(408),
    [anon_sym_CR] = ACTIONS(408),
    [sym_file_descriptor] = ACTIONS(408),
    [sym__concat] = ACTIONS(408),
  },
  [120] = {
    [sym_cmd_substitution_arg] = STATE(120),
    [aux_sym_grep_specifier_repeat1] = STATE(120),
    [ts_builtin_sym_end] = ACTIONS(412),
    [anon_sym_TILDE] = ACTIONS(414),
    [sym_grep_specifier_identifier] = ACTIONS(416),
    [aux_sym_grep_specifier_token1] = ACTIONS(414),
    [anon_sym_PIPE] = ACTIONS(414),
    [anon_sym_PIPEH] = ACTIONS(414),
    [anon_sym_PIPET] = ACTIONS(414),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(414),
    [anon_sym_AT_AT_ATb] = ACTIONS(414),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(414),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(414),
    [anon_sym_AT_AT_ATi] = ACTIONS(414),
    [anon_sym_AT_AT_ATr] = ACTIONS(414),
    [anon_sym_AT_AT_ATs] = ACTIONS(414),
    [anon_sym_AT_AT_ATst] = ACTIONS(414),
    [anon_sym_AT_AT_ATS] = ACTIONS(414),
    [anon_sym_AT_AT_ATm] = ACTIONS(414),
    [anon_sym_AT_AT_ATM] = ACTIONS(414),
    [anon_sym_AT_AT_ATf] = ACTIONS(414),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(414),
    [anon_sym_AT_AT_ATF] = ACTIONS(414),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(414),
    [anon_sym_AT_AT_ATt] = ACTIONS(414),
    [anon_sym_AT_AT] = ACTIONS(414),
    [anon_sym_AT_ATdbt] = ACTIONS(414),
    [anon_sym_AT_ATdbta] = ACTIONS(414),
    [anon_sym_AT_ATdbtb] = ACTIONS(414),
    [anon_sym_AT_ATdbts] = ACTIONS(414),
    [anon_sym_AT_AT_DOT] = ACTIONS(414),
    [anon_sym_AT_AT_EQ] = ACTIONS(414),
    [anon_sym_AT_ATk] = ACTIONS(414),
    [anon_sym_AT_ATt] = ACTIONS(414),
    [anon_sym_AT_ATb] = ACTIONS(414),
    [anon_sym_AT_ATi] = ACTIONS(414),
    [anon_sym_AT_ATiS] = ACTIONS(414),
    [anon_sym_AT_ATf] = ACTIONS(414),
    [anon_sym_AT_ATs_COLON] = ACTIONS(414),
    [anon_sym_AT_ATc_COLON] = ACTIONS(414),
    [anon_sym_AT] = ACTIONS(414),
    [anon_sym_AT_BANG] = ACTIONS(414),
    [anon_sym_AT_LBRACE] = ACTIONS(414),
    [anon_sym_ATa_COLON] = ACTIONS(414),
    [anon_sym_ATb_COLON] = ACTIONS(414),
    [anon_sym_ATB_COLON] = ACTIONS(414),
    [anon_sym_ATe_COLON] = ACTIONS(414),
    [anon_sym_ATF_COLON] = ACTIONS(414),
    [anon_sym_ATi_COLON] = ACTIONS(414),
    [anon_sym_ATk_COLON] = ACTIONS(414),
    [anon_sym_ATo_COLON] = ACTIONS(414),
    [anon_sym_ATr_COLON] = ACTIONS(414),
    [anon_sym_ATf_COLON] = ACTIONS(414),
    [anon_sym_ATs_COLON] = ACTIONS(414),
    [anon_sym_ATx_COLON] = ACTIONS(414),
    [anon_sym_PIPE_DOT] = ACTIONS(414),
    [anon_sym_SEMI] = ACTIONS(414),
    [anon_sym_GT] = ACTIONS(414),
    [anon_sym_GT_GT] = ACTIONS(414),
    [sym_html_redirect_operator] = ACTIONS(414),
    [sym_html_append_operator] = ACTIONS(414),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(419),
    [anon_sym_BQUOTE] = ACTIONS(422),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(414),
    [anon_sym_CR] = ACTIONS(414),
    [sym_file_descriptor] = ACTIONS(412),
  },
  [121] = {
    [aux_sym_tmp_eval_arg_repeat1] = STATE(121),
    [ts_builtin_sym_end] = ACTIONS(425),
    [anon_sym_TILDE] = ACTIONS(425),
    [anon_sym_PIPE] = ACTIONS(427),
    [anon_sym_PIPEH] = ACTIONS(425),
    [anon_sym_PIPET] = ACTIONS(425),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(425),
    [anon_sym_AT_AT_ATb] = ACTIONS(425),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(425),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(425),
    [anon_sym_AT_AT_ATi] = ACTIONS(425),
    [anon_sym_AT_AT_ATr] = ACTIONS(425),
    [anon_sym_AT_AT_ATs] = ACTIONS(427),
    [anon_sym_AT_AT_ATst] = ACTIONS(425),
    [anon_sym_AT_AT_ATS] = ACTIONS(425),
    [anon_sym_AT_AT_ATm] = ACTIONS(425),
    [anon_sym_AT_AT_ATM] = ACTIONS(425),
    [anon_sym_AT_AT_ATf] = ACTIONS(427),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(425),
    [anon_sym_AT_AT_ATF] = ACTIONS(427),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(425),
    [anon_sym_AT_AT_ATt] = ACTIONS(425),
    [anon_sym_AT_AT] = ACTIONS(427),
    [anon_sym_AT_ATdbt] = ACTIONS(427),
    [anon_sym_AT_ATdbta] = ACTIONS(425),
    [anon_sym_AT_ATdbtb] = ACTIONS(425),
    [anon_sym_AT_ATdbts] = ACTIONS(425),
    [anon_sym_AT_AT_DOT] = ACTIONS(425),
    [anon_sym_AT_AT_EQ] = ACTIONS(425),
    [anon_sym_AT_ATk] = ACTIONS(425),
    [anon_sym_AT_ATt] = ACTIONS(425),
    [anon_sym_AT_ATb] = ACTIONS(425),
    [anon_sym_AT_ATi] = ACTIONS(427),
    [anon_sym_AT_ATiS] = ACTIONS(425),
    [anon_sym_AT_ATf] = ACTIONS(425),
    [anon_sym_AT_ATs_COLON] = ACTIONS(425),
    [anon_sym_AT_ATc_COLON] = ACTIONS(425),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_AT_BANG] = ACTIONS(425),
    [anon_sym_AT_LBRACE] = ACTIONS(425),
    [anon_sym_ATa_COLON] = ACTIONS(425),
    [anon_sym_ATb_COLON] = ACTIONS(425),
    [anon_sym_ATB_COLON] = ACTIONS(425),
    [anon_sym_ATe_COLON] = ACTIONS(425),
    [anon_sym_ATF_COLON] = ACTIONS(425),
    [anon_sym_ATi_COLON] = ACTIONS(425),
    [anon_sym_ATk_COLON] = ACTIONS(425),
    [anon_sym_ATo_COLON] = ACTIONS(425),
    [anon_sym_ATr_COLON] = ACTIONS(425),
    [anon_sym_ATf_COLON] = ACTIONS(425),
    [anon_sym_ATs_COLON] = ACTIONS(425),
    [anon_sym_ATx_COLON] = ACTIONS(425),
    [anon_sym_PIPE_DOT] = ACTIONS(425),
    [anon_sym_RPAREN] = ACTIONS(425),
    [anon_sym_SEMI] = ACTIONS(425),
    [anon_sym_GT] = ACTIONS(427),
    [anon_sym_GT_GT] = ACTIONS(425),
    [sym_html_redirect_operator] = ACTIONS(427),
    [sym_html_append_operator] = ACTIONS(425),
    [anon_sym_COMMA] = ACTIONS(425),
    [aux_sym_tmp_eval_arg_token1] = ACTIONS(429),
    [anon_sym_BQUOTE] = ACTIONS(425),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(425),
    [anon_sym_CR] = ACTIONS(425),
    [sym_file_descriptor] = ACTIONS(425),
  },
  [122] = {
    [aux_sym_pf_dot_args_repeat1] = STATE(122),
    [ts_builtin_sym_end] = ACTIONS(434),
    [anon_sym_TILDE] = ACTIONS(434),
    [anon_sym_PIPE] = ACTIONS(436),
    [anon_sym_PIPEH] = ACTIONS(434),
    [anon_sym_PIPET] = ACTIONS(434),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(434),
    [anon_sym_AT_AT_ATb] = ACTIONS(434),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(434),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(434),
    [anon_sym_AT_AT_ATi] = ACTIONS(434),
    [anon_sym_AT_AT_ATr] = ACTIONS(434),
    [anon_sym_AT_AT_ATs] = ACTIONS(436),
    [anon_sym_AT_AT_ATst] = ACTIONS(434),
    [anon_sym_AT_AT_ATS] = ACTIONS(434),
    [anon_sym_AT_AT_ATm] = ACTIONS(434),
    [anon_sym_AT_AT_ATM] = ACTIONS(434),
    [anon_sym_AT_AT_ATf] = ACTIONS(436),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(434),
    [anon_sym_AT_AT_ATF] = ACTIONS(436),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(434),
    [anon_sym_AT_AT_ATt] = ACTIONS(434),
    [anon_sym_AT_AT] = ACTIONS(436),
    [anon_sym_AT_ATdbt] = ACTIONS(436),
    [anon_sym_AT_ATdbta] = ACTIONS(434),
    [anon_sym_AT_ATdbtb] = ACTIONS(434),
    [anon_sym_AT_ATdbts] = ACTIONS(434),
    [anon_sym_AT_AT_DOT] = ACTIONS(434),
    [anon_sym_AT_AT_EQ] = ACTIONS(434),
    [anon_sym_AT_ATk] = ACTIONS(434),
    [anon_sym_AT_ATt] = ACTIONS(434),
    [anon_sym_AT_ATb] = ACTIONS(434),
    [anon_sym_AT_ATi] = ACTIONS(436),
    [anon_sym_AT_ATiS] = ACTIONS(434),
    [anon_sym_AT_ATf] = ACTIONS(434),
    [anon_sym_AT_ATs_COLON] = ACTIONS(434),
    [anon_sym_AT_ATc_COLON] = ACTIONS(434),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_AT_BANG] = ACTIONS(434),
    [anon_sym_AT_LBRACE] = ACTIONS(434),
    [anon_sym_ATa_COLON] = ACTIONS(434),
    [anon_sym_ATb_COLON] = ACTIONS(434),
    [anon_sym_ATB_COLON] = ACTIONS(434),
    [anon_sym_ATe_COLON] = ACTIONS(434),
    [anon_sym_ATF_COLON] = ACTIONS(434),
    [anon_sym_ATi_COLON] = ACTIONS(434),
    [anon_sym_ATk_COLON] = ACTIONS(434),
    [anon_sym_ATo_COLON] = ACTIONS(434),
    [anon_sym_ATr_COLON] = ACTIONS(434),
    [anon_sym_ATf_COLON] = ACTIONS(434),
    [anon_sym_ATs_COLON] = ACTIONS(434),
    [anon_sym_ATx_COLON] = ACTIONS(434),
    [anon_sym_PIPE_DOT] = ACTIONS(434),
    [anon_sym_EQ] = ACTIONS(434),
    [anon_sym_RPAREN] = ACTIONS(434),
    [anon_sym_SEMI] = ACTIONS(434),
    [anon_sym_GT] = ACTIONS(436),
    [anon_sym_GT_GT] = ACTIONS(434),
    [sym_html_redirect_operator] = ACTIONS(436),
    [sym_html_append_operator] = ACTIONS(434),
    [anon_sym_BQUOTE] = ACTIONS(434),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(434),
    [anon_sym_CR] = ACTIONS(434),
    [sym_file_descriptor] = ACTIONS(434),
    [sym__concat_pf_dot] = ACTIONS(438),
  },
  [123] = {
    [aux_sym_eq_sep_key_repeat1] = STATE(127),
    [ts_builtin_sym_end] = ACTIONS(441),
    [anon_sym_TILDE] = ACTIONS(441),
    [anon_sym_PIPE] = ACTIONS(443),
    [anon_sym_PIPEH] = ACTIONS(441),
    [anon_sym_PIPET] = ACTIONS(441),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(441),
    [anon_sym_AT_AT_ATb] = ACTIONS(441),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(441),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(441),
    [anon_sym_AT_AT_ATi] = ACTIONS(441),
    [anon_sym_AT_AT_ATr] = ACTIONS(441),
    [anon_sym_AT_AT_ATs] = ACTIONS(443),
    [anon_sym_AT_AT_ATst] = ACTIONS(441),
    [anon_sym_AT_AT_ATS] = ACTIONS(441),
    [anon_sym_AT_AT_ATm] = ACTIONS(441),
    [anon_sym_AT_AT_ATM] = ACTIONS(441),
    [anon_sym_AT_AT_ATf] = ACTIONS(443),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(441),
    [anon_sym_AT_AT_ATF] = ACTIONS(443),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(441),
    [anon_sym_AT_AT_ATt] = ACTIONS(441),
    [anon_sym_AT_AT] = ACTIONS(443),
    [anon_sym_AT_ATdbt] = ACTIONS(443),
    [anon_sym_AT_ATdbta] = ACTIONS(441),
    [anon_sym_AT_ATdbtb] = ACTIONS(441),
    [anon_sym_AT_ATdbts] = ACTIONS(441),
    [anon_sym_AT_AT_DOT] = ACTIONS(441),
    [anon_sym_AT_AT_EQ] = ACTIONS(441),
    [anon_sym_AT_ATk] = ACTIONS(441),
    [anon_sym_AT_ATt] = ACTIONS(441),
    [anon_sym_AT_ATb] = ACTIONS(441),
    [anon_sym_AT_ATi] = ACTIONS(443),
    [anon_sym_AT_ATiS] = ACTIONS(441),
    [anon_sym_AT_ATf] = ACTIONS(441),
    [anon_sym_AT_ATs_COLON] = ACTIONS(441),
    [anon_sym_AT_ATc_COLON] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_AT_BANG] = ACTIONS(441),
    [anon_sym_AT_LBRACE] = ACTIONS(441),
    [anon_sym_ATa_COLON] = ACTIONS(441),
    [anon_sym_ATb_COLON] = ACTIONS(441),
    [anon_sym_ATB_COLON] = ACTIONS(441),
    [anon_sym_ATe_COLON] = ACTIONS(441),
    [anon_sym_ATF_COLON] = ACTIONS(441),
    [anon_sym_ATi_COLON] = ACTIONS(441),
    [anon_sym_ATk_COLON] = ACTIONS(441),
    [anon_sym_ATo_COLON] = ACTIONS(441),
    [anon_sym_ATr_COLON] = ACTIONS(441),
    [anon_sym_ATf_COLON] = ACTIONS(441),
    [anon_sym_ATs_COLON] = ACTIONS(441),
    [anon_sym_ATx_COLON] = ACTIONS(441),
    [anon_sym_PIPE_DOT] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_RPAREN] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(443),
    [anon_sym_GT_GT] = ACTIONS(441),
    [sym_html_redirect_operator] = ACTIONS(443),
    [sym_html_append_operator] = ACTIONS(441),
    [anon_sym_BQUOTE] = ACTIONS(441),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_CR] = ACTIONS(441),
    [sym_file_descriptor] = ACTIONS(441),
    [sym__eq_sep_concat] = ACTIONS(445),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(375),
    [anon_sym_PIPE] = ACTIONS(377),
    [anon_sym_PIPEH] = ACTIONS(375),
    [anon_sym_PIPET] = ACTIONS(375),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(375),
    [anon_sym_AT_AT_ATb] = ACTIONS(375),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(375),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(375),
    [anon_sym_AT_AT_ATi] = ACTIONS(375),
    [anon_sym_AT_AT_ATr] = ACTIONS(375),
    [anon_sym_AT_AT_ATs] = ACTIONS(377),
    [anon_sym_AT_AT_ATst] = ACTIONS(375),
    [anon_sym_AT_AT_ATS] = ACTIONS(375),
    [anon_sym_AT_AT_ATm] = ACTIONS(375),
    [anon_sym_AT_AT_ATM] = ACTIONS(375),
    [anon_sym_AT_AT_ATf] = ACTIONS(377),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(375),
    [anon_sym_AT_AT_ATF] = ACTIONS(377),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(375),
    [anon_sym_AT_AT_ATt] = ACTIONS(375),
    [anon_sym_AT_AT] = ACTIONS(377),
    [anon_sym_AT_ATdbt] = ACTIONS(377),
    [anon_sym_AT_ATdbta] = ACTIONS(375),
    [anon_sym_AT_ATdbtb] = ACTIONS(375),
    [anon_sym_AT_ATdbts] = ACTIONS(375),
    [anon_sym_AT_AT_DOT] = ACTIONS(375),
    [anon_sym_AT_AT_EQ] = ACTIONS(375),
    [anon_sym_AT_ATk] = ACTIONS(375),
    [anon_sym_AT_ATt] = ACTIONS(375),
    [anon_sym_AT_ATb] = ACTIONS(375),
    [anon_sym_AT_ATi] = ACTIONS(377),
    [anon_sym_AT_ATiS] = ACTIONS(375),
    [anon_sym_AT_ATf] = ACTIONS(375),
    [anon_sym_AT_ATs_COLON] = ACTIONS(375),
    [anon_sym_AT_ATc_COLON] = ACTIONS(375),
    [anon_sym_AT] = ACTIONS(377),
    [anon_sym_AT_BANG] = ACTIONS(375),
    [anon_sym_AT_LBRACE] = ACTIONS(375),
    [anon_sym_ATa_COLON] = ACTIONS(375),
    [anon_sym_ATb_COLON] = ACTIONS(375),
    [anon_sym_ATB_COLON] = ACTIONS(375),
    [anon_sym_ATe_COLON] = ACTIONS(375),
    [anon_sym_ATF_COLON] = ACTIONS(375),
    [anon_sym_ATi_COLON] = ACTIONS(375),
    [anon_sym_ATk_COLON] = ACTIONS(375),
    [anon_sym_ATo_COLON] = ACTIONS(375),
    [anon_sym_ATr_COLON] = ACTIONS(375),
    [anon_sym_ATf_COLON] = ACTIONS(375),
    [anon_sym_ATs_COLON] = ACTIONS(375),
    [anon_sym_ATx_COLON] = ACTIONS(375),
    [anon_sym_PIPE_DOT] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(375),
    [anon_sym_RPAREN] = ACTIONS(375),
    [sym_pf_arg_identifier] = ACTIONS(377),
    [anon_sym_SEMI] = ACTIONS(375),
    [anon_sym_GT] = ACTIONS(377),
    [anon_sym_GT_GT] = ACTIONS(375),
    [sym_html_redirect_operator] = ACTIONS(377),
    [sym_html_append_operator] = ACTIONS(375),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(375),
    [anon_sym_BQUOTE] = ACTIONS(375),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(375),
    [anon_sym_CR] = ACTIONS(375),
    [sym_file_descriptor] = ACTIONS(375),
  },
  [125] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(128),
    [ts_builtin_sym_end] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_PIPEH] = ACTIONS(358),
    [anon_sym_PIPET] = ACTIONS(358),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATi] = ACTIONS(358),
    [anon_sym_AT_AT_ATr] = ACTIONS(358),
    [anon_sym_AT_AT_ATs] = ACTIONS(360),
    [anon_sym_AT_AT_ATst] = ACTIONS(358),
    [anon_sym_AT_AT_ATS] = ACTIONS(358),
    [anon_sym_AT_AT_ATm] = ACTIONS(358),
    [anon_sym_AT_AT_ATM] = ACTIONS(358),
    [anon_sym_AT_AT_ATf] = ACTIONS(360),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATF] = ACTIONS(360),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_AT] = ACTIONS(360),
    [anon_sym_AT_ATdbt] = ACTIONS(360),
    [anon_sym_AT_ATdbta] = ACTIONS(358),
    [anon_sym_AT_ATdbtb] = ACTIONS(358),
    [anon_sym_AT_ATdbts] = ACTIONS(358),
    [anon_sym_AT_AT_DOT] = ACTIONS(358),
    [anon_sym_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_ATk] = ACTIONS(358),
    [anon_sym_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_ATi] = ACTIONS(360),
    [anon_sym_AT_ATiS] = ACTIONS(358),
    [anon_sym_AT_ATf] = ACTIONS(358),
    [anon_sym_AT_ATs_COLON] = ACTIONS(358),
    [anon_sym_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_AT_BANG] = ACTIONS(358),
    [anon_sym_AT_LBRACE] = ACTIONS(358),
    [anon_sym_ATa_COLON] = ACTIONS(358),
    [anon_sym_ATb_COLON] = ACTIONS(358),
    [anon_sym_ATB_COLON] = ACTIONS(358),
    [anon_sym_ATe_COLON] = ACTIONS(358),
    [anon_sym_ATF_COLON] = ACTIONS(358),
    [anon_sym_ATi_COLON] = ACTIONS(358),
    [anon_sym_ATk_COLON] = ACTIONS(358),
    [anon_sym_ATo_COLON] = ACTIONS(358),
    [anon_sym_ATr_COLON] = ACTIONS(358),
    [anon_sym_ATf_COLON] = ACTIONS(358),
    [anon_sym_ATs_COLON] = ACTIONS(358),
    [anon_sym_ATx_COLON] = ACTIONS(358),
    [anon_sym_PIPE_DOT] = ACTIONS(358),
    [anon_sym_EQ] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(358),
    [sym_html_redirect_operator] = ACTIONS(360),
    [sym_html_append_operator] = ACTIONS(358),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(358),
    [anon_sym_CR] = ACTIONS(358),
    [sym_file_descriptor] = ACTIONS(358),
    [sym__concat_pf_dot] = ACTIONS(358),
  },
  [126] = {
    [aux_sym_tmp_eval_arg_repeat1] = STATE(121),
    [ts_builtin_sym_end] = ACTIONS(447),
    [anon_sym_TILDE] = ACTIONS(447),
    [anon_sym_PIPE] = ACTIONS(449),
    [anon_sym_PIPEH] = ACTIONS(447),
    [anon_sym_PIPET] = ACTIONS(447),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(447),
    [anon_sym_AT_AT_ATb] = ACTIONS(447),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(447),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(447),
    [anon_sym_AT_AT_ATi] = ACTIONS(447),
    [anon_sym_AT_AT_ATr] = ACTIONS(447),
    [anon_sym_AT_AT_ATs] = ACTIONS(449),
    [anon_sym_AT_AT_ATst] = ACTIONS(447),
    [anon_sym_AT_AT_ATS] = ACTIONS(447),
    [anon_sym_AT_AT_ATm] = ACTIONS(447),
    [anon_sym_AT_AT_ATM] = ACTIONS(447),
    [anon_sym_AT_AT_ATf] = ACTIONS(449),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(447),
    [anon_sym_AT_AT_ATF] = ACTIONS(449),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(447),
    [anon_sym_AT_AT_ATt] = ACTIONS(447),
    [anon_sym_AT_AT] = ACTIONS(449),
    [anon_sym_AT_ATdbt] = ACTIONS(449),
    [anon_sym_AT_ATdbta] = ACTIONS(447),
    [anon_sym_AT_ATdbtb] = ACTIONS(447),
    [anon_sym_AT_ATdbts] = ACTIONS(447),
    [anon_sym_AT_AT_DOT] = ACTIONS(447),
    [anon_sym_AT_AT_EQ] = ACTIONS(447),
    [anon_sym_AT_ATk] = ACTIONS(447),
    [anon_sym_AT_ATt] = ACTIONS(447),
    [anon_sym_AT_ATb] = ACTIONS(447),
    [anon_sym_AT_ATi] = ACTIONS(449),
    [anon_sym_AT_ATiS] = ACTIONS(447),
    [anon_sym_AT_ATf] = ACTIONS(447),
    [anon_sym_AT_ATs_COLON] = ACTIONS(447),
    [anon_sym_AT_ATc_COLON] = ACTIONS(447),
    [anon_sym_AT] = ACTIONS(449),
    [anon_sym_AT_BANG] = ACTIONS(447),
    [anon_sym_AT_LBRACE] = ACTIONS(447),
    [anon_sym_ATa_COLON] = ACTIONS(447),
    [anon_sym_ATb_COLON] = ACTIONS(447),
    [anon_sym_ATB_COLON] = ACTIONS(447),
    [anon_sym_ATe_COLON] = ACTIONS(447),
    [anon_sym_ATF_COLON] = ACTIONS(447),
    [anon_sym_ATi_COLON] = ACTIONS(447),
    [anon_sym_ATk_COLON] = ACTIONS(447),
    [anon_sym_ATo_COLON] = ACTIONS(447),
    [anon_sym_ATr_COLON] = ACTIONS(447),
    [anon_sym_ATf_COLON] = ACTIONS(447),
    [anon_sym_ATs_COLON] = ACTIONS(447),
    [anon_sym_ATx_COLON] = ACTIONS(447),
    [anon_sym_PIPE_DOT] = ACTIONS(447),
    [anon_sym_RPAREN] = ACTIONS(447),
    [anon_sym_SEMI] = ACTIONS(447),
    [anon_sym_GT] = ACTIONS(449),
    [anon_sym_GT_GT] = ACTIONS(447),
    [sym_html_redirect_operator] = ACTIONS(449),
    [sym_html_append_operator] = ACTIONS(447),
    [anon_sym_COMMA] = ACTIONS(447),
    [aux_sym_tmp_eval_arg_token1] = ACTIONS(451),
    [anon_sym_BQUOTE] = ACTIONS(447),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(447),
    [anon_sym_CR] = ACTIONS(447),
    [sym_file_descriptor] = ACTIONS(447),
  },
  [127] = {
    [aux_sym_eq_sep_key_repeat1] = STATE(130),
    [ts_builtin_sym_end] = ACTIONS(453),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_PIPEH] = ACTIONS(453),
    [anon_sym_PIPET] = ACTIONS(453),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(453),
    [anon_sym_AT_AT_ATb] = ACTIONS(453),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(453),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(453),
    [anon_sym_AT_AT_ATi] = ACTIONS(453),
    [anon_sym_AT_AT_ATr] = ACTIONS(453),
    [anon_sym_AT_AT_ATs] = ACTIONS(455),
    [anon_sym_AT_AT_ATst] = ACTIONS(453),
    [anon_sym_AT_AT_ATS] = ACTIONS(453),
    [anon_sym_AT_AT_ATm] = ACTIONS(453),
    [anon_sym_AT_AT_ATM] = ACTIONS(453),
    [anon_sym_AT_AT_ATf] = ACTIONS(455),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(453),
    [anon_sym_AT_AT_ATF] = ACTIONS(455),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(453),
    [anon_sym_AT_AT_ATt] = ACTIONS(453),
    [anon_sym_AT_AT] = ACTIONS(455),
    [anon_sym_AT_ATdbt] = ACTIONS(455),
    [anon_sym_AT_ATdbta] = ACTIONS(453),
    [anon_sym_AT_ATdbtb] = ACTIONS(453),
    [anon_sym_AT_ATdbts] = ACTIONS(453),
    [anon_sym_AT_AT_DOT] = ACTIONS(453),
    [anon_sym_AT_AT_EQ] = ACTIONS(453),
    [anon_sym_AT_ATk] = ACTIONS(453),
    [anon_sym_AT_ATt] = ACTIONS(453),
    [anon_sym_AT_ATb] = ACTIONS(453),
    [anon_sym_AT_ATi] = ACTIONS(455),
    [anon_sym_AT_ATiS] = ACTIONS(453),
    [anon_sym_AT_ATf] = ACTIONS(453),
    [anon_sym_AT_ATs_COLON] = ACTIONS(453),
    [anon_sym_AT_ATc_COLON] = ACTIONS(453),
    [anon_sym_AT] = ACTIONS(455),
    [anon_sym_AT_BANG] = ACTIONS(453),
    [anon_sym_AT_LBRACE] = ACTIONS(453),
    [anon_sym_ATa_COLON] = ACTIONS(453),
    [anon_sym_ATb_COLON] = ACTIONS(453),
    [anon_sym_ATB_COLON] = ACTIONS(453),
    [anon_sym_ATe_COLON] = ACTIONS(453),
    [anon_sym_ATF_COLON] = ACTIONS(453),
    [anon_sym_ATi_COLON] = ACTIONS(453),
    [anon_sym_ATk_COLON] = ACTIONS(453),
    [anon_sym_ATo_COLON] = ACTIONS(453),
    [anon_sym_ATr_COLON] = ACTIONS(453),
    [anon_sym_ATf_COLON] = ACTIONS(453),
    [anon_sym_ATs_COLON] = ACTIONS(453),
    [anon_sym_ATx_COLON] = ACTIONS(453),
    [anon_sym_PIPE_DOT] = ACTIONS(453),
    [anon_sym_EQ] = ACTIONS(453),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_SEMI] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_GT] = ACTIONS(453),
    [sym_html_redirect_operator] = ACTIONS(455),
    [sym_html_append_operator] = ACTIONS(453),
    [anon_sym_BQUOTE] = ACTIONS(453),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(453),
    [anon_sym_CR] = ACTIONS(453),
    [sym_file_descriptor] = ACTIONS(453),
    [sym__eq_sep_concat] = ACTIONS(445),
  },
  [128] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(129),
    [ts_builtin_sym_end] = ACTIONS(362),
    [anon_sym_TILDE] = ACTIONS(362),
    [anon_sym_PIPE] = ACTIONS(364),
    [anon_sym_PIPEH] = ACTIONS(362),
    [anon_sym_PIPET] = ACTIONS(362),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(362),
    [anon_sym_AT_AT_ATb] = ACTIONS(362),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(362),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(362),
    [anon_sym_AT_AT_ATi] = ACTIONS(362),
    [anon_sym_AT_AT_ATr] = ACTIONS(362),
    [anon_sym_AT_AT_ATs] = ACTIONS(364),
    [anon_sym_AT_AT_ATst] = ACTIONS(362),
    [anon_sym_AT_AT_ATS] = ACTIONS(362),
    [anon_sym_AT_AT_ATm] = ACTIONS(362),
    [anon_sym_AT_AT_ATM] = ACTIONS(362),
    [anon_sym_AT_AT_ATf] = ACTIONS(364),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(362),
    [anon_sym_AT_AT_ATF] = ACTIONS(364),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(362),
    [anon_sym_AT_AT_ATt] = ACTIONS(362),
    [anon_sym_AT_AT] = ACTIONS(364),
    [anon_sym_AT_ATdbt] = ACTIONS(364),
    [anon_sym_AT_ATdbta] = ACTIONS(362),
    [anon_sym_AT_ATdbtb] = ACTIONS(362),
    [anon_sym_AT_ATdbts] = ACTIONS(362),
    [anon_sym_AT_AT_DOT] = ACTIONS(362),
    [anon_sym_AT_AT_EQ] = ACTIONS(362),
    [anon_sym_AT_ATk] = ACTIONS(362),
    [anon_sym_AT_ATt] = ACTIONS(362),
    [anon_sym_AT_ATb] = ACTIONS(362),
    [anon_sym_AT_ATi] = ACTIONS(364),
    [anon_sym_AT_ATiS] = ACTIONS(362),
    [anon_sym_AT_ATf] = ACTIONS(362),
    [anon_sym_AT_ATs_COLON] = ACTIONS(362),
    [anon_sym_AT_ATc_COLON] = ACTIONS(362),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_AT_BANG] = ACTIONS(362),
    [anon_sym_AT_LBRACE] = ACTIONS(362),
    [anon_sym_ATa_COLON] = ACTIONS(362),
    [anon_sym_ATb_COLON] = ACTIONS(362),
    [anon_sym_ATB_COLON] = ACTIONS(362),
    [anon_sym_ATe_COLON] = ACTIONS(362),
    [anon_sym_ATF_COLON] = ACTIONS(362),
    [anon_sym_ATi_COLON] = ACTIONS(362),
    [anon_sym_ATk_COLON] = ACTIONS(362),
    [anon_sym_ATo_COLON] = ACTIONS(362),
    [anon_sym_ATr_COLON] = ACTIONS(362),
    [anon_sym_ATf_COLON] = ACTIONS(362),
    [anon_sym_ATs_COLON] = ACTIONS(362),
    [anon_sym_ATx_COLON] = ACTIONS(362),
    [anon_sym_PIPE_DOT] = ACTIONS(362),
    [anon_sym_EQ] = ACTIONS(362),
    [anon_sym_RPAREN] = ACTIONS(362),
    [anon_sym_SEMI] = ACTIONS(362),
    [anon_sym_GT] = ACTIONS(364),
    [anon_sym_GT_GT] = ACTIONS(362),
    [sym_html_redirect_operator] = ACTIONS(364),
    [sym_html_append_operator] = ACTIONS(362),
    [anon_sym_BQUOTE] = ACTIONS(362),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(362),
    [anon_sym_CR] = ACTIONS(362),
    [sym_file_descriptor] = ACTIONS(362),
    [sym__concat_pf_dot] = ACTIONS(457),
  },
  [129] = {
    [aux_sym_pf_dot_concatenation_repeat1] = STATE(129),
    [ts_builtin_sym_end] = ACTIONS(368),
    [anon_sym_TILDE] = ACTIONS(368),
    [anon_sym_PIPE] = ACTIONS(370),
    [anon_sym_PIPEH] = ACTIONS(368),
    [anon_sym_PIPET] = ACTIONS(368),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(368),
    [anon_sym_AT_AT_ATb] = ACTIONS(368),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATi] = ACTIONS(368),
    [anon_sym_AT_AT_ATr] = ACTIONS(368),
    [anon_sym_AT_AT_ATs] = ACTIONS(370),
    [anon_sym_AT_AT_ATst] = ACTIONS(368),
    [anon_sym_AT_AT_ATS] = ACTIONS(368),
    [anon_sym_AT_AT_ATm] = ACTIONS(368),
    [anon_sym_AT_AT_ATM] = ACTIONS(368),
    [anon_sym_AT_AT_ATf] = ACTIONS(370),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATF] = ACTIONS(370),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATt] = ACTIONS(368),
    [anon_sym_AT_AT] = ACTIONS(370),
    [anon_sym_AT_ATdbt] = ACTIONS(370),
    [anon_sym_AT_ATdbta] = ACTIONS(368),
    [anon_sym_AT_ATdbtb] = ACTIONS(368),
    [anon_sym_AT_ATdbts] = ACTIONS(368),
    [anon_sym_AT_AT_DOT] = ACTIONS(368),
    [anon_sym_AT_AT_EQ] = ACTIONS(368),
    [anon_sym_AT_ATk] = ACTIONS(368),
    [anon_sym_AT_ATt] = ACTIONS(368),
    [anon_sym_AT_ATb] = ACTIONS(368),
    [anon_sym_AT_ATi] = ACTIONS(370),
    [anon_sym_AT_ATiS] = ACTIONS(368),
    [anon_sym_AT_ATf] = ACTIONS(368),
    [anon_sym_AT_ATs_COLON] = ACTIONS(368),
    [anon_sym_AT_ATc_COLON] = ACTIONS(368),
    [anon_sym_AT] = ACTIONS(370),
    [anon_sym_AT_BANG] = ACTIONS(368),
    [anon_sym_AT_LBRACE] = ACTIONS(368),
    [anon_sym_ATa_COLON] = ACTIONS(368),
    [anon_sym_ATb_COLON] = ACTIONS(368),
    [anon_sym_ATB_COLON] = ACTIONS(368),
    [anon_sym_ATe_COLON] = ACTIONS(368),
    [anon_sym_ATF_COLON] = ACTIONS(368),
    [anon_sym_ATi_COLON] = ACTIONS(368),
    [anon_sym_ATk_COLON] = ACTIONS(368),
    [anon_sym_ATo_COLON] = ACTIONS(368),
    [anon_sym_ATr_COLON] = ACTIONS(368),
    [anon_sym_ATf_COLON] = ACTIONS(368),
    [anon_sym_ATs_COLON] = ACTIONS(368),
    [anon_sym_ATx_COLON] = ACTIONS(368),
    [anon_sym_PIPE_DOT] = ACTIONS(368),
    [anon_sym_EQ] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym_GT] = ACTIONS(370),
    [anon_sym_GT_GT] = ACTIONS(368),
    [sym_html_redirect_operator] = ACTIONS(370),
    [sym_html_append_operator] = ACTIONS(368),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(368),
    [anon_sym_CR] = ACTIONS(368),
    [sym_file_descriptor] = ACTIONS(368),
    [sym__concat_pf_dot] = ACTIONS(459),
  },
  [130] = {
    [aux_sym_eq_sep_key_repeat1] = STATE(130),
    [ts_builtin_sym_end] = ACTIONS(462),
    [anon_sym_TILDE] = ACTIONS(462),
    [anon_sym_PIPE] = ACTIONS(464),
    [anon_sym_PIPEH] = ACTIONS(462),
    [anon_sym_PIPET] = ACTIONS(462),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(462),
    [anon_sym_AT_AT_ATb] = ACTIONS(462),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATi] = ACTIONS(462),
    [anon_sym_AT_AT_ATr] = ACTIONS(462),
    [anon_sym_AT_AT_ATs] = ACTIONS(464),
    [anon_sym_AT_AT_ATst] = ACTIONS(462),
    [anon_sym_AT_AT_ATS] = ACTIONS(462),
    [anon_sym_AT_AT_ATm] = ACTIONS(462),
    [anon_sym_AT_AT_ATM] = ACTIONS(462),
    [anon_sym_AT_AT_ATf] = ACTIONS(464),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATF] = ACTIONS(464),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATt] = ACTIONS(462),
    [anon_sym_AT_AT] = ACTIONS(464),
    [anon_sym_AT_ATdbt] = ACTIONS(464),
    [anon_sym_AT_ATdbta] = ACTIONS(462),
    [anon_sym_AT_ATdbtb] = ACTIONS(462),
    [anon_sym_AT_ATdbts] = ACTIONS(462),
    [anon_sym_AT_AT_DOT] = ACTIONS(462),
    [anon_sym_AT_AT_EQ] = ACTIONS(462),
    [anon_sym_AT_ATk] = ACTIONS(462),
    [anon_sym_AT_ATt] = ACTIONS(462),
    [anon_sym_AT_ATb] = ACTIONS(462),
    [anon_sym_AT_ATi] = ACTIONS(464),
    [anon_sym_AT_ATiS] = ACTIONS(462),
    [anon_sym_AT_ATf] = ACTIONS(462),
    [anon_sym_AT_ATs_COLON] = ACTIONS(462),
    [anon_sym_AT_ATc_COLON] = ACTIONS(462),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_AT_BANG] = ACTIONS(462),
    [anon_sym_AT_LBRACE] = ACTIONS(462),
    [anon_sym_ATa_COLON] = ACTIONS(462),
    [anon_sym_ATb_COLON] = ACTIONS(462),
    [anon_sym_ATB_COLON] = ACTIONS(462),
    [anon_sym_ATe_COLON] = ACTIONS(462),
    [anon_sym_ATF_COLON] = ACTIONS(462),
    [anon_sym_ATi_COLON] = ACTIONS(462),
    [anon_sym_ATk_COLON] = ACTIONS(462),
    [anon_sym_ATo_COLON] = ACTIONS(462),
    [anon_sym_ATr_COLON] = ACTIONS(462),
    [anon_sym_ATf_COLON] = ACTIONS(462),
    [anon_sym_ATs_COLON] = ACTIONS(462),
    [anon_sym_ATx_COLON] = ACTIONS(462),
    [anon_sym_PIPE_DOT] = ACTIONS(462),
    [anon_sym_EQ] = ACTIONS(462),
    [anon_sym_RPAREN] = ACTIONS(462),
    [anon_sym_SEMI] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(464),
    [anon_sym_GT_GT] = ACTIONS(462),
    [sym_html_redirect_operator] = ACTIONS(464),
    [sym_html_append_operator] = ACTIONS(462),
    [anon_sym_BQUOTE] = ACTIONS(462),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(462),
    [anon_sym_CR] = ACTIONS(462),
    [sym_file_descriptor] = ACTIONS(462),
    [sym__eq_sep_concat] = ACTIONS(466),
  },
  [131] = {
    [aux_sym_concatenation_repeat1] = STATE(131),
    [ts_builtin_sym_end] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_PIPEH] = ACTIONS(319),
    [anon_sym_PIPET] = ACTIONS(319),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATi] = ACTIONS(319),
    [anon_sym_AT_AT_ATr] = ACTIONS(319),
    [anon_sym_AT_AT_ATs] = ACTIONS(321),
    [anon_sym_AT_AT_ATst] = ACTIONS(319),
    [anon_sym_AT_AT_ATS] = ACTIONS(319),
    [anon_sym_AT_AT_ATm] = ACTIONS(319),
    [anon_sym_AT_AT_ATM] = ACTIONS(319),
    [anon_sym_AT_AT_ATf] = ACTIONS(321),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATF] = ACTIONS(321),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_AT] = ACTIONS(321),
    [anon_sym_AT_ATdbt] = ACTIONS(321),
    [anon_sym_AT_ATdbta] = ACTIONS(319),
    [anon_sym_AT_ATdbtb] = ACTIONS(319),
    [anon_sym_AT_ATdbts] = ACTIONS(319),
    [anon_sym_AT_AT_DOT] = ACTIONS(319),
    [anon_sym_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_ATk] = ACTIONS(319),
    [anon_sym_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_ATi] = ACTIONS(321),
    [anon_sym_AT_ATiS] = ACTIONS(319),
    [anon_sym_AT_ATf] = ACTIONS(319),
    [anon_sym_AT_ATs_COLON] = ACTIONS(319),
    [anon_sym_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_AT_BANG] = ACTIONS(319),
    [anon_sym_AT_LBRACE] = ACTIONS(319),
    [anon_sym_ATa_COLON] = ACTIONS(319),
    [anon_sym_ATb_COLON] = ACTIONS(319),
    [anon_sym_ATB_COLON] = ACTIONS(319),
    [anon_sym_ATe_COLON] = ACTIONS(319),
    [anon_sym_ATF_COLON] = ACTIONS(319),
    [anon_sym_ATi_COLON] = ACTIONS(319),
    [anon_sym_ATk_COLON] = ACTIONS(319),
    [anon_sym_ATo_COLON] = ACTIONS(319),
    [anon_sym_ATr_COLON] = ACTIONS(319),
    [anon_sym_ATf_COLON] = ACTIONS(319),
    [anon_sym_ATs_COLON] = ACTIONS(319),
    [anon_sym_ATx_COLON] = ACTIONS(319),
    [anon_sym_PIPE_DOT] = ACTIONS(319),
    [anon_sym_RPAREN] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(321),
    [anon_sym_GT_GT] = ACTIONS(319),
    [sym_html_redirect_operator] = ACTIONS(321),
    [sym_html_append_operator] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_CR] = ACTIONS(319),
    [sym_file_descriptor] = ACTIONS(319),
    [sym__eq_sep_concat] = ACTIONS(319),
    [sym__concat] = ACTIONS(469),
  },
  [132] = {
    [aux_sym_pf_dot_args_repeat1] = STATE(133),
    [ts_builtin_sym_end] = ACTIONS(228),
    [anon_sym_TILDE] = ACTIONS(228),
    [anon_sym_PIPE] = ACTIONS(230),
    [anon_sym_PIPEH] = ACTIONS(228),
    [anon_sym_PIPET] = ACTIONS(228),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(228),
    [anon_sym_AT_AT_ATb] = ACTIONS(228),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATi] = ACTIONS(228),
    [anon_sym_AT_AT_ATr] = ACTIONS(228),
    [anon_sym_AT_AT_ATs] = ACTIONS(230),
    [anon_sym_AT_AT_ATst] = ACTIONS(228),
    [anon_sym_AT_AT_ATS] = ACTIONS(228),
    [anon_sym_AT_AT_ATm] = ACTIONS(228),
    [anon_sym_AT_AT_ATM] = ACTIONS(228),
    [anon_sym_AT_AT_ATf] = ACTIONS(230),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATF] = ACTIONS(230),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(228),
    [anon_sym_AT_AT_ATt] = ACTIONS(228),
    [anon_sym_AT_AT] = ACTIONS(230),
    [anon_sym_AT_ATdbt] = ACTIONS(230),
    [anon_sym_AT_ATdbta] = ACTIONS(228),
    [anon_sym_AT_ATdbtb] = ACTIONS(228),
    [anon_sym_AT_ATdbts] = ACTIONS(228),
    [anon_sym_AT_AT_DOT] = ACTIONS(228),
    [anon_sym_AT_AT_EQ] = ACTIONS(228),
    [anon_sym_AT_ATk] = ACTIONS(228),
    [anon_sym_AT_ATt] = ACTIONS(228),
    [anon_sym_AT_ATb] = ACTIONS(228),
    [anon_sym_AT_ATi] = ACTIONS(230),
    [anon_sym_AT_ATiS] = ACTIONS(228),
    [anon_sym_AT_ATf] = ACTIONS(228),
    [anon_sym_AT_ATs_COLON] = ACTIONS(228),
    [anon_sym_AT_ATc_COLON] = ACTIONS(228),
    [anon_sym_AT] = ACTIONS(230),
    [anon_sym_AT_BANG] = ACTIONS(228),
    [anon_sym_AT_LBRACE] = ACTIONS(228),
    [anon_sym_ATa_COLON] = ACTIONS(228),
    [anon_sym_ATb_COLON] = ACTIONS(228),
    [anon_sym_ATB_COLON] = ACTIONS(228),
    [anon_sym_ATe_COLON] = ACTIONS(228),
    [anon_sym_ATF_COLON] = ACTIONS(228),
    [anon_sym_ATi_COLON] = ACTIONS(228),
    [anon_sym_ATk_COLON] = ACTIONS(228),
    [anon_sym_ATo_COLON] = ACTIONS(228),
    [anon_sym_ATr_COLON] = ACTIONS(228),
    [anon_sym_ATf_COLON] = ACTIONS(228),
    [anon_sym_ATs_COLON] = ACTIONS(228),
    [anon_sym_ATx_COLON] = ACTIONS(228),
    [anon_sym_PIPE_DOT] = ACTIONS(228),
    [anon_sym_EQ] = ACTIONS(228),
    [anon_sym_RPAREN] = ACTIONS(228),
    [anon_sym_SEMI] = ACTIONS(228),
    [anon_sym_GT] = ACTIONS(230),
    [anon_sym_GT_GT] = ACTIONS(228),
    [sym_html_redirect_operator] = ACTIONS(230),
    [sym_html_append_operator] = ACTIONS(228),
    [anon_sym_BQUOTE] = ACTIONS(228),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(228),
    [anon_sym_CR] = ACTIONS(228),
    [sym_file_descriptor] = ACTIONS(228),
    [sym__concat_pf_dot] = ACTIONS(240),
  },
  [133] = {
    [aux_sym_pf_dot_args_repeat1] = STATE(122),
    [ts_builtin_sym_end] = ACTIONS(472),
    [anon_sym_TILDE] = ACTIONS(472),
    [anon_sym_PIPE] = ACTIONS(474),
    [anon_sym_PIPEH] = ACTIONS(472),
    [anon_sym_PIPET] = ACTIONS(472),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(472),
    [anon_sym_AT_AT_ATb] = ACTIONS(472),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(472),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(472),
    [anon_sym_AT_AT_ATi] = ACTIONS(472),
    [anon_sym_AT_AT_ATr] = ACTIONS(472),
    [anon_sym_AT_AT_ATs] = ACTIONS(474),
    [anon_sym_AT_AT_ATst] = ACTIONS(472),
    [anon_sym_AT_AT_ATS] = ACTIONS(472),
    [anon_sym_AT_AT_ATm] = ACTIONS(472),
    [anon_sym_AT_AT_ATM] = ACTIONS(472),
    [anon_sym_AT_AT_ATf] = ACTIONS(474),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(472),
    [anon_sym_AT_AT_ATF] = ACTIONS(474),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(472),
    [anon_sym_AT_AT_ATt] = ACTIONS(472),
    [anon_sym_AT_AT] = ACTIONS(474),
    [anon_sym_AT_ATdbt] = ACTIONS(474),
    [anon_sym_AT_ATdbta] = ACTIONS(472),
    [anon_sym_AT_ATdbtb] = ACTIONS(472),
    [anon_sym_AT_ATdbts] = ACTIONS(472),
    [anon_sym_AT_AT_DOT] = ACTIONS(472),
    [anon_sym_AT_AT_EQ] = ACTIONS(472),
    [anon_sym_AT_ATk] = ACTIONS(472),
    [anon_sym_AT_ATt] = ACTIONS(472),
    [anon_sym_AT_ATb] = ACTIONS(472),
    [anon_sym_AT_ATi] = ACTIONS(474),
    [anon_sym_AT_ATiS] = ACTIONS(472),
    [anon_sym_AT_ATf] = ACTIONS(472),
    [anon_sym_AT_ATs_COLON] = ACTIONS(472),
    [anon_sym_AT_ATc_COLON] = ACTIONS(472),
    [anon_sym_AT] = ACTIONS(474),
    [anon_sym_AT_BANG] = ACTIONS(472),
    [anon_sym_AT_LBRACE] = ACTIONS(472),
    [anon_sym_ATa_COLON] = ACTIONS(472),
    [anon_sym_ATb_COLON] = ACTIONS(472),
    [anon_sym_ATB_COLON] = ACTIONS(472),
    [anon_sym_ATe_COLON] = ACTIONS(472),
    [anon_sym_ATF_COLON] = ACTIONS(472),
    [anon_sym_ATi_COLON] = ACTIONS(472),
    [anon_sym_ATk_COLON] = ACTIONS(472),
    [anon_sym_ATo_COLON] = ACTIONS(472),
    [anon_sym_ATr_COLON] = ACTIONS(472),
    [anon_sym_ATf_COLON] = ACTIONS(472),
    [anon_sym_ATs_COLON] = ACTIONS(472),
    [anon_sym_ATx_COLON] = ACTIONS(472),
    [anon_sym_PIPE_DOT] = ACTIONS(472),
    [anon_sym_EQ] = ACTIONS(472),
    [anon_sym_RPAREN] = ACTIONS(472),
    [anon_sym_SEMI] = ACTIONS(472),
    [anon_sym_GT] = ACTIONS(474),
    [anon_sym_GT_GT] = ACTIONS(472),
    [sym_html_redirect_operator] = ACTIONS(474),
    [sym_html_append_operator] = ACTIONS(472),
    [anon_sym_BQUOTE] = ACTIONS(472),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(472),
    [anon_sym_CR] = ACTIONS(472),
    [sym_file_descriptor] = ACTIONS(472),
    [sym__concat_pf_dot] = ACTIONS(240),
  },
  [134] = {
    [aux_sym_concatenation_repeat1] = STATE(135),
    [ts_builtin_sym_end] = ACTIONS(315),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_PIPE] = ACTIONS(317),
    [anon_sym_PIPEH] = ACTIONS(315),
    [anon_sym_PIPET] = ACTIONS(315),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(315),
    [anon_sym_AT_AT_ATb] = ACTIONS(315),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATi] = ACTIONS(315),
    [anon_sym_AT_AT_ATr] = ACTIONS(315),
    [anon_sym_AT_AT_ATs] = ACTIONS(317),
    [anon_sym_AT_AT_ATst] = ACTIONS(315),
    [anon_sym_AT_AT_ATS] = ACTIONS(315),
    [anon_sym_AT_AT_ATm] = ACTIONS(315),
    [anon_sym_AT_AT_ATM] = ACTIONS(315),
    [anon_sym_AT_AT_ATf] = ACTIONS(317),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATF] = ACTIONS(317),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATt] = ACTIONS(315),
    [anon_sym_AT_AT] = ACTIONS(317),
    [anon_sym_AT_ATdbt] = ACTIONS(317),
    [anon_sym_AT_ATdbta] = ACTIONS(315),
    [anon_sym_AT_ATdbtb] = ACTIONS(315),
    [anon_sym_AT_ATdbts] = ACTIONS(315),
    [anon_sym_AT_AT_DOT] = ACTIONS(315),
    [anon_sym_AT_AT_EQ] = ACTIONS(315),
    [anon_sym_AT_ATk] = ACTIONS(315),
    [anon_sym_AT_ATt] = ACTIONS(315),
    [anon_sym_AT_ATb] = ACTIONS(315),
    [anon_sym_AT_ATi] = ACTIONS(317),
    [anon_sym_AT_ATiS] = ACTIONS(315),
    [anon_sym_AT_ATf] = ACTIONS(315),
    [anon_sym_AT_ATs_COLON] = ACTIONS(315),
    [anon_sym_AT_ATc_COLON] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_AT_BANG] = ACTIONS(315),
    [anon_sym_AT_LBRACE] = ACTIONS(315),
    [anon_sym_ATa_COLON] = ACTIONS(315),
    [anon_sym_ATb_COLON] = ACTIONS(315),
    [anon_sym_ATB_COLON] = ACTIONS(315),
    [anon_sym_ATe_COLON] = ACTIONS(315),
    [anon_sym_ATF_COLON] = ACTIONS(315),
    [anon_sym_ATi_COLON] = ACTIONS(315),
    [anon_sym_ATk_COLON] = ACTIONS(315),
    [anon_sym_ATo_COLON] = ACTIONS(315),
    [anon_sym_ATr_COLON] = ACTIONS(315),
    [anon_sym_ATf_COLON] = ACTIONS(315),
    [anon_sym_ATs_COLON] = ACTIONS(315),
    [anon_sym_ATx_COLON] = ACTIONS(315),
    [anon_sym_PIPE_DOT] = ACTIONS(315),
    [anon_sym_RPAREN] = ACTIONS(315),
    [anon_sym_SEMI] = ACTIONS(315),
    [anon_sym_GT] = ACTIONS(317),
    [anon_sym_GT_GT] = ACTIONS(315),
    [sym_html_redirect_operator] = ACTIONS(317),
    [sym_html_append_operator] = ACTIONS(315),
    [anon_sym_BQUOTE] = ACTIONS(315),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(315),
    [anon_sym_CR] = ACTIONS(315),
    [sym_file_descriptor] = ACTIONS(315),
    [sym__eq_sep_concat] = ACTIONS(315),
    [sym__concat] = ACTIONS(476),
  },
  [135] = {
    [aux_sym_concatenation_repeat1] = STATE(131),
    [ts_builtin_sym_end] = ACTIONS(309),
    [anon_sym_TILDE] = ACTIONS(309),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_PIPEH] = ACTIONS(309),
    [anon_sym_PIPET] = ACTIONS(309),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(309),
    [anon_sym_AT_AT_ATb] = ACTIONS(309),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATi] = ACTIONS(309),
    [anon_sym_AT_AT_ATr] = ACTIONS(309),
    [anon_sym_AT_AT_ATs] = ACTIONS(311),
    [anon_sym_AT_AT_ATst] = ACTIONS(309),
    [anon_sym_AT_AT_ATS] = ACTIONS(309),
    [anon_sym_AT_AT_ATm] = ACTIONS(309),
    [anon_sym_AT_AT_ATM] = ACTIONS(309),
    [anon_sym_AT_AT_ATf] = ACTIONS(311),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATF] = ACTIONS(311),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATt] = ACTIONS(309),
    [anon_sym_AT_AT] = ACTIONS(311),
    [anon_sym_AT_ATdbt] = ACTIONS(311),
    [anon_sym_AT_ATdbta] = ACTIONS(309),
    [anon_sym_AT_ATdbtb] = ACTIONS(309),
    [anon_sym_AT_ATdbts] = ACTIONS(309),
    [anon_sym_AT_AT_DOT] = ACTIONS(309),
    [anon_sym_AT_AT_EQ] = ACTIONS(309),
    [anon_sym_AT_ATk] = ACTIONS(309),
    [anon_sym_AT_ATt] = ACTIONS(309),
    [anon_sym_AT_ATb] = ACTIONS(309),
    [anon_sym_AT_ATi] = ACTIONS(311),
    [anon_sym_AT_ATiS] = ACTIONS(309),
    [anon_sym_AT_ATf] = ACTIONS(309),
    [anon_sym_AT_ATs_COLON] = ACTIONS(309),
    [anon_sym_AT_ATc_COLON] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(311),
    [anon_sym_AT_BANG] = ACTIONS(309),
    [anon_sym_AT_LBRACE] = ACTIONS(309),
    [anon_sym_ATa_COLON] = ACTIONS(309),
    [anon_sym_ATb_COLON] = ACTIONS(309),
    [anon_sym_ATB_COLON] = ACTIONS(309),
    [anon_sym_ATe_COLON] = ACTIONS(309),
    [anon_sym_ATF_COLON] = ACTIONS(309),
    [anon_sym_ATi_COLON] = ACTIONS(309),
    [anon_sym_ATk_COLON] = ACTIONS(309),
    [anon_sym_ATo_COLON] = ACTIONS(309),
    [anon_sym_ATr_COLON] = ACTIONS(309),
    [anon_sym_ATf_COLON] = ACTIONS(309),
    [anon_sym_ATs_COLON] = ACTIONS(309),
    [anon_sym_ATx_COLON] = ACTIONS(309),
    [anon_sym_PIPE_DOT] = ACTIONS(309),
    [anon_sym_RPAREN] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_GT] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(309),
    [sym_html_redirect_operator] = ACTIONS(311),
    [sym_html_append_operator] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(309),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(309),
    [anon_sym_CR] = ACTIONS(309),
    [sym_file_descriptor] = ACTIONS(309),
    [sym__eq_sep_concat] = ACTIONS(309),
    [sym__concat] = ACTIONS(476),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(368),
    [anon_sym_TILDE] = ACTIONS(368),
    [anon_sym_PIPE] = ACTIONS(370),
    [anon_sym_PIPEH] = ACTIONS(368),
    [anon_sym_PIPET] = ACTIONS(368),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(368),
    [anon_sym_AT_AT_ATb] = ACTIONS(368),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATi] = ACTIONS(368),
    [anon_sym_AT_AT_ATr] = ACTIONS(368),
    [anon_sym_AT_AT_ATs] = ACTIONS(370),
    [anon_sym_AT_AT_ATst] = ACTIONS(368),
    [anon_sym_AT_AT_ATS] = ACTIONS(368),
    [anon_sym_AT_AT_ATm] = ACTIONS(368),
    [anon_sym_AT_AT_ATM] = ACTIONS(368),
    [anon_sym_AT_AT_ATf] = ACTIONS(370),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATF] = ACTIONS(370),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(368),
    [anon_sym_AT_AT_ATt] = ACTIONS(368),
    [anon_sym_AT_AT] = ACTIONS(370),
    [anon_sym_AT_ATdbt] = ACTIONS(370),
    [anon_sym_AT_ATdbta] = ACTIONS(368),
    [anon_sym_AT_ATdbtb] = ACTIONS(368),
    [anon_sym_AT_ATdbts] = ACTIONS(368),
    [anon_sym_AT_AT_DOT] = ACTIONS(368),
    [anon_sym_AT_AT_EQ] = ACTIONS(368),
    [anon_sym_AT_ATk] = ACTIONS(368),
    [anon_sym_AT_ATt] = ACTIONS(368),
    [anon_sym_AT_ATb] = ACTIONS(368),
    [anon_sym_AT_ATi] = ACTIONS(370),
    [anon_sym_AT_ATiS] = ACTIONS(368),
    [anon_sym_AT_ATf] = ACTIONS(368),
    [anon_sym_AT_ATs_COLON] = ACTIONS(368),
    [anon_sym_AT_ATc_COLON] = ACTIONS(368),
    [anon_sym_AT] = ACTIONS(370),
    [anon_sym_AT_BANG] = ACTIONS(368),
    [anon_sym_AT_LBRACE] = ACTIONS(368),
    [anon_sym_ATa_COLON] = ACTIONS(368),
    [anon_sym_ATb_COLON] = ACTIONS(368),
    [anon_sym_ATB_COLON] = ACTIONS(368),
    [anon_sym_ATe_COLON] = ACTIONS(368),
    [anon_sym_ATF_COLON] = ACTIONS(368),
    [anon_sym_ATi_COLON] = ACTIONS(368),
    [anon_sym_ATk_COLON] = ACTIONS(368),
    [anon_sym_ATo_COLON] = ACTIONS(368),
    [anon_sym_ATr_COLON] = ACTIONS(368),
    [anon_sym_ATf_COLON] = ACTIONS(368),
    [anon_sym_ATs_COLON] = ACTIONS(368),
    [anon_sym_ATx_COLON] = ACTIONS(368),
    [anon_sym_PIPE_DOT] = ACTIONS(368),
    [anon_sym_EQ] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(368),
    [anon_sym_GT] = ACTIONS(370),
    [anon_sym_GT_GT] = ACTIONS(368),
    [sym_html_redirect_operator] = ACTIONS(370),
    [sym_html_append_operator] = ACTIONS(368),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(368),
    [anon_sym_CR] = ACTIONS(368),
    [sym_file_descriptor] = ACTIONS(368),
    [sym__concat_pf_dot] = ACTIONS(368),
  },
  [137] = {
    [ts_builtin_sym_end] = ACTIONS(330),
    [anon_sym_TILDE] = ACTIONS(330),
    [anon_sym_PIPE] = ACTIONS(332),
    [anon_sym_PIPEH] = ACTIONS(330),
    [anon_sym_PIPET] = ACTIONS(330),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(330),
    [anon_sym_AT_AT_ATb] = ACTIONS(330),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATi] = ACTIONS(330),
    [anon_sym_AT_AT_ATr] = ACTIONS(330),
    [anon_sym_AT_AT_ATs] = ACTIONS(332),
    [anon_sym_AT_AT_ATst] = ACTIONS(330),
    [anon_sym_AT_AT_ATS] = ACTIONS(330),
    [anon_sym_AT_AT_ATm] = ACTIONS(330),
    [anon_sym_AT_AT_ATM] = ACTIONS(330),
    [anon_sym_AT_AT_ATf] = ACTIONS(332),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATF] = ACTIONS(332),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATt] = ACTIONS(330),
    [anon_sym_AT_AT] = ACTIONS(332),
    [anon_sym_AT_ATdbt] = ACTIONS(332),
    [anon_sym_AT_ATdbta] = ACTIONS(330),
    [anon_sym_AT_ATdbtb] = ACTIONS(330),
    [anon_sym_AT_ATdbts] = ACTIONS(330),
    [anon_sym_AT_AT_DOT] = ACTIONS(330),
    [anon_sym_AT_AT_EQ] = ACTIONS(330),
    [anon_sym_AT_ATk] = ACTIONS(330),
    [anon_sym_AT_ATt] = ACTIONS(330),
    [anon_sym_AT_ATb] = ACTIONS(330),
    [anon_sym_AT_ATi] = ACTIONS(332),
    [anon_sym_AT_ATiS] = ACTIONS(330),
    [anon_sym_AT_ATf] = ACTIONS(330),
    [anon_sym_AT_ATs_COLON] = ACTIONS(330),
    [anon_sym_AT_ATc_COLON] = ACTIONS(330),
    [anon_sym_AT] = ACTIONS(332),
    [anon_sym_AT_BANG] = ACTIONS(330),
    [anon_sym_AT_LBRACE] = ACTIONS(330),
    [anon_sym_ATa_COLON] = ACTIONS(330),
    [anon_sym_ATb_COLON] = ACTIONS(330),
    [anon_sym_ATB_COLON] = ACTIONS(330),
    [anon_sym_ATe_COLON] = ACTIONS(330),
    [anon_sym_ATF_COLON] = ACTIONS(330),
    [anon_sym_ATi_COLON] = ACTIONS(330),
    [anon_sym_ATk_COLON] = ACTIONS(330),
    [anon_sym_ATo_COLON] = ACTIONS(330),
    [anon_sym_ATr_COLON] = ACTIONS(330),
    [anon_sym_ATf_COLON] = ACTIONS(330),
    [anon_sym_ATs_COLON] = ACTIONS(330),
    [anon_sym_ATx_COLON] = ACTIONS(330),
    [anon_sym_PIPE_DOT] = ACTIONS(330),
    [anon_sym_EQ] = ACTIONS(330),
    [anon_sym_RPAREN] = ACTIONS(330),
    [anon_sym_SEMI] = ACTIONS(330),
    [anon_sym_GT] = ACTIONS(332),
    [anon_sym_GT_GT] = ACTIONS(330),
    [sym_html_redirect_operator] = ACTIONS(332),
    [sym_html_append_operator] = ACTIONS(330),
    [anon_sym_BQUOTE] = ACTIONS(330),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(330),
    [anon_sym_CR] = ACTIONS(330),
    [sym_file_descriptor] = ACTIONS(330),
    [sym__eq_sep_concat] = ACTIONS(330),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [sym_grep_specifier_identifier] = ACTIONS(352),
    [aux_sym_grep_specifier_token1] = ACTIONS(352),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(352),
    [anon_sym_PIPET] = ACTIONS(352),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(352),
    [anon_sym_AT_AT_ATb] = ACTIONS(352),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_AT_ATr] = ACTIONS(352),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(352),
    [anon_sym_AT_AT_ATS] = ACTIONS(352),
    [anon_sym_AT_AT_ATm] = ACTIONS(352),
    [anon_sym_AT_AT_ATM] = ACTIONS(352),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATt] = ACTIONS(352),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(352),
    [anon_sym_AT_ATdbtb] = ACTIONS(352),
    [anon_sym_AT_ATdbts] = ACTIONS(352),
    [anon_sym_AT_AT_DOT] = ACTIONS(352),
    [anon_sym_AT_AT_EQ] = ACTIONS(352),
    [anon_sym_AT_ATk] = ACTIONS(352),
    [anon_sym_AT_ATt] = ACTIONS(352),
    [anon_sym_AT_ATb] = ACTIONS(352),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(352),
    [anon_sym_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_ATs_COLON] = ACTIONS(352),
    [anon_sym_AT_ATc_COLON] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(352),
    [anon_sym_AT_LBRACE] = ACTIONS(352),
    [anon_sym_ATa_COLON] = ACTIONS(352),
    [anon_sym_ATb_COLON] = ACTIONS(352),
    [anon_sym_ATB_COLON] = ACTIONS(352),
    [anon_sym_ATe_COLON] = ACTIONS(352),
    [anon_sym_ATF_COLON] = ACTIONS(352),
    [anon_sym_ATi_COLON] = ACTIONS(352),
    [anon_sym_ATk_COLON] = ACTIONS(352),
    [anon_sym_ATo_COLON] = ACTIONS(352),
    [anon_sym_ATr_COLON] = ACTIONS(352),
    [anon_sym_ATf_COLON] = ACTIONS(352),
    [anon_sym_ATs_COLON] = ACTIONS(352),
    [anon_sym_ATx_COLON] = ACTIONS(352),
    [anon_sym_PIPE_DOT] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(352),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(352),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(352),
    [anon_sym_BQUOTE] = ACTIONS(352),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(352),
    [anon_sym_CR] = ACTIONS(352),
    [sym_file_descriptor] = ACTIONS(350),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(352),
    [sym_grep_specifier_identifier] = ACTIONS(352),
    [aux_sym_grep_specifier_token1] = ACTIONS(352),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(352),
    [anon_sym_PIPET] = ACTIONS(352),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(352),
    [anon_sym_AT_AT_ATb] = ACTIONS(352),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_AT_ATr] = ACTIONS(352),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(352),
    [anon_sym_AT_AT_ATS] = ACTIONS(352),
    [anon_sym_AT_AT_ATm] = ACTIONS(352),
    [anon_sym_AT_AT_ATM] = ACTIONS(352),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(352),
    [anon_sym_AT_AT_ATt] = ACTIONS(352),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(352),
    [anon_sym_AT_ATdbtb] = ACTIONS(352),
    [anon_sym_AT_ATdbts] = ACTIONS(352),
    [anon_sym_AT_AT_DOT] = ACTIONS(352),
    [anon_sym_AT_AT_EQ] = ACTIONS(352),
    [anon_sym_AT_ATk] = ACTIONS(352),
    [anon_sym_AT_ATt] = ACTIONS(352),
    [anon_sym_AT_ATb] = ACTIONS(352),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(352),
    [anon_sym_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_ATs_COLON] = ACTIONS(352),
    [anon_sym_AT_ATc_COLON] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(352),
    [anon_sym_AT_LBRACE] = ACTIONS(352),
    [anon_sym_ATa_COLON] = ACTIONS(352),
    [anon_sym_ATb_COLON] = ACTIONS(352),
    [anon_sym_ATB_COLON] = ACTIONS(352),
    [anon_sym_ATe_COLON] = ACTIONS(352),
    [anon_sym_ATF_COLON] = ACTIONS(352),
    [anon_sym_ATi_COLON] = ACTIONS(352),
    [anon_sym_ATk_COLON] = ACTIONS(352),
    [anon_sym_ATo_COLON] = ACTIONS(352),
    [anon_sym_ATr_COLON] = ACTIONS(352),
    [anon_sym_ATf_COLON] = ACTIONS(352),
    [anon_sym_ATs_COLON] = ACTIONS(352),
    [anon_sym_ATx_COLON] = ACTIONS(352),
    [anon_sym_PIPE_DOT] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(352),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(352),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(352),
    [anon_sym_BQUOTE] = ACTIONS(352),
    [sym__comment] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(352),
    [anon_sym_CR] = ACTIONS(352),
    [sym_file_descriptor] = ACTIONS(350),
  },
  [140] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__eq_sep_concat] = ACTIONS(350),
    [sym__concat] = ACTIONS(350),
  },
  [141] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__eq_sep_concat] = ACTIONS(350),
    [sym__concat] = ACTIONS(350),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_EQ] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__concat_pf_dot] = ACTIONS(350),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_EQ] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__concat_pf_dot] = ACTIONS(350),
  },
  [144] = {
    [ts_builtin_sym_end] = ACTIONS(346),
    [anon_sym_TILDE] = ACTIONS(346),
    [anon_sym_PIPE] = ACTIONS(348),
    [anon_sym_PIPEH] = ACTIONS(346),
    [anon_sym_PIPET] = ACTIONS(346),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(346),
    [anon_sym_AT_AT_ATb] = ACTIONS(346),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATi] = ACTIONS(346),
    [anon_sym_AT_AT_ATr] = ACTIONS(346),
    [anon_sym_AT_AT_ATs] = ACTIONS(348),
    [anon_sym_AT_AT_ATst] = ACTIONS(346),
    [anon_sym_AT_AT_ATS] = ACTIONS(346),
    [anon_sym_AT_AT_ATm] = ACTIONS(346),
    [anon_sym_AT_AT_ATM] = ACTIONS(346),
    [anon_sym_AT_AT_ATf] = ACTIONS(348),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATF] = ACTIONS(348),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATt] = ACTIONS(346),
    [anon_sym_AT_AT] = ACTIONS(348),
    [anon_sym_AT_ATdbt] = ACTIONS(348),
    [anon_sym_AT_ATdbta] = ACTIONS(346),
    [anon_sym_AT_ATdbtb] = ACTIONS(346),
    [anon_sym_AT_ATdbts] = ACTIONS(346),
    [anon_sym_AT_AT_DOT] = ACTIONS(346),
    [anon_sym_AT_AT_EQ] = ACTIONS(346),
    [anon_sym_AT_ATk] = ACTIONS(346),
    [anon_sym_AT_ATt] = ACTIONS(346),
    [anon_sym_AT_ATb] = ACTIONS(346),
    [anon_sym_AT_ATi] = ACTIONS(348),
    [anon_sym_AT_ATiS] = ACTIONS(346),
    [anon_sym_AT_ATf] = ACTIONS(346),
    [anon_sym_AT_ATs_COLON] = ACTIONS(346),
    [anon_sym_AT_ATc_COLON] = ACTIONS(346),
    [anon_sym_AT] = ACTIONS(348),
    [anon_sym_AT_BANG] = ACTIONS(346),
    [anon_sym_AT_LBRACE] = ACTIONS(346),
    [anon_sym_ATa_COLON] = ACTIONS(346),
    [anon_sym_ATb_COLON] = ACTIONS(346),
    [anon_sym_ATB_COLON] = ACTIONS(346),
    [anon_sym_ATe_COLON] = ACTIONS(346),
    [anon_sym_ATF_COLON] = ACTIONS(346),
    [anon_sym_ATi_COLON] = ACTIONS(346),
    [anon_sym_ATk_COLON] = ACTIONS(346),
    [anon_sym_ATo_COLON] = ACTIONS(346),
    [anon_sym_ATr_COLON] = ACTIONS(346),
    [anon_sym_ATf_COLON] = ACTIONS(346),
    [anon_sym_ATs_COLON] = ACTIONS(346),
    [anon_sym_ATx_COLON] = ACTIONS(346),
    [anon_sym_PIPE_DOT] = ACTIONS(346),
    [anon_sym_RPAREN] = ACTIONS(346),
    [anon_sym_SEMI] = ACTIONS(346),
    [anon_sym_GT] = ACTIONS(348),
    [anon_sym_GT_GT] = ACTIONS(346),
    [sym_html_redirect_operator] = ACTIONS(348),
    [sym_html_append_operator] = ACTIONS(346),
    [anon_sym_BQUOTE] = ACTIONS(346),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(346),
    [anon_sym_CR] = ACTIONS(346),
    [sym_file_descriptor] = ACTIONS(346),
    [sym__eq_sep_concat] = ACTIONS(346),
    [sym__concat] = ACTIONS(346),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(338),
    [anon_sym_TILDE] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(340),
    [anon_sym_PIPEH] = ACTIONS(338),
    [anon_sym_PIPET] = ACTIONS(338),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(338),
    [anon_sym_AT_AT_ATb] = ACTIONS(338),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATi] = ACTIONS(338),
    [anon_sym_AT_AT_ATr] = ACTIONS(338),
    [anon_sym_AT_AT_ATs] = ACTIONS(340),
    [anon_sym_AT_AT_ATst] = ACTIONS(338),
    [anon_sym_AT_AT_ATS] = ACTIONS(338),
    [anon_sym_AT_AT_ATm] = ACTIONS(338),
    [anon_sym_AT_AT_ATM] = ACTIONS(338),
    [anon_sym_AT_AT_ATf] = ACTIONS(340),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATF] = ACTIONS(340),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATt] = ACTIONS(338),
    [anon_sym_AT_AT] = ACTIONS(340),
    [anon_sym_AT_ATdbt] = ACTIONS(340),
    [anon_sym_AT_ATdbta] = ACTIONS(338),
    [anon_sym_AT_ATdbtb] = ACTIONS(338),
    [anon_sym_AT_ATdbts] = ACTIONS(338),
    [anon_sym_AT_AT_DOT] = ACTIONS(338),
    [anon_sym_AT_AT_EQ] = ACTIONS(338),
    [anon_sym_AT_ATk] = ACTIONS(338),
    [anon_sym_AT_ATt] = ACTIONS(338),
    [anon_sym_AT_ATb] = ACTIONS(338),
    [anon_sym_AT_ATi] = ACTIONS(340),
    [anon_sym_AT_ATiS] = ACTIONS(338),
    [anon_sym_AT_ATf] = ACTIONS(338),
    [anon_sym_AT_ATs_COLON] = ACTIONS(338),
    [anon_sym_AT_ATc_COLON] = ACTIONS(338),
    [anon_sym_AT] = ACTIONS(340),
    [anon_sym_AT_BANG] = ACTIONS(338),
    [anon_sym_AT_LBRACE] = ACTIONS(338),
    [anon_sym_ATa_COLON] = ACTIONS(338),
    [anon_sym_ATb_COLON] = ACTIONS(338),
    [anon_sym_ATB_COLON] = ACTIONS(338),
    [anon_sym_ATe_COLON] = ACTIONS(338),
    [anon_sym_ATF_COLON] = ACTIONS(338),
    [anon_sym_ATi_COLON] = ACTIONS(338),
    [anon_sym_ATk_COLON] = ACTIONS(338),
    [anon_sym_ATo_COLON] = ACTIONS(338),
    [anon_sym_ATr_COLON] = ACTIONS(338),
    [anon_sym_ATf_COLON] = ACTIONS(338),
    [anon_sym_ATs_COLON] = ACTIONS(338),
    [anon_sym_ATx_COLON] = ACTIONS(338),
    [anon_sym_PIPE_DOT] = ACTIONS(338),
    [anon_sym_RPAREN] = ACTIONS(338),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_GT] = ACTIONS(340),
    [anon_sym_GT_GT] = ACTIONS(338),
    [sym_html_redirect_operator] = ACTIONS(340),
    [sym_html_append_operator] = ACTIONS(338),
    [anon_sym_BQUOTE] = ACTIONS(338),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(338),
    [anon_sym_CR] = ACTIONS(338),
    [sym_file_descriptor] = ACTIONS(338),
    [sym__eq_sep_concat] = ACTIONS(338),
    [sym__concat] = ACTIONS(338),
  },
  [146] = {
    [ts_builtin_sym_end] = ACTIONS(342),
    [anon_sym_TILDE] = ACTIONS(342),
    [anon_sym_PIPE] = ACTIONS(344),
    [anon_sym_PIPEH] = ACTIONS(342),
    [anon_sym_PIPET] = ACTIONS(342),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(342),
    [anon_sym_AT_AT_ATb] = ACTIONS(342),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATi] = ACTIONS(342),
    [anon_sym_AT_AT_ATr] = ACTIONS(342),
    [anon_sym_AT_AT_ATs] = ACTIONS(344),
    [anon_sym_AT_AT_ATst] = ACTIONS(342),
    [anon_sym_AT_AT_ATS] = ACTIONS(342),
    [anon_sym_AT_AT_ATm] = ACTIONS(342),
    [anon_sym_AT_AT_ATM] = ACTIONS(342),
    [anon_sym_AT_AT_ATf] = ACTIONS(344),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATF] = ACTIONS(344),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATt] = ACTIONS(342),
    [anon_sym_AT_AT] = ACTIONS(344),
    [anon_sym_AT_ATdbt] = ACTIONS(344),
    [anon_sym_AT_ATdbta] = ACTIONS(342),
    [anon_sym_AT_ATdbtb] = ACTIONS(342),
    [anon_sym_AT_ATdbts] = ACTIONS(342),
    [anon_sym_AT_AT_DOT] = ACTIONS(342),
    [anon_sym_AT_AT_EQ] = ACTIONS(342),
    [anon_sym_AT_ATk] = ACTIONS(342),
    [anon_sym_AT_ATt] = ACTIONS(342),
    [anon_sym_AT_ATb] = ACTIONS(342),
    [anon_sym_AT_ATi] = ACTIONS(344),
    [anon_sym_AT_ATiS] = ACTIONS(342),
    [anon_sym_AT_ATf] = ACTIONS(342),
    [anon_sym_AT_ATs_COLON] = ACTIONS(342),
    [anon_sym_AT_ATc_COLON] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_AT_BANG] = ACTIONS(342),
    [anon_sym_AT_LBRACE] = ACTIONS(342),
    [anon_sym_ATa_COLON] = ACTIONS(342),
    [anon_sym_ATb_COLON] = ACTIONS(342),
    [anon_sym_ATB_COLON] = ACTIONS(342),
    [anon_sym_ATe_COLON] = ACTIONS(342),
    [anon_sym_ATF_COLON] = ACTIONS(342),
    [anon_sym_ATi_COLON] = ACTIONS(342),
    [anon_sym_ATk_COLON] = ACTIONS(342),
    [anon_sym_ATo_COLON] = ACTIONS(342),
    [anon_sym_ATr_COLON] = ACTIONS(342),
    [anon_sym_ATf_COLON] = ACTIONS(342),
    [anon_sym_ATs_COLON] = ACTIONS(342),
    [anon_sym_ATx_COLON] = ACTIONS(342),
    [anon_sym_PIPE_DOT] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(342),
    [anon_sym_SEMI] = ACTIONS(342),
    [anon_sym_GT] = ACTIONS(344),
    [anon_sym_GT_GT] = ACTIONS(342),
    [sym_html_redirect_operator] = ACTIONS(344),
    [sym_html_append_operator] = ACTIONS(342),
    [anon_sym_BQUOTE] = ACTIONS(342),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(342),
    [anon_sym_CR] = ACTIONS(342),
    [sym_file_descriptor] = ACTIONS(342),
    [sym__eq_sep_concat] = ACTIONS(342),
    [sym__concat] = ACTIONS(342),
  },
  [147] = {
    [ts_builtin_sym_end] = ACTIONS(330),
    [anon_sym_TILDE] = ACTIONS(330),
    [anon_sym_PIPE] = ACTIONS(332),
    [anon_sym_PIPEH] = ACTIONS(330),
    [anon_sym_PIPET] = ACTIONS(330),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(330),
    [anon_sym_AT_AT_ATb] = ACTIONS(330),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATi] = ACTIONS(330),
    [anon_sym_AT_AT_ATr] = ACTIONS(330),
    [anon_sym_AT_AT_ATs] = ACTIONS(332),
    [anon_sym_AT_AT_ATst] = ACTIONS(330),
    [anon_sym_AT_AT_ATS] = ACTIONS(330),
    [anon_sym_AT_AT_ATm] = ACTIONS(330),
    [anon_sym_AT_AT_ATM] = ACTIONS(330),
    [anon_sym_AT_AT_ATf] = ACTIONS(332),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATF] = ACTIONS(332),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(330),
    [anon_sym_AT_AT_ATt] = ACTIONS(330),
    [anon_sym_AT_AT] = ACTIONS(332),
    [anon_sym_AT_ATdbt] = ACTIONS(332),
    [anon_sym_AT_ATdbta] = ACTIONS(330),
    [anon_sym_AT_ATdbtb] = ACTIONS(330),
    [anon_sym_AT_ATdbts] = ACTIONS(330),
    [anon_sym_AT_AT_DOT] = ACTIONS(330),
    [anon_sym_AT_AT_EQ] = ACTIONS(330),
    [anon_sym_AT_ATk] = ACTIONS(330),
    [anon_sym_AT_ATt] = ACTIONS(330),
    [anon_sym_AT_ATb] = ACTIONS(330),
    [anon_sym_AT_ATi] = ACTIONS(332),
    [anon_sym_AT_ATiS] = ACTIONS(330),
    [anon_sym_AT_ATf] = ACTIONS(330),
    [anon_sym_AT_ATs_COLON] = ACTIONS(330),
    [anon_sym_AT_ATc_COLON] = ACTIONS(330),
    [anon_sym_AT] = ACTIONS(332),
    [anon_sym_AT_BANG] = ACTIONS(330),
    [anon_sym_AT_LBRACE] = ACTIONS(330),
    [anon_sym_ATa_COLON] = ACTIONS(330),
    [anon_sym_ATb_COLON] = ACTIONS(330),
    [anon_sym_ATB_COLON] = ACTIONS(330),
    [anon_sym_ATe_COLON] = ACTIONS(330),
    [anon_sym_ATF_COLON] = ACTIONS(330),
    [anon_sym_ATi_COLON] = ACTIONS(330),
    [anon_sym_ATk_COLON] = ACTIONS(330),
    [anon_sym_ATo_COLON] = ACTIONS(330),
    [anon_sym_ATr_COLON] = ACTIONS(330),
    [anon_sym_ATf_COLON] = ACTIONS(330),
    [anon_sym_ATs_COLON] = ACTIONS(330),
    [anon_sym_ATx_COLON] = ACTIONS(330),
    [anon_sym_PIPE_DOT] = ACTIONS(330),
    [anon_sym_RPAREN] = ACTIONS(330),
    [anon_sym_SEMI] = ACTIONS(330),
    [anon_sym_GT] = ACTIONS(332),
    [anon_sym_GT_GT] = ACTIONS(330),
    [sym_html_redirect_operator] = ACTIONS(332),
    [sym_html_append_operator] = ACTIONS(330),
    [anon_sym_BQUOTE] = ACTIONS(330),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(330),
    [anon_sym_CR] = ACTIONS(330),
    [sym_file_descriptor] = ACTIONS(330),
    [sym__eq_sep_concat] = ACTIONS(330),
    [sym__concat] = ACTIONS(330),
  },
  [148] = {
    [ts_builtin_sym_end] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_PIPEH] = ACTIONS(319),
    [anon_sym_PIPET] = ACTIONS(319),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATi] = ACTIONS(319),
    [anon_sym_AT_AT_ATr] = ACTIONS(319),
    [anon_sym_AT_AT_ATs] = ACTIONS(321),
    [anon_sym_AT_AT_ATst] = ACTIONS(319),
    [anon_sym_AT_AT_ATS] = ACTIONS(319),
    [anon_sym_AT_AT_ATm] = ACTIONS(319),
    [anon_sym_AT_AT_ATM] = ACTIONS(319),
    [anon_sym_AT_AT_ATf] = ACTIONS(321),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATF] = ACTIONS(321),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_AT] = ACTIONS(321),
    [anon_sym_AT_ATdbt] = ACTIONS(321),
    [anon_sym_AT_ATdbta] = ACTIONS(319),
    [anon_sym_AT_ATdbtb] = ACTIONS(319),
    [anon_sym_AT_ATdbts] = ACTIONS(319),
    [anon_sym_AT_AT_DOT] = ACTIONS(319),
    [anon_sym_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_ATk] = ACTIONS(319),
    [anon_sym_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_ATi] = ACTIONS(321),
    [anon_sym_AT_ATiS] = ACTIONS(319),
    [anon_sym_AT_ATf] = ACTIONS(319),
    [anon_sym_AT_ATs_COLON] = ACTIONS(319),
    [anon_sym_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_AT_BANG] = ACTIONS(319),
    [anon_sym_AT_LBRACE] = ACTIONS(319),
    [anon_sym_ATa_COLON] = ACTIONS(319),
    [anon_sym_ATb_COLON] = ACTIONS(319),
    [anon_sym_ATB_COLON] = ACTIONS(319),
    [anon_sym_ATe_COLON] = ACTIONS(319),
    [anon_sym_ATF_COLON] = ACTIONS(319),
    [anon_sym_ATi_COLON] = ACTIONS(319),
    [anon_sym_ATk_COLON] = ACTIONS(319),
    [anon_sym_ATo_COLON] = ACTIONS(319),
    [anon_sym_ATr_COLON] = ACTIONS(319),
    [anon_sym_ATf_COLON] = ACTIONS(319),
    [anon_sym_ATs_COLON] = ACTIONS(319),
    [anon_sym_ATx_COLON] = ACTIONS(319),
    [anon_sym_PIPE_DOT] = ACTIONS(319),
    [anon_sym_RPAREN] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(321),
    [anon_sym_GT_GT] = ACTIONS(319),
    [sym_html_redirect_operator] = ACTIONS(321),
    [sym_html_append_operator] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_CR] = ACTIONS(319),
    [sym_file_descriptor] = ACTIONS(319),
    [sym__eq_sep_concat] = ACTIONS(319),
    [sym__concat] = ACTIONS(319),
  },
  [149] = {
    [ts_builtin_sym_end] = ACTIONS(334),
    [anon_sym_TILDE] = ACTIONS(334),
    [anon_sym_PIPE] = ACTIONS(336),
    [anon_sym_PIPEH] = ACTIONS(334),
    [anon_sym_PIPET] = ACTIONS(334),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(334),
    [anon_sym_AT_AT_ATb] = ACTIONS(334),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(334),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(334),
    [anon_sym_AT_AT_ATi] = ACTIONS(334),
    [anon_sym_AT_AT_ATr] = ACTIONS(334),
    [anon_sym_AT_AT_ATs] = ACTIONS(336),
    [anon_sym_AT_AT_ATst] = ACTIONS(334),
    [anon_sym_AT_AT_ATS] = ACTIONS(334),
    [anon_sym_AT_AT_ATm] = ACTIONS(334),
    [anon_sym_AT_AT_ATM] = ACTIONS(334),
    [anon_sym_AT_AT_ATf] = ACTIONS(336),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(334),
    [anon_sym_AT_AT_ATF] = ACTIONS(336),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(334),
    [anon_sym_AT_AT_ATt] = ACTIONS(334),
    [anon_sym_AT_AT] = ACTIONS(336),
    [anon_sym_AT_ATdbt] = ACTIONS(336),
    [anon_sym_AT_ATdbta] = ACTIONS(334),
    [anon_sym_AT_ATdbtb] = ACTIONS(334),
    [anon_sym_AT_ATdbts] = ACTIONS(334),
    [anon_sym_AT_AT_DOT] = ACTIONS(334),
    [anon_sym_AT_AT_EQ] = ACTIONS(334),
    [anon_sym_AT_ATk] = ACTIONS(334),
    [anon_sym_AT_ATt] = ACTIONS(334),
    [anon_sym_AT_ATb] = ACTIONS(334),
    [anon_sym_AT_ATi] = ACTIONS(336),
    [anon_sym_AT_ATiS] = ACTIONS(334),
    [anon_sym_AT_ATf] = ACTIONS(334),
    [anon_sym_AT_ATs_COLON] = ACTIONS(334),
    [anon_sym_AT_ATc_COLON] = ACTIONS(334),
    [anon_sym_AT] = ACTIONS(336),
    [anon_sym_AT_BANG] = ACTIONS(334),
    [anon_sym_AT_LBRACE] = ACTIONS(334),
    [anon_sym_ATa_COLON] = ACTIONS(334),
    [anon_sym_ATb_COLON] = ACTIONS(334),
    [anon_sym_ATB_COLON] = ACTIONS(334),
    [anon_sym_ATe_COLON] = ACTIONS(334),
    [anon_sym_ATF_COLON] = ACTIONS(334),
    [anon_sym_ATi_COLON] = ACTIONS(334),
    [anon_sym_ATk_COLON] = ACTIONS(334),
    [anon_sym_ATo_COLON] = ACTIONS(334),
    [anon_sym_ATr_COLON] = ACTIONS(334),
    [anon_sym_ATf_COLON] = ACTIONS(334),
    [anon_sym_ATs_COLON] = ACTIONS(334),
    [anon_sym_ATx_COLON] = ACTIONS(334),
    [anon_sym_PIPE_DOT] = ACTIONS(334),
    [anon_sym_RPAREN] = ACTIONS(334),
    [anon_sym_SEMI] = ACTIONS(334),
    [anon_sym_GT] = ACTIONS(336),
    [anon_sym_GT_GT] = ACTIONS(334),
    [sym_html_redirect_operator] = ACTIONS(336),
    [sym_html_append_operator] = ACTIONS(334),
    [anon_sym_BQUOTE] = ACTIONS(334),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(334),
    [anon_sym_CR] = ACTIONS(334),
    [sym_file_descriptor] = ACTIONS(334),
    [sym__eq_sep_concat] = ACTIONS(334),
    [sym__concat] = ACTIONS(334),
  },
  [150] = {
    [aux_sym_tmp_eval_args_repeat1] = STATE(157),
    [ts_builtin_sym_end] = ACTIONS(478),
    [anon_sym_TILDE] = ACTIONS(478),
    [anon_sym_PIPE] = ACTIONS(480),
    [anon_sym_PIPEH] = ACTIONS(478),
    [anon_sym_PIPET] = ACTIONS(478),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(478),
    [anon_sym_AT_AT_ATb] = ACTIONS(478),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(478),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(478),
    [anon_sym_AT_AT_ATi] = ACTIONS(478),
    [anon_sym_AT_AT_ATr] = ACTIONS(478),
    [anon_sym_AT_AT_ATs] = ACTIONS(480),
    [anon_sym_AT_AT_ATst] = ACTIONS(478),
    [anon_sym_AT_AT_ATS] = ACTIONS(478),
    [anon_sym_AT_AT_ATm] = ACTIONS(478),
    [anon_sym_AT_AT_ATM] = ACTIONS(478),
    [anon_sym_AT_AT_ATf] = ACTIONS(480),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(478),
    [anon_sym_AT_AT_ATF] = ACTIONS(480),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(478),
    [anon_sym_AT_AT_ATt] = ACTIONS(478),
    [anon_sym_AT_AT] = ACTIONS(480),
    [anon_sym_AT_ATdbt] = ACTIONS(480),
    [anon_sym_AT_ATdbta] = ACTIONS(478),
    [anon_sym_AT_ATdbtb] = ACTIONS(478),
    [anon_sym_AT_ATdbts] = ACTIONS(478),
    [anon_sym_AT_AT_DOT] = ACTIONS(478),
    [anon_sym_AT_AT_EQ] = ACTIONS(478),
    [anon_sym_AT_ATk] = ACTIONS(478),
    [anon_sym_AT_ATt] = ACTIONS(478),
    [anon_sym_AT_ATb] = ACTIONS(478),
    [anon_sym_AT_ATi] = ACTIONS(480),
    [anon_sym_AT_ATiS] = ACTIONS(478),
    [anon_sym_AT_ATf] = ACTIONS(478),
    [anon_sym_AT_ATs_COLON] = ACTIONS(478),
    [anon_sym_AT_ATc_COLON] = ACTIONS(478),
    [anon_sym_AT] = ACTIONS(480),
    [anon_sym_AT_BANG] = ACTIONS(478),
    [anon_sym_AT_LBRACE] = ACTIONS(478),
    [anon_sym_ATa_COLON] = ACTIONS(478),
    [anon_sym_ATb_COLON] = ACTIONS(478),
    [anon_sym_ATB_COLON] = ACTIONS(478),
    [anon_sym_ATe_COLON] = ACTIONS(478),
    [anon_sym_ATF_COLON] = ACTIONS(478),
    [anon_sym_ATi_COLON] = ACTIONS(478),
    [anon_sym_ATk_COLON] = ACTIONS(478),
    [anon_sym_ATo_COLON] = ACTIONS(478),
    [anon_sym_ATr_COLON] = ACTIONS(478),
    [anon_sym_ATf_COLON] = ACTIONS(478),
    [anon_sym_ATs_COLON] = ACTIONS(478),
    [anon_sym_ATx_COLON] = ACTIONS(478),
    [anon_sym_PIPE_DOT] = ACTIONS(478),
    [anon_sym_RPAREN] = ACTIONS(478),
    [anon_sym_SEMI] = ACTIONS(478),
    [anon_sym_GT] = ACTIONS(480),
    [anon_sym_GT_GT] = ACTIONS(478),
    [sym_html_redirect_operator] = ACTIONS(480),
    [sym_html_append_operator] = ACTIONS(478),
    [anon_sym_COMMA] = ACTIONS(482),
    [anon_sym_BQUOTE] = ACTIONS(478),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(478),
    [anon_sym_CR] = ACTIONS(478),
    [sym_file_descriptor] = ACTIONS(478),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(326),
    [anon_sym_PIPE] = ACTIONS(328),
    [anon_sym_PIPEH] = ACTIONS(326),
    [anon_sym_PIPET] = ACTIONS(326),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(326),
    [anon_sym_AT_AT_ATb] = ACTIONS(326),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(326),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(326),
    [anon_sym_AT_AT_ATi] = ACTIONS(326),
    [anon_sym_AT_AT_ATr] = ACTIONS(326),
    [anon_sym_AT_AT_ATs] = ACTIONS(328),
    [anon_sym_AT_AT_ATst] = ACTIONS(326),
    [anon_sym_AT_AT_ATS] = ACTIONS(326),
    [anon_sym_AT_AT_ATm] = ACTIONS(326),
    [anon_sym_AT_AT_ATM] = ACTIONS(326),
    [anon_sym_AT_AT_ATf] = ACTIONS(328),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(326),
    [anon_sym_AT_AT_ATF] = ACTIONS(328),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(326),
    [anon_sym_AT_AT_ATt] = ACTIONS(326),
    [anon_sym_AT_AT] = ACTIONS(328),
    [anon_sym_AT_ATdbt] = ACTIONS(328),
    [anon_sym_AT_ATdbta] = ACTIONS(326),
    [anon_sym_AT_ATdbtb] = ACTIONS(326),
    [anon_sym_AT_ATdbts] = ACTIONS(326),
    [anon_sym_AT_AT_DOT] = ACTIONS(326),
    [anon_sym_AT_AT_EQ] = ACTIONS(326),
    [anon_sym_AT_ATk] = ACTIONS(326),
    [anon_sym_AT_ATt] = ACTIONS(326),
    [anon_sym_AT_ATb] = ACTIONS(326),
    [anon_sym_AT_ATi] = ACTIONS(328),
    [anon_sym_AT_ATiS] = ACTIONS(326),
    [anon_sym_AT_ATf] = ACTIONS(326),
    [anon_sym_AT_ATs_COLON] = ACTIONS(326),
    [anon_sym_AT_ATc_COLON] = ACTIONS(326),
    [anon_sym_AT] = ACTIONS(328),
    [anon_sym_AT_BANG] = ACTIONS(326),
    [anon_sym_AT_LBRACE] = ACTIONS(326),
    [anon_sym_ATa_COLON] = ACTIONS(326),
    [anon_sym_ATb_COLON] = ACTIONS(326),
    [anon_sym_ATB_COLON] = ACTIONS(326),
    [anon_sym_ATe_COLON] = ACTIONS(326),
    [anon_sym_ATF_COLON] = ACTIONS(326),
    [anon_sym_ATi_COLON] = ACTIONS(326),
    [anon_sym_ATk_COLON] = ACTIONS(326),
    [anon_sym_ATo_COLON] = ACTIONS(326),
    [anon_sym_ATr_COLON] = ACTIONS(326),
    [anon_sym_ATf_COLON] = ACTIONS(326),
    [anon_sym_ATs_COLON] = ACTIONS(326),
    [anon_sym_ATx_COLON] = ACTIONS(326),
    [anon_sym_PIPE_DOT] = ACTIONS(326),
    [anon_sym_RPAREN] = ACTIONS(326),
    [anon_sym_SEMI] = ACTIONS(326),
    [anon_sym_GT] = ACTIONS(328),
    [anon_sym_GT_GT] = ACTIONS(326),
    [sym_html_redirect_operator] = ACTIONS(328),
    [sym_html_append_operator] = ACTIONS(326),
    [anon_sym_BQUOTE] = ACTIONS(326),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(326),
    [anon_sym_CR] = ACTIONS(326),
    [sym_file_descriptor] = ACTIONS(326),
    [sym__eq_sep_concat] = ACTIONS(326),
    [sym__concat] = ACTIONS(326),
  },
  [152] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_EQ] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__eq_sep_concat] = ACTIONS(350),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PIPE] = ACTIONS(352),
    [anon_sym_PIPEH] = ACTIONS(350),
    [anon_sym_PIPET] = ACTIONS(350),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATi] = ACTIONS(350),
    [anon_sym_AT_AT_ATr] = ACTIONS(350),
    [anon_sym_AT_AT_ATs] = ACTIONS(352),
    [anon_sym_AT_AT_ATst] = ACTIONS(350),
    [anon_sym_AT_AT_ATS] = ACTIONS(350),
    [anon_sym_AT_AT_ATm] = ACTIONS(350),
    [anon_sym_AT_AT_ATM] = ACTIONS(350),
    [anon_sym_AT_AT_ATf] = ACTIONS(352),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATF] = ACTIONS(352),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(350),
    [anon_sym_AT_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_AT] = ACTIONS(352),
    [anon_sym_AT_ATdbt] = ACTIONS(352),
    [anon_sym_AT_ATdbta] = ACTIONS(350),
    [anon_sym_AT_ATdbtb] = ACTIONS(350),
    [anon_sym_AT_ATdbts] = ACTIONS(350),
    [anon_sym_AT_AT_DOT] = ACTIONS(350),
    [anon_sym_AT_AT_EQ] = ACTIONS(350),
    [anon_sym_AT_ATk] = ACTIONS(350),
    [anon_sym_AT_ATt] = ACTIONS(350),
    [anon_sym_AT_ATb] = ACTIONS(350),
    [anon_sym_AT_ATi] = ACTIONS(352),
    [anon_sym_AT_ATiS] = ACTIONS(350),
    [anon_sym_AT_ATf] = ACTIONS(350),
    [anon_sym_AT_ATs_COLON] = ACTIONS(350),
    [anon_sym_AT_ATc_COLON] = ACTIONS(350),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_AT_BANG] = ACTIONS(350),
    [anon_sym_AT_LBRACE] = ACTIONS(350),
    [anon_sym_ATa_COLON] = ACTIONS(350),
    [anon_sym_ATb_COLON] = ACTIONS(350),
    [anon_sym_ATB_COLON] = ACTIONS(350),
    [anon_sym_ATe_COLON] = ACTIONS(350),
    [anon_sym_ATF_COLON] = ACTIONS(350),
    [anon_sym_ATi_COLON] = ACTIONS(350),
    [anon_sym_ATk_COLON] = ACTIONS(350),
    [anon_sym_ATo_COLON] = ACTIONS(350),
    [anon_sym_ATr_COLON] = ACTIONS(350),
    [anon_sym_ATf_COLON] = ACTIONS(350),
    [anon_sym_ATs_COLON] = ACTIONS(350),
    [anon_sym_ATx_COLON] = ACTIONS(350),
    [anon_sym_PIPE_DOT] = ACTIONS(350),
    [anon_sym_EQ] = ACTIONS(350),
    [anon_sym_RPAREN] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_GT_GT] = ACTIONS(350),
    [sym_html_redirect_operator] = ACTIONS(352),
    [sym_html_append_operator] = ACTIONS(350),
    [anon_sym_BQUOTE] = ACTIONS(350),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(350),
    [anon_sym_CR] = ACTIONS(350),
    [sym_file_descriptor] = ACTIONS(350),
    [sym__eq_sep_concat] = ACTIONS(350),
  },
  [154] = {
    [aux_sym_eq_sep_val_repeat1] = STATE(156),
    [ts_builtin_sym_end] = ACTIONS(484),
    [anon_sym_TILDE] = ACTIONS(484),
    [anon_sym_PIPE] = ACTIONS(486),
    [anon_sym_PIPEH] = ACTIONS(484),
    [anon_sym_PIPET] = ACTIONS(484),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(484),
    [anon_sym_AT_AT_ATb] = ACTIONS(484),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(484),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(484),
    [anon_sym_AT_AT_ATi] = ACTIONS(484),
    [anon_sym_AT_AT_ATr] = ACTIONS(484),
    [anon_sym_AT_AT_ATs] = ACTIONS(486),
    [anon_sym_AT_AT_ATst] = ACTIONS(484),
    [anon_sym_AT_AT_ATS] = ACTIONS(484),
    [anon_sym_AT_AT_ATm] = ACTIONS(484),
    [anon_sym_AT_AT_ATM] = ACTIONS(484),
    [anon_sym_AT_AT_ATf] = ACTIONS(486),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(484),
    [anon_sym_AT_AT_ATF] = ACTIONS(486),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(484),
    [anon_sym_AT_AT_ATt] = ACTIONS(484),
    [anon_sym_AT_AT] = ACTIONS(486),
    [anon_sym_AT_ATdbt] = ACTIONS(486),
    [anon_sym_AT_ATdbta] = ACTIONS(484),
    [anon_sym_AT_ATdbtb] = ACTIONS(484),
    [anon_sym_AT_ATdbts] = ACTIONS(484),
    [anon_sym_AT_AT_DOT] = ACTIONS(484),
    [anon_sym_AT_AT_EQ] = ACTIONS(484),
    [anon_sym_AT_ATk] = ACTIONS(484),
    [anon_sym_AT_ATt] = ACTIONS(484),
    [anon_sym_AT_ATb] = ACTIONS(484),
    [anon_sym_AT_ATi] = ACTIONS(486),
    [anon_sym_AT_ATiS] = ACTIONS(484),
    [anon_sym_AT_ATf] = ACTIONS(484),
    [anon_sym_AT_ATs_COLON] = ACTIONS(484),
    [anon_sym_AT_ATc_COLON] = ACTIONS(484),
    [anon_sym_AT] = ACTIONS(486),
    [anon_sym_AT_BANG] = ACTIONS(484),
    [anon_sym_AT_LBRACE] = ACTIONS(484),
    [anon_sym_ATa_COLON] = ACTIONS(484),
    [anon_sym_ATb_COLON] = ACTIONS(484),
    [anon_sym_ATB_COLON] = ACTIONS(484),
    [anon_sym_ATe_COLON] = ACTIONS(484),
    [anon_sym_ATF_COLON] = ACTIONS(484),
    [anon_sym_ATi_COLON] = ACTIONS(484),
    [anon_sym_ATk_COLON] = ACTIONS(484),
    [anon_sym_ATo_COLON] = ACTIONS(484),
    [anon_sym_ATr_COLON] = ACTIONS(484),
    [anon_sym_ATf_COLON] = ACTIONS(484),
    [anon_sym_ATs_COLON] = ACTIONS(484),
    [anon_sym_ATx_COLON] = ACTIONS(484),
    [anon_sym_PIPE_DOT] = ACTIONS(484),
    [anon_sym_RPAREN] = ACTIONS(484),
    [anon_sym_SEMI] = ACTIONS(484),
    [anon_sym_GT] = ACTIONS(486),
    [anon_sym_GT_GT] = ACTIONS(484),
    [sym_html_redirect_operator] = ACTIONS(486),
    [sym_html_append_operator] = ACTIONS(484),
    [anon_sym_BQUOTE] = ACTIONS(484),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(484),
    [anon_sym_CR] = ACTIONS(484),
    [sym_file_descriptor] = ACTIONS(484),
    [sym__eq_sep_concat] = ACTIONS(488),
  },
  [155] = {
    [ts_builtin_sym_end] = ACTIONS(462),
    [anon_sym_TILDE] = ACTIONS(462),
    [anon_sym_PIPE] = ACTIONS(464),
    [anon_sym_PIPEH] = ACTIONS(462),
    [anon_sym_PIPET] = ACTIONS(462),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(462),
    [anon_sym_AT_AT_ATb] = ACTIONS(462),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATi] = ACTIONS(462),
    [anon_sym_AT_AT_ATr] = ACTIONS(462),
    [anon_sym_AT_AT_ATs] = ACTIONS(464),
    [anon_sym_AT_AT_ATst] = ACTIONS(462),
    [anon_sym_AT_AT_ATS] = ACTIONS(462),
    [anon_sym_AT_AT_ATm] = ACTIONS(462),
    [anon_sym_AT_AT_ATM] = ACTIONS(462),
    [anon_sym_AT_AT_ATf] = ACTIONS(464),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATF] = ACTIONS(464),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(462),
    [anon_sym_AT_AT_ATt] = ACTIONS(462),
    [anon_sym_AT_AT] = ACTIONS(464),
    [anon_sym_AT_ATdbt] = ACTIONS(464),
    [anon_sym_AT_ATdbta] = ACTIONS(462),
    [anon_sym_AT_ATdbtb] = ACTIONS(462),
    [anon_sym_AT_ATdbts] = ACTIONS(462),
    [anon_sym_AT_AT_DOT] = ACTIONS(462),
    [anon_sym_AT_AT_EQ] = ACTIONS(462),
    [anon_sym_AT_ATk] = ACTIONS(462),
    [anon_sym_AT_ATt] = ACTIONS(462),
    [anon_sym_AT_ATb] = ACTIONS(462),
    [anon_sym_AT_ATi] = ACTIONS(464),
    [anon_sym_AT_ATiS] = ACTIONS(462),
    [anon_sym_AT_ATf] = ACTIONS(462),
    [anon_sym_AT_ATs_COLON] = ACTIONS(462),
    [anon_sym_AT_ATc_COLON] = ACTIONS(462),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_AT_BANG] = ACTIONS(462),
    [anon_sym_AT_LBRACE] = ACTIONS(462),
    [anon_sym_ATa_COLON] = ACTIONS(462),
    [anon_sym_ATb_COLON] = ACTIONS(462),
    [anon_sym_ATB_COLON] = ACTIONS(462),
    [anon_sym_ATe_COLON] = ACTIONS(462),
    [anon_sym_ATF_COLON] = ACTIONS(462),
    [anon_sym_ATi_COLON] = ACTIONS(462),
    [anon_sym_ATk_COLON] = ACTIONS(462),
    [anon_sym_ATo_COLON] = ACTIONS(462),
    [anon_sym_ATr_COLON] = ACTIONS(462),
    [anon_sym_ATf_COLON] = ACTIONS(462),
    [anon_sym_ATs_COLON] = ACTIONS(462),
    [anon_sym_ATx_COLON] = ACTIONS(462),
    [anon_sym_PIPE_DOT] = ACTIONS(462),
    [anon_sym_EQ] = ACTIONS(462),
    [anon_sym_RPAREN] = ACTIONS(462),
    [anon_sym_SEMI] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(464),
    [anon_sym_GT_GT] = ACTIONS(462),
    [sym_html_redirect_operator] = ACTIONS(464),
    [sym_html_append_operator] = ACTIONS(462),
    [anon_sym_BQUOTE] = ACTIONS(462),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(462),
    [anon_sym_CR] = ACTIONS(462),
    [sym_file_descriptor] = ACTIONS(462),
    [sym__eq_sep_concat] = ACTIONS(462),
  },
  [156] = {
    [aux_sym_eq_sep_val_repeat1] = STATE(159),
    [ts_builtin_sym_end] = ACTIONS(490),
    [anon_sym_TILDE] = ACTIONS(490),
    [anon_sym_PIPE] = ACTIONS(492),
    [anon_sym_PIPEH] = ACTIONS(490),
    [anon_sym_PIPET] = ACTIONS(490),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(490),
    [anon_sym_AT_AT_ATb] = ACTIONS(490),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(490),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(490),
    [anon_sym_AT_AT_ATi] = ACTIONS(490),
    [anon_sym_AT_AT_ATr] = ACTIONS(490),
    [anon_sym_AT_AT_ATs] = ACTIONS(492),
    [anon_sym_AT_AT_ATst] = ACTIONS(490),
    [anon_sym_AT_AT_ATS] = ACTIONS(490),
    [anon_sym_AT_AT_ATm] = ACTIONS(490),
    [anon_sym_AT_AT_ATM] = ACTIONS(490),
    [anon_sym_AT_AT_ATf] = ACTIONS(492),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(490),
    [anon_sym_AT_AT_ATF] = ACTIONS(492),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(490),
    [anon_sym_AT_AT_ATt] = ACTIONS(490),
    [anon_sym_AT_AT] = ACTIONS(492),
    [anon_sym_AT_ATdbt] = ACTIONS(492),
    [anon_sym_AT_ATdbta] = ACTIONS(490),
    [anon_sym_AT_ATdbtb] = ACTIONS(490),
    [anon_sym_AT_ATdbts] = ACTIONS(490),
    [anon_sym_AT_AT_DOT] = ACTIONS(490),
    [anon_sym_AT_AT_EQ] = ACTIONS(490),
    [anon_sym_AT_ATk] = ACTIONS(490),
    [anon_sym_AT_ATt] = ACTIONS(490),
    [anon_sym_AT_ATb] = ACTIONS(490),
    [anon_sym_AT_ATi] = ACTIONS(492),
    [anon_sym_AT_ATiS] = ACTIONS(490),
    [anon_sym_AT_ATf] = ACTIONS(490),
    [anon_sym_AT_ATs_COLON] = ACTIONS(490),
    [anon_sym_AT_ATc_COLON] = ACTIONS(490),
    [anon_sym_AT] = ACTIONS(492),
    [anon_sym_AT_BANG] = ACTIONS(490),
    [anon_sym_AT_LBRACE] = ACTIONS(490),
    [anon_sym_ATa_COLON] = ACTIONS(490),
    [anon_sym_ATb_COLON] = ACTIONS(490),
    [anon_sym_ATB_COLON] = ACTIONS(490),
    [anon_sym_ATe_COLON] = ACTIONS(490),
    [anon_sym_ATF_COLON] = ACTIONS(490),
    [anon_sym_ATi_COLON] = ACTIONS(490),
    [anon_sym_ATk_COLON] = ACTIONS(490),
    [anon_sym_ATo_COLON] = ACTIONS(490),
    [anon_sym_ATr_COLON] = ACTIONS(490),
    [anon_sym_ATf_COLON] = ACTIONS(490),
    [anon_sym_ATs_COLON] = ACTIONS(490),
    [anon_sym_ATx_COLON] = ACTIONS(490),
    [anon_sym_PIPE_DOT] = ACTIONS(490),
    [anon_sym_RPAREN] = ACTIONS(490),
    [anon_sym_SEMI] = ACTIONS(490),
    [anon_sym_GT] = ACTIONS(492),
    [anon_sym_GT_GT] = ACTIONS(490),
    [sym_html_redirect_operator] = ACTIONS(492),
    [sym_html_append_operator] = ACTIONS(490),
    [anon_sym_BQUOTE] = ACTIONS(490),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(490),
    [anon_sym_CR] = ACTIONS(490),
    [sym_file_descriptor] = ACTIONS(490),
    [sym__eq_sep_concat] = ACTIONS(488),
  },
  [157] = {
    [aux_sym_tmp_eval_args_repeat1] = STATE(157),
    [ts_builtin_sym_end] = ACTIONS(494),
    [anon_sym_TILDE] = ACTIONS(494),
    [anon_sym_PIPE] = ACTIONS(496),
    [anon_sym_PIPEH] = ACTIONS(494),
    [anon_sym_PIPET] = ACTIONS(494),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(494),
    [anon_sym_AT_AT_ATb] = ACTIONS(494),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(494),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(494),
    [anon_sym_AT_AT_ATi] = ACTIONS(494),
    [anon_sym_AT_AT_ATr] = ACTIONS(494),
    [anon_sym_AT_AT_ATs] = ACTIONS(496),
    [anon_sym_AT_AT_ATst] = ACTIONS(494),
    [anon_sym_AT_AT_ATS] = ACTIONS(494),
    [anon_sym_AT_AT_ATm] = ACTIONS(494),
    [anon_sym_AT_AT_ATM] = ACTIONS(494),
    [anon_sym_AT_AT_ATf] = ACTIONS(496),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(494),
    [anon_sym_AT_AT_ATF] = ACTIONS(496),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(494),
    [anon_sym_AT_AT_ATt] = ACTIONS(494),
    [anon_sym_AT_AT] = ACTIONS(496),
    [anon_sym_AT_ATdbt] = ACTIONS(496),
    [anon_sym_AT_ATdbta] = ACTIONS(494),
    [anon_sym_AT_ATdbtb] = ACTIONS(494),
    [anon_sym_AT_ATdbts] = ACTIONS(494),
    [anon_sym_AT_AT_DOT] = ACTIONS(494),
    [anon_sym_AT_AT_EQ] = ACTIONS(494),
    [anon_sym_AT_ATk] = ACTIONS(494),
    [anon_sym_AT_ATt] = ACTIONS(494),
    [anon_sym_AT_ATb] = ACTIONS(494),
    [anon_sym_AT_ATi] = ACTIONS(496),
    [anon_sym_AT_ATiS] = ACTIONS(494),
    [anon_sym_AT_ATf] = ACTIONS(494),
    [anon_sym_AT_ATs_COLON] = ACTIONS(494),
    [anon_sym_AT_ATc_COLON] = ACTIONS(494),
    [anon_sym_AT] = ACTIONS(496),
    [anon_sym_AT_BANG] = ACTIONS(494),
    [anon_sym_AT_LBRACE] = ACTIONS(494),
    [anon_sym_ATa_COLON] = ACTIONS(494),
    [anon_sym_ATb_COLON] = ACTIONS(494),
    [anon_sym_ATB_COLON] = ACTIONS(494),
    [anon_sym_ATe_COLON] = ACTIONS(494),
    [anon_sym_ATF_COLON] = ACTIONS(494),
    [anon_sym_ATi_COLON] = ACTIONS(494),
    [anon_sym_ATk_COLON] = ACTIONS(494),
    [anon_sym_ATo_COLON] = ACTIONS(494),
    [anon_sym_ATr_COLON] = ACTIONS(494),
    [anon_sym_ATf_COLON] = ACTIONS(494),
    [anon_sym_ATs_COLON] = ACTIONS(494),
    [anon_sym_ATx_COLON] = ACTIONS(494),
    [anon_sym_PIPE_DOT] = ACTIONS(494),
    [anon_sym_RPAREN] = ACTIONS(494),
    [anon_sym_SEMI] = ACTIONS(494),
    [anon_sym_GT] = ACTIONS(496),
    [anon_sym_GT_GT] = ACTIONS(494),
    [sym_html_redirect_operator] = ACTIONS(496),
    [sym_html_append_operator] = ACTIONS(494),
    [anon_sym_COMMA] = ACTIONS(498),
    [anon_sym_BQUOTE] = ACTIONS(494),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(494),
    [anon_sym_CR] = ACTIONS(494),
    [sym_file_descriptor] = ACTIONS(494),
  },
  [158] = {
    [aux_sym_concatenation_repeat1] = STATE(158),
    [ts_builtin_sym_end] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(319),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_PIPEH] = ACTIONS(319),
    [anon_sym_PIPET] = ACTIONS(319),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATi] = ACTIONS(319),
    [anon_sym_AT_AT_ATr] = ACTIONS(319),
    [anon_sym_AT_AT_ATs] = ACTIONS(321),
    [anon_sym_AT_AT_ATst] = ACTIONS(319),
    [anon_sym_AT_AT_ATS] = ACTIONS(319),
    [anon_sym_AT_AT_ATm] = ACTIONS(319),
    [anon_sym_AT_AT_ATM] = ACTIONS(319),
    [anon_sym_AT_AT_ATf] = ACTIONS(321),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATF] = ACTIONS(321),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(319),
    [anon_sym_AT_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_AT] = ACTIONS(321),
    [anon_sym_AT_ATdbt] = ACTIONS(321),
    [anon_sym_AT_ATdbta] = ACTIONS(319),
    [anon_sym_AT_ATdbtb] = ACTIONS(319),
    [anon_sym_AT_ATdbts] = ACTIONS(319),
    [anon_sym_AT_AT_DOT] = ACTIONS(319),
    [anon_sym_AT_AT_EQ] = ACTIONS(319),
    [anon_sym_AT_ATk] = ACTIONS(319),
    [anon_sym_AT_ATt] = ACTIONS(319),
    [anon_sym_AT_ATb] = ACTIONS(319),
    [anon_sym_AT_ATi] = ACTIONS(321),
    [anon_sym_AT_ATiS] = ACTIONS(319),
    [anon_sym_AT_ATf] = ACTIONS(319),
    [anon_sym_AT_ATs_COLON] = ACTIONS(319),
    [anon_sym_AT_ATc_COLON] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_AT_BANG] = ACTIONS(319),
    [anon_sym_AT_LBRACE] = ACTIONS(319),
    [anon_sym_ATa_COLON] = ACTIONS(319),
    [anon_sym_ATb_COLON] = ACTIONS(319),
    [anon_sym_ATB_COLON] = ACTIONS(319),
    [anon_sym_ATe_COLON] = ACTIONS(319),
    [anon_sym_ATF_COLON] = ACTIONS(319),
    [anon_sym_ATi_COLON] = ACTIONS(319),
    [anon_sym_ATk_COLON] = ACTIONS(319),
    [anon_sym_ATo_COLON] = ACTIONS(319),
    [anon_sym_ATr_COLON] = ACTIONS(319),
    [anon_sym_ATf_COLON] = ACTIONS(319),
    [anon_sym_ATs_COLON] = ACTIONS(319),
    [anon_sym_ATx_COLON] = ACTIONS(319),
    [anon_sym_PIPE_DOT] = ACTIONS(319),
    [anon_sym_RPAREN] = ACTIONS(319),
    [anon_sym_SEMI] = ACTIONS(319),
    [anon_sym_GT] = ACTIONS(321),
    [anon_sym_GT_GT] = ACTIONS(319),
    [sym_html_redirect_operator] = ACTIONS(321),
    [sym_html_append_operator] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(319),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(319),
    [anon_sym_CR] = ACTIONS(319),
    [sym_file_descriptor] = ACTIONS(319),
    [sym__concat] = ACTIONS(501),
  },
  [159] = {
    [aux_sym_eq_sep_val_repeat1] = STATE(159),
    [ts_builtin_sym_end] = ACTIONS(504),
    [anon_sym_TILDE] = ACTIONS(504),
    [anon_sym_PIPE] = ACTIONS(506),
    [anon_sym_PIPEH] = ACTIONS(504),
    [anon_sym_PIPET] = ACTIONS(504),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(504),
    [anon_sym_AT_AT_ATb] = ACTIONS(504),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(504),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(504),
    [anon_sym_AT_AT_ATi] = ACTIONS(504),
    [anon_sym_AT_AT_ATr] = ACTIONS(504),
    [anon_sym_AT_AT_ATs] = ACTIONS(506),
    [anon_sym_AT_AT_ATst] = ACTIONS(504),
    [anon_sym_AT_AT_ATS] = ACTIONS(504),
    [anon_sym_AT_AT_ATm] = ACTIONS(504),
    [anon_sym_AT_AT_ATM] = ACTIONS(504),
    [anon_sym_AT_AT_ATf] = ACTIONS(506),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(504),
    [anon_sym_AT_AT_ATF] = ACTIONS(506),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(504),
    [anon_sym_AT_AT_ATt] = ACTIONS(504),
    [anon_sym_AT_AT] = ACTIONS(506),
    [anon_sym_AT_ATdbt] = ACTIONS(506),
    [anon_sym_AT_ATdbta] = ACTIONS(504),
    [anon_sym_AT_ATdbtb] = ACTIONS(504),
    [anon_sym_AT_ATdbts] = ACTIONS(504),
    [anon_sym_AT_AT_DOT] = ACTIONS(504),
    [anon_sym_AT_AT_EQ] = ACTIONS(504),
    [anon_sym_AT_ATk] = ACTIONS(504),
    [anon_sym_AT_ATt] = ACTIONS(504),
    [anon_sym_AT_ATb] = ACTIONS(504),
    [anon_sym_AT_ATi] = ACTIONS(506),
    [anon_sym_AT_ATiS] = ACTIONS(504),
    [anon_sym_AT_ATf] = ACTIONS(504),
    [anon_sym_AT_ATs_COLON] = ACTIONS(504),
    [anon_sym_AT_ATc_COLON] = ACTIONS(504),
    [anon_sym_AT] = ACTIONS(506),
    [anon_sym_AT_BANG] = ACTIONS(504),
    [anon_sym_AT_LBRACE] = ACTIONS(504),
    [anon_sym_ATa_COLON] = ACTIONS(504),
    [anon_sym_ATb_COLON] = ACTIONS(504),
    [anon_sym_ATB_COLON] = ACTIONS(504),
    [anon_sym_ATe_COLON] = ACTIONS(504),
    [anon_sym_ATF_COLON] = ACTIONS(504),
    [anon_sym_ATi_COLON] = ACTIONS(504),
    [anon_sym_ATk_COLON] = ACTIONS(504),
    [anon_sym_ATo_COLON] = ACTIONS(504),
    [anon_sym_ATr_COLON] = ACTIONS(504),
    [anon_sym_ATf_COLON] = ACTIONS(504),
    [anon_sym_ATs_COLON] = ACTIONS(504),
    [anon_sym_ATx_COLON] = ACTIONS(504),
    [anon_sym_PIPE_DOT] = ACTIONS(504),
    [anon_sym_RPAREN] = ACTIONS(504),
    [anon_sym_SEMI] = ACTIONS(504),
    [anon_sym_GT] = ACTIONS(506),
    [anon_sym_GT_GT] = ACTIONS(504),
    [sym_html_redirect_operator] = ACTIONS(506),
    [sym_html_append_operator] = ACTIONS(504),
    [anon_sym_BQUOTE] = ACTIONS(504),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(504),
    [anon_sym_CR] = ACTIONS(504),
    [sym_file_descriptor] = ACTIONS(504),
    [sym__eq_sep_concat] = ACTIONS(508),
  },
  [160] = {
    [ts_builtin_sym_end] = ACTIONS(346),
    [anon_sym_TILDE] = ACTIONS(346),
    [anon_sym_PIPE] = ACTIONS(348),
    [anon_sym_PIPEH] = ACTIONS(346),
    [anon_sym_PIPET] = ACTIONS(346),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(346),
    [anon_sym_AT_AT_ATb] = ACTIONS(346),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATi] = ACTIONS(346),
    [anon_sym_AT_AT_ATr] = ACTIONS(346),
    [anon_sym_AT_AT_ATs] = ACTIONS(348),
    [anon_sym_AT_AT_ATst] = ACTIONS(346),
    [anon_sym_AT_AT_ATS] = ACTIONS(346),
    [anon_sym_AT_AT_ATm] = ACTIONS(346),
    [anon_sym_AT_AT_ATM] = ACTIONS(346),
    [anon_sym_AT_AT_ATf] = ACTIONS(348),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATF] = ACTIONS(348),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(346),
    [anon_sym_AT_AT_ATt] = ACTIONS(346),
    [anon_sym_AT_AT] = ACTIONS(348),
    [anon_sym_AT_ATdbt] = ACTIONS(348),
    [anon_sym_AT_ATdbta] = ACTIONS(346),
    [anon_sym_AT_ATdbtb] = ACTIONS(346),
    [anon_sym_AT_ATdbts] = ACTIONS(346),
    [anon_sym_AT_AT_DOT] = ACTIONS(346),
    [anon_sym_AT_AT_EQ] = ACTIONS(346),
    [anon_sym_AT_ATk] = ACTIONS(346),
    [anon_sym_AT_ATt] = ACTIONS(346),
    [anon_sym_AT_ATb] = ACTIONS(346),
    [anon_sym_AT_ATi] = ACTIONS(348),
    [anon_sym_AT_ATiS] = ACTIONS(346),
    [anon_sym_AT_ATf] = ACTIONS(346),
    [anon_sym_AT_ATs_COLON] = ACTIONS(346),
    [anon_sym_AT_ATc_COLON] = ACTIONS(346),
    [anon_sym_AT] = ACTIONS(348),
    [anon_sym_AT_BANG] = ACTIONS(346),
    [anon_sym_AT_LBRACE] = ACTIONS(346),
    [anon_sym_ATa_COLON] = ACTIONS(346),
    [anon_sym_ATb_COLON] = ACTIONS(346),
    [anon_sym_ATB_COLON] = ACTIONS(346),
    [anon_sym_ATe_COLON] = ACTIONS(346),
    [anon_sym_ATF_COLON] = ACTIONS(346),
    [anon_sym_ATi_COLON] = ACTIONS(346),
    [anon_sym_ATk_COLON] = ACTIONS(346),
    [anon_sym_ATo_COLON] = ACTIONS(346),
    [anon_sym_ATr_COLON] = ACTIONS(346),
    [anon_sym_ATf_COLON] = ACTIONS(346),
    [anon_sym_ATs_COLON] = ACTIONS(346),
    [anon_sym_ATx_COLON] = ACTIONS(346),
    [anon_sym_PIPE_DOT] = ACTIONS(346),
    [anon_sym_EQ] = ACTIONS(346),
    [anon_sym_RPAREN] = ACTIONS(346),
    [anon_sym_SEMI] = ACTIONS(346),
    [anon_sym_GT] = ACTIONS(348),
    [anon_sym_GT_GT] = ACTIONS(346),
    [sym_html_redirect_operator] = ACTIONS(348),
    [sym_html_append_operator] = ACTIONS(346),
    [anon_sym_BQUOTE] = ACTIONS(346),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(346),
    [anon_sym_CR] = ACTIONS(346),
    [sym_file_descriptor] = ACTIONS(346),
    [sym__eq_sep_concat] = ACTIONS(346),
  },
  [161] = {
    [ts_builtin_sym_end] = ACTIONS(511),
    [anon_sym_TILDE] = ACTIONS(511),
    [anon_sym_PIPE] = ACTIONS(513),
    [anon_sym_PIPEH] = ACTIONS(511),
    [anon_sym_PIPET] = ACTIONS(511),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(511),
    [anon_sym_AT_AT_ATb] = ACTIONS(511),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(511),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(511),
    [anon_sym_AT_AT_ATi] = ACTIONS(511),
    [anon_sym_AT_AT_ATr] = ACTIONS(511),
    [anon_sym_AT_AT_ATs] = ACTIONS(513),
    [anon_sym_AT_AT_ATst] = ACTIONS(511),
    [anon_sym_AT_AT_ATS] = ACTIONS(511),
    [anon_sym_AT_AT_ATm] = ACTIONS(511),
    [anon_sym_AT_AT_ATM] = ACTIONS(511),
    [anon_sym_AT_AT_ATf] = ACTIONS(513),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(511),
    [anon_sym_AT_AT_ATF] = ACTIONS(513),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(511),
    [anon_sym_AT_AT_ATt] = ACTIONS(511),
    [anon_sym_AT_AT] = ACTIONS(513),
    [anon_sym_AT_ATdbt] = ACTIONS(513),
    [anon_sym_AT_ATdbta] = ACTIONS(511),
    [anon_sym_AT_ATdbtb] = ACTIONS(511),
    [anon_sym_AT_ATdbts] = ACTIONS(511),
    [anon_sym_AT_AT_DOT] = ACTIONS(511),
    [anon_sym_AT_AT_EQ] = ACTIONS(511),
    [anon_sym_AT_ATk] = ACTIONS(511),
    [anon_sym_AT_ATt] = ACTIONS(511),
    [anon_sym_AT_ATb] = ACTIONS(511),
    [anon_sym_AT_ATi] = ACTIONS(513),
    [anon_sym_AT_ATiS] = ACTIONS(511),
    [anon_sym_AT_ATf] = ACTIONS(511),
    [anon_sym_AT_ATs_COLON] = ACTIONS(511),
    [anon_sym_AT_ATc_COLON] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_AT_BANG] = ACTIONS(511),
    [anon_sym_AT_LBRACE] = ACTIONS(511),
    [anon_sym_ATa_COLON] = ACTIONS(511),
    [anon_sym_ATb_COLON] = ACTIONS(511),
    [anon_sym_ATB_COLON] = ACTIONS(511),
    [anon_sym_ATe_COLON] = ACTIONS(511),
    [anon_sym_ATF_COLON] = ACTIONS(511),
    [anon_sym_ATi_COLON] = ACTIONS(511),
    [anon_sym_ATk_COLON] = ACTIONS(511),
    [anon_sym_ATo_COLON] = ACTIONS(511),
    [anon_sym_ATr_COLON] = ACTIONS(511),
    [anon_sym_ATf_COLON] = ACTIONS(511),
    [anon_sym_ATs_COLON] = ACTIONS(511),
    [anon_sym_ATx_COLON] = ACTIONS(511),
    [anon_sym_PIPE_DOT] = ACTIONS(511),
    [anon_sym_EQ] = ACTIONS(511),
    [anon_sym_RPAREN] = ACTIONS(511),
    [anon_sym_SEMI] = ACTIONS(511),
    [anon_sym_GT] = ACTIONS(513),
    [anon_sym_GT_GT] = ACTIONS(511),
    [sym_html_redirect_operator] = ACTIONS(513),
    [sym_html_append_operator] = ACTIONS(511),
    [anon_sym_BQUOTE] = ACTIONS(511),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(511),
    [anon_sym_CR] = ACTIONS(511),
    [sym_file_descriptor] = ACTIONS(511),
    [sym__concat_pf_dot] = ACTIONS(511),
  },
  [162] = {
    [ts_builtin_sym_end] = ACTIONS(338),
    [anon_sym_TILDE] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(340),
    [anon_sym_PIPEH] = ACTIONS(338),
    [anon_sym_PIPET] = ACTIONS(338),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(338),
    [anon_sym_AT_AT_ATb] = ACTIONS(338),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATi] = ACTIONS(338),
    [anon_sym_AT_AT_ATr] = ACTIONS(338),
    [anon_sym_AT_AT_ATs] = ACTIONS(340),
    [anon_sym_AT_AT_ATst] = ACTIONS(338),
    [anon_sym_AT_AT_ATS] = ACTIONS(338),
    [anon_sym_AT_AT_ATm] = ACTIONS(338),
    [anon_sym_AT_AT_ATM] = ACTIONS(338),
    [anon_sym_AT_AT_ATf] = ACTIONS(340),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATF] = ACTIONS(340),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(338),
    [anon_sym_AT_AT_ATt] = ACTIONS(338),
    [anon_sym_AT_AT] = ACTIONS(340),
    [anon_sym_AT_ATdbt] = ACTIONS(340),
    [anon_sym_AT_ATdbta] = ACTIONS(338),
    [anon_sym_AT_ATdbtb] = ACTIONS(338),
    [anon_sym_AT_ATdbts] = ACTIONS(338),
    [anon_sym_AT_AT_DOT] = ACTIONS(338),
    [anon_sym_AT_AT_EQ] = ACTIONS(338),
    [anon_sym_AT_ATk] = ACTIONS(338),
    [anon_sym_AT_ATt] = ACTIONS(338),
    [anon_sym_AT_ATb] = ACTIONS(338),
    [anon_sym_AT_ATi] = ACTIONS(340),
    [anon_sym_AT_ATiS] = ACTIONS(338),
    [anon_sym_AT_ATf] = ACTIONS(338),
    [anon_sym_AT_ATs_COLON] = ACTIONS(338),
    [anon_sym_AT_ATc_COLON] = ACTIONS(338),
    [anon_sym_AT] = ACTIONS(340),
    [anon_sym_AT_BANG] = ACTIONS(338),
    [anon_sym_AT_LBRACE] = ACTIONS(338),
    [anon_sym_ATa_COLON] = ACTIONS(338),
    [anon_sym_ATb_COLON] = ACTIONS(338),
    [anon_sym_ATB_COLON] = ACTIONS(338),
    [anon_sym_ATe_COLON] = ACTIONS(338),
    [anon_sym_ATF_COLON] = ACTIONS(338),
    [anon_sym_ATi_COLON] = ACTIONS(338),
    [anon_sym_ATk_COLON] = ACTIONS(338),
    [anon_sym_ATo_COLON] = ACTIONS(338),
    [anon_sym_ATr_COLON] = ACTIONS(338),
    [anon_sym_ATf_COLON] = ACTIONS(338),
    [anon_sym_ATs_COLON] = ACTIONS(338),
    [anon_sym_ATx_COLON] = ACTIONS(338),
    [anon_sym_PIPE_DOT] = ACTIONS(338),
    [anon_sym_EQ] = ACTIONS(338),
    [anon_sym_RPAREN] = ACTIONS(338),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_GT] = ACTIONS(340),
    [anon_sym_GT_GT] = ACTIONS(338),
    [sym_html_redirect_operator] = ACTIONS(340),
    [sym_html_append_operator] = ACTIONS(338),
    [anon_sym_BQUOTE] = ACTIONS(338),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(338),
    [anon_sym_CR] = ACTIONS(338),
    [sym_file_descriptor] = ACTIONS(338),
    [sym__eq_sep_concat] = ACTIONS(338),
  },
  [163] = {
    [aux_sym_concatenation_repeat1] = STATE(158),
    [ts_builtin_sym_end] = ACTIONS(309),
    [anon_sym_TILDE] = ACTIONS(309),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_PIPEH] = ACTIONS(309),
    [anon_sym_PIPET] = ACTIONS(309),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(309),
    [anon_sym_AT_AT_ATb] = ACTIONS(309),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATi] = ACTIONS(309),
    [anon_sym_AT_AT_ATr] = ACTIONS(309),
    [anon_sym_AT_AT_ATs] = ACTIONS(311),
    [anon_sym_AT_AT_ATst] = ACTIONS(309),
    [anon_sym_AT_AT_ATS] = ACTIONS(309),
    [anon_sym_AT_AT_ATm] = ACTIONS(309),
    [anon_sym_AT_AT_ATM] = ACTIONS(309),
    [anon_sym_AT_AT_ATf] = ACTIONS(311),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATF] = ACTIONS(311),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(309),
    [anon_sym_AT_AT_ATt] = ACTIONS(309),
    [anon_sym_AT_AT] = ACTIONS(311),
    [anon_sym_AT_ATdbt] = ACTIONS(311),
    [anon_sym_AT_ATdbta] = ACTIONS(309),
    [anon_sym_AT_ATdbtb] = ACTIONS(309),
    [anon_sym_AT_ATdbts] = ACTIONS(309),
    [anon_sym_AT_AT_DOT] = ACTIONS(309),
    [anon_sym_AT_AT_EQ] = ACTIONS(309),
    [anon_sym_AT_ATk] = ACTIONS(309),
    [anon_sym_AT_ATt] = ACTIONS(309),
    [anon_sym_AT_ATb] = ACTIONS(309),
    [anon_sym_AT_ATi] = ACTIONS(311),
    [anon_sym_AT_ATiS] = ACTIONS(309),
    [anon_sym_AT_ATf] = ACTIONS(309),
    [anon_sym_AT_ATs_COLON] = ACTIONS(309),
    [anon_sym_AT_ATc_COLON] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(311),
    [anon_sym_AT_BANG] = ACTIONS(309),
    [anon_sym_AT_LBRACE] = ACTIONS(309),
    [anon_sym_ATa_COLON] = ACTIONS(309),
    [anon_sym_ATb_COLON] = ACTIONS(309),
    [anon_sym_ATB_COLON] = ACTIONS(309),
    [anon_sym_ATe_COLON] = ACTIONS(309),
    [anon_sym_ATF_COLON] = ACTIONS(309),
    [anon_sym_ATi_COLON] = ACTIONS(309),
    [anon_sym_ATk_COLON] = ACTIONS(309),
    [anon_sym_ATo_COLON] = ACTIONS(309),
    [anon_sym_ATr_COLON] = ACTIONS(309),
    [anon_sym_ATf_COLON] = ACTIONS(309),
    [anon_sym_ATs_COLON] = ACTIONS(309),
    [anon_sym_ATx_COLON] = ACTIONS(309),
    [anon_sym_PIPE_DOT] = ACTIONS(309),
    [anon_sym_RPAREN] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_GT] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(309),
    [sym_html_redirect_operator] = ACTIONS(311),
    [sym_html_append_operator] = ACTIONS(309),
    [anon_sym_BQUOTE] = ACTIONS(309),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(309),
    [anon_sym_CR] = ACTIONS(309),
    [sym_file_descriptor] = ACTIONS(309),
    [sym__concat] = ACTIONS(515),
  },
  [164] = {
    [ts_builtin_sym_end] = ACTIONS(342),
    [anon_sym_TILDE] = ACTIONS(342),
    [anon_sym_PIPE] = ACTIONS(344),
    [anon_sym_PIPEH] = ACTIONS(342),
    [anon_sym_PIPET] = ACTIONS(342),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(342),
    [anon_sym_AT_AT_ATb] = ACTIONS(342),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATi] = ACTIONS(342),
    [anon_sym_AT_AT_ATr] = ACTIONS(342),
    [anon_sym_AT_AT_ATs] = ACTIONS(344),
    [anon_sym_AT_AT_ATst] = ACTIONS(342),
    [anon_sym_AT_AT_ATS] = ACTIONS(342),
    [anon_sym_AT_AT_ATm] = ACTIONS(342),
    [anon_sym_AT_AT_ATM] = ACTIONS(342),
    [anon_sym_AT_AT_ATf] = ACTIONS(344),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATF] = ACTIONS(344),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(342),
    [anon_sym_AT_AT_ATt] = ACTIONS(342),
    [anon_sym_AT_AT] = ACTIONS(344),
    [anon_sym_AT_ATdbt] = ACTIONS(344),
    [anon_sym_AT_ATdbta] = ACTIONS(342),
    [anon_sym_AT_ATdbtb] = ACTIONS(342),
    [anon_sym_AT_ATdbts] = ACTIONS(342),
    [anon_sym_AT_AT_DOT] = ACTIONS(342),
    [anon_sym_AT_AT_EQ] = ACTIONS(342),
    [anon_sym_AT_ATk] = ACTIONS(342),
    [anon_sym_AT_ATt] = ACTIONS(342),
    [anon_sym_AT_ATb] = ACTIONS(342),
    [anon_sym_AT_ATi] = ACTIONS(344),
    [anon_sym_AT_ATiS] = ACTIONS(342),
    [anon_sym_AT_ATf] = ACTIONS(342),
    [anon_sym_AT_ATs_COLON] = ACTIONS(342),
    [anon_sym_AT_ATc_COLON] = ACTIONS(342),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_AT_BANG] = ACTIONS(342),
    [anon_sym_AT_LBRACE] = ACTIONS(342),
    [anon_sym_ATa_COLON] = ACTIONS(342),
    [anon_sym_ATb_COLON] = ACTIONS(342),
    [anon_sym_ATB_COLON] = ACTIONS(342),
    [anon_sym_ATe_COLON] = ACTIONS(342),
    [anon_sym_ATF_COLON] = ACTIONS(342),
    [anon_sym_ATi_COLON] = ACTIONS(342),
    [anon_sym_ATk_COLON] = ACTIONS(342),
    [anon_sym_ATo_COLON] = ACTIONS(342),
    [anon_sym_ATr_COLON] = ACTIONS(342),
    [anon_sym_ATf_COLON] = ACTIONS(342),
    [anon_sym_ATs_COLON] = ACTIONS(342),
    [anon_sym_ATx_COLON] = ACTIONS(342),
    [anon_sym_PIPE_DOT] = ACTIONS(342),
    [anon_sym_EQ] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(342),
    [anon_sym_SEMI] = ACTIONS(342),
    [anon_sym_GT] = ACTIONS(344),
    [anon_sym_GT_GT] = ACTIONS(342),
    [sym_html_redirect_operator] = ACTIONS(344),
    [sym_html_append_operator] = ACTIONS(342),
    [anon_sym_BQUOTE] = ACTIONS(342),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(342),
    [anon_sym_CR] = ACTIONS(342),
    [sym_file_descriptor] = ACTIONS(342),
    [sym__eq_sep_concat] = ACTIONS(342),
  },
  [165] = {
    [aux_sym_tmp_eval_args_repeat1] = STATE(150),
    [ts_builtin_sym_end] = ACTIONS(517),
    [anon_sym_TILDE] = ACTIONS(517),
    [anon_sym_PIPE] = ACTIONS(519),
    [anon_sym_PIPEH] = ACTIONS(517),
    [anon_sym_PIPET] = ACTIONS(517),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(517),
    [anon_sym_AT_AT_ATb] = ACTIONS(517),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(517),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(517),
    [anon_sym_AT_AT_ATi] = ACTIONS(517),
    [anon_sym_AT_AT_ATr] = ACTIONS(517),
    [anon_sym_AT_AT_ATs] = ACTIONS(519),
    [anon_sym_AT_AT_ATst] = ACTIONS(517),
    [anon_sym_AT_AT_ATS] = ACTIONS(517),
    [anon_sym_AT_AT_ATm] = ACTIONS(517),
    [anon_sym_AT_AT_ATM] = ACTIONS(517),
    [anon_sym_AT_AT_ATf] = ACTIONS(519),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(517),
    [anon_sym_AT_AT_ATF] = ACTIONS(519),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(517),
    [anon_sym_AT_AT_ATt] = ACTIONS(517),
    [anon_sym_AT_AT] = ACTIONS(519),
    [anon_sym_AT_ATdbt] = ACTIONS(519),
    [anon_sym_AT_ATdbta] = ACTIONS(517),
    [anon_sym_AT_ATdbtb] = ACTIONS(517),
    [anon_sym_AT_ATdbts] = ACTIONS(517),
    [anon_sym_AT_AT_DOT] = ACTIONS(517),
    [anon_sym_AT_AT_EQ] = ACTIONS(517),
    [anon_sym_AT_ATk] = ACTIONS(517),
    [anon_sym_AT_ATt] = ACTIONS(517),
    [anon_sym_AT_ATb] = ACTIONS(517),
    [anon_sym_AT_ATi] = ACTIONS(519),
    [anon_sym_AT_ATiS] = ACTIONS(517),
    [anon_sym_AT_ATf] = ACTIONS(517),
    [anon_sym_AT_ATs_COLON] = ACTIONS(517),
    [anon_sym_AT_ATc_COLON] = ACTIONS(517),
    [anon_sym_AT] = ACTIONS(519),
    [anon_sym_AT_BANG] = ACTIONS(517),
    [anon_sym_AT_LBRACE] = ACTIONS(517),
    [anon_sym_ATa_COLON] = ACTIONS(517),
    [anon_sym_ATb_COLON] = ACTIONS(517),
    [anon_sym_ATB_COLON] = ACTIONS(517),
    [anon_sym_ATe_COLON] = ACTIONS(517),
    [anon_sym_ATF_COLON] = ACTIONS(517),
    [anon_sym_ATi_COLON] = ACTIONS(517),
    [anon_sym_ATk_COLON] = ACTIONS(517),
    [anon_sym_ATo_COLON] = ACTIONS(517),
    [anon_sym_ATr_COLON] = ACTIONS(517),
    [anon_sym_ATf_COLON] = ACTIONS(517),
    [anon_sym_ATs_COLON] = ACTIONS(517),
    [anon_sym_ATx_COLON] = ACTIONS(517),
    [anon_sym_PIPE_DOT] = ACTIONS(517),
    [anon_sym_RPAREN] = ACTIONS(517),
    [anon_sym_SEMI] = ACTIONS(517),
    [anon_sym_GT] = ACTIONS(519),
    [anon_sym_GT_GT] = ACTIONS(517),
    [sym_html_redirect_operator] = ACTIONS(519),
    [sym_html_append_operator] = ACTIONS(517),
    [anon_sym_COMMA] = ACTIONS(482),
    [anon_sym_BQUOTE] = ACTIONS(517),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(517),
    [anon_sym_CR] = ACTIONS(517),
    [sym_file_descriptor] = ACTIONS(517),
  },
  [166] = {
    [aux_sym_concatenation_repeat1] = STATE(163),
    [ts_builtin_sym_end] = ACTIONS(315),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_PIPE] = ACTIONS(317),
    [anon_sym_PIPEH] = ACTIONS(315),
    [anon_sym_PIPET] = ACTIONS(315),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(315),
    [anon_sym_AT_AT_ATb] = ACTIONS(315),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATi] = ACTIONS(315),
    [anon_sym_AT_AT_ATr] = ACTIONS(315),
    [anon_sym_AT_AT_ATs] = ACTIONS(317),
    [anon_sym_AT_AT_ATst] = ACTIONS(315),
    [anon_sym_AT_AT_ATS] = ACTIONS(315),
    [anon_sym_AT_AT_ATm] = ACTIONS(315),
    [anon_sym_AT_AT_ATM] = ACTIONS(315),
    [anon_sym_AT_AT_ATf] = ACTIONS(317),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATF] = ACTIONS(317),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(315),
    [anon_sym_AT_AT_ATt] = ACTIONS(315),
    [anon_sym_AT_AT] = ACTIONS(317),
    [anon_sym_AT_ATdbt] = ACTIONS(317),
    [anon_sym_AT_ATdbta] = ACTIONS(315),
    [anon_sym_AT_ATdbtb] = ACTIONS(315),
    [anon_sym_AT_ATdbts] = ACTIONS(315),
    [anon_sym_AT_AT_DOT] = ACTIONS(315),
    [anon_sym_AT_AT_EQ] = ACTIONS(315),
    [anon_sym_AT_ATk] = ACTIONS(315),
    [anon_sym_AT_ATt] = ACTIONS(315),
    [anon_sym_AT_ATb] = ACTIONS(315),
    [anon_sym_AT_ATi] = ACTIONS(317),
    [anon_sym_AT_ATiS] = ACTIONS(315),
    [anon_sym_AT_ATf] = ACTIONS(315),
    [anon_sym_AT_ATs_COLON] = ACTIONS(315),
    [anon_sym_AT_ATc_COLON] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_AT_BANG] = ACTIONS(315),
    [anon_sym_AT_LBRACE] = ACTIONS(315),
    [anon_sym_ATa_COLON] = ACTIONS(315),
    [anon_sym_ATb_COLON] = ACTIONS(315),
    [anon_sym_ATB_COLON] = ACTIONS(315),
    [anon_sym_ATe_COLON] = ACTIONS(315),
    [anon_sym_ATF_COLON] = ACTIONS(315),
    [anon_sym_ATi_COLON] = ACTIONS(315),
    [anon_sym_ATk_COLON] = ACTIONS(315),
    [anon_sym_ATo_COLON] = ACTIONS(315),
    [anon_sym_ATr_COLON] = ACTIONS(315),
    [anon_sym_ATf_COLON] = ACTIONS(315),
    [anon_sym_ATs_COLON] = ACTIONS(315),
    [anon_sym_ATx_COLON] = ACTIONS(315),
    [anon_sym_PIPE_DOT] = ACTIONS(315),
    [anon_sym_RPAREN] = ACTIONS(315),
    [anon_sym_SEMI] = ACTIONS(315),
    [anon_sym_GT] = ACTIONS(317),
    [anon_sym_GT_GT] = ACTIONS(315),
    [sym_html_redirect_operator] = ACTIONS(317),
    [sym_html_append_operator] = ACTIONS(315),
    [anon_sym_BQUOTE] = ACTIONS(315),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(315),
    [anon_sym_CR] = ACTIONS(315),
    [sym_file_descriptor] = ACTIONS(315),
    [sym__concat] = ACTIONS(515),
  },
  [167] = {
    [sym_macro_call_full_content] = STATE(224),
    [ts_builtin_sym_end] = ACTIONS(521),
    [anon_sym_TILDE] = ACTIONS(521),
    [anon_sym_PIPE] = ACTIONS(523),
    [anon_sym_PIPEH] = ACTIONS(521),
    [anon_sym_PIPET] = ACTIONS(521),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(521),
    [anon_sym_AT_AT_ATb] = ACTIONS(521),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(521),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(521),
    [anon_sym_AT_AT_ATi] = ACTIONS(521),
    [anon_sym_AT_AT_ATr] = ACTIONS(521),
    [anon_sym_AT_AT_ATs] = ACTIONS(523),
    [anon_sym_AT_AT_ATst] = ACTIONS(521),
    [anon_sym_AT_AT_ATS] = ACTIONS(521),
    [anon_sym_AT_AT_ATm] = ACTIONS(521),
    [anon_sym_AT_AT_ATM] = ACTIONS(521),
    [anon_sym_AT_AT_ATf] = ACTIONS(523),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(521),
    [anon_sym_AT_AT_ATF] = ACTIONS(523),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(521),
    [anon_sym_AT_AT_ATt] = ACTIONS(521),
    [anon_sym_AT_AT] = ACTIONS(523),
    [anon_sym_AT_ATdbt] = ACTIONS(523),
    [anon_sym_AT_ATdbta] = ACTIONS(521),
    [anon_sym_AT_ATdbtb] = ACTIONS(521),
    [anon_sym_AT_ATdbts] = ACTIONS(521),
    [anon_sym_AT_AT_DOT] = ACTIONS(521),
    [anon_sym_AT_AT_EQ] = ACTIONS(521),
    [anon_sym_AT_ATk] = ACTIONS(521),
    [anon_sym_AT_ATt] = ACTIONS(521),
    [anon_sym_AT_ATb] = ACTIONS(521),
    [anon_sym_AT_ATi] = ACTIONS(523),
    [anon_sym_AT_ATiS] = ACTIONS(521),
    [anon_sym_AT_ATf] = ACTIONS(521),
    [anon_sym_AT_ATs_COLON] = ACTIONS(521),
    [anon_sym_AT_ATc_COLON] = ACTIONS(521),
    [anon_sym_AT] = ACTIONS(523),
    [anon_sym_AT_BANG] = ACTIONS(521),
    [anon_sym_AT_LBRACE] = ACTIONS(521),
    [anon_sym_ATa_COLON] = ACTIONS(521),
    [anon_sym_ATb_COLON] = ACTIONS(521),
    [anon_sym_ATB_COLON] = ACTIONS(521),
    [anon_sym_ATe_COLON] = ACTIONS(521),
    [anon_sym_ATF_COLON] = ACTIONS(521),
    [anon_sym_ATi_COLON] = ACTIONS(521),
    [anon_sym_ATk_COLON] = ACTIONS(521),
    [anon_sym_ATo_COLON] = ACTIONS(521),
    [anon_sym_ATr_COLON] = ACTIONS(521),
    [anon_sym_ATf_COLON] = ACTIONS(521),
    [anon_sym_ATs_COLON] = ACTIONS(521),
    [anon_sym_ATx_COLON] = ACTIONS(521),
    [anon_sym_PIPE_DOT] = ACTIONS(521),
    [anon_sym_LPAREN] = ACTIONS(525),
    [anon_sym_RPAREN] = ACTIONS(521),
    [anon_sym_SEMI] = ACTIONS(521),
    [anon_sym_GT] = ACTIONS(523),
    [anon_sym_GT_GT] = ACTIONS(521),
    [sym_html_redirect_operator] = ACTIONS(523),
    [sym_html_append_operator] = ACTIONS(521),
    [anon_sym_BQUOTE] = ACTIONS(521),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(521),
    [anon_sym_CR] = ACTIONS(521),
    [sym_file_descriptor] = ACTIONS(521),
  },
  [168] = {
    [ts_builtin_sym_end] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_PIPE] = ACTIONS(529),
    [anon_sym_PIPEH] = ACTIONS(527),
    [anon_sym_PIPET] = ACTIONS(527),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(527),
    [anon_sym_AT_AT_ATb] = ACTIONS(527),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(527),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(527),
    [anon_sym_AT_AT_ATi] = ACTIONS(527),
    [anon_sym_AT_AT_ATr] = ACTIONS(527),
    [anon_sym_AT_AT_ATs] = ACTIONS(529),
    [anon_sym_AT_AT_ATst] = ACTIONS(527),
    [anon_sym_AT_AT_ATS] = ACTIONS(527),
    [anon_sym_AT_AT_ATm] = ACTIONS(527),
    [anon_sym_AT_AT_ATM] = ACTIONS(527),
    [anon_sym_AT_AT_ATf] = ACTIONS(529),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(527),
    [anon_sym_AT_AT_ATF] = ACTIONS(529),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(527),
    [anon_sym_AT_AT_ATt] = ACTIONS(527),
    [anon_sym_AT_AT] = ACTIONS(529),
    [anon_sym_AT_ATdbt] = ACTIONS(529),
    [anon_sym_AT_ATdbta] = ACTIONS(527),
    [anon_sym_AT_ATdbtb] = ACTIONS(527),
    [anon_sym_AT_ATdbts] = ACTIONS(527),
    [anon_sym_AT_AT_DOT] = ACTIONS(527),
    [anon_sym_AT_AT_EQ] = ACTIONS(527),
    [anon_sym_AT_ATk] = ACTIONS(527),
    [anon_sym_AT_ATt] = ACTIONS(527),
    [anon_sym_AT_ATb] = ACTIONS(527),
    [anon_sym_AT_ATi] = ACTIONS(529),
    [anon_sym_AT_ATiS] = ACTIONS(527),
    [anon_sym_AT_ATf] = ACTIONS(527),
    [anon_sym_AT_ATs_COLON] = ACTIONS(527),
    [anon_sym_AT_ATc_COLON] = ACTIONS(527),
    [anon_sym_AT] = ACTIONS(529),
    [anon_sym_AT_BANG] = ACTIONS(527),
    [anon_sym_AT_LBRACE] = ACTIONS(527),
    [anon_sym_ATa_COLON] = ACTIONS(527),
    [anon_sym_ATb_COLON] = ACTIONS(527),
    [anon_sym_ATB_COLON] = ACTIONS(527),
    [anon_sym_ATe_COLON] = ACTIONS(527),
    [anon_sym_ATF_COLON] = ACTIONS(527),
    [anon_sym_ATi_COLON] = ACTIONS(527),
    [anon_sym_ATk_COLON] = ACTIONS(527),
    [anon_sym_ATo_COLON] = ACTIONS(527),
    [anon_sym_ATr_COLON] = ACTIONS(527),
    [anon_sym_ATf_COLON] = ACTIONS(527),
    [anon_sym_ATs_COLON] = ACTIONS(527),
    [anon_sym_ATx_COLON] = ACTIONS(527),
    [anon_sym_PIPE_DOT] = ACTIONS(527),
    [anon_sym_EQ] = ACTIONS(527),
    [anon_sym_RPAREN] = ACTIONS(527),
    [anon_sym_SEMI] = ACTIONS(527),
    [anon_sym_GT] = ACTIONS(529),
    [anon_sym_GT_GT] = ACTIONS(527),
    [sym_html_redirect_operator] = ACTIONS(529),
    [sym_html_append_operator] = ACTIONS(527),
    [anon_sym_BQUOTE] = ACTIONS(527),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(527),
    [anon_sym_CR] = ACTIONS(527),
    [sym_file_descriptor] = ACTIONS(527),
    [sym__eq_sep_concat] = ACTIONS(527),
  },
  [169] = {
    [ts_builtin_sym_end] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PIPE] = ACTIONS(360),
    [anon_sym_PIPEH] = ACTIONS(358),
    [anon_sym_PIPET] = ACTIONS(358),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATi] = ACTIONS(358),
    [anon_sym_AT_AT_ATr] = ACTIONS(358),
    [anon_sym_AT_AT_ATs] = ACTIONS(360),
    [anon_sym_AT_AT_ATst] = ACTIONS(358),
    [anon_sym_AT_AT_ATS] = ACTIONS(358),
    [anon_sym_AT_AT_ATm] = ACTIONS(358),
    [anon_sym_AT_AT_ATM] = ACTIONS(358),
    [anon_sym_AT_AT_ATf] = ACTIONS(360),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATF] = ACTIONS(360),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(358),
    [anon_sym_AT_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_AT] = ACTIONS(360),
    [anon_sym_AT_ATdbt] = ACTIONS(360),
    [anon_sym_AT_ATdbta] = ACTIONS(358),
    [anon_sym_AT_ATdbtb] = ACTIONS(358),
    [anon_sym_AT_ATdbts] = ACTIONS(358),
    [anon_sym_AT_AT_DOT] = ACTIONS(358),
    [anon_sym_AT_AT_EQ] = ACTIONS(358),
    [anon_sym_AT_ATk] = ACTIONS(358),
    [anon_sym_AT_ATt] = ACTIONS(358),
    [anon_sym_AT_ATb] = ACTIONS(358),
    [anon_sym_AT_ATi] = ACTIONS(360),
    [anon_sym_AT_ATiS] = ACTIONS(358),
    [anon_sym_AT_ATf] = ACTIONS(358),
    [anon_sym_AT_ATs_COLON] = ACTIONS(358),
    [anon_sym_AT_ATc_COLON] = ACTIONS(358),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_AT_BANG] = ACTIONS(358),
    [anon_sym_AT_LBRACE] = ACTIONS(358),
    [anon_sym_ATa_COLON] = ACTIONS(358),
    [anon_sym_ATb_COLON] = ACTIONS(358),
    [anon_sym_ATB_COLON] = ACTIONS(358),
    [anon_sym_ATe_COLON] = ACTIONS(358),
    [anon_sym_ATF_COLON] = ACTIONS(358),
    [anon_sym_ATi_COLON] = ACTIONS(358),
    [anon_sym_ATk_COLON] = ACTIONS(358),
    [anon_sym_ATo_COLON] = ACTIONS(358),
    [anon_sym_ATr_COLON] = ACTIONS(358),
    [anon_sym_ATf_COLON] = ACTIONS(358),
    [anon_sym_ATs_COLON] = ACTIONS(358),
    [anon_sym_ATx_COLON] = ACTIONS(358),
    [anon_sym_PIPE_DOT] = ACTIONS(358),
    [anon_sym_EQ] = ACTIONS(358),
    [anon_sym_RPAREN] = ACTIONS(358),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_GT] = ACTIONS(360),
    [anon_sym_GT_GT] = ACTIONS(358),
    [sym_html_redirect_operator] = ACTIONS(360),
    [sym_html_append_operator] = ACTIONS(358),
    [anon_sym_BQUOTE] = ACTIONS(358),
    [sym__comment] = ACTIONS(432),
    [anon_sym_LF] = ACTIONS(358),
    [anon_sym_CR] = ACTIONS(358),
    [sym_file_descriptor] = ACTIONS(358),
    [sym__concat_pf_dot] = ACTIONS(358),
  },
  [170] = {
    [sym_cmd_substitution_arg] = STATE(171),
    [aux_sym_grep_specifier_repeat1] = STATE(171),
    [anon_sym_TILDE] = ACTIONS(394),
    [sym_grep_specifier_identifier] = ACTIONS(531),
    [aux_sym_grep_specifier_token1] = ACTIONS(398),
    [anon_sym_PIPE] = ACTIONS(394),
    [anon_sym_PIPEH] = ACTIONS(394),
    [anon_sym_PIPET] = ACTIONS(394),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(394),
    [anon_sym_AT_AT_ATb] = ACTIONS(394),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATi] = ACTIONS(394),
    [anon_sym_AT_AT_ATr] = ACTIONS(394),
    [anon_sym_AT_AT_ATs] = ACTIONS(394),
    [anon_sym_AT_AT_ATst] = ACTIONS(394),
    [anon_sym_AT_AT_ATS] = ACTIONS(394),
    [anon_sym_AT_AT_ATm] = ACTIONS(394),
    [anon_sym_AT_AT_ATM] = ACTIONS(394),
    [anon_sym_AT_AT_ATf] = ACTIONS(394),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATF] = ACTIONS(394),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(394),
    [anon_sym_AT_AT_ATt] = ACTIONS(394),
    [anon_sym_AT_AT] = ACTIONS(394),
    [anon_sym_AT_ATdbt] = ACTIONS(394),
    [anon_sym_AT_ATdbta] = ACTIONS(394),
    [anon_sym_AT_ATdbtb] = ACTIONS(394),
    [anon_sym_AT_ATdbts] = ACTIONS(394),
    [anon_sym_AT_AT_DOT] = ACTIONS(394),
    [anon_sym_AT_AT_EQ] = ACTIONS(394),
    [anon_sym_AT_ATk] = ACTIONS(394),
    [anon_sym_AT_ATt] = ACTIONS(394),
    [anon_sym_AT_ATb] = ACTIONS(394),
    [anon_sym_AT_ATi] = ACTIONS(394),
    [anon_sym_AT_ATiS] = ACTIONS(394),
    [anon_sym_AT_ATf] = ACTIONS(394),
    [anon_sym_AT_ATs_COLON] = ACTIONS(394),
    [anon_sym_AT_ATc_COLON] = ACTIONS(394),
    [anon_sym_AT] = ACTIONS(394),
    [anon_sym_AT_BANG] = ACTIONS(394),
    [anon_sym_AT_LBRACE] = ACTIONS(394),
    [anon_sym_ATa_COLON] = ACTIONS(394),
    [anon_sym_ATb_COLON] = ACTIONS(394),
    [anon_sym_ATB_COLON] = ACTIONS(394),
    [anon_sym_ATe_COLON] = ACTIONS(394),
    [anon_sym_ATF_COLON] = ACTIONS(394),
    [anon_sym_ATi_COLON] = ACTIONS(394),
    [anon_sym_ATk_COLON] = ACTIONS(394),
    [anon_sym_ATo_COLON] = ACTIONS(394),
    [anon_sym_ATr_COLON] = ACTIONS(394),
    [anon_sym_ATf_COLON] = ACTIONS(394),
    [anon_sym_ATs_COLON] = ACTIONS(394),
    [anon_sym_ATx_COLON] = ACTIONS(394),
    [anon_sym_PIPE_DOT] = ACTIONS(394),
    [anon_sym_RPAREN] = ACTIONS(394),
    [anon_sym_SEMI] = ACTIONS(394),
    [anon_sym_GT] = ACTIONS(394),
    [anon_sym_GT_GT] = ACTIONS(394),
    [sym_html_redirect_operator] = ACTIONS(394),
    [sym_html_append_operator] = ACTIONS(394),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(533),
    [anon_sym_BQUOTE] = ACTIONS(535),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(392),
  },
  [171] = {
    [sym_cmd_substitution_arg] = STATE(171),
    [aux_sym_grep_specifier_repeat1] = STATE(171),
    [anon_sym_TILDE] = ACTIONS(414),
    [sym_grep_specifier_identifier] = ACTIONS(537),
    [aux_sym_grep_specifier_token1] = ACTIONS(414),
    [anon_sym_PIPE] = ACTIONS(414),
    [anon_sym_PIPEH] = ACTIONS(414),
    [anon_sym_PIPET] = ACTIONS(414),
    [anon_sym_AT_AT_AT_EQ] = ACTIONS(414),
    [anon_sym_AT_AT_ATb] = ACTIONS(414),
    [anon_sym_AT_AT_ATc_COLON] = ACTIONS(414),
    [anon_sym_AT_AT_ATC_COLON] = ACTIONS(414),
    [anon_sym_AT_AT_ATi] = ACTIONS(414),
    [anon_sym_AT_AT_ATr] = ACTIONS(414),
    [anon_sym_AT_AT_ATs] = ACTIONS(414),
    [anon_sym_AT_AT_ATst] = ACTIONS(414),
    [anon_sym_AT_AT_ATS] = ACTIONS(414),
    [anon_sym_AT_AT_ATm] = ACTIONS(414),
    [anon_sym_AT_AT_ATM] = ACTIONS(414),
    [anon_sym_AT_AT_ATf] = ACTIONS(414),
    [anon_sym_AT_AT_ATf_COLON] = ACTIONS(414),
    [anon_sym_AT_AT_ATF] = ACTIONS(414),
    [anon_sym_AT_AT_ATF_COLON] = ACTIONS(414),
    [anon_sym_AT_AT_ATt] = ACTIONS(414),
    [anon_sym_AT_AT] = ACTIONS(414),
    [anon_sym_AT_ATdbt] = ACTIONS(414),
    [anon_sym_AT_ATdbta] = ACTIONS(414),
    [anon_sym_AT_ATdbtb] = ACTIONS(414),
    [anon_sym_AT_ATdbts] = ACTIONS(414),
    [anon_sym_AT_AT_DOT] = ACTIONS(414),
    [anon_sym_AT_AT_EQ] = ACTIONS(414),
    [anon_sym_AT_ATk] = ACTIONS(414),
    [anon_sym_AT_ATt] = ACTIONS(414),
    [anon_sym_AT_ATb] = ACTIONS(414),
    [anon_sym_AT_ATi] = ACTIONS(414),
    [anon_sym_AT_ATiS] = ACTIONS(414),
    [anon_sym_AT_ATf] = ACTIONS(414),
    [anon_sym_AT_ATs_COLON] = ACTIONS(414),
    [anon_sym_AT_ATc_COLON] = ACTIONS(414),
    [anon_sym_AT] = ACTIONS(414),
    [anon_sym_AT_BANG] = ACTIONS(414),
    [anon_sym_AT_LBRACE] = ACTIONS(414),
    [anon_sym_ATa_COLON] = ACTIONS(414),
    [anon_sym_ATb_COLON] = ACTIONS(414),
    [anon_sym_ATB_COLON] = ACTIONS(414),
    [anon_sym_ATe_COLON] = ACTIONS(414),
    [anon_sym_ATF_COLON] = ACTIONS(414),
    [anon_sym_ATi_COLON] = ACTIONS(414),
    [anon_sym_ATk_COLON] = ACTIONS(414),
    [anon_sym_ATo_COLON] = ACTIONS(414),
    [anon_sym_ATr_COLON] = ACTIONS(414),
    [anon_sym_ATf_COLON] = ACTIONS(414),
    [anon_sym_ATs_COLON] = ACTIONS(414),
    [anon_sym_ATx_COLON] = ACTIONS(414),
    [anon_sym_PIPE_DOT] = ACTIONS(414),
    [anon_sym_RPAREN] = ACTIONS(414),
    [anon_sym_SEMI] = ACTIONS(414),
    [anon_sym_GT] = ACTIONS(414),
    [anon_sym_GT_GT] = ACTIONS(414),
    [sym_html_redirect_operator] = ACTIONS(414),
    [sym_html_append_operator] = ACTIONS(414),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(540),
    [anon_sym_BQUOTE] = ACTIONS(543),
    [sym__comment] = ACTIONS(3),
    [sym_file_descriptor] = ACTIONS(412),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(548), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(546), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [71] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(352), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(350), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [142] = 7,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(392), 1,
      sym_file_descriptor,
    ACTIONS(398), 1,
      aux_sym_grep_specifier_token1,
    ACTIONS(531), 1,
      sym_grep_specifier_identifier,
    ACTIONS(533), 1,
      anon_sym_DOLLAR_LPAREN,
    STATE(171), 2,
      sym_cmd_substitution_arg,
      aux_sym_grep_specifier_repeat1,
    ACTIONS(394), 57,
      anon_sym_TILDE,
      anon_sym_PIPE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATi,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_SEMI,
      anon_sym_GT,
      anon_sym_GT_GT,
      sym_html_redirect_operator,
      sym_html_append_operator,
      anon_sym_BQUOTE,
  [221] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(352), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(350), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [292] = 4,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(554), 1,
      anon_sym_EQ,
    ACTIONS(552), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(550), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [365] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(328), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(326), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [436] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(558), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(556), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [507] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(336), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(334), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [578] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(562), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(560), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [649] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(321), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(319), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [720] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(506), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(504), 53,
      sym_file_descriptor,
      sym__eq_sep_concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [791] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(332), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(330), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [862] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(496), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(494), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_COMMA,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [933] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(566), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(564), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1004] = 59,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(570), 1,
      anon_sym_TILDE,
    ACTIONS(572), 1,
      anon_sym_PIPE,
    ACTIONS(574), 1,
      anon_sym_PIPEH,
    ACTIONS(576), 1,
      anon_sym_PIPET,
    ACTIONS(578), 1,
      anon_sym_AT_AT_AT_EQ,
    ACTIONS(580), 1,
      anon_sym_AT_AT_ATb,
    ACTIONS(582), 1,
      anon_sym_AT_AT_ATc_COLON,
    ACTIONS(584), 1,
      anon_sym_AT_AT_ATC_COLON,
    ACTIONS(586), 1,
      anon_sym_AT_AT_ATi,
    ACTIONS(588), 1,
      anon_sym_AT_AT_ATr,
    ACTIONS(590), 1,
      anon_sym_AT_AT_ATs,
    ACTIONS(592), 1,
      anon_sym_AT_AT_ATst,
    ACTIONS(594), 1,
      anon_sym_AT_AT_ATS,
    ACTIONS(596), 1,
      anon_sym_AT_AT_ATm,
    ACTIONS(598), 1,
      anon_sym_AT_AT_ATM,
    ACTIONS(600), 1,
      anon_sym_AT_AT_ATf,
    ACTIONS(602), 1,
      anon_sym_AT_AT_ATf_COLON,
    ACTIONS(604), 1,
      anon_sym_AT_AT_ATF,
    ACTIONS(606), 1,
      anon_sym_AT_AT_ATF_COLON,
    ACTIONS(608), 1,
      anon_sym_AT_AT_ATt,
    ACTIONS(610), 1,
      anon_sym_AT_AT,
    ACTIONS(612), 1,
      anon_sym_AT_ATdbt,
    ACTIONS(614), 1,
      anon_sym_AT_ATdbta,
    ACTIONS(616), 1,
      anon_sym_AT_ATdbtb,
    ACTIONS(618), 1,
      anon_sym_AT_ATdbts,
    ACTIONS(620), 1,
      anon_sym_AT_AT_DOT,
    ACTIONS(622), 1,
      anon_sym_AT_AT_EQ,
    ACTIONS(624), 1,
      anon_sym_AT_ATk,
    ACTIONS(626), 1,
      anon_sym_AT_ATt,
    ACTIONS(628), 1,
      anon_sym_AT_ATb,
    ACTIONS(630), 1,
      anon_sym_AT_ATi,
    ACTIONS(632), 1,
      anon_sym_AT_ATiS,
    ACTIONS(634), 1,
      anon_sym_AT_ATf,
    ACTIONS(636), 1,
      anon_sym_AT_ATs_COLON,
    ACTIONS(638), 1,
      anon_sym_AT_ATc_COLON,
    ACTIONS(640), 1,
      anon_sym_AT,
    ACTIONS(642), 1,
      anon_sym_AT_BANG,
    ACTIONS(644), 1,
      anon_sym_AT_LBRACE,
    ACTIONS(646), 1,
      anon_sym_ATa_COLON,
    ACTIONS(648), 1,
      anon_sym_ATb_COLON,
    ACTIONS(650), 1,
      anon_sym_ATB_COLON,
    ACTIONS(652), 1,
      anon_sym_ATe_COLON,
    ACTIONS(654), 1,
      anon_sym_ATF_COLON,
    ACTIONS(656), 1,
      anon_sym_ATi_COLON,
    ACTIONS(658), 1,
      anon_sym_ATk_COLON,
    ACTIONS(660), 1,
      anon_sym_ATo_COLON,
    ACTIONS(662), 1,
      anon_sym_ATr_COLON,
    ACTIONS(664), 1,
      anon_sym_ATf_COLON,
    ACTIONS(666), 1,
      anon_sym_ATs_COLON,
    ACTIONS(668), 1,
      anon_sym_ATx_COLON,
    ACTIONS(670), 1,
      anon_sym_PIPE_DOT,
    ACTIONS(672), 1,
      anon_sym_GT,
    ACTIONS(674), 1,
      anon_sym_GT_GT,
    ACTIONS(676), 1,
      sym_html_redirect_operator,
    ACTIONS(678), 1,
      sym_html_append_operator,
    ACTIONS(680), 1,
      sym_file_descriptor,
    STATE(332), 3,
      sym__redirect_operator,
      sym_fdn_redirect_operator,
      sym_fdn_append_operator,
    ACTIONS(568), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LF,
      anon_sym_CR,
  [1187] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(344), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(342), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1258] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(340), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(338), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1329] = 4,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(686), 1,
      anon_sym_COLON,
    ACTIONS(684), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(682), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1402] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(348), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(346), 53,
      sym_file_descriptor,
      sym__concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1473] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(690), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(688), 53,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1544] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(317), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(315), 53,
      sym_file_descriptor,
      sym__eq_sep_concat,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1615] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(694), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(692), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1685] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(698), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(696), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1755] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(702), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(700), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1825] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(706), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(704), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1895] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(710), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(708), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [1965] = 4,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(716), 1,
      anon_sym_EQ,
    ACTIONS(714), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(712), 51,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_LF,
      anon_sym_CR,
  [2037] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(720), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(718), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2107] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(724), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(722), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2177] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(728), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(726), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2247] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(350), 1,
      sym_file_descriptor,
    ACTIONS(352), 61,
      anon_sym_TILDE,
      sym_grep_specifier_identifier,
      aux_sym_grep_specifier_token1,
      anon_sym_PIPE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATi,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT,
      anon_sym_GT_GT,
      sym_html_redirect_operator,
      sym_html_append_operator,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
  [2317] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(732), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(730), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2387] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(736), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(734), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2457] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(740), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(738), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2527] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(744), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(742), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2597] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(748), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(746), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2667] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(752), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(750), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2737] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(756), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(754), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2807] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(760), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(758), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2877] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(764), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(762), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [2947] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(768), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(766), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3017] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(772), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(770), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3087] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(776), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(774), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3157] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(780), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(778), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3227] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(784), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(782), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3297] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(788), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(786), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3367] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(792), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(790), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3437] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(796), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(794), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3507] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(800), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(798), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3577] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(804), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(802), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3647] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(808), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(806), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3717] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(812), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(810), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3787] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(816), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(814), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3857] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(820), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(818), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [3927] = 3,
    ACTIONS(3), 1,
      sym__comment,
    ACTIONS(350), 1,
      sym_file_descriptor,
    ACTIONS(352), 61,
      anon_sym_TILDE,
      sym_grep_specifier_identifier,
      aux_sym_grep_specifier_token1,
      anon_sym_PIPE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATi,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT,
      anon_sym_GT_GT,
      sym_html_redirect_operator,
      sym_html_append_operator,
      anon_sym_DOLLAR_LPAREN,
      anon_sym_BQUOTE,
  [3997] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(824), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(822), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4067] = 4,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(830), 1,
      sym__concat_pf_dot,
    ACTIONS(828), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(826), 51,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_LF,
      anon_sym_CR,
  [4139] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(834), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(832), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4209] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(317), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(315), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4279] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(838), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(836), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4349] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(842), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(840), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4419] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(846), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(844), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4489] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(850), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(848), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4559] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(854), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(852), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4629] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(858), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(856), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4699] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(862), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(860), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4769] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(866), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(864), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4839] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(75), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(73), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4909] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(870), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(868), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [4979] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(874), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(872), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5049] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(878), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(876), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5119] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(882), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(880), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5189] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(886), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(884), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5259] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(890), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(888), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5329] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(894), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(892), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5399] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(898), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(896), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5469] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(902), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(900), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5539] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(906), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(904), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5609] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(910), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(908), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5679] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(914), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(912), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5749] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(918), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(916), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5819] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(922), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(920), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5889] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(394), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(392), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [5959] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(926), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(924), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6029] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(930), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(928), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6099] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(934), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(932), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6169] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(938), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(936), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6239] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(67), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(65), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6309] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(942), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(940), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6379] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(946), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(944), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6449] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(950), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(948), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6519] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(954), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(952), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6589] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(958), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(956), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6659] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(962), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(960), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6729] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(966), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(964), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6799] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(970), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(968), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6869] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(974), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(972), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [6939] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(978), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(976), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7009] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(982), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(980), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7079] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(958), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(956), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7149] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(986), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(984), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7219] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(990), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(988), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7289] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(994), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(992), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7359] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(998), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(996), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7429] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(1002), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1000), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7499] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(1006), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1004), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7569] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(1010), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1008), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7639] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(1014), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1012), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
      anon_sym_PIPEH,
      anon_sym_PIPET,
      anon_sym_AT_AT_AT_EQ,
      anon_sym_AT_AT_ATb,
      anon_sym_AT_AT_ATc_COLON,
      anon_sym_AT_AT_ATC_COLON,
      anon_sym_AT_AT_ATi,
      anon_sym_AT_AT_ATr,
      anon_sym_AT_AT_ATst,
      anon_sym_AT_AT_ATS,
      anon_sym_AT_AT_ATm,
      anon_sym_AT_AT_ATM,
      anon_sym_AT_AT_ATf_COLON,
      anon_sym_AT_AT_ATF_COLON,
      anon_sym_AT_AT_ATt,
      anon_sym_AT_ATdbta,
      anon_sym_AT_ATdbtb,
      anon_sym_AT_ATdbts,
      anon_sym_AT_AT_DOT,
      anon_sym_AT_AT_EQ,
      anon_sym_AT_ATk,
      anon_sym_AT_ATt,
      anon_sym_AT_ATb,
      anon_sym_AT_ATiS,
      anon_sym_AT_ATf,
      anon_sym_AT_ATs_COLON,
      anon_sym_AT_ATc_COLON,
      anon_sym_AT_BANG,
      anon_sym_AT_LBRACE,
      anon_sym_ATa_COLON,
      anon_sym_ATb_COLON,
      anon_sym_ATB_COLON,
      anon_sym_ATe_COLON,
      anon_sym_ATF_COLON,
      anon_sym_ATi_COLON,
      anon_sym_ATk_COLON,
      anon_sym_ATo_COLON,
      anon_sym_ATr_COLON,
      anon_sym_ATf_COLON,
      anon_sym_ATs_COLON,
      anon_sym_ATx_COLON,
      anon_sym_PIPE_DOT,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_GT_GT,
      sym_html_append_operator,
      anon_sym_BQUOTE,
      anon_sym_LF,
      anon_sym_CR,
  [7709] = 3,
    ACTIONS(432), 1,
      sym__comment,
    ACTIONS(1018), 10,
      anon_sym_PIPE,
      anon_sym_AT_AT_ATs,
      anon_sym_AT_AT_ATf,
      anon_sym_AT_AT_ATF,
      anon_sym_AT_AT,
      anon_sym_AT_ATdbt,
      anon_sym_AT_ATi,
      anon_sym_AT,
      anon_sym_GT,
      sym_html_redirect_operator,
    ACTIONS(1016), 52,
      sym_file_descriptor,
      ts_builtin_sym_end,
      anon_sym_TILDE,
 