\name{zoom}
\alias{zm}
\alias{ff}
\alias{zf}
\alias{zi}
\alias{zo}
\alias{zc}
\alias{pz}
\alias{zz}
\alias{zp}
\alias{pd}
\alias{pl}
\alias{pr}
\alias{pu}
\alias{loc}
\alias{delta}


\title{Zoom}
\description{
  Zoom and pan functions.
}
\usage{
zm()
ff(...)
zf(...)
zi(p = 25, ...)
zo(p = 25, ...)
zc(massCenter = TRUE)
pz(w1Delta = NULL, w2Delta = NULL, ...)
zz(...)
zp()

pd(p = 5, ...)
pu(p = 5, ...)
pl(p = 5, ...)
pr(p = 5, ...)

loc()
delta()
}

\arguments{
  \item{p}{numeric; the percentage to move, reduce, or enlarge a spectrum.}
  \item{massCenter}{logical; \code{TRUE} centers peaks by center of mass,
    \code{FALSE} centers peaks by maximum signal observed.}
  \item{w1Delta}{Chemical shift range for the new window in the indirect 
    dimension, \code{NULL} sets the window to 0.25 ppm for 1H and 2.5 ppm for 
    all other nuclei.}
  \item{w2Delta}{Chemical shift range for the new window in the direct 
    dimension, \code{NULL} sets the window to 0.25 ppm for 1H and 2.5 ppm for 
    all other nuclei.}
  \item{\dots}{Additional arguments can be passed to internal plotting functions
  (see \code{\link{addArg}}).}
}

\details{
  \code{zm} displays a zoom and scroll GUI. To zoom or scroll select the desired 
  option using the zoom/scroll radio buttons located along the top, then click 
  on the appropriate arrow button to zoom or scroll by the percentage provided 
  in the center box. The \bold{Full}, \bold{Point}, \bold{Center}, \bold{Prev}, 
  \bold{Hand}, and \bold{Get shifts} buttons call the \code{zf}, \code{pz}, 
  \code{zc}, \code{zp}, \code{zz}, \code{loc} and \code{dela} functions 
  respectively, detailed below. 
}
  
\section{Shortcut functions}{
\describe{
  \item{\code{ff} and \code{zf}}{Zoom out to display the full spectrum.}
  \item{\code{zi} and \code{zo}}{Zoom in or out by the provided percentage 
  \code{p}.}
  \item{\code{zc}}{Centers the main plot window on either a peak's center of 
    mass, or on the maximum observed signal.}
  \item{\code{pz}}{Centers the zoom window around a point in the spectrum 
    designated by clicking in the main plot window with the left mouse button. 
    The dimensions of the zoom window are defined by the parameters 
    \code{w1Delta} and \code{w2Delta}.}
  \item{\code{zz}}{Zooms to a specific region designated by clicking on two 
    points in the main plot window with the left mouse button. The two specified 
    points represent opposite corners of a box defining the outer 
    boundaries of the new zoom window.  To exit manual zoom mode, right-click 
    within the main plot window.}
  \item{\code{zp}}{Reverts to the previous zoom level.}
  \item{\code{pd}, \code{pu}, \code{pl}, and \code{pr}}{Pan (scroll) down, up, 
    left, and right respectively by the desired percentage \code{p}.}
  \item{\code{loc}}{Retrieves chemical shifts for a point in a spectrum defined 
  	by clicking within the main plot window. To exit shift retrieval mode, 
  	right-click in the main plot window and select stop.}
   \item{\code{delta}}{Retrieves the chemical shift range in Hz and PPM between 
    points defined by clicking within the main plot window. To exit shift 
    retrieval mode,	right-click in the main plot window and select stop.}
  }   
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{rNMR}} for other rNMR help topics.}

\keyword{iplot}