\name{sr}
\alias{sr}

\title{Chemical shift referencing}

\description{
  GUI for adjusting chemical shift references in one or more spectra.
}
  
\usage{
sr()
}

\details{
  Displays a chemical shift referencing GUI.  Changes are only applied to files 
  selected from the files list.  Double-clicking on a file name within the files 
  list will switch the current spectrum to the file selected.  To set a chemical 
  shift reference, enter a numeric value for the shift (or use the 
  \bold{Get shift} button to use a point in the current spectrum) and then 
  define the reference point by pressing the \bold{Point} button or the
  \bold{Region} button.  In both cases, the selected spectra must have the same 
  nuclei and number of points and dimensions as the current spectrum.   
   
  	The \bold{Point} button allows the reference point to be selected manually 
  by clicking on a point within the main plot window.  The corresponding 
  position (in ppm) is then used as a chemical shift reference for the selected
  spectra.  
  
  	The \bold{Region} button defines the reference point by the location of the 
  maximum intensity observed within a select region.  Two successive mouse 
  clicks indicate opposite corners of the region being defined.  
  
  	The shift referencing GUI also allows shifts to be adjusted manually 
  (without a reference) using the arrow buttons.  The value for the adjustment 
  increment is in ppm and must be a positive number.  Manual shift adjustment is 
  best used to align spectra in conjunction with the overlay tool 
  (see \code{\link{ol}}).  Chemical shift referencing should be performed prior 
  to designating ROIs (see \code{\link{roi}}).  Unlike peak lists, ROI tables 
  are not updated after chemical shift referencing.
   
  	One-dimensional spectra may be referenced automatically using the 
  \bold{Auto} button.  Automatic referencing sets the chemical shift of the
  furthest upfield peak with an intensity above the 1D threshold (see 
  \code{\link{pp}}) to 0 ppm.  The \bold{Default} button restores the original 
  (as collected) shift reference to the selected spectra.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{pp}} for peak picking; \code{\link{roi}} for ROI's; 
\code{\link{ol}} for overlays; \code{\link{rNMR}} for other rNMR help topics.}

\keyword{hplot}
\keyword{iplot}