\name{setGraphics}
\alias{setGraphics}

\title{Change graphics settings}
\description{
  Change graphics settings for one or more open spectra.  This function is
  provided as a convenience for advanced \pkg{rNMR} users and developers.
}

\usage{
setGraphics(file.name = currentSpectrum, all.files = FALSE, save.backup = TRUE, 
		refresh.graphics = FALSE, bg = NULL, fg = NULL, col.axis = NULL, 
		col.lab = NULL, col.main = NULL,	col.sub = NULL,	col = NULL, usr = NULL, 
		line.color = NULL, pos.color = NULL, neg.color = NULL, proj.color = NULL, 
		conDisp = NULL, nlevels = NULL, clevel = NULL, type = NULL, theta = NULL, 
		phi = NULL,	asp = NULL,	peak.color = NULL, peak.disp = NULL, 
		peak.noiseFilt = NULL, peak.pch = NULL, peak.cex = NULL, 
		peak.labelPos = NULL, thresh.1D = NULL, position.1D = NULL,	offset = NULL, 
		proj.mode = NULL,	proj.type = NULL,	proj.direct = NULL,	filter = NULL, 
		roi.multi = NULL,	roiMain = NULL, roiMax = NULL, roi.bcolor = NULL, 
		roi.tcolor = NULL, roi.lwd = NULL, roi.lty = NULL, roi.cex = NULL, 
		roi.labelPos = NULL, roi.noiseFilt = NULL, roi.w1 = NULL, roi.w2 = NULL, 
		roi.pad = NULL,	w1Range = NULL, w2Range = NULL, overlay.text = NULL)
}

\arguments{
  \item{file.name}{character string or vector; the complete file path(s) to an 
  	open spectrum or spectra to be modified, defaults to the current spectrum.  
  	Note:  file.name must match one of the values returned when calling 
  	\code{names(fileFolder)}.}
  \item{all.files}{logical; if \code{TRUE} all files will be updated.}
  \item{save.backup}{logical; saves an undo/redo point if \code{TRUE}.}
  \item{refresh.graphics}{logical; if \code{TRUE} all plot windows are 
  	redrawn.}
  \item{bg}{see \code{\link{par}}.}
  \item{fg}{see \code{\link{par}}.}
  \item{col.axis}{see \code{\link{par}}.}
  \item{col.lab}{see \code{\link{par}}.}
  \item{col.main}{see \code{\link{par}}.}
  \item{col.sub}{see \code{\link{par}}.}
  \item{col}{see \code{\link{par}}.}
  \item{usr}{see \code{\link{par}}.}
  \item{line.color}{sets the \code{fg}, \code{col.axis}, \code{col.lab}, 
  	\code{col.main}, \code{col.sub}, and \code{col} parameters to the color 
  	provided (see \code{\link{colors}} for a list of usable colors).}
  \item{pos.color}{color setting for positive contours (see \code{\link{colors}}
    for a list of usable colors).}
  \item{neg.color}{color setting for negative contours (see \code{\link{colors}}
    for a list of usable colors).}
  \item{proj.color}{color setting for 1D plots and projections (see 
    \code{\link{colors}} for a list of usable colors).}
  \item{conDisp}{logical vector; \code{c(TRUE, TRUE)} plots positive and 
  	negative contours, \code{c(TRUE, FALSE)} plots only positive, 
  	\code{c(FALSE, TRUE)} plots only negative, \code{c(FALSE, FALSE)} plots no 
  	contours.}
  \item{nlevels}{positive integer; the number of contour levels.}
  \item{clevel}{positive numeric; the number of standard deviations away from 
    the noise that the lowest contour should be drawn.}
  \item{type}{specifies the type of plot to be generated; "\code{image}" loads 
  	fastest, "\code{contour}" produces a contour plot, "\code{filled}" produces 
  	a filled contour plot, "\code{persp}" produces a 3D perspective plot, and 
  	"\code{auto}" chooses the type based on the size of the spectral window.  
  	For 1D spectra, "\code{auto}" displays a solid line, "\code{p}" displays 
  	only points, and "\code{b}" displays points connected by a line.}
  \item{theta}{perspective plot control (see \code{\link{persp}}).}
  \item{phi}{perspective plot control (see \code{\link{persp}}).}
  \item{asp}{perspective plot control (see \code{\link{persp}}).}
  \item{peak.color}{color setting for peak markers (see \code{\link{colors}}
    for a list of usable colors).}
  \item{peak.disp}{logical; if \code{TRUE} peak markers are displayed.}
  \item{peak.noiseFilt}{integer; \code{0} does not apply a noise filter, 
  	\code{1} applies a mild filter (adjacent points in the direct dimension must 
  	be above the noise threshold), and \code{2} applies a strong filter (all 
  	adjacent points must be above the noise threshold)}
  \item{peak.pch}{integer or character; the symbol used for peak markers for 
  	picked peaks.  Equivalent to R's \code{pch} graphical parameter, accepts any 
  	ASCII character as well as integer values corresponding to predefined 
  	symbols in R (see \code{\link{par}}).}	
  \item{peak.cex}{numeric (positive); the magnification for peak labels and 
  	markers for	picked peaks.  Equivalent to R's \code{cex} graphical parameter 
  	(see \code{\link{par}}).}
  \item{peak.labelPos}{justification for peak label text.  Must be one of 
  	\code{"top"}, \code{"bottom"}, \code{"left"}, or \code{"right"}.}	
  \item{thresh.1D}{numeric; the peak picking threshold for 1D spectra.}
  \item{position.1D}{numeric; the vertical position of 1D plots within the
    spectral window.}
  \item{offset}{numeric; the percent of total intensity range with which to 
    displace each spectrum. This is used to create stacked 1D spectra and is not 
    passed to 2D plots.}
  \item{proj.mode}{logical; if \code{TRUE} displays a 1D representation of a 
  	2D spectrum.}
  \item{proj.type}{specifies the type of projection to be generated;  
  	"\code{auto}" displays a solid line, "\code{p}" displays only points, and 
  	"\code{b}" displays points connected by a line.}
  \item{proj.direct}{integer \code{1} or \code{2}; if \code{1} a projection of 
  	the direct dimension is displayed, \code{2} displays the indirect 
  	dimension.}
  \item{filter}{function; a function used to create a 1D projection, must be
    capable of being applied to a vector (e.g. \code{min}, \code{max}, 
    \code{sd}).  Function must accept \code{x} as its only argument.}
  \item{roi.multi}{logical; if \code{TRUE} the specified file(s) will appear in
  	the multiple file window.}
  \item{roiMain}{logical; if \code{TRUE} displays ROIs in the main plot 
  	window.}
  \item{roiMax}{logical; if \code{TRUE} displays a marker in the subplot and 
  	multiple file windows on the absolute maximum visible signals within the 
  	ROIs.}
  \item{roi.bcolor}{color setting for active and inactive ROI boxes.  Must be
  	a vector of length 2, \code{c(active, inactive)}.  See \code{\link{colors}}
    for a list of usable colors.}
  \item{roi.tcolor}{color setting for active and inactive ROI labels.  Must be
  	a vector of length 2, \code{c(active, inactive)}.  See \code{\link{colors}}
    for a list of usable colors.}
  \item{roi.lwd}{numeric vector of length 2; line width for active and inactive 
  	ROI boxes, \code{c(active, inactive)}.  Equivalent to R's \code{lwd} 
  	graphical parameter (see \code{\link{par}}).}
  \item{roi.lty}{box type for active and inactive ROIs.  Must be a vector of
  	length 2, \code{c(active, inactive)}.  Equivalent to R's \code{lty} 
  	graphical parameter (see \code{\link{par}}).  Valid options include: 
  	\code{"solid"}, \code{"dashed"}, \code{"dotted"}, \code{"dotdash"}, 
  	\code{"longdash"}, \code{"twodash"}, or \code{"blank"}.}
  \item{roi.cex}{numeric (positive); text magnification for active and inactive 
  	ROI labels, \code{c(active, inactive)}.  Equivalent to R's \code{cex} 
  	graphical parameter	(see \code{\link{par}}).}
 	\item{roi.labelPos}{justification for ROI label text.  Must be one of 
  	\code{"top"}, \code{"bottom"}, \code{"left"}, or \code{"right"}.}
  \item{roi.noiseFilt}{integer; filter for automatic ROI generation (see 
  	\code{\link{ra}}).  \code{0} does not apply a noise filter, \code{1} applies 
  	a mild filter (adjacent points in the direct dimension must be above the 
  	noise threshold), and \code{2} applies a strong	filter (all adjacent points 
  	must be above the noise threshold).  Note that setting the ROI noise filter
  	to zero may result in errors when using \code{\link{ra}} in certain 
  	spectra.}
  \item{roi.w1}{numeric; fixed size in the indirect dimension (in ppm) for ROIs 
  	generated automatically using \code{\link{ra}}.}
  \item{roi.w2}{numeric; fixed size in the direct dimension (in ppm) for ROIs 
  	generated automatically using \code{\link{ra}}.}
  \item{roi.pad}{numeric; padding percentage applied to ROIs generated 
  	automatically using \code{\link{ra}}. This padding is added to the area 
  	surrounding the peaks within an ROI and is only applied to the height/width
  	of an ROI if the corresponding \code{roi.w1}/\code{roi.w2} argument is not 
  	provided.}
  \item{w1Range}{numeric vector; chemical shift range (\code{c(lower, upper)}) 
    in the indirect dimension.  This is provided as an alternative method for
    modifying the \code{usr} parameter.}
  \item{w2Range}{numeric vector; chemical shift range (\code{c(lower, upper)}) 
    in the direct dimension.  This is provided as an alternative method for
    modifying the \code{usr} parameter.}	
	\item{overlay.text}{logical; if \code{TRUE} the names of overlaid spectrum are 
		displayed in the plot window.}
}

\details{
  Sets graphics parameters for the current spectrum or spectra provided by the
  \code{file.name} argument.  This includes values found in \code{\link{par}} as 
  well as \pkg{rNMR} specific graphics parameters.  Note: All changes are 
  applied to the files in \code{\link{fileFolder}}, with the exception of the
  global parameters which are modified in the \code{\link{globalSettings}} list.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{ct}} for plot settings; \code{\link{per}} for perspective
plot settings; \code{\link{co}} for color settings; \code{\link{pj}} for 1D
projections and slices; \code{\link{ol}} for overlays; \code{\link{pp}} for 
peak picking; \code{\link{roi}} for ROIs; \code{\link{sr}} for chemical shift
referencing; \code{\link{toolkit}} for other \pkg{rNMR} utility functions.}

\keyword{color}
\keyword{iplot}