\name{rNMRobjects}
\alias{rNMRobjects}

\title{Objects used by functions in the rNMR package}
\description{
  The \pkg{rNMR} objects detailed below are created when the package loads and
  are necessary for the package to run correctly.  Users should avoid modifying
  these objects directly before becoming familiar with their structure and use.
}

\section{Help topics}{
\describe{
	\item{\code{\link{currentSpectrum}}}{Stores the full path name to the 
		current spectrum.}
	\item{\code{\link{defaultSettings}}}{Stores \pkg{rNMR}'s default plot and 
		graphics settings.}
	\item{\code{\link{fileFolder}}}{Stores file and graphics parameters for 
		currently opened spectra.}
	\item{\code{\link{globalSettings}}}{Stores the current set of global 
		graphics and plot settings.}
	\item{\code{\link{oldFolder}}}{Stores copies of \code{\link{fileFolder}} and 
		other relevant \pkg{rNMR} objects for use with the \code{\link{ud}},
		\code{\link{rd}}, and \code{\link{zp}} functions.}
	\item{\code{\link{overlayList}}}{Stores full path names to all currently 
		overlaid spectra.}
	\item{\code{\link{pkgVar}}}{Stores the previously used directory as well as 
		the current \pkg{rNMR} version number.}
	\item{\code{\link{roiSummary}}}{Stores the most recently calculated ROI 
		summary.}
	\item{\code{\link{roiTable}}}{Stores the current set of ROIs.}
	}
}

\author{
Ian A. Lewis, Seth C. Schommer

Maintainer: Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}
}

\keyword{internal}