\name{pickUtils}
\alias{pickUtils}
\alias{appendPeak}
\alias{isNoise}
\alias{localMax}
\alias{matchShift}
\alias{maxShift}
\alias{pdisp}
\alias{peakPick}
\alias{peakPick1D}
\alias{peakPick2D}
\alias{peakVolume}
\alias{regionMax}
\alias{shiftToROI}

\title{rNMR peak picking utilities}

\description{Utilities used for or related to peak picking in \pkg{rNMR}.
}

\usage{
appendPeak(newList, oldList)
isNoise(x, data, thresh = -0.15)
localMax(x, thresh, noiseFilt)
matchShift(inFolder = fileFolder[[wc()]], w1 = NULL, w2 = NULL, w1.pad = 0, 
	w2.pad = 0, invert = FALSE, return.inc = FALSE, return.seq = FALSE,
	overRange = FALSE)
maxShift(inFile, invert = FALSE, conDisp = c(TRUE, TRUE), massCenter = FALSE)
pdisp(col, cex, pch, pos, offset, ...)
peakPick(fileName = currentSpectrum, inFile = NULL, w1Range = NULL, 
	w2Range = NULL, append = FALSE, internal = FALSE, ...)
peakPick1D(fileName = currentSpectrum, inFile = NULL, w2Range = NULL, 
	w2Gran = 2, noiseFilt = globalSettings$peak.noiseFilt, maxOnly = FALSE, ...)
peakPick2D(fileName = currentSpectrum, inFile = NULL, w1Range = NULL, 
	w2Range = NULL, fancy = FALSE, noiseFilt = globalSettings$peak.noiseFilt, 
	maxOnly = FALSE, ...)
peakVolume(inFile, gran = 200, c.vol = FALSE, baselineCorr = FALSE)
regionMax(fileName = currentSpectrum, redraw = TRUE, noiseCheck = TRUE)
shiftToROI(shiftList = NULL, w1Delta = 1, w2Delta = 0.05)
}

\arguments{
  \item{newList}{data.frame; peak list to append.}
  \item{oldList}{data.frame; peak list to be appended.}
  \item{x}{numeric; a candidate signal (\code{isNoise}) or a matrix containing 
    the range of data being analyzed (\code{localMax}).}
  \item{data}{numeric vector; the field of data being tested.}
  \item{thresh}{numeric; noise threshold. For \code{isNoise}, values can range 
  	from 0 (no filtering) to -1 (no data returned).  For \code{localMax}, this
  	indicates the minimum level to be included.}
  \item{noiseFilt}{integer, either \code{0}, \code{1} or \code{2}; \code{0} does
  	not apply a noise filter, \code{1} applies a mild filter (adjacent points in 
  	the direct dimension must be above the noise threshold), \code{2} applies a 
  	strong filter (all adjacent points must be above the noise threshold).}
  \item{inFolder}{File and graphics parameters for desired spectra as listed in
  	\code{\link{fileFolder}}.}
  \item{w1}{numeric (vector); w1 chemical shifts to be matched.}
  \item{w2}{numeric (vector); w2 chemical shifts to be matched.}
  \item{w1.pad}{integer; number of adjacent points to return in addition to the 
  	matched shifts in the indirect dimension.}
  \item{w2.pad}{integer; number of adjacent points to return in addition to the 
  	matched shifts in the direct dimension.}
  \item{invert}{logical; if \code{TRUE}, shifts are inverted (reflected across 
  	the center of the spectrum) before being returned.  R plots must be sorted 
  	by increasing x and y values.  To meet this requirement all NMR data is
  	inverted before plotting.}
  \item{return.inc}{logical; if \code{TRUE}, returns the index for the shift as 
  	a point in the data matrix, if \code{FALSE}, returns the chemical shift.}
  \item{return.seq}{logical; if \code{TRUE}, returns the entire sequence of 
  	shifts covered by the w1 and w2 ranges provided, if \code{FALSE} returns the
  	range for the matched shifts.}
  \item{overRange}{logical; \code{TRUE} returns \code{NA} if shifts are outside 
  	the spectral window; \code{FALSE} returns the closest match to the shifts 
  	provided.} 
  \item{conDisp}{logical vector; \code{c(TRUE, TRUE)} returns the chemical shift
  	at the absolute maximum intensity, \code{c(TRUE, FALSE)} returns the 
  	chemical shift at the maximum intensity, \code{c(TRUE, FALSE)} returns the
  	chemical shift at the minimum intensity.}
  \item{massCenter}{logical; if \code{TRUE}, returns the geometric center for
  	the data, if \code{FALSE}, returns shifts at the max/min signal observed.}
  \item{col}{character string; color for peak markers, see \code{\link{colors}} 
  	for the many color options.} 	
  \item{cex}{numeric; symbol expansion, see \code{\link{points}}.}	
  \item{pch}{numeric or character; symbol used for peak markers, see \code{\link{points}}.}	
  \item{pos}{numeric; specifies position for peak label text, see 
  	\code{\link{text}}.}	
  \item{offset}{numeric; peak label offset, see \code{\link{text}}.}		
  \item{\dots}{Additional graphics (\code{pdisp}, see \code{\link{points}}) or 
  	peak picking arguments (see \code{\link{addArg}}).}	
  \item{fileName}{character string or vector; spectrum name(s) as they appear in 
  	fileFolder.}
  \item{inFile}{list; file parameters and data for file being analyzed, the 
  	output from the main plot window for the \code{\link{ed}} function.}
  \item{w1Range}{numeric; w1 chemical shift range (\code{c(downfield,upfield)}) 
  	to be used.}
  \item{w2Range}{numeric; w2 chemical shift range (\code{c(downfield,upfield)}) 
  	to be used.}
  \item{append}{logical; if \code{TRUE}, appends peaks to the previous list.}
  \item{internal}{logical; if \code{TRUE}, returns the list without assigning it 
  	to \code{\link{fileFolder}}, if \code{FALSE}, assigns the list to 
	\code{\link{fileFolder}}.}
  \item{w2Gran}{integer; granularity of search space used for finding local 
  	maxima, smaller values are more exhaustive, bigger values suppress noise.}
  \item{fancy}{logical; if \code{FALSE}, implements a basic peak picker that 
  	returns	local maxima only, this is fastest; if \code{TRUE}, determines 
  	chemical shifts of peaks, groups multiplets, and measures line width and 
  	volume.}
  \item{gran}{integer; granularity of contour fitting.}
  \item{maxOnly}{logical; if \code{TRUE}, only the maximum peak is returned.}
  \item{c.vol}{logical; if \code{TRUE}, returns stacked ellipsoid volumes, if 
  	\code{FALSE} returns the sum of the visible data (recommended).}
  \item{baselineCorr}{logical; performs local baseline correction for 1D 
  	spectra if \code{TRUE}.}
  \item{redraw}{logical; if \code{TRUE}, the spectrum is refreshed before 
  	exiting.}
  \item{noiseCheck}{logical; if \code{TRUE}, peak is not returned if its 
    intensity is below the noise threshold (as specified by the \code{thres.1D} 
    parameter in \code{\link{globalSettings}} for 1D spectra or by the contour 
    level settings for 2D spectra).}
  \item{shiftList}{data.frame; chemical shift table containing an w1 and an w2 
  	column.  A column named "Code" or "Assignment" will be used for the ROI 
  	names if present.}
  \item{w1Delta}{numeric; width of the desired ROI in the w1 dimension.}
  \item{w2Delta}{numeric; width of the ROI in the w2 dimension.}
}

\details{
\describe{
  \item{\code{appendPeak}}{Combines two peak lists.  The only requirement is
  	that each peak list must contain "w1", "w2", and "Height" columns.}
  \item{\code{isNoise}}{A simple filter for detecting noise signals in 1D data.
  	This function is an obvious area for future improvement, as the filter 
  	currently excludes broad signals.}
  \item{\code{localMax}}{Finds points in a matrix that are larger than all 
  	surrounding points, useful for peak picking algorithms.}
  \item{\code{matchShift}}{Looks in the provided spectrum for the closest 
  	matches (actual chemical shifts) to the chemical shifts provided.  If more
  	than one shift is provided, the function returns the shifts matched over the
  	range of given shifts.}
  \item{\code{maxShift}}{Finds the chemical shifts at the maximum, absolute 
  	maximum, or	minimum intensity for the data provided.}
  \item{\code{peakPick}}{Wrapper function for implementing 1D and 2D peak 
  	picking in \pkg{rNMR}.}
  \item{\code{pdisp}}{Displays the peak list for the current spectrum.  Note 
  	that this function does not turn the peak display on, so peaks will only be
  	displayed until the next plot refresh.}
  \item{\code{peakPick1D}}{1D peak picking algorithm utilizing local maxima 
  	(hill climbing method).}
  \item{\code{peakPick2D}}{2D peak picking algorithm utilizing local maxima 
  	(hill climbing method).}
  \item{\code{peakVolume}}{Estimates volumes of 2D peaks using the sum of the 
  	visible data or stacked ellipsoids.}
  \item{\code{regionMax}}{Finds the chemical shifts at the absolute maximum 
  	intensity within a region defined by the user interactively.}
  \item{\code{shiftToROI}}{Converts a peak list to an \code{\link{roiTable}}. 
    See	\code{\link{roi}} for more information on ROIs.}
  }
}

\value{
  \item{\code{appendPeak}}{returns the newly appended peak list.}
  \item{\code{isNoise}}{returns \code{TRUE} if the data provided is determined
  	to be noise.}
  \item{\code{localMax}}{returns a vector of points defining the local maxima.}
  \item{\code{matchShift}}{returns the range of chemical shifts, or indices, for 
  	the closest matching w1 and w2 shifts found in a spectrum.}
  \item{\code{maxShift}}{returns the chemical shifts for the max/min intensity.}
  \item{\code{peakPick}}{returns a new peak list for the w1/w2 ranges provided.}
  \item{\code{peakPick1D}}{returns a new peak list for the w2 range provided.}
  \item{\code{peakPick2D}}{returns a new peak list for the w1/w2 ranges 
  	provided.}
  \item{\code{peakVolume}}{returns volume for 2D peaks and area of 1D peaks.}
  \item{\code{regionMax}}{returns the chemical shifts for the absolute maximum
  	intensity within the designated region.}
  \item{\code{shiftToROI}}{returns an \code{\link{roiTable}}.}
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{toolkit}} for other \pkg{rNMR} utility functions.}

\keyword{internal}
