\name{oldFolder}
\alias{oldFolder}

\title{
rNMR object oldFolder
}

\description{
The \code{oldFolder} list object stores the information necessary for the undo
(\code{\link{ud}}), redo (\code{\link{rd}}), and zoom previous 
(\code{\link{zp}}) operations in \pkg{rNMR}.
}

\details{
Functions that may be "undone" create an entry in \code{oldFolder}.  Up to ten
entries may be stored.  Each entry in \code{oldFolder} is a named list with the
following structure:
\describe{
  \item{\code{undo.index}}{The number of currently stored undo points (max=10).}
  \item{\code{fileFolder}}{Previous copies of \code{\link{fileFolder}} totaling 
	\code{undo.index}.}
  \item{\code{roiTable}}{Previous copies of \code{\link{roiTable}} totaling 
	\code{undo.index}.}
  \item{\code{currentSpectrum}}{Previous copies of \code{\link{currentSpectrum}}
	totaling \code{undo.index}.}
  \item{\code{roiSummary}}{Previous copies of \code{\link{roiSummary}} totaling 
	\code{undo.index}.}
  \item{\code{overlayList}}{Previous copies of \code{\link{overlayList}} 
    totaling \code{undo.index}.}
  \item{\code{zoom.history}}{Logical vector totaling \code{undo.index}; 
	\code{TRUE} indicates that the function that saved the undo point 
	changed the	current zoom setting.}
  \item{\code{zoom.list}}{Lists the previous zoom settings; each list entry is
	a vector of length four indicating the chemical shift boundaries for the
	spectrum in each dimension.}
  \item{\code{globalSettings}}{Previous copies of \code{\link{globalSettings}} 
	totaling \code{undo.index}.}
  }
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{rNMRobjects}} for other other objects used by the 
\pkg{rNMR} package; \code{\link{rNMRutils}} for functions used for interacting
with \pkg{rNMR} objects.}

\keyword{internal}
