\name{ol}
\alias{ol}

\title{Overlays}

\description{
  Overlay open spectra.
}
  
\usage{
ol(askUsr = TRUE, offset = NULL, ...)
}

\arguments{
  \item{askUsr}{logical; used internally by rNMR, \code{TRUE} displays the
  overlay GUI.}
  \item{offset}{numeric; the percentage of the total intensity range with which 
  to displace each spectrum. This is used to create stacked 1D spectra and is 
  not passed to 2D plots.}
  \item{\dots}{Additional arguments can be passed to internal plotting 
  functions (see \code{\link{addArg}}).}
}

\details{
  \code{ol} displays an overlay GUI (this is the default behavior, if 
  \code{askUser} is set to \code{TRUE} the GUI will not be displayed).  To add 
  spectra to the overlay list, select the desired spectra from the files list 
  and press the \bold{Add} button.  Overlays can be removed by selecting from 
  the "Select overlays" list and pressing the \bold{Remove} button.  Color 
  changes are only applied to files selected from the overlays list.  
  Double-clicking on a file name within either list will switch the current 
  spectrum to the file selected.  The 1D offset option adjusts the position of 
  1D overlays, and is used to create a stacked 1D plot.  By default, the names
  of overlaid spectra are displayed in the main plot window.  To turn this 
  feature off, uncheck the display option at the bottom of the GUI.
  
  When \code{askUser} is set to \code{FALSE}, this function calls one of the 
  lower level plotting functions (\code{\link{drawNMR}}, \code{\link{plot1D}}, 
  etc.) to plot spectra listed in \code{\link{overlayList}} on top of the 
  current spectrum.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{fo}} for opening/closing/switching between spectra; 
\code{\link{ct}} for plot settings; \code{\link{vp}} for 1D vertical 
positioning; \code{\link{rNMR}} for other rNMR help topics.}

\keyword{hplot}
\keyword{iplot}
\keyword{aplot}