\name{guiUtils}
\alias{guiUtils}
\alias{closeGui}
\alias{getTitles}
\alias{hideGui}
\alias{myToplevel}
\alias{reset}
\alias{showGui}
\alias{tclCheck}

\title{rNMR Tk GUI utilities}

\description{Utilities for the creation and management of Tk GUIs in \pkg{rNMR}.
}

\usage{
closeGui(guiName)
getTitles(inNames, index = TRUE)
hideGui(guiName)
myToplevel(id, parent, ...)
reset(lists, boxes, prevPaths, update = 'files', dims = 'both')
showGui(guiName)
tclCheck()
}

\arguments{
  \item{guiName}{character string; name of the desired GUI.}
  \item{inNames}{numeric or character vector; the file names (equivalent to the
  output of \code{names(fileFolder)}) to retrieve user titles for.}
  \item{index}{logical; if \code{TRUE}, items in \code{inList} will be preceded
  by an index.}
  \item{id}{character string; pathname (ID) for the new toplevel object.}
	\item{parent}{optional Tk toplevel object to set as a parent window for the 
	newly created toplevel.  If provided, the dialog will appear near its parent
	and will bring the parent toplevel object to the front.  This is 
	particularly useful for displaying message or error dialogs in response to
	user interactions within rNMR GUIs.}
  \item{\dots}{Additional arguments normally passed to \code{tktoplevel}.}
  \item{lists}{list; Tk list variables to be reset.}
  \item{boxes}{list; Tk listboxes to be reset.}
  \item{prevPaths}{list; reference list previously used to create items in 
  \code{lists}.}
  \item{update}{character vector; type of items to be reset.  Must be equal in
  length to \code{lists} and \code{boxes} and must be listed in the same order
  as items in these lists. Usually \code{'files'} or \code{'overlays'}.}
  \item{dims}{character string; one of \code{'1D'}, \code{'2D'}, or 
  \code{'both'}. Used when resetting file lists.}
}

\details{
\describe{
	\item{\code{myToplevel}}{A replacement function for \code{tktoplevel}.  This
	function is used to create a toplevel object with a specific ID (pathname), 
	not only in the global environment but the \code{TkRoot} environment as well.  
	The ID provided by the \code{id} argument will be preceded by a "\code{.}" and 
	will be assigned to the ID field for the object.  This is used in conjuction 
	with the functions detailed below to provide additional control over 
	\pkg{rNMR} GUIs and to ensure that only one instance of each GUI may be open 
	at a given time.  For more information on Tk windows see 
	\code{\link{.Tk.newwin}}.}
  \item{\code{hideGui} and \code{showGui}}{Hide or show the specified GUI.  This
  function is normally used in conjunction with iterative functions to ensure
  the user does not interrupt the function by interacting with open Tk GUIs.}
  \item{\code{closeGui}}{Destroys the specified Tk GUI if open.}
  \item{\code{getTitles}}{Takes a list of file names and returns the user title
  (as it appears in \code{fileFolder}) for each.  This is primarily used for 
  displaying spectrum names in rNMR GUIs.}
  \item{\code{reset}}{Several \pkg{rNMR} GUIs contain lists corresponding to 
  global variables, such as file lists (from \code{\link{fileFolder}}) and 
  overlays.  These global variables are often modified by the user outside of 
  the GUIs.  The reset function is called whenever a command is executed from 
  within a GUI in order to update these lists with their sources.}
  \item{\code{tclCheck}}{Tries to load the TclTk package and produces an error
  if the package can not be loaded or the version of the package is not 8.4 or
  higher.  Also checks if TclTk version 8.5 is available.  If so, the themed
  widget set (ttk) is used whenever possible.}
  }
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{toolkit}} for other \pkg{rNMR} utility functions.}

\keyword{internal}
