\name{fs}
\alias{fo}
\alias{fc}
\alias{fs}
\alias{ss}
\title{Spectra}

\description{
	Functions for opening, closing, and switching between spectra in \pkg{rNMR}.
}

\section{Shortcut functions}{
\describe{
	\item{\code{fo}}{Open one or more UCSF (Sparky and \pkg{rNMR}) format files.}
	\item{\code{fc}}{Close one or more files.}
	\item{\code{ss}}{Switch between open spectra.}
	}
}

\usage{
fo(fileName, ...)
fc(usrList = NULL)
fs()
ss(...)
}

\arguments{
  \item{fileName}{optional character string or vector argument giving the full 
  path to the file(s) to open.  A file selection window is opened if this
  argument is not provided.} 
  \item{usrList}{optional character string or vector giving the full path to 
  the file(s) to close.  A file selection window is opened if this
  argument is not provided.} 
  \item{\dots}{Additional arguments can be passed to internal plotting functions
  (see \code{\link{addArg}}).}
}

\details{
	\code{fs} displays a GUI for opening, closing, sorting, and renaming files in 
	\pkg{rNMR}.  Double-clicking on a file path will switch the current spectrum 
	to the file selected.  Double-clicking on a spectrum name will allow the name
	to be edited.  Changes made to the file order or spectrum names will affect 
	the names and order in which files appear in \code{\link{fileFolder}}, other 
	GUIs, and the multiple file window (see \code{\link{rsf}}).
}

\value{
	\code{fo} invisibly returns the list of opened files.
}

\note{Files must be in UCSF (Sparky and rNMR) format.  Bruker, NMRPipe, and
  Varian format spectra may be converted using \pkg{rNMR}'s file conversion
  function \code{\link{cf}}.  ASCII files my be converted using 
  \code{\link{ca}}.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{gui}} for displaying \pkg{rNMR} menus; \code{\link{rNMR}} 
for other rNMR help topics.} 

\keyword{file}