\name{fileFolder}
\alias{fileFolder}

\title{
rNMR object fileFolder
}

\description{
The \code{fileFolder} object stores the file and graphics parameters for all
open spectra as a nested list.
}

\details{
The majority of \pkg{rNMR}'s functions interact directly with \code{fileFolder} 
any time a modification is made to a currently opened spectrum. 
\code{fileFolder} is structured as a nested list, containing up to six sections 
with identical fields for each opened spectrum.  Each section is a named list.  

The first section, \code{file.par} contains information pertaining to the 
spectrum itself.  Most of this information is taken directly from the spectrum's
ucsf format file header (see \code{\link{ucsfHead}}).  

The \code{graphics.par} section contains the current graphics and plot settings
for the spectrum.  This is identical in structure to 
\code{\link{defaultSettings}}.  See \code{\link{setGraphics}} for 
information on these parameters and how to alter them.

The \code{w1}, \code{w2}, and \code{data} sections are not normally present in
\code{fileFolder} and must be added manually.  \code{w1} and \code{w2} are 
numeric vectors containing the chemical shifts for the spectrum, in 
increasing order. The \code{data} section is a matrix containing the transposed
data (intensities) for the spectrum.  These values match the \code{w1}, 
\code{w2}, and \code{data} values returned by \code{\link{ed}}.  If all three of
these sections are present, \pkg{rNMR} will plot the spectrum from 
\code{\link{fileFolder}} instead of plotting from the spectrum's ucsf file.

The last section, \code{peak.list}, will only be present for peak picked spectra
(see \code{\link{pp}} for information on peak picking and \code{\link{import}}
for information on peak list structure.).
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{rNMRobjects}} for other other objects used by the 
\pkg{rNMR} package; \code{\link{rNMRutils}} for functions used for interacting
with \pkg{rNMR} objects.}

\keyword{internal}
