\name{ed}
\alias{ed}

\title{Extract data from rNMR}
\description{
  Displays a list of data stored during an \pkg{rNMR} session (including 
  spectral data, ROI tables, ROI summaries, and peak lists) and returns the 
  selected item.  The "Main plot window" option collects data from the main plot 
  window (the current spectrum).  The "Slice" option returns a 1D slice of the 
  current 2D plot.  These two options are meant as a convenience for advanced 
  \pkg{rNMR} users and developers.  The "ROI table", "ROI summary", and 
  "Peak list" options return the corresponding data in a format that can be 
  viewed or used for statistical analysis within R.
}
\usage{
ed()
}

\value{ 
  The "Main plot window" and "Slice" options return a list containing:
  \item{file.par}{Header information for the spectrum including file name, 
  nuclei, number of dimensions, spectrum width, etc.}
  \item{w1}{Chemical shifts in the indirect dimension.}
  \item{w2}{Chemical shifts in the direct dimension.}
  \item{data}{The data from the spectrum, as a matrix of intensities for 2D 
  spectra or a vector for 1D slices and plots.  The first data point in a matrix 
  of 2D intensities, [1, 1], corresponds to the downfield-most point, in both 
  dimensions, for the spectrum.  The last data point in the matrix corresponds 
  to the upfield-most point, in both dimensions, for the spectrum.  In other 
  words, if you traverse the matrix by rows, data points in the matrix start at 
  the bottom-left of the spectrum and move up and to the right (as the spectrum 
  would normally be viewed). See \code{\link{import}} for details on the 
  contents of the ROI table, ROI summary, and peak list objects.}
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{import}} for importing/exporting peak lists, ROI tables, 
and ROI summaries; \code{\link{pp}} for generating peak lists; 
\code{\link{roi}} for generating ROI tables; \code{\link{rSum}} for generating 
ROI summaries; \code{\link{rNMR}} for other rNMR help topics.}

\keyword{iplot}
\keyword{data}