\name{dialogUtils}
\alias{dialogUtils}
\alias{buttonDlg}
\alias{err}
\alias{myDialog}
\alias{myDir}
\alias{myMsg}
\alias{myOpen}
\alias{mySave}
\alias{mySelect}

\title{rNMR dialog box utilities}

\description{The functions detailed below display custom Tk dialogs in 
\pkg{rNMR}.  Several of these functions replace Windows-specific functions
available in Rgui for cross-platform use.
}

\usage{
buttonDlg(message, buttons, checkBox = FALSE, default = buttons[1], 
	title = 'rNMR', parent = NULL)
err(message, parent = NULL, halt = TRUE)
myDialog(message, default, title = 'rNMR', entryWidth = 20, parent = NULL)
myDir(initialdir = "", parent = NULL, title = "", mustexist = TRUE)
myMsg(message = "", type = "ok", icon = "question", title = "rNMR", 
	parent = NULL)
myOpen(defaultextension = "", filetypes = "", initialfile = "", initialdir = "", 
	multiple = TRUE, title = "", parent = NULL)
mySave(defaultextension = "", filetypes = "", initialfile = "", initialdir = "", 
	title = "", parent = NULL)
mySelect(list, preselect = NULL, multiple = FALSE, title = NULL, index = FALSE,
	parent = NULL)
}

\arguments{
  \item{message}{character string; message to display in the Tk dialog.}
  \item{buttons}{character string or vector; names for the buttons to display.
    If "Apply to all" is provided as the third option, a checbox will be 
    displayed in the GUI with that label.}
  \item{default}{(\code{buttonDialog})character string; specifies which of the 
  	buttons should be the	default.  This will be the active button when the 
  	dialog opens and will be the value returned if the dialog is closed without 
  	one of the other buttons being pressed.  Must match one of the values in 
  	\code{button}.}
  \item{checkBox}{logical; if \code{TRUE} the last button in the dialog will be
  	a checkbox.}
	\item{title}{character string; title for the dialog.}
  \item{parent}{optional Tk toplevel object to set as a parent window for the 
  	newly created dialog.  If provided, the dialog will appear near its parent
  	and will bring the parent toplevel object to the front.  This is 
  	particularly useful for displaying message or error dialogs in response to
  	user interactions within rNMR GUIs.}
  \item{halt}{logical; stops code execution if \code{TRUE}.}
  \item{default}{(\code{myDialog}) character string; default text to be 
  	displayed in the dialog's text entry box.}
  \item{entryWidth}{numeric; width of the text entry box in characters.}
  \item{initialdir}{character string; default directory path.}
  \item{title}{character string; title for the Tk dialog.}
  \item{mustexist}{logical; if \code{TRUE} the user must select a previously
  	existing directory.}
  \item{type}{character string; the type of buttons to display in the dialog,
  	must be one of "abortretryignore", "ok", "retrycancel", "okcancel", 
  	"yesno", or "yesnocancel".}
  \item{icon}{character string; icon to use in the dialog, must be one of 
  	"error", "info", "question" or "warning".}
  \item{defaultextension}{(\code{myOpen}) character string; a string specifying 
  	the file extension (without ".") for the default filetype to be displayed in
  	the dialog (must match one of the extensions provided in \code{filetypes})}
  \item{filetypes}{adds the provided file types to the file types listbox in the
	open dialog if supported by the platform.  Must be in list format, for 
	example:  list(txt = "Text File", xls = "Excel File")}
  \item{initialfile}{character string; specifies a filename to be displayed 
  	initially in the dialog.}
  \item{multiple}{logical; if \code{TRUE}, allows users to select more than one 
    file or list item.}
  \item{defaultextension}{(\code{mySave}) character string; a string specifying 
  	the file extension (without ".") to be appended to the file name if one is 
  	not provided.}
  \item{list}{character string or vector; items to display in the list box.}
  \item{preselect}{character string or vector; items to be preselected in the
  	list box.}
  \item{index}{logical; if \code{TRUE}, the indices for the selected list items
  	are returned, rather than the list items themselves.}
}
\details{
\describe{
  \item{\code{buttonDlg}}{Displays a dialog with a message and buttons.  If 
  \code{checkBox} is set to \code{TRUE}, the last button will be a checkbox
  with a label containing the last item in \code{buttons}.  With this option
  enabled, the text associated with the button pressed to close the dialog will 
  be returned along with either \code{TRUE} or \code{FALSE} to indicate whether
  or not the checkbox was checked when the button was pressed.  This is useful 
  when confirming multiple file overwrites.}
  \item{\code{err}}{Displays an error dialog and halts command execution.}
  \item{\code{myDialog}}{A Tk version of R's \code{winDialogString}; 
  displays a dialog box with a text entry widget.}
  \item{\code{myDir}}{A Tk version of R's \code{choose.dir}; displays a 
  directory selection dialog.}
  \item{\code{myMsg}}{Displays a dialog with customizable buttons, icon, and
  message.}
  \item{\code{myOpen} and \code{mySave}}{Display file open and save dialogs, 
  respectively.}
  \item{\code{mySelect}}{A Tk version of R's \code{\link{select.list}}; displays
  a list selection dialog.}
  }
}

\value{
  \code{buttonDlg}, \code{err}, and \code{myMsg} return the text associated
  with the button pressed to close the dialog.  If \code{checkBox} is set to 
  \code{TRUE} in \code{buttonDlg}, the return value will be a data.frame with 
  two values, the first being the button text, the second a logical value 
  indicating whether or not the dialog's checkbox was checked when the user 
  pressed one of the buttons.  \code{myDir}, \code{myOpen}, and \code{mySave} 
  return the selected file or directory name.  \code{mySelect} returns the 
  selected list items as a character vector.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{toolkit}} for other \pkg{rNMR} utility functions.}

\keyword{internal}
