\name{cf}
\alias{cf}

\title{Convert spectra}
\description{
  GUI for converting Bruker, NMRPipe, or Varian format files to UCSF (Sparky) 
  format for use in rNMR.
}
\usage{
cf()
}

\details{
  \code{cf} displays a GUI for converting spectra.  \code{cf} supports 
  processed one-dimensional or two-dimensional Bruker, Varian, NMRPipe, or 
  ASCII (see \code{\link{ca}}) format files.  To convert files, set the input 
  directory using the \bold{Browse} button.  This directory should contain 
  folders for the spectra being converted or the folder for the spectrum 
  itself (see "File Structure" below).  Press the button corresponding to the 
  file type for conversion (\bold{Bruker}, \bold{Varian}, \bold{NMRPipe}, or
  \bold{ASCII}) to display the appropriate folders contained within the input 
  directory.  Select the files you wish to convert from the files list and then 
  press the \bold{Next} button.  
  
  For Bruker and NMRPipe files, this will bring up a dialog containing the 
  selected spectra as well as the corresponding output names for the newly 
  converted files. Checking the \bold{1D Drift correction} box will correct DC 
  offset problems and set the median noise level to zero. Once the conversion 
  parameters have been set, press the \bold{Convert} button to convert the 
  displayed files to UCSF (Sparky) format.
  
  For Varian files, the dialog will contain an additional column indicating the
  indirect nuclei for the selected spectra. By default, the conversion function 
  selects the indirect nucleus using the "dn" parameter from the spectrum's 
  "procpar" file. If this value is incorrect, multiple entries may be edited 
  simultaneously by selecting the appropriate files from the list, and then 
  selecting the desired nucleus from the drop-down box at the bottom of the 
  dialog. This step is only necessary for 2D spectra, as the "tn" (transmitter 
  nucleus) parameter from the "procpar" file is always the correct nucleus for 
  the direct dimension.  For arrayed 1D experiments, each dataset in the array 
  will be saved as a separate spectrum and will be numbered sequentially 
  (appended to the output name).
}

\section{File structure}{
  rNMR's file converter assumes a certain file structure for input directories
  which must be adhered to for file conversions to be successful.  Bruker format
  spectra must contain processed data files ("1r" or "2rr") in a folder named 
  "pdata".  This folder must also contain the processing parameter files 
  ("proc", "procs", "proc2", or "proc2s").  Acquisition parameter files ("acqu",
  "acqus", "acqu2", or "acqu2s") must be in a directory above the "pdata" 
  folder.  These files/folders may be nested within other folders, so long as a 
  "pdata" folder exists somewhere in the spectrum's directory.
  
  NMRPipe format spectra should be individual files containing the NMRPipe 
  format header for the spectrum followed by the processed data. These files 
  should have a ".ft2" or ".dat" extension.
  
  Varian format spectra must contain a processed data file ("phasefile") as well 
  as a processing parameters file ("procpar"). The processed data must be in the 
  directory for the spectrum or in a folder named "datdir". When a spectrum is 
  saved in Vnmr, the processed data file is not written to the same location as 
  the saved spectrum. Instead, "phasefile" is saved to Vnmr's default 
  experimental directory (e.g. "~/vnmrsys/exp/datdir/phasefile"). Spectra may 
  be converted from the "vnmrsys" directory or from the directory where the 
  spectrum was saved, as long as the "phasefile" and "procpar" files are 
  present. These files can be copied automatically for multiple spectra using 
  the Vnmr macro provided at the rNMR website, 
  (\url{http://rnmr.nmrfam.wisc.edu/pages/download/export.html}).  For details 
  on changing the processing commands within the macro or for instructions on
  copying "phasefile" and "procpar"	manually, refer to the "Varian processing
  requirements" section below.
}

\section{Varian processing requirements}{
  The "phasefile" and "procpar" files can be copied manually from the "vnmrsys" 
  directory to the saved directory for the spectrum if the spectrum is processed 
  correctly. To ensure proper conversion in rNMR, Varian spectra must be 
  processed using the following commands:
  \describe{
	\item{1D spectra:}{\code{fn=np*2 ft f full vsadj dc ds flush}}
	\item{Arrayed 1D spectra:}{\code{fn=np*2 ft f full vsadj dc dssh flush}}
	\item{2D spectra:}{\code{trace='f1' wft2da f full dconi flush}}
  }
  These commands can be altered, but there are a few restrictions.  The "ft" and 
  "wft2da" commands can only be substituted with equivalent Fourier transform 
  commands.  Alterations to the processing parameters (e.g. zero filling, window 
  functions, phasing) must precede the Fourier transform command.  For 2D 
  spectra, "trace" must be set to "f1" directly before the data is transformed.
  All commands listed above that follow the Fourier transform command are 
  required. And finally, for arrayed 1D experiments, the "dssh" command is 
  necessary to display the full array.
}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{ca}} for converting ASCII (plain text) files; 
\code{\link{rNMR}} for other rNMR help topics.}

\keyword{utilities}
