\name{ca}
\alias{ca}

\title{Convert ASCII spectra}
\description{
  GUI for converting ASCII (plain text) format spectra to UCSF (Sparky) 
  format for use in rNMR.
}
\usage{
ca()
}

\details{
  \code{ca} displays a GUI for converting ASCII spectra.  \code{ca} supports
  processed one-dimensional or two-dimensional spectra.  To convert files, 
  designate an output directory and select files for conversion using the "Add 
  Files" button.  Output names may be modified by clicking within the "Output 
  Names" column.  Pressing the "Append Paths" button will append the file path 
  to the output name for a selected file.  Checking the "1D Drift correction" 
  box will correct DC offset problems and set the median noise level to zero 
  for all one-dimensional spectra being converted. The direct and indirect 
  nuclei for each spectrum must be provided before conversion. The field 
  strength each spectrum was collected under may also be provided, but this is 
  optional (see the \bold{Conversion} accuracy section below). Click anywhere 
  within the table to edit a single entry.  Multiple entries may be edited 
  simultaneously using the options at the bottom of the GUI.  Once the 
  conversion parameters have been set, press the "Convert" button to convert the 
  displayed files to UCSF format.
}

\section{File structure}{
  rNMR's ASCII file converter assumes a certain file structure which must be 
  adhered to for conversions to be successful.  Two formats are accepted by 
  \pkg{rNMR}.  One-dimensional spectra must include two columns,  the first 
  containing the chemical shift at each point in the spectrum and the second 
  containing the intensity at each point in the spectrum.  Any lines within a 
  file that contain non-numeric values will be ignored during conversion.  Two-
  dimensional spectra may be formatted in a similar matter, the first column
  containing direct chemical shifts, the second containing indirect chemical
  shifts, and the third containing intensities.  Shifts need not be ordered
  under this format, as long as values in each row correspond to each other.

  Two-dimensional spectra may also be formatted into a matrix of intensities 
  (recommended).  Each value in the matrix must be separated by tabs or 
  whitespace.  The first row of the matrix must contain the chemical shifts in 
  the direct dimension, in ascending order from left to right. The first column 
  of the matrix must contain the chemical shifts in the indirect dimension, in 
  ascending order from top to bottom.  The first value in the matrix (the top, 
  left corner) will be ignored.  This format allows for quicker conversion and 
  smaller file sizes. 
  
  Both formats require that values be written in ASCII (plain text) and must be 
  separated by tabs or white space.  Files must contain data for every point in 
  the spectrum and should not be thresholded or compressed. 
}

\section{Conversion accuracy}{
	UCSF format spectra produced by \pkg{rNMR}'s ASCII converter may be opened
	in \pkg{rNMR} as well as Sparky.  During conversion, \pkg{rNMR} appends the 
	up and downfield shifts provided in the ASCII file to the UCSF format file
	header.  This information is not usually included in UCSF files and is
	not used by Sparky when opening spectra.  If you wish to open converted files
	in other programs that support UCSF format (such as Sparky), it is important
	to note that the accuracy of the chemical shifts in the converted file is
	dependent upon the accuracy of the field strength value provided during
	conversion.
	
	Under normal circumstances, when a file is opened in \pkg{rNMR} or Sparky, the 
	up and downfield shifts in each dimension are calculated using the transmitter 
	frequencies, sweep widths, and center frequencies included in the file's 
	header.  This step is bypassed in \pkg{rNMR} when opening spectra produced by
	the ASCII converter.  Instead the up and downfield shifts are taken directly 
	from the original file in order to ensure accuracy.  This is not the case when
	using Sparky.
	
	The transmitter	frequencies included in the UCSF header are calculated using
	the nucleus names and field strength values provided during conversion.  This 
	is accomplished using chemical shift referencing values available at 
	\url{http://www.bmrb.wisc.edu}.  Because these calculations are dependent on 
	the field strength values provided, it is	important to report field strengths 
	with as much accuracy as possible.  If the field strength is not provided
	during conversion, the UCSF file produced by the converter may only be opened
	and displayed accurately by \pkg{rNMR}.
}

\references{\emph{BMRB} homepage: \url{http://www.bmrb.wisc.edu}}

\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{rNMR}} for other rNMR help topics.}

\keyword{utilities}
