\name{addArg}
\alias{addArg}

\title{Additional arguments}
\description{
  Additional arguments that can be passed to \pkg{rNMR} functions.
}


\details{
  Many \pkg{rNMR} functions accept additional arguments that get passed to
  internal plotting and peak picking functions.  The option of passing these
  arguments is provided as a convenience for advanced \pkg{rNMR} users and 
  developers.  The various parameters for these functions are described below.
}

\section{Plotting parameters}{
 \describe{
  \item{\code{add}}{logical; \code{TRUE} adds new data to an existing plot, 
	\code{FALSE} generates a new plot.}
  \item{\code{axes}}{logical; \code{TRUE} makes pretty labels, \code{FALSE} 
  	puts a box around the plot but no labels.}
  \item{\code{bg}}{Background color, see \code{\link{colors}} for the many color 
	options.}
  \item{\code{col}}{Color for 1D data and 1D slices/projections of 2D data.  All 
  	2D plots use \code{pos.color} for positive intensities, and 
		\code{neg.color} for negative intensities. 3D perspective plots use 
		\code{pos.color} for all data, and all 1D plots use \code{col}.}
  \item{\code{col.axis}}{Axis color, see \code{\link{colors}} for the many color 
		options.}
  \item{\code{col.lab}}{Color used for axis labels, see \code{\link{colors}} for
    the many color options.}
  \item{\code{col.main}}{Color used for plot main titles, see
    \code{\link{colors}} for the many color options.}
  \item{\code{col.sub}}{Color used for plot sub-titles, see \code{\link{colors}}
    for the many color options.}
  \item{\code{conDisp}}{logical vector; \code{c(TRUE, TRUE)} plots positive 
	and	negative contours, \code{c(TRUE, FALSE)} plots only positive, 
	\code{c(FALSE, TRUE)} plots	only the negative contours, 
	\code{c(FALSE, FALSE)} plots no contours.}
  \item{\code{fg}}{Foreground color, see \code{\link{colors}} for the many color 
	options.}
  \item{\code{main}}{character string; main title for plot, the default is the 
	file name.}
  \item{\code{neg.color}}{Color for negative contours, the default is the most 
	recent setting for the file, see \code{\link{colors}} for the many color 
	options.}
  \item{\code{neg.zlim}}{numeric (\code{c(lower, upper)}); min and max 
  	intensities to be displayed for negative contours, the default is the most 
  	recent setting used with the file.}
  \item{\code{nlevels}}{positive integer; the number of contour intervals to be 
    drawn, the default is the most recent setting used for the file.}
  \item{\code{p.window}}{character string; name of the window (device) to be 
	used, can be "\code{main}", "\code{sub}", "\code{multi}", or 
	"\code{stats}".}
  \item{\code{pos.color}}{Color for positive contours, the default is the most 
	recent setting for the file, see \code{\link{colors}} for the many color 
	options.}
  \item{\code{pos.zlim}}{numeric (\code{c(lower, upper)}); min and 
  	max intensities to be displayed for positive contours, the default is the 
  	most recent setting used with the file.}
  \item{\code{type}}{character string; specifies the type of plot to be 
    generated.  2D data can be drawn as "\code{auto}", "\code{image}", 
    "\code{contour}", "\code{filled}", and "\code{persp}".  Image plots are 
    fastest, contour plots are more detailed, "\code{filled}" produces a filled 
    contour plot, "\code{persp}" generates a 3D perspective plot, and 
    "\code{auto}" (the default) switches between image and contour depending on 
    the amount of data being displayed.  1D plots can also be passed a type. 
	Arguments include "\code{l}", "\code{p}", and "\code{b}" for line, point, 
	and both line and points, respectively. 1D spectra default to "\code{l}".  
	2D data, when passed any of	the 1D arguments will invoke \command{proj1D} 
	and "\code{l}", "\code{p}" or "\code{b}" will be passed to \command{proj1D}.  
	If \code{type} is set to \code{NULL}, \code{type} is taken from the 
	spectrum's last setting.} 
  \item{\code{w1Range}}{numeric (\code{c(lower, upper)}); chemical 
    shift range in the indirect dimension, the default is the most recent 
    setting used with the file.}
  \item{\code{w2Range}}{numeric (\code{c(lower, upper)}); chemical 
    shift range in the direct dimension, the default is the most recent setting 
    used with the file.}
  \item{\code{xlab}}{character string; label for the x-axis, the default is the 
	direct detected nucleus in ppm.}
  \item{\code{ylab}}{character string; label for the y-axis, the default is the 
	indirect detected nucleus in ppm.}
 }

  See \code{\link{plot}}, \code{\link{image}}, \code{\link{contour}}, 
  \code{\link{persp}} for additional plot parameters and their descriptions.
}
  
\section{Peak picking parameters}{
 \describe{
  \item{\code{append}}{logical; \code{TRUE} appends new peaks to the previous 
 	peak list.}
  \item{\code{fancy}}{logical; \code{FALSE} implements a basic peak picker that 
  	returns local maxima only (this is fastest), \code{TRUE} determines 
  	chemical shifts of peaks, groups multiplets, and measures line width.}
  \item{\code{file.name}}{character string or vector; name of the file(s) to be 
  	peak picked.  The default, \code{NULL}, will pick the current spectrum.  
  	Note:  \code{file.name} must match one of the values returned when calling 
  	\code{names(fileFolder)}.}
  \item{\code{internal}}{logical; \code{TRUE} returns the peak list without 
 	assigning it to fileFolder, \code{FALSE} assigns the list to fileFolder.}
  \item{\code{noiseFilt}}{either \code{0}, \code{1} or \code{2}; \code{0} does 
  	not apply a noise filter, \code{1} applies a mild filter (adjacent points in 
  	the direct dimension must be above the noise threshold), \code{2} applies a 
  	strong filter (all adjacent points must be above the noise threshold.}
  \item{\code{w1Range}}{numeric; w1 chemical shift range 
	(\code{c(downfield, upfield)}) to be used.}
  \item{\code{w2Gran}}{integer; controls granularity of search space, smaller 
 	values are more exhaustive, larger values suppress noise.}
  \item{\code{w2Range}}{numeric; w2 chemical shift range 
 	\code{(c(downfield, upfield)}) to be used.}
 }
}
  
\author{Ian A. Lewis \email{ialewis@nmrfam.wisc.edu}, 
Seth C. Schommer \email{schommer@nmrfam.wisc.edu}}

\seealso{\code{\link{rNMR}} for other rNMR help topics.}

\keyword{iplot}
\keyword{hplot}