/* TABO.C - command line utility to display tabular file so that columns line up visually
 * Copyright 1998-2001 Stephen C. Grubb  (www.sgpr.net) .
 * This code is covered under the GNU General Public License (GPL);
 * see the file ./Copyright for details. */

/* lines beginning with // are omitted */

#define MAXCOLS 1024
#include "tdhkit.h"

extern int exit();

int
main( argc, argv )
int argc;
char **argv;
{
int i, ix, j, k;
char buf[ MAXRECORDLEN ];
FILE *fp;
int len[MAXCOLS];
char *getok();
int ncols;
char tok[255];
char spacer[40];
int topt;
int ropt;
char headerline[ MAXRECORDLEN ];
int rowcount;
int lineopt;


if( argc < 2 ) {
	fprintf( stderr, "usage: tabo file [-s spacerstring]\n" );
	exit(1);
	}
strcpy( spacer, " " );
topt = 0;
ropt = 0;
lineopt = 0;
for( i = 1; i < argc; i++ ) {
	if( strcmp( argv[i] , "-s" )==0 ) {
		i++;
		if( i < argc ) strcpy( spacer, argv[i] );
		continue;
		}
	else if( strcmp( argv[i], "-t" )==0 ) topt = 1;
	else if( strcmp( argv[i], "-r" )==0 ) ropt = 1;
	else if( strcmp( argv[i], "-l" )==0 ) lineopt = 1;
	else if( argv[i][0] == '-' ) fprintf( stderr, "tabo: warning ignoring unrecognized option: %s\n", argv[i] );
	else	{
		/* stdin doesn't work because of the rewind() .. */
		fp = fopen( argv[i], "r" );
		if( fp == NULL ) {
			fprintf( stderr, "cannot open %s\n", argv[i] );
			exit(1);
			}
		}
	}

/* initialize */
for( i = 0; i < MAXCOLS; i++ ) len[i] = 0;
ncols = 0;

/* go through and find max lengths.. */
while( fgets( buf, MAXRECORDLEN-1, fp ) != NULL ) {
	sscanf( buf, "%s", tok );
	if( strncmp( tok, "//", 2 )==0 ) continue;
	for( i = 0, ix = 0; ; i++ ) {
		if( topt ) GL_getseg( tok, buf, &ix, "\t\n" );
		else strcpy( tok, GL_getok( buf, &ix ) );
		if( tok[0] == '\0' ) break;
		if( strlen( tok ) > len[i] ) len[i] = strlen( tok );
		}
	if( i > ncols ) ncols = i;
	}

/* now display.. */
rewind( fp );
rowcount = 0;
while( fgets( buf, MAXRECORDLEN-1, fp ) != NULL ) {

	sscanf( buf, "%s", tok );
	if( strncmp( tok, "//", 2 )==0 ) continue;

	REPEAT:
	if( ropt && rowcount == 0 ) strcpy( headerline, buf );
	rowcount++;

	for( i = 0, ix = 0; ; i++ ) {
		if( topt ) GL_getseg( tok, buf, &ix, "\t\n" );
		else strcpy( tok, GL_getok( buf, &ix ) );
		if( tok[0] == '\0' ) break;

		/* first column - left aligned */
		if( i == 0 ) {
			printf( "%s", tok );
			for( j = strlen( tok ); j < len[i]; j++ ) printf( " " );
			}
		/* other columns - centered */
		else	{
			k = (len[i] - strlen( tok )) / 2;
			for( j = 0; j < k; j++ ) printf( " " );
			printf( "%s", tok );
			for( j = k + strlen( tok ); j < len[i]; j++ ) printf( " " );
			}
		printf( "%s", spacer );
		}
	printf( "\n" );

	if( lineopt && (rowcount == 1 || (ropt && rowcount % 30 == 0)) ) {  /* supply rulings below header line.. */
		for( i = 0; i < ncols; i++ ) {
			for( j = 0; j < len[i]; j++ ) printf( "-" );
			printf( " " );
			}
		printf( "\n" );
		}

	/* replicate header line */
	if( ropt && (rowcount % 30) == 29 ) {
		strcpy( buf, headerline );
		printf( "\n" );
		goto REPEAT;
		}
	}
exit( 0 );
}
