/* SHSQL CONFIG
 * Copyright 1998-2002 Stephen C. Grubb  
 * This code is covered under the GNU General Public License (GPL);
 * see the file ./Copyright for details. */

#include "tdhkit.h"
#include "shsql.h"

/* the following are settable using config file.. */
char SHSQL_projdir[ MAXPATH ] = "./";

char SHSQL_bin[ MAXPATH ] = "";				/* directory where shsql executables reside */
char SHSQL_tmptabledir[ MAXPATH ] = "./";		/* directory where temp tables will reside */
char SHSQL_tmptblpfx[MAXPATH] = "";			/* process-unique temp table prefix */
char SHSQL_commonwordsfile[MAXPATH] = "";		/* pathname of common words file (words that word index can ignore) */

char SHSQL_wildchar = '*';		/* default wild card character */
char SHSQL_wildchar1 = '?';		/* default 1-slot wild card character */
int SHSQL_debug = 0;			/* debug mode */
long SHSQL_rlocktimeout = 30;		/* # minutes until a record lock times out */
int SHSQL_nrows = 0;			/* holds row count - for internal use */
int SHSQL_translog = 1;			/* 1 = log all transactions  0 = don't */
int SHSQL_splitlog = 0;			/* if 1, one transaction log file per identity */
int SHSQL_readonly = 0;			/* if 1, disallow updates */
char SHSQL_delim = BLANK;		/* field delim character */
char SHSQL_delims[2] = " ";		/* string equivalent of above */
int SHSQL_maxrows_select = 2000; 	/* max # of rows that a select may retrieve */
int SHSQL_maxrows_update = 2000; 	/* max # of rows that an update or delete may affect */
int SHSQL_ixtrunclen = 15;		/* index entries truncated to this length */
int SHSQL_mustix = 0;			/* if 1, table scans prohibited on any table having index(es) */
int SHSQL_suppressix = 0;		/* if 1, indexing suppressed by user for testing */
char SHSQL_spacerep = '_';		/* character that represents space */
int SHSQL_writelock_ntries = 8;		/* number of times to retry when encountering a write-locked table */
int SHSQL_retainund = 0;  		/* if 1, SHSQL_getrow will not convert embedded underscores to space */

extern char TDH_configfile[];



/* =========================== */
/* ALLCONFIG - using the SHSQL_DB environment variable, get settings from the config file */
int
SHSQL_allconfig()
{
int stat, flag;
char buf[MAXPATH];
char *getenv(), *s;

flag = 0;
s = getenv( "SHSQL_DB" );
if( s == NULL ) {
	s = getenv( "SHSQL_CONFIG" );
	flag = 1;
	}
if( s == NULL ) return( err( 4932, "cannot find SHSQL_DB or SHSQL_CONFIG env var", "" ));
if( s[0] == '\0' ) return( err( 4932, "empty SHSQL_DB or SHSQL_CONFIG env var", "" ));

if( flag ) sprintf( buf, "file=%s", s );
else sprintf( buf, "file=%s/config", s );

stat = 0;
stat = TDH_readconfig( buf );
if( stat != 0 ) return( stat );
stat += SHSQL_readconfig();
if( strcmp( TDH_scriptdir, "./" )==0 ) sprintf( TDH_scriptdir, "%s/pages", SHSQL_projdir );
return( stat );
}

/* =========================== */
/* READCONFIG - get shsql settings from config file.
	The config file is the same as the tdhkit config file.
	Any call to this routine MUST be preceded by a call to TDH_readconfig(),
	which sets global TDH_configfile to hold the name of the file.
 */
int
SHSQL_readconfig()
{
FILE *fp;
char buf[512];
char tag[80];
char value[512];
int nt;

if( TDH_configfile == NULL ) {
	return( err( 1501, "config file not defined", "" ) );
	}
fp = fopen( TDH_configfile, "r" );
if( fp == NULL ) {
	return( err( 1501, "Cannot open config file", TDH_configfile ) );
	}

/* as a default, set tmptabledir to TDH_tmpdir.. */
strcpy( SHSQL_tmptabledir, TDH_tmpdir );

/* get user settings.. */
while( fgets( value, 511, fp ) != NULL ) {

	TDH_value_subst( buf, value, NULL, "", NORMAL, 1 );
	

	buf[ strlen( buf ) -1 ] = '\0';
	nt = sscanf( buf, "%s %s", tag, value );
	if( nt < 1 ) continue; /* skip blank lines */
	if( tag[0] == '/' ) continue; /* skip comments */


	if( nt < 2 ) strcpy( value, "" );

	if( stricmp( tag, "projectdir:" )==0 ) strcpy( SHSQL_projdir, value );
	else if( stricmp( tag, "dbtmptabledir:" )==0 ) {
		strcpy( SHSQL_tmptabledir, value );
		if( strcmp( TDH_tmpdir, "/tmp" )==0 ) strcpy( TDH_tmpdir, value );
		}
	else if( stricmp( tag, "dbbin:" )==0 ) { if( stricmp( value, "path" )!= 0 ) strcpy( SHSQL_bin, value ); }
	else if( stricmp( tag, "dbtranslog:" )==0 ) SHSQL_translog = atoi( value );
	else if( stricmp( tag, "dbtranslog_byuser:" )==0 ) SHSQL_splitlog = atoi( value );
	else if( stricmp( tag, "dbdebugmode:" )==0 ) SHSQL_debug = atoi( value );
	else if( stricmp( tag, "dbmaxrows_select:" )==0 ) SHSQL_maxrows_select = atoi( value );
	else if( stricmp( tag, "dbmaxrows_update:" )==0 ) SHSQL_maxrows_update = atoi( value );
	else if( stricmp( tag, "dbdelimchar:" )==0 ) {
		if( stricmp( value, "space" )==0 ) SHSQL_delim = BLANK;
		else if( stricmp( value, "tab" )==0 ) SHSQL_delim = '\t';
		else SHSQL_delim = value[0];
		sprintf( SHSQL_delims, "%c", SHSQL_delim );
		}
	else if( stricmp( tag, "dbspacerep:" )==0 ) SHSQL_spacerep = value[0];
        else if( stricmp( tag, "dbwildcard:" )==0 ) SHSQL_wildchar = value[0];
        else if( stricmp( tag, "dbwildcard1:" )==0 ) SHSQL_wildchar1 = value[0];
        else if( stricmp( tag, "dbrecordlock_timeout:" )==0 ) SHSQL_rlocktimeout = atoi( value );
        else if( stricmp( tag, "dbwritelock_ntries:" )==0 ) SHSQL_writelock_ntries = atoi( value );
        else if( stricmp( tag, "dbreadonly:" )==0 ) SHSQL_readonly = atoi( value );
        else if( stricmp( tag, "dbindextrunc:" )==0 ) SHSQL_ixtrunclen = atoi( value );
        else if( stricmp( tag, "dbmustindex:" )==0 ) SHSQL_mustix = atoi( value );
        else if( stricmp( tag, "dbsuppressindex:" )==0 ) SHSQL_suppressix = atoi( value );
        else if( stricmp( tag, "dbcommonwordsfile:" )==0 ) strcpy( SHSQL_commonwordsfile, value );
	}
fclose( fp );
return( 0 );
}
