/* DBCAT.C - print named SHSQL table(s) to standard output.
 * Output stream will have field name header.
 * 
 * Copyright 1998-2001 Stephen C. Grubb  (www.sgpr.net) .
 * This code is covered under the GNU General Public License (GPL);
 * see the file ./Copyright for details. */

#include "tdhkit.h"
#include "shsql.h"

int
main( argc, argv )
int argc;
char **argv;
{
int i, firstline, stat;
char buf[ MAXRECORDLEN+1 ];
FILE *fp;
int path_opt;	/* if 1, pathnames are specified instead of tablenames */

TDH_errprog( "dbcat" );
if( argc < 2 ) { fprintf( stderr, "usage: dbcat table1 .. tableN\n" ); exit( 1 ); }


/* process config file if any.. */
stat = SHSQL_allconfig();
if( stat != 0 ) { fprintf( stderr, "dbcat error: cannot read config file\n" ); exit( 1 ); }

path_opt = 0;
for( i = 1; ; i++ ) {
	if( strcmp( argv[i], "-p" )==0 ) path_opt = 1;
	else break;
	}

for( ; i < argc; i++ ) {
	if( path_opt ) strcpy( buf, argv[i] );
	else sprintf( buf, "%s/data/%s", SHSQL_projdir, argv[i] );
	fp = fopen( buf, "r" );
	if( fp == NULL ) { 
		fprintf( stderr, "dbcat: cannot open %s\n", buf );
		continue;
		}
	firstline = 1;
	while( fgets( buf, MAXRECORDLEN, fp ) != NULL ) {
		if( buf[0] == SHSQL_delim || strncmp( buf, "//", 2 )==0 ) continue;

		if( i > 1 && firstline ) {
			firstline = 0;
			continue;
			}

		printf( "%s", buf );
		}
	fclose( fp );
	}
exit( 0 );
}
