#!/bin/sh
#
# create a new quisp and/or shsql project directory with a config file.
#
# usage: newproject projdir_pathname
#
#

echo "Welcome to quisp/shsql project setup script.  

Instructions are available at 
http://quisp.sourceforge.net/qman/html/support.html

Preparing to create a quisp/shsql project directory...
"

if [ $# -eq 1 ]; then
  DBDIR=$1
else
  echo "Enter full path name for your project directory:"
  read DBDIR
fi

if [ "$DBDIR" = "" ]; then
  echo "No path name supplied."
  exit 1
fi

if test -d $DBDIR; then
  echo "Directory $DBDIR already exists.  Continue (y/n)? "
  read ANS
  if [ "$ANS" = "n" ]; then
    exit 1
  fi
else
  mkdir $DBDIR
fi
	
# be sure DBDIR is a full pathname..
cd /tmp
if test -d $DBDIR; then
  echo ""
else
  echo "The project dir pathname must be a full pathname."
  exit 1 
fi

cd $DBDIR
if [ $? -ne 0 ]; then
  echo "cannot cd into the newly created project directory"
  exit 1
fi
	
# make subdirs..
mkdir data indexes locks tmp logs pages textchunks
if [ $? -ne 0 ]; then
  echo "error during creation of subdirectories"
  exit 1
fi
# this subdir is needed by demo..
mkdir textchunks/examp_art

# make config file..
echo "//////// Config file for QUISP / SHSQL   quisp.sourceforge.net

varvalue:	PROJDIR=$DBDIR
projectdir:	@PROJDIR		// directory where database resides
tmpdir:		@PROJDIR/tmp 		// dir where misc temp files will be created

//////// SHSQL attributes:
dbbin:		path			// dir where shsql executables reside, or 'path'
putenv:	SHSQL_DB=@PROJDIR		// set shell env var for any subprocesses
dbtmptabledir:	@PROJDIR/tmp		// dir where temp tables will be created
dbcommonwordsfile: @PROJDIR/commonwords	// file containing 'common words', one per line
dbnull:		=			// symbol that will represent NULL in data files

//////// QUISP attributes:		
scriptdir:	@PROJDIR/pages 		// directory where quisp page files reside
defaultrtn:	testpage1		// default page 
//
// Set the following correctly for your local system:
varvalue:	HTMLURL=		// URL location of your local html directory 
varvalue:	HTMLPATH=/data/htdocs/you_need_to_set_this	// pathname location of your local html directory
// varvalue:	CGIPROG=/cgi-bin/quisp		// URL location of your quisp executable (or equivalent)
// varvalue:	CGIPROG_PL=/cgi-bin/quisp_pl	// URL location of your quisp_pl executable (or equivalent)
" > config


# make some fake database tables..
echo "// demo data for QUISP example pages... this file can be removed when done trying examples.
id name prefix city country nick _locktime _lockowner             
1 Jackson_Laboratory The Bar_Harbor,_ME USA JAX 43tdq terlingua 
2 University_of_Colorado = Boulder,_CO USA = = =            
3 Children's_Hospital = Boston,_MA USA = = =            
4 International_Livestock_Research_Institute = Nairobi KENYA = = =            
5 Portland_Alcohol_Research_Center = Portland,_OR USA = = =            
6 Harvard_Medical_School = Boston,_MA USA = = =            
7 Howard_Hughes_Medical_Institute = = = = = =
9 University_of_Washington = Seattle,_WA USA = = =            
10 University_of_Tennessee = Memphis,_TN USA = = =            
11 George_Washington_University_School_of_Medicine The Washington,_DC USA = = =               
12 Animal_Genetic_Systems,_Inc. = College_Park,_MD USA = = fried     
13 Princeton_University = Princeton,_NJ USA = = =            
15 University_of_Cincinnati = Cincinnati,_OH USA = = =            
19 Medical_College_of_Wisconsin = Milwaukee,_WI USA = = =            
21 Institut_Pasteur = = FRANCE = = =            
22 Baylor_College_of_Medicine = Houston,_TX USA = 36g9t fried    
24 Graduate_University_for_Advanced_Studies The = JAPAN = = =            
25 Northwestern_University = Evanston,_IL USA = = =            
32 Boston_University = Boston,_MA USA = = =            
35 Yale_University = New_Haven,_CT USA = = =            
37 National_Cancer_Institute = Bethesda,_MD USA = = =            
38 VA_Medical_Center = Portland,_OR USA = = =            
40 National_Institute_of_Genetics = Mishima JAPAN = = =            
41 RIKEN_Brain_Science_Institute = Wako JAPAN = = =            
42 University_of_Calgary = Calgary,_Alberta CANADA = = =            
43 Rockefeller_University = New_York,_NY USA = = =            
44 University_of_Illinois_at_Urbana-Champaign = Champaign,_IL USA = = =             
45 Hebrew_University_of_Jerusalem = Jerusalem ISRAEL = = =            
99 Pennsylvania_State_University The University_Park,_PA USA = = = 
121 University_of_California-San_Diego The CA = = = = 
139 Scripps_Research_Institute The La_Jolla,_CA USA = = = 
" > data/examp_institutes


echo "// demo data for QUISP example pages... this file can be removed when done trying examples.
varname strain istrain sex mean nmice nmissing sd se cv min max logmean logsd logse logcv zscore logzscore
HR 129S1/SvImJ 3 f 699 8 0 78.0 27.6 0.112 519 764 6.54 0.124 0.0438 0.0189 -0.32 -0.32 
HR A/J 4 f 720 8 0 66.8 23.6 0.0929 612 798 6.58 0.0959 0.0339 0.0146 -0.08 0.00 
HR AKR/J 15 f 724 8 0 61.3 21.7 0.0847 643 808 6.58 0.0845 0.0299 0.0128 -0.03 0.00 
HR BALB/cJ 5 f 537 8 0 33.2 11.7 0.0619 508 612 6.29 0.0593 0.0210 0.00943 -2.22 -2.31 
HR BTBR_T+_tf/J 1 f 721 8 0 52.4 18.5 0.0727 671 824 6.58 0.0704 0.0249 0.0107 -0.07 0.00 
HR C3H/HeJ 6 f 795 7 1 22.2 8.40 0.0280 757 829 6.68 0.0280 0.0106 0.00420 0.80 0.80 
HR C57BL/6J 7 f 764 8 0 36.7 13.0 0.0480 715 828 6.64 0.0476 0.0168 0.00717 0.44 0.48 
HR CAST/EiJ 2 f 806 8 0 23.7 8.38 0.0294 751 828 6.69 0.0301 0.0106 0.00450 0.93 0.88 
HR CBA/J 16 f 783 8 0 21.9 7.75 0.0280 747 810 6.66 0.0281 0.00994 0.00422 0.66 0.64 
HR DBA/2J 8 f 628 8 0 84.1 29.7 0.134 479 702 6.44 0.141 0.0500 0.0220 -1.16 -1.12 
HR FVB/NJ 9 f 767 7 1 63.6 24.0 0.0830 649 821 6.64 0.0866 0.0327 0.0130 0.47 0.48 
HR LP/J 10 f 794 8 0 29.9 10.6 0.0376 754 843 6.68 0.0374 0.0132 0.00560 0.79 0.80 
HR NOD/LtJ 13 f 788 8 0 17.8 6.30 0.0226 763 818 6.67 0.0225 0.00797 0.00338 0.72 0.72 
HR NZB/BlNJ 11 f 797 8 0 19.3 6.82 0.0242 770 824 6.68 0.0241 0.00852 0.00361 0.82 0.80 
HR PL/J 14 f 618 8 0 54.6 19.3 0.0884 543 710 6.42 0.0880 0.0311 0.0137 -1.27 -1.28 
HR SJL/J 17 f 590 8 0 27.4 9.68 0.0464 544 627 6.38 0.0466 0.0165 0.00731 -1.60 -1.59 
HR SWR/J 12 f 822 8 0 30.9 10.9 0.0375 764 850 6.71 0.0382 0.0135 0.00569 1.12 1.04 
HR_VAR 129S1/SvImJ 3 f 9.12 8 0 4.90 1.73 0.537 3.60 18.0 2.21 0.486 0.172 0.220 -0.63 -0.70 
HR_VAR A/J 4 f 18.2 8 0 10.6 3.75 0.581 7.40 31.2 2.81 0.597 0.211 0.213 -0.15 0.23 
HR_VAR AKR/J 15 f 9.96 8 0 6.23 2.20 0.626 4.80 23.7 2.28 0.488 0.173 0.214 -0.59 -0.59 
HR_VAR BALB/cJ 5 f 59.1 7 1 42.3 16.0 0.716 10.9 137 3.85 0.817 0.309 0.212 2.00 1.84 
HR_VAR BTBR_T+_tf/J 1 f 13.4 8 0 11.2 3.96 0.834 5.50 36.6 2.47 0.633 0.224 0.257 -0.41 -0.30 
HR_VAR C3H/HeJ 6 f 68.0 7 1 32.9 12.4 0.484 6.40 117 4.01 0.912 0.345 0.227 2.46 2.09 
HR_VAR C57BL/6J 7 f 10.3 8 0 8.97 3.17 0.871 5.30 32.1 2.26 0.536 0.190 0.237 -0.57 -0.63 
HR_VAR CAST/EiJ 2 f 16.7 8 0 17.6 6.24 1.06 4.20 56.5 2.51 0.887 0.314 0.354 -0.23 -0.24 
HR_VAR CBA/J 16 f 9.49 7 1 2.53 0.957 0.267 5.80 12.3 2.32 0.256 0.0966 0.110 -0.61 -0.53 
HR_VAR DBA/2J 8 f 42.5 6 2 34.1 13.9 0.802 11.2 91.1 3.49 0.840 0.343 0.241 1.12 1.28 
HR_VAR FVB/NJ 9 f 37.7 7 1 36.7 13.9 0.972 4.30 93.0 3.18 1.12 0.422 0.351 0.87 0.80 
HR_VAR LP/J 10 f 8.14 8 0 3.87 1.37 0.476 3.70 14.7 2.14 0.419 0.148 0.196 -0.68 -0.81 
HR_VAR NOD/LtJ 13 f 6.97 8 0 1.15 0.406 0.164 5.20 8.60 2.07 0.146 0.0515 0.0705 -0.74 -0.92 
HR_VAR NZB/BlNJ 11 f 5.46 8 0 2.56 0.904 0.468 2.60 8.70 1.79 0.407 0.144 0.227 -0.82 -1.36 
HR_VAR PL/J 14 f 16.7 8 0 5.93 2.10 0.356 8.00 27.6 2.82 0.348 0.123 0.123 -0.23 0.24 
HR_VAR SJL/J 17 f 19.3 8 0 9.71 3.43 0.504 9.30 40.1 2.92 0.435 0.154 0.149 -0.10 0.40 
HR_VAR SWR/J 12 f 7.93 8 0 3.14 1.11 0.396 4.60 14.7 2.14 0.309 0.109 0.144 -0.69 -0.81 
RR 129S1/SvImJ 3 f 87.1 8 0 12.1 4.29 0.139 78.5 116 4.47 0.124 0.0438 0.0277 0.22 0.25 
RR A/J 4 f 84.2 8 0 8.42 2.98 0.100 75.2 98.3 4.44 0.0958 0.0339 0.0216 -0.03 0.01 
RR AKR/J 15 f 83.4 8 0 7.07 2.50 0.0848 74.2 93.4 4.43 0.0840 0.0297 0.0190 -0.10 -0.06 
RR BALB/cJ 5 f 114 7 1 7.55 2.86 0.0665 98.5 122 4.74 0.0686 0.0259 0.0145 2.50 2.36 
RR BTBR_T+_tf/J 1 f 83.7 8 0 5.66 2.00 0.0677 73.0 89.4 4.44 0.0690 0.0244 0.0155 -0.07 0.01 
RR C3H/HeJ 6 f 76.3 7 1 2.92 1.10 0.0383 73.1 82.4 4.35 0.0370 0.0140 0.00851 -0.70 -0.69 
RR C57BL/6J 7 f 77.2 8 0 3.12 1.10 0.0404 72.5 82.2 4.36 0.0399 0.0141 0.00914 -0.62 -0.61 
RR CAST/EiJ 2 f 74.6 8 0 2.45 0.867 0.0328 72.5 80.4 4.33 0.0316 0.0112 0.00730 -0.84 -0.85 
RR CBA/J 16 f 78.8 8 0 3.18 1.12 0.0404 74.1 84.5 4.38 0.0397 0.0140 0.00907 -0.48 -0.46 
RR DBA/2J 8 f 99.1 6 2 16.6 6.76 0.167 85.5 126 4.60 0.159 0.0647 0.0345 1.23 1.27 
RR FVB/NJ 9 f 79.0 7 1 7.00 2.65 0.0887 73.5 92.4 4.38 0.0840 0.0318 0.0192 -0.47 -0.46 
RR LP/J 10 f 75.7 8 0 2.83 1.00 0.0374 71.2 79.6 4.34 0.0371 0.0131 0.00854 -0.75 -0.77 
RR NOD/LtJ 13 f 75.7 8 0 1.70 0.602 0.0225 73.3 78.7 4.34 0.0221 0.00782 0.00510 -0.75 -0.77 
RR NZB/BlNJ 11 f 75.1 8 0 2.22 0.785 0.0296 71.1 78.0 4.33 0.0294 0.0104 0.00679 -0.80 -0.85 
RR PL/J 14 f 97.9 8 0 8.72 3.08 0.0890 84.5 111 4.59 0.0884 0.0312 0.0192 1.13 1.19 
RR SJL/J 17 f 102 8 0 4.74 1.67 0.0464 95.7 110 4.63 0.0458 0.0162 0.00988 1.48 1.50 
RR SWR/J 12 f 73.1 8 0 2.87 1.02 0.0393 70.6 78.6 4.30 0.0381 0.0135 0.00884 -0.97 -1.08 
PQ 129S1/SvImJ 3 f 24.9 8 0 2.26 0.798 0.0905 20.1 27.5 3.25 0.0922 0.0326 0.0283 1.43 1.30 
PQ A/J 4 f 23.2 8 0 1.36 0.481 0.0587 20.7 25.0 3.18 0.0572 0.0202 0.0180 0.65 0.62 
PQ AKR/J 15 f 22.0 8 0 2.34 0.827 0.106 17.4 24.5 3.13 0.107 0.0378 0.0342 0.09 0.14 
PQ BALB/cJ 5 f 21.9 7 1 1.49 0.564 0.0683 19.3 23.4 3.13 0.0668 0.0252 0.0213 0.05 0.14 
PQ BTBR_T+_tf/J 1 f 22.2 8 0 2.36 0.833 0.106 19.0 25.0 3.14 0.103 0.0364 0.0328 0.19 0.23 
PQ C3H/HeJ 6 f 17.3 7 1 3.87 1.46 0.224 10.7 22.8 2.88 0.229 0.0866 0.0794 -2.07 -2.30 
PQ C57BL/6J 7 f 21.1 8 0 1.14 0.404 0.0542 19.0 22.4 3.09 0.0526 0.0186 0.0170 -0.32 -0.25 
PQ CAST/EiJ 2 f 19.0 8 0 1.13 0.400 0.0595 17.1 20.1 2.99 0.0577 0.0204 0.0193 -1.29 -1.22 
PQ CBA/J 16 f 19.3 8 0 2.64 0.933 0.136 13.8 21.9 3.00 0.142 0.0502 0.0473 -1.15 -1.13 
PQ DBA/2J 8 f 21.8 6 2 0.737 0.301 0.0339 20.5 22.4 3.12 0.0328 0.0134 0.0105 0.00 0.04 
PQ FVB/NJ 9 f 18.7 7 1 2.56 0.968 0.137 14.8 22.3 2.97 0.132 0.0499 0.0444 -1.42 -1.42 
PQ LP/J 10 f 22.6 8 0 1.49 0.526 0.0658 20.1 24.6 3.16 0.0636 0.0225 0.0201 0.37 0.43 
PQ NOD/LtJ 13 f 22.9 8 0 1.84 0.652 0.0805 19.2 24.6 3.17 0.0805 0.0284 0.0254 0.51 0.53 
PQ NZB/BlNJ 11 f 24.8 8 0 1.19 0.422 0.0481 22.7 26.1 3.25 0.0471 0.0167 0.0145 1.38 1.30 
PQ PL/J 14 f 23.9 8 0 2.39 0.845 0.0999 19.7 28.0 3.21 0.0974 0.0344 0.0303 0.97 0.92 
PQ SJL/J 17 f 23.7 8 0 2.36 0.835 0.0998 19.5 26.0 3.20 0.0993 0.0351 0.0310 0.88 0.82 
PQ SWR/J 12 f 21.2 8 0 2.01 0.710 0.0945 18.3 23.3 3.10 0.0931 0.0329 0.0300 -0.27 -0.15 
" > data/examp_stats


echo "// demo data for QUISP example pages... this file can be removed when done trying examples.
id artist title format size frame year_created current_value textdesc img1 img2 img3 _lockowner _locktime
204 unknown S._S._Repton watercolor 23_x_15.5 wide_wood_frame,_guilded c._1905 2000 1 repton1.jpg repton4.jpg = = =                   
206 Persolglia Musical_Romance oil 31~_x_21.5~ museum_mounted,_custom_gold_lear_frame c._1890 4000 1 persoglia.jpg = = = =                       
205 Haddon,_Trevor Idle_Conversation oil 11.5~_x_17.5~ gilt_frame c._1880 4000 1 haddon1.jpg = = = =                                      
207 Lomax,_John_A. Repairing_the_Doll oil 25.3~_x_30~ yes 1880 4700 1 lomax.jpg = = = =                 
208 Grutzner,_N Clergyman_After_Dinner oil 8.5~_x_10~ beautiful_period_frame late_19C 300 1 grutzner.jpg = = fried.jax.org 44dbA     
209 Faure,_Amadeus The_Circus_Family oil 41.3~_x_48.9 original_frame 1917 1000 1 circus.jpg = = = =                   
210 Hooper,_E._Lancaster By_the_River oil 25.75~_x__36.25~ vintage_gold_period_wood_frame c._1900 800 = hooper.jpg = = = =                       
211 Skovgaard,_Joakim_Frederik_(1856-1933) Untitled oil 16.5~_x_18.5~ frame_in_good_condition c._1900 1100 1 skovgaard.jpg = = = =                        
" > data/examp_art

cp data/examp_art data/examp_art.orig


# make a fake _sequences table..
echo "// the examp_institutes and examp_art entries are for quisp demos...
tablename value   
examp_institutes 200
examp_art 300
" > data/_sequences



# make a basic quisp test page..
echo "
<title>quisp test page</title>
<br><br><center><h2>QUISP test page</h2><br><br>
This page shows that quisp executed successfully as a CGI.
<br><br>
#set WHOAMI = \$whoami()
Executing as (user, group): @WHOAMI<br>
<br>
<br>
<br>
<h4>QUISP comes with lots of examples.<br>  
The next step is to copy the example files<br>
from ./qexamples in your QUISP distribution<br>
to the "pages" directory in your project node......<br>
then <a href=\"@CGIPROG?rtn=index\">try them by clicking here</a>.</h4>
" > pages/testpage1

# make an error page..
echo "<title>quisp error</title>
<br><br><center>\n#if @_ERRORMESSAGE != \"\" 
  <h3>Error: @_ERRORMESSAGE</h3>
#endif
<a href=\"@CGIPROG?rtn=testpage1\">Back to test page 1</a>
" > pages/errorpage


# load some textchunks for the demo...

echo "An exquisitely detailed marine watercolor painting on canvas of the SS Repton 
(an American admiral). It is signed (and possibly dated) on the lower left, but 
the signature is indecipherable. Unusual in a watercolor, the colors are very 
intense with no fading. It is in almost perfect condition (one small repair on 
reverse of the canvas) behind glass in its magnificent gilded and wood wide 
concave frame." > textchunks/examp_art/204

echo "a spectacular original oil on stretched canvas by listed English artist Trevor 
Haddon. Created with emotion and subtle colors, the work is infused with light 
and feelings of poetic allegories. Haddons work is executed with a glamorous 
style, this work being a perfect example of this. The piece is in excellent 
condition and is signed by the artist. The piece was exhibited in London in 
1883 and has the import inventory tag and #1252 on the back. It is museum 
quality mounted in a vintage hand carved and gilt frame. Certificate of 
authenticity and appraised value is included." > textchunks/examp_art/205 

echo "This an original oil on canvas by listed Austrian artist Franz Von Persoglia. 
Signed on the lower right hand side. Circa 1890, this painting is precisely 
what Persoglia is known for. This work is executed with wonderful detail, a 
color palette of the time and a realistic approach. It is in mint condition 
with no in painting or repairs. It has recently been professionally cleaned and 
varnished. It is museum mounted and custom framed in a gold leaf framed. The 
frame is also in excellent condition. (Note the frame is not guaranteed). 
Certificate of authenticity and certified appraisal are included." > textchunks/examp_art/206

echo "Lomax, John Arthur ROI RBA (1857 - 1923)
 John Arthur Lomax was a Manchester born genre painter. He studied painting in 
Stuttgart and the Munich Academy but returned to Manchester and later relocated 
to London. His subjects were mostly historical of the 17th and 18th Century, 
especially of the civil war period, and often with a dramatic or sentimental 
theme. Lomax was a regular exhibitor at Suffolk Street and also at the Royal 
Academy from 1880.

This auction is for a wonderful antique painting 'Repairing the doll' by 
A.J.Lomax. It is oil on canvas, 25,3\" x 30\" without the frame. The artwork is 
signed and dated 1880 lower right. Condition of the painting is very good, no 
tears or halls, no visible restoration. Frame is in a good condition as well.  " > textchunks/examp_art/207

echo "The painting represents a well-fed clergy man in his chair smoking an after 
dinner cigar. There is a humorous twist to this fine painting and the happy 
face of the man is very skillfully painted. The work is painted in a vintage 
style, though with visible brushstrokes and shows high quality. A very 
attractive work in a beautiful period frame. Artist:  Signed \"N. Grtzner\". 
Unidentified likely Austrian artist. Possibly connected to the well-known 
artist Eduard von Grtzner known for burlesque scenes with clergymen. A painting 
by E.Grtzner was sold at Carola van Ham in Cologne on 30 October 1999 for 
$91,681. " > textchunks/examp_art/208


echo "German A. Faure dated 1917.  The Circus Family.
Amadeus Faure, German.
1874 Hambourg- Stuttgart 1931.

Scene in a circus, the artists have a rest. 
Fantastic monumental oil painting, signed lower right Faure and dated (19)17. 
Brilliant colours and a outstanding carsima. 
Oil on canvas. 
Canvas size 41.3\" x 48.9\" 
Original frame." > textchunks/examp_art/209
 

echo "Original high quality oil painting on canvas. A thoroughly made interior 
setting in powerful colors and with expertly executed details. Please disregard 
the light reflections.
ARTIST: Signed \"JS\" in monogram. Joakim Frederik Skovgaard (1856-1933) is a 
listed artist. He was the son of Peter Christian Skovgaard (1817-1875), who 
taught him how to draw. Later he studied under C.C.A. Weber and he went to the 
Kunstakademiet (Academy of Fine Art) in Copenhagen from 1871-76. He also 
studied at Bonnats School in Paris for three months. Besides Paris he traveled 
to Germany, Greece, Norway, Java and had a number of longer stays in Italy. 
Joakim Skovgaards early landscapes were clearly dependent on his father. But 
after his stay at Bonnats School, a change in his style began. He finally broke 
free from his fathers influence during his stay in Italy 1882-84 where he 
colouristicly became impressionistic influenced by Theodor Philipsen and Rmy 
Cogger. He received a number of prizes, e.g. the Sdring Prize in 1879 and also a 
prize from the Academy in 1886. Joakim Skovgaard has exhibited at 
Charlottenborg and Den Frie Udstilling (the Free Exhibition) for several years, 
at Kunstnerforeningen (the Artist Society), at Nordisk Kunst Udstilling (the 
Nordic Art Exhibition) and a number of posthumous exhibitions. He has also 
exhibited widely internationally; Among others in London, Paris, Munich, Malm 
and at the World Exhibition in Paris 1889,1900 and 1925. He is represented at 
Statens Museum for Kunst (the Danish National Gallery), Den Hirschsprungske 
Samling and at the Art museums in Aarhus, Funen and Bornholm. Price example: He 
sold \"The Return from the Shoot\" (1886-88) for $17,880 at Christie's, London in 
March 1994 (Lot 215, 33 1/4\" by 49 1/6\"). " > textchunks/examp_art/211



echo "
Project directory created.  Please review the subdirectories and 'config' file.

For command line use, environment variable SHSQL_DB should be set to:
$DBDIR

"



exit 0
