/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferProxy;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.support.SimpleProtocolDecoderOutput;
import org.apache.mina.filter.codec.support.SimpleProtocolEncoderOutput;
import org.apache.mina.util.SessionLog;

public class ProtocolCodecFilter
extends IoFilterAdapter {
    public static final String ENCODER = ProtocolCodecFilter.class.getName() + ".encoder";
    public static final String DECODER = ProtocolCodecFilter.class.getName() + ".decoder";
    private static final String DECODER_LOCK = ProtocolCodecFilter.class.getName() + ".decoderLock";
    private static final Class[] EMPTY_PARAMS = new Class[0];
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final ProtocolCodecFactory factory;

    public ProtocolCodecFilter(ProtocolCodecFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }

    public ProtocolCodecFilter(final ProtocolEncoder encoder, final ProtocolDecoder decoder) {
        if (encoder == null) {
            throw new NullPointerException("encoder");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder");
        }
        this.factory = new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder() {
                return encoder;
            }

            public ProtocolDecoder getDecoder() {
                return decoder;
            }
        };
    }

    public ProtocolCodecFilter(final Class encoderClass, final Class decoderClass) {
        if (encoderClass == null) {
            throw new NullPointerException("encoderClass");
        }
        if (decoderClass == null) {
            throw new NullPointerException("decoderClass");
        }
        if (!ProtocolEncoder.class.isAssignableFrom(encoderClass)) {
            throw new IllegalArgumentException("encoderClass: " + encoderClass.getName());
        }
        if (!ProtocolDecoder.class.isAssignableFrom(decoderClass)) {
            throw new IllegalArgumentException("decoderClass: " + decoderClass.getName());
        }
        try {
            encoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("encoderClass doesn't have a public default constructor.");
        }
        try {
            decoderClass.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("decoderClass doesn't have a public default constructor.");
        }
        this.factory = new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder() throws Exception {
                return (ProtocolEncoder)encoderClass.newInstance();
            }

            public ProtocolDecoder getDecoder() throws Exception {
                return (ProtocolDecoder)decoderClass.newInstance();
            }
        };
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(ProtocolCodecFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one ProtocolCodecFilter.");
        }
    }

    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        this.disposeEncoder(parent.getSession());
        this.disposeDecoder(parent.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!(message instanceof ByteBuffer)) {
            nextFilter.messageReceived(session, message);
            return;
        }
        ByteBuffer in = (ByteBuffer)message;
        ProtocolDecoder decoder = this.getDecoder(session);
        Object decoderLock = this.getDecoderLock(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        try {
            Object object = decoderLock;
            synchronized (object) {
                decoder.decode(session, in, decoderOut);
            }
        }
        catch (Throwable t) {
            ProtocolDecoderException pde = t instanceof ProtocolDecoderException ? (ProtocolDecoderException)t : new ProtocolDecoderException(t);
            pde.setHexdump(in.getHexDump());
            throw pde;
        }
        finally {
            if (session.getTransportType().isConnectionless()) {
                this.disposeDecoder(session);
            }
            in.release();
            decoderOut.flush();
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (message instanceof HiddenByteBuffer) {
            return;
        }
        if (!(message instanceof MessageByteBuffer)) {
            nextFilter.messageSent(session, message);
            return;
        }
        nextFilter.messageSent(session, ((MessageByteBuffer)message).message);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (message instanceof ByteBuffer) {
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        ProtocolEncoder encoder = this.getEncoder(session);
        ProtocolEncoderOutputImpl encoderOut = this.getEncoderOut(session, nextFilter, writeRequest);
        try {
            encoder.encode(session, message, encoderOut);
            encoderOut.flush();
            nextFilter.filterWrite(session, new IoFilter.WriteRequest(new MessageByteBuffer(writeRequest.getMessage()), writeRequest.getFuture(), writeRequest.getDestination()));
        }
        catch (Throwable t) {
            ProtocolEncoderException pee = t instanceof ProtocolEncoderException ? (ProtocolEncoderException)t : new ProtocolEncoderException(t);
            throw pee;
        }
        finally {
            if (session.getTransportType().isConnectionless()) {
                this.disposeEncoder(session);
            }
        }
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        ProtocolDecoder decoder = this.getDecoder(session);
        ProtocolDecoderOutput decoderOut = this.getDecoderOut(session, nextFilter);
        try {
            decoder.finishDecode(session, decoderOut);
        }
        catch (Throwable t) {
            ProtocolDecoderException pde = t instanceof ProtocolDecoderException ? (ProtocolDecoderException)t : new ProtocolDecoderException(t);
            throw pde;
        }
        finally {
            this.disposeEncoder(session);
            this.disposeDecoder(session);
            decoderOut.flush();
        }
        nextFilter.sessionClosed(session);
    }

    private ProtocolEncoder getEncoder(IoSession session) throws Exception {
        ProtocolEncoder encoder = (ProtocolEncoder)session.getAttribute(ENCODER);
        if (encoder == null) {
            encoder = this.factory.getEncoder();
            session.setAttribute(ENCODER, encoder);
        }
        return encoder;
    }

    private Object getDecoderLock(IoSession session) {
        Object lock = session.getAttribute(DECODER_LOCK);
        if (lock == null) {
            lock = new Object();
            session.setAttribute(DECODER_LOCK, lock);
        }
        return lock;
    }

    private ProtocolEncoderOutputImpl getEncoderOut(IoSession session, IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
        return new ProtocolEncoderOutputImpl(session, nextFilter, writeRequest);
    }

    private ProtocolDecoder getDecoder(IoSession session) throws Exception {
        ProtocolDecoder decoder = (ProtocolDecoder)session.getAttribute(DECODER);
        if (decoder == null) {
            decoder = this.factory.getDecoder();
            session.setAttribute(DECODER, decoder);
        }
        return decoder;
    }

    private ProtocolDecoderOutput getDecoderOut(IoSession session, IoFilter.NextFilter nextFilter) {
        return new SimpleProtocolDecoderOutput(session, nextFilter);
    }

    private void disposeEncoder(IoSession session) {
        ProtocolEncoder encoder = (ProtocolEncoder)session.removeAttribute(ENCODER);
        if (encoder == null) {
            return;
        }
        try {
            encoder.dispose(session);
        }
        catch (Throwable t) {
            SessionLog.warn(session, "Failed to dispose: " + encoder.getClass().getName() + " (" + encoder + ')');
        }
    }

    private void disposeDecoder(IoSession session) {
        ProtocolDecoder decoder = (ProtocolDecoder)session.removeAttribute(DECODER);
        if (decoder == null) {
            return;
        }
        try {
            decoder.dispose(session);
        }
        catch (Throwable t) {
            SessionLog.warn(session, "Falied to dispose: " + decoder.getClass().getName() + " (" + decoder + ')');
        }
    }

    private static class ProtocolEncoderOutputImpl
    extends SimpleProtocolEncoderOutput {
        private final IoSession session;
        private final IoFilter.NextFilter nextFilter;
        private final IoFilter.WriteRequest writeRequest;

        public ProtocolEncoderOutputImpl(IoSession session, IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
            this.session = session;
            this.nextFilter = nextFilter;
            this.writeRequest = writeRequest;
        }

        protected WriteFuture doFlush(ByteBuffer buf) {
            DefaultWriteFuture future = new DefaultWriteFuture(this.session);
            this.nextFilter.filterWrite(this.session, new IoFilter.WriteRequest(new HiddenByteBuffer(buf), future, this.writeRequest.getDestination()));
            return future;
        }
    }

    private static class MessageByteBuffer
    extends ByteBufferProxy {
        private final Object message;

        private MessageByteBuffer(Object message) {
            super(EMPTY_BUFFER);
            this.message = message;
        }

        public void acquire() {
        }

        public void release() {
        }
    }

    private static class HiddenByteBuffer
    extends ByteBufferProxy {
        private HiddenByteBuffer(ByteBuffer buf) {
            super(buf);
        }
    }
}

