/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.executor.ExecutorFilter;

public class ExecutorThreadModel
implements ThreadModel {
    private static final Map service2model = new HashMap();
    private final String threadNamePrefix;
    private final ExecutorFilter defaultFilter;
    private ExecutorFilter filter = new ExecutorFilter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorThreadModel getInstance(String serviceName) {
        ExecutorThreadModel model;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        Map map = service2model;
        synchronized (map) {
            model = (ExecutorThreadModel)service2model.get(serviceName);
            if (model == null) {
                model = new ExecutorThreadModel(serviceName);
                service2model.put(serviceName, model);
            }
        }
        return model;
    }

    private ExecutorThreadModel(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        this.defaultFilter = new ExecutorFilter();
        ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.defaultFilter.getExecutor();
        final ThreadFactory originalThreadFactory = tpe.getThreadFactory();
        ThreadFactory newThreadFactory = new ThreadFactory(){
            private final AtomicInteger threadId = new AtomicInteger(0);

            public Thread newThread(Runnable runnable) {
                Thread t = originalThreadFactory.newThread(runnable);
                t.setName(ExecutorThreadModel.this.threadNamePrefix + '-' + this.threadId.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        };
        tpe.setThreadFactory(newThreadFactory);
        this.setExecutor(null);
    }

    public Executor getExecutor() {
        return this.filter.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.filter = executor == null ? this.defaultFilter : new ExecutorFilter(executor);
    }

    public void buildFilterChain(IoFilterChain chain) throws Exception {
        chain.addFirst(ExecutorThreadModel.class.getName(), this.filter);
    }
}

