/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.quickfixj.CharsetSupport;
import quickfix.AbstractLog;
import quickfix.FileUtil;
import quickfix.LogUtil;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.field.converter.UtcTimestampConverter;

public class FileLog
extends AbstractLog {
    private static final byte[] TIME_STAMP_DELIMETER;
    private SessionID sessionID;
    private String messagesFileName;
    private String eventFileName;
    private boolean syncAfterWrite;
    private FileOutputStream messages;
    private FileOutputStream events;
    private boolean includeMillis;
    private boolean includeTimestampForMessages;

    FileLog(String path, SessionID sessionID, boolean includeMillis, boolean includeTimestampForMessages, boolean logHeartbeats) throws FileNotFoundException {
        this.sessionID = sessionID;
        String sessionName = FileUtil.sessionIdFileName(sessionID);
        this.setLogHeartbeats(logHeartbeats);
        String prefix = FileUtil.fileAppendPath(path, sessionName + ".");
        this.messagesFileName = prefix + "messages.log";
        this.eventFileName = prefix + "event.log";
        File directory = new File(this.messagesFileName).getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.includeMillis = includeMillis;
        this.includeTimestampForMessages = includeTimestampForMessages;
        this.openLogStreams(true);
    }

    private void openLogStreams(boolean append) throws FileNotFoundException {
        this.messages = new FileOutputStream(this.messagesFileName, append);
        this.events = new FileOutputStream(this.eventFileName, append);
    }

    protected void logIncoming(String message) {
        this.writeMessage(this.messages, message, false);
    }

    protected void logOutgoing(String message) {
        this.writeMessage(this.messages, message, false);
    }

    private synchronized void writeMessage(FileOutputStream stream, String message, boolean forceTimestamp) {
        try {
            if (forceTimestamp || this.includeTimestampForMessages) {
                this.writeTimeStamp(stream);
            }
            stream.write(message.getBytes(CharsetSupport.getCharset()));
            stream.write(10);
            stream.flush();
            if (this.syncAfterWrite) {
                stream.getFD().sync();
            }
        }
        catch (IOException e) {
            LogUtil.logThrowable(this.sessionID, "error writing message to log", (Throwable)e);
        }
    }

    public void onEvent(String message) {
        this.writeMessage(this.events, message, true);
    }

    private void writeTimeStamp(OutputStream out) throws IOException {
        String formattedTime = UtcTimestampConverter.convert(SystemTime.getDate(), this.includeMillis);
        out.write(formattedTime.getBytes(CharsetSupport.getCharset()));
        out.write(TIME_STAMP_DELIMETER);
    }

    String getEventFileName() {
        return this.eventFileName;
    }

    String getMessagesFileName() {
        return this.messagesFileName;
    }

    public void setSyncAfterWrite(boolean syncAfterWrite) {
        this.syncAfterWrite = syncAfterWrite;
    }

    public void closeFiles() throws IOException {
        this.messages.close();
        this.events.close();
    }

    public void clear() {
        try {
            this.closeFiles();
            this.openLogStreams(false);
        }
        catch (IOException e) {
            System.err.println("Could not clear log: " + this.getClass().getName());
        }
    }

    static {
        try {
            TIME_STAMP_DELIMETER = ": ".getBytes(CharsetSupport.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

