/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import quickfix.ConfigError;

public class DayConverter {
    public static int toInteger(String dayName) throws ConfigError {
        String[] dayNames = new DateFormatSymbols(Locale.getDefault()).getWeekdays();
        dayName = dayName.toLowerCase();
        for (int i = 1; i < dayNames.length; ++i) {
            if (!dayNames[i].toLowerCase().startsWith(dayName)) continue;
            return i;
        }
        throw new ConfigError("invalid format for day (valid values: " + Arrays.asList(dayNames).subList(1, dayNames.length) + " or prefix); actual value was '" + dayName + "'");
    }

    public static String toString(int dayOffset) throws ConfigError {
        String[] dayNames = new DateFormatSymbols(Locale.getDefault()).getWeekdays();
        if (dayOffset > 0 && dayOffset < dayNames.length) {
            return dayNames[dayOffset].toLowerCase();
        }
        throw new ConfigError("invalid offset for day: " + dayOffset);
    }
}

