/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.lang._Character;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.lang._Integer;
import quickfix.BooleanField;
import quickfix.BytesField;
import quickfix.CharField;
import quickfix.DecimalField;
import quickfix.DoubleField;
import quickfix.Field;
import quickfix.FieldConvertError;
import quickfix.FieldException;
import quickfix.FieldNotFound;
import quickfix.Group;
import quickfix.IntField;
import quickfix.MessageComponent;
import quickfix.RuntimeError;
import quickfix.StringField;
import quickfix.UtcDateOnlyField;
import quickfix.UtcTimeOnlyField;
import quickfix.UtcTimeStampField;
import quickfix.field.converter.BooleanConverter;
import quickfix.field.converter.CharConverter;
import quickfix.field.converter.DecimalConverter;
import quickfix.field.converter.DoubleConverter;
import quickfix.field.converter.IntConverter;
import quickfix.field.converter.UtcDateOnlyConverter;
import quickfix.field.converter.UtcTimeOnlyConverter;
import quickfix.field.converter.UtcTimestampConverter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldMap
implements Serializable {
    static final long serialVersionUID = -3193357271891865972L;
    private final int[] fieldOrder;
    private final TreeMap<Integer, Field<?>> fields;
    private final TreeMap<Integer, List<Group>> groups = new TreeMap();

    protected FieldMap(int[] fieldOrder) {
        this.fieldOrder = fieldOrder;
        this.fields = new TreeMap(fieldOrder != null ? new FieldOrderComparator() : null);
    }

    protected FieldMap() {
        this(null);
    }

    public int[] getFieldOrder() {
        return this.fieldOrder;
    }

    public void clear() {
        this.fields.clear();
        this.groups.clear();
    }

    public boolean isEmpty() {
        return this.fields.size() == 0;
    }

    public void setFields(FieldMap fieldMap) {
        this.fields.clear();
        this.fields.putAll(fieldMap.fields);
    }

    protected void setComponent(MessageComponent component) {
        component.copyTo(this);
    }

    protected void getComponent(MessageComponent component) {
        component.clear();
        component.copyFrom(this);
    }

    public void setGroups(FieldMap fieldMap) {
        this.groups.clear();
        this.groups.putAll(fieldMap.groups);
    }

    protected void setGroups(int key, List<Group> groupList) {
        this.groups.put(_Integer.valueOf(key), groupList);
    }

    public void setString(int field, String value) {
        this.setField(new StringField(field, value));
    }

    public void setBytes(int field, byte[] value) {
        this.setField(field, new BytesField(field, value));
    }

    public void setBoolean(int field, boolean value) {
        String s = BooleanConverter.convert(value);
        this.setField(new StringField(field, s));
    }

    public void setChar(int field, char value) {
        String s = CharConverter.convert(value);
        this.setField(new StringField(field, s));
    }

    public void setInt(int field, int value) {
        String s = IntConverter.convert(value);
        this.setField(new StringField(field, s));
    }

    public void setDouble(int field, double value) {
        this.setDouble(field, value, 0);
    }

    public void setDouble(int field, double value, int padding) {
        String s = DoubleConverter.convert(value, padding);
        this.setField(new StringField(field, s));
    }

    public void setDecimal(int field, BigDecimal value) {
        this.setField(new StringField(field, DecimalConverter.convert(value)));
    }

    public void setDecimal(int field, BigDecimal value, int padding) {
        String s = DecimalConverter.convert(value, padding);
        this.setField(new StringField(field, s));
    }

    public void setUtcTimeStamp(int field, Date value) {
        this.setUtcTimeStamp(field, value, false);
    }

    public void setUtcTimeStamp(int field, Date value, boolean includeMilliseconds) {
        String s = UtcTimestampConverter.convert(value, includeMilliseconds);
        this.setField(new StringField(field, s));
    }

    public void setUtcTimeOnly(int field, Date value) {
        this.setUtcTimeOnly(field, value, false);
    }

    public void setUtcTimeOnly(int field, Date value, boolean includeMillseconds) {
        String s = UtcTimeOnlyConverter.convert(value, includeMillseconds);
        this.setField(new StringField(field, s));
    }

    public void setUtcDateOnly(int field, Date value) {
        String s = UtcDateOnlyConverter.convert(value);
        this.setField(new StringField(field, s));
    }

    public String getString(int field) throws FieldNotFound {
        return (String)this.getField(field).getObject();
    }

    StringField getField(int field) throws FieldNotFound {
        StringField f = (StringField)this.fields.get(_Integer.valueOf(field));
        if (f == null) {
            throw new FieldNotFound(field);
        }
        return f;
    }

    Field<?> getField(int field, Field<?> defaultValue) {
        Field<?> f = this.fields.get(_Integer.valueOf(field));
        if (f == null) {
            return defaultValue;
        }
        return f;
    }

    public boolean getBoolean(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return BooleanConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public char getChar(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return CharConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public int getInt(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return IntConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public double getDouble(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return DoubleConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public BigDecimal getDecimal(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return DecimalConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public Date getUtcTimeStamp(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return UtcTimestampConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public Date getUtcTimeOnly(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return UtcTimeOnlyConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public Date getUtcDateOnly(int field) throws FieldNotFound {
        String value = this.getField(field).getValue();
        try {
            return UtcDateOnlyConverter.convert(value);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    protected void setField(int key, Field<?> field) {
        this.fields.put(_Integer.valueOf(key), field);
    }

    public void setField(StringField field) {
        if (field.getValue() == null) {
            throw new NullPointerException("Null field values are not allowed.");
        }
        this.fields.put(_Integer.valueOf(field.getField()), field);
    }

    public void setField(BooleanField field) {
        this.setBoolean(field.getField(), field.getValue());
    }

    public void setField(CharField field) {
        this.setChar(field.getField(), field.getValue());
    }

    public void setField(IntField field) {
        this.setInt(field.getField(), field.getValue());
    }

    public void setField(DoubleField field) {
        this.setDouble(field.getField(), field.getValue());
    }

    public void setField(DecimalField field) {
        this.setDecimal(field.getField(), field.getValue());
    }

    public void setField(UtcTimeStampField field) {
        this.setUtcTimeStamp(field.getField(), field.getValue(), field.showMilliseconds());
    }

    public void setField(UtcTimeOnlyField field) {
        this.setUtcTimeOnly(field.getField(), field.getValue(), field.showMilliseconds());
    }

    public void setField(UtcDateOnlyField field) {
        this.setUtcDateOnly(field.getField(), field.getValue());
    }

    public void setField(BytesField field) {
        this.setBytes(field.getField(), (byte[])field.getObject());
    }

    public StringField getField(StringField field) throws FieldNotFound {
        return (StringField)this.getFieldInternal(field);
    }

    private Field<String> getFieldInternal(Field<String> field) throws FieldNotFound {
        field.setObject((String)this.getField(field.getField()).getObject());
        return field;
    }

    public BytesField getField(BytesField field) throws FieldNotFound {
        Field<?> returnField = this.fields.get(_Integer.valueOf(field.getField()));
        if (returnField == null) {
            throw new FieldNotFound(field.getField());
        }
        if (!(returnField instanceof BytesField)) {
            throw new FieldException(6, field.getField());
        }
        return (BytesField)returnField;
    }

    public BooleanField getField(BooleanField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(BooleanConverter.convert(value));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public CharField getField(CharField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(_Character.valueOf(CharConverter.convert(value)));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public IntField getField(IntField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(_Integer.valueOf(IntConverter.convert(value)));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public DoubleField getField(DoubleField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(new Double(DoubleConverter.convert(value)));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public DecimalField getField(DecimalField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(DecimalConverter.convert(value));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public UtcTimeStampField getField(UtcTimeStampField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(UtcTimestampConverter.convert(value));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public UtcTimeOnlyField getField(UtcTimeOnlyField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(UtcTimeOnlyConverter.convert(value));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    public UtcDateOnlyField getField(UtcDateOnlyField field) throws FieldNotFound {
        try {
            String value = this.getField(field.getField()).getValue();
            field.setObject(UtcDateOnlyConverter.convert(value));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field.getField());
        }
        catch (FieldNotFound e) {
            throw e;
        }
        return field;
    }

    private FieldException newIncorrectDataException(FieldConvertError e, int tag) {
        return new FieldException(6, e.getMessage(), tag);
    }

    public boolean isSetField(int field) {
        return this.fields.containsKey(_Integer.valueOf(field));
    }

    public boolean isSetField(Field<?> field) {
        return this.isSetField(field.getField());
    }

    public void removeField(int field) {
        this.fields.remove(_Integer.valueOf(field));
    }

    public Iterator<Field<?>> iterator() {
        return this.fields.values().iterator();
    }

    protected void initializeFrom(FieldMap source) {
        this.fields.clear();
        this.fields.putAll(source.fields);
        for (Map.Entry<Integer, List<Group>> entry : source.groups.entrySet()) {
            ArrayList<Group> clonedMembers = new ArrayList<Group>();
            List<Group> groupMembers = entry.getValue();
            for (int i = 0; i < groupMembers.size(); ++i) {
                Group originalGroup = groupMembers.get(i);
                Group clonedGroup = new Group(originalGroup.getFieldTag(), originalGroup.delim(), originalGroup.getFieldOrder());
                clonedGroup.initializeFrom(originalGroup);
                clonedMembers.add(clonedGroup);
            }
            this.groups.put(entry.getKey(), clonedMembers);
        }
    }

    private boolean isGroupField(int field) {
        return this.groups.containsKey(_Integer.valueOf(field));
    }

    protected void calculateString(StringBuffer buffer, int[] preFields, int[] postFields) {
        List<Group> groups;
        if (preFields != null) {
            for (int i = 0; i < preFields.length; ++i) {
                Field<?> field = this.getField(preFields[i], null);
                if (field == null) continue;
                field.toString(buffer);
                buffer.append('\u0001');
            }
        }
        for (Field<?> field : this.fields.values()) {
            int tag = field.getField();
            if (!(this.isOrderedField(tag, preFields) || this.isOrderedField(tag, postFields) || this.isGroupField(tag))) {
                field.toString(buffer);
                buffer.append('\u0001');
                continue;
            }
            if (!this.isGroupField(tag) || !this.isOrderedField(tag, this.fieldOrder) || this.getGroupCount(tag) <= 0) continue;
            groups = this.getGroups(tag);
            field.toString(buffer);
            buffer.append('\u0001');
            for (int i = 0; i < groups.size(); ++i) {
                FieldMap groupFields = groups.get(i);
                groupFields.calculateString(buffer, preFields, postFields);
            }
        }
        for (Map.Entry entry : this.groups.entrySet()) {
            Integer groupCountTag = (Integer)entry.getKey();
            if (this.isOrderedField(groupCountTag, this.fieldOrder)) continue;
            groups = (List<Group>)entry.getValue();
            IntField countField = new IntField((int)groupCountTag, groups.size());
            countField.toString(buffer);
            buffer.append('\u0001');
            for (int i = 0; i < groups.size(); ++i) {
                FieldMap groupFields = groups.get(i);
                groupFields.calculateString(buffer, preFields, postFields);
            }
        }
        if (postFields != null) {
            for (int i = 0; i < postFields.length; ++i) {
                Field<?> field = this.getField(postFields[i], null);
                field.toString(buffer);
                buffer.append('\u0001');
            }
        }
    }

    private boolean isOrderedField(int field, int[] afieldOrder) {
        if (afieldOrder != null) {
            for (int i = 0; i < afieldOrder.length; ++i) {
                if (field != afieldOrder[i]) continue;
                return true;
            }
        }
        return false;
    }

    int calculateLength() {
        int result = 0;
        int length = 0;
        for (Field<?> field : this.fields.values()) {
            if (field.getField() == 8 || field.getField() == 9 || field.getField() == 10 || this.isGroupField(field.getField())) continue;
            length = field.getLength();
            result += length;
        }
        for (Map.Entry<Integer, List<Group>> entry : this.groups.entrySet()) {
            List<Group> groupList = entry.getValue();
            IntField groupField = new IntField(entry.getKey());
            groupField.setValue(groupList.size());
            length = groupField.getLength();
            result += length;
            for (int i = 0; i < groupList.size(); ++i) {
                Group group = groupList.get(i);
                length = group.calculateLength();
                result += length;
            }
        }
        return result;
    }

    int calculateTotal() {
        int result = 0;
        for (Field<?> field : this.fields.values()) {
            if (field.getField() == 10 || this.isGroupField(field.getField())) continue;
            result += field.getTotal();
        }
        for (Map.Entry<Integer, List<Group>> entry : this.groups.entrySet()) {
            List<Group> groupList = entry.getValue();
            IntField groupField = new IntField(entry.getKey());
            groupField.setValue(groupList.size());
            result += groupField.getTotal();
            for (int i = 0; i < groupList.size(); ++i) {
                Group group = groupList.get(i);
                result += group.calculateTotal();
            }
        }
        return result;
    }

    public int getGroupCount(int tag) {
        return this.getGroups(tag).size();
    }

    public Iterator<Integer> groupKeyIterator() {
        return this.groups.keySet().iterator();
    }

    Map<Integer, List<Group>> getGroups() {
        return this.groups;
    }

    public void addGroup(Group group) {
        int countTag = group.getFieldTag();
        List<Group> currentGroups = this.getGroups(countTag);
        currentGroups.add(new Group(group));
        this.setGroupCount(countTag, currentGroups.size());
    }

    protected void setGroupCount(int countTag, int groupSize) {
        if (groupSize == 0) {
            return;
        }
        try {
            StringField count;
            if (groupSize == 1) {
                count = new StringField(countTag, "1");
                this.setField(countTag, count);
            } else {
                count = this.getField(countTag);
            }
            count.setValue(Integer.toString(groupSize));
        }
        catch (FieldNotFound e) {
            throw new RuntimeError(e);
        }
    }

    public List<Group> getGroups(int field) {
        List<Group> groupList = this.groups.get(_Integer.valueOf(field));
        if (groupList == null) {
            groupList = new ArrayList<Group>();
            this.groups.put(_Integer.valueOf(field), groupList);
        }
        return groupList;
    }

    public Group getGroup(int num, Group group) throws FieldNotFound {
        List<Group> groupList = this.getGroups(group.getFieldTag());
        if (num > groupList.size()) {
            throw new FieldNotFound(new StringBuffer().append(group.getFieldTag()).append(", index=").append(num).toString());
        }
        group.setFields(groupList.get(num - 1));
        group.setGroups(groupList.get(num - 1));
        return group;
    }

    public void replaceGroup(int num, Group group) {
        int offset = num - 1;
        List<Group> groupList = this.getGroups(group.getFieldTag());
        if (offset < 0 || offset >= groupList.size()) {
            return;
        }
        groupList.set(offset, new Group(group));
    }

    public void removeGroup(int field) {
        this.getGroups(field).clear();
        this.removeField(field);
    }

    public void removeGroup(int num, int field) {
        List<Group> groupList = this.getGroups(field);
        if (num <= groupList.size()) {
            groupList.remove(num - 1);
        }
        this.setGroupCount(field, groupList.size());
    }

    public void removeGroup(int num, Group group) {
        this.removeGroup(num, group.getFieldTag());
    }

    public void removeGroup(Group group) {
        this.removeGroup(group.getFieldTag());
    }

    public boolean hasGroup(int field) {
        return this.groups.containsKey(_Integer.valueOf(field));
    }

    public boolean hasGroup(int num, int field) {
        return this.hasGroup(field) && num <= this.getGroups(field).size();
    }

    public boolean hasGroup(int num, Group group) {
        return this.hasGroup(num, group.getFieldTag());
    }

    public boolean hasGroup(Group group) {
        return this.hasGroup(group.getFieldTag());
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldOrderComparator
    implements Comparator<Integer>,
    Serializable {
        static final long serialVersionUID = 3416006398018829270L;

        private FieldOrderComparator() {
        }

        @Override
        public int compare(Integer tag1, Integer tag2) {
            int index1 = this.indexOf(tag1, FieldMap.this.getFieldOrder());
            int index2 = this.indexOf(tag2, FieldMap.this.getFieldOrder());
            if (index1 != Integer.MAX_VALUE && index2 != Integer.MAX_VALUE) {
                return index1 != index2 ? (index1 < index2 ? -1 : 1) : 0;
            }
            if (index1 == Integer.MAX_VALUE || index2 == Integer.MAX_VALUE) {
                if (index1 != index2) {
                    return index1 == Integer.MAX_VALUE ? 1 : -1;
                }
                return tag1.intValue() != tag2.intValue() ? (tag1 < tag2 ? -1 : 1) : 0;
            }
            return tag1.intValue() != tag2.intValue() ? (tag1 < tag2 ? -1 : 1) : 0;
        }

        private int indexOf(int tag, int[] order) {
            if (order != null) {
                for (int i = 0; i < order.length; ++i) {
                    if (tag != order[i]) continue;
                    return i;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((Integer)x0, (Integer)x1);
        }
    }
}

