/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.utilint.DbLsn;

public class RecoveryInfo {
    public long lastUsedLsn = -1L;
    public long nextAvailableLsn = -1L;
    public long firstActiveLsn = -1L;
    public long checkpointStartLsn = -1L;
    public long checkpointEndLsn = -1L;
    public long useRootLsn = -1L;
    public long partialCheckpointStartLsn = -1L;
    public CheckpointEnd checkpointEnd;
    public long useMaxNodeId;
    public int useMaxDbId;
    public long useMaxTxnId;
    public int numMapINs;
    public int numOtherINs;
    public int numBinDeltas;
    public int numDuplicateINs;
    public int lnFound;
    public int lnNotFound;
    public int lnInserted;
    public int lnReplaced;
    public int nRepeatIteratorReads;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Recovery Info");
        this.appendLsn(sb, " lastUsed=", this.lastUsedLsn);
        this.appendLsn(sb, " nextAvail=", this.nextAvailableLsn);
        this.appendLsn(sb, " ckptStart=", this.checkpointStartLsn);
        this.appendLsn(sb, " firstActive=", this.firstActiveLsn);
        this.appendLsn(sb, " ckptEnd=", this.checkpointEndLsn);
        this.appendLsn(sb, " useRoot=", this.useRootLsn);
        sb.append(" ckptEnd=<").append(this.checkpointEnd).append(">");
        sb.append(" useMaxNodeId=").append(this.useMaxNodeId);
        sb.append(" useMaxDbId=").append(this.useMaxDbId);
        sb.append(" useMaxTxnId=").append(this.useMaxTxnId);
        sb.append(" numMapINs=").append(this.numMapINs);
        sb.append(" numOtherINs=").append(this.numOtherINs);
        sb.append(" numBinDeltas=").append(this.numBinDeltas);
        sb.append(" numDuplicateINs=").append(this.numDuplicateINs);
        sb.append(" lnFound=").append(this.lnFound);
        sb.append(" lnNotFound=").append(this.lnNotFound);
        sb.append(" lnInserted=").append(this.lnInserted);
        sb.append(" lnReplaced=").append(this.lnReplaced);
        sb.append(" nRepeatIteratorReads=").append(this.nRepeatIteratorReads);
        return sb.toString();
    }

    private void appendLsn(StringBuffer sb, String name, long lsn) {
        if (lsn != -1L) {
            sb.append(name).append(DbLsn.getNoFormatString(lsn));
        }
    }
}

