/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.OperationStatus;
import java.util.Comparator;
import java.util.SortedMap;

public class StoredSortedMap
extends StoredMap
implements SortedMap {
    public StoredSortedMap(Database database, EntryBinding keyBinding, EntryBinding valueBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, valueBinding, null, writeAllowed, null));
    }

    public StoredSortedMap(Database database, EntryBinding keyBinding, EntryBinding valueBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, valueBinding, null, true, keyAssigner));
    }

    public StoredSortedMap(Database database, EntryBinding keyBinding, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, writeAllowed, null));
    }

    public StoredSortedMap(Database database, EntryBinding keyBinding, EntityBinding valueEntityBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, true, keyAssigner));
    }

    StoredSortedMap(DataView mapView) {
        super(mapView);
    }

    public Comparator comparator() {
        return null;
    }

    public Object firstKey() {
        return this.getFirstOrLastKey(true);
    }

    public Object lastKey() {
        return this.getFirstOrLastKey(false);
    }

    private Object getFirstOrLastKey(boolean doGetFirst) {
        Object object;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = doGetFirst ? cursor.getFirst(false) : cursor.getLast(false);
            object = status == OperationStatus.SUCCESS ? cursor.getCurrentKey() : null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return object;
    }

    public SortedMap headMap(Object toKey) {
        return this.subMap(null, false, toKey, false);
    }

    public SortedMap headMap(Object toKey, boolean toInclusive) {
        return this.subMap(null, false, toKey, toInclusive);
    }

    public SortedMap tailMap(Object fromKey) {
        return this.subMap(fromKey, true, null, false);
    }

    public SortedMap tailMap(Object fromKey, boolean fromInclusive) {
        return this.subMap(fromKey, fromInclusive, null, false);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public SortedMap subMap(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive) {
        try {
            return new StoredSortedMap(this.view.subView(fromKey, fromInclusive, toKey, toInclusive, null));
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }
}

