/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.mbean.session;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.quickfixj.jmx.mbean.session.SessionAdminMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.SessionStateListener;
import quickfix.field.MsgType;
import quickfix.field.NewSeqNo;
import quickfix.field.converter.UtcTimestampConverter;

public class SessionAdmin
extends NotificationBroadcasterSupport
implements SessionAdminMBean,
MBeanRegistration,
SessionStateListener {
    private static final String NOTIFICATION_TYPE = "quickfix.Session";
    private final Session session;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectName connectorName;
    private MBeanServer mbeanServer;

    public SessionAdmin(Session session, ObjectName connnectorName) {
        this.session = session;
        this.connectorName = connnectorName;
    }

    public String getID() {
        return this.session.getSessionID().toString();
    }

    public String getTargetCompID() {
        return this.session.getSessionID().getTargetCompID();
    }

    public String getTargetSubID() {
        return this.session.getSessionID().getTargetSubID();
    }

    public String getTargetLocationID() {
        return this.session.getSessionID().getTargetLocationID();
    }

    public String getSenderCompID() {
        return this.session.getSessionID().getSenderCompID();
    }

    public String getSenderSubID() {
        return this.session.getSessionID().getSenderSubID();
    }

    public String getSenderLocationID() {
        return this.session.getSessionID().getSenderLocationID();
    }

    public String getBeginString() {
        return this.session.getSessionID().getBeginString();
    }

    public boolean isLoggedOn() {
        return this.session.isLoggedOn();
    }

    public String getRemoteIPAddress() {
        if (this.session.getResponder() != null) {
            return this.session.getResponder().getRemoteIPAddress();
        }
        return "";
    }

    public void reset() throws IOException {
        this.logInvocation("reset");
        this.session.reset();
    }

    public int getNextSenderMsgSeqNum() throws IOException {
        return this.session.getExpectedSenderNum();
    }

    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.logAttributeChange("NextSenderMsgSeqNum", next);
        this.session.setNextSenderMsgSeqNum(next);
    }

    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.logAttributeChange("NextTargetMsgSeqNum", next);
        this.session.setNextTargetMsgSeqNum(next);
    }

    public int getNextTargetMsgSeqNum() throws IOException {
        return this.session.getExpectedTargetNum();
    }

    public String[] getMessages(int startSequence, int endSequence) throws IOException {
        ArrayList<String> messages = new ArrayList<String>();
        this.session.getStore().get(startSequence, endSequence, messages);
        return messages.toArray(new String[messages.size()]);
    }

    public void disconnect() throws IOException {
        this.logInvocation("disconnect");
        this.session.disconnect();
    }

    public void resetSequence(int nextSeqNum) throws SessionNotFound {
        this.logInvocation("resetSequence to: " + nextSeqNum);
        Message sequenceReset = new Message();
        sequenceReset.getHeader().setField(new MsgType("4"));
        sequenceReset.setField(new NewSeqNo(nextSeqNum));
        this.doSend(sequenceReset, this.session.getSessionID());
    }

    protected void doSend(Message message, SessionID sessionID) throws SessionNotFound {
        Session.sendToTarget(message, sessionID);
    }

    public void logon() {
        this.logInvocation("logon");
        this.session.logon();
    }

    public void logoff() {
        this.logInvocation("logout");
        this.session.logout();
    }

    public boolean isReconnectEnabled() {
        return this.session.isEnabled();
    }

    public String getHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            this.log.error(uhe.getMessage(), (Throwable)uhe);
            return "N/A";
        }
    }

    public String getProcessID() {
        return System.getProperty("java.pid");
    }

    public ObjectName getConnectorName() {
        return this.connectorName;
    }

    public boolean getCheckCompID() {
        return this.session.getCheckCompID();
    }

    public String getLogClassName() {
        return this.session.getLog().getClass().getName();
    }

    public int getLogonTimeout() {
        return this.session.getLogonTimeout();
    }

    public int getLogoutTimeout() {
        return this.session.getLogoutTimeout();
    }

    public String getMessageFactoryClassName() {
        return this.session.getMessageFactory().getClass().getName();
    }

    public String getMessageStoreClassName() {
        return this.session.getStore().getClass().getName();
    }

    public boolean getRedundantResendRequestsAllowed() {
        return this.session.getRedundantResentRequestsAllowed();
    }

    public boolean getRefreshOnLogon() {
        return this.session.getRefreshOnLogon();
    }

    public boolean getResetOnDisconnect() {
        return this.session.getResetOnDisconnect();
    }

    public boolean getResetOnLogout() {
        return this.session.getResetOnLogout();
    }

    public boolean isLogonAlreadySent() {
        return this.session.isLogonAlreadySent();
    }

    public boolean isLogonReceived() {
        return this.session.isLogonReceived();
    }

    public boolean isLogonSendNeeded() {
        return this.session.isLogonSendNeeded();
    }

    public boolean isLogonSent() {
        return this.session.isLogonSent();
    }

    public boolean isLogonTimedOut() {
        return this.session.isLogonTimedOut();
    }

    public boolean isLogoutReceived() {
        return this.session.isLogoutReceived();
    }

    public boolean isLogoutSent() {
        return this.session.isLogoutSent();
    }

    public boolean isLogoutTimedOut() {
        return this.session.isLogoutTimedOut();
    }

    public void setLogonTimeout(int seconds) {
        this.logAttributeChange("LogonTimeout", seconds);
        this.session.setLogonTimeout(seconds);
    }

    public void setLogoutTimeout(int seconds) {
        this.logAttributeChange("LogoutTimeout", seconds);
        this.session.setLogoutTimeout(seconds);
    }

    public boolean isUsingDataDictionary() {
        return this.session.isUsingDataDictionary();
    }

    public String getSessionID() {
        return this.session.getSessionID().toString();
    }

    public boolean getEnabled() {
        return this.session.isEnabled();
    }

    public String getStartTime() {
        try {
            return UtcTimestampConverter.convert(this.session.getStartTime(), true);
        }
        catch (IOException e) {
            return "[ERROR]";
        }
    }

    public String getConnectionRole() {
        try {
            return this.mbeanServer.getAttribute(this.connectorName, "Role").toString();
        }
        catch (Exception e) {
            return "[ERROR: " + e.getMessage() + "]";
        }
    }

    private void logAttributeChange(String attributeName, int value) {
        this.session.getLog().onEvent("JMX: setting " + attributeName + " to " + value);
    }

    private void logInvocation(String operation) {
        this.session.getLog().onEvent("JMX: " + operation + " invoked");
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        return name;
    }

    public void onConnect() {
        this.sendNotification("connect");
    }

    public void onDisconnect() {
        this.sendNotification("disconnect");
    }

    public void onLogon() {
        this.sendNotification("logon");
    }

    public void onLogout() {
        this.sendNotification("logout");
    }

    public void onHeartBeatTimeout() {
        this.sendNotification("heartBeatTimeout");
    }

    public void onMissedHeartBeat() {
        this.sendNotification("missedHeartBeat");
    }

    public void onRefresh() {
        this.sendNotification("refresh");
    }

    public void onReset() {
        this.sendNotification("reset");
    }

    private void sendNotification(String eventName) {
        Notification notification = new Notification(NOTIFICATION_TYPE, this, -1L, System.currentTimeMillis(), eventName);
        this.sendNotification(notification);
    }
}

