/*
 * applications.h - the Qucs application list
 *
 * Copyright (C) 2005-2011 Stefan Jahn <stefan@lkcc.org>
 * Copyright (C) 2006 Gunther Kraut <gn.kraut@t-online.de>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * $Id$
 *
 */

#ifndef __APPLICATIONS_H__
#define __APPLICATIONS_H__

// Array containing all kinds of applications.
struct application_t qucs::eqn::applications[] = {
  { "+", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "+", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "+", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "+", TAG_MATRIX,  NULL, 1, { TAG_MATRIX  } },
  { "+", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "+", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "+", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "+", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "+", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "+", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_DOUBLE  } },
  { "+", TAG_VECTOR,  NULL, 2, { TAG_DOUBLE,  TAG_VECTOR  } },
  { "+", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_COMPLEX } },
  { "+", TAG_VECTOR,  NULL, 2, { TAG_COMPLEX, TAG_VECTOR  } },
  { "+", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_VECTOR  } },
  { "+", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_MATRIX  } },
  { "+", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_DOUBLE  } },
  { "+", TAG_MATRIX,  NULL, 2, { TAG_DOUBLE,  TAG_MATRIX  } },
  { "+", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_COMPLEX } },
  { "+", TAG_MATRIX,  NULL, 2, { TAG_COMPLEX, TAG_MATRIX  } },
  { "+", TAG_STRING,  NULL, 2, { TAG_STRING,  TAG_STRING  } },
  { "+", TAG_STRING,  NULL, 2, { TAG_CHAR,    TAG_STRING  } },
  { "+", TAG_STRING,  NULL, 2, { TAG_STRING,  TAG_CHAR    } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_MATVEC,TAG_MATVEC  } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_MATRIX  } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_MATRIX, TAG_MATVEC  } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_DOUBLE  } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_DOUBLE, TAG_MATVEC  } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_COMPLEX,TAG_MATVEC  } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_VECTOR  } },
  { "+", TAG_MATVEC,  NULL, 2, { TAG_VECTOR, TAG_MATVEC  } },

  { "-", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "-", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "-", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "-", TAG_MATRIX,  NULL, 1, { TAG_MATRIX  } },
  { "-", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "-", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "-", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "-", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "-", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "-", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_DOUBLE  } },
  { "-", TAG_VECTOR,  NULL, 2, { TAG_DOUBLE,  TAG_VECTOR  } },
  { "-", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_COMPLEX } },
  { "-", TAG_VECTOR,  NULL, 2, { TAG_COMPLEX, TAG_VECTOR  } },
  { "-", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_VECTOR  } },
  { "-", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_MATRIX  } },
  { "-", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_DOUBLE  } },
  { "-", TAG_MATRIX,  NULL, 2, { TAG_DOUBLE,  TAG_MATRIX  } },
  { "-", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_COMPLEX } },
  { "-", TAG_MATRIX,  NULL, 2, { TAG_COMPLEX, TAG_MATRIX  } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_MATVEC,TAG_MATVEC  } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_MATRIX  } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_MATRIX, TAG_MATVEC  } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_DOUBLE  } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_DOUBLE, TAG_MATVEC  } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_COMPLEX,TAG_MATVEC  } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_VECTOR  } },
  { "-", TAG_MATVEC,  NULL, 2, { TAG_VECTOR, TAG_MATVEC  } },

  { "*", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "*", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "*", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "*", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "*", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_DOUBLE  } },
  { "*", TAG_VECTOR,  NULL, 2, { TAG_DOUBLE,  TAG_VECTOR  } },
  { "*", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_COMPLEX } },
  { "*", TAG_VECTOR,  NULL, 2, { TAG_COMPLEX, TAG_VECTOR  } },
  { "*", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_VECTOR  } },
  { "*", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_MATRIX  } },
  { "*", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_COMPLEX } },
  { "*", TAG_MATRIX,  NULL, 2, { TAG_COMPLEX, TAG_MATRIX  } },
  { "*", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_DOUBLE  } },
  { "*", TAG_MATRIX,  NULL, 2, { TAG_DOUBLE,  TAG_MATRIX  } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_MATVEC,TAG_MATVEC  } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_MATRIX  } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_MATRIX, TAG_MATVEC  } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_COMPLEX,TAG_MATVEC  } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_DOUBLE  } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_DOUBLE, TAG_MATVEC  } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_VECTOR  } },
  { "*", TAG_MATVEC,  NULL, 2, { TAG_VECTOR, TAG_MATVEC  } },

  { "/", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "/", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "/", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "/", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "/", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_DOUBLE  } },
  { "/", TAG_VECTOR,  NULL, 2, { TAG_DOUBLE,  TAG_VECTOR  } },
  { "/", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_COMPLEX } },
  { "/", TAG_VECTOR,  NULL, 2, { TAG_COMPLEX, TAG_VECTOR  } },
  { "/", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_VECTOR  } },
  { "/", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_COMPLEX } },
  { "/", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_DOUBLE  } },
  { "/", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "/", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_DOUBLE  } },
  { "/", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_VECTOR  } },

  { "%", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "%", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "%", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "%", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "%", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_DOUBLE  } },
  { "%", TAG_VECTOR,  NULL, 2, { TAG_DOUBLE,  TAG_VECTOR  } },
  { "%", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_COMPLEX } },
  { "%", TAG_VECTOR,  NULL, 2, { TAG_COMPLEX, TAG_VECTOR  } },
  { "%", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_VECTOR  } },

  { "^", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "^", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "^", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "^", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "^", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_DOUBLE  } },
  { "^", TAG_VECTOR,  NULL, 2, { TAG_DOUBLE,  TAG_VECTOR  } },
  { "^", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_COMPLEX } },
  { "^", TAG_VECTOR,  NULL, 2, { TAG_COMPLEX, TAG_VECTOR  } },
  { "^", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_VECTOR  } },
  { "^", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_DOUBLE  } },
  { "^", TAG_MATRIX,  NULL, 2, { TAG_MATRIX,  TAG_COMPLEX } },
  { "^", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_DOUBLE  } },
  { "^", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "^", TAG_MATVEC,  NULL, 2, { TAG_MATVEC, TAG_VECTOR  } },

  { "hypot", TAG_DOUBLE,  NULL, 2,
    { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "hypot", TAG_DOUBLE, NULL, 2,
    { TAG_COMPLEX, TAG_COMPLEX } },
  { "hypot", TAG_DOUBLE, NULL, 2,
    { TAG_COMPLEX, TAG_DOUBLE  } },
  { "hypot", TAG_DOUBLE, NULL, 2,
    { TAG_DOUBLE,  TAG_COMPLEX } },
  { "hypot", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_DOUBLE  } },
  { "hypot", TAG_VECTOR,  NULL, 2,
    { TAG_DOUBLE,  TAG_VECTOR  } },
  { "hypot", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_COMPLEX } },
  { "hypot", TAG_VECTOR,  NULL, 2,
    { TAG_COMPLEX, TAG_VECTOR  } },
  { "hypot", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_VECTOR  } },

  { "real", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "real", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "real", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "real", TAG_MATRIX,  NULL, 1, { TAG_MATRIX  } },
  { "real", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "imag", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "imag", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "imag", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "imag", TAG_MATRIX,  NULL, 1, { TAG_MATRIX  } },
  { "imag", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "abs", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "abs", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "abs", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "abs", TAG_MATRIX,  NULL, 1, { TAG_MATRIX  } },
  { "abs", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "mag", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "mag", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "mag", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "mag", TAG_MATRIX,  NULL, 1, { TAG_MATRIX  } },
  { "mag", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "conj", TAG_DOUBLE,  NULL,  1, { TAG_DOUBLE  } },
  { "conj", TAG_COMPLEX, NULL,  1, { TAG_COMPLEX } },
  { "conj", TAG_VECTOR,  NULL,  1, { TAG_VECTOR  } },
  { "conj", TAG_MATRIX,  NULL,  1, { TAG_MATRIX  } },
  { "conj", TAG_MATVEC,  NULL, 1, { TAG_MATVEC  } },

  { "norm", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "norm", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "norm", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "phase", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "phase", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "phase", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "phase", TAG_MATRIX,  NULL,  1, { TAG_MATRIX } },
  { "phase", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "angle", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "angle", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "angle", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "angle", TAG_MATRIX,  NULL,  1, { TAG_MATRIX } },
  { "angle", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "arg", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arg", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "arg", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "arg", TAG_MATRIX,  NULL,  1, { TAG_MATRIX } },
  { "arg", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },

  { "unwrap", TAG_VECTOR,  NULL, 1,
    { TAG_VECTOR  } },
  { "unwrap", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR, TAG_DOUBLE } },
  { "unwrap", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_DOUBLE, TAG_DOUBLE } },

  { "deg2rad", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "deg2rad", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "deg2rad", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },
  { "rad2deg", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "rad2deg", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "rad2deg", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "dB", TAG_DOUBLE, NULL,  1, { TAG_DOUBLE  } },
  { "dB", TAG_DOUBLE, NULL,  1, { TAG_COMPLEX } },
  { "dB", TAG_VECTOR, NULL,  1, { TAG_VECTOR  } },
  { "dB", TAG_MATRIX, NULL,  1, { TAG_MATRIX  } },
  { "dB", TAG_MATVEC, NULL, 1, { TAG_MATVEC  } },

  { "sqrt", TAG_COMPLEX, NULL, 1, { TAG_DOUBLE } },
  { "sqrt", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "sqrt", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "exp", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "exp", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "exp", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "limexp", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "limexp", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "limexp", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "ln", TAG_COMPLEX, NULL, 1, { TAG_DOUBLE  } },
  { "ln", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "ln", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "log10", TAG_COMPLEX, NULL, 1, { TAG_DOUBLE  } },
  { "log10", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "log10", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "log2", TAG_COMPLEX, NULL, 1, { TAG_DOUBLE  } },
  { "log2", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "log2", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "sin", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "sin", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "sin", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arcsin", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arcsin", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arcsin", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "cos", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "cos", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "cos", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arccos", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arccos", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arccos", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "tan", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "tan", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "tan", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arctan", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arctan", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arctan", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "cot", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "cot", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "cot", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arccot", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arccot", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arccot", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "sec", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "sec", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "sec", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arcsec", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arcsec", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arcsec", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "cosec", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "cosec", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "cosec", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arccosec", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arccosec", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arccosec", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "sinh", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "sinh", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "sinh", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arsinh", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arsinh", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arsinh", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "cosh", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "cosh", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "cosh", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arcosh", TAG_COMPLEX, NULL, 1, { TAG_DOUBLE  } },
  { "arcosh", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arcosh", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "tanh", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "tanh", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "tanh", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "artanh", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "artanh", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "artanh", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "coth", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "coth", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "coth", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arcoth", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arcoth", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arcoth", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "sech", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "sech", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "sech", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arsech", TAG_COMPLEX, NULL, 1, { TAG_DOUBLE  } },
  { "arsech", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arsech", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "cosech", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "cosech", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "cosech", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "arcosech", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "arcosech", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "arcosech", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "ztor", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE } },
  { "ztor", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE, TAG_DOUBLE } },
  { "ztor", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE, TAG_COMPLEX } },
  { "ztor", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "ztor", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE } },
  { "ztor", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "ztor", TAG_VECTOR,  NULL, 1, { TAG_VECTOR } },
  { "ztor", TAG_VECTOR,  NULL, 2, { TAG_VECTOR, TAG_DOUBLE } },
  { "ztor", TAG_VECTOR,  NULL, 2, { TAG_VECTOR, TAG_COMPLEX } },

  { "rtoz", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE } },
  { "rtoz", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE, TAG_DOUBLE } },
  { "rtoz", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE, TAG_COMPLEX } },
  { "rtoz", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "rtoz", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE } },
  { "rtoz", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "rtoz", TAG_VECTOR,  NULL, 1, { TAG_VECTOR } },
  { "rtoz", TAG_VECTOR,  NULL, 2, { TAG_VECTOR, TAG_DOUBLE } },
  { "rtoz", TAG_VECTOR,  NULL, 2, { TAG_VECTOR, TAG_COMPLEX } },

  { "ytor", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE } },
  { "ytor", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE, TAG_DOUBLE } },
  { "ytor", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE, TAG_COMPLEX } },
  { "ytor", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "ytor", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE } },
  { "ytor", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "ytor", TAG_VECTOR,  NULL, 1, { TAG_VECTOR } },
  { "ytor", TAG_VECTOR,  NULL, 2, { TAG_VECTOR, TAG_DOUBLE } },
  { "ytor", TAG_VECTOR,  NULL, 2, { TAG_VECTOR, TAG_COMPLEX } },

  { "rtoy", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE } },
  { "rtoy", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE, TAG_DOUBLE } },
  { "rtoy", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE, TAG_COMPLEX } },
  { "rtoy", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "rtoy", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE } },
  { "rtoy", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "rtoy", TAG_VECTOR,  NULL, 1, { TAG_VECTOR } },
  { "rtoy", TAG_VECTOR,  NULL, 2, { TAG_VECTOR, TAG_DOUBLE } },
  { "rtoy", TAG_VECTOR,  NULL, 2, { TAG_VECTOR, TAG_COMPLEX } },

  { "rtoswr", TAG_DOUBLE, NULL, 1, { TAG_DOUBLE  } },
  { "rtoswr", TAG_DOUBLE, NULL, 1, { TAG_COMPLEX } },
  { "rtoswr", TAG_VECTOR, NULL, 1, { TAG_VECTOR  } },

  { "diff", TAG_VECTOR, NULL, 2, { TAG_VECTOR, TAG_VECTOR } },
  { "diff", TAG_VECTOR, NULL, 3, { TAG_VECTOR, TAG_VECTOR,
						 TAG_DOUBLE } },

  { "max", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "max", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "max", TAG_DOUBLE,  NULL, 1, { TAG_VECTOR  } },
  { "max", TAG_DOUBLE,  NULL, 2, { TAG_VECTOR, TAG_RANGE } },

  { "max", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "max", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "max", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "max", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },

  { "min", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "min", TAG_DOUBLE,  NULL, 1, { TAG_COMPLEX } },
  { "min", TAG_DOUBLE,  NULL, 1, { TAG_VECTOR  } },
  { "min", TAG_DOUBLE,  NULL, 2, { TAG_VECTOR, TAG_RANGE } },

  { "min", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "min", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "min", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "min", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },

  { "sum", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "sum", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "sum", TAG_COMPLEX, NULL, 1, { TAG_VECTOR  } },

  { "prod", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "prod", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "prod", TAG_COMPLEX, NULL, 1, { TAG_VECTOR  } },

  { "avg", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "avg", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "avg", TAG_COMPLEX, NULL, 1, { TAG_VECTOR  } },
  { "avg", TAG_COMPLEX, NULL, 2, { TAG_VECTOR, TAG_RANGE } },

  { "length", TAG_DOUBLE, NULL,  1, { TAG_DOUBLE  } },
  { "length", TAG_DOUBLE, NULL,  1, { TAG_COMPLEX } },
  { "length", TAG_DOUBLE, NULL,  1, { TAG_VECTOR  } },
  { "length", TAG_DOUBLE, NULL,  1, { TAG_MATRIX  } },
  { "length", TAG_DOUBLE, NULL, 1, { TAG_MATVEC  } },

  { "array", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_DOUBLE, TAG_DOUBLE } },
  { "array", TAG_MATRIX, NULL, 2,
    { TAG_MATVEC, TAG_DOUBLE } },
  { "array", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR, TAG_DOUBLE | TAG_RANGE } },
  { "array", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_DOUBLE | TAG_RANGE, TAG_DOUBLE | TAG_RANGE } },
  { "array", TAG_COMPLEX, NULL, 3,
    { TAG_MATRIX, TAG_DOUBLE, TAG_DOUBLE } },
  { "array", TAG_CHAR, NULL, 2, { TAG_STRING, TAG_DOUBLE } },

  { "stos", TAG_MATRIX, NULL,   2, { TAG_MATRIX, TAG_DOUBLE } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_DOUBLE,
						   TAG_DOUBLE } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_DOUBLE,
						   TAG_COMPLEX } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_DOUBLE,
						   TAG_VECTOR } },
  { "stos", TAG_MATRIX, NULL,   2, { TAG_MATRIX, TAG_COMPLEX } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_COMPLEX,
						   TAG_DOUBLE } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_COMPLEX,
						   TAG_COMPLEX } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_COMPLEX,
						   TAG_VECTOR } },
  { "stos", TAG_MATRIX, NULL,   2, { TAG_MATRIX, TAG_VECTOR } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_VECTOR,
						   TAG_DOUBLE } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_VECTOR,
						   TAG_COMPLEX } },
  { "stos", TAG_MATRIX, NULL, 3, { TAG_MATRIX, TAG_VECTOR,
						   TAG_VECTOR } },

  { "stos", TAG_MATVEC, NULL,   2, { TAG_MATVEC, TAG_DOUBLE } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_DOUBLE,
						    TAG_DOUBLE } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_DOUBLE,
						    TAG_COMPLEX } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_DOUBLE,
						    TAG_VECTOR } },
  { "stos", TAG_MATVEC, NULL,   2, { TAG_MATVEC,
						    TAG_COMPLEX } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_COMPLEX,
						    TAG_DOUBLE } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_COMPLEX,
						    TAG_COMPLEX } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_COMPLEX,
						    TAG_VECTOR } },
  { "stos", TAG_MATVEC, NULL,   2, { TAG_MATVEC, TAG_VECTOR } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_VECTOR,
						    TAG_DOUBLE } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_VECTOR,
						    TAG_COMPLEX } },
  { "stos", TAG_MATVEC, NULL, 3, { TAG_MATVEC, TAG_VECTOR,
						    TAG_VECTOR } },

  { "stoy", TAG_MATRIX, NULL, 1, { TAG_MATRIX } },
  { "stoy", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_DOUBLE } },
  { "stoy", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_COMPLEX } },
  { "stoy", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_VECTOR } },
  { "stoy", TAG_MATVEC, NULL, 1, { TAG_MATVEC } },
  { "stoy", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_DOUBLE } },
  { "stoy", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "stoy", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_VECTOR } },

  { "stoz", TAG_MATRIX, NULL, 1, { TAG_MATRIX } },
  { "stoz", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_DOUBLE } },
  { "stoz", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_COMPLEX } },
  { "stoz", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_VECTOR } },
  { "stoz", TAG_MATVEC, NULL, 1, { TAG_MATVEC } },
  { "stoz", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_DOUBLE } },
  { "stoz", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "stoz", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_VECTOR } },

  { "ytos", TAG_MATRIX, NULL,  1, { TAG_MATRIX } },
  { "ytos", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_DOUBLE } },
  { "ytos", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_COMPLEX } },
  { "ytos", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_VECTOR } },
  { "ytos", TAG_MATVEC, NULL, 1, { TAG_MATVEC } },
  { "ytos", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_DOUBLE } },
  { "ytos", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "ytos", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_VECTOR } },

  { "ztos", TAG_MATRIX, NULL,  1, { TAG_MATRIX } },
  { "ztos", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_DOUBLE } },
  { "ztos", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_COMPLEX } },
  { "ztos", TAG_MATRIX, NULL, 2, { TAG_MATRIX, TAG_VECTOR } },
  { "ztos", TAG_MATVEC, NULL, 1, { TAG_MATVEC } },
  { "ztos", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_DOUBLE } },
  { "ztos", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_COMPLEX } },
  { "ztos", TAG_MATVEC, NULL, 2, { TAG_MATVEC, TAG_VECTOR } },

  { "ytoz", TAG_MATRIX, NULL,  1, { TAG_MATRIX } },
  { "ytoz", TAG_MATVEC, NULL, 1, { TAG_MATVEC } },
  { "ztoy", TAG_MATRIX, NULL,  1, { TAG_MATRIX } },
  { "ztoy", TAG_MATVEC, NULL, 1, { TAG_MATVEC } },

  { "twoport", TAG_MATRIX, NULL,  3,
    { TAG_MATRIX, TAG_CHAR, TAG_CHAR } },
  { "twoport", TAG_MATVEC, NULL, 3,
    { TAG_MATVEC, TAG_CHAR, TAG_CHAR } },

  { "inverse",   TAG_MATRIX,  NULL,    1, { TAG_MATRIX } },
  { "inverse",   TAG_MATVEC,  NULL,   1, { TAG_MATVEC } },
  { "transpose", TAG_MATRIX,  NULL,  1, { TAG_MATRIX } },
  { "transpose", TAG_MATVEC,  NULL, 1, { TAG_MATVEC } },
  { "det",       TAG_COMPLEX, NULL,        1, { TAG_MATRIX } },
  { "det",       TAG_VECTOR,  NULL,       1, { TAG_MATVEC } },
  { "eye",       TAG_MATRIX,  NULL,        1, { TAG_DOUBLE } },
  { "adjoint",   TAG_MATRIX,  NULL,    1, { TAG_MATRIX } },
  { "adjoint",   TAG_MATVEC,  NULL,   1, { TAG_MATVEC } },

  { "signum", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "signum", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "signum", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "sign", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "sign", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "sign", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "sinc", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "sinc", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "sinc", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "Rollet", TAG_DOUBLE,  NULL,  1, { TAG_MATRIX } },
  { "Rollet", TAG_VECTOR,  NULL, 1, { TAG_MATVEC } },
  { "Mu",     TAG_DOUBLE,  NULL,     1, { TAG_MATRIX } },
  { "Mu",     TAG_VECTOR,  NULL,    1, { TAG_MATVEC } },
  { "Mu2",    TAG_DOUBLE,  NULL,     1, { TAG_MATRIX } },
  { "Mu2",    TAG_VECTOR,  NULL,    1, { TAG_MATVEC } },
  { "StabFactor",  TAG_DOUBLE,  NULL,  1, { TAG_MATRIX } },
  { "StabFactor",  TAG_VECTOR,  NULL, 1, { TAG_MATVEC } },
  { "StabMeasure", TAG_DOUBLE,  NULL,      1, { TAG_MATRIX } },
  { "StabMeasure", TAG_VECTOR,  NULL,     1, { TAG_MATVEC } },

  { "linspace", TAG_VECTOR, NULL, 3,
    { TAG_DOUBLE, TAG_DOUBLE, TAG_DOUBLE } },
  { "logspace", TAG_VECTOR, NULL, 3,
    { TAG_DOUBLE, TAG_DOUBLE, TAG_DOUBLE } },
  { "NoiseCircle", TAG_VECTOR, NULL, 5,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_DOUBLE, TAG_VECTOR } },
  { "NoiseCircle", TAG_VECTOR, NULL, 5,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_DOUBLE, TAG_DOUBLE } },
  { "NoiseCircle", TAG_VECTOR, NULL, 4,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_DOUBLE } },
  { "NoiseCircle", TAG_VECTOR, NULL, 5,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR } },
  { "NoiseCircle", TAG_VECTOR, NULL, 5,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_DOUBLE } },
  { "NoiseCircle", TAG_VECTOR, NULL, 4,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR } },
  { "StabCircleL", TAG_VECTOR, NULL, 2,
    { TAG_MATVEC, TAG_VECTOR } },
  { "StabCircleL", TAG_VECTOR, NULL, 2,
    { TAG_MATVEC, TAG_DOUBLE } },
  { "StabCircleL", TAG_VECTOR, NULL, 1, { TAG_MATVEC } },
  { "StabCircleS", TAG_VECTOR, NULL, 2,
    { TAG_MATVEC, TAG_VECTOR } },
  { "StabCircleS", TAG_VECTOR, NULL, 2,
    { TAG_MATVEC, TAG_DOUBLE } },
  { "StabCircleS", TAG_VECTOR, NULL, 1, { TAG_MATVEC } },
  { "GaCircle", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_DOUBLE, TAG_VECTOR } },
  { "GaCircle", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_DOUBLE, TAG_DOUBLE } },
  { "GaCircle", TAG_VECTOR, NULL, 2,
    { TAG_MATVEC, TAG_DOUBLE } },
  { "GaCircle", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_VECTOR, TAG_VECTOR } },
  { "GaCircle", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_VECTOR, TAG_DOUBLE } },
  { "GaCircle", TAG_VECTOR, NULL, 2,
    { TAG_MATVEC, TAG_VECTOR } },
  { "GpCircle", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_DOUBLE, TAG_VECTOR } },
  { "GpCircle", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_DOUBLE, TAG_DOUBLE } },
  { "GpCircle", TAG_VECTOR, NULL, 2,
    { TAG_MATVEC, TAG_DOUBLE } },
  { "GpCircle", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_VECTOR, TAG_VECTOR } },
  { "GpCircle", TAG_VECTOR, NULL, 3,
    { TAG_MATVEC, TAG_VECTOR, TAG_DOUBLE } },
  { "GpCircle", TAG_VECTOR, NULL, 2,
    { TAG_MATVEC, TAG_VECTOR } },
  { "PlotVs", TAG_VECTOR, NULL, 2,
    { TAG_VECTOR, TAG_VECTOR } },
  { "PlotVs", TAG_VECTOR, NULL, 3,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR } },
  { "PlotVs", TAG_VECTOR, NULL, 4,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR } },
  { "PlotVs", TAG_VECTOR, NULL, 5,
    { TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR } },
  { "PlotVs", TAG_MATVEC, NULL, 2,
    { TAG_MATVEC, TAG_VECTOR } },
  { "PlotVs", TAG_MATVEC, NULL, 3,
    { TAG_MATVEC, TAG_VECTOR, TAG_VECTOR } },
  { "PlotVs", TAG_MATVEC, NULL, 4,
    { TAG_MATVEC, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR } },
  { "PlotVs", TAG_MATVEC, NULL, 5,
    { TAG_MATVEC, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR, TAG_VECTOR } },

  { "interpolate", TAG_VECTOR, NULL, 3,
    { TAG_VECTOR, TAG_VECTOR, TAG_DOUBLE } },
  { "interpolate", TAG_VECTOR, NULL, 2,
    { TAG_VECTOR, TAG_VECTOR } },

  { "fft",  TAG_VECTOR, NULL,  1, { TAG_VECTOR } },
  { "ifft", TAG_VECTOR, NULL, 1, { TAG_VECTOR } },
  { "dft",  TAG_VECTOR, NULL,  1, { TAG_VECTOR } },
  { "idft", TAG_VECTOR, NULL, 1, { TAG_VECTOR } },

  { "Time2Freq", TAG_VECTOR, NULL, 2,
    { TAG_VECTOR, TAG_VECTOR } },
  { "Freq2Time", TAG_VECTOR, NULL, 2,
    { TAG_VECTOR, TAG_VECTOR } },
  { "receiver",  TAG_VECTOR, NULL,  2,
    { TAG_VECTOR, TAG_VECTOR } },
  { "receiver",  TAG_VECTOR, NULL,  3,
    { TAG_VECTOR, TAG_VECTOR, TAG_DOUBLE } },
  { "fftshift",  TAG_VECTOR, NULL, 1, { TAG_VECTOR } },

  { "xvalue", TAG_COMPLEX, NULL, 2,
    { TAG_VECTOR, TAG_DOUBLE } },
  { "xvalue", TAG_COMPLEX, NULL, 2,
    { TAG_VECTOR, TAG_COMPLEX } },
  { "yvalue", TAG_COMPLEX, NULL, 2,
    { TAG_VECTOR, TAG_DOUBLE } },
  { "yvalue", TAG_COMPLEX, NULL, 2,
    { TAG_VECTOR, TAG_COMPLEX } },

  { "range", TAG_RANGE, NULL, 2, { TAG_DOUBLE, TAG_DOUBLE } },
  { "range", TAG_RANGE, NULL, 2, { TAG_CHAR, TAG_DOUBLE } },
  { "range", TAG_RANGE, NULL, 2, { TAG_DOUBLE, TAG_CHAR } },
  { "range", TAG_RANGE, NULL, 2, { TAG_CHAR, TAG_CHAR } },

  { "ceil", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "ceil", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "ceil", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "fix", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "fix", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "fix", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "step", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "step", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "step", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "floor", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "floor", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "floor", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "round", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "round", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "round", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "erf", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "erf", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "erf", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "erfc", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "erfc", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "erfc", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "erfinv", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "erfinv", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "erfinv", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "erfcinv", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "erfcinv", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "erfcinv", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "cumsum", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "cumsum", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "cumsum", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "cumavg", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "cumavg", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "cumavg", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "cumprod", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "cumprod", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "cumprod", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "rms", TAG_DOUBLE, NULL, 1, { TAG_DOUBLE  } },
  { "rms", TAG_DOUBLE, NULL, 1, { TAG_COMPLEX } },
  { "rms", TAG_DOUBLE, NULL, 1, { TAG_VECTOR  } },

  { "variance", TAG_DOUBLE, NULL, 1, { TAG_DOUBLE  } },
  { "variance", TAG_DOUBLE, NULL, 1, { TAG_COMPLEX } },
  { "variance", TAG_DOUBLE, NULL, 1, { TAG_VECTOR  } },

  { "stddev", TAG_DOUBLE, NULL, 1, { TAG_DOUBLE  } },
  { "stddev", TAG_DOUBLE, NULL, 1, { TAG_COMPLEX } },
  { "stddev", TAG_DOUBLE, NULL, 1, { TAG_VECTOR  } },

  { "besseli0", TAG_DOUBLE,  NULL,  1, { TAG_DOUBLE  } },
  { "besseli0", TAG_COMPLEX, NULL,  1, { TAG_COMPLEX } },
  { "besseli0", TAG_VECTOR,  NULL,  1, { TAG_VECTOR  } },

  { "besselj", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE, TAG_DOUBLE  } },
  { "besselj", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE, TAG_COMPLEX } },
  { "besselj", TAG_VECTOR,  NULL, 2, { TAG_DOUBLE, TAG_VECTOR  } },
  { "bessely", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE, TAG_DOUBLE  } },
  { "bessely", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE, TAG_COMPLEX } },
  { "bessely", TAG_VECTOR,  NULL, 2, { TAG_DOUBLE, TAG_VECTOR  } },

  { "sqr", TAG_DOUBLE,  NULL,  1, { TAG_DOUBLE  } },
  { "sqr", TAG_COMPLEX, NULL,  1, { TAG_COMPLEX } },
  { "sqr", TAG_VECTOR,  NULL,  1, { TAG_VECTOR  } },
  { "sqr", TAG_MATRIX,  NULL,  1, { TAG_MATRIX  } },
  { "sqr", TAG_MATVEC,  NULL, 1, { TAG_MATVEC  } },

  { "polar", TAG_COMPLEX, NULL, 2,
    { TAG_DOUBLE, TAG_DOUBLE } },
  { "polar", TAG_COMPLEX, NULL, 2,
    { TAG_DOUBLE, TAG_COMPLEX } },
  { "polar", TAG_COMPLEX, NULL, 2,
    { TAG_COMPLEX, TAG_DOUBLE } },
  { "polar", TAG_COMPLEX, NULL, 2,
    { TAG_COMPLEX, TAG_COMPLEX } },
  { "polar", TAG_VECTOR,  NULL, 2,
    { TAG_DOUBLE, TAG_VECTOR } },
  { "polar", TAG_VECTOR,  NULL, 2,
    { TAG_COMPLEX, TAG_VECTOR } },
  { "polar", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR, TAG_DOUBLE } },
  { "polar", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR, TAG_COMPLEX } },
  { "polar", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR, TAG_VECTOR } },

  { "arctan", TAG_COMPLEX, NULL, 2,
    { TAG_DOUBLE, TAG_DOUBLE } },
  { "arctan", TAG_VECTOR,  NULL, 2,
    { TAG_DOUBLE, TAG_VECTOR } },
  { "arctan", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR, TAG_DOUBLE } },
  { "arctan", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR, TAG_VECTOR } },

  { "dbm2w", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "dbm2w", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "dbm2w", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "w2dbm", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "w2dbm", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "w2dbm", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "integrate", TAG_DOUBLE,  NULL, 2,
    { TAG_DOUBLE, TAG_DOUBLE   } },
  { "integrate", TAG_COMPLEX, NULL, 2,
    { TAG_COMPLEX, TAG_COMPLEX } },
  { "integrate", TAG_DOUBLE,  NULL, 2,
    { TAG_VECTOR, TAG_DOUBLE   } },
  { "integrate", TAG_COMPLEX, NULL, 2,
    { TAG_VECTOR, TAG_COMPLEX  } },

  { "dbm", TAG_DOUBLE,  NULL,   1, { TAG_DOUBLE  } },
  { "dbm", TAG_DOUBLE,  NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "dbm", TAG_COMPLEX, NULL,   1, { TAG_COMPLEX } },
  { "dbm", TAG_DOUBLE,  NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "dbm", TAG_VECTOR,  NULL,   1, { TAG_VECTOR  } },
  { "dbm", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_DOUBLE  } },
  { "dbm", TAG_COMPLEX, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "dbm", TAG_COMPLEX, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "dbm", TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_COMPLEX } },

  { "runavg", TAG_VECTOR, NULL, 2,
    { TAG_DOUBLE,  TAG_DOUBLE } },
  { "runavg", TAG_VECTOR, NULL, 2,
    { TAG_COMPLEX, TAG_DOUBLE } },
  { "runavg", TAG_VECTOR, NULL, 2,
    { TAG_VECTOR,  TAG_DOUBLE } },

  { "vt", TAG_DOUBLE,  NULL, 1, { TAG_DOUBLE  } },
  { "vt", TAG_COMPLEX, NULL, 1, { TAG_COMPLEX } },
  { "vt", TAG_VECTOR,  NULL, 1, { TAG_VECTOR  } },

  { "kbd", TAG_VECTOR, NULL, 2, { TAG_DOUBLE, TAG_DOUBLE } },
  { "kbd", TAG_VECTOR, NULL,   1, { TAG_DOUBLE } },

  { "?:", TAG_BOOLEAN, NULL, 3,
    { TAG_BOOLEAN, TAG_BOOLEAN, TAG_BOOLEAN } },
  { "?:", TAG_DOUBLE,  NULL, 3,
    { TAG_BOOLEAN, TAG_DOUBLE,  TAG_DOUBLE } },
  { "?:", TAG_DOUBLE,  NULL, 3,
    { TAG_BOOLEAN, TAG_DOUBLE,  TAG_BOOLEAN } },
  { "?:", TAG_DOUBLE,  NULL, 3,
    { TAG_BOOLEAN, TAG_BOOLEAN, TAG_DOUBLE } },
  { "?:", TAG_COMPLEX, NULL, 3,
    { TAG_BOOLEAN, TAG_DOUBLE,  TAG_COMPLEX } },
  { "?:", TAG_COMPLEX, NULL, 3,
    { TAG_BOOLEAN, TAG_BOOLEAN, TAG_COMPLEX } },
  { "?:", TAG_COMPLEX, NULL, 3,
    { TAG_BOOLEAN, TAG_COMPLEX, TAG_DOUBLE } },
  { "?:", TAG_COMPLEX, NULL, 3,
    { TAG_BOOLEAN, TAG_COMPLEX, TAG_BOOLEAN } },
  { "?:", TAG_COMPLEX, NULL, 3,
    { TAG_BOOLEAN, TAG_COMPLEX, TAG_COMPLEX } },
  { "?:", TAG_MATRIX,  NULL, 3,
    { TAG_BOOLEAN, TAG_MATRIX,  TAG_MATRIX } },
  { "?:", TAG_MATRIX,  NULL, 3,
    { TAG_BOOLEAN, TAG_BOOLEAN, TAG_MATRIX } },
  { "?:", TAG_MATRIX,  NULL, 3,
    { TAG_BOOLEAN, TAG_DOUBLE,  TAG_MATRIX } },
  { "?:", TAG_MATRIX,  NULL, 3,
    { TAG_BOOLEAN, TAG_COMPLEX, TAG_MATRIX } },
  { "?:", TAG_MATRIX,  NULL, 3,
    { TAG_BOOLEAN, TAG_MATRIX,  TAG_BOOLEAN } },
  { "?:", TAG_MATRIX,  NULL, 3,
    { TAG_BOOLEAN, TAG_MATRIX,  TAG_DOUBLE } },
  { "?:", TAG_MATRIX,  NULL, 3,
    { TAG_BOOLEAN, TAG_MATRIX,  TAG_COMPLEX } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_BOOLEAN, TAG_VECTOR,  TAG_VECTOR } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_BOOLEAN, TAG_BOOLEAN, TAG_VECTOR } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_BOOLEAN, TAG_DOUBLE,  TAG_VECTOR } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_BOOLEAN, TAG_COMPLEX, TAG_VECTOR } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_BOOLEAN, TAG_VECTOR,  TAG_BOOLEAN } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_BOOLEAN, TAG_VECTOR,  TAG_DOUBLE } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_BOOLEAN, TAG_VECTOR,  TAG_COMPLEX } },

  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_VECTOR,  TAG_VECTOR } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_BOOLEAN, TAG_VECTOR } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_DOUBLE,  TAG_VECTOR } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_COMPLEX, TAG_VECTOR } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_BOOLEAN, TAG_BOOLEAN } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_DOUBLE,  TAG_BOOLEAN } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_COMPLEX, TAG_BOOLEAN } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_VECTOR,  TAG_BOOLEAN } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_BOOLEAN, TAG_DOUBLE } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_DOUBLE,  TAG_DOUBLE } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_COMPLEX, TAG_DOUBLE } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_VECTOR,  TAG_DOUBLE } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_BOOLEAN, TAG_COMPLEX } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_DOUBLE,  TAG_COMPLEX } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_COMPLEX, TAG_COMPLEX } },
  { "?:", TAG_VECTOR,  NULL, 3,
    { TAG_VECTOR, TAG_VECTOR,  TAG_COMPLEX } },

  { "<=", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_DOUBLE } },
  { "<=", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE,  TAG_COMPLEX } },
  { "<=", TAG_VECTOR,  NULL, 2,
    { TAG_DOUBLE,  TAG_VECTOR  } },
  { "<=", TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_DOUBLE  } },
  { "<=", TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_COMPLEX } },
  { "<=", TAG_VECTOR,  NULL, 2,
    { TAG_COMPLEX, TAG_VECTOR  } },
  { "<=", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_DOUBLE  } },
  { "<=", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_COMPLEX } },
  { "<=", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_VECTOR  } },

  { ">=", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_DOUBLE } },
  { ">=", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE,  TAG_COMPLEX } },
  { ">=", TAG_VECTOR,  NULL, 2,
    { TAG_DOUBLE,  TAG_VECTOR  } },
  { ">=", TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_DOUBLE  } },
  { ">=", TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_COMPLEX } },
  { ">=", TAG_VECTOR,  NULL, 2,
    { TAG_COMPLEX, TAG_VECTOR  } },
  { ">=", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_DOUBLE  } },
  { ">=", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_COMPLEX } },
  { ">=", TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_VECTOR  } },

  { "<",  TAG_BOOLEAN, NULL, 2, { TAG_DOUBLE,  TAG_DOUBLE  } },
  { "<",  TAG_BOOLEAN, NULL, 2, { TAG_DOUBLE,  TAG_COMPLEX } },
  { "<",  TAG_VECTOR,  NULL, 2, { TAG_DOUBLE,  TAG_VECTOR  } },
  { "<",  TAG_BOOLEAN, NULL, 2, { TAG_COMPLEX, TAG_DOUBLE  } },
  { "<",  TAG_BOOLEAN, NULL, 2, { TAG_COMPLEX, TAG_COMPLEX } },
  { "<",  TAG_VECTOR,  NULL, 2, { TAG_COMPLEX, TAG_VECTOR  } },
  { "<",  TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_DOUBLE  } },
  { "<",  TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_COMPLEX } },
  { "<",  TAG_VECTOR,  NULL, 2, { TAG_VECTOR,  TAG_VECTOR  } },

  { ">",  TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_DOUBLE } },
  { ">",  TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE,  TAG_COMPLEX } },
  { ">",  TAG_VECTOR,  NULL, 2,
    { TAG_DOUBLE,  TAG_VECTOR  } },
  { ">",  TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_DOUBLE  } },
  { ">",  TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_COMPLEX } },
  { ">",  TAG_VECTOR,  NULL, 2,
    { TAG_COMPLEX, TAG_VECTOR  } },
  { ">",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_DOUBLE  } },
  { ">",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_COMPLEX } },
  { ">",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_VECTOR  } },

  { "==", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_DOUBLE } },
  { "==", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_COMPLEX } },
  { "==", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_VECTOR } },
  { "==",  TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_DOUBLE  } },
  { "==",  TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_COMPLEX } },
  { "==",  TAG_VECTOR,  NULL, 2,
    { TAG_COMPLEX, TAG_VECTOR  } },
  { "==",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_DOUBLE  } },
  { "==",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_COMPLEX } },
  { "==",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_VECTOR  } },

  { "!=", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_DOUBLE } },
  { "!=", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_COMPLEX } },
  { "!=", TAG_BOOLEAN, NULL, 2,
    { TAG_DOUBLE, TAG_VECTOR } },
  { "!=",  TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_DOUBLE  } },
  { "!=",  TAG_BOOLEAN, NULL, 2,
    { TAG_COMPLEX, TAG_COMPLEX } },
  { "!=",  TAG_VECTOR,  NULL, 2,
    { TAG_COMPLEX, TAG_VECTOR  } },
  { "!=",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_DOUBLE  } },
  { "!=",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_COMPLEX } },
  { "!=",  TAG_VECTOR,  NULL, 2,
    { TAG_VECTOR,  TAG_VECTOR  } },

  { "!",  TAG_BOOLEAN, NULL, 1,   { TAG_BOOLEAN } },
  { "||", TAG_BOOLEAN, NULL, 2,  { TAG_BOOLEAN, TAG_BOOLEAN } },
  { "&&", TAG_BOOLEAN, NULL, 2, { TAG_BOOLEAN, TAG_BOOLEAN } },
  { "==", TAG_BOOLEAN, NULL, 2,
    { TAG_BOOLEAN, TAG_BOOLEAN } },
  { "!=", TAG_BOOLEAN, NULL, 2,
    { TAG_BOOLEAN, TAG_BOOLEAN } },

  { "random",  TAG_DOUBLE, NULL,    0, { TAG_UNKNOWN } },
  { "srandom", TAG_DOUBLE, NULL, 1, { TAG_DOUBLE  } },

  { "vector", TAG_VECTOR, NULL, -1, { TAG_UNKNOWN } },
  { "matrix", TAG_MATRIX, NULL, -1, { TAG_UNKNOWN } },

  { "assert",  TAG_BOOLEAN, NULL, 1,   { TAG_BOOLEAN } },
  { "assert",  TAG_BOOLEAN, NULL, 1,   { TAG_DOUBLE } },
  { "assert",  TAG_BOOLEAN, NULL, 1,   { TAG_VECTOR } },

  { "bugon",  TAG_BOOLEAN, NULL, 1,   { TAG_BOOLEAN } },
  { "bugon",  TAG_BOOLEAN, NULL, 1,   { TAG_DOUBLE } },
  { "bugon",  TAG_BOOLEAN, NULL, 1,   { TAG_VECTOR } },

  { NULL, 0, NULL, 0, { 0 } /* end of list */ }
};

// Converts a TAG_XXX value into a unique string.
const char * checker::tag2key (int tag) {
  const char * key = "";
  if (tag == TAG_RANGE)
    key = "R";
  else switch (tag & ~TAG_RANGE) {
  case TAG_UNKNOWN:
    key = "U"; break;
  case TAG_DOUBLE:
    key = "D"; break;
  case TAG_DOUBLE|TAG_COMPLEX:
    key = "D"; break;
  case TAG_BOOLEAN:
    key = "B"; break;
  case TAG_COMPLEX:
    key = "C"; break;
  case TAG_VECTOR:
    key = "V"; break;
  case TAG_MATRIX:
    key = "M"; break;
  case TAG_MATVEC:
    key = "MV"; break;
  case TAG_CHAR:
    key = "CHR"; break;
  case TAG_STRING:
    key = "STR"; break;
  }
  return key;
}

#endif /* __APPLICATIONS_H__ */
