/*
 * bsim4v30pMOS.defs.h - device definition header
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 */

#ifndef __bsim4v30pMOS_DEFS_H__
#define __bsim4v30pMOS_DEFS_H__


// required properties
PROP_REQ [] = {
  { "GMIN", PROP_REAL, { 1e-12, PROP_NO_STR }, PROP_NO_RANGE },
  { "PS", PROP_REAL, { 12e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "PD", PROP_REAL, { 12e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "AS", PROP_REAL, { 12e-12, PROP_NO_STR }, PROP_NO_RANGE },
  { "AD", PROP_REAL, { 12e-12, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGBO", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGDO", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGSO", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "L", PROP_REAL, { 3e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "W", PROP_REAL, { 6e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "MOBMOD", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RDSMOD", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "IGCMOD", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "IGBMOD", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CAPMOD", PROP_REAL, { 2, PROP_NO_STR }, PROP_NO_RANGE },
  { "RGATEMOD", PROP_REAL, { 2, PROP_NO_STR }, PROP_NO_RANGE },
  { "RBODYMOD", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DIOMOD", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
  { "TEMPMOD", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "GEOMOD", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RGEOMOD", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PERMOD", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
  { "TNOIMOD", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "FNOIMOD", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "EPSROX", PROP_REAL, { 3.9, PROP_NO_STR }, PROP_NO_RANGE },
  { "TOXE", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TOXP", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TOXM", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DTOX", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XJ", PROP_REAL, { 1.5e-7, PROP_NO_STR }, PROP_NO_RANGE },
  { "GAMMA1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "GAMMA2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NDEP", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NSUB", PROP_REAL, { 6.0e16, PROP_NO_STR }, PROP_NO_RANGE },
  { "NGATE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NSD", PROP_REAL, { 1.0e20, PROP_NO_STR }, PROP_NO_RANGE },
  { "VBX", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XT", PROP_REAL, { 1.55e-7, PROP_NO_STR }, PROP_NO_RANGE },
  { "RSH", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RSHG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VTH0", PROP_REAL, { -0.6, PROP_NO_STR }, PROP_NO_RANGE },
  { "VFB", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PHIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "K1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "K2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "K3", PROP_REAL, { 80.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "K3B", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "W0", PROP_REAL, { 2.5e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPE0", PROP_REAL, { 1.74e-7, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPEB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VBM", PROP_REAL, { -3.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT0", PROP_REAL, { 2.2, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT1", PROP_REAL, { 0.53, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT2", PROP_REAL, { -0.032, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVTP0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVTP1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT0W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT1W", PROP_REAL, { 5.3e6, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT2W", PROP_REAL, { -0.032, PROP_NO_STR }, PROP_NO_RANGE },
  { "U0", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "UA", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "UB", PROP_REAL, { 1.0e-19, PROP_NO_STR }, PROP_NO_RANGE },
  { "UC", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "EU", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VSAT", PROP_REAL, { 8.0e4, PROP_NO_STR }, PROP_NO_RANGE },
  { "A0", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AGS", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "B0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "B1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KETA", PROP_REAL, { -0.047, PROP_NO_STR }, PROP_NO_RANGE },
  { "A1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "A2", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WINT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LINT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VOFF", PROP_REAL, { -0.08, PROP_NO_STR }, PROP_NO_RANGE },
  { "VOFFL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "MINV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NFACTOR", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "ETA0", PROP_REAL, { 0.08, PROP_NO_STR }, PROP_NO_RANGE },
  { "ETAB", PROP_REAL, { -0.07, PROP_NO_STR }, PROP_NO_RANGE },
  { "DROUT", PROP_REAL, { 0.56, PROP_NO_STR }, PROP_NO_RANGE },
  { "DSUB", PROP_REAL, { 0.56, PROP_NO_STR }, PROP_NO_RANGE },
  { "CIT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CDSC", PROP_REAL, { 2.4e-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "CDSCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CDSCD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCLM", PROP_REAL, { 1.3, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDIBL1", PROP_REAL, { 0.39, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDIBL2", PROP_REAL, { 0.0086, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDIBLB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PSCBE1", PROP_REAL, { 4.24e8, PROP_NO_STR }, PROP_NO_RANGE },
  { "PSCBE2", PROP_REAL, { 1.0e-5, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVAG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DELTA", PROP_REAL, { 0.01, PROP_NO_STR }, PROP_NO_RANGE },
  { "FPROUT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDITS", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDITSD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDITSL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LAMBDA", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VTL", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LC", PROP_REAL, { 5.0e-9, PROP_NO_STR }, PROP_NO_RANGE },
  { "XN", PROP_REAL, { 3.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RDSW", PROP_REAL, { 200.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RDSWMIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RDW", PROP_REAL, { 100.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RDWMIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RSW", PROP_REAL, { 100.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RSWMIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PRWG", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PRWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WR", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NRS", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NRD", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "ALPHA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "ALPHA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "BETA0", PROP_REAL, { 30.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AGIDL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "BGIDL", PROP_REAL, { 2.3e9, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGIDL", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_NO_RANGE },
  { "EGIDL", PROP_REAL, { 0.8, PROP_NO_STR }, PROP_NO_RANGE },
  { "AIGBACC", PROP_REAL, { 0.43, PROP_NO_STR }, PROP_NO_RANGE },
  { "BIGBACC", PROP_REAL, { 0.054, PROP_NO_STR }, PROP_NO_RANGE },
  { "CIGBACC", PROP_REAL, { 0.075, PROP_NO_STR }, PROP_NO_RANGE },
  { "NIGBACC", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AIGBINV", PROP_REAL, { 0.35, PROP_NO_STR }, PROP_NO_RANGE },
  { "BIGBINV", PROP_REAL, { 0.03, PROP_NO_STR }, PROP_NO_RANGE },
  { "CIGBINV", PROP_REAL, { 0.006, PROP_NO_STR }, PROP_NO_RANGE },
  { "EIGBINV", PROP_REAL, { 1.1, PROP_NO_STR }, PROP_NO_RANGE },
  { "NIGBINV", PROP_REAL, { 3.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AIGC", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "BIGC", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CIGC", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AIGSD", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "BIGSD", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CIGSD", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DLCIG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NIGC", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "POXEDGE", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PIGCD", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NTOX", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TOXREF", PROP_REAL, { 3.0e-9, PROP_NO_STR }, PROP_NO_RANGE },
  { "XPART", PROP_REAL, { 0.4, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGS0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGD0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGB0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGSL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGDL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CKAPPAS", PROP_REAL, { 0.6, PROP_NO_STR }, PROP_NO_RANGE },
  { "CKAPPAD", PROP_REAL, { 0.6, PROP_NO_STR }, PROP_NO_RANGE },
  { "CF", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CLC", PROP_REAL, { 1.0e-7, PROP_NO_STR }, PROP_NO_RANGE },
  { "CLE", PROP_REAL, { 0.6, PROP_NO_STR }, PROP_NO_RANGE },
  { "DLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DWC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VFBCV", PROP_REAL, { -1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NOFF", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VOFFCV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "ACDE", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "MOIN", PROP_REAL, { 15.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XRCRG1", PROP_REAL, { 12.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XRCRG2", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RBPB", PROP_REAL, { 50.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RBPD", PROP_REAL, { 50.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RBPS", PROP_REAL, { 50.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RBDB", PROP_REAL, { 50.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RBSB", PROP_REAL, { 50.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "GBMIN", PROP_REAL, { 1.0e-12, PROP_NO_STR }, PROP_NO_RANGE },
  { "DMCG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DMCI", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DMDG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DMCGT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NF", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DWJ", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "MIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XGW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XGL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NGCON", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "IJTHSREV", PROP_REAL, { 0.1, PROP_NO_STR }, PROP_NO_RANGE },
  { "IJTHDREV", PROP_REAL, { 0.1, PROP_NO_STR }, PROP_NO_RANGE },
  { "IJTHSFWD", PROP_REAL, { 0.1, PROP_NO_STR }, PROP_NO_RANGE },
  { "IJTHDFWD", PROP_REAL, { 0.1, PROP_NO_STR }, PROP_NO_RANGE },
  { "XJBVS", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XJBVD", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "BVS", PROP_REAL, { 10.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "BVD", PROP_REAL, { 10.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "JSS", PROP_REAL, { 1.0e-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "JSD", PROP_REAL, { 1.0e-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "JSWS", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "JSWD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "JSWGS", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "JSWGD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJS", PROP_REAL, { 5.0e-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJD", PROP_REAL, { 5.0e-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJS", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJD", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJSWS", PROP_REAL, { 0.33, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJSWD", PROP_REAL, { 0.33, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJSWS", PROP_REAL, { 5.0e-10, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJSWD", PROP_REAL, { 5.0e-10, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJSWGS", PROP_REAL, { 5.0e-10, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJSWGD", PROP_REAL, { 5.0e-10, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJSWGS", PROP_REAL, { 0.33, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJSWGD", PROP_REAL, { 0.33, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBS", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBD", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBSWS", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBSWD", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBSWGS", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBSWGD", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TNOM", PROP_REAL, { 27, PROP_NO_STR }, PROP_NO_RANGE },
  { "UTE", PROP_REAL, { -1.5, PROP_NO_STR }, PROP_NO_RANGE },
  { "KT1", PROP_REAL, { -0.11, PROP_NO_STR }, PROP_NO_RANGE },
  { "KT1L", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KT2", PROP_REAL, { 0.022, PROP_NO_STR }, PROP_NO_RANGE },
  { "UA1", PROP_REAL, { 1.0e-9, PROP_NO_STR }, PROP_NO_RANGE },
  { "UB1", PROP_REAL, { -1.0e-18, PROP_NO_STR }, PROP_NO_RANGE },
  { "UC1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AT", PROP_REAL, { 3.3e4, PROP_NO_STR }, PROP_NO_RANGE },
  { "PRT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NJS", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NJD", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XTIS", PROP_REAL, { 3.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XTID", PROP_REAL, { 3.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TPB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TPBSW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TPBSWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TCJ", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TCJSW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TCJSWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "SA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "SB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "SD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "SAREF", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "SBREF", PROP_REAL, { 1e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "WLOD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KVSAT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TKU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LKU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WKU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PKU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LLODKU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WLODKU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KVTH0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LKVTH0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WKVTH0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PKVTH0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LLODVTH", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WLODVTH", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "STK2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LODK2", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "STETA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LODETA0", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WLN", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWN", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LLN", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWN", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NTNOI", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AF", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "EF", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TEMP", PROP_REAL, { 27, PROP_NO_STR }, PROP_NO_RANGE },
  PROP_NO_PROP };

// optional properties
PROP_OPT [] = {
  PROP_NO_PROP };

// device definition
struct define_t bsim4v30pMOS::cirdef =
  { "bsim4v30pMOS",
    4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR, PROP_DEF };

#endif /* __bsim4v30pMOS_DEFS_H__ */
