/*
 * bsim3v34nMOS.defs.h - device definition header
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 */

#ifndef __bsim3v34nMOS_DEFS_H__
#define __bsim3v34nMOS_DEFS_H__

// required properties
PROP_REQ [] = {
  { "L", PROP_REAL, { 3.5e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "W", PROP_REAL, { 5.0e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "PS", PROP_REAL, { 8.0e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "PD", PROP_REAL, { 8.0e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "AS", PROP_REAL, { 12.0e-12, PROP_NO_STR }, PROP_NO_RANGE },
  { "AD", PROP_REAL, { 12.0e-12, PROP_NO_STR }, PROP_NO_RANGE },
  { "NRS", PROP_REAL, { 10.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NRD", PROP_REAL, { 10.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NQSMOD", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "GMIN", PROP_REAL, { 1e-12, PROP_NO_STR }, PROP_NO_RANGE },
  { "VERSION", PROP_REAL, { 3.24, PROP_NO_STR }, PROP_NO_RANGE },
  { "PARAMCHK", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "MOBMOD", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
  { "CAPMOD", PROP_REAL, { 3, PROP_NO_STR }, PROP_NO_RANGE },
  { "NOIMOD", PROP_REAL, { 4, PROP_NO_STR }, PROP_NO_RANGE },
  { "BINUNIT", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
  { "TOX", PROP_REAL, { 150.0e-10, PROP_NO_STR }, PROP_NO_RANGE },
  { "TOXM", PROP_REAL, { 150.0e-10, PROP_NO_STR }, PROP_NO_RANGE },
  { "CDSC", PROP_REAL, { 2.4e-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "CDSCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CDSCD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CIT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NFACTOR", PROP_REAL, { 1, PROP_NO_STR }, PROP_NO_RANGE },
  { "XJ", PROP_REAL, { 0.15e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "VSAT", PROP_REAL, { 8.0e4, PROP_NO_STR }, PROP_NO_RANGE },
  { "AT", PROP_REAL, { 3.3e4, PROP_NO_STR }, PROP_NO_RANGE },
  { "A0", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AGS", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "A1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "A2", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KETA", PROP_REAL, { -0.047, PROP_NO_STR }, PROP_NO_RANGE },
  { "NSUB", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NCH", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NGATE", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "GAMMA1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "GAMMA2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VBX", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VBM", PROP_REAL, { -3.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XT", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "K1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KT1", PROP_REAL, { -0.11, PROP_NO_STR }, PROP_NO_RANGE },
  { "KT1L", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KT2", PROP_REAL, { 0.022, PROP_NO_STR }, PROP_NO_RANGE },
  { "K2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "K3", PROP_REAL, { 80.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "K3B", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "W0", PROP_REAL, { 2.5e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "NLX", PROP_REAL, { 1.74e-7, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT0", PROP_REAL, { 2.2, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT1", PROP_REAL, { 0.53, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT2", PROP_REAL, { -0.032, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT0W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT1W", PROP_REAL, { 5.3e6, PROP_NO_STR }, PROP_NO_RANGE },
  { "DVT2W", PROP_REAL, { -0.032, PROP_NO_STR }, PROP_NO_RANGE },
  { "DROUT", PROP_REAL, { 0.56, PROP_NO_STR }, PROP_NO_RANGE },
  { "DSUB", PROP_REAL, { 0.56, PROP_NO_STR }, PROP_NO_RANGE },
  { "VTHO", PROP_REAL, { 0.7, PROP_NO_STR }, PROP_NO_RANGE },
  { "VTH0", PROP_REAL, { 0.7, PROP_NO_STR }, PROP_NO_RANGE },
  { "UA", PROP_REAL, { 2.25e-9, PROP_NO_STR }, PROP_NO_RANGE },
  { "UA1", PROP_REAL, { 4.31e-9, PROP_NO_STR }, PROP_NO_RANGE },
  { "UB", PROP_REAL, { 5.87e-19, PROP_NO_STR }, PROP_NO_RANGE },
  { "UB1", PROP_REAL, { -7.61e-18, PROP_NO_STR }, PROP_NO_RANGE },
  { "UC", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "UC1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "U0", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "UTE", PROP_REAL, { -1.5, PROP_NO_STR }, PROP_NO_RANGE },
  { "VOFF", PROP_REAL, { -0.08, PROP_NO_STR }, PROP_NO_RANGE },
  { "TNOM", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGSO", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGDO", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGBO", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XPART", PROP_REAL, { 0.4, PROP_NO_STR }, PROP_NO_RANGE },
  { "ELM", PROP_REAL, { 5.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DELTA", PROP_REAL, { 0.01, PROP_NO_STR }, PROP_NO_RANGE },
  { "RSH", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "RDSW", PROP_REAL, { 0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PRWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PRWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PRT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "ETA0", PROP_REAL, { 0.08, PROP_NO_STR }, PROP_NO_RANGE },
  { "ETAB", PROP_REAL, { -0.07, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCLM", PROP_REAL, { 1.3, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDIBLC1", PROP_REAL, { 0.39, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDIBLC2", PROP_REAL, { 0.0086, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDIBLCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PSCBE1", PROP_REAL, { 4.24e8, PROP_NO_STR }, PROP_NO_RANGE },
  { "PSCBE2", PROP_REAL, { 1.0e-5, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVAG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "JS", PROP_REAL, { 1.0E-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "JSW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PB", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NJ", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "XTI", PROP_REAL, { 3.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJ", PROP_REAL, { 0.5, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBSW", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJSW", PROP_REAL, { 0.33, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBSWG", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "MJSWG", PROP_REAL, { 0.33, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJ", PROP_REAL, { 5.0E-4, PROP_NO_STR }, PROP_NO_RANGE },
  { "VFBCV", PROP_REAL, { -1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VFB", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJSW", PROP_REAL, { 5.0E-10, PROP_NO_STR }, PROP_NO_RANGE },
  { "CJSWG", PROP_REAL, { 5.0e-10, PROP_NO_STR }, PROP_NO_RANGE },
  { "TPB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TCJ", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TPBSW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TCJSW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TPBSWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "TCJSWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "ACDE", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "MOIN", PROP_REAL, { 15.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "NOFF", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "VOFFCV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LINT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LLN", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWN", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LMIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LMAX", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WR", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WINT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WLN", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWN", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WMIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WMAX", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "B0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "B1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGSL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CGDL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CKAPPA", PROP_REAL, { 0.6, PROP_NO_STR }, PROP_NO_RANGE },
  { "CF", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "CLC", PROP_REAL, { 0.1e-6, PROP_NO_STR }, PROP_NO_RANGE },
  { "CLE", PROP_REAL, { 0.6, PROP_NO_STR }, PROP_NO_RANGE },
  { "DWC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "DLC", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "ALPHA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "ALPHA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "BETA0", PROP_REAL, { 30.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "IJTH", PROP_REAL, { 0.1, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCDSC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCDSCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCDSCD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCIT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LNFACTOR", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LXJ", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVSAT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LAT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LAGS", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LA2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LKETA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LNSUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LNCH", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LNGATE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LGAMMA1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LGAMMA2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVBX", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVBM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LXT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LK1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LKT1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LKT1L", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LKT2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LK2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LK3", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LK3B", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LW0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LNLX", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDVT0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDVT1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDVT2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDVT0W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDVT1W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDVT2W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDROUT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDSUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVTH0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVTHO", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LUA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LUA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LUB1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LUC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LUC1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LUTE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVOFF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LELM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDELTA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LRDSW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPRWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPRWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPRT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LETA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LETAB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPCLM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPDIBLC1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPDIBLC2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPDIBLCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPSCBE1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPSCBE2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LPVAG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LWR", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LDWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LB0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LB1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCGSL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCGDL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCKAPPA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LCLE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LALPHA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LALPHA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LBETA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVFBCV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVFB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LACDE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LMOIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LNOFF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "LVOFFCV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCDSC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCDSCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCDSCD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCIT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WNFACTOR", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WXJ", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVSAT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WAT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WAGS", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WA2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WKETA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WNSUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WNCH", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WNGATE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WGAMMA1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WGAMMA2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVBX", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVBM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WXT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WK1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WKT1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WKT1L", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WKT2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WK2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WK3", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WK3B", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WW0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WNLX", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDVT0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDVT1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDVT2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDVT0W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDVT1W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDVT2W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDROUT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDSUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVTH0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVTHO", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WUA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WUA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WUB1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WUC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WUC1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WUTE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVOFF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WELM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDELTA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WRDSW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPRWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPRWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPRT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WETA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WETAB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPCLM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPDIBLC1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPDIBLC2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPDIBLCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPSCBE1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPSCBE2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WPVAG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WWR", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WDWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WB0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WB1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCGSL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCGDL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCKAPPA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WCLE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WALPHA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WALPHA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WBETA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVFBCV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVFB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WACDE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WMOIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WNOFF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "WVOFFCV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCDSC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCDSCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCDSCD", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCIT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PNFACTOR", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PXJ", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVSAT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PAT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PAGS", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PA2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PKETA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PNSUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PNCH", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PNGATE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PGAMMA1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PGAMMA2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVBX", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVBM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PXT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PK1", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PKT1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PKT1L", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PKT2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PK2", PROP_REAL, { -99.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PK3", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PK3B", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PW0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PNLX", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDVT0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDVT1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDVT2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDVT0W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDVT1W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDVT2W", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDROUT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDSUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVTH0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVTHO", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PUA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PUA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PUB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PUB1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PUC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PUC1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PU0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PUTE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVOFF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PELM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDELTA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PRDSW", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPRWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPRWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPRT", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PETA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PETAB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPCLM", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPDIBLC1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPDIBLC2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPDIBLCB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPSCBE1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPSCBE2", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PPVAG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PWR", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDWG", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PDWB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PB0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PB1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCGSL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCGDL", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCKAPPA", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCLC", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PCLE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PALPHA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PALPHA1", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PBETA0", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVFBCV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVFB", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PACDE", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PMOIN", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PNOFF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "PVOFFCV", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "KF", PROP_REAL, { 0.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "AF", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  { "EF", PROP_REAL, { 1.0, PROP_NO_STR }, PROP_NO_RANGE },
  PROP_NO_PROP };

// optional properties
PROP_OPT [] = {
  { "Temp", PROP_REAL, { 26.85, PROP_NO_STR }, PROP_MIN_VAL (K) },
  PROP_NO_PROP };

// device definition
struct define_t bsim3v34nMOS::cirdef =
  { "bsim3v34nMOS",
    4, PROP_COMPONENT, PROP_NO_SUBSTRATE, PROP_NONLINEAR, PROP_DEF };

#endif /* __bsim3v34nMOS_DEFS_H__ */
