// QApplication.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// Generated File.  Do Not Modify.

namespace Qt {

    using Qt;
    using System;
    using System.Collections;
    using System.IO;
    using System.Runtime.InteropServices;

    public class QApplication : QObject, IDisposable {

        // For use the copy of command-line arguments we
        // create in unmanaged heap
        private int globalArgCount;
        private unsafe byte** globalArgVector;


        public enum Type {
            Tty = 0,
            GuiClient = 1,
            GuiServer = 2
        }

        public enum ColorMode {
            NormalColors = 0,
            CustomColors = 1
        }

        public enum ColorSpec {
            NormalColor = 0,
            CustomColor = 1,
            ManyColor = 2
        }

        public enum Encoding {
            DefaultCodec = 0,
            UnicodeUTF8 = 1
        }


        private unsafe void InitializeArgs( string[] args )
        {
            string[] argv = new string[args.Length+1];

            Array.Copy( args, 0, argv, 1, args.Length );

            // Get the "command" use to run the current application
            // Example, for "clix program.exe", we use "program.exe"
            // Some CLI impl. return full path, so to extract if necessary
            string commandName = Environment.GetCommandLineArgs()[0];
            argv[0] = commandName.Substring(
                commandName.LastIndexOf( Path.DirectorySeparatorChar ) + 1 );

            globalArgCount = argv.Length;
            globalArgVector = (byte**) Marshal.AllocHGlobal( globalArgCount * IntPtr.Size );

            for ( int i = 0; i < globalArgCount; i++ )
            {
                // This is the easy way
                // globalArgVector[i] = (byte*) Marshal.StringToHGlobalAnsi( argv[i] );


                // Use this workaround for Rotor:
                globalArgVector[i] = (byte*) Marshal.AllocHGlobal( argv[i].Length + 1 );
                for ( int j = 0; j < argv[i].Length; j++ )
                    globalArgVector[i][j] = (byte) argv[i][j];

                globalArgVector[i][argv[i].Length] = 0;
            }
        }



        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static unsafe extern IntPtr qt_new_QApplication (int argc, byte** argv);
        public unsafe QApplication (string[] argv) : this (QNull.Instance)
        {
            QObject.qApp = this;
            qparent = null;
            argv = ParseArguments (argv);
            InitializeArgs (argv);
            rawObject = qt_new_QApplication (globalArgCount, globalArgVector);
            RegisterObject (this);
            RegisterEventDelegate ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static unsafe extern IntPtr qt_new_QApplication1 (int argc, byte** argv, bool GUIenabled);
        public unsafe QApplication (string[] argv, bool GUIenabled) : this (QNull.Instance)
        {
            QObject.qApp = this;
            qparent = null;
            argv = ParseArguments (argv);
            InitializeArgs (argv);
            rawObject = qt_new_QApplication1 (globalArgCount, globalArgVector, GUIenabled);
            RegisterObject (this);
            RegisterEventDelegate ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static unsafe extern IntPtr qt_new_QApplication2 (int argc, byte** argv, Type arg1);
        public unsafe QApplication (string[] argv, Type arg1) : this (QNull.Instance)
        {
            QObject.qApp = this;
            qparent = null;
            argv = ParseArguments (argv);
            InitializeArgs (argv);
            rawObject = qt_new_QApplication2 (globalArgCount, globalArgVector, arg1);
            RegisterObject (this);
            RegisterEventDelegate ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QApplication3 (IntPtr dpy, uint visual, uint cmap);
        public QApplication (IntPtr dpy, uint visual, uint cmap) : this (QNull.Instance)
        {
            QObject.qApp = this;
            qparent = null;
            rawObject = qt_new_QApplication3 (dpy, visual, cmap);
            RegisterObject (this);
            RegisterEventDelegate ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static unsafe extern IntPtr qt_new_QApplication4 (IntPtr dpy, int argc, byte** argv, uint visual, uint cmap);
        public unsafe QApplication (IntPtr dpy, string[] argv, uint visual, uint cmap) : this (QNull.Instance)
        {
            QObject.qApp = this;
            qparent = null;
            argv = ParseArguments (argv);
            InitializeArgs (argv);
            rawObject = qt_new_QApplication4 (dpy, globalArgCount, globalArgVector, visual, cmap);
            RegisterObject (this);
            RegisterEventDelegate ();
        }

        public QApplication (IntPtr dpy) : this (dpy, (uint) 0) {}

        public QApplication (IntPtr dpy, uint visual) : this (dpy, visual, (uint) 0) {}

        public QApplication (IntPtr dpy, string[] argv) : this (dpy, argv, (uint) 0) {}

        public QApplication (IntPtr dpy, string[] argv, uint visual) : this (dpy, argv, visual, (uint) 0) {}

        internal QApplication () : this (QNull.Instance) {}

        internal QApplication (QNull dummy) : base (QNull.Instance) {}

        unsafe ~QApplication ()
        {
            for ( int i = 0; i < globalArgCount; i++ )
                Marshal.FreeHGlobal( (IntPtr) globalArgVector[i] );

            Marshal.FreeHGlobal( (IntPtr) globalArgVector );
            Dispose (false);
        }


        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_del_QApplication (IntPtr obj);
        internal override void Delete ()
        {
            if (deleted) return;

            qt_del_QApplication (rawObject);
            deleted = true;
        }

        private string[] ParseArguments (string[] args)
        {
            ArrayList newargs = new ArrayList();

            foreach (string arg in args) {
                switch (arg) {
                case "--qts-help":
                    PrintHelp ();
                    Environment.Exit(0);
                    break;
                case "--qts-debug":
                    QtSupport.enableDebug = true;
                    break;
                case "--qts-notracking":
                    QtSupport.disableTracking = true;
                    break;
                case "--qts-trace-objects":
                    QtSupport.traceObjects = true;
                    break;
                case "--qts-trace-connects":
                    QtSignal.traceConnects = true;
                    break;
                case "--qts-trace-children":
                    QtSupport.traceChildren = true;
                    break;
                default:
                    newargs.Add (arg);
                    break;
                }
            }

            return newargs.ToArray (typeof (string)) as string[];
        }

        private void PrintHelp ()
        {
            Msg ("Qt# Options:");
            Msg ("");
            Msg ("--qts-help\t\tDisplay help.");
            Msg ("--qts-debug\t\tEnable debug mode.");
            Msg ("--qts-notracking\tDisable object tracking.");
            Msg ("--qts-trace-objects\tTrace object tracking.");
            Msg ("--qts-trace-connects\tTrace signal connections.");
            Msg ("--qts-trace-children\tTrace parent/child relationships.");
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_argc (IntPtr raw);
        public int Argc ()
        {
            return qt_QApplication_argc (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern string[] qt_QApplication_argv (IntPtr raw);
        public string[] Argv ()
        {
            return qt_QApplication_argv (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern Type qt_QApplication_type (IntPtr raw);
        public Type TheType ()
        {
            return qt_QApplication_type (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_mainWidget (IntPtr raw);
        public QWidget MainWidget ()
        {
            return (QWidget)LookupObject (qt_QApplication_mainWidget (rawObject), typeof(QWidget));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setMainWidget (IntPtr raw, IntPtr arg1);
        public void SetMainWidget (QWidget arg1)
        {
            qt_QApplication_setMainWidget (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_polish (IntPtr raw, IntPtr arg1);
        public void Polish (QWidget arg1)
        {
            qt_QApplication_polish (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_focusWidget (IntPtr raw);
        public QWidget FocusWidget ()
        {
            return (QWidget)LookupObject (qt_QApplication_focusWidget (rawObject), typeof(QWidget));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_activeWindow (IntPtr raw);
        public QWidget ActiveWindow ()
        {
            return (QWidget)LookupObject (qt_QApplication_activeWindow (rawObject), typeof(QWidget));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_exec (IntPtr raw);
        public int Exec ()
        {
            return qt_QApplication_exec (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_processEvents (IntPtr raw);
        public void ProcessEvents ()
        {
            qt_QApplication_processEvents (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_processEvents1 (IntPtr raw, int maxtime);
        public void ProcessEvents (int maxtime)
        {
            qt_QApplication_processEvents1 (rawObject, maxtime);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_hasPendingEvents (IntPtr raw);
        public bool HasPendingEvents ()
        {
            return qt_QApplication_hasPendingEvents (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_enter_loop (IntPtr raw);
        public int Enter_loop ()
        {
            return qt_QApplication_enter_loop (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_exit_loop (IntPtr raw);
        public void Exit_loop ()
        {
            qt_QApplication_exit_loop (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_loopLevel (IntPtr raw);
        public int LoopLevel ()
        {
            return qt_QApplication_loopLevel (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_notify (IntPtr raw, IntPtr arg1, IntPtr arg2);
        public bool Notify (QObject arg1, QEvent arg2)
        {
            return qt_QApplication_notify (rawObject, arg1.RawObject, arg2.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setDefaultCodec (IntPtr raw, IntPtr arg1);
        public void SetDefaultCodec (QTextCodec arg1)
        {
            qt_QApplication_setDefaultCodec (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_defaultCodec (IntPtr raw);
        public QTextCodec DefaultCodec ()
        {
            return (QTextCodec)LookupObject (qt_QApplication_defaultCodec (rawObject), typeof(QTextCodec));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_installTranslator (IntPtr raw, IntPtr arg1);
        public void InstallTranslator (QTranslator arg1)
        {
            qt_QApplication_installTranslator (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_removeTranslator (IntPtr raw, IntPtr arg1);
        public void RemoveTranslator (QTranslator arg1)
        {
            qt_QApplication_removeTranslator (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_translate (IntPtr raw, string context, string key, string comment, Encoding encoding);
        public string Translate (string context, string key, string comment, Encoding encoding)
        {
            QString qstr = new QString (qt_QApplication_translate (rawObject, context, key, comment, encoding));
            string str = qstr.Latin1 ();
            qstr.Dispose ();
            return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_macEventFilter (IntPtr raw, IntPtr arg1);
        public bool MacEventFilter (IntPtr arg1)
        {
            return qt_QApplication_macEventFilter (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_winEventFilter (IntPtr raw, IntPtr arg1);
        public bool WinEventFilter (IntPtr arg1)
        {
            return qt_QApplication_winEventFilter (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_x11EventFilter (IntPtr raw, IntPtr arg1);
        public bool X11EventFilter (IntPtr arg1)
        {
            return qt_QApplication_x11EventFilter (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_x11ClientMessage (IntPtr raw, IntPtr arg1, IntPtr arg2, bool passive_only);
        public int X11ClientMessage (QWidget arg1, IntPtr arg2, bool passive_only)
        {
            return qt_QApplication_x11ClientMessage (rawObject, arg1.RawObject, arg2, passive_only);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_qwsEventFilter (IntPtr raw, IntPtr arg1);
        public bool QwsEventFilter (IntPtr arg1)
        {
            return qt_QApplication_qwsEventFilter (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_qwsSetCustomColors (IntPtr raw, int colortable, int start, int numColors);
        public void QwsSetCustomColors (int colortable, int start, int numColors)
        {
            qt_QApplication_qwsSetCustomColors (rawObject, colortable, start, numColors);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_winFocus (IntPtr raw, IntPtr arg1, bool arg2);
        public void WinFocus (QWidget arg1, bool arg2)
        {
            qt_QApplication_winFocus (rawObject, arg1.RawObject, arg2);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_isSessionRestored (IntPtr raw);
        public bool IsSessionRestored ()
        {
            return qt_QApplication_isSessionRestored (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_sessionId (IntPtr raw);
        public string SessionId ()
        {
            QString qstr = new QString (qt_QApplication_sessionId (rawObject));
            string str = qstr.Latin1 ();
            qstr.Dispose ();
            return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_commitData (IntPtr raw, IntPtr sm);
        public void CommitData (QSessionManager sm)
        {
            qt_QApplication_commitData (rawObject, sm.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_saveState (IntPtr raw, IntPtr sm);
        public void SaveState (QSessionManager sm)
        {
            qt_QApplication_saveState (rawObject, sm.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_wakeUpGuiThread (IntPtr raw);
        public void WakeUpGuiThread ()
        {
            qt_QApplication_wakeUpGuiThread (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_lock (IntPtr raw);
        public void Q_lock ()
        {
            qt_QApplication_lock (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_unlock (IntPtr raw, bool wakeUpGui);
        public void Unlock (bool wakeUpGui)
        {
            qt_QApplication_unlock (rawObject, wakeUpGui);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_locked (IntPtr raw);
        public bool Locked ()
        {
            return qt_QApplication_locked (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_tryLock (IntPtr raw);
        public bool TryLock ()
        {
            return qt_QApplication_tryLock (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setEnableRemoteControl (IntPtr raw, bool enable, IntPtr appId);
        public void SetEnableRemoteControl (bool enable, QUuid appId)
        {
            qt_QApplication_setEnableRemoteControl (rawObject, enable, appId.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_remoteControlEnabled (IntPtr raw);
        public bool RemoteControlEnabled ()
        {
            return qt_QApplication_remoteControlEnabled (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_applicationId (IntPtr raw);
        public QUuid ApplicationId ()
        {
            return (QUuid)LookupObject (qt_QApplication_applicationId (rawObject), typeof(QUuid));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_quit (IntPtr raw);
        public void Quit ()
        {
            qt_QApplication_quit (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_closeAllWindows (IntPtr raw);
        public void CloseAllWindows ()
        {
            qt_QApplication_closeAllWindows (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_style ();
        public static QStyle Style ()
        {
            return (QStyle)LookupObject (qt_QApplication_style (), typeof(QStyle));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setStyle (IntPtr arg1);
        public static void SetStyle (QStyle arg1)
        {
            qt_QApplication_setStyle (arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_setStyle1 (IntPtr arg1);
        public static QStyle SetStyle (string arg1)
        {
            return (QStyle)LookupObject (qt_QApplication_setStyle1 (new QString (arg1).RawObject), typeof(QStyle));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern ColorMode qt_QApplication_colorMode ();
        public static ColorMode TheColorMode ()
        {
            return qt_QApplication_colorMode ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setColorMode (QApplication.ColorMode arg1);
        public static void SetColorMode (QApplication.ColorMode arg1)
        {
            qt_QApplication_setColorMode (arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_colorSpec ();
        public static int TheColorSpec ()
        {
            return qt_QApplication_colorSpec ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setColorSpec (int arg1);
        public static void SetColorSpec (int arg1)
        {
            qt_QApplication_setColorSpec (arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_overrideCursor ();
        public static QCursor OverrideCursor ()
        {
            return (QCursor)LookupObject (qt_QApplication_overrideCursor (), typeof(QCursor));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setOverrideCursor (IntPtr arg1, bool replace);
        public static void SetOverrideCursor (QCursor arg1, bool replace)
        {
            qt_QApplication_setOverrideCursor (arg1.RawObject, replace);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_restoreOverrideCursor ();
        public static void RestoreOverrideCursor ()
        {
            qt_QApplication_restoreOverrideCursor ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_hasGlobalMouseTracking ();
        public static bool HasGlobalMouseTracking ()
        {
            return qt_QApplication_hasGlobalMouseTracking ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setGlobalMouseTracking (bool enable);
        public static void SetGlobalMouseTracking (bool enable)
        {
            qt_QApplication_setGlobalMouseTracking (enable);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_palette (IntPtr arg1);
        public static QPalette Palette (QWidget arg1)
        {
            return (QPalette)LookupObject (qt_QApplication_palette (arg1.RawObject), typeof(QPalette));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setPalette (IntPtr arg1, bool informWidgets, string className);
        public static void SetPalette (QPalette arg1, bool informWidgets, string className)
        {
            qt_QApplication_setPalette (arg1.RawObject, informWidgets, className);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_font (IntPtr arg1);
        public static QFont Font (QWidget arg1)
        {
            return (QFont)LookupObject (qt_QApplication_font (arg1.RawObject), typeof(QFont));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setFont (IntPtr arg1, bool informWidgets, string className);
        public static void SetFont (QFont arg1, bool informWidgets, string className)
        {
            qt_QApplication_setFont (arg1.RawObject, informWidgets, className);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_fontMetrics ();
        public static QFontMetrics FontMetrics ()
        {
            return (QFontMetrics)LookupObject (qt_QApplication_fontMetrics (), typeof(QFontMetrics));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_allWidgets ();
        public static QWidgetList AllWidgets ()
        {
            return (QWidgetList)LookupObject (qt_QApplication_allWidgets (), typeof(QWidgetList));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_topLevelWidgets ();
        public static QWidgetList TopLevelWidgets ()
        {
            return (QWidgetList)LookupObject (qt_QApplication_topLevelWidgets (), typeof(QWidgetList));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_desktop ();
        public static QDesktopWidget Desktop ()
        {
            return (QDesktopWidget)LookupObject (qt_QApplication_desktop (), typeof(QDesktopWidget));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_activePopupWidget ();
        public static QWidget ActivePopupWidget ()
        {
            return (QWidget)LookupObject (qt_QApplication_activePopupWidget (), typeof(QWidget));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_activeModalWidget ();
        public static QWidget ActiveModalWidget ()
        {
            return (QWidget)LookupObject (qt_QApplication_activeModalWidget (), typeof(QWidget));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_clipboard ();
        public static QClipboard Clipboard ()
        {
            return (QClipboard)LookupObject (qt_QApplication_clipboard (), typeof(QClipboard));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_widgetAt (int x, int y, bool child);
        public static QWidget WidgetAt (int x, int y, bool child)
        {
            return (QWidget)LookupObject (qt_QApplication_widgetAt (x, y, child), typeof(QWidget));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_widgetAt1 (IntPtr arg1, bool child);
        public static QWidget WidgetAt (QPoint arg1, bool child)
        {
            return (QWidget)LookupObject (qt_QApplication_widgetAt1 (arg1.RawObject, child), typeof(QWidget));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_exit (int retcode);
        public static void Exit (int retcode)
        {
            qt_QApplication_exit (retcode);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_sendPostedEvents (IntPtr receiver, int event_type);
        public static void SendPostedEvents (QObject receiver, int event_type)
        {
            qt_QApplication_sendPostedEvents (receiver.RawObject, event_type);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_sendPostedEvents1 ();
        public static void SendPostedEvents ()
        {
            qt_QApplication_sendPostedEvents1 ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_removePostedEvents (IntPtr receiver);
        public static void RemovePostedEvents (QObject receiver)
        {
            qt_QApplication_removePostedEvents (receiver.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_startingUp ();
        public static bool StartingUp ()
        {
            return qt_QApplication_startingUp ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_closingDown ();
        public static bool ClosingDown ()
        {
            return qt_QApplication_closingDown ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_flushX ();
        public static void FlushX ()
        {
            qt_QApplication_flushX ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_flush ();
        public static void Flush ()
        {
            qt_QApplication_flush ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_syncX ();
        public static void SyncX ()
        {
            qt_QApplication_syncX ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_beep ();
        public static void Beep ()
        {
            qt_QApplication_beep ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setWinStyleHighlightColor (IntPtr c);
        public static void SetWinStyleHighlightColor (QColor c)
        {
            qt_QApplication_setWinStyleHighlightColor (c.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_winStyleHighlightColor ();
        public static QColor WinStyleHighlightColor ()
        {
            return (QColor)LookupObject (qt_QApplication_winStyleHighlightColor (), typeof(QColor));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setDesktopSettingsAware (bool arg1);
        public static void SetDesktopSettingsAware (bool arg1)
        {
            qt_QApplication_setDesktopSettingsAware (arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_desktopSettingsAware ();
        public static bool DesktopSettingsAware ()
        {
            return qt_QApplication_desktopSettingsAware ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setCursorFlashTime (int arg1);
        public static void SetCursorFlashTime (int arg1)
        {
            qt_QApplication_setCursorFlashTime (arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_cursorFlashTime ();
        public static int CursorFlashTime ()
        {
            return qt_QApplication_cursorFlashTime ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setDoubleClickInterval (int arg1);
        public static void SetDoubleClickInterval (int arg1)
        {
            qt_QApplication_setDoubleClickInterval (arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_doubleClickInterval ();
        public static int DoubleClickInterval ()
        {
            return qt_QApplication_doubleClickInterval ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setWheelScrollLines (int arg1);
        public static void SetWheelScrollLines (int arg1)
        {
            qt_QApplication_setWheelScrollLines (arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_wheelScrollLines ();
        public static int WheelScrollLines ()
        {
            return qt_QApplication_wheelScrollLines ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setGlobalStrut (IntPtr arg1);
        public static void SetGlobalStrut (QSize arg1)
        {
            qt_QApplication_setGlobalStrut (arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_globalStrut ();
        public static QSize GlobalStrut ()
        {
            return (QSize)LookupObject (qt_QApplication_globalStrut (), typeof(QSize));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setLibraryPaths (IntPtr arg1);
        public static void SetLibraryPaths (QStringList arg1)
        {
            qt_QApplication_setLibraryPaths (arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_libraryPaths ();
        public static QStringList LibraryPaths ()
        {
            return (QStringList)LookupObject (qt_QApplication_libraryPaths (), typeof(QStringList));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_addLibraryPath (IntPtr arg1);
        public static void AddLibraryPath (string arg1)
        {
            qt_QApplication_addLibraryPath (new QString (arg1).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_removeLibraryPath (IntPtr arg1);
        public static void RemoveLibraryPath (string arg1)
        {
            qt_QApplication_removeLibraryPath (new QString (arg1).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setStartDragTime (int ms);
        public static void SetStartDragTime (int ms)
        {
            qt_QApplication_setStartDragTime (ms);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_startDragTime ();
        public static int StartDragTime ()
        {
            return qt_QApplication_startDragTime ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setStartDragDistance (int l);
        public static void SetStartDragDistance (int l)
        {
            qt_QApplication_setStartDragDistance (l);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_startDragDistance ();
        public static int StartDragDistance ()
        {
            return qt_QApplication_startDragDistance ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setReverseLayout (bool b);
        public static void SetReverseLayout (bool b)
        {
            qt_QApplication_setReverseLayout (b);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_reverseLayout ();
        public static bool ReverseLayout ()
        {
            return qt_QApplication_reverseLayout ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_horizontalAlignment (int align);
        public static int HorizontalAlignment (int align)
        {
            return qt_QApplication_horizontalAlignment (align);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_isEffectEnabled (Qt.UIEffect arg1);
        public static bool IsEffectEnabled (Qt.UIEffect arg1)
        {
            return qt_QApplication_isEffectEnabled (arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setEffectEnabled (Qt.UIEffect arg1, bool enable);
        public static void SetEffectEnabled (Qt.UIEffect arg1, bool enable)
        {
            qt_QApplication_setEffectEnabled (arg1, enable);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_qwsDecoration ();
        public static IntPtr QwsDecoration ()
        {
            return qt_QApplication_qwsDecoration ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_qwsSetDecoration (IntPtr arg1);
        public static void QwsSetDecoration (IntPtr arg1)
        {
            qt_QApplication_qwsSetDecoration (arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern Qt.WindowsVersion qt_QApplication_winVersion ();
        public static Qt.WindowsVersion WinVersion ()
        {
            return qt_QApplication_winVersion ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_winMouseButtonUp ();
        public static void WinMouseButtonUp ()
        {
            qt_QApplication_winMouseButtonUp ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_create_xim ();
        public static void Create_xim ()
        {
            qt_QApplication_create_xim ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_close_xim ();
        public static void Close_xim ()
        {
            qt_QApplication_close_xim ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_x11_apply_settings ();
        public static bool X11_apply_settings ()
        {
            return qt_QApplication_x11_apply_settings ();
        }

        public string Translate (string context, string key)
        {
            return Translate(context, key, "");
        }

        public string Translate (string context, string key, string comment)
        {
            return Translate(context, key, comment, Encoding.DefaultCodec);
        }

        public void Unlock ()
        {
            Unlock(true);
        }

        public void SetEnableRemoteControl (bool enable)
        {
            SetEnableRemoteControl(enable, new QUuid ());
        }

        public static void SetOverrideCursor (QCursor arg1)
        {
            SetOverrideCursor(arg1, false);
        }

        public static QPalette Palette ()
        {
            return Palette(new QWidget ());
        }

        public static void SetPalette (QPalette arg1)
        {
            SetPalette(arg1, false);
        }

        public static void SetPalette (QPalette arg1, bool informWidgets)
        {
            SetPalette(arg1, informWidgets, "");
        }

        public static QFont Font ()
        {
            return Font(new QWidget ());
        }

        public static void SetFont (QFont arg1)
        {
            SetFont(arg1, false);
        }

        public static void SetFont (QFont arg1, bool informWidgets)
        {
            SetFont(arg1, informWidgets, "");
        }

        public static QWidget WidgetAt (int x, int y)
        {
            return WidgetAt(x, y, false);
        }

        public static QWidget WidgetAt (QPoint arg1)
        {
            return WidgetAt(arg1, false);
        }

        public static void Exit ()
        {
            Exit((int) 0);
        }

        public static void SetEffectEnabled (Qt.UIEffect arg1)
        {
            SetEffectEnabled(arg1, true);
        }

        // Begin interface methods.

    }
}
