# Copyright 2014 PDFium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'target_defaults': {
    'defines': [
      'OPJ_STATIC',
      '_CRT_SECURE_NO_WARNINGS',
    ],
    'msvs_disabled_warnings': [
      4005, 4018, 4146, 4333, 4345, 4267
    ],
  },
  'targets': [
    {
      'target_name': 'bigint',
      'type': 'static_library',
      'sources': [
        'bigint/BigInteger.hh',
        'bigint/BigIntegerLibrary.hh',
        'bigint/BigIntegerUtils.hh',
        'bigint/BigUnsigned.hh',
        'bigint/NumberlikeArray.hh',
        'bigint/BigUnsignedInABase.hh',
        'bigint/BigInteger.cc',
        'bigint/BigIntegerUtils.cc',
        'bigint/BigUnsigned.cc',
        'bigint/BigUnsignedInABase.cc',
      ],
    },
    {
      'target_name': 'freetype',
      'type': 'static_library',
      'defines': [
        'FT2_BUILD_LIBRARY',
      ],
      'include_dirs': [
         'freetype/include',
      ],
      'sources': [
        'freetype/include/freetype.h',
        'freetype/include/ft2build.h',
        'freetype/include/ftmm.h',
        'freetype/include/ftotval.h',
        'freetype/include/ftoutln.h',
        'freetype/include/tttables.h',
        'freetype/include/internal/ftobjs.h',
        'freetype/include/internal/ftstream.h',
        'freetype/include/internal/tttypes.h',
        'freetype/src/cff/cffobjs.h',
        'freetype/src/cff/cfftypes.h',
        'freetype/src/cff/cff.c',
        'freetype/src/base/ftbase.c',
        'freetype/src/base/ftbitmap.c',
        'freetype/src/base/ftglyph.c',
        'freetype/src/base/ftinit.c',
        'freetype/src/base/ftlcdfil.c',
        'freetype/src/base/ftmm.c',
        'freetype/src/base/ftsystem.c',
        'freetype/src/psaux/psaux.c',
        'freetype/src/pshinter/pshinter.c',
        'freetype/src/psnames/psmodule.c',
        'freetype/src/raster/raster.c',
        'freetype/src/sfnt/sfnt.c',
        'freetype/src/smooth/smooth.c',
        'freetype/src/truetype/truetype.c',
        'freetype/src/type1/type1.c',
        'freetype/src/cid/type1cid.c',
      ],
    },
    {
      'target_name': 'fx_agg',
      'type': 'static_library',
      'sources': [
        'agg23/agg_basics.h',
        'agg23/agg_clip_liang_barsky.h',
        'agg23/agg_conv_dash.h',
        'agg23/agg_conv_stroke.h',
        'agg23/agg_curves.cpp',
        'agg23/agg_curves.h',
        'agg23/agg_path_storage.cpp',
        'agg23/agg_path_storage.h',
        'agg23/agg_rasterizer_scanline_aa.cpp',
        'agg23/agg_rasterizer_scanline_aa.h',
        'agg23/agg_renderer_scanline.h',
        'agg23/agg_rendering_buffer.h',
        'agg23/agg_scanline_u.h',
        'agg23/agg_vcgen_dash.cpp',
        'agg23/agg_vcgen_stroke.cpp',
      ],
      'conditions': [
        ['os_posix==1', {
          # library contains several enum vs non-enum conditionals.
          'cflags': [ '-Wno-extra', ],
        }],
      ],
    },
    {
      'target_name': 'fx_lcms2',
      'type': 'static_library',
      'sources': [
        'lcms2-2.6/include/lcms2.h',
        'lcms2-2.6/include/lcms2_plugin.h',
        'lcms2-2.6/src/cmscam02.c',
        'lcms2-2.6/src/cmscgats.c',
        'lcms2-2.6/src/cmscnvrt.c',
        'lcms2-2.6/src/cmserr.c',
        'lcms2-2.6/src/cmsgamma.c',
        'lcms2-2.6/src/cmsgmt.c',
        'lcms2-2.6/src/cmshalf.c',
        'lcms2-2.6/src/cmsintrp.c',
        'lcms2-2.6/src/cmsio0.c',
        'lcms2-2.6/src/cmsio1.c',
        'lcms2-2.6/src/cmslut.c',
        'lcms2-2.6/src/cmsmd5.c',
        'lcms2-2.6/src/cmsmtrx.c',
        'lcms2-2.6/src/cmsnamed.c',
        'lcms2-2.6/src/cmsopt.c',
        'lcms2-2.6/src/cmspack.c',
        'lcms2-2.6/src/cmspcs.c',
        'lcms2-2.6/src/cmsplugin.c',
        'lcms2-2.6/src/cmsps2.c',
        'lcms2-2.6/src/cmssamp.c',
        'lcms2-2.6/src/cmssm.c',
        'lcms2-2.6/src/cmstypes.c',
        'lcms2-2.6/src/cmsvirt.c',
        'lcms2-2.6/src/cmswtpnt.c',
        'lcms2-2.6/src/cmsxform.c',
      ],
      'conditions': [
        ['os_posix==1', {
          'cflags': [
            '-Wno-main',
            '-Wno-missing-braces',
            '-Wno-unused',
          ],
        }],
      ],
      'variables': {
        'clang_warning_flags': [
          '-Wno-missing-braces',
        ],
      },
    },
    {
      'target_name': 'fx_libjpeg',
      'type': 'static_library',
      'sources': [
        'libjpeg/cderror.h',
        'libjpeg/cdjpeg.h',
        'libjpeg/fpdfapi_jcapimin.c',
        'libjpeg/fpdfapi_jcapistd.c',
        'libjpeg/fpdfapi_jccoefct.c',
        'libjpeg/fpdfapi_jccolor.c',
        'libjpeg/fpdfapi_jcdctmgr.c',
        'libjpeg/fpdfapi_jchuff.c',
        'libjpeg/fpdfapi_jcinit.c',
        'libjpeg/fpdfapi_jcmainct.c',
        'libjpeg/fpdfapi_jcmarker.c',
        'libjpeg/fpdfapi_jcmaster.c',
        'libjpeg/fpdfapi_jcomapi.c',
        'libjpeg/fpdfapi_jcparam.c',
        'libjpeg/fpdfapi_jcphuff.c',
        'libjpeg/fpdfapi_jcprepct.c',
        'libjpeg/fpdfapi_jcsample.c',
        'libjpeg/fpdfapi_jctrans.c',
        'libjpeg/fpdfapi_jdapimin.c',
        'libjpeg/fpdfapi_jdapistd.c',
        'libjpeg/fpdfapi_jdcoefct.c',
        'libjpeg/fpdfapi_jdcolor.c',
        'libjpeg/fpdfapi_jddctmgr.c',
        'libjpeg/fpdfapi_jdhuff.c',
        'libjpeg/fpdfapi_jdinput.c',
        'libjpeg/fpdfapi_jdmainct.c',
        'libjpeg/fpdfapi_jdmarker.c',
        'libjpeg/fpdfapi_jdmaster.c',
        'libjpeg/fpdfapi_jdmerge.c',
        'libjpeg/fpdfapi_jdphuff.c',
        'libjpeg/fpdfapi_jdpostct.c',
        'libjpeg/fpdfapi_jdsample.c',
        'libjpeg/fpdfapi_jdtrans.c',
        'libjpeg/fpdfapi_jerror.c',
        'libjpeg/fpdfapi_jfdctfst.c',
        'libjpeg/fpdfapi_jfdctint.c',
        'libjpeg/fpdfapi_jidctfst.c',
        'libjpeg/fpdfapi_jidctint.c',
        'libjpeg/fpdfapi_jidctred.c',
        'libjpeg/fpdfapi_jmemmgr.c',
        'libjpeg/fpdfapi_jmemnobs.c',
        'libjpeg/fpdfapi_jutils.c',
        'libjpeg/jchuff.h',
        'libjpeg/jconfig.h',
        'libjpeg/jdct.h',
        'libjpeg/jdhuff.h',
        'libjpeg/jerror.h',
        'libjpeg/jinclude.h',
        'libjpeg/jmemsys.h',
        'libjpeg/jmorecfg.h',
        'libjpeg/jpegint.h',
        'libjpeg/jpeglib.h',
        'libjpeg/jversion.h',
        'libjpeg/transupp.h',
      ],
      'conditions': [
        ['os_posix==1', {
          'cflags': [
            '-Wno-main',
            '-Wno-missing-braces',
            '-Wno-unused',
          ],
        }],
      ],
    },
    {
      'target_name': 'fx_libopenjpeg',
      'type': 'static_library',
      'sources': [
        'libopenjpeg20/bio.c',
        'libopenjpeg20/cio.c',
        'libopenjpeg20/dwt.c',
        'libopenjpeg20/event.c',
        'libopenjpeg20/function_list.c',
        'libopenjpeg20/image.c',
        'libopenjpeg20/invert.c',
        'libopenjpeg20/j2k.c',
        'libopenjpeg20/jp2.c',
        'libopenjpeg20/mct.c',
        'libopenjpeg20/mqc.c',
        'libopenjpeg20/openjpeg.c',
        'libopenjpeg20/opj_clock.c',
        'libopenjpeg20/pi.c',
        'libopenjpeg20/raw.c',
        'libopenjpeg20/t1.c',
        'libopenjpeg20/t2.c',
        'libopenjpeg20/tcd.c',
        'libopenjpeg20/tgt.c',
      ],
    },
    {
      'target_name': 'fx_zlib',
      'type': 'static_library',
      'sources': [
        'zlib_v128/adler32.c',
        'zlib_v128/compress.c',
        'zlib_v128/crc32.c',
        'zlib_v128/deflate.c',
        'zlib_v128/gzclose.c',
        'zlib_v128/gzlib.c',
        'zlib_v128/gzread.c',
        'zlib_v128/gzwrite.c',
        'zlib_v128/infback.c',
        'zlib_v128/inffast.c',
        'zlib_v128/inflate.c',
        'zlib_v128/inftrees.c',
        'zlib_v128/trees.c',
        'zlib_v128/uncompr.c',
        'zlib_v128/zutil.c',
      ],
    },
    {
      'target_name': 'pdfium_base',
      'type': 'none',
      'sources': [
        'base/logging.h',
        'base/macros.h',
        'base/nonstd_unique_ptr.h',
        'base/template_util.h',
        'base/numerics/safe_conversions.h',
        'base/numerics/safe_conversions_impl.h',
        'base/numerics/safe_math.h',
        'base/numerics/safe_math_impl.h',
      ],
    },
  ],
}
