// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "base/hash.h"
#include "chrome_elf/dll_hash/dll_hash.h"

int DllNameToHash(std::string dll_name) {
  uint32 data = base::Hash(dll_name);

  // Strip off the signed bit because UMA doesn't support negative values,
  // but takes a signed int as input.
  return static_cast<int>(data & 0x7fffffff);
}
