/* Generated by wayland-scanner 1.11.0 */

#ifndef VSYNC_FEEDBACK_UNSTABLE_V1_SERVER_PROTOCOL_H
#define VSYNC_FEEDBACK_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_vsync_feedback_unstable_v1 The vsync_feedback_unstable_v1 protocol
 * Protocol for providing vertical synchronization timing
 *
 * @section page_desc_vsync_feedback_unstable_v1 Description
 *
 * This protocol specifies a set of interfaces used to inform the client about
 * vertical synchronization timing in a precise way and without unnecessary
 * overhead.
 *
 * Warning! The protocol described in this file is experimental and backward
 * incompatible changes may be made. Backward compatible changes may be added
 * together with the corresponding interface version bump. Backward
 * incompatible changes are done by bumping the version number in the protocol
 * and interface names and resetting the interface version. Once the protocol
 * is to be declared stable, the version number in the protocol is removed and
 * the interface version number is reset.
 *
 * @section page_ifaces_vsync_feedback_unstable_v1 Interfaces
 * - @subpage page_iface_zwp_vsync_feedback_v1 - Protocol for providing vertical synchronization timing
 * - @subpage page_iface_zwp_vsync_timing_v1 - 
 * @section page_copyright_vsync_feedback_unstable_v1 Copyright
 * <pre>
 *
 * Copyright 2016 The Chromium Authors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_output;
struct zwp_vsync_feedback_v1;
struct zwp_vsync_timing_v1;

/**
 * @page page_iface_zwp_vsync_feedback_v1 zwp_vsync_feedback_v1
 * @section page_iface_zwp_vsync_feedback_v1_desc Description
 *
 * The global interface that allows clients to subscribe for vertical
 * synchronization timing data for given wl_output.
 * @section page_iface_zwp_vsync_feedback_v1_api API
 * See @ref iface_zwp_vsync_feedback_v1.
 */
/**
 * @defgroup iface_zwp_vsync_feedback_v1 The zwp_vsync_feedback_v1 interface
 *
 * The global interface that allows clients to subscribe for vertical
 * synchronization timing data for given wl_output.
 */
extern const struct wl_interface zwp_vsync_feedback_v1_interface;
/**
 * @page page_iface_zwp_vsync_timing_v1 zwp_vsync_timing_v1
 * @section page_iface_zwp_vsync_timing_v1_api API
 * See @ref iface_zwp_vsync_timing_v1.
 */
/**
 * @defgroup iface_zwp_vsync_timing_v1 The zwp_vsync_timing_v1 interface
 */
extern const struct wl_interface zwp_vsync_timing_v1_interface;

/**
 * @ingroup iface_zwp_vsync_feedback_v1
 * @struct zwp_vsync_feedback_v1_interface
 */
struct zwp_vsync_feedback_v1_interface {
	/**
	 * destroy vsync feedback object
	 *
	 * Destroy this vsync feedback object. Existing vsync timing
	 * objects shall not be affected by this request.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * get vsync timing object for given wl_output
	 *
	 * Create a new vsync timing object that represents a
	 * subscription to vertical synchronization timing updates of given
	 * wl_output object.
	 *
	 * The newly created object will immediately signal an update to
	 * notify the subscriber of initial timing parameters.
	 * @param id the new vsync timing interface id
	 * @param output the wl_output object to subscribe for timings of
	 */
	void (*get_vsync_timing)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t id,
				 struct wl_resource *output);
};


/**
 * @ingroup iface_zwp_vsync_timing_v1
 * @struct zwp_vsync_timing_v1_interface
 */
struct zwp_vsync_timing_v1_interface {
	/**
	 * destroy vsync timing object
	 *
	 * Destroy this vsync timing object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_VSYNC_TIMING_V1_UPDATE	0

/**
 * @ingroup iface_zwp_vsync_timing_v1
 */
#define ZWP_VSYNC_TIMING_V1_UPDATE_SINCE_VERSION	1

/**
 * @ingroup iface_zwp_vsync_timing_v1
 * Sends an update event to the client owning the resource.
 * @param resource_ The client's resource
 * @param timebase_l new vsync timebase (lower 32 bits)
 * @param timebase_h new vsync timebase (upper 32 bits)
 * @param interval_l new vsync interval (lower 32 bits)
 * @param interval_h new vsync interval (upper 32 bits)
 */
static inline void
zwp_vsync_timing_v1_send_update(struct wl_resource *resource_, uint32_t timebase_l, uint32_t timebase_h, uint32_t interval_l, uint32_t interval_h)
{
	wl_resource_post_event(resource_, ZWP_VSYNC_TIMING_V1_UPDATE, timebase_l, timebase_h, interval_l, interval_h);
}

#ifdef  __cplusplus
}
#endif

#endif
