# Copyright 2013 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'brotli',
      'type': 'static_library',
      'include_dirs': [
        'dec',
      ],
      'sources': [
        'dec/bit_reader.c',
        'dec/bit_reader.h',
        'dec/context.h',
        'dec/decode.c',
        'dec/decode.h',
        'dec/dictionary.c',
        'dec/dictionary.h',
        'dec/huffman.c',
        'dec/huffman.h',
        'dec/port.h',
        'dec/prefix.h',
        'dec/state.c',
        'dec/state.h',
        'dec/transform.h',
        'dec/types.h',
      ],
      'conditions': [
        ['os_posix==1 and (target_arch=="arm" or target_arch=="armv7" or target_arch=="arm64")', {
          'cflags!': ['-Os'],
          'cflags': ['-O2'],
        }],
      ],
      'toolsets': ['host', 'target'],
    },
    {
      'target_name': 'bro',
      'type': 'executable',
      'dependencies': [
        'brotli',
      ],
      'sources': [
        'enc/backward_references.cc',
        'enc/backward_references.h',
        'enc/bit_cost.h',
        'enc/block_splitter.cc',
        'enc/block_splitter.h',
        'enc/brotli_bit_stream.cc',
        'enc/brotli_bit_stream.h',
        'enc/cluster.h',
        'enc/command.h',
        'enc/compress_fragment.cc',
        'enc/compress_fragment.h',
        'enc/compress_fragment_two_pass.cc',
        'enc/compress_fragment_two_pass.h',
        'enc/compressor.h',
        'enc/context.h',
        'enc/dictionary_hash.h',
        'enc/encode.cc',
        'enc/encode.h',
        'enc/encode_parallel.cc',
        'enc/encode_parallel.h',
        'enc/entropy_encode.cc',
        'enc/entropy_encode.h',
        'enc/entropy_encode_static.h',
        'enc/fast_log.h',
        'enc/find_match_length.h',
        'enc/hash.h ',
        'enc/histogram.cc',
        'enc/histogram.h',
        'enc/literal_cost.cc',
        'enc/literal_cost.h',
        'enc/metablock.cc',
        'enc/metablock.h',
        'enc/port.h ',
        'enc/prefix.h',
        'enc/ringbuffer.h',
        'enc/static_dict.cc',
        'enc/static_dict.h',
        'enc/static_dict_lut.h',
        'enc/streams.cc',
        'enc/streams.h',
        'enc/transform.h',
        'enc/types.h',
        'enc/utf8_util.cc',
        'enc/utf8_util.h',
        'enc/write_bits.h',
        'tools/bro.cc',
      ],
      'toolsets': ['host'],
      'conditions': [
        ['OS=="win" and MSVS_VERSION == "2015"', {
          # Disabling "result of 32-bit shift implicitly converted to 64 bits",
          # caused by code like: foo |= (1 << i);   // warning 4334
          'msvs_disabled_warnings': [ 4334, ],
        }],
      ],
    }
  ],
}
