// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_GPU_PROCESS_LAUNCH_CAUSES_H_
#define CONTENT_COMMON_GPU_PROCESS_LAUNCH_CAUSES_H_

namespace content {

// If you change this enum you also need to update
// tools/metrics/histograms/histograms.xml
enum CauseForGpuLaunch {
  // Start enum from 2 to keep the same values for the histogram.
  CAUSE_FOR_GPU_LAUNCH_GPUDATAMANAGER_REQUESTCOMPLETEGPUINFOIFNEEDED = 2,
  CAUSE_FOR_GPU_LAUNCH_RENDERWIDGETFULLSCREENPEPPER_CREATECONTEXT,
  // Deprecated
  // CAUSE_FOR_GPU_LAUNCH_WEBGRAPHICSCONTEXT3DCOMMANDBUFFERIMPL_INITIALIZE,
  CAUSE_FOR_GPU_LAUNCH_NO_LAUNCH = 4,
  CAUSE_FOR_GPU_LAUNCH_VIDEODECODEACCELERATOR_INITIALIZE,
  CAUSE_FOR_GPU_LAUNCH_PEPPERPLATFORMCONTEXT3DIMPL_INITIALIZE,
  CAUSE_FOR_GPU_LAUNCH_BROWSER_STARTUP,
  CAUSE_FOR_GPU_LAUNCH_CANVAS_2D,
  CAUSE_FOR_GPU_LAUNCH_PEPPERVIDEOENCODERACCELERATOR_INITIALIZE,
  CAUSE_FOR_GPU_LAUNCH_GPU_MEMORY_BUFFER_ALLOCATE,
  CAUSE_FOR_GPU_LAUNCH_JPEGDECODEACCELERATOR_INITIALIZE,
  CAUSE_FOR_GPU_LAUNCH_MOJO_SETUP,
  CAUSE_FOR_GPU_LAUNCH_GET_GPU_SERVICE_REGISTRY,
  CAUSE_FOR_GPU_LAUNCH_BROWSER_SHARED_MAIN_THREAD_CONTEXT,
  CAUSE_FOR_GPU_LAUNCH_RENDERER_SHARED_MAIN_THREAD_CONTEXT,
  CAUSE_FOR_GPU_LAUNCH_WEBGL_CONTEXT,
  CAUSE_FOR_GPU_LAUNCH_SHARED_WORKER_THREAD_CONTEXT,
  CAUSE_FOR_GPU_LAUNCH_RENDERER_VERIFY_GPU_COMPOSITING,
  CAUSE_FOR_GPU_LAUNCH_DISPLAY_COMPOSITOR_CONTEXT,
  CAUSE_FOR_GPU_LAUNCH_MEDIA_CONTEXT,

  // All new values should be inserted above this point so that
  // existing values continue to match up with those in histograms.xml.
  CAUSE_FOR_GPU_LAUNCH_MAX_ENUM
};

}  // namespace content

#endif  // CONTENT_COMMON_GPU_PROCESS_LAUNCH_CAUSES_H_
