
  Polymer({
    is: 'paper-icon-button',

    hostAttributes: {
      role: 'button',
      tabindex: '0'
    },

    behaviors: [
      Polymer.PaperInkyFocusBehavior
    ],

    properties: {
      /**
       * The URL of an image for the icon. If the src property is specified,
       * the icon property should not be.
       */
      src: {
        type: String
      },

      /**
       * Specifies the icon name or index in the set of icons available in
       * the icon's icon set. If the icon property is specified,
       * the src property should not be.
       */
      icon: {
        type: String
      },

      /**
       * Specifies the alternate text for the button, for accessibility.
       */
      alt: {
        type: String,
        observer: "_altChanged"
      }
    },

    _altChanged: function(newValue, oldValue) {
      var label = this.getAttribute('aria-label');

      // Don't stomp over a user-set aria-label.
      if (!label || oldValue == label) {
        this.setAttribute('aria-label', newValue);
      }
    }
  });
