

  Polymer.IronOverlayManager = (function() {

    var overlays = [];
    var DEFAULT_Z = 10;
    var backdrops = [];

    // track overlays for z-index and focus managemant
    function addOverlay(overlay) {
      var z0 = currentOverlayZ();
      overlays.push(overlay);
      var z1 = currentOverlayZ();
      if (z1 <= z0) {
        applyOverlayZ(overlay, z0);
      }
    }

    function removeOverlay(overlay) {
      var i = overlays.indexOf(overlay);
      if (i >= 0) {
        overlays.splice(i, 1);
        setZ(overlay, '');
      }
    }

    function applyOverlayZ(overlay, aboveZ) {
      setZ(overlay, aboveZ + 2);
    }

    function setZ(element, z) {
      element.style.zIndex = z;
    }

    function currentOverlay() {
      return overlays[overlays.length-1];
    }

    function currentOverlayZ() {
      var z;
      var current = currentOverlay();
      if (current) {
        var z1 = window.getComputedStyle(current).zIndex;
        if (!isNaN(z1)) {
          z = Number(z1);
        }
      }
      return z || DEFAULT_Z;
    }

    function focusOverlay() {
      var current = currentOverlay();
      // We have to be careful to focus the next overlay _after_ any current
      // transitions are complete (due to the state being toggled prior to the
      // transition). Otherwise, we risk infinite recursion when a transitioning
      // (closed) overlay becomes the current overlay.
      //
      // NOTE: We make the assumption that any overlay that completes a transition
      // will call into focusOverlay to kick the process back off. Currently:
      // transitionend -> _applyFocus -> focusOverlay.
      if (current && !current.transitioning) {
        current._applyFocus();
      }
    }

    function trackBackdrop(element) {
      // backdrops contains the overlays with a backdrop that are currently
      // visible
      if (element.opened) {
        backdrops.push(element);
      } else {
        var index = backdrops.indexOf(element);
        if (index >= 0) {
          backdrops.splice(index, 1);
        }
      }
    }

    function getBackdrops() {
      return backdrops;
    }

    return {
      addOverlay: addOverlay,
      removeOverlay: removeOverlay,
      currentOverlay: currentOverlay,
      currentOverlayZ: currentOverlayZ,
      focusOverlay: focusOverlay,
      trackBackdrop: trackBackdrop,
      getBackdrops: getBackdrops
    };

  })();

