{
  'includes': [
    '../core/core_generated.gypi',
    'modules_generated.gypi',
  ],
  'variables': {
    # Experimental hooks for embedder to provide extra IDL and source files.
    #
    # Note: this is not a supported API. If you rely on this, you will be broken
    # from time to time as the code generator changes in backward incompatible
    # ways.
    'extra_blink_module_idl_files': [],
    'extra_blink_module_files': [],
    # Files for which bindings (.cpp and .h files) will be generated
    'modules_idl_files': [
      '<@(extra_blink_module_idl_files)',
      'app_banner/AppBannerPromptResult.idl',
      'app_banner/BeforeInstallPromptEvent.idl',
      'background_sync/PeriodicSyncEvent.idl',
      'background_sync/PeriodicSyncManager.idl',
      'background_sync/PeriodicSyncRegistration.idl',
      'background_sync/SyncEvent.idl',
      'background_sync/SyncManager.idl',
      'background_sync/SyncRegistration.idl',
      'battery/BatteryManager.idl',
      'bluetooth/Bluetooth.idl',
      'bluetooth/BluetoothDevice.idl',
      'bluetooth/BluetoothGATTCharacteristic.idl',
      'bluetooth/BluetoothGATTRemoteServer.idl',
      'bluetooth/BluetoothGATTService.idl',
      'bluetooth/BluetoothUUID.idl',
      'cachestorage/Cache.idl',
      'cachestorage/CacheStorage.idl',
      'canvas2d/CanvasGradient.idl',
      'canvas2d/CanvasPattern.idl',
      'canvas2d/CanvasRenderingContext2D.idl',
      'canvas2d/Path2D.idl',
      'compositorworker/CompositorWorker.idl',
      'compositorworker/CompositorWorkerGlobalScope.idl',
      'credentialmanager/Credential.idl',
      'credentialmanager/CredentialsContainer.idl',
      'credentialmanager/FederatedCredential.idl',
      'credentialmanager/PasswordCredential.idl',
      'crypto/Crypto.idl',
      'crypto/CryptoKey.idl',
      'crypto/SubtleCrypto.idl',
      'device_light/DeviceLightEvent.idl',
      'device_orientation/DeviceAcceleration.idl',
      'device_orientation/DeviceMotionEvent.idl',
      'device_orientation/DeviceOrientationEvent.idl',
      'device_orientation/DeviceRotationRate.idl',
      'encoding/TextDecoder.idl',
      'encoding/TextEncoder.idl',
      'encryptedmedia/MediaEncryptedEvent.idl',
      'encryptedmedia/MediaKeyMessageEvent.idl',
      'encryptedmedia/MediaKeySession.idl',
      'encryptedmedia/MediaKeyStatusMap.idl',
      'encryptedmedia/MediaKeySystemAccess.idl',
      'encryptedmedia/MediaKeys.idl',
      'fetch/Body.idl',
      'fetch/Headers.idl',
      'fetch/Request.idl',
      'fetch/Response.idl',
      'filesystem/DOMFileSystem.idl',
      'filesystem/DOMFileSystemSync.idl',
      'filesystem/DirectoryEntry.idl',
      'filesystem/DirectoryEntrySync.idl',
      'filesystem/DirectoryReader.idl',
      'filesystem/DirectoryReaderSync.idl',
      'filesystem/EntriesCallback.idl',
      'filesystem/Entry.idl',
      'filesystem/EntryCallback.idl',
      'filesystem/EntrySync.idl',
      'filesystem/ErrorCallback.idl',
      'filesystem/FileCallback.idl',
      'filesystem/FileEntry.idl',
      'filesystem/FileEntrySync.idl',
      'filesystem/FileSystemCallback.idl',
      'filesystem/FileWriter.idl',
      'filesystem/FileWriterCallback.idl',
      'filesystem/FileWriterSync.idl',
      'filesystem/Metadata.idl',
      'filesystem/MetadataCallback.idl',
      'gamepad/Gamepad.idl',
      'gamepad/GamepadButton.idl',
      'gamepad/GamepadEvent.idl',
      'gamepad/GamepadList.idl',
      'geofencing/CircularGeofencingRegion.idl',
      'geofencing/Geofencing.idl',
      'geofencing/GeofencingEvent.idl',
      'geofencing/GeofencingRegion.idl',
      'geolocation/Coordinates.idl',
      'geolocation/Geolocation.idl',
      'geolocation/Geoposition.idl',
      'geolocation/PositionCallback.idl',
      'geolocation/PositionError.idl',
      'geolocation/PositionErrorCallback.idl',
      'indexeddb/IDBCursor.idl',
      'indexeddb/IDBCursorWithValue.idl',
      'indexeddb/IDBDatabase.idl',
      'indexeddb/IDBFactory.idl',
      'indexeddb/IDBIndex.idl',
      'indexeddb/IDBKeyRange.idl',
      'indexeddb/IDBObjectStore.idl',
      'indexeddb/IDBOpenDBRequest.idl',
      'indexeddb/IDBRequest.idl',
      'indexeddb/IDBTransaction.idl',
      'indexeddb/IDBVersionChangeEvent.idl',
      'mediasource/MediaSource.idl',
      'mediasource/SourceBuffer.idl',
      'mediasource/SourceBufferList.idl',
      'mediasource/TrackDefault.idl',
      'mediasource/TrackDefaultList.idl',
      'mediasource/VideoPlaybackQuality.idl',
      'mediasession/MediaSession.idl',
      'mediastream/MediaDeviceInfo.idl',
      'mediastream/MediaDevices.idl',
      'mediastream/MediaStream.idl',
      'mediastream/MediaStreamEvent.idl',
      'mediastream/MediaStreamTrack.idl',
      'mediastream/MediaStreamTrackEvent.idl',
      'mediastream/MediaStreamTrackSourcesCallback.idl',
      'mediastream/NavigatorUserMediaError.idl',
      'mediastream/NavigatorUserMediaErrorCallback.idl',
      'mediastream/NavigatorUserMediaSuccessCallback.idl',
      'mediastream/RTCDTMFSender.idl',
      'mediastream/RTCDTMFToneChangeEvent.idl',
      'mediastream/RTCDataChannel.idl',
      'mediastream/RTCDataChannelEvent.idl',
      'mediastream/RTCErrorCallback.idl',
      'mediastream/RTCIceCandidate.idl',
      'mediastream/RTCIceCandidateEvent.idl',
      'mediastream/RTCPeerConnection.idl',
      'mediastream/RTCSessionDescription.idl',
      'mediastream/RTCSessionDescriptionCallback.idl',
      'mediastream/RTCStatsCallback.idl',
      'mediastream/RTCStatsReport.idl',
      'mediastream/RTCStatsResponse.idl',
      'mediastream/SourceInfo.idl',
      'navigatorconnect/CrossOriginConnectEvent.idl',
      'navigatorconnect/CrossOriginServiceWorkerClient.idl',
      'navigatorconnect/ServicePort.idl',
      'navigatorconnect/ServicePortConnectEvent.idl',
      'navigatorconnect/ServicePortCollection.idl',
      'netinfo/NetworkInformation.idl',
      'notifications/Notification.idl',
      'notifications/NotificationEvent.idl',
      'notifications/NotificationPermissionCallback.idl',
      'permissions/Permissions.idl',
      'permissions/PermissionStatus.idl',
      'plugins/MimeType.idl',
      'plugins/MimeTypeArray.idl',
      'plugins/Plugin.idl',
      'plugins/PluginArray.idl',
      'presentation/DefaultSessionStartEvent.idl',
      'presentation/Presentation.idl',
      'presentation/PresentationAvailability.idl',
      'presentation/PresentationSession.idl',
      'push_messaging/PushEvent.idl',
      'push_messaging/PushManager.idl',
      'push_messaging/PushMessageData.idl',
      'push_messaging/PushSubscription.idl',
      'quota/DeprecatedStorageInfo.idl',
      'quota/DeprecatedStorageQuota.idl',
      'quota/StorageErrorCallback.idl',
      'quota/StorageInfo.idl',
      'quota/StorageQuota.idl',
      'quota/StorageQuotaCallback.idl',
      'quota/StorageUsageCallback.idl',
      'screen_orientation/ScreenOrientation.idl',
      'serviceworkers/Client.idl',
      'serviceworkers/Clients.idl',
      'serviceworkers/ExtendableEvent.idl',
      'serviceworkers/FetchEvent.idl',
      'serviceworkers/ServiceWorker.idl',
      'serviceworkers/ServiceWorkerContainer.idl',
      'serviceworkers/ServiceWorkerGlobalScope.idl',
      'serviceworkers/ServiceWorkerMessageEvent.idl',
      'serviceworkers/ServiceWorkerRegistration.idl',
      'serviceworkers/StashedMessagePort.idl',
      'serviceworkers/StashedPortCollection.idl',
      'serviceworkers/WindowClient.idl',
      'speech/SpeechGrammar.idl',
      'speech/SpeechGrammarList.idl',
      'speech/SpeechRecognition.idl',
      'speech/SpeechRecognitionAlternative.idl',
      'speech/SpeechRecognitionError.idl',
      'speech/SpeechRecognitionEvent.idl',
      'speech/SpeechRecognitionResult.idl',
      'speech/SpeechRecognitionResultList.idl',
      'speech/SpeechSynthesis.idl',
      'speech/SpeechSynthesisEvent.idl',
      'speech/SpeechSynthesisUtterance.idl',
      'speech/SpeechSynthesisVoice.idl',
      'storage/Storage.idl',
      'storage/StorageEvent.idl',
      'vr/HMDVRDevice.idl',
      'vr/PositionSensorVRDevice.idl',
      'vr/VRDevice.idl',
      'vr/VREyeParameters.idl',
      'vr/VRFieldOfView.idl',
      'vr/VRPositionState.idl',
      'webaudio/AnalyserNode.idl',
      'webaudio/AudioBuffer.idl',
      'webaudio/AudioBufferCallback.idl',
      'webaudio/AudioBufferSourceNode.idl',
      'webaudio/AudioContext.idl',
      'webaudio/AudioDestinationNode.idl',
      'webaudio/AudioListener.idl',
      'webaudio/AudioNode.idl',
      'webaudio/AudioParam.idl',
      'webaudio/AudioProcessingEvent.idl',
      'webaudio/AudioSourceNode.idl',
      'webaudio/BiquadFilterNode.idl',
      'webaudio/ChannelMergerNode.idl',
      'webaudio/ChannelSplitterNode.idl',
      'webaudio/ConvolverNode.idl',
      'webaudio/DelayNode.idl',
      'webaudio/DynamicsCompressorNode.idl',
      'webaudio/GainNode.idl',
      'webaudio/MediaElementAudioSourceNode.idl',
      'webaudio/MediaStreamAudioDestinationNode.idl',
      'webaudio/MediaStreamAudioSourceNode.idl',
      'webaudio/OfflineAudioCompletionEvent.idl',
      'webaudio/OfflineAudioContext.idl',
      'webaudio/OscillatorNode.idl',
      'webaudio/PannerNode.idl',
      'webaudio/PeriodicWave.idl',
      'webaudio/ScriptProcessorNode.idl',
      'webaudio/StereoPannerNode.idl',
      'webaudio/WaveShaperNode.idl',
      'webdatabase/Database.idl',
      'webdatabase/DatabaseCallback.idl',
      'webdatabase/SQLError.idl',
      'webdatabase/SQLResultSet.idl',
      'webdatabase/SQLResultSetRowList.idl',
      'webdatabase/SQLStatementCallback.idl',
      'webdatabase/SQLStatementErrorCallback.idl',
      'webdatabase/SQLTransaction.idl',
      'webdatabase/SQLTransactionCallback.idl',
      'webdatabase/SQLTransactionErrorCallback.idl',
      'webgl/ANGLEInstancedArrays.idl',
      'webgl/CHROMIUMSubscribeUniform.idl',
      'webgl/CHROMIUMValuebuffer.idl',
      'webgl/EXTBlendMinMax.idl',
      'webgl/EXTFragDepth.idl',
      'webgl/EXTShaderTextureLOD.idl',
      'webgl/EXTTextureFilterAnisotropic.idl',
      'webgl/EXTsRGB.idl',
      'webgl/OESElementIndexUint.idl',
      'webgl/OESStandardDerivatives.idl',
      'webgl/OESTextureFloat.idl',
      'webgl/OESTextureFloatLinear.idl',
      'webgl/OESTextureHalfFloat.idl',
      'webgl/OESTextureHalfFloatLinear.idl',
      'webgl/OESVertexArrayObject.idl',
      'webgl/WebGL2RenderingContext.idl',
      'webgl/WebGLActiveInfo.idl',
      'webgl/WebGLBuffer.idl',
      'webgl/WebGLCompressedTextureATC.idl',
      'webgl/WebGLCompressedTextureETC1.idl',
      'webgl/WebGLCompressedTexturePVRTC.idl',
      'webgl/WebGLCompressedTextureS3TC.idl',
      'webgl/WebGLContextEvent.idl',
      'webgl/WebGLDebugRendererInfo.idl',
      'webgl/WebGLDebugShaders.idl',
      'webgl/WebGLDepthTexture.idl',
      'webgl/WebGLDrawBuffers.idl',
      'webgl/WebGLFramebuffer.idl',
      'webgl/WebGLLoseContext.idl',
      'webgl/WebGLProgram.idl',
      'webgl/WebGLQuery.idl',
      'webgl/WebGLRenderbuffer.idl',
      'webgl/WebGLRenderingContext.idl',
      'webgl/WebGLSampler.idl',
      'webgl/WebGLShader.idl',
      'webgl/WebGLShaderPrecisionFormat.idl',
      'webgl/WebGLSync.idl',
      'webgl/WebGLTexture.idl',
      'webgl/WebGLTransformFeedback.idl',
      'webgl/WebGLUniformLocation.idl',
      'webgl/WebGLVertexArrayObject.idl',
      'webgl/WebGLVertexArrayObjectOES.idl',
      'webmidi/MIDIAccess.idl',
      'webmidi/MIDIConnectionEvent.idl',
      'webmidi/MIDIInput.idl',
      'webmidi/MIDIInputMap.idl',
      'webmidi/MIDIMessageEvent.idl',
      'webmidi/MIDIOutput.idl',
      'webmidi/MIDIOutputMap.idl',
      'webmidi/MIDIPort.idl',
      'websockets/CloseEvent.idl',
      'websockets/WebSocket.idl',
    ],
    # 'partial interface' or target (right side of) 'implements'
    'modules_dependency_idl_files': [
      'audio_output_devices/HTMLMediaElementAudioOutputDevice.idl',
      'background_sync/ServiceWorkerGlobalScopeSync.idl',
      'background_sync/ServiceWorkerRegistrationSync.idl',
      'battery/NavigatorBattery.idl',
      'beacon/NavigatorBeacon.idl',
      'bluetooth/NavigatorBluetooth.idl',
      'cachestorage/WindowCacheStorage.idl',
      'cachestorage/WorkerCacheStorage.idl',
      'canvas2d/CanvasPathMethods.idl',
      'canvas2d/MouseEventHitRegion.idl',
      'credentialmanager/NavigatorCredentials.idl',
      'crypto/WindowCrypto.idl',
      'crypto/WorkerGlobalScopeCrypto.idl',
      'device_light/WindowDeviceLight.idl',
      'device_orientation/WindowDeviceMotion.idl',
      'device_orientation/WindowDeviceOrientation.idl',
      'donottrack/NavigatorDoNotTrack.idl',
      'encryptedmedia/HTMLMediaElementEncryptedMedia.idl',
      'encryptedmedia/NavigatorRequestMediaKeySystemAccess.idl',
      'fetch/WindowFetch.idl',
      'fetch/WorkerFetch.idl',
      'filesystem/DataTransferItemFileSystem.idl',
      'filesystem/DevToolsHostFileSystem.idl',
      'filesystem/HTMLInputElementFileSystem.idl',
      'filesystem/WindowFileSystem.idl',
      'filesystem/WorkerGlobalScopeFileSystem.idl',
      'gamepad/NavigatorGamepad.idl',
      'geofencing/ServiceWorkerGlobalScopeGeofencing.idl',
      'geofencing/ServiceWorkerRegistrationGeofencing.idl',
      'geofencing/WorkerNavigatorGeofencing.idl',
      'geolocation/NavigatorGeolocation.idl',
      'imagebitmap/WindowImageBitmapFactories.idl',
      'indexeddb/WindowIndexedDatabase.idl',
      'indexeddb/WorkerGlobalScopeIndexedDatabase.idl',
      'mediasession/HTMLMediaElementMediaSession.idl',
      'mediasource/HTMLVideoElementMediaSource.idl',
      'mediasource/URLMediaSource.idl',
      'mediastream/NavigatorMediaStream.idl',
      'mediastream/NavigatorUserMedia.idl',
      'mediastream/URLMediaStream.idl',
      'mediastream/WindowMediaStream.idl',
      'navigatorconnect/NavigatorServices.idl',
      'navigatorconnect/ServiceWorkerGlobalScopeNavigatorConnect.idl',
      'navigatorconnect/WorkerNavigatorServices.idl',
      'navigatorcontentutils/NavigatorContentUtils.idl',
      'netinfo/NavigatorNetworkInformation.idl',
      'netinfo/WorkerNavigatorNetworkInformation.idl',
      'notifications/ServiceWorkerGlobalScopeNotifications.idl',
      'notifications/ServiceWorkerRegistrationNotifications.idl',
      'permissions/NavigatorPermissions.idl',
      'permissions/WorkerNavigatorPermissions.idl',
      'plugins/NavigatorPlugins.idl',
      'presentation/NavigatorPresentation.idl',
      'push_messaging/ServiceWorkerGlobalScopePush.idl',
      'push_messaging/ServiceWorkerRegistrationPush.idl',
      'quota/NavigatorStorageQuota.idl',
      'quota/WindowQuota.idl',
      'quota/WorkerNavigatorStorageQuota.idl',
      'screen_orientation/ScreenScreenOrientation.idl',
      'serviceworkers/NavigatorServiceWorker.idl',
      'speech/WindowSpeech.idl',
      'speech/WindowSpeechSynthesis.idl',
      'storage/WindowStorage.idl',
      'vibration/NavigatorVibration.idl',
      'vr/NavigatorVRDevice.idl',
      'webaudio/WindowWebAudio.idl',
      'webdatabase/WindowWebDatabase.idl',
      'webgl/WebGL2RenderingContextBase.idl',
      'webgl/WebGLRenderingContextBase.idl',
      'webmidi/NavigatorWebMIDI.idl',
    ],
    # interfaces that inherit from Event
    'modules_event_idl_files': [
      'app_banner/BeforeInstallPromptEvent.idl',
      'background_sync/PeriodicSyncEvent.idl',
      'background_sync/SyncEvent.idl',
      'device_light/DeviceLightEvent.idl',
      'device_orientation/DeviceMotionEvent.idl',
      'device_orientation/DeviceOrientationEvent.idl',
      'encryptedmedia/MediaEncryptedEvent.idl',
      'encryptedmedia/MediaKeyMessageEvent.idl',
      'gamepad/GamepadEvent.idl',
      'geofencing/GeofencingEvent.idl',
      'indexeddb/IDBVersionChangeEvent.idl',
      'mediastream/MediaStreamEvent.idl',
      'mediastream/MediaStreamTrackEvent.idl',
      'mediastream/RTCDTMFToneChangeEvent.idl',
      'mediastream/RTCDataChannelEvent.idl',
      'mediastream/RTCIceCandidateEvent.idl',
      'navigatorconnect/CrossOriginConnectEvent.idl',
      'navigatorconnect/ServicePortConnectEvent.idl',
      'notifications/NotificationEvent.idl',
      'presentation/DefaultSessionStartEvent.idl',
      'push_messaging/PushEvent.idl',
      'serviceworkers/ExtendableEvent.idl',
      'serviceworkers/FetchEvent.idl',
      'serviceworkers/ServiceWorkerMessageEvent.idl',
      'speech/SpeechRecognitionError.idl',
      'speech/SpeechRecognitionEvent.idl',
      'speech/SpeechSynthesisEvent.idl',
      'storage/StorageEvent.idl',
      'webaudio/AudioProcessingEvent.idl',
      'webaudio/OfflineAudioCompletionEvent.idl',
      'webgl/WebGLContextEvent.idl',
      'webmidi/MIDIConnectionEvent.idl',
      'webmidi/MIDIMessageEvent.idl',
      'websockets/CloseEvent.idl',
    ],
    'modules_dictionary_idl_files': [
      'app_banner/BeforeInstallPromptEventInit.idl',
      'background_sync/PeriodicSyncEventInit.idl',
      'background_sync/PeriodicSyncRegistrationOptions.idl',
      'background_sync/SyncEventInit.idl',
      'background_sync/SyncRegistrationOptions.idl',
      'bluetooth/BluetoothScanFilter.idl',
      'bluetooth/RequestDeviceOptions.idl',
      'cachestorage/CacheQueryOptions.idl',
      'canvas2d/Canvas2DContextAttributes.idl',
      'canvas2d/HitRegionOptions.idl',
      'credentialmanager/CredentialData.idl',
      'credentialmanager/CredentialRequestOptions.idl',
      'credentialmanager/FederatedCredentialData.idl',
      'credentialmanager/FederatedCredentialRequestOptions.idl',
      'credentialmanager/LocallyStoredCredentialData.idl',
      'credentialmanager/PasswordCredentialData.idl',
      'device_light/DeviceLightEventInit.idl',
      'encoding/TextDecodeOptions.idl',
      'encoding/TextDecoderOptions.idl',
      'encryptedmedia/MediaEncryptedEventInit.idl',
      'encryptedmedia/MediaKeyMessageEventInit.idl',
      'encryptedmedia/MediaKeySystemConfiguration.idl',
      'encryptedmedia/MediaKeySystemMediaCapability.idl',
      'filesystem/FileSystemFlags.idl',
      'gamepad/GamepadEventInit.idl',
      'geofencing/CircularGeofencingRegionInit.idl',
      'geolocation/PositionOptions.idl',
      'indexeddb/IDBIndexParameters.idl',
      'indexeddb/IDBObjectStoreParameters.idl',
      'indexeddb/IDBVersionChangeEventInit.idl',
      'mediastream/MediaStreamEventInit.idl',
      'mediastream/RTCDTMFToneChangeEventInit.idl',
      'mediastream/RTCIceCandidateInit.idl',
      'mediastream/RTCSessionDescriptionInit.idl',
      'navigatorconnect/ServicePortConnectEventInit.idl',
      'navigatorconnect/ServicePortConnectOptions.idl',
      'navigatorconnect/ServicePortConnectResponse.idl',
      'navigatorconnect/ServicePortMatchOptions.idl',
      'notifications/GetNotificationOptions.idl',
      'notifications/NotificationEventInit.idl',
      'notifications/NotificationOptions.idl',
      'permissions/MidiPermissionDescriptor.idl',
      'permissions/PermissionDescriptor.idl',
      'permissions/PushPermissionDescriptor.idl',
      'presentation/DefaultSessionStartEventInit.idl',
      'push_messaging/PushEventInit.idl',
      'push_messaging/PushSubscriptionOptions.idl',
      'serviceworkers/ClientQueryOptions.idl',
      'serviceworkers/ExtendableEventInit.idl',
      'serviceworkers/FetchEventInit.idl',
      'serviceworkers/RegistrationOptions.idl',
      'serviceworkers/ServiceWorkerMessageEventInit.idl',
      'speech/SpeechRecognitionErrorInit.idl',
      'speech/SpeechRecognitionEventInit.idl',
      'storage/StorageEventInit.idl',
      'vr/VRFieldOfViewInit.idl',
      'webgl/WebGLContextAttributes.idl',
      'webgl/WebGLContextEventInit.idl',
      'webmidi/MIDIConnectionEventInit.idl',
      'webmidi/MIDIMessageEventInit.idl',
      'webmidi/MIDIOptions.idl',
      'websockets/CloseEventInit.idl',
    ],
    'generated_modules_files': [
      # .cpp files from make_modules_generated actions.
      '<(blink_modules_output_dir)/EventModules.cpp',
      '<(blink_modules_output_dir)/EventModulesHeaders.h',
      '<(blink_modules_output_dir)/EventModulesNames.cpp',
      '<(blink_modules_output_dir)/EventModulesNames.h',
      '<(blink_modules_output_dir)/EventTargetModulesNames.cpp',
      '<(blink_modules_output_dir)/EventTargetModulesNames.h',
      '<(blink_modules_output_dir)/IndexedDBNames.cpp',
      '<(blink_modules_output_dir)/IndexedDBNames.h',
    ],
    'generated_modules_dictionary_files': [
      '<(blink_modules_output_dir)/app_banner/BeforeInstallPromptEventInit.cpp',
      '<(blink_modules_output_dir)/app_banner/BeforeInstallPromptEventInit.h',
      '<(blink_modules_output_dir)/background_sync/PeriodicSyncEventInit.cpp',
      '<(blink_modules_output_dir)/background_sync/PeriodicSyncEventInit.h',
      '<(blink_modules_output_dir)/background_sync/PeriodicSyncRegistrationOptions.cpp',
      '<(blink_modules_output_dir)/background_sync/PeriodicSyncRegistrationOptions.h',
      '<(blink_modules_output_dir)/background_sync/SyncEventInit.cpp',
      '<(blink_modules_output_dir)/background_sync/SyncEventInit.h',
      '<(blink_modules_output_dir)/background_sync/SyncRegistrationOptions.cpp',
      '<(blink_modules_output_dir)/background_sync/SyncRegistrationOptions.h',
      '<(blink_modules_output_dir)/bluetooth/BluetoothScanFilter.cpp',
      '<(blink_modules_output_dir)/bluetooth/RequestDeviceOptions.cpp',
      '<(blink_modules_output_dir)/cachestorage/CacheQueryOptions.cpp',
      '<(blink_modules_output_dir)/cachestorage/CacheQueryOptions.h',
      '<(blink_modules_output_dir)/canvas2d/Canvas2DContextAttributes.cpp',
      '<(blink_modules_output_dir)/canvas2d/Canvas2DContextAttributes.h',
      '<(blink_modules_output_dir)/canvas2d/HitRegionOptions.cpp',
      '<(blink_modules_output_dir)/canvas2d/HitRegionOptions.h',
      '<(blink_modules_output_dir)/credentialmanager/CredentialData.cpp',
      '<(blink_modules_output_dir)/credentialmanager/CredentialData.h',
      '<(blink_modules_output_dir)/credentialmanager/CredentialRequestOptions.cpp',
      '<(blink_modules_output_dir)/credentialmanager/CredentialRequestOptions.h',
      '<(blink_modules_output_dir)/credentialmanager/FederatedCredentialData.cpp',
      '<(blink_modules_output_dir)/credentialmanager/FederatedCredentialData.h',
      '<(blink_modules_output_dir)/credentialmanager/FederatedCredentialRequestOptions.cpp',
      '<(blink_modules_output_dir)/credentialmanager/FederatedCredentialRequestOptions.h',
      '<(blink_modules_output_dir)/credentialmanager/LocallyStoredCredentialData.cpp',
      '<(blink_modules_output_dir)/credentialmanager/LocallyStoredCredentialData.h',
      '<(blink_modules_output_dir)/credentialmanager/PasswordCredentialData.cpp',
      '<(blink_modules_output_dir)/credentialmanager/PasswordCredentialData.h',
      '<(blink_modules_output_dir)/device_light/DeviceLightEventInit.cpp',
      '<(blink_modules_output_dir)/device_light/DeviceLightEventInit.h',
      '<(blink_modules_output_dir)/encoding/TextDecodeOptions.cpp',
      '<(blink_modules_output_dir)/encoding/TextDecodeOptions.h',
      '<(blink_modules_output_dir)/encoding/TextDecoderOptions.cpp',
      '<(blink_modules_output_dir)/encoding/TextDecoderOptions.h',
      '<(blink_modules_output_dir)/encryptedmedia/MediaEncryptedEventInit.cpp',
      '<(blink_modules_output_dir)/encryptedmedia/MediaEncryptedEventInit.h',
      '<(blink_modules_output_dir)/encryptedmedia/MediaKeyMessageEventInit.cpp',
      '<(blink_modules_output_dir)/encryptedmedia/MediaKeyMessageEventInit.h',
      '<(blink_modules_output_dir)/encryptedmedia/MediaKeySystemConfiguration.cpp',
      '<(blink_modules_output_dir)/encryptedmedia/MediaKeySystemConfiguration.h',
      '<(blink_modules_output_dir)/encryptedmedia/MediaKeySystemMediaCapability.cpp',
      '<(blink_modules_output_dir)/encryptedmedia/MediaKeySystemMediaCapability.h',
      '<(blink_modules_output_dir)/filesystem/FileSystemFlags.cpp',
      '<(blink_modules_output_dir)/filesystem/FileSystemFlags.h',
      '<(blink_modules_output_dir)/gamepad/GamepadEventInit.cpp',
      '<(blink_modules_output_dir)/gamepad/GamepadEventInit.h',
      '<(blink_modules_output_dir)/geofencing/CircularGeofencingRegionInit.cpp',
      '<(blink_modules_output_dir)/geofencing/CircularGeofencingRegionInit.h',
      '<(blink_modules_output_dir)/geolocation/PositionOptions.cpp',
      '<(blink_modules_output_dir)/geolocation/PositionOptions.h',
      '<(blink_modules_output_dir)/indexeddb/IDBIndexParameters.cpp',
      '<(blink_modules_output_dir)/indexeddb/IDBIndexParameters.h',
      '<(blink_modules_output_dir)/indexeddb/IDBObjectStoreParameters.cpp',
      '<(blink_modules_output_dir)/indexeddb/IDBObjectStoreParameters.h',
      '<(blink_modules_output_dir)/indexeddb/IDBVersionChangeEventInit.cpp',
      '<(blink_modules_output_dir)/indexeddb/IDBVersionChangeEventInit.h',
      '<(blink_modules_output_dir)/mediastream/MediaStreamEventInit.cpp',
      '<(blink_modules_output_dir)/mediastream/MediaStreamEventInit.h',
      '<(blink_modules_output_dir)/mediastream/RTCDTMFToneChangeEventInit.cpp',
      '<(blink_modules_output_dir)/mediastream/RTCDTMFToneChangeEventInit.h',
      '<(blink_modules_output_dir)/mediastream/RTCIceCandidateInit.cpp',
      '<(blink_modules_output_dir)/mediastream/RTCIceCandidateInit.h',
      '<(blink_modules_output_dir)/mediastream/RTCSessionDescriptionInit.cpp',
      '<(blink_modules_output_dir)/mediastream/RTCSessionDescriptionInit.h',
      '<(blink_modules_output_dir)/navigatorconnect/ServicePortConnectEventInit.cpp',
      '<(blink_modules_output_dir)/navigatorconnect/ServicePortConnectEventInit.h',
      '<(blink_modules_output_dir)/navigatorconnect/ServicePortConnectOptions.cpp',
      '<(blink_modules_output_dir)/navigatorconnect/ServicePortConnectOptions.h',
      '<(blink_modules_output_dir)/navigatorconnect/ServicePortConnectResponse.cpp',
      '<(blink_modules_output_dir)/navigatorconnect/ServicePortConnectResponse.h',
      '<(blink_modules_output_dir)/navigatorconnect/ServicePortMatchOptions.cpp',
      '<(blink_modules_output_dir)/navigatorconnect/ServicePortMatchOptions.h',
      '<(blink_modules_output_dir)/notifications/GetNotificationOptions.cpp',
      '<(blink_modules_output_dir)/notifications/GetNotificationOptions.h',
      '<(blink_modules_output_dir)/notifications/NotificationEventInit.cpp',
      '<(blink_modules_output_dir)/notifications/NotificationEventInit.h',
      '<(blink_modules_output_dir)/notifications/NotificationOptions.cpp',
      '<(blink_modules_output_dir)/notifications/NotificationOptions.h',
      '<(blink_modules_output_dir)/permissions/MidiPermissionDescriptor.cpp',
      '<(blink_modules_output_dir)/permissions/MidiPermissionDescriptor.h',
      '<(blink_modules_output_dir)/permissions/PermissionDescriptor.cpp',
      '<(blink_modules_output_dir)/permissions/PermissionDescriptor.h',
      '<(blink_modules_output_dir)/permissions/PushPermissionDescriptor.cpp',
      '<(blink_modules_output_dir)/permissions/PushPermissionDescriptor.h',
      '<(blink_modules_output_dir)/presentation/DefaultSessionStartEventInit.cpp',
      '<(blink_modules_output_dir)/presentation/DefaultSessionStartEventInit.h',
      '<(blink_modules_output_dir)/push_messaging/PushEventInit.cpp',
      '<(blink_modules_output_dir)/push_messaging/PushEventInit.h',
      '<(blink_modules_output_dir)/push_messaging/PushSubscriptionOptions.cpp',
      '<(blink_modules_output_dir)/push_messaging/PushSubscriptionOptions.h',
      '<(blink_modules_output_dir)/serviceworkers/ClientQueryOptions.cpp',
      '<(blink_modules_output_dir)/serviceworkers/ClientQueryOptions.h',
      '<(blink_modules_output_dir)/serviceworkers/ExtendableEventInit.cpp',
      '<(blink_modules_output_dir)/serviceworkers/ExtendableEventInit.h',
      '<(blink_modules_output_dir)/serviceworkers/FetchEventInit.cpp',
      '<(blink_modules_output_dir)/serviceworkers/FetchEventInit.h',
      '<(blink_modules_output_dir)/serviceworkers/RegistrationOptions.cpp',
      '<(blink_modules_output_dir)/serviceworkers/RegistrationOptions.h',
      '<(blink_modules_output_dir)/serviceworkers/ServiceWorkerMessageEventInit.cpp',
      '<(blink_modules_output_dir)/serviceworkers/ServiceWorkerMessageEventInit.h',
      '<(blink_modules_output_dir)/speech/SpeechRecognitionErrorInit.cpp',
      '<(blink_modules_output_dir)/speech/SpeechRecognitionErrorInit.h',
      '<(blink_modules_output_dir)/speech/SpeechRecognitionEventInit.cpp',
      '<(blink_modules_output_dir)/speech/SpeechRecognitionEventInit.h',
      '<(blink_modules_output_dir)/storage/StorageEventInit.cpp',
      '<(blink_modules_output_dir)/storage/StorageEventInit.h',
      '<(blink_modules_output_dir)/vr/VRFieldOfViewInit.cpp',
      '<(blink_modules_output_dir)/vr/VRFieldOfViewInit.h',
      '<(blink_modules_output_dir)/webgl/WebGLContextAttributes.cpp',
      '<(blink_modules_output_dir)/webgl/WebGLContextAttributes.h',
      '<(blink_modules_output_dir)/webgl/WebGLContextEventInit.cpp',
      '<(blink_modules_output_dir)/webgl/WebGLContextEventInit.h',
      '<(blink_modules_output_dir)/webmidi/MIDIConnectionEventInit.cpp',
      '<(blink_modules_output_dir)/webmidi/MIDIConnectionEventInit.h',
      '<(blink_modules_output_dir)/webmidi/MIDIMessageEventInit.h',
      '<(blink_modules_output_dir)/webmidi/MIDIMessageEventInit.cpp',
      '<(blink_modules_output_dir)/webmidi/MIDIOptions.cpp',
      '<(blink_modules_output_dir)/webmidi/MIDIOptions.h',
      '<(blink_modules_output_dir)/websockets/CloseEventInit.cpp',
      '<(blink_modules_output_dir)/websockets/CloseEventInit.h',
    ],
    'modules_files': [
      '<@(extra_blink_module_files)',
      '<@(generated_modules_dictionary_files)',
      '<@(generated_modules_files)',
      'InitModules.cpp',
      'InitModules.h',
      'accessibility/AXARIAGrid.cpp',
      'accessibility/AXARIAGrid.h',
      'accessibility/AXARIAGridCell.cpp',
      'accessibility/AXARIAGridCell.h',
      'accessibility/AXARIAGridRow.cpp',
      'accessibility/AXARIAGridRow.h',
      'accessibility/AXImageMapLink.cpp',
      'accessibility/AXImageMapLink.h',
      'accessibility/AXInlineTextBox.cpp',
      'accessibility/AXInlineTextBox.h',
      'accessibility/AXLayoutObject.cpp',
      'accessibility/AXLayoutObject.h',
      'accessibility/AXList.cpp',
      'accessibility/AXList.h',
      'accessibility/AXListBox.cpp',
      'accessibility/AXListBox.h',
      'accessibility/AXListBoxOption.cpp',
      'accessibility/AXListBoxOption.h',
      'accessibility/AXMediaControls.cpp',
      'accessibility/AXMediaControls.h',
      'accessibility/AXMenuList.cpp',
      'accessibility/AXMenuList.h',
      'accessibility/AXMenuListOption.cpp',
      'accessibility/AXMenuListOption.h',
      'accessibility/AXMenuListPopup.cpp',
      'accessibility/AXMenuListPopup.h',
      'accessibility/AXMockObject.cpp',
      'accessibility/AXMockObject.h',
      'accessibility/AXNodeObject.cpp',
      'accessibility/AXNodeObject.h',
      'accessibility/AXObjectCacheImpl.cpp',
      'accessibility/AXObjectCacheImpl.h',
      'accessibility/AXObject.cpp',
      'accessibility/AXObject.h',
      'accessibility/AXProgressIndicator.cpp',
      'accessibility/AXProgressIndicator.h',
      'accessibility/AXSVGRoot.cpp',
      'accessibility/AXSVGRoot.h',
      'accessibility/AXScrollView.cpp',
      'accessibility/AXScrollView.h',
      'accessibility/AXScrollbar.cpp',
      'accessibility/AXScrollbar.h',
      'accessibility/AXSlider.cpp',
      'accessibility/AXSlider.h',
      'accessibility/AXSpinButton.cpp',
      'accessibility/AXSpinButton.h',
      'accessibility/AXTable.cpp',
      'accessibility/AXTable.h',
      'accessibility/AXTableCell.cpp',
      'accessibility/AXTableCell.h',
      'accessibility/AXTableColumn.cpp',
      'accessibility/AXTableColumn.h',
      'accessibility/AXTableHeaderContainer.cpp',
      'accessibility/AXTableHeaderContainer.h',
      'accessibility/AXTableRow.cpp',
      'accessibility/AXTableRow.h',
      'accessibility/InspectorAccessibilityAgent.cpp',
      'accessibility/InspectorAccessibilityAgent.h',
      'accessibility/InspectorTypeBuilderHelper.cpp',
      'accessibility/InspectorTypeBuilderHelper.h',
      'app_banner/AppBannerCallbacks.cpp',
      'app_banner/AppBannerCallbacks.h',
      'app_banner/AppBannerController.cpp',
      'app_banner/AppBannerController.h',
      'app_banner/AppBannerPromptResult.cpp',
      'app_banner/AppBannerPromptResult.h',
      'app_banner/BeforeInstallPromptEvent.cpp',
      'app_banner/BeforeInstallPromptEvent.h',
      'audio_output_devices/HTMLMediaElementAudioOutputDevice.cpp',
      'audio_output_devices/HTMLMediaElementAudioOutputDevice.h',
      'audio_output_devices/SetSinkIdCallbacks.cpp',
      'audio_output_devices/SetSinkIdCallbacks.h',
      'background_sync/PeriodicSyncEvent.cpp',
      'background_sync/PeriodicSyncEvent.h',
      'background_sync/PeriodicSyncManager.cpp',
      'background_sync/PeriodicSyncManager.h',
      'background_sync/PeriodicSyncRegistration.cpp',
      'background_sync/PeriodicSyncRegistration.h',
      'background_sync/ServiceWorkerGlobalScopeSync.h',
      'background_sync/ServiceWorkerRegistrationSync.cpp',
      'background_sync/ServiceWorkerRegistrationSync.h',
      'background_sync/SyncCallbacks.cpp',
      'background_sync/SyncCallbacks.h',
      'background_sync/SyncError.cpp',
      'background_sync/SyncError.h',
      'background_sync/SyncEvent.cpp',
      'background_sync/SyncEvent.h',
      'background_sync/SyncManager.cpp',
      'background_sync/SyncManager.h',
      'background_sync/SyncRegistration.cpp',
      'background_sync/SyncRegistration.h',
      'battery/BatteryDispatcher.cpp',
      'battery/BatteryDispatcher.h',
      'battery/BatteryManager.cpp',
      'battery/BatteryManager.h',
      'battery/BatteryStatus.cpp',
      'battery/BatteryStatus.h',
      'battery/NavigatorBattery.cpp',
      'battery/NavigatorBattery.h',
      'beacon/NavigatorBeacon.cpp',
      'beacon/NavigatorBeacon.h',
      'bluetooth/Bluetooth.h',
      'bluetooth/ConvertWebVectorToArrayBuffer.cpp',
      'bluetooth/ConvertWebVectorToArrayBuffer.h',
      'bluetooth/Bluetooth.cpp',
      'bluetooth/BluetoothDevice.cpp',
      'bluetooth/BluetoothDevice.h',
      'bluetooth/BluetoothError.cpp',
      'bluetooth/BluetoothError.h',
      'bluetooth/BluetoothGATTCharacteristic.cpp',
      'bluetooth/BluetoothGATTCharacteristic.h',
      'bluetooth/BluetoothGATTService.h',
      'bluetooth/BluetoothGATTService.cpp',
      'bluetooth/BluetoothGATTRemoteServer.h',
      'bluetooth/BluetoothGATTRemoteServer.cpp',
      'bluetooth/BluetoothUUID.cpp',
      'bluetooth/BluetoothUUID.h',
      'bluetooth/NavigatorBluetooth.cpp',
      'bluetooth/NavigatorBluetooth.h',
      'cachestorage/Cache.cpp',
      'cachestorage/Cache.h',
      'cachestorage/CacheStorage.cpp',
      'cachestorage/CacheStorage.h',
      'cachestorage/CacheStorageError.cpp',
      'cachestorage/CacheStorageError.h',
      'cachestorage/GlobalCacheStorage.cpp',
      'cachestorage/GlobalCacheStorage.h',
      'cachestorage/InspectorCacheStorageAgent.cpp',
      'cachestorage/InspectorCacheStorageAgent.h',
      'canvas2d/CanvasGradient.cpp',
      'canvas2d/CanvasGradient.h',
      'canvas2d/CanvasPathMethods.cpp',
      'canvas2d/CanvasPathMethods.h',
      'canvas2d/CanvasPattern.cpp',
      'canvas2d/CanvasPattern.h',
      'canvas2d/CanvasRenderingContext2D.cpp',
      'canvas2d/CanvasRenderingContext2D.h',
      'canvas2d/CanvasRenderingContext2DState.cpp',
      'canvas2d/CanvasRenderingContext2DState.h',
      'canvas2d/CanvasStyle.cpp',
      'canvas2d/CanvasStyle.h',
      'canvas2d/ClipList.cpp',
      'canvas2d/ClipList.h',
      'canvas2d/ContextAttributeHelpers.cpp',
      'canvas2d/ContextAttributeHelpers.h',
      'canvas2d/HitRegion.cpp',
      'canvas2d/HitRegion.h',
      'canvas2d/MouseEventHitRegion.h',
      'canvas2d/Path2D.h',
      'compositorworker/CompositorWorker.cpp',
      'compositorworker/CompositorWorker.h',
      'compositorworker/CompositorWorkerGlobalScope.cpp',
      'compositorworker/CompositorWorkerGlobalScope.h',
      'compositorworker/CompositorWorkerManager.cpp',
      'compositorworker/CompositorWorkerManager.h',
      'compositorworker/CompositorWorkerMessagingProxy.cpp',
      'compositorworker/CompositorWorkerMessagingProxy.h',
      'compositorworker/CompositorWorkerThread.cpp',
      'compositorworker/CompositorWorkerThread.h',
      'credentialmanager/Credential.cpp',
      'credentialmanager/Credential.h',
      'credentialmanager/CredentialManagerClient.cpp',
      'credentialmanager/CredentialManagerClient.h',
      'credentialmanager/CredentialsContainer.cpp',
      'credentialmanager/CredentialsContainer.h',
      'credentialmanager/FederatedCredential.cpp',
      'credentialmanager/FederatedCredential.h',
      'credentialmanager/PasswordCredential.cpp',
      'credentialmanager/PasswordCredential.h',
      'credentialmanager/NavigatorCredentials.cpp',
      'credentialmanager/NavigatorCredentials.h',
      'crypto/Crypto.cpp',
      'crypto/Crypto.h',
      'crypto/CryptoHistograms.cpp',
      'crypto/CryptoHistograms.h',
      'crypto/CryptoKey.cpp',
      'crypto/CryptoKey.h',
      'crypto/CryptoResultImpl.cpp',
      'crypto/CryptoResultImpl.h',
      'crypto/DOMWindowCrypto.cpp',
      'crypto/DOMWindowCrypto.h',
      'crypto/NormalizeAlgorithm.cpp',
      'crypto/NormalizeAlgorithm.h',
      'crypto/SubtleCrypto.cpp',
      'crypto/SubtleCrypto.h',
      'crypto/WorkerGlobalScopeCrypto.cpp',
      'crypto/WorkerGlobalScopeCrypto.h',
      'device_light/DeviceLightController.cpp',
      'device_light/DeviceLightController.h',
      'device_light/DeviceLightDispatcher.cpp',
      'device_light/DeviceLightDispatcher.h',
      'device_light/DeviceLightEvent.cpp',
      'device_light/DeviceLightEvent.h',
      'device_orientation/DeviceAcceleration.cpp',
      'device_orientation/DeviceAcceleration.h',
      'device_orientation/DeviceMotionController.cpp',
      'device_orientation/DeviceMotionController.h',
      'device_orientation/DeviceMotionData.cpp',
      'device_orientation/DeviceMotionData.h',
      'device_orientation/DeviceMotionDispatcher.cpp',
      'device_orientation/DeviceMotionDispatcher.h',
      'device_orientation/DeviceMotionEvent.cpp',
      'device_orientation/DeviceMotionEvent.h',
      'device_orientation/DeviceOrientationController.cpp',
      'device_orientation/DeviceOrientationController.h',
      'device_orientation/DeviceOrientationData.cpp',
      'device_orientation/DeviceOrientationData.h',
      'device_orientation/DeviceOrientationDispatcher.cpp',
      'device_orientation/DeviceOrientationDispatcher.h',
      'device_orientation/DeviceOrientationEvent.cpp',
      'device_orientation/DeviceOrientationEvent.h',
      'device_orientation/DeviceOrientationInspectorAgent.cpp',
      'device_orientation/DeviceOrientationInspectorAgent.h',
      'device_orientation/DeviceRotationRate.cpp',
      'device_orientation/DeviceRotationRate.h',
      'donottrack/NavigatorDoNotTrack.cpp',
      'donottrack/NavigatorDoNotTrack.h',
      'encoding/Encoding.cpp',
      'encoding/Encoding.h',
      'encoding/TextDecoder.cpp',
      'encoding/TextDecoder.h',
      'encoding/TextEncoder.cpp',
      'encoding/TextEncoder.h',
      'encryptedmedia/ContentDecryptionModuleResultPromise.cpp',
      'encryptedmedia/ContentDecryptionModuleResultPromise.h',
      'encryptedmedia/EncryptedMediaUtils.cpp',
      'encryptedmedia/EncryptedMediaUtils.h',
      'encryptedmedia/HTMLMediaElementEncryptedMedia.cpp',
      'encryptedmedia/HTMLMediaElementEncryptedMedia.h',
      'encryptedmedia/MediaEncryptedEvent.cpp',
      'encryptedmedia/MediaEncryptedEvent.h',
      'encryptedmedia/MediaKeyMessageEvent.cpp',
      'encryptedmedia/MediaKeyMessageEvent.h',
      'encryptedmedia/MediaKeySession.cpp',
      'encryptedmedia/MediaKeySession.h',
      'encryptedmedia/MediaKeyStatusMap.cpp',
      'encryptedmedia/MediaKeyStatusMap.h',
      'encryptedmedia/MediaKeySystemAccess.cpp',
      'encryptedmedia/MediaKeySystemAccess.h',
      'encryptedmedia/MediaKeys.cpp',
      'encryptedmedia/MediaKeys.h',
      'encryptedmedia/MediaKeysClient.h',
      'encryptedmedia/MediaKeysController.cpp',
      'encryptedmedia/MediaKeysController.h',
      'encryptedmedia/NavigatorRequestMediaKeySystemAccess.cpp',
      'encryptedmedia/NavigatorRequestMediaKeySystemAccess.h',
      'encryptedmedia/SimpleContentDecryptionModuleResultPromise.cpp',
      'encryptedmedia/SimpleContentDecryptionModuleResultPromise.h',
      'fetch/CompositeDataConsumerHandle.cpp',
      'fetch/CompositeDataConsumerHandle.h',
      'fetch/DataConsumerHandleUtil.cpp',
      'fetch/DataConsumerHandleUtil.h',
      'fetch/Body.cpp',
      'fetch/Body.h',
      'fetch/BodyStreamBuffer.cpp',
      'fetch/BodyStreamBuffer.h',
      'fetch/DataConsumerTee.cpp',
      'fetch/DataConsumerTee.h',
      'fetch/FetchBlobDataConsumerHandle.cpp',
      'fetch/FetchBlobDataConsumerHandle.h',
      'fetch/FetchDataConsumerHandle.h',
      'fetch/FetchDataLoader.cpp',
      'fetch/FetchDataLoader.h',
      'fetch/FetchHeaderList.cpp',
      'fetch/FetchHeaderList.h',
      'fetch/FetchManager.cpp',
      'fetch/FetchManager.h',
      'fetch/FetchRequestData.cpp',
      'fetch/FetchRequestData.h',
      'fetch/FetchResponseData.cpp',
      'fetch/FetchResponseData.h',
      'fetch/GlobalFetch.cpp',
      'fetch/GlobalFetch.h',
      'fetch/Headers.cpp',
      'fetch/Headers.h',
      'fetch/Request.cpp',
      'fetch/Request.h',
      'fetch/RequestInit.cpp',
      'fetch/RequestInit.h',
      'fetch/Response.cpp',
      'fetch/Response.h',
      'fetch/ResponseInit.h',
      'filesystem/DOMFilePath.cpp',
      'filesystem/DOMFilePath.h',
      'filesystem/DOMFileSystem.cpp',
      'filesystem/DOMFileSystem.h',
      'filesystem/DOMFileSystemBase.cpp',
      'filesystem/DOMFileSystemBase.h',
      'filesystem/DOMFileSystemSync.cpp',
      'filesystem/DOMFileSystemSync.h',
      'filesystem/DOMWindowFileSystem.cpp',
      'filesystem/DOMWindowFileSystem.h',
      'filesystem/DataTransferItemFileSystem.cpp',
      'filesystem/DataTransferItemFileSystem.h',
      'filesystem/DevToolsHostFileSystem.cpp',
      'filesystem/DevToolsHostFileSystem.h',
      'filesystem/DirectoryEntry.cpp',
      'filesystem/DirectoryEntry.h',
      'filesystem/DirectoryEntrySync.cpp',
      'filesystem/DirectoryEntrySync.h',
      'filesystem/DirectoryReader.cpp',
      'filesystem/DirectoryReader.h',
      'filesystem/DirectoryReaderBase.h',
      'filesystem/DirectoryReaderSync.cpp',
      'filesystem/DirectoryReaderSync.h',
      'filesystem/DraggedIsolatedFileSystemImpl.cpp',
      'filesystem/DraggedIsolatedFileSystemImpl.h',
      'filesystem/EntriesCallback.h',
      'filesystem/Entry.cpp',
      'filesystem/Entry.h',
      'filesystem/EntryBase.cpp',
      'filesystem/EntryBase.h',
      'filesystem/EntryCallback.h',
      'filesystem/EntrySync.cpp',
      'filesystem/EntrySync.h',
      'filesystem/ErrorCallback.h',
      'filesystem/FileCallback.h',
      'filesystem/FileEntry.cpp',
      'filesystem/FileEntry.h',
      'filesystem/FileEntrySync.cpp',
      'filesystem/FileEntrySync.h',
      'filesystem/FileSystemCallback.h',
      'filesystem/FileSystemCallbacks.cpp',
      'filesystem/FileSystemCallbacks.h',
      'filesystem/FileSystemClient.h',
      'filesystem/FileWriter.cpp',
      'filesystem/FileWriter.h',
      'filesystem/FileWriterBase.cpp',
      'filesystem/FileWriterBase.h',
      'filesystem/FileWriterBaseCallback.h',
      'filesystem/FileWriterCallback.h',
      'filesystem/FileWriterSync.cpp',
      'filesystem/FileWriterSync.h',
      'filesystem/HTMLInputElementFileSystem.cpp',
      'filesystem/HTMLInputElementFileSystem.h',
      'filesystem/InspectorFileSystemAgent.cpp',
      'filesystem/InspectorFileSystemAgent.h',
      'filesystem/LocalFileSystem.cpp',
      'filesystem/LocalFileSystem.h',
      'filesystem/Metadata.h',
      'filesystem/MetadataCallback.h',
      'filesystem/SyncCallbackHelper.h',
      'filesystem/WorkerGlobalScopeFileSystem.cpp',
      'filesystem/WorkerGlobalScopeFileSystem.h',
      'gamepad/Gamepad.cpp',
      'gamepad/Gamepad.h',
      'gamepad/GamepadButton.cpp',
      'gamepad/GamepadButton.h',
      'gamepad/GamepadDispatcher.cpp',
      'gamepad/GamepadDispatcher.h',
      'gamepad/GamepadEvent.cpp',
      'gamepad/GamepadEvent.h',
      'gamepad/GamepadList.cpp',
      'gamepad/GamepadList.h',
      'gamepad/NavigatorGamepad.cpp',
      'gamepad/NavigatorGamepad.h',
      'geofencing/CircularGeofencingRegion.cpp',
      'geofencing/CircularGeofencingRegion.h',
      'geofencing/Geofencing.cpp',
      'geofencing/Geofencing.h',
      'geofencing/GeofencingError.cpp',
      'geofencing/GeofencingError.h',
      'geofencing/GeofencingEvent.cpp',
      'geofencing/GeofencingEvent.h',
      'geofencing/GeofencingRegion.h',
      'geofencing/ServiceWorkerGlobalScopeGeofencing.h',
      'geofencing/ServiceWorkerRegistrationGeofencing.cpp',
      'geofencing/ServiceWorkerRegistrationGeofencing.h',
      'geofencing/WorkerNavigatorGeofencing.cpp',
      'geofencing/WorkerNavigatorGeofencing.h',
      'geolocation/Coordinates.cpp',
      'geolocation/Geolocation.cpp',
      'geolocation/GeolocationController.cpp',
      'geolocation/GeoNotifier.cpp',
      'geolocation/GeoNotifier.h',
      'geolocation/GeolocationWatchers.cpp',
      'geolocation/GeolocationWatchers.h',
      'geolocation/NavigatorGeolocation.cpp',
      'geolocation/NavigatorGeolocation.h',
      'imagebitmap/WindowImageBitmapFactories.cpp',
      'imagebitmap/WindowImageBitmapFactories.h',
      'indexeddb/DOMWindowIndexedDatabase.cpp',
      'indexeddb/DOMWindowIndexedDatabase.h',
      'indexeddb/IDBAny.cpp',
      'indexeddb/IDBAny.h',
      'indexeddb/IDBCursor.cpp',
      'indexeddb/IDBCursor.h',
      'indexeddb/IDBCursorWithValue.cpp',
      'indexeddb/IDBCursorWithValue.h',
      'indexeddb/IDBDatabase.cpp',
      'indexeddb/IDBDatabase.h',
      'indexeddb/IDBDatabaseCallbacks.cpp',
      'indexeddb/IDBDatabaseCallbacks.h',
      'indexeddb/IDBEventDispatcher.cpp',
      'indexeddb/IDBEventDispatcher.h',
      'indexeddb/IDBFactory.cpp',
      'indexeddb/IDBFactory.h',
      'indexeddb/IDBHistograms.h',
      'indexeddb/IDBIndex.cpp',
      'indexeddb/IDBIndex.h',
      'indexeddb/IDBKey.cpp',
      'indexeddb/IDBKey.h',
      'indexeddb/IDBKeyPath.cpp',
      'indexeddb/IDBKeyPath.h',
      'indexeddb/IDBKeyRange.cpp',
      'indexeddb/IDBKeyRange.h',
      'indexeddb/IDBMetadata.cpp',
      'indexeddb/IDBMetadata.h',
      'indexeddb/IDBObjectStore.cpp',
      'indexeddb/IDBObjectStore.h',
      'indexeddb/IDBOpenDBRequest.cpp',
      'indexeddb/IDBOpenDBRequest.h',
      'indexeddb/IDBRequest.cpp',
      'indexeddb/IDBRequest.h',
      'indexeddb/IDBTracing.h',
      'indexeddb/IDBTransaction.cpp',
      'indexeddb/IDBTransaction.h',
      'indexeddb/IDBValue.cpp',
      'indexeddb/IDBValue.h',
      'indexeddb/IDBVersionChangeEvent.cpp',
      'indexeddb/IDBVersionChangeEvent.h',
      'indexeddb/IndexedDB.h',
      'indexeddb/IndexedDBClient.cpp',
      'indexeddb/IndexedDBClient.h',
      'indexeddb/InspectorIndexedDBAgent.cpp',
      'indexeddb/InspectorIndexedDBAgent.h',
      'indexeddb/WebIDBCallbacksImpl.cpp',
      'indexeddb/WebIDBCallbacksImpl.h',
      'indexeddb/WebIDBDatabaseCallbacksImpl.cpp',
      'indexeddb/WebIDBDatabaseCallbacksImpl.h',
      'indexeddb/WorkerGlobalScopeIndexedDatabase.cpp',
      'indexeddb/WorkerGlobalScopeIndexedDatabase.h',
      'mediasession/HTMLMediaElementMediaSession.cpp',
      'mediasession/HTMLMediaElementMediaSession.h',
      'mediasession/MediaSession.cpp',
      'mediasession/MediaSession.h',
      'mediasource/HTMLVideoElementMediaSource.cpp',
      'mediasource/HTMLVideoElementMediaSource.h',
      'mediasource/MediaSource.cpp',
      'mediasource/MediaSource.h',
      'mediasource/MediaSourceRegistry.cpp',
      'mediasource/MediaSourceRegistry.h',
      'mediasource/SourceBuffer.cpp',
      'mediasource/SourceBuffer.h',
      'mediasource/SourceBufferList.cpp',
      'mediasource/SourceBufferList.h',
      'mediasource/TrackDefault.cpp',
      'mediasource/TrackDefault.h',
      'mediasource/TrackDefaultList.cpp',
      'mediasource/TrackDefaultList.h',
      'mediasource/URLMediaSource.cpp',
      'mediasource/URLMediaSource.h',
      'mediasource/VideoPlaybackQuality.cpp',
      'mediasource/VideoPlaybackQuality.h',
      'mediastream/MediaConstraintsImpl.cpp',
      'mediastream/MediaConstraintsImpl.h',
      'mediastream/MediaDeviceInfo.cpp',
      'mediastream/MediaDeviceInfo.h',
      'mediastream/MediaDevices.cpp',
      'mediastream/MediaDevices.h',
      'mediastream/MediaDevicesRequest.cpp',
      'mediastream/MediaDevicesRequest.h',
      'mediastream/MediaStream.cpp',
      'mediastream/MediaStream.h',
      'mediastream/MediaStreamEvent.cpp',
      'mediastream/MediaStreamEvent.h',
      'mediastream/MediaStreamRegistry.cpp',
      'mediastream/MediaStreamRegistry.h',
      'mediastream/MediaStreamTrack.cpp',
      'mediastream/MediaStreamTrack.h',
      'mediastream/MediaStreamTrackEvent.cpp',
      'mediastream/MediaStreamTrackEvent.h',
      'mediastream/MediaStreamTrackSourcesCallback.h',
      'mediastream/MediaStreamTrackSourcesRequestImpl.cpp',
      'mediastream/MediaStreamTrackSourcesRequestImpl.h',
      'mediastream/NavigatorMediaStream.cpp',
      'mediastream/NavigatorMediaStream.h',
      'mediastream/NavigatorUserMedia.cpp',
      'mediastream/NavigatorUserMedia.h',
      'mediastream/NavigatorUserMediaError.cpp',
      'mediastream/NavigatorUserMediaError.h',
      'mediastream/NavigatorUserMediaErrorCallback.h',
      'mediastream/NavigatorUserMediaSuccessCallback.h',
      'mediastream/RTCDTMFSender.cpp',
      'mediastream/RTCDTMFSender.h',
      'mediastream/RTCDTMFToneChangeEvent.cpp',
      'mediastream/RTCDTMFToneChangeEvent.h',
      'mediastream/RTCDataChannel.cpp',
      'mediastream/RTCDataChannel.h',
      'mediastream/RTCDataChannelEvent.cpp',
      'mediastream/RTCDataChannelEvent.h',
      'mediastream/RTCErrorCallback.h',
      'mediastream/RTCIceCandidate.cpp',
      'mediastream/RTCIceCandidate.h',
      'mediastream/RTCIceCandidateEvent.cpp',
      'mediastream/RTCIceCandidateEvent.h',
      'mediastream/RTCPeerConnection.cpp',
      'mediastream/RTCPeerConnection.h',
      'mediastream/RTCSessionDescription.cpp',
      'mediastream/RTCSessionDescription.h',
      'mediastream/RTCSessionDescriptionCallback.h',
      'mediastream/RTCSessionDescriptionRequestImpl.cpp',
      'mediastream/RTCSessionDescriptionRequestImpl.h',
      'mediastream/RTCStatsReport.cpp',
      'mediastream/RTCStatsReport.h',
      'mediastream/RTCStatsRequestImpl.cpp',
      'mediastream/RTCStatsRequestImpl.h',
      'mediastream/RTCStatsResponse.cpp',
      'mediastream/RTCStatsResponse.h',
      'mediastream/RTCVoidRequestImpl.cpp',
      'mediastream/RTCVoidRequestImpl.h',
      'mediastream/SourceInfo.cpp',
      'mediastream/SourceInfo.h',
      'mediastream/URLMediaStream.cpp',
      'mediastream/URLMediaStream.h',
      'mediastream/UserMediaClient.h',
      'mediastream/UserMediaController.cpp',
      'mediastream/UserMediaController.h',
      'mediastream/UserMediaRequest.cpp',
      'mediastream/UserMediaRequest.h',
      'navigatorconnect/AcceptConnectionObserver.cpp',
      'navigatorconnect/AcceptConnectionObserver.h',
      'navigatorconnect/CrossOriginConnectEvent.cpp',
      'navigatorconnect/CrossOriginConnectEvent.h',
      'navigatorconnect/CrossOriginServiceWorkerClient.cpp',
      'navigatorconnect/CrossOriginServiceWorkerClient.h',
      'navigatorconnect/NavigatorServices.cpp',
      'navigatorconnect/NavigatorServices.h',
      'navigatorconnect/ServicePort.cpp',
      'navigatorconnect/ServicePort.h',
      'navigatorconnect/ServicePortCollection.cpp',
      'navigatorconnect/ServicePortCollection.h',
      'navigatorconnect/ServicePortConnectEvent.cpp',
      'navigatorconnect/ServicePortConnectEvent.h',
      'navigatorconnect/ServiceWorkerGlobalScopeNavigatorConnect.h',
      'navigatorconnect/WorkerNavigatorServices.cpp',
      'navigatorconnect/WorkerNavigatorServices.h',
      'navigatorcontentutils/NavigatorContentUtils.cpp',
      'navigatorcontentutils/NavigatorContentUtils.h',
      'navigatorcontentutils/NavigatorContentUtilsClient.h',
      'netinfo/NavigatorNetworkInformation.cpp',
      'netinfo/NavigatorNetworkInformation.h',
      'netinfo/NetworkInformation.cpp',
      'netinfo/NetworkInformation.h',
      'netinfo/WorkerNavigatorNetworkInformation.cpp',
      'netinfo/WorkerNavigatorNetworkInformation.h',
      'notifications/Notification.cpp',
      'notifications/Notification.h',
      'notifications/NotificationEvent.cpp',
      'notifications/NotificationEvent.h',
      'notifications/NotificationPermissionCallback.h',
      'notifications/NotificationPermissionClient.cpp',
      'notifications/NotificationPermissionClient.h',
      'notifications/ServiceWorkerGlobalScopeNotifications.h',
      'notifications/ServiceWorkerRegistrationNotifications.cpp',
      'notifications/ServiceWorkerRegistrationNotifications.h',
      'permissions/NavigatorPermissions.cpp',
      'permissions/NavigatorPermissions.h',
      'permissions/PermissionController.cpp',
      'permissions/PermissionController.h',
      'permissions/Permissions.cpp',
      'permissions/Permissions.h',
      'permissions/PermissionQueryCallback.cpp',
      'permissions/PermissionQueryCallback.h',
      'permissions/PermissionStatus.cpp',
      'permissions/PermissionStatus.h',
      'permissions/WorkerNavigatorPermissions.cpp',
      'permissions/WorkerNavigatorPermissions.h',
      'plugins/DOMMimeType.cpp',
      'plugins/DOMMimeType.h',
      'plugins/DOMMimeTypeArray.cpp',
      'plugins/DOMMimeTypeArray.h',
      'plugins/DOMPlugin.cpp',
      'plugins/DOMPlugin.h',
      'plugins/DOMPluginArray.cpp',
      'plugins/DOMPluginArray.h',
      'plugins/NavigatorPlugins.cpp',
      'plugins/NavigatorPlugins.h',
      'plugins/PluginOcclusionSupport.cpp',
      'plugins/PluginOcclusionSupport.h',
      'presentation/DefaultSessionStartEvent.cpp',
      'presentation/DefaultSessionStartEvent.h',
      'presentation/NavigatorPresentation.cpp',
      'presentation/NavigatorPresentation.h',
      'presentation/Presentation.cpp',
      'presentation/Presentation.h',
      'presentation/PresentationAvailability.cpp',
      'presentation/PresentationAvailability.h',
      'presentation/PresentationAvailabilityCallback.cpp',
      'presentation/PresentationAvailabilityCallback.h',
      'presentation/PresentationController.cpp',
      'presentation/PresentationController.h',
      'presentation/PresentationError.cpp',
      'presentation/PresentationError.h',
      'presentation/PresentationSession.cpp',
      'presentation/PresentationSession.h',
      'presentation/PresentationSessionClientCallbacks.cpp',
      'presentation/PresentationSessionClientCallbacks.h',
      'push_messaging/PushController.cpp',
      'push_messaging/PushController.h',
      'push_messaging/PushError.cpp',
      'push_messaging/PushError.h',
      'push_messaging/PushEvent.cpp',
      'push_messaging/PushEvent.h',
      'push_messaging/PushManager.cpp',
      'push_messaging/PushManager.h',
      'push_messaging/PushMessageData.cpp',
      'push_messaging/PushMessageData.h',
      'push_messaging/PushPermissionStatusCallbacks.cpp',
      'push_messaging/PushPermissionStatusCallbacks.h',
      'push_messaging/PushSubscription.cpp',
      'push_messaging/PushSubscription.h',
      'push_messaging/PushSubscriptionCallbacks.cpp',
      'push_messaging/PushSubscriptionCallbacks.h',
      'push_messaging/ServiceWorkerGlobalScopePush.h',
      'push_messaging/ServiceWorkerRegistrationPush.cpp',
      'push_messaging/ServiceWorkerRegistrationPush.h',
      'quota/DOMWindowQuota.cpp',
      'quota/DOMWindowQuota.h',
      'quota/DeprecatedStorageInfo.cpp',
      'quota/DeprecatedStorageInfo.h',
      'quota/DeprecatedStorageQuota.cpp',
      'quota/DeprecatedStorageQuota.h',
      'quota/DeprecatedStorageQuotaCallbacksImpl.cpp',
      'quota/DeprecatedStorageQuotaCallbacksImpl.h',
      'quota/NavigatorStorageQuota.cpp',
      'quota/NavigatorStorageQuota.h',
      'quota/StorageErrorCallback.cpp',
      'quota/StorageErrorCallback.h',
      'quota/StorageInfo.cpp',
      'quota/StorageInfo.h',
      'quota/StorageQuota.cpp',
      'quota/StorageQuota.h',
      'quota/StorageQuotaCallback.h',
      'quota/StorageQuotaCallbacksImpl.cpp',
      'quota/StorageQuotaCallbacksImpl.h',
      'quota/StorageQuotaClient.cpp',
      'quota/StorageQuotaClient.h',
      'quota/StorageUsageCallback.h',
      'quota/WorkerNavigatorStorageQuota.cpp',
      'quota/WorkerNavigatorStorageQuota.h',
      'screen_orientation/LockOrientationCallback.cpp',
      'screen_orientation/LockOrientationCallback.h',
      'screen_orientation/ScreenScreenOrientation.cpp',
      'screen_orientation/ScreenScreenOrientation.h',
      'screen_orientation/ScreenOrientation.cpp',
      'screen_orientation/ScreenOrientation.h',
      'screen_orientation/ScreenOrientationController.cpp',
      'screen_orientation/ScreenOrientationController.h',
      'screen_orientation/ScreenOrientationDispatcher.cpp',
      'screen_orientation/ScreenOrientationDispatcher.h',
      'screen_orientation/ScreenOrientationInspectorAgent.cpp',
      'screen_orientation/ScreenOrientationInspectorAgent.h',
      'serviceworkers/ExtendableEvent.cpp',
      'serviceworkers/ExtendableEvent.h',
      'serviceworkers/FetchEvent.cpp',
      'serviceworkers/FetchEvent.h',
      'serviceworkers/NavigatorServiceWorker.cpp',
      'serviceworkers/NavigatorServiceWorker.h',
      'serviceworkers/RespondWithObserver.cpp',
      'serviceworkers/RespondWithObserver.h',
      'serviceworkers/ServiceWorker.cpp',
      'serviceworkers/ServiceWorker.h',
      'serviceworkers/ServiceWorkerClient.cpp',
      'serviceworkers/ServiceWorkerClient.h',
      'serviceworkers/ServiceWorkerClients.cpp',
      'serviceworkers/ServiceWorkerClients.h',
      'serviceworkers/ServiceWorkerContainer.cpp',
      'serviceworkers/ServiceWorkerContainer.h',
      'serviceworkers/ServiceWorkerContainerClient.cpp',
      'serviceworkers/ServiceWorkerContainerClient.h',
      'serviceworkers/ServiceWorkerWindowClient.cpp',
      'serviceworkers/ServiceWorkerWindowClient.h',
      'serviceworkers/ServiceWorkerError.cpp',
      'serviceworkers/ServiceWorkerError.h',
      'serviceworkers/ServiceWorkerGlobalScope.cpp',
      'serviceworkers/ServiceWorkerGlobalScope.h',
      'serviceworkers/ServiceWorkerGlobalScopeClient.cpp',
      'serviceworkers/ServiceWorkerGlobalScopeClient.h',
      'serviceworkers/ServiceWorkerMessageEvent.cpp',
      'serviceworkers/ServiceWorkerMessageEvent.h',
      'serviceworkers/ServiceWorkerRegistration.cpp',
      'serviceworkers/ServiceWorkerRegistration.h',
      'serviceworkers/ServiceWorkerScriptCachedMetadataHandler.cpp',
      'serviceworkers/ServiceWorkerScriptCachedMetadataHandler.h',
      'serviceworkers/ServiceWorkerThread.cpp',
      'serviceworkers/ServiceWorkerThread.h',
      'serviceworkers/StashedMessagePort.cpp',
      'serviceworkers/StashedMessagePort.h',
      'serviceworkers/StashedPortCollection.cpp',
      'serviceworkers/StashedPortCollection.h',
      'serviceworkers/WaitUntilObserver.cpp',
      'speech/DOMWindowSpeechSynthesis.cpp',
      'speech/DOMWindowSpeechSynthesis.h',
      'speech/SpeechGrammar.cpp',
      'speech/SpeechGrammar.h',
      'speech/SpeechGrammarList.cpp',
      'speech/SpeechGrammarList.h',
      'speech/SpeechRecognition.cpp',
      'speech/SpeechRecognition.h',
      'speech/SpeechRecognitionAlternative.cpp',
      'speech/SpeechRecognitionAlternative.h',
      'speech/SpeechRecognitionClient.h',
      'speech/SpeechRecognitionController.cpp',
      'speech/SpeechRecognitionController.h',
      'speech/SpeechRecognitionError.cpp',
      'speech/SpeechRecognitionError.h',
      'speech/SpeechRecognitionEvent.cpp',
      'speech/SpeechRecognitionEvent.h',
      'speech/SpeechRecognitionResult.cpp',
      'speech/SpeechRecognitionResult.h',
      'speech/SpeechRecognitionResultList.cpp',
      'speech/SpeechRecognitionResultList.h',
      'speech/SpeechSynthesis.cpp',
      'speech/SpeechSynthesis.h',
      'speech/SpeechSynthesisEvent.cpp',
      'speech/SpeechSynthesisEvent.h',
      'speech/SpeechSynthesisUtterance.cpp',
      'speech/SpeechSynthesisUtterance.h',
      'speech/SpeechSynthesisVoice.cpp',
      'speech/SpeechSynthesisVoice.h',
      'storage/DOMWindowStorage.cpp',
      'storage/DOMWindowStorage.h',
      'storage/DOMWindowStorageController.cpp',
      'storage/DOMWindowStorageController.h',
      'storage/InspectorDOMStorageAgent.cpp',
      'storage/InspectorDOMStorageAgent.h',
      'storage/Storage.cpp',
      'storage/Storage.h',
      'storage/StorageArea.cpp',
      'storage/StorageArea.h',
      'storage/StorageEvent.cpp',
      'storage/StorageEvent.h',
      'storage/StorageNamespace.cpp',
      'storage/StorageNamespace.h',
      'storage/StorageNamespaceController.cpp',
      'storage/StorageNamespaceController.h',
      'vibration/NavigatorVibration.cpp',
      'vibration/NavigatorVibration.h',
      'vr/HMDVRDevice.cpp',
      'vr/HMDVRDevice.h',
      'vr/NavigatorVRDevice.cpp',
      'vr/NavigatorVRDevice.h',
      'vr/PositionSensorVRDevice.cpp',
      'vr/PositionSensorVRDevice.h',
      'vr/VRController.cpp',
      'vr/VRController.h',
      'vr/VRDevice.cpp',
      'vr/VRDevice.h',
      'vr/VREyeParameters.cpp',
      'vr/VREyeParameters.h',
      'vr/VRFieldOfView.h',
      'vr/VRGetDevicesCallback.cpp',
      'vr/VRGetDevicesCallback.h',
      'vr/VRHardwareUnit.cpp',
      'vr/VRHardwareUnit.h',
      'vr/VRHardwareUnitCollection.cpp',
      'vr/VRHardwareUnitCollection.h',
      'vr/VRPositionState.cpp',
      'vr/VRPositionState.h',
      'webaudio/AnalyserNode.cpp',
      'webaudio/AnalyserNode.h',
      'webaudio/AsyncAudioDecoder.cpp',
      'webaudio/AsyncAudioDecoder.h',
      'webaudio/AudioBasicInspectorNode.cpp',
      'webaudio/AudioBasicInspectorNode.h',
      'webaudio/AudioBasicProcessorHandler.cpp',
      'webaudio/AudioBasicProcessorHandler.h',
      'webaudio/AudioBuffer.cpp',
      'webaudio/AudioBuffer.h',
      'webaudio/AudioBufferCallback.h',
      'webaudio/AudioBufferSourceNode.cpp',
      'webaudio/AudioBufferSourceNode.h',
      'webaudio/AudioContext.cpp',
      'webaudio/AudioContext.h',
      'webaudio/AudioDestinationNode.cpp',
      'webaudio/AudioDestinationNode.h',
      'webaudio/AudioListener.cpp',
      'webaudio/AudioListener.h',
      'webaudio/AudioNode.cpp',
      'webaudio/AudioNode.h',
      'webaudio/AudioNodeInput.cpp',
      'webaudio/AudioNodeInput.h',
      'webaudio/AudioNodeOutput.cpp',
      'webaudio/AudioNodeOutput.h',
      'webaudio/AudioParam.cpp',
      'webaudio/AudioParam.h',
      'webaudio/AudioParamTimeline.cpp',
      'webaudio/AudioParamTimeline.h',
      'webaudio/AudioProcessingEvent.cpp',
      'webaudio/AudioProcessingEvent.h',
      'webaudio/AudioScheduledSourceNode.cpp',
      'webaudio/AudioScheduledSourceNode.h',
      'webaudio/AudioSourceNode.h',
      'webaudio/AudioSummingJunction.cpp',
      'webaudio/AudioSummingJunction.h',
      'webaudio/BiquadDSPKernel.cpp',
      'webaudio/BiquadDSPKernel.h',
      'webaudio/BiquadFilterNode.cpp',
      'webaudio/BiquadFilterNode.h',
      'webaudio/BiquadProcessor.cpp',
      'webaudio/BiquadProcessor.h',
      'webaudio/ChannelMergerNode.cpp',
      'webaudio/ChannelMergerNode.h',
      'webaudio/ChannelSplitterNode.cpp',
      'webaudio/ChannelSplitterNode.h',
      'webaudio/ConvolverNode.cpp',
      'webaudio/ConvolverNode.h',
      'webaudio/DefaultAudioDestinationNode.cpp',
      'webaudio/DefaultAudioDestinationNode.h',
      'webaudio/DeferredTaskHandler.cpp',
      'webaudio/DeferredTaskHandler.h',
      'webaudio/DelayDSPKernel.cpp',
      'webaudio/DelayDSPKernel.h',
      'webaudio/DelayNode.cpp',
      'webaudio/DelayNode.h',
      'webaudio/DelayProcessor.cpp',
      'webaudio/DelayProcessor.h',
      'webaudio/DynamicsCompressorNode.cpp',
      'webaudio/DynamicsCompressorNode.h',
      'webaudio/GainNode.cpp',
      'webaudio/GainNode.h',
      'webaudio/MediaElementAudioSourceNode.cpp',
      'webaudio/MediaElementAudioSourceNode.h',
      'webaudio/MediaStreamAudioDestinationNode.cpp',
      'webaudio/MediaStreamAudioDestinationNode.h',
      'webaudio/MediaStreamAudioSourceNode.cpp',
      'webaudio/MediaStreamAudioSourceNode.h',
      'webaudio/OfflineAudioCompletionEvent.cpp',
      'webaudio/OfflineAudioCompletionEvent.h',
      'webaudio/OfflineAudioContext.cpp',
      'webaudio/OfflineAudioContext.h',
      'webaudio/OfflineAudioDestinationNode.cpp',
      'webaudio/OfflineAudioDestinationNode.h',
      'webaudio/OscillatorNode.cpp',
      'webaudio/OscillatorNode.h',
      'webaudio/PannerNode.cpp',
      'webaudio/PannerNode.h',
      'webaudio/PeriodicWave.cpp',
      'webaudio/PeriodicWave.h',
      'webaudio/RealtimeAnalyser.cpp',
      'webaudio/RealtimeAnalyser.h',
      'webaudio/ScriptProcessorNode.cpp',
      'webaudio/ScriptProcessorNode.h',
      'webaudio/StereoPannerNode.cpp',
      'webaudio/StereoPannerNode.h',
      'webaudio/WaveShaperDSPKernel.cpp',
      'webaudio/WaveShaperDSPKernel.h',
      'webaudio/WaveShaperNode.cpp',
      'webaudio/WaveShaperNode.h',
      'webaudio/WaveShaperProcessor.cpp',
      'webaudio/WaveShaperProcessor.h',
      'webdatabase/ChangeVersionData.h',
      'webdatabase/ChangeVersionWrapper.cpp',
      'webdatabase/ChangeVersionWrapper.h',
      'webdatabase/DOMWindowWebDatabase.cpp',
      'webdatabase/DOMWindowWebDatabase.h',
      'webdatabase/Database.cpp',
      'webdatabase/Database.h',
      'webdatabase/DatabaseAuthorizer.cpp',
      'webdatabase/DatabaseAuthorizer.h',
      'webdatabase/DatabaseBasicTypes.h',
      'webdatabase/DatabaseCallback.h',
      'webdatabase/DatabaseClient.cpp',
      'webdatabase/DatabaseClient.h',
      'webdatabase/DatabaseContext.cpp',
      'webdatabase/DatabaseContext.h',
      'webdatabase/DatabaseError.h',
      'webdatabase/DatabaseManager.cpp',
      'webdatabase/DatabaseManager.h',
      'webdatabase/DatabaseTask.cpp',
      'webdatabase/DatabaseTask.h',
      'webdatabase/DatabaseThread.cpp',
      'webdatabase/DatabaseThread.h',
      'webdatabase/DatabaseTracker.cpp',
      'webdatabase/DatabaseTracker.h',
      'webdatabase/InspectorDatabaseAgent.cpp',
      'webdatabase/InspectorDatabaseAgent.h',
      'webdatabase/InspectorDatabaseResource.cpp',
      'webdatabase/InspectorDatabaseResource.h',
      'webdatabase/QuotaTracker.cpp',
      'webdatabase/QuotaTracker.h',
      'webdatabase/SQLError.cpp',
      'webdatabase/SQLError.h',
      'webdatabase/SQLResultSet.cpp',
      'webdatabase/SQLResultSetRowList.cpp',
      'webdatabase/SQLStatement.cpp',
      'webdatabase/SQLStatement.h',
      'webdatabase/SQLStatementBackend.cpp',
      'webdatabase/SQLStatementBackend.h',
      'webdatabase/SQLTransaction.cpp',
      'webdatabase/SQLTransaction.h',
      'webdatabase/SQLTransactionBackend.cpp',
      'webdatabase/SQLTransactionBackend.h',
      'webdatabase/SQLTransactionClient.cpp',
      'webdatabase/SQLTransactionClient.h',
      'webdatabase/SQLTransactionCoordinator.cpp',
      'webdatabase/SQLTransactionCoordinator.h',
      'webdatabase/SQLTransactionState.h',
      'webdatabase/SQLTransactionStateMachine.cpp',
      'webdatabase/SQLTransactionStateMachine.h',
      'webdatabase/sqlite/SQLValue.cpp',
      'webdatabase/sqlite/SQLiteAuthorizer.cpp',
      'webdatabase/sqlite/SQLiteDatabase.cpp',
      'webdatabase/sqlite/SQLiteDatabase.h',
      'webdatabase/sqlite/SQLiteFileSystem.cpp',
      'webdatabase/sqlite/SQLiteFileSystem.h',
      'webdatabase/sqlite/SQLiteFileSystemPosix.cpp',
      'webdatabase/sqlite/SQLiteFileSystemWin.cpp',
      'webdatabase/sqlite/SQLiteStatement.cpp',
      'webdatabase/sqlite/SQLiteStatement.h',
      'webdatabase/sqlite/SQLiteTransaction.cpp',
      'webdatabase/sqlite/SQLiteTransaction.h',
      'webgl/ANGLEInstancedArrays.cpp',
      'webgl/ANGLEInstancedArrays.h',
      'webgl/CHROMIUMSubscribeUniform.cpp',
      'webgl/CHROMIUMSubscribeUniform.h',
      'webgl/CHROMIUMValuebuffer.cpp',
      'webgl/CHROMIUMValuebuffer.h',
      'webgl/EXTBlendMinMax.cpp',
      'webgl/EXTBlendMinMax.h',
      'webgl/EXTFragDepth.cpp',
      'webgl/EXTFragDepth.h',
      'webgl/EXTShaderTextureLOD.cpp',
      'webgl/EXTShaderTextureLOD.h',
      'webgl/EXTTextureFilterAnisotropic.cpp',
      'webgl/EXTTextureFilterAnisotropic.h',
      'webgl/EXTsRGB.cpp',
      'webgl/EXTsRGB.h',
      'webgl/OESElementIndexUint.cpp',
      'webgl/OESElementIndexUint.h',
      'webgl/OESStandardDerivatives.cpp',
      'webgl/OESStandardDerivatives.h',
      'webgl/OESTextureFloat.cpp',
      'webgl/OESTextureFloat.h',
      'webgl/OESTextureFloatLinear.cpp',
      'webgl/OESTextureFloatLinear.h',
      'webgl/OESTextureHalfFloat.cpp',
      'webgl/OESTextureHalfFloat.h',
      'webgl/OESTextureHalfFloatLinear.cpp',
      'webgl/OESTextureHalfFloatLinear.h',
      'webgl/OESVertexArrayObject.cpp',
      'webgl/OESVertexArrayObject.h',
      'webgl/WebGL2RenderingContext.cpp',
      'webgl/WebGL2RenderingContext.h',
      'webgl/WebGL2RenderingContextBase.cpp',
      'webgl/WebGL2RenderingContextBase.h',
      'webgl/WebGLActiveInfo.h',
      'webgl/WebGLBuffer.cpp',
      'webgl/WebGLBuffer.h',
      'webgl/WebGLCompressedTextureATC.cpp',
      'webgl/WebGLCompressedTextureATC.h',
      'webgl/WebGLCompressedTextureETC1.cpp',
      'webgl/WebGLCompressedTextureETC1.h',
      'webgl/WebGLCompressedTexturePVRTC.cpp',
      'webgl/WebGLCompressedTexturePVRTC.h',
      'webgl/WebGLCompressedTextureS3TC.cpp',
      'webgl/WebGLCompressedTextureS3TC.h',
      'webgl/WebGLContextAttributeHelpers.cpp',
      'webgl/WebGLContextAttributeHelpers.h',
      'webgl/WebGLContextEvent.cpp',
      'webgl/WebGLContextEvent.h',
      'webgl/WebGLContextGroup.cpp',
      'webgl/WebGLContextGroup.h',
      'webgl/WebGLContextObject.cpp',
      'webgl/WebGLContextObject.h',
      'webgl/WebGLDebugRendererInfo.cpp',
      'webgl/WebGLDebugRendererInfo.h',
      'webgl/WebGLDebugShaders.cpp',
      'webgl/WebGLDebugShaders.h',
      'webgl/WebGLDepthTexture.cpp',
      'webgl/WebGLDepthTexture.h',
      'webgl/WebGLDrawBuffers.cpp',
      'webgl/WebGLDrawBuffers.h',
      'webgl/WebGLExtension.cpp',
      'webgl/WebGLExtension.h',
      'webgl/WebGLExtensionName.h',
      'webgl/WebGLFenceSync.cpp',
      'webgl/WebGLFenceSync.h',
      'webgl/WebGLFramebuffer.cpp',
      'webgl/WebGLFramebuffer.h',
      'webgl/WebGLLoseContext.cpp',
      'webgl/WebGLLoseContext.h',
      'webgl/WebGLObject.cpp',
      'webgl/WebGLObject.h',
      'webgl/WebGLProgram.cpp',
      'webgl/WebGLProgram.h',
      'webgl/WebGLQuery.cpp',
      'webgl/WebGLQuery.h',
      'webgl/WebGLRenderbuffer.cpp',
      'webgl/WebGLRenderbuffer.h',
      'webgl/WebGLRenderingContext.cpp',
      'webgl/WebGLRenderingContext.h',
      'webgl/WebGLRenderingContextBase.cpp',
      'webgl/WebGLRenderingContextBase.h',
      'webgl/WebGLSampler.cpp',
      'webgl/WebGLSampler.h',
      'webgl/WebGLShader.cpp',
      'webgl/WebGLShader.h',
      'webgl/WebGLShaderPrecisionFormat.cpp',
      'webgl/WebGLShaderPrecisionFormat.h',
      'webgl/WebGLSharedObject.cpp',
      'webgl/WebGLSharedObject.h',
      'webgl/WebGLSharedPlatform3DObject.cpp',
      'webgl/WebGLSharedPlatform3DObject.h',
      'webgl/WebGLSync.cpp',
      'webgl/WebGLSync.h',
      'webgl/WebGLTexture.cpp',
      'webgl/WebGLTexture.h',
      'webgl/WebGLTransformFeedback.cpp',
      'webgl/WebGLTransformFeedback.h',
      'webgl/WebGLUniformLocation.cpp',
      'webgl/WebGLUniformLocation.h',
      'webgl/WebGLVertexArrayObject.cpp',
      'webgl/WebGLVertexArrayObject.h',
      'webgl/WebGLVertexArrayObjectBase.cpp',
      'webgl/WebGLVertexArrayObjectBase.h',
      'webgl/WebGLVertexArrayObjectOES.cpp',
      'webgl/WebGLVertexArrayObjectOES.h',
      'webmidi/MIDIAccess.cpp',
      'webmidi/MIDIAccess.h',
      'webmidi/MIDIAccessInitializer.cpp',
      'webmidi/MIDIAccessInitializer.h',
      'webmidi/MIDIAccessor.cpp',
      'webmidi/MIDIAccessor.h',
      'webmidi/MIDIAccessorClient.h',
      'webmidi/MIDIClient.h',
      'webmidi/MIDIConnectionEvent.cpp',
      'webmidi/MIDIConnectionEvent.h',
      'webmidi/MIDIController.cpp',
      'webmidi/MIDIController.h',
      'webmidi/MIDIInput.cpp',
      'webmidi/MIDIInput.h',
      'webmidi/MIDIInputMap.cpp',
      'webmidi/MIDIInputMap.h',
      'webmidi/MIDIMessageEvent.cpp',
      'webmidi/MIDIMessageEvent.h',
      'webmidi/MIDIPortMap.h',
      'webmidi/MIDIOutput.cpp',
      'webmidi/MIDIOutput.h',
      'webmidi/MIDIOutputMap.cpp',
      'webmidi/MIDIOutputMap.h',
      'webmidi/MIDIPort.cpp',
      'webmidi/MIDIPort.h',
      'webmidi/NavigatorWebMIDI.cpp',
      'webmidi/NavigatorWebMIDI.h',
      'websockets/CloseEvent.cpp',
      'websockets/CloseEvent.h',
      'websockets/DOMWebSocket.cpp',
      'websockets/DOMWebSocket.h',
      'websockets/DocumentWebSocketChannel.cpp',
      'websockets/DocumentWebSocketChannel.h',
      'websockets/InspectorWebSocketEvents.cpp',
      'websockets/InspectorWebSocketEvents.h',
      'websockets/WebSocketChannel.cpp',
      'websockets/WebSocketChannel.h',
      'websockets/WebSocketChannelClient.h',
      'websockets/WebSocketFrame.cpp',
      'websockets/WebSocketFrame.h',
      'websockets/WorkerWebSocketChannel.cpp',
      'websockets/WorkerWebSocketChannel.h',
    ],
    # 'partial interface' or target (right side of) 'implements'
    'modules_testing_dependency_idl_files' : [
      'accessibility/testing/InternalsAccessibility.idl',
      'geolocation/testing/InternalsGeolocation.idl',
      'navigatorcontentutils/testing/InternalsNavigatorContentUtils.idl',
      'serviceworkers/testing/InternalsServiceWorker.idl',
      'speech/testing/InternalsSpeechSynthesis.idl',
      'vibration/testing/InternalsVibration.idl',
      'webaudio/testing/InternalsWebAudio.idl',
    ],
    'modules_testing_files': [
      'accessibility/testing/InternalsAccessibility.cpp',
      'accessibility/testing/InternalsAccessibility.h',
      'geolocation/testing/GeolocationClientMock.cpp',
      'geolocation/testing/GeolocationClientMock.h',
      'geolocation/testing/InternalsGeolocation.cpp',
      'geolocation/testing/InternalsGeolocation.h',
      'navigatorcontentutils/testing/InternalsNavigatorContentUtils.cpp',
      'navigatorcontentutils/testing/InternalsNavigatorContentUtils.h',
      'navigatorcontentutils/testing/NavigatorContentUtilsClientMock.cpp',
      'navigatorcontentutils/testing/NavigatorContentUtilsClientMock.h',
      'serviceworkers/testing/InternalsServiceWorker.cpp',
      'serviceworkers/testing/InternalsServiceWorker.h',
      'speech/testing/InternalsSpeechSynthesis.cpp',
      'speech/testing/InternalsSpeechSynthesis.h',
      'speech/testing/PlatformSpeechSynthesizerMock.cpp',
      'speech/testing/PlatformSpeechSynthesizerMock.h',
      'vibration/testing/InternalsVibration.cpp',
      'vibration/testing/InternalsVibration.h',
      'webaudio/testing/InternalsWebAudio.h',
      'webaudio/testing/InternalsWebAudio.cpp',
    ],
    'modules_unittest_files': [
      'accessibility/AXObjectTest.cpp',
      'cachestorage/CacheTest.cpp',
      'canvas2d/CanvasRenderingContext2DAPITest.cpp',
      'canvas2d/CanvasRenderingContext2DTest.cpp',
      'compositorworker/CompositorWorkerManagerTest.cpp',
      'fetch/BodyStreamBufferTest.cpp',
      'fetch/CompositeDataConsumerHandleTest.cpp',
      'fetch/DataConsumerHandleTestUtil.cpp',
      'fetch/DataConsumerHandleTestUtil.h',
      'fetch/DataConsumerHandleUtilTest.cpp',
      'fetch/DataConsumerTeeTest.cpp',
      'fetch/FetchDataLoaderTest.cpp',
      'fetch/FetchResponseDataTest.cpp',
      'fetch/RequestTest.cpp',
      'fetch/ResponseTest.cpp',
      'filesystem/DOMFileSystemBaseTest.cpp',
      'imagebitmap/ImageBitmapModuleTest.cpp',
      'indexeddb/IDBKeyPathTest.cpp',
      'indexeddb/IDBRequestTest.cpp',
      'indexeddb/IDBTransactionTest.cpp',
      'serviceworkers/ServiceWorkerContainerTest.cpp',
      'webaudio/AudioBasicProcessorHandlerTest.cpp',
      'webaudio/ConvolverNodeTest.cpp',
      'webaudio/DynamicsCompressorNodeTest.cpp',
      'webaudio/ScriptProcessorNodeTest.cpp',
      'webaudio/StereoPannerNodeTest.cpp',
      'websockets/DOMWebSocketTest.cpp',
      'websockets/DocumentWebSocketChannelTest.cpp',
    ],
  },
}
